;; gorilla-repl.fileformat = 1

;; **
;;; # Gorilla REPL
;;; 
;;; Welcome to gorilla :-)
;;; 
;;; Shift + enter evaluates code. Hit ctrl+g twice in quick succession or click the menu icon (upper-right corner) for more commands ...
;;; 
;;; It's a good habit to run each worksheet in its own namespace: feel free to use the declaration we've provided below if you'd like.
;; **

;; @@
(ns marmoset.notebook
  (:require [gorilla-repl.html :as gh]
            [marmoset.core :refer :all]
            [clojure.core.async :as async]))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; @@
(defsegment list-segment
  {:preamble ["react.js"]
   :optimizations :advanced
   :pretty-print false
   :externs ["react.js"]}
  (ns foo
    [:require marmoset.client
     [cljs.core.async :refer [<!]]
     [om.core :as om :include-macros true]
     [om.dom :as dom :include-macros true]]
    [:require-macros
     [cljs.core.async.macros :refer [go]]])
  (enable-console-print!)
  
  (def l (atom []))
  
  (go (loop []
        (when-let [m (<! (:in marmoset.client/chan))]
          (reset! l m)
          (recur))))
  
  (defn list-widget [data owner]
    (reify
      om/IRender
      (render [this]
              (apply dom/ul nil
                     (map (fn [l]
                            (dom/li nil (str l)))
                          data)))))
  
  (defn main []
    (marmoset.client/autoheight)
    (om/root list-widget
             l
             {:target (.item (.getElementsByTagName js/document "body") 0)}))
  
  (set! (.-onload js/window) main))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.notebook/list-segment</span>","value":"#'marmoset.notebook/list-segment"}
;; <=

;; @@
(def id (java.util.UUID/randomUUID))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.notebook/id</span>","value":"#'marmoset.notebook/id"}
;; <=

;; @@
(def ch (async/chan))
(register-chan! id ch)
;; @@
;; =>
;;; {"type":"list-like","open":"<span class='clj-map'>{</span>","close":"<span class='clj-map'>}</span>","separator":", ","items":[{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;e975d8e8-ac34-489f-9df8-d97f82d27ea7&quot;</span>","value":"\"e975d8e8-ac34-489f-9df8-d97f82d27ea7\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@13d57ac2&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@13d57ac2>"}],"value":"[\"e975d8e8-ac34-489f-9df8-d97f82d27ea7\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@13d57ac2>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;f73b5e66-353b-4e61-95ee-102a413751e1&quot;</span>","value":"\"f73b5e66-353b-4e61-95ee-102a413751e1\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75b378b1&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75b378b1>"}],"value":"[\"f73b5e66-353b-4e61-95ee-102a413751e1\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75b378b1>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;265ce875-c38e-4212-9ab9-63701b9b57f0&quot;</span>","value":"\"265ce875-c38e-4212-9ab9-63701b9b57f0\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@2bf294bb&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@2bf294bb>"}],"value":"[\"265ce875-c38e-4212-9ab9-63701b9b57f0\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@2bf294bb>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;61323cad-adfd-47e0-a488-69bcce3005ae&quot;</span>","value":"\"61323cad-adfd-47e0-a488-69bcce3005ae\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@189c5355&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@189c5355>"}],"value":"[\"61323cad-adfd-47e0-a488-69bcce3005ae\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@189c5355>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;cf8218e8-1df7-420a-af4f-0b727b119f58&quot;</span>","value":"\"cf8218e8-1df7-420a-af4f-0b727b119f58\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@4cbfefd7&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@4cbfefd7>"}],"value":"[\"cf8218e8-1df7-420a-af4f-0b727b119f58\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@4cbfefd7>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;7ff5a572-9427-4777-9b5e-16dccf8bab76&quot;</span>","value":"\"7ff5a572-9427-4777-9b5e-16dccf8bab76\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75bbc660&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75bbc660>"}],"value":"[\"7ff5a572-9427-4777-9b5e-16dccf8bab76\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75bbc660>]"},{"type":"list-like","open":"","close":"","separator":" ","items":[{"type":"html","content":"<span class='clj-string'>&quot;f005e629-7bbb-4726-848a-75fe11e5454d&quot;</span>","value":"\"f005e629-7bbb-4726-848a-75fe11e5454d\""},{"type":"html","content":"<span class='clj-unkown'>#&lt;ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@719e8fe8&gt;</span>","value":"#<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@719e8fe8>"}],"value":"[\"f005e629-7bbb-4726-848a-75fe11e5454d\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@719e8fe8>]"}],"value":"{\"e975d8e8-ac34-489f-9df8-d97f82d27ea7\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@13d57ac2>, \"f73b5e66-353b-4e61-95ee-102a413751e1\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75b378b1>, \"265ce875-c38e-4212-9ab9-63701b9b57f0\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@2bf294bb>, \"61323cad-adfd-47e0-a488-69bcce3005ae\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@189c5355>, \"cf8218e8-1df7-420a-af4f-0b727b119f58\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@4cbfefd7>, \"7ff5a572-9427-4777-9b5e-16dccf8bab76\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@75bbc660>, \"f005e629-7bbb-4726-848a-75fe11e5454d\" #<ManyToManyChannel clojure.core.async.impl.channels.ManyToManyChannel@719e8fe8>}"}
;; <=

;; @@
;(gh/html-view (list-segment id nil))
;; @@

;; @@
(def c (future (async/<!! ch)))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.notebook/c</span>","value":"#'marmoset.notebook/c"}
;; <=

;; @@
c
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-unkown'>#&lt;core$future_call$reify__6320@7060fed1: :pending&gt;</span>","value":"#<core$future_call$reify__6320@7060fed1: :pending>"}
;; <=

;; @@
(def c @c)
;; @@

;; @@
(future (doseq [i (range 20)] (async/put! (:out c) (range (rand-int 20))) (Thread/sleep 1000)))
;; @@
