(ns marmoset.client
      [:require cljs.reader
                sock.client])

(let [payload (cljs.reader/read-string js/marmoset-payload)]
  (def id (:id payload))
  (def env (:env payload))
  (def chan (sock.client/ws (str "ws://"
                                  (aget js/top "location" "host")
                                  "/marmoset-ws/"
                                  (str id)))))
(defn autoheight []
  (let [mo (new js/MutationObserver
             (fn []
                 (aset js/frameElement "height"
                       (aget js/document
                             "documentElement"
                             "offsetHeight"))))]
    (. mo (observe (aget js/document "body")
                   #js{:attributes true
                       :childList true
                       :characterData true
                       :subtree true}))
    mo))
