;; gorilla-repl.fileformat = 1

;; **
;;; # Gorilla visualisations for error codes.
;;; 
;;; Inline views for error codes are a huge help when correcting pages and viewing the changes made by correction algorithms.
;; **

;; @@
(ns error-codes.gorilla
  (:require [error-codes.core :as e]
            [gorilla-renderable.core :as render]
            [marmoset.core :as m]))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; @@
(def error-view-code
  '[(ns error-codes.visualized
      (:require [marmoset.client :as m]
                [om.core :as om :include-macros true]
                [error-codes.visualizer :as v])
      (:use-macros
        [dommy.macros :only [node sel sel1]]))
    (enable-console-print!)
    (defn start []
      (om/root v/page-view m/env
               {:target (sel1 :body)}))
    (set! (.-onload js/window) start)])

(defrecord ErrorCodeView [left right error-codes]
  render/Renderable
  (render [self]
          (let [id (java.util.UUID/randomUUID)
                opts {:preamble ["react.js"]}
                env  {:left left
                      :right right
                      :error-codes error-codes}
                code error-view-code
                html (m/cljs-html id env code opts)]
            {:type :html
             :value (pr-str self)
             :content html})))

(defn error-view [left right]
  (->ErrorCodeView left
                   right
                   (e/error-codes left right)))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;error-codes.gorilla/error-view</span>","value":"#'error-codes.gorilla/error-view"}
;; <=

;; @@
(error-view "hallo" "hollo")
;; @@
;; ->
;;; &quot;fs &quot; [[[1 1]]]
;;; &quot;fi &quot; ()
;;; &quot;ext &quot; ()
;;; &quot;extr &quot; () &quot;res&quot; ()
;;; &quot;fs &quot; [[[1 1]]]
;;; &quot;fi &quot; ()
;;; &quot;ext &quot; ()
;;; &quot;extr &quot; () &quot;res&quot; ()
;;; 
;; <-

;; @@
(m/cljs-view {:env {:left "a"
                    :right "b"
                    :error-codes [[[1 1] [0 0]]]}
              :opts {:preamble ["react.js"]}}
             (ns error-codes.visualized
               (:require [marmoset.client :as m]
                         [om.core :as om :include-macros true]
                         [error-codes.visualizer :as v])
               (:use-macros
                 [dommy.macros :only [node sel sel1]]))
             (enable-console-print!)
             (defn start []
               (om/root v/page-view m/env
                        {:target (sel1 :body)}))
             (set! (.-onload js/window) start))
;; @@
;; =>
;;; {"type":"html","value":"#marmoset.core.CljsView{:id #uuid \"c354590e-e4de-4a6d-af6d-43d54dafdd0f\", :env {:error-codes [[[1 1] [0 0]]], :right \"b\", :left \"a\"}, :opts {:preamble [\"react.js\"]}, :code [(ns error-codes.visualized (:require [marmoset.client :as m] [om.core :as om :include-macros true] [error-codes.visualizer :as v]) (:use-macros [dommy.macros :only [node sel sel1]])) (enable-console-print!) (defn start [] (om/root v/page-view m/env {:target (sel1 :body)})) (set! (.-onload js/window) start)]}","content":"<div style=\"position: relative; width: 100%; height: 0; padding-bottom: 56.25%;\"><iframe frameborder=\"0\" hspace=\"0\" id=\"c354590e-e4de-4a6d-af6d-43d54dafdd0f\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" seamless=\"seamless\" srcdoc=\"&lt;html&gt;&lt;head&gt;&lt;script type=&quot;text/javascript&quot;&gt;var marmoset_payload = &quot;{:id #uuid \\&quot;c354590e-e4de-4a6d-af6d-43d54dafdd0f\\&quot;, :env {:error-codes [[[1 1] [0 0]]], :right \\&quot;b\\&quot;, :left \\&quot;a\\&quot;}}&quot;;&lt;/script&gt;&lt;script type=&quot;text/javascript&quot;&gt;/**\n * React v0.9.0\n */\n!function(e){if(&quot;object&quot;==typeof exports)module.exports=e();else if(&quot;function&quot;==typeof define&amp;&amp;define.amd)define(e);else{var f;&quot;undefined&quot;!=typeof window?f=window:&quot;undefined&quot;!=typeof global?f=global:&quot;undefined&quot;!=typeof self&amp;&amp;(f=self),f.React=e()}}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require==&quot;function&quot;&amp;&amp;require;if(!u&amp;&amp;a)return a(o,!0);if(i)return i(o,!0);throw new Error(&quot;Cannot find module &apos;&quot;+o+&quot;&apos;&quot;)}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require==&quot;function&quot;&amp;&amp;require;for(var o=0;o&lt;r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule AutoFocusMixin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = {\n  componentDidMount: function() {\n    if (this.props.autoFocus) {\n      this.getDOMNode().focus();\n    }\n  }\n};\n\nmodule.exports = AutoFocusMixin;\n\n},{}],2:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CSSProperty\n */\n\n&quot;use strict&quot;;\n\n/**\n * CSS properties which accept numbers but are not in units of &quot;px&quot;.\n */\nvar isUnitlessNumber = {\n  columnCount: true,\n  fillOpacity: true,\n  flex: true,\n  flexGrow: true,\n  flexShrink: true,\n  fontWeight: true,\n  lineClamp: true,\n  lineHeight: true,\n  opacity: true,\n  order: true,\n  orphans: true,\n  widows: true,\n  zIndex: true,\n  zoom: true\n};\n\n/**\n * @param {string} prefix vendor-specific prefix, eg: Webkit\n * @param {string} key style name, eg: transitionDuration\n * @return {string} style name prefixed with `prefix`, properly camelCased, eg:\n * WebkitTransitionDuration\n */\nfunction prefixKey(prefix, key) {\n  return prefix + key.charAt(0).toUpperCase() + key.substring(1);\n}\n\n/**\n * Support style names that may come passed in prefixed by adding permutations\n * of vendor prefixes.\n */\nvar prefixes = [&apos;Webkit&apos;, &apos;ms&apos;, &apos;Moz&apos;, &apos;O&apos;];\n\n// Using Object.keys here, or else the vanilla for-in loop makes IE8 go into an\n// infinite loop, because it iterates over the newly added props too.\nObject.keys(isUnitlessNumber).forEach(function(prop) {\n  prefixes.forEach(function(prefix) {\n    isUnitlessNumber[prefixKey(prefix, prop)] = isUnitlessNumber[prop];\n  });\n});\n\n/**\n * Most style properties can be unset by doing .style[prop] = &apos;&apos; but IE8\n * doesn&apos;t like doing that with shorthand properties so for the properties that\n * IE8 breaks on, which are listed here, we instead unset each of the\n * individual properties. See http://bugs.jquery.com/ticket/12385.\n * The 4-value &apos;clock&apos; properties like margin, padding, border-width seem to\n * behave without any problems. Curiously, list-style works too without any\n * special prodding.\n */\nvar shorthandPropertyExpansions = {\n  background: {\n    backgroundImage: true,\n    backgroundPosition: true,\n    backgroundRepeat: true,\n    backgroundColor: true\n  },\n  border: {\n    borderWidth: true,\n    borderStyle: true,\n    borderColor: true\n  },\n  borderBottom: {\n    borderBottomWidth: true,\n    borderBottomStyle: true,\n    borderBottomColor: true\n  },\n  borderLeft: {\n    borderLeftWidth: true,\n    borderLeftStyle: true,\n    borderLeftColor: true\n  },\n  borderRight: {\n    borderRightWidth: true,\n    borderRightStyle: true,\n    borderRightColor: true\n  },\n  borderTop: {\n    borderTopWidth: true,\n    borderTopStyle: true,\n    borderTopColor: true\n  },\n  font: {\n    fontStyle: true,\n    fontVariant: true,\n    fontWeight: true,\n    fontSize: true,\n    lineHeight: true,\n    fontFamily: true\n  }\n};\n\nvar CSSProperty = {\n  isUnitlessNumber: isUnitlessNumber,\n  shorthandPropertyExpansions: shorthandPropertyExpansions\n};\n\nmodule.exports = CSSProperty;\n\n},{}],3:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CSSPropertyOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSProperty = require(&quot;./CSSProperty&quot;);\n\nvar dangerousStyleValue = require(&quot;./dangerousStyleValue&quot;);\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar hyphenate = require(&quot;./hyphenate&quot;);\nvar memoizeStringOnly = require(&quot;./memoizeStringOnly&quot;);\n\nvar processStyleName = memoizeStringOnly(function(styleName) {\n  return escapeTextForBrowser(hyphenate(styleName));\n});\n\n/**\n * Operations for dealing with CSS properties.\n */\nvar CSSPropertyOperations = {\n\n  /**\n   * Serializes a mapping of style properties for use as inline styles:\n   *\n   *   &gt; createMarkupForStyles({width: &apos;200px&apos;, height: 0})\n   *   &quot;width:200px;height:0;&quot;\n   *\n   * Undefined values are ignored so that declarative programming is easier.\n   *\n   * @param {object} styles\n   * @return {?string}\n   */\n  createMarkupForStyles: function(styles) {\n    var serialized = &apos;&apos;;\n    for (var styleName in styles) {\n      if (!styles.hasOwnProperty(styleName)) {\n        continue;\n      }\n      var styleValue = styles[styleName];\n      if (styleValue != null) {\n        serialized += processStyleName(styleName) + &apos;:&apos;;\n        serialized += dangerousStyleValue(styleName, styleValue) + &apos;;&apos;;\n      }\n    }\n    return serialized || null;\n  },\n\n  /**\n   * Sets the value for multiple styles on a node.  If a value is specified as\n   * &apos;&apos; (empty string), the corresponding style property will be unset.\n   *\n   * @param {DOMElement} node\n   * @param {object} styles\n   */\n  setValueForStyles: function(node, styles) {\n    var style = node.style;\n    for (var styleName in styles) {\n      if (!styles.hasOwnProperty(styleName)) {\n        continue;\n      }\n      var styleValue = dangerousStyleValue(styleName, styles[styleName]);\n      if (styleValue) {\n        style[styleName] = styleValue;\n      } else {\n        var expansion = CSSProperty.shorthandPropertyExpansions[styleName];\n        if (expansion) {\n          // Shorthand property that IE8 won&apos;t like unsetting, so unset each\n          // component to placate it\n          for (var individualStyleName in expansion) {\n            style[individualStyleName] = &apos;&apos;;\n          }\n        } else {\n          style[styleName] = &apos;&apos;;\n        }\n      }\n    }\n  }\n\n};\n\nmodule.exports = CSSPropertyOperations;\n\n},{&quot;./CSSProperty&quot;:2,&quot;./dangerousStyleValue&quot;:94,&quot;./escapeTextForBrowser&quot;:96,&quot;./hyphenate&quot;:107,&quot;./memoizeStringOnly&quot;:116}],4:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ChangeEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\nvar isTextInputElement = require(&quot;./isTextInputElement&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  change: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onChange: null}),\n      captured: keyOf({onChangeCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topChange,\n      topLevelTypes.topClick,\n      topLevelTypes.topFocus,\n      topLevelTypes.topInput,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topSelectionChange\n    ]\n  }\n};\n\n/**\n * For IE shims\n */\nvar activeElement = null;\nvar activeElementID = null;\nvar activeElementValue = null;\nvar activeElementValueProp = null;\n\n/**\n * SECTION: handle `change` event\n */\nfunction shouldUseChangeEvent(elem) {\n  return (\n    elem.nodeName === &apos;SELECT&apos; ||\n    (elem.nodeName === &apos;INPUT&apos; &amp;&amp; elem.type === &apos;file&apos;)\n  );\n}\n\nvar doesChangeEventBubble = false;\nif (ExecutionEnvironment.canUseDOM) {\n  // See `handleChange` comment below\n  doesChangeEventBubble = isEventSupported(&apos;change&apos;) &amp;&amp; (\n    !(&apos;documentMode&apos; in document) || document.documentMode &gt; 8\n  );\n}\n\nfunction manualDispatchChangeEvent(nativeEvent) {\n  var event = SyntheticEvent.getPooled(\n    eventTypes.change,\n    activeElementID,\n    nativeEvent\n  );\n  EventPropagators.accumulateTwoPhaseDispatches(event);\n\n  // If change and propertychange bubbled, we&apos;d just bind to it like all the\n  // other events and have it go through ReactEventTopLevelCallback. Since it\n  // doesn&apos;t, we manually listen for the events and so we have to enqueue and\n  // process the abstract event manually.\n  //\n  // Batching is necessary here in order to ensure that all event handlers run\n  // before the next rerender (including event handlers attached to ancestor\n  // elements instead of directly on the input). Without this, controlled\n  // components don&apos;t work properly in conjunction with event bubbling because\n  // the component is rerendered and the value reverted before all the event\n  // handlers can run. See https://github.com/facebook/react/issues/708.\n  ReactUpdates.batchedUpdates(runEventInBatch, event);\n}\n\nfunction runEventInBatch(event) {\n  EventPluginHub.enqueueEvents(event);\n  EventPluginHub.processEventQueue();\n}\n\nfunction startWatchingForChangeEventIE8(target, targetID) {\n  activeElement = target;\n  activeElementID = targetID;\n  activeElement.attachEvent(&apos;onchange&apos;, manualDispatchChangeEvent);\n}\n\nfunction stopWatchingForChangeEventIE8() {\n  if (!activeElement) {\n    return;\n  }\n  activeElement.detachEvent(&apos;onchange&apos;, manualDispatchChangeEvent);\n  activeElement = null;\n  activeElementID = null;\n}\n\nfunction getTargetIDForChangeEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topChange) {\n    return topLevelTargetID;\n  }\n}\nfunction handleEventsForChangeEventIE8(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topFocus) {\n    // stopWatching() should be a noop here but we call it just in case we\n    // missed a blur event somehow.\n    stopWatchingForChangeEventIE8();\n    startWatchingForChangeEventIE8(topLevelTarget, topLevelTargetID);\n  } else if (topLevelType === topLevelTypes.topBlur) {\n    stopWatchingForChangeEventIE8();\n  }\n}\n\n\n/**\n * SECTION: handle `input` event\n */\nvar isInputEventSupported = false;\nif (ExecutionEnvironment.canUseDOM) {\n  // IE9 claims to support the input event but fails to trigger it when\n  // deleting text, so we ignore its input events\n  isInputEventSupported = isEventSupported(&apos;input&apos;) &amp;&amp; (\n    !(&apos;documentMode&apos; in document) || document.documentMode &gt; 9\n  );\n}\n\n/**\n * (For old IE.) Replacement getter/setter for the `value` property that gets\n * set on the active element.\n */\nvar newValueProp =  {\n  get: function() {\n    return activeElementValueProp.get.call(this);\n  },\n  set: function(val) {\n    // Cast to a string so we can do equality checks.\n    activeElementValue = &apos;&apos; + val;\n    activeElementValueProp.set.call(this, val);\n  }\n};\n\n/**\n * (For old IE.) Starts tracking propertychange events on the passed-in element\n * and override the value property so that we can distinguish user events from\n * value changes in JS.\n */\nfunction startWatchingForValueChange(target, targetID) {\n  activeElement = target;\n  activeElementID = targetID;\n  activeElementValue = target.value;\n  activeElementValueProp = Object.getOwnPropertyDescriptor(\n    target.constructor.prototype,\n    &apos;value&apos;\n  );\n\n  Object.defineProperty(activeElement, &apos;value&apos;, newValueProp);\n  activeElement.attachEvent(&apos;onpropertychange&apos;, handlePropertyChange);\n}\n\n/**\n * (For old IE.) Removes the event listeners from the currently-tracked element,\n * if any exists.\n */\nfunction stopWatchingForValueChange() {\n  if (!activeElement) {\n    return;\n  }\n\n  // delete restores the original property definition\n  delete activeElement.value;\n  activeElement.detachEvent(&apos;onpropertychange&apos;, handlePropertyChange);\n\n  activeElement = null;\n  activeElementID = null;\n  activeElementValue = null;\n  activeElementValueProp = null;\n}\n\n/**\n * (For old IE.) Handles a propertychange event, sending a `change` event if\n * the value of the active element has changed.\n */\nfunction handlePropertyChange(nativeEvent) {\n  if (nativeEvent.propertyName !== &apos;value&apos;) {\n    return;\n  }\n  var value = nativeEvent.srcElement.value;\n  if (value === activeElementValue) {\n    return;\n  }\n  activeElementValue = value;\n\n  manualDispatchChangeEvent(nativeEvent);\n}\n\n/**\n * If a `change` event should be fired, returns the target&apos;s ID.\n */\nfunction getTargetIDForInputEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topInput) {\n    // In modern browsers (i.e., not IE8 or IE9), the input event is exactly\n    // what we want so fall through here and trigger an abstract event\n    return topLevelTargetID;\n  }\n}\n\n// For IE8 and IE9.\nfunction handleEventsForInputEventIE(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topFocus) {\n    // In IE8, we can capture almost all .value changes by adding a\n    // propertychange handler and looking for events with propertyName\n    // equal to &apos;value&apos;\n    // In IE9, propertychange fires for most input events but is buggy and\n    // doesn&apos;t fire when text is deleted, but conveniently, selectionchange\n    // appears to fire in all of the remaining cases so we catch those and\n    // forward the event if the value has changed\n    // In either case, we don&apos;t want to call the event handler if the value\n    // is changed from JS so we redefine a setter for `.value` that updates\n    // our activeElementValue variable, allowing us to ignore those changes\n    //\n    // stopWatching() should be a noop here but we call it just in case we\n    // missed a blur event somehow.\n    stopWatchingForValueChange();\n    startWatchingForValueChange(topLevelTarget, topLevelTargetID);\n  } else if (topLevelType === topLevelTypes.topBlur) {\n    stopWatchingForValueChange();\n  }\n}\n\n// For IE8 and IE9.\nfunction getTargetIDForInputEventIE(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topSelectionChange ||\n      topLevelType === topLevelTypes.topKeyUp ||\n      topLevelType === topLevelTypes.topKeyDown) {\n    // On the selectionchange event, the target is just document which isn&apos;t\n    // helpful for us so just check activeElement instead.\n    //\n    // 99% of the time, keydown and keyup aren&apos;t necessary. IE8 fails to fire\n    // propertychange on the first input event after setting `value` from a\n    // script and fires only keydown, keypress, keyup. Catching keyup usually\n    // gets it and catching keydown lets us fire an event for the first\n    // keystroke if user does a key repeat (it&apos;ll be a little delayed: right\n    // before the second keystroke). Other input methods (e.g., paste) seem to\n    // fire selectionchange normally.\n    if (activeElement &amp;&amp; activeElement.value !== activeElementValue) {\n      activeElementValue = activeElement.value;\n      return activeElementID;\n    }\n  }\n}\n\n\n/**\n * SECTION: handle `click` event\n */\nfunction shouldUseClickEvent(elem) {\n  // Use the `click` event to detect changes to checkbox and radio inputs.\n  // This approach works across all browsers, whereas `change` does not fire\n  // until `blur` in IE8.\n  return (\n    elem.nodeName === &apos;INPUT&apos; &amp;&amp;\n    (elem.type === &apos;checkbox&apos; || elem.type === &apos;radio&apos;)\n  );\n}\n\nfunction getTargetIDForClickEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topClick) {\n    return topLevelTargetID;\n  }\n}\n\n/**\n * This plugin creates an `onChange` event that normalizes change events\n * across form elements. This event fires at a time when it&apos;s possible to\n * change the element&apos;s value without seeing a flicker.\n *\n * Supported elements are:\n * - input (see `isTextInputElement`)\n * - textarea\n * - select\n */\nvar ChangeEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    var getTargetIDFunc, handleEventFunc;\n    if (shouldUseChangeEvent(topLevelTarget)) {\n      if (doesChangeEventBubble) {\n        getTargetIDFunc = getTargetIDForChangeEvent;\n      } else {\n        handleEventFunc = handleEventsForChangeEventIE8;\n      }\n    } else if (isTextInputElement(topLevelTarget)) {\n      if (isInputEventSupported) {\n        getTargetIDFunc = getTargetIDForInputEvent;\n      } else {\n        getTargetIDFunc = getTargetIDForInputEventIE;\n        handleEventFunc = handleEventsForInputEventIE;\n      }\n    } else if (shouldUseClickEvent(topLevelTarget)) {\n      getTargetIDFunc = getTargetIDForClickEvent;\n    }\n\n    if (getTargetIDFunc) {\n      var targetID = getTargetIDFunc(\n        topLevelType,\n        topLevelTarget,\n        topLevelTargetID\n      );\n      if (targetID) {\n        var event = SyntheticEvent.getPooled(\n          eventTypes.change,\n          targetID,\n          nativeEvent\n        );\n        EventPropagators.accumulateTwoPhaseDispatches(event);\n        return event;\n      }\n    }\n\n    if (handleEventFunc) {\n      handleEventFunc(\n        topLevelType,\n        topLevelTarget,\n        topLevelTargetID\n      );\n    }\n  }\n\n};\n\nmodule.exports = ChangeEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginHub&quot;:16,&quot;./EventPropagators&quot;:19,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactUpdates&quot;:70,&quot;./SyntheticEvent&quot;:77,&quot;./isEventSupported&quot;:109,&quot;./isTextInputElement&quot;:111,&quot;./keyOf&quot;:115}],5:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ClientReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar nextReactRootIndex = 0;\n\nvar ClientReactRootIndex = {\n  createReactRootIndex: function() {\n    return nextReactRootIndex++;\n  }\n};\n\nmodule.exports = ClientReactRootIndex;\n\n},{}],6:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CompositionEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar SyntheticCompositionEvent = require(&quot;./SyntheticCompositionEvent&quot;);\n\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar END_KEYCODES = [9, 13, 27, 32]; // Tab, Return, Esc, Space\nvar START_KEYCODE = 229;\n\nvar useCompositionEvent = (\n  ExecutionEnvironment.canUseDOM &amp;&amp;\n  &apos;CompositionEvent&apos; in window\n);\n\n// In IE9+, we have access to composition events, but the data supplied\n// by the native compositionend event may be incorrect. In Korean, for example,\n// the compositionend event contains only one character regardless of\n// how many characters have been composed since compositionstart.\n// We therefore use the fallback data while still using the native\n// events as triggers.\nvar useFallbackData = (\n  !useCompositionEvent ||\n  &apos;documentMode&apos; in document &amp;&amp; document.documentMode &gt; 8\n);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\nvar currentComposition = null;\n\n// Events and their corresponding property names.\nvar eventTypes = {\n  compositionEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionEnd: null}),\n      captured: keyOf({onCompositionEndCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionEnd,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  },\n  compositionStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionStart: null}),\n      captured: keyOf({onCompositionStartCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionStart,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  },\n  compositionUpdate: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionUpdate: null}),\n      captured: keyOf({onCompositionUpdateCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionUpdate,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  }\n};\n\n/**\n * Translate native top level events into event types.\n *\n * @param {string} topLevelType\n * @return {object}\n */\nfunction getCompositionEventType(topLevelType) {\n  switch (topLevelType) {\n    case topLevelTypes.topCompositionStart:\n      return eventTypes.compositionStart;\n    case topLevelTypes.topCompositionEnd:\n      return eventTypes.compositionEnd;\n    case topLevelTypes.topCompositionUpdate:\n      return eventTypes.compositionUpdate;\n  }\n}\n\n/**\n * Does our fallback best-guess model think this event signifies that\n * composition has begun?\n *\n * @param {string} topLevelType\n * @param {object} nativeEvent\n * @return {boolean}\n */\nfunction isFallbackStart(topLevelType, nativeEvent) {\n  return (\n    topLevelType === topLevelTypes.topKeyDown &amp;&amp;\n    nativeEvent.keyCode === START_KEYCODE\n  );\n}\n\n/**\n * Does our fallback mode think that this event is the end of composition?\n *\n * @param {string} topLevelType\n * @param {object} nativeEvent\n * @return {boolean}\n */\nfunction isFallbackEnd(topLevelType, nativeEvent) {\n  switch (topLevelType) {\n    case topLevelTypes.topKeyUp:\n      // Command keys insert or clear IME input.\n      return (END_KEYCODES.indexOf(nativeEvent.keyCode) !== -1);\n    case topLevelTypes.topKeyDown:\n      // Expect IME keyCode on each keydown. If we get any other\n      // code we must have exited earlier.\n      return (nativeEvent.keyCode !== START_KEYCODE);\n    case topLevelTypes.topKeyPress:\n    case topLevelTypes.topMouseDown:\n    case topLevelTypes.topBlur:\n      // Events are not possible without cancelling IME.\n      return true;\n    default:\n      return false;\n  }\n}\n\n/**\n * Helper class stores information about selection and document state\n * so we can figure out what changed at a later date.\n *\n * @param {DOMEventTarget} root\n */\nfunction FallbackCompositionState(root) {\n  this.root = root;\n  this.startSelection = ReactInputSelection.getSelection(root);\n  this.startValue = this.getText();\n}\n\n/**\n * Get current text of input.\n *\n * @return {string}\n */\nFallbackCompositionState.prototype.getText = function() {\n  return this.root.value || this.root[getTextContentAccessor()];\n};\n\n/**\n * Text that has changed since the start of composition.\n *\n * @return {string}\n */\nFallbackCompositionState.prototype.getData = function() {\n  var endValue = this.getText();\n  var prefixLength = this.startSelection.start;\n  var suffixLength = this.startValue.length - this.startSelection.end;\n\n  return endValue.substr(\n    prefixLength,\n    endValue.length - suffixLength - prefixLength\n  );\n};\n\n/**\n * This plugin creates `onCompositionStart`, `onCompositionUpdate` and\n * `onCompositionEnd` events on inputs, textareas and contentEditable\n * nodes.\n */\nvar CompositionEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    var eventType;\n    var data;\n\n    if (useCompositionEvent) {\n      eventType = getCompositionEventType(topLevelType);\n    } else if (!currentComposition) {\n      if (isFallbackStart(topLevelType, nativeEvent)) {\n        eventType = eventTypes.compositionStart;\n      }\n    } else if (isFallbackEnd(topLevelType, nativeEvent)) {\n      eventType = eventTypes.compositionEnd;\n    }\n\n    if (useFallbackData) {\n      // The current composition is stored statically and must not be\n      // overwritten while composition continues.\n      if (!currentComposition &amp;&amp; eventType === eventTypes.compositionStart) {\n        currentComposition = new FallbackCompositionState(topLevelTarget);\n      } else if (eventType === eventTypes.compositionEnd) {\n        if (currentComposition) {\n          data = currentComposition.getData();\n          currentComposition = null;\n        }\n      }\n    }\n\n    if (eventType) {\n      var event = SyntheticCompositionEvent.getPooled(\n        eventType,\n        topLevelTargetID,\n        nativeEvent\n      );\n      if (data) {\n        // Inject data generated from fallback path into the synthetic event.\n        // This matches the property of native CompositionEventInterface.\n        event.data = data;\n      }\n      EventPropagators.accumulateTwoPhaseDispatches(event);\n      return event;\n    }\n  }\n};\n\nmodule.exports = CompositionEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactInputSelection&quot;:52,&quot;./SyntheticCompositionEvent&quot;:75,&quot;./getTextContentAccessor&quot;:105,&quot;./keyOf&quot;:115}],7:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMChildrenOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar Danger = require(&quot;./Danger&quot;);\nvar ReactMultiChildUpdateTypes = require(&quot;./ReactMultiChildUpdateTypes&quot;);\n\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\n\n/**\n * The DOM property to use when setting text content.\n *\n * @type {string}\n * @private\n */\nvar textContentAccessor = getTextContentAccessor();\n\n/**\n * Inserts `childNode` as a child of `parentNode` at the `index`.\n *\n * @param {DOMElement} parentNode Parent node in which to insert.\n * @param {DOMElement} childNode Child node to insert.\n * @param {number} index Index at which to insert the child.\n * @internal\n */\nfunction insertChildAt(parentNode, childNode, index) {\n  var childNodes = parentNode.childNodes;\n  if (childNodes[index] === childNode) {\n    return;\n  }\n  // If `childNode` is already a child of `parentNode`, remove it so that\n  // computing `childNodes[index]` takes into account the removal.\n  if (childNode.parentNode === parentNode) {\n    parentNode.removeChild(childNode);\n  }\n  if (index &gt;= childNodes.length) {\n    parentNode.appendChild(childNode);\n  } else {\n    parentNode.insertBefore(childNode, childNodes[index]);\n  }\n}\n\n/**\n * Sets the text content of `node` to `text`.\n *\n * @param {DOMElement} node Node to change\n * @param {string} text New text content\n */\nvar updateTextContent;\nif (textContentAccessor === &apos;textContent&apos;) {\n  updateTextContent = function(node, text) {\n    node.textContent = text;\n  };\n} else {\n  updateTextContent = function(node, text) {\n    // In order to preserve newlines correctly, we can&apos;t use .innerText to set\n    // the contents (see #1080), so we empty the element then append a text node\n    while (node.firstChild) {\n      node.removeChild(node.firstChild);\n    }\n    if (text) {\n      var doc = node.ownerDocument || document;\n      node.appendChild(doc.createTextNode(text));\n    }\n  };\n}\n\n/**\n * Operations for updating with DOM children.\n */\nvar DOMChildrenOperations = {\n\n  dangerouslyReplaceNodeWithMarkup: Danger.dangerouslyReplaceNodeWithMarkup,\n\n  updateTextContent: updateTextContent,\n\n  /**\n   * Updates a component&apos;s children by processing a series of updates. The\n   * update configurations are each expected to have a `parentNode` property.\n   *\n   * @param {array&lt;object&gt;} updates List of update configurations.\n   * @param {array&lt;string&gt;} markupList List of markup strings.\n   * @internal\n   */\n  processUpdates: function(updates, markupList) {\n    var update;\n    // Mapping from parent IDs to initial child orderings.\n    var initialChildren = null;\n    // List of children that will be moved or removed.\n    var updatedChildren = null;\n\n    for (var i = 0; update = updates[i]; i++) {\n      if (update.type === ReactMultiChildUpdateTypes.MOVE_EXISTING ||\n          update.type === ReactMultiChildUpdateTypes.REMOVE_NODE) {\n        var updatedIndex = update.fromIndex;\n        var updatedChild = update.parentNode.childNodes[updatedIndex];\n        var parentID = update.parentID;\n\n        initialChildren = initialChildren || {};\n        initialChildren[parentID] = initialChildren[parentID] || [];\n        initialChildren[parentID][updatedIndex] = updatedChild;\n\n        updatedChildren = updatedChildren || [];\n        updatedChildren.push(updatedChild);\n      }\n    }\n\n    var renderedMarkup = Danger.dangerouslyRenderMarkup(markupList);\n\n    // Remove updated children first so that `toIndex` is consistent.\n    if (updatedChildren) {\n      for (var j = 0; j &lt; updatedChildren.length; j++) {\n        updatedChildren[j].parentNode.removeChild(updatedChildren[j]);\n      }\n    }\n\n    for (var k = 0; update = updates[k]; k++) {\n      switch (update.type) {\n        case ReactMultiChildUpdateTypes.INSERT_MARKUP:\n          insertChildAt(\n            update.parentNode,\n            renderedMarkup[update.markupIndex],\n            update.toIndex\n          );\n          break;\n        case ReactMultiChildUpdateTypes.MOVE_EXISTING:\n          insertChildAt(\n            update.parentNode,\n            initialChildren[update.parentID][update.fromIndex],\n            update.toIndex\n          );\n          break;\n        case ReactMultiChildUpdateTypes.TEXT_CONTENT:\n          updateTextContent(\n            update.parentNode,\n            update.textContent\n          );\n          break;\n        case ReactMultiChildUpdateTypes.REMOVE_NODE:\n          // Already removed by the for-loop above.\n          break;\n      }\n    }\n  }\n\n};\n\nmodule.exports = DOMChildrenOperations;\n\n},{&quot;./Danger&quot;:10,&quot;./ReactMultiChildUpdateTypes&quot;:58,&quot;./getTextContentAccessor&quot;:105}],8:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMProperty\n * @typechecks static-only\n */\n\n/*jslint bitwise: true */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar DOMPropertyInjection = {\n  /**\n   * Mapping from normalized, camelcased property names to a configuration that\n   * specifies how the associated DOM property should be accessed or rendered.\n   */\n  MUST_USE_ATTRIBUTE: 0x1,\n  MUST_USE_PROPERTY: 0x2,\n  HAS_SIDE_EFFECTS: 0x4,\n  HAS_BOOLEAN_VALUE: 0x8,\n  HAS_POSITIVE_NUMERIC_VALUE: 0x10,\n\n  /**\n   * Inject some specialized knowledge about the DOM. This takes a config object\n   * with the following properties:\n   *\n   * isCustomAttribute: function that given an attribute name will return true\n   * if it can be inserted into the DOM verbatim. Useful for data-* or aria-*\n   * attributes where it&apos;s impossible to enumerate all of the possible\n   * attribute names,\n   *\n   * Properties: object mapping DOM property name to one of the\n   * DOMPropertyInjection constants or null. If your attribute isn&apos;t in here,\n   * it won&apos;t get written to the DOM.\n   *\n   * DOMAttributeNames: object mapping React attribute name to the DOM\n   * attribute name. Attribute names not specified use the **lowercase**\n   * normalized name.\n   *\n   * DOMPropertyNames: similar to DOMAttributeNames but for DOM properties.\n   * Property names not specified use the normalized name.\n   *\n   * DOMMutationMethods: Properties that require special mutation methods. If\n   * `value` is undefined, the mutation method should unset the property.\n   *\n   * @param {object} domPropertyConfig the config as described above.\n   */\n  injectDOMPropertyConfig: function(domPropertyConfig) {\n    var Properties = domPropertyConfig.Properties || {};\n    var DOMAttributeNames = domPropertyConfig.DOMAttributeNames || {};\n    var DOMPropertyNames = domPropertyConfig.DOMPropertyNames || {};\n    var DOMMutationMethods = domPropertyConfig.DOMMutationMethods || {};\n\n    if (domPropertyConfig.isCustomAttribute) {\n      DOMProperty._isCustomAttributeFunctions.push(\n        domPropertyConfig.isCustomAttribute\n      );\n    }\n\n    for (var propName in Properties) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.isStandardName[propName],\n        &apos;injectDOMPropertyConfig(...): You\\&apos;re trying to inject DOM property &apos; +\n        &apos;\\&apos;%s\\&apos; which has already been injected. You may be accidentally &apos; +\n        &apos;injecting the same DOM property config twice, or you may be &apos; +\n        &apos;injecting two configs that have conflicting property names.&apos;,\n        propName\n      ) : invariant(!DOMProperty.isStandardName[propName]));\n\n      DOMProperty.isStandardName[propName] = true;\n\n      var lowerCased = propName.toLowerCase();\n      DOMProperty.getPossibleStandardName[lowerCased] = propName;\n\n      var attributeName = DOMAttributeNames[propName];\n      if (attributeName) {\n        DOMProperty.getPossibleStandardName[attributeName] = propName;\n      }\n\n      DOMProperty.getAttributeName[propName] = attributeName || lowerCased;\n\n      DOMProperty.getPropertyName[propName] =\n        DOMPropertyNames[propName] || propName;\n\n      var mutationMethod = DOMMutationMethods[propName];\n      if (mutationMethod) {\n        DOMProperty.getMutationMethod[propName] = mutationMethod;\n      }\n\n      var propConfig = Properties[propName];\n      DOMProperty.mustUseAttribute[propName] =\n        propConfig &amp; DOMPropertyInjection.MUST_USE_ATTRIBUTE;\n      DOMProperty.mustUseProperty[propName] =\n        propConfig &amp; DOMPropertyInjection.MUST_USE_PROPERTY;\n      DOMProperty.hasSideEffects[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_SIDE_EFFECTS;\n      DOMProperty.hasBooleanValue[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_BOOLEAN_VALUE;\n      DOMProperty.hasPositiveNumericValue[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_POSITIVE_NUMERIC_VALUE;\n\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.mustUseAttribute[propName] ||\n          !DOMProperty.mustUseProperty[propName],\n        &apos;DOMProperty: Cannot require using both attribute and property: %s&apos;,\n        propName\n      ) : invariant(!DOMProperty.mustUseAttribute[propName] ||\n        !DOMProperty.mustUseProperty[propName]));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        DOMProperty.mustUseProperty[propName] ||\n          !DOMProperty.hasSideEffects[propName],\n        &apos;DOMProperty: Properties that have side effects must use property: %s&apos;,\n        propName\n      ) : invariant(DOMProperty.mustUseProperty[propName] ||\n        !DOMProperty.hasSideEffects[propName]));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.hasBooleanValue[propName] ||\n          !DOMProperty.hasPositiveNumericValue[propName],\n        &apos;DOMProperty: Cannot have both boolean and positive numeric value: %s&apos;,\n        propName\n      ) : invariant(!DOMProperty.hasBooleanValue[propName] ||\n        !DOMProperty.hasPositiveNumericValue[propName]));\n    }\n  }\n};\nvar defaultValueCache = {};\n\n/**\n * DOMProperty exports lookup objects that can be used like functions:\n *\n *   &gt; DOMProperty.isValid[&apos;id&apos;]\n *   true\n *   &gt; DOMProperty.isValid[&apos;foobar&apos;]\n *   undefined\n *\n * Although this may be confusing, it performs better in general.\n *\n * @see http://jsperf.com/key-exists\n * @see http://jsperf.com/key-missing\n */\nvar DOMProperty = {\n\n  ID_ATTRIBUTE_NAME: &apos;data-reactid&apos;,\n\n  /**\n   * Checks whether a property name is a standard property.\n   * @type {Object}\n   */\n  isStandardName: {},\n\n  /**\n   * Mapping from lowercase property names to the properly cased version, used\n   * to warn in the case of missing properties.\n   * @type {Object}\n   */\n  getPossibleStandardName: {},\n\n  /**\n   * Mapping from normalized names to attribute names that differ. Attribute\n   * names are used when rendering markup or with `*Attribute()`.\n   * @type {Object}\n   */\n  getAttributeName: {},\n\n  /**\n   * Mapping from normalized names to properties on DOM node instances.\n   * (This includes properties that mutate due to external factors.)\n   * @type {Object}\n   */\n  getPropertyName: {},\n\n  /**\n   * Mapping from normalized names to mutation methods. This will only exist if\n   * mutation cannot be set simply by the property or `setAttribute()`.\n   * @type {Object}\n   */\n  getMutationMethod: {},\n\n  /**\n   * Whether the property must be accessed and mutated as an object property.\n   * @type {Object}\n   */\n  mustUseAttribute: {},\n\n  /**\n   * Whether the property must be accessed and mutated using `*Attribute()`.\n   * (This includes anything that fails `&lt;propName&gt; in &lt;element&gt;`.)\n   * @type {Object}\n   */\n  mustUseProperty: {},\n\n  /**\n   * Whether or not setting a value causes side effects such as triggering\n   * resources to be loaded or text selection changes. We must ensure that\n   * the value is only set if it has changed.\n   * @type {Object}\n   */\n  hasSideEffects: {},\n\n  /**\n   * Whether the property should be removed when set to a falsey value.\n   * @type {Object}\n   */\n  hasBooleanValue: {},\n\n  /**\n   * Whether the property must be positive numeric or parse as a positive\n   * numeric and should be removed when set to a falsey value.\n   * @type {Object}\n   */\n  hasPositiveNumericValue: {},\n\n  /**\n   * All of the isCustomAttribute() functions that have been injected.\n   */\n  _isCustomAttributeFunctions: [],\n\n  /**\n   * Checks whether a property name is a custom attribute.\n   * @method\n   */\n  isCustomAttribute: function(attributeName) {\n    return DOMProperty._isCustomAttributeFunctions.some(\n      function(isCustomAttributeFn) {\n        return isCustomAttributeFn.call(null, attributeName);\n      }\n    );\n  },\n\n  /**\n   * Returns the default property value for a DOM property (i.e., not an\n   * attribute). Most default values are &apos;&apos; or false, but not all. Worse yet,\n   * some (in particular, `type`) vary depending on the type of element.\n   *\n   * TODO: Is it better to grab all the possible properties when creating an\n   * element to avoid having to create the same element twice?\n   */\n  getDefaultValueForProperty: function(nodeName, prop) {\n    var nodeDefaults = defaultValueCache[nodeName];\n    var testElement;\n    if (!nodeDefaults) {\n      defaultValueCache[nodeName] = nodeDefaults = {};\n    }\n    if (!(prop in nodeDefaults)) {\n      testElement = document.createElement(nodeName);\n      nodeDefaults[prop] = testElement[prop];\n    }\n    return nodeDefaults[prop];\n  },\n\n  injection: DOMPropertyInjection\n};\n\nmodule.exports = DOMProperty;\n\n},{&quot;./invariant&quot;:108}],9:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMPropertyOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar memoizeStringOnly = require(&quot;./memoizeStringOnly&quot;);\n\nfunction shouldIgnoreValue(name, value) {\n  return value == null ||\n    DOMProperty.hasBooleanValue[name] &amp;&amp; !value ||\n    DOMProperty.hasPositiveNumericValue[name] &amp;&amp; (isNaN(value) || value &lt; 1);\n}\n\nvar processAttributeNameAndPrefix = memoizeStringOnly(function(name) {\n  return escapeTextForBrowser(name) + &apos;=&quot;&apos;;\n});\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  var reactProps = {\n    children: true,\n    dangerouslySetInnerHTML: true,\n    key: true,\n    ref: true\n  };\n  var warnedProperties = {};\n\n  var warnUnknownProperty = function(name) {\n    if (reactProps[name] || warnedProperties[name]) {\n      return;\n    }\n\n    warnedProperties[name] = true;\n    var lowerCasedName = name.toLowerCase();\n\n    // data-* attributes should be lowercase; suggest the lowercase version\n    var standardName = DOMProperty.isCustomAttribute(lowerCasedName) ?\n      lowerCasedName : DOMProperty.getPossibleStandardName[lowerCasedName];\n\n    // For now, only warn when we have a suggested correction. This prevents\n    // logging too much when using transferPropsTo.\n    if (standardName != null) {\n      console.warn(\n        &apos;Unknown DOM property &apos; + name + &apos;. Did you mean &apos; + standardName + &apos;?&apos;\n      );\n    }\n\n  };\n}\n\n/**\n * Operations for dealing with DOM properties.\n */\nvar DOMPropertyOperations = {\n\n  /**\n   * Creates markup for the ID property.\n   *\n   * @param {string} id Unescaped ID.\n   * @return {string} Markup string.\n   */\n  createMarkupForID: function(id) {\n    return processAttributeNameAndPrefix(DOMProperty.ID_ATTRIBUTE_NAME) +\n      escapeTextForBrowser(id) + &apos;&quot;&apos;;\n  },\n\n  /**\n   * Creates markup for a property.\n   *\n   * @param {string} name\n   * @param {*} value\n   * @return {?string} Markup string, or null if the property was invalid.\n   */\n  createMarkupForProperty: function(name, value) {\n    if (DOMProperty.isStandardName[name]) {\n      if (shouldIgnoreValue(name, value)) {\n        return &apos;&apos;;\n      }\n      var attributeName = DOMProperty.getAttributeName[name];\n      if (DOMProperty.hasBooleanValue[name]) {\n        return escapeTextForBrowser(attributeName);\n      }\n      return processAttributeNameAndPrefix(attributeName) +\n        escapeTextForBrowser(value) + &apos;&quot;&apos;;\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      if (value == null) {\n        return &apos;&apos;;\n      }\n      return processAttributeNameAndPrefix(name) +\n        escapeTextForBrowser(value) + &apos;&quot;&apos;;\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n    return null;\n  },\n\n  /**\n   * Sets the value for a property on a node.\n   *\n   * @param {DOMElement} node\n   * @param {string} name\n   * @param {*} value\n   */\n  setValueForProperty: function(node, name, value) {\n    if (DOMProperty.isStandardName[name]) {\n      var mutationMethod = DOMProperty.getMutationMethod[name];\n      if (mutationMethod) {\n        mutationMethod(node, value);\n      } else if (shouldIgnoreValue(name, value)) {\n        this.deleteValueForProperty(node, name);\n      } else if (DOMProperty.mustUseAttribute[name]) {\n        node.setAttribute(DOMProperty.getAttributeName[name], &apos;&apos; + value);\n      } else {\n        var propName = DOMProperty.getPropertyName[name];\n        if (!DOMProperty.hasSideEffects[name] || node[propName] !== value) {\n          node[propName] = value;\n        }\n      }\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      if (value == null) {\n        node.removeAttribute(DOMProperty.getAttributeName[name]);\n      } else {\n        node.setAttribute(name, &apos;&apos; + value);\n      }\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n  },\n\n  /**\n   * Deletes the value for a property on a node.\n   *\n   * @param {DOMElement} node\n   * @param {string} name\n   */\n  deleteValueForProperty: function(node, name) {\n    if (DOMProperty.isStandardName[name]) {\n      var mutationMethod = DOMProperty.getMutationMethod[name];\n      if (mutationMethod) {\n        mutationMethod(node, undefined);\n      } else if (DOMProperty.mustUseAttribute[name]) {\n        node.removeAttribute(DOMProperty.getAttributeName[name]);\n      } else {\n        var propName = DOMProperty.getPropertyName[name];\n        var defaultValue = DOMProperty.getDefaultValueForProperty(\n          node.nodeName,\n          name\n        );\n        if (!DOMProperty.hasSideEffects[name] ||\n            node[propName] !== defaultValue) {\n          node[propName] = defaultValue;\n        }\n      }\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      node.removeAttribute(name);\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n  }\n\n};\n\nmodule.exports = DOMPropertyOperations;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./escapeTextForBrowser&quot;:96,&quot;./memoizeStringOnly&quot;:116}],10:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule Danger\n * @typechecks static-only\n */\n\n/*jslint evil: true, sub: true */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar createNodesFromMarkup = require(&quot;./createNodesFromMarkup&quot;);\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar getMarkupWrap = require(&quot;./getMarkupWrap&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\nvar OPEN_TAG_NAME_EXP = /^(&lt;[^ \\/&gt;]+)/;\nvar RESULT_INDEX_ATTR = &apos;data-danger-index&apos;;\n\n/**\n * Extracts the `nodeName` from a string of markup.\n *\n * NOTE: Extracting the `nodeName` does not require a regular expression match\n * because we make assumptions about React-generated markup (i.e. there are no\n * spaces surrounding the opening tag and there is at least one attribute).\n *\n * @param {string} markup String of markup.\n * @return {string} Node name of the supplied markup.\n * @see http://jsperf.com/extract-nodename\n */\nfunction getNodeName(markup) {\n  return markup.substring(1, markup.indexOf(&apos; &apos;));\n}\n\nvar Danger = {\n\n  /**\n   * Renders markup into an array of nodes. The markup is expected to render\n   * into a list of root nodes. Also, the length of `resultList` and\n   * `markupList` should be the same.\n   *\n   * @param {array&lt;string&gt;} markupList List of markup strings to render.\n   * @return {array&lt;DOMElement&gt;} List of rendered nodes.\n   * @internal\n   */\n  dangerouslyRenderMarkup: function(markupList) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;dangerouslyRenderMarkup(...): Cannot render markup in a Worker &apos; +\n      &apos;thread. This is likely a bug in the framework. Please report &apos; +\n      &apos;immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    var nodeName;\n    var markupByNodeName = {};\n    // Group markup by `nodeName` if a wrap is necessary, else by &apos;*&apos;.\n    for (var i = 0; i &lt; markupList.length; i++) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        markupList[i],\n        &apos;dangerouslyRenderMarkup(...): Missing markup.&apos;\n      ) : invariant(markupList[i]));\n      nodeName = getNodeName(markupList[i]);\n      nodeName = getMarkupWrap(nodeName) ? nodeName : &apos;*&apos;;\n      markupByNodeName[nodeName] = markupByNodeName[nodeName] || [];\n      markupByNodeName[nodeName][i] = markupList[i];\n    }\n    var resultList = [];\n    var resultListAssignmentCount = 0;\n    for (nodeName in markupByNodeName) {\n      if (!markupByNodeName.hasOwnProperty(nodeName)) {\n        continue;\n      }\n      var markupListByNodeName = markupByNodeName[nodeName];\n\n      // This for-in loop skips the holes of the sparse array. The order of\n      // iteration should follow the order of assignment, which happens to match\n      // numerical index order, but we don&apos;t rely on that.\n      for (var resultIndex in markupListByNodeName) {\n        if (markupListByNodeName.hasOwnProperty(resultIndex)) {\n          var markup = markupListByNodeName[resultIndex];\n\n          // Push the requested markup with an additional RESULT_INDEX_ATTR\n          // attribute.  If the markup does not start with a &lt; character, it\n          // will be discarded below (with an appropriate console.error).\n          markupListByNodeName[resultIndex] = markup.replace(\n            OPEN_TAG_NAME_EXP,\n            // This index will be parsed back out below.\n            &apos;$1 &apos; + RESULT_INDEX_ATTR + &apos;=&quot;&apos; + resultIndex + &apos;&quot; &apos;\n          );\n        }\n      }\n\n      // Render each group of markup with similar wrapping `nodeName`.\n      var renderNodes = createNodesFromMarkup(\n        markupListByNodeName.join(&apos;&apos;),\n        emptyFunction // Do nothing special with &lt;script&gt; tags.\n      );\n\n      for (i = 0; i &lt; renderNodes.length; ++i) {\n        var renderNode = renderNodes[i];\n        if (renderNode.hasAttribute &amp;&amp;\n            renderNode.hasAttribute(RESULT_INDEX_ATTR)) {\n\n          resultIndex = +renderNode.getAttribute(RESULT_INDEX_ATTR);\n          renderNode.removeAttribute(RESULT_INDEX_ATTR);\n\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            !resultList.hasOwnProperty(resultIndex),\n            &apos;Danger: Assigning to an already-occupied result index.&apos;\n          ) : invariant(!resultList.hasOwnProperty(resultIndex)));\n\n          resultList[resultIndex] = renderNode;\n\n          // This should match resultList.length and markupList.length when\n          // we&apos;re done.\n          resultListAssignmentCount += 1;\n\n        } else if (&quot;production&quot; !== &quot;development&quot;) {\n          console.error(\n            &quot;Danger: Discarding unexpected node:&quot;,\n            renderNode\n          );\n        }\n      }\n    }\n\n    // Although resultList was populated out of order, it should now be a dense\n    // array.\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      resultListAssignmentCount === resultList.length,\n      &apos;Danger: Did not assign to every index of resultList.&apos;\n    ) : invariant(resultListAssignmentCount === resultList.length));\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      resultList.length === markupList.length,\n      &apos;Danger: Expected markup to render %s nodes, but rendered %s.&apos;,\n      markupList.length,\n      resultList.length\n    ) : invariant(resultList.length === markupList.length));\n\n    return resultList;\n  },\n\n  /**\n   * Replaces a node with a string of markup at its current position within its\n   * parent. The markup must render into a single root node.\n   *\n   * @param {DOMElement} oldChild Child node to replace.\n   * @param {string} markup Markup to render in place of the child node.\n   * @internal\n   */\n  dangerouslyReplaceNodeWithMarkup: function(oldChild, markup) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;dangerouslyReplaceNodeWithMarkup(...): Cannot render markup in a &apos; +\n      &apos;worker thread. This is likely a bug in the framework. Please report &apos; +\n      &apos;immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(markup, &apos;dangerouslyReplaceNodeWithMarkup(...): Missing markup.&apos;) : invariant(markup));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      oldChild.tagName.toLowerCase() !== &apos;html&apos;,\n      &apos;dangerouslyReplaceNodeWithMarkup(...): Cannot replace markup of the &apos; +\n      &apos;&lt;html&gt; node. This is because browser quirks make this unreliable &apos; +\n      &apos;and/or slow. If you want to render to the root you must use &apos; +\n      &apos;server rendering. See renderComponentToString().&apos;\n    ) : invariant(oldChild.tagName.toLowerCase() !== &apos;html&apos;));\n\n    var newChild = createNodesFromMarkup(markup, emptyFunction)[0];\n    oldChild.parentNode.replaceChild(newChild, oldChild);\n  }\n\n};\n\nmodule.exports = Danger;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./createNodesFromMarkup&quot;:92,&quot;./emptyFunction&quot;:95,&quot;./getMarkupWrap&quot;:102,&quot;./invariant&quot;:108}],11:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DefaultDOMPropertyConfig\n */\n\n/*jslint bitwise: true*/\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\n\nvar MUST_USE_ATTRIBUTE = DOMProperty.injection.MUST_USE_ATTRIBUTE;\nvar MUST_USE_PROPERTY = DOMProperty.injection.MUST_USE_PROPERTY;\nvar HAS_BOOLEAN_VALUE = DOMProperty.injection.HAS_BOOLEAN_VALUE;\nvar HAS_SIDE_EFFECTS = DOMProperty.injection.HAS_SIDE_EFFECTS;\nvar HAS_POSITIVE_NUMERIC_VALUE =\n  DOMProperty.injection.HAS_POSITIVE_NUMERIC_VALUE;\n\nvar DefaultDOMPropertyConfig = {\n  isCustomAttribute: RegExp.prototype.test.bind(\n    /^(data|aria)-[a-z_][a-z\\d_.\\-]*$/\n  ),\n  Properties: {\n    /**\n     * Standard Properties\n     */\n    accept: null,\n    accessKey: null,\n    action: null,\n    allowFullScreen: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    allowTransparency: MUST_USE_ATTRIBUTE,\n    alt: null,\n    async: HAS_BOOLEAN_VALUE,\n    autoComplete: null,\n    // autoFocus is polyfilled/normalized by AutoFocusMixin\n    // autoFocus: HAS_BOOLEAN_VALUE,\n    autoPlay: HAS_BOOLEAN_VALUE,\n    cellPadding: null,\n    cellSpacing: null,\n    charSet: MUST_USE_ATTRIBUTE,\n    checked: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    className: MUST_USE_PROPERTY,\n    cols: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    colSpan: null,\n    content: null,\n    contentEditable: null,\n    contextMenu: MUST_USE_ATTRIBUTE,\n    controls: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    crossOrigin: null,\n    data: null, // For `&lt;object /&gt;` acts as `src`.\n    dateTime: MUST_USE_ATTRIBUTE,\n    defer: HAS_BOOLEAN_VALUE,\n    dir: null,\n    disabled: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    download: null,\n    draggable: null,\n    encType: null,\n    form: MUST_USE_ATTRIBUTE,\n    formNoValidate: HAS_BOOLEAN_VALUE,\n    frameBorder: MUST_USE_ATTRIBUTE,\n    height: MUST_USE_ATTRIBUTE,\n    hidden: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    href: null,\n    hrefLang: null,\n    htmlFor: null,\n    httpEquiv: null,\n    icon: null,\n    id: MUST_USE_PROPERTY,\n    label: null,\n    lang: null,\n    list: null,\n    loop: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    max: null,\n    maxLength: MUST_USE_ATTRIBUTE,\n    mediaGroup: null,\n    method: null,\n    min: null,\n    multiple: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    muted: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    name: null,\n    noValidate: HAS_BOOLEAN_VALUE,\n    pattern: null,\n    placeholder: null,\n    poster: null,\n    preload: null,\n    radioGroup: null,\n    readOnly: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    rel: null,\n    required: HAS_BOOLEAN_VALUE,\n    role: MUST_USE_ATTRIBUTE,\n    rows: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    rowSpan: null,\n    sandbox: null,\n    scope: null,\n    scrollLeft: MUST_USE_PROPERTY,\n    scrollTop: MUST_USE_PROPERTY,\n    seamless: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    selected: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    size: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    span: HAS_POSITIVE_NUMERIC_VALUE,\n    spellCheck: null,\n    src: null,\n    srcDoc: MUST_USE_PROPERTY,\n    step: null,\n    style: null,\n    tabIndex: null,\n    target: null,\n    title: null,\n    type: null,\n    value: MUST_USE_PROPERTY | HAS_SIDE_EFFECTS,\n    width: MUST_USE_ATTRIBUTE,\n    wmode: MUST_USE_ATTRIBUTE,\n\n    /**\n     * Non-standard Properties\n     */\n    autoCapitalize: null, // Supported in Mobile Safari for keyboard hints\n    autoCorrect: null, // Supported in Mobile Safari for keyboard hints\n    property: null, // Supports OG in meta tags\n\n    /**\n     * SVG Properties\n     */\n    cx: MUST_USE_ATTRIBUTE,\n    cy: MUST_USE_ATTRIBUTE,\n    d: MUST_USE_ATTRIBUTE,\n    fill: MUST_USE_ATTRIBUTE,\n    fx: MUST_USE_ATTRIBUTE,\n    fy: MUST_USE_ATTRIBUTE,\n    gradientTransform: MUST_USE_ATTRIBUTE,\n    gradientUnits: MUST_USE_ATTRIBUTE,\n    offset: MUST_USE_ATTRIBUTE,\n    points: MUST_USE_ATTRIBUTE,\n    r: MUST_USE_ATTRIBUTE,\n    rx: MUST_USE_ATTRIBUTE,\n    ry: MUST_USE_ATTRIBUTE,\n    spreadMethod: MUST_USE_ATTRIBUTE,\n    stopColor: MUST_USE_ATTRIBUTE,\n    stopOpacity: MUST_USE_ATTRIBUTE,\n    stroke: MUST_USE_ATTRIBUTE,\n    strokeLinecap: MUST_USE_ATTRIBUTE,\n    strokeWidth: MUST_USE_ATTRIBUTE,\n    transform: MUST_USE_ATTRIBUTE,\n    version: MUST_USE_ATTRIBUTE,\n    viewBox: MUST_USE_ATTRIBUTE,\n    x1: MUST_USE_ATTRIBUTE,\n    x2: MUST_USE_ATTRIBUTE,\n    x: MUST_USE_ATTRIBUTE,\n    y1: MUST_USE_ATTRIBUTE,\n    y2: MUST_USE_ATTRIBUTE,\n    y: MUST_USE_ATTRIBUTE\n  },\n  DOMAttributeNames: {\n    className: &apos;class&apos;,\n    gradientTransform: &apos;gradientTransform&apos;,\n    gradientUnits: &apos;gradientUnits&apos;,\n    htmlFor: &apos;for&apos;,\n    spreadMethod: &apos;spreadMethod&apos;,\n    stopColor: &apos;stop-color&apos;,\n    stopOpacity: &apos;stop-opacity&apos;,\n    strokeLinecap: &apos;stroke-linecap&apos;,\n    strokeWidth: &apos;stroke-width&apos;,\n    viewBox: &apos;viewBox&apos;\n  },\n  DOMPropertyNames: {\n    autoCapitalize: &apos;autocapitalize&apos;,\n    autoComplete: &apos;autocomplete&apos;,\n    autoCorrect: &apos;autocorrect&apos;,\n    autoFocus: &apos;autofocus&apos;,\n    autoPlay: &apos;autoplay&apos;,\n    encType: &apos;enctype&apos;,\n    hrefLang: &apos;hreflang&apos;,\n    radioGroup: &apos;radiogroup&apos;,\n    spellCheck: &apos;spellcheck&apos;,\n    srcDoc: &apos;srcdoc&apos;\n  },\n  DOMMutationMethods: {\n    /**\n     * Setting `className` to null may cause it to be set to the string &quot;null&quot;.\n     *\n     * @param {DOMElement} node\n     * @param {*} value\n     */\n    className: function(node, value) {\n      node.className = value || &apos;&apos;;\n    }\n  }\n};\n\nmodule.exports = DefaultDOMPropertyConfig;\n\n},{&quot;./DOMProperty&quot;:8}],12:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DefaultEventPluginOrder\n */\n\n&quot;use strict&quot;;\n\n var keyOf = require(&quot;./keyOf&quot;);\n\n/**\n * Module that is injectable into `EventPluginHub`, that specifies a\n * deterministic ordering of `EventPlugin`s. A convenient way to reason about\n * plugins, without having to package every one of them. This is better than\n * having plugins be ordered in the same order that they are injected because\n * that ordering would be influenced by the packaging order.\n * `ResponderEventPlugin` must occur before `SimpleEventPlugin` so that\n * preventing default on events is convenient in `SimpleEventPlugin` handlers.\n */\nvar DefaultEventPluginOrder = [\n  keyOf({ResponderEventPlugin: null}),\n  keyOf({SimpleEventPlugin: null}),\n  keyOf({TapEventPlugin: null}),\n  keyOf({EnterLeaveEventPlugin: null}),\n  keyOf({ChangeEventPlugin: null}),\n  keyOf({SelectEventPlugin: null}),\n  keyOf({CompositionEventPlugin: null}),\n  keyOf({AnalyticsEventPlugin: null}),\n  keyOf({MobileSafariClickEventPlugin: null})\n];\n\nmodule.exports = DefaultEventPluginOrder;\n\n},{&quot;./keyOf&quot;:115}],13:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EnterLeaveEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\nvar getFirstReactDOM = ReactMount.getFirstReactDOM;\n\nvar eventTypes = {\n  mouseEnter: {\n    registrationName: keyOf({onMouseEnter: null}),\n    dependencies: [\n      topLevelTypes.topMouseOut,\n      topLevelTypes.topMouseOver\n    ]\n  },\n  mouseLeave: {\n    registrationName: keyOf({onMouseLeave: null}),\n    dependencies: [\n      topLevelTypes.topMouseOut,\n      topLevelTypes.topMouseOver\n    ]\n  }\n};\n\nvar extractedEvents = [null, null];\n\nvar EnterLeaveEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * For almost every interaction we care about, there will be both a top-level\n   * `mouseover` and `mouseout` event that occurs. Only use `mouseout` so that\n   * we do not extract duplicate events. However, moving the mouse into the\n   * browser from outside will not fire a `mouseout` event. In this case, we use\n   * the `mouseover` top-level event.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    if (topLevelType === topLevelTypes.topMouseOver &amp;&amp;\n        (nativeEvent.relatedTarget || nativeEvent.fromElement)) {\n      return null;\n    }\n    if (topLevelType !== topLevelTypes.topMouseOut &amp;&amp;\n        topLevelType !== topLevelTypes.topMouseOver) {\n      // Must not be a mouse in or mouse out - ignoring.\n      return null;\n    }\n\n    var win;\n    if (topLevelTarget.window === topLevelTarget) {\n      // `topLevelTarget` is probably a window object.\n      win = topLevelTarget;\n    } else {\n      // TODO: Figure out why `ownerDocument` is sometimes undefined in IE8.\n      var doc = topLevelTarget.ownerDocument;\n      if (doc) {\n        win = doc.defaultView || doc.parentWindow;\n      } else {\n        win = window;\n      }\n    }\n\n    var from, to;\n    if (topLevelType === topLevelTypes.topMouseOut) {\n      from = topLevelTarget;\n      to =\n        getFirstReactDOM(nativeEvent.relatedTarget || nativeEvent.toElement) ||\n        win;\n    } else {\n      from = win;\n      to = topLevelTarget;\n    }\n\n    if (from === to) {\n      // Nothing pertains to our managed components.\n      return null;\n    }\n\n    var fromID = from ? ReactMount.getID(from) : &apos;&apos;;\n    var toID = to ? ReactMount.getID(to) : &apos;&apos;;\n\n    var leave = SyntheticMouseEvent.getPooled(\n      eventTypes.mouseLeave,\n      fromID,\n      nativeEvent\n    );\n    leave.type = &apos;mouseleave&apos;;\n    leave.target = from;\n    leave.relatedTarget = to;\n\n    var enter = SyntheticMouseEvent.getPooled(\n      eventTypes.mouseEnter,\n      toID,\n      nativeEvent\n    );\n    enter.type = &apos;mouseenter&apos;;\n    enter.target = to;\n    enter.relatedTarget = from;\n\n    EventPropagators.accumulateEnterLeaveDispatches(leave, enter, fromID, toID);\n\n    extractedEvents[0] = leave;\n    extractedEvents[1] = enter;\n\n    return extractedEvents;\n  }\n\n};\n\nmodule.exports = EnterLeaveEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ReactMount&quot;:55,&quot;./SyntheticMouseEvent&quot;:80,&quot;./keyOf&quot;:115}],14:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventConstants\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\nvar PropagationPhases = keyMirror({bubbled: null, captured: null});\n\n/**\n * Types of raw signals from the browser caught at the top level.\n */\nvar topLevelTypes = keyMirror({\n  topBlur: null,\n  topChange: null,\n  topClick: null,\n  topCompositionEnd: null,\n  topCompositionStart: null,\n  topCompositionUpdate: null,\n  topContextMenu: null,\n  topCopy: null,\n  topCut: null,\n  topDoubleClick: null,\n  topDrag: null,\n  topDragEnd: null,\n  topDragEnter: null,\n  topDragExit: null,\n  topDragLeave: null,\n  topDragOver: null,\n  topDragStart: null,\n  topDrop: null,\n  topError: null,\n  topFocus: null,\n  topInput: null,\n  topKeyDown: null,\n  topKeyPress: null,\n  topKeyUp: null,\n  topLoad: null,\n  topMouseDown: null,\n  topMouseMove: null,\n  topMouseOut: null,\n  topMouseOver: null,\n  topMouseUp: null,\n  topPaste: null,\n  topReset: null,\n  topScroll: null,\n  topSelectionChange: null,\n  topSubmit: null,\n  topTouchCancel: null,\n  topTouchEnd: null,\n  topTouchMove: null,\n  topTouchStart: null,\n  topWheel: null\n});\n\nvar EventConstants = {\n  topLevelTypes: topLevelTypes,\n  PropagationPhases: PropagationPhases\n};\n\nmodule.exports = EventConstants;\n\n},{&quot;./keyMirror&quot;:114}],15:[function(require,module,exports){\n/**\n * @providesModule EventListener\n */\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\n/**\n * Upstream version of event listener. Does not take into account specific\n * nature of platform.\n */\nvar EventListener = {\n  /**\n   * Listen to DOM events during the bubble phase.\n   *\n   * @param {DOMEventTarget} target DOM element to register listener on.\n   * @param {string} eventType Event type, e.g. &apos;click&apos; or &apos;mouseover&apos;.\n   * @param {function} callback Callback function.\n   * @return {object} Object with a `remove` method.\n   */\n  listen: function(target, eventType, callback) {\n    if (target.addEventListener) {\n      target.addEventListener(eventType, callback, false);\n      return {\n        remove: function() {\n          target.removeEventListener(eventType, callback, false);\n        }\n      };\n    } else if (target.attachEvent) {\n      target.attachEvent(&apos;on&apos; + eventType, callback);\n      return {\n        remove: function() {\n          target.detachEvent(eventType, callback);\n        }\n      };\n    }\n  },\n\n  /**\n   * Listen to DOM events during the capture phase.\n   *\n   * @param {DOMEventTarget} target DOM element to register listener on.\n   * @param {string} eventType Event type, e.g. &apos;click&apos; or &apos;mouseover&apos;.\n   * @param {function} callback Callback function.\n   * @return {object} Object with a `remove` method.\n   */\n  capture: function(target, eventType, callback) {\n    if (!target.addEventListener) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.error(\n          &apos;Attempted to listen to events during the capture phase on a &apos; +\n          &apos;browser that does not support the capture phase. Your application &apos; +\n          &apos;will not receive some events.&apos;\n        );\n      }\n      return {\n        remove: emptyFunction\n      };\n    } else {\n      target.addEventListener(eventType, callback, true);\n      return {\n        remove: function() {\n          target.removeEventListener(eventType, callback, true);\n        }\n      };\n    }\n  }\n};\n\nmodule.exports = EventListener;\n\n},{&quot;./emptyFunction&quot;:95}],16:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginHub\n */\n\n&quot;use strict&quot;;\n\nvar EventPluginRegistry = require(&quot;./EventPluginRegistry&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar accumulate = require(&quot;./accumulate&quot;);\nvar forEachAccumulated = require(&quot;./forEachAccumulated&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\n\n/**\n * Internal store for event listeners\n */\nvar listenerBank = {};\n\n/**\n * Internal queue of events that have accumulated their dispatches and are\n * waiting to have their dispatches executed.\n */\nvar eventQueue = null;\n\n/**\n * Dispatches an event and releases it back into the pool, unless persistent.\n *\n * @param {?object} event Synthetic event to be dispatched.\n * @private\n */\nvar executeDispatchesAndRelease = function(event) {\n  if (event) {\n    var executeDispatch = EventPluginUtils.executeDispatch;\n    // Plugins can provide custom behavior when dispatching events.\n    var PluginModule = EventPluginRegistry.getPluginModuleForEvent(event);\n    if (PluginModule &amp;&amp; PluginModule.executeDispatch) {\n      executeDispatch = PluginModule.executeDispatch;\n    }\n    EventPluginUtils.executeDispatchesInOrder(event, executeDispatch);\n\n    if (!event.isPersistent()) {\n      event.constructor.release(event);\n    }\n  }\n};\n\n/**\n * - `InstanceHandle`: [required] Module that performs logical traversals of DOM\n *   hierarchy given ids of the logical DOM elements involved.\n */\nvar InstanceHandle = null;\n\nfunction validateInstanceHandle() {\n  var invalid = !InstanceHandle||\n    !InstanceHandle.traverseTwoPhase ||\n    !InstanceHandle.traverseEnterLeave;\n  if (invalid) {\n    throw new Error(&apos;InstanceHandle not injected before use!&apos;);\n  }\n}\n\n/**\n * This is a unified interface for event plugins to be installed and configured.\n *\n * Event plugins can implement the following properties:\n *\n *   `extractEvents` {function(string, DOMEventTarget, string, object): *}\n *     Required. When a top-level event is fired, this method is expected to\n *     extract synthetic events that will in turn be queued and dispatched.\n *\n *   `eventTypes` {object}\n *     Optional, plugins that fire events must publish a mapping of registration\n *     names that are used to register listeners. Values of this mapping must\n *     be objects that contain `registrationName` or `phasedRegistrationNames`.\n *\n *   `executeDispatch` {function(object, function, string)}\n *     Optional, allows plugins to override how an event gets dispatched. By\n *     default, the listener is simply invoked.\n *\n * Each plugin that is injected into `EventsPluginHub` is immediately operable.\n *\n * @public\n */\nvar EventPluginHub = {\n\n  /**\n   * Methods for injecting dependencies.\n   */\n  injection: {\n\n    /**\n     * @param {object} InjectedMount\n     * @public\n     */\n    injectMount: EventPluginUtils.injection.injectMount,\n\n    /**\n     * @param {object} InjectedInstanceHandle\n     * @public\n     */\n    injectInstanceHandle: function(InjectedInstanceHandle) {\n      InstanceHandle = InjectedInstanceHandle;\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        validateInstanceHandle();\n      }\n    },\n\n    getInstanceHandle: function() {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        validateInstanceHandle();\n      }\n      return InstanceHandle;\n    },\n\n    /**\n     * @param {array} InjectedEventPluginOrder\n     * @public\n     */\n    injectEventPluginOrder: EventPluginRegistry.injectEventPluginOrder,\n\n    /**\n     * @param {object} injectedNamesToPlugins Map from names to plugin modules.\n     */\n    injectEventPluginsByName: EventPluginRegistry.injectEventPluginsByName\n\n  },\n\n  eventNameDispatchConfigs: EventPluginRegistry.eventNameDispatchConfigs,\n\n  registrationNameModules: EventPluginRegistry.registrationNameModules,\n\n  /**\n   * Stores `listener` at `listenerBank[registrationName][id]`. Is idempotent.\n   *\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @param {?function} listener The callback to store.\n   */\n  putListener: function(id, registrationName, listener) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;Cannot call putListener() in a non-DOM environment.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !listener || typeof listener === &apos;function&apos;,\n      &apos;Expected %s listener to be a function, instead got type %s&apos;,\n      registrationName, typeof listener\n    ) : invariant(!listener || typeof listener === &apos;function&apos;));\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      // IE8 has no API for event capturing and the `onScroll` event doesn&apos;t\n      // bubble.\n      if (registrationName === &apos;onScroll&apos; &amp;&amp;\n          !isEventSupported(&apos;scroll&apos;, true)) {\n        console.warn(&apos;This browser doesn\\&apos;t support the `onScroll` event&apos;);\n      }\n    }\n    var bankForRegistrationName =\n      listenerBank[registrationName] || (listenerBank[registrationName] = {});\n    bankForRegistrationName[id] = listener;\n  },\n\n  /**\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @return {?function} The stored callback.\n   */\n  getListener: function(id, registrationName) {\n    var bankForRegistrationName = listenerBank[registrationName];\n    return bankForRegistrationName &amp;&amp; bankForRegistrationName[id];\n  },\n\n  /**\n   * Deletes a listener from the registration bank.\n   *\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   */\n  deleteListener: function(id, registrationName) {\n    var bankForRegistrationName = listenerBank[registrationName];\n    if (bankForRegistrationName) {\n      delete bankForRegistrationName[id];\n    }\n  },\n\n  /**\n   * Deletes all listeners for the DOM element with the supplied ID.\n   *\n   * @param {string} id ID of the DOM element.\n   */\n  deleteAllListeners: function(id) {\n    for (var registrationName in listenerBank) {\n      delete listenerBank[registrationName][id];\n    }\n  },\n\n  /**\n   * Allows registered plugins an opportunity to extract events from top-level\n   * native browser events.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @internal\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var events;\n    var plugins = EventPluginRegistry.plugins;\n    for (var i = 0, l = plugins.length; i &lt; l; i++) {\n      // Not every plugin in the ordering may be loaded at runtime.\n      var possiblePlugin = plugins[i];\n      if (possiblePlugin) {\n        var extractedEvents = possiblePlugin.extractEvents(\n          topLevelType,\n          topLevelTarget,\n          topLevelTargetID,\n          nativeEvent\n        );\n        if (extractedEvents) {\n          events = accumulate(events, extractedEvents);\n        }\n      }\n    }\n    return events;\n  },\n\n  /**\n   * Enqueues a synthetic event that should be dispatched when\n   * `processEventQueue` is invoked.\n   *\n   * @param {*} events An accumulation of synthetic events.\n   * @internal\n   */\n  enqueueEvents: function(events) {\n    if (events) {\n      eventQueue = accumulate(eventQueue, events);\n    }\n  },\n\n  /**\n   * Dispatches all synthetic events on the event queue.\n   *\n   * @internal\n   */\n  processEventQueue: function() {\n    // Set `eventQueue` to null before processing it so that we can tell if more\n    // events get enqueued while processing.\n    var processingEventQueue = eventQueue;\n    eventQueue = null;\n    forEachAccumulated(processingEventQueue, executeDispatchesAndRelease);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !eventQueue,\n      &apos;processEventQueue(): Additional events were enqueued while processing &apos; +\n      &apos;an event queue. Support for this has not yet been implemented.&apos;\n    ) : invariant(!eventQueue));\n  },\n\n  /**\n   * These are needed for tests only. Do not use!\n   */\n  __purge: function() {\n    listenerBank = {};\n  },\n\n  __getListenerBank: function() {\n    return listenerBank;\n  }\n\n};\n\nmodule.exports = EventPluginHub;\n\n},{&quot;./EventPluginRegistry&quot;:17,&quot;./EventPluginUtils&quot;:18,&quot;./ExecutionEnvironment&quot;:20,&quot;./accumulate&quot;:86,&quot;./forEachAccumulated&quot;:98,&quot;./invariant&quot;:108,&quot;./isEventSupported&quot;:109}],17:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginRegistry\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Injectable ordering of event plugins.\n */\nvar EventPluginOrder = null;\n\n/**\n * Injectable mapping from names to event plugin modules.\n */\nvar namesToPlugins = {};\n\n/**\n * Recomputes the plugin list using the injected plugins and plugin ordering.\n *\n * @private\n */\nfunction recomputePluginOrdering() {\n  if (!EventPluginOrder) {\n    // Wait until an `EventPluginOrder` is injected.\n    return;\n  }\n  for (var pluginName in namesToPlugins) {\n    var PluginModule = namesToPlugins[pluginName];\n    var pluginIndex = EventPluginOrder.indexOf(pluginName);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      pluginIndex &gt; -1,\n      &apos;EventPluginRegistry: Cannot inject event plugins that do not exist in &apos; +\n      &apos;the plugin ordering, `%s`.&apos;,\n      pluginName\n    ) : invariant(pluginIndex &gt; -1));\n    if (EventPluginRegistry.plugins[pluginIndex]) {\n      continue;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      PluginModule.extractEvents,\n      &apos;EventPluginRegistry: Event plugins must implement an `extractEvents` &apos; +\n      &apos;method, but `%s` does not.&apos;,\n      pluginName\n    ) : invariant(PluginModule.extractEvents));\n    EventPluginRegistry.plugins[pluginIndex] = PluginModule;\n    var publishedEvents = PluginModule.eventTypes;\n    for (var eventName in publishedEvents) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        publishEventForPlugin(\n          publishedEvents[eventName],\n          PluginModule,\n          eventName\n        ),\n        &apos;EventPluginRegistry: Failed to publish event `%s` for plugin `%s`.&apos;,\n        eventName,\n        pluginName\n      ) : invariant(publishEventForPlugin(\n        publishedEvents[eventName],\n        PluginModule,\n        eventName\n      )));\n    }\n  }\n}\n\n/**\n * Publishes an event so that it can be dispatched by the supplied plugin.\n *\n * @param {object} dispatchConfig Dispatch configuration for the event.\n * @param {object} PluginModule Plugin publishing the event.\n * @return {boolean} True if the event was successfully published.\n * @private\n */\nfunction publishEventForPlugin(dispatchConfig, PluginModule, eventName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !EventPluginRegistry.eventNameDispatchConfigs[eventName],\n    &apos;EventPluginHub: More than one plugin attempted to publish the same &apos; +\n    &apos;event name, `%s`.&apos;,\n    eventName\n  ) : invariant(!EventPluginRegistry.eventNameDispatchConfigs[eventName]));\n  EventPluginRegistry.eventNameDispatchConfigs[eventName] = dispatchConfig;\n\n  var phasedRegistrationNames = dispatchConfig.phasedRegistrationNames;\n  if (phasedRegistrationNames) {\n    for (var phaseName in phasedRegistrationNames) {\n      if (phasedRegistrationNames.hasOwnProperty(phaseName)) {\n        var phasedRegistrationName = phasedRegistrationNames[phaseName];\n        publishRegistrationName(\n          phasedRegistrationName,\n          PluginModule,\n          eventName\n        );\n      }\n    }\n    return true;\n  } else if (dispatchConfig.registrationName) {\n    publishRegistrationName(\n      dispatchConfig.registrationName,\n      PluginModule,\n      eventName\n    );\n    return true;\n  }\n  return false;\n}\n\n/**\n * Publishes a registration name that is used to identify dispatched events and\n * can be used with `EventPluginHub.putListener` to register listeners.\n *\n * @param {string} registrationName Registration name to add.\n * @param {object} PluginModule Plugin publishing the event.\n * @private\n */\nfunction publishRegistrationName(registrationName, PluginModule, eventName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !EventPluginRegistry.registrationNameModules[registrationName],\n    &apos;EventPluginHub: More than one plugin attempted to publish the same &apos; +\n    &apos;registration name, `%s`.&apos;,\n    registrationName\n  ) : invariant(!EventPluginRegistry.registrationNameModules[registrationName]));\n  EventPluginRegistry.registrationNameModules[registrationName] = PluginModule;\n  EventPluginRegistry.registrationNameDependencies[registrationName] =\n    PluginModule.eventTypes[eventName].dependencies;\n}\n\n/**\n * Registers plugins so that they can extract and dispatch events.\n *\n * @see {EventPluginHub}\n */\nvar EventPluginRegistry = {\n\n  /**\n   * Ordered list of injected plugins.\n   */\n  plugins: [],\n\n  /**\n   * Mapping from event name to dispatch config\n   */\n  eventNameDispatchConfigs: {},\n\n  /**\n   * Mapping from registration name to plugin module\n   */\n  registrationNameModules: {},\n\n  /**\n   * Mapping from registration name to event name\n   */\n  registrationNameDependencies: {},\n\n  /**\n   * Injects an ordering of plugins (by plugin name). This allows the ordering\n   * to be decoupled from injection of the actual plugins so that ordering is\n   * always deterministic regardless of packaging, on-the-fly injection, etc.\n   *\n   * @param {array} InjectedEventPluginOrder\n   * @internal\n   * @see {EventPluginHub.injection.injectEventPluginOrder}\n   */\n  injectEventPluginOrder: function(InjectedEventPluginOrder) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !EventPluginOrder,\n      &apos;EventPluginRegistry: Cannot inject event plugin ordering more than once.&apos;\n    ) : invariant(!EventPluginOrder));\n    // Clone the ordering so it cannot be dynamically mutated.\n    EventPluginOrder = Array.prototype.slice.call(InjectedEventPluginOrder);\n    recomputePluginOrdering();\n  },\n\n  /**\n   * Injects plugins to be used by `EventPluginHub`. The plugin names must be\n   * in the ordering injected by `injectEventPluginOrder`.\n   *\n   * Plugins can be injected as part of page initialization or on-the-fly.\n   *\n   * @param {object} injectedNamesToPlugins Map from names to plugin modules.\n   * @internal\n   * @see {EventPluginHub.injection.injectEventPluginsByName}\n   */\n  injectEventPluginsByName: function(injectedNamesToPlugins) {\n    var isOrderingDirty = false;\n    for (var pluginName in injectedNamesToPlugins) {\n      if (!injectedNamesToPlugins.hasOwnProperty(pluginName)) {\n        continue;\n      }\n      var PluginModule = injectedNamesToPlugins[pluginName];\n      if (namesToPlugins[pluginName] !== PluginModule) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          !namesToPlugins[pluginName],\n          &apos;EventPluginRegistry: Cannot inject two different event plugins &apos; +\n          &apos;using the same name, `%s`.&apos;,\n          pluginName\n        ) : invariant(!namesToPlugins[pluginName]));\n        namesToPlugins[pluginName] = PluginModule;\n        isOrderingDirty = true;\n      }\n    }\n    if (isOrderingDirty) {\n      recomputePluginOrdering();\n    }\n  },\n\n  /**\n   * Looks up the plugin for the supplied event.\n   *\n   * @param {object} event A synthetic event.\n   * @return {?object} The plugin that created the supplied event.\n   * @internal\n   */\n  getPluginModuleForEvent: function(event) {\n    var dispatchConfig = event.dispatchConfig;\n    if (dispatchConfig.registrationName) {\n      return EventPluginRegistry.registrationNameModules[\n        dispatchConfig.registrationName\n      ] || null;\n    }\n    for (var phase in dispatchConfig.phasedRegistrationNames) {\n      if (!dispatchConfig.phasedRegistrationNames.hasOwnProperty(phase)) {\n        continue;\n      }\n      var PluginModule = EventPluginRegistry.registrationNameModules[\n        dispatchConfig.phasedRegistrationNames[phase]\n      ];\n      if (PluginModule) {\n        return PluginModule;\n      }\n    }\n    return null;\n  },\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _resetEventPlugins: function() {\n    EventPluginOrder = null;\n    for (var pluginName in namesToPlugins) {\n      if (namesToPlugins.hasOwnProperty(pluginName)) {\n        delete namesToPlugins[pluginName];\n      }\n    }\n    EventPluginRegistry.plugins.length = 0;\n\n    var eventNameDispatchConfigs = EventPluginRegistry.eventNameDispatchConfigs;\n    for (var eventName in eventNameDispatchConfigs) {\n      if (eventNameDispatchConfigs.hasOwnProperty(eventName)) {\n        delete eventNameDispatchConfigs[eventName];\n      }\n    }\n\n    var registrationNameModules = EventPluginRegistry.registrationNameModules;\n    for (var registrationName in registrationNameModules) {\n      if (registrationNameModules.hasOwnProperty(registrationName)) {\n        delete registrationNameModules[registrationName];\n      }\n    }\n  }\n\n};\n\nmodule.exports = EventPluginRegistry;\n\n},{&quot;./invariant&quot;:108}],18:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginUtils\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Injected dependencies:\n */\n\n/**\n * - `Mount`: [required] Module that can convert between React dom IDs and\n *   actual node references.\n */\nvar injection = {\n  Mount: null,\n  injectMount: function(InjectedMount) {\n    injection.Mount = InjectedMount;\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        InjectedMount &amp;&amp; InjectedMount.getNode,\n        &apos;EventPluginUtils.injection.injectMount(...): Injected Mount module &apos; +\n        &apos;is missing getNode.&apos;\n      ) : invariant(InjectedMount &amp;&amp; InjectedMount.getNode));\n    }\n  }\n};\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nfunction isEndish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseUp ||\n         topLevelType === topLevelTypes.topTouchEnd ||\n         topLevelType === topLevelTypes.topTouchCancel;\n}\n\nfunction isMoveish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseMove ||\n         topLevelType === topLevelTypes.topTouchMove;\n}\nfunction isStartish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseDown ||\n         topLevelType === topLevelTypes.topTouchStart;\n}\n\n\nvar validateEventDispatches;\nif (&quot;production&quot; !== &quot;development&quot;) {\n  validateEventDispatches = function(event) {\n    var dispatchListeners = event._dispatchListeners;\n    var dispatchIDs = event._dispatchIDs;\n\n    var listenersIsArr = Array.isArray(dispatchListeners);\n    var idsIsArr = Array.isArray(dispatchIDs);\n    var IDsLen = idsIsArr ? dispatchIDs.length : dispatchIDs ? 1 : 0;\n    var listenersLen = listenersIsArr ?\n      dispatchListeners.length :\n      dispatchListeners ? 1 : 0;\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      idsIsArr === listenersIsArr &amp;&amp; IDsLen === listenersLen,\n      &apos;EventPluginUtils: Invalid `event`.&apos;\n    ) : invariant(idsIsArr === listenersIsArr &amp;&amp; IDsLen === listenersLen));\n  };\n}\n\n/**\n * Invokes `cb(event, listener, id)`. Avoids using call if no scope is\n * provided. The `(listener,id)` pair effectively forms the &quot;dispatch&quot; but are\n * kept separate to conserve memory.\n */\nfunction forEachEventDispatch(event, cb) {\n  var dispatchListeners = event._dispatchListeners;\n  var dispatchIDs = event._dispatchIDs;\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  if (Array.isArray(dispatchListeners)) {\n    for (var i = 0; i &lt; dispatchListeners.length; i++) {\n      if (event.isPropagationStopped()) {\n        break;\n      }\n      // Listeners and IDs are two parallel arrays that are always in sync.\n      cb(event, dispatchListeners[i], dispatchIDs[i]);\n    }\n  } else if (dispatchListeners) {\n    cb(event, dispatchListeners, dispatchIDs);\n  }\n}\n\n/**\n * Default implementation of PluginModule.executeDispatch().\n * @param {SyntheticEvent} SyntheticEvent to handle\n * @param {function} Application-level callback\n * @param {string} domID DOM id to pass to the callback.\n */\nfunction executeDispatch(event, listener, domID) {\n  event.currentTarget = injection.Mount.getNode(domID);\n  var returnValue = listener(event, domID);\n  event.currentTarget = null;\n  return returnValue;\n}\n\n/**\n * Standard/simple iteration through an event&apos;s collected dispatches.\n */\nfunction executeDispatchesInOrder(event, executeDispatch) {\n  forEachEventDispatch(event, executeDispatch);\n  event._dispatchListeners = null;\n  event._dispatchIDs = null;\n}\n\n/**\n * Standard/simple iteration through an event&apos;s collected dispatches, but stops\n * at the first dispatch execution returning true, and returns that id.\n *\n * @return id of the first dispatch execution who&apos;s listener returns true, or\n * null if no listener returned true.\n */\nfunction executeDispatchesInOrderStopAtTrue(event) {\n  var dispatchListeners = event._dispatchListeners;\n  var dispatchIDs = event._dispatchIDs;\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  if (Array.isArray(dispatchListeners)) {\n    for (var i = 0; i &lt; dispatchListeners.length; i++) {\n      if (event.isPropagationStopped()) {\n        break;\n      }\n      // Listeners and IDs are two parallel arrays that are always in sync.\n      if (dispatchListeners[i](event, dispatchIDs[i])) {\n        return dispatchIDs[i];\n      }\n    }\n  } else if (dispatchListeners) {\n    if (dispatchListeners(event, dispatchIDs)) {\n      return dispatchIDs;\n    }\n  }\n  return null;\n}\n\n/**\n * Execution of a &quot;direct&quot; dispatch - there must be at most one dispatch\n * accumulated on the event or it is considered an error. It doesn&apos;t really make\n * sense for an event with multiple dispatches (bubbled) to keep track of the\n * return values at each dispatch execution, but it does tend to make sense when\n * dealing with &quot;direct&quot; dispatches.\n *\n * @return The return value of executing the single dispatch.\n */\nfunction executeDirectDispatch(event) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  var dispatchListener = event._dispatchListeners;\n  var dispatchID = event._dispatchIDs;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !Array.isArray(dispatchListener),\n    &apos;executeDirectDispatch(...): Invalid `event`.&apos;\n  ) : invariant(!Array.isArray(dispatchListener)));\n  var res = dispatchListener ?\n    dispatchListener(event, dispatchID) :\n    null;\n  event._dispatchListeners = null;\n  event._dispatchIDs = null;\n  return res;\n}\n\n/**\n * @param {SyntheticEvent} event\n * @return {bool} True iff number of dispatches accumulated is greater than 0.\n */\nfunction hasDispatches(event) {\n  return !!event._dispatchListeners;\n}\n\n/**\n * General utilities that are useful in creating custom Event Plugins.\n */\nvar EventPluginUtils = {\n  isEndish: isEndish,\n  isMoveish: isMoveish,\n  isStartish: isStartish,\n\n  executeDirectDispatch: executeDirectDispatch,\n  executeDispatch: executeDispatch,\n  executeDispatchesInOrder: executeDispatchesInOrder,\n  executeDispatchesInOrderStopAtTrue: executeDispatchesInOrderStopAtTrue,\n  hasDispatches: hasDispatches,\n  injection: injection,\n  useTouchEvents: false\n};\n\nmodule.exports = EventPluginUtils;\n\n},{&quot;./EventConstants&quot;:14,&quot;./invariant&quot;:108}],19:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPropagators\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\n\nvar accumulate = require(&quot;./accumulate&quot;);\nvar forEachAccumulated = require(&quot;./forEachAccumulated&quot;);\n\nvar PropagationPhases = EventConstants.PropagationPhases;\nvar getListener = EventPluginHub.getListener;\n\n/**\n * Some event types have a notion of different registration names for different\n * &quot;phases&quot; of propagation. This finds listeners by a given phase.\n */\nfunction listenerAtPhase(id, event, propagationPhase) {\n  var registrationName =\n    event.dispatchConfig.phasedRegistrationNames[propagationPhase];\n  return getListener(id, registrationName);\n}\n\n/**\n * Tags a `SyntheticEvent` with dispatched listeners. Creating this function\n * here, allows us to not have to bind or create functions for each event.\n * Mutating the event&apos;s members allows us to not have to create a wrapping\n * &quot;dispatch&quot; object that pairs the event with the listener.\n */\nfunction accumulateDirectionalDispatches(domID, upwards, event) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (!domID) {\n      throw new Error(&apos;Dispatching id must not be null&apos;);\n    }\n  }\n  var phase = upwards ? PropagationPhases.bubbled : PropagationPhases.captured;\n  var listener = listenerAtPhase(domID, event, phase);\n  if (listener) {\n    event._dispatchListeners = accumulate(event._dispatchListeners, listener);\n    event._dispatchIDs = accumulate(event._dispatchIDs, domID);\n  }\n}\n\n/**\n * Collect dispatches (must be entirely collected before dispatching - see unit\n * tests). Lazily allocate the array to conserve memory.  We must loop through\n * each event and perform the traversal for each one. We can not perform a\n * single traversal for the entire collection of events because each event may\n * have a different target.\n */\nfunction accumulateTwoPhaseDispatchesSingle(event) {\n  if (event &amp;&amp; event.dispatchConfig.phasedRegistrationNames) {\n    EventPluginHub.injection.getInstanceHandle().traverseTwoPhase(\n      event.dispatchMarker,\n      accumulateDirectionalDispatches,\n      event\n    );\n  }\n}\n\n\n/**\n * Accumulates without regard to direction, does not look for phased\n * registration names. Same as `accumulateDirectDispatchesSingle` but without\n * requiring that the `dispatchMarker` be the same as the dispatched ID.\n */\nfunction accumulateDispatches(id, ignoredDirection, event) {\n  if (event &amp;&amp; event.dispatchConfig.registrationName) {\n    var registrationName = event.dispatchConfig.registrationName;\n    var listener = getListener(id, registrationName);\n    if (listener) {\n      event._dispatchListeners = accumulate(event._dispatchListeners, listener);\n      event._dispatchIDs = accumulate(event._dispatchIDs, id);\n    }\n  }\n}\n\n/**\n * Accumulates dispatches on an `SyntheticEvent`, but only for the\n * `dispatchMarker`.\n * @param {SyntheticEvent} event\n */\nfunction accumulateDirectDispatchesSingle(event) {\n  if (event &amp;&amp; event.dispatchConfig.registrationName) {\n    accumulateDispatches(event.dispatchMarker, null, event);\n  }\n}\n\nfunction accumulateTwoPhaseDispatches(events) {\n  forEachAccumulated(events, accumulateTwoPhaseDispatchesSingle);\n}\n\nfunction accumulateEnterLeaveDispatches(leave, enter, fromID, toID) {\n  EventPluginHub.injection.getInstanceHandle().traverseEnterLeave(\n    fromID,\n    toID,\n    accumulateDispatches,\n    leave,\n    enter\n  );\n}\n\n\nfunction accumulateDirectDispatches(events) {\n  forEachAccumulated(events, accumulateDirectDispatchesSingle);\n}\n\n\n\n/**\n * A small set of propagation patterns, each of which will accept a small amount\n * of information, and generate a set of &quot;dispatch ready event objects&quot; - which\n * are sets of events that have already been annotated with a set of dispatched\n * listener functions/ids. The API is designed this way to discourage these\n * propagation strategies from actually executing the dispatches, since we\n * always want to collect the entire set of dispatches before executing event a\n * single one.\n *\n * @constructor EventPropagators\n */\nvar EventPropagators = {\n  accumulateTwoPhaseDispatches: accumulateTwoPhaseDispatches,\n  accumulateDirectDispatches: accumulateDirectDispatches,\n  accumulateEnterLeaveDispatches: accumulateEnterLeaveDispatches\n};\n\nmodule.exports = EventPropagators;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginHub&quot;:16,&quot;./accumulate&quot;:86,&quot;./forEachAccumulated&quot;:98}],20:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ExecutionEnvironment\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar canUseDOM = typeof window !== &apos;undefined&apos;;\n\n/**\n * Simple, lightweight module assisting with the detection and context of\n * Worker. Helps avoid circular dependencies and allows code to reason about\n * whether or not they are in a Worker, even if they never include the main\n * `ReactWorker` dependency.\n */\nvar ExecutionEnvironment = {\n\n  canUseDOM: canUseDOM,\n\n  canUseWorkers: typeof Worker !== &apos;undefined&apos;,\n\n  canUseEventListeners:\n    canUseDOM &amp;&amp; (window.addEventListener || window.attachEvent),\n\n  isInWorker: !canUseDOM // For now, this is true - might change in the future.\n\n};\n\nmodule.exports = ExecutionEnvironment;\n\n},{}],21:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule LinkedValueUtils\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactPropTypes = require(&quot;./ReactPropTypes&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar hasReadOnlyValue = {\n  &apos;button&apos;: true,\n  &apos;checkbox&apos;: true,\n  &apos;image&apos;: true,\n  &apos;hidden&apos;: true,\n  &apos;radio&apos;: true,\n  &apos;reset&apos;: true,\n  &apos;submit&apos;: true\n};\n\nfunction _assertSingleLink(input) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      input.props.checkedLink == null || input.props.valueLink == null,\n      &apos;Cannot provide a checkedLink and a valueLink. If you want to use &apos; +\n      &apos;checkedLink, you probably don\\&apos;t want to use valueLink and vice versa.&apos;\n  ) : invariant(input.props.checkedLink == null || input.props.valueLink == null));\n}\nfunction _assertValueLink(input) {\n  _assertSingleLink(input);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    input.props.value == null &amp;&amp; input.props.onChange == null,\n    &apos;Cannot provide a valueLink and a value or onChange event. If you want &apos; +\n    &apos;to use value or onChange, you probably don\\&apos;t want to use valueLink.&apos;\n  ) : invariant(input.props.value == null &amp;&amp; input.props.onChange == null));\n}\n\nfunction _assertCheckedLink(input) {\n  _assertSingleLink(input);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    input.props.checked == null &amp;&amp; input.props.onChange == null,\n    &apos;Cannot provide a checkedLink and a checked property or onChange event. &apos; +\n    &apos;If you want to use checked or onChange, you probably don\\&apos;t want to &apos; +\n    &apos;use checkedLink&apos;\n  ) : invariant(input.props.checked == null &amp;&amp; input.props.onChange == null));\n}\n\n/**\n * @param {SyntheticEvent} e change event to handle\n */\nfunction _handleLinkedValueChange(e) {\n  /*jshint validthis:true */\n  this.props.valueLink.requestChange(e.target.value);\n}\n\n/**\n  * @param {SyntheticEvent} e change event to handle\n  */\nfunction _handleLinkedCheckChange(e) {\n  /*jshint validthis:true */\n  this.props.checkedLink.requestChange(e.target.checked);\n}\n\n/**\n * Provide a linked `value` attribute for controlled forms. You should not use\n * this outside of the ReactDOM controlled form components.\n */\nvar LinkedValueUtils = {\n  Mixin: {\n    propTypes: {\n      value: function(props, propName, componentName) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          if (props[propName] &amp;&amp;\n              !hasReadOnlyValue[props.type] &amp;&amp;\n              !props.onChange &amp;&amp;\n              !props.readOnly &amp;&amp;\n              !props.disabled) {\n            console.warn(\n              &apos;You provided a `value` prop to a form field without an &apos; +\n              &apos;`onChange` handler. This will render a read-only field. If &apos; +\n              &apos;the field should be mutable use `defaultValue`. Otherwise, &apos; +\n              &apos;set either `onChange` or `readOnly`.&apos;\n            );\n          }\n        }\n      },\n      checked: function(props, propName, componentName) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          if (props[propName] &amp;&amp;\n              !props.onChange &amp;&amp;\n              !props.readOnly &amp;&amp;\n              !props.disabled) {\n            console.warn(\n              &apos;You provided a `checked` prop to a form field without an &apos; +\n              &apos;`onChange` handler. This will render a read-only field. If &apos; +\n              &apos;the field should be mutable use `defaultChecked`. Otherwise, &apos; +\n              &apos;set either `onChange` or `readOnly`.&apos;\n            );\n          }\n        }\n      },\n      onChange: ReactPropTypes.func\n    }\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {*} current value of the input either from value prop or link.\n   */\n  getValue: function(input) {\n    if (input.props.valueLink) {\n      _assertValueLink(input);\n      return input.props.valueLink.value;\n    }\n    return input.props.value;\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {*} current checked status of the input either from checked prop\n   *             or link.\n   */\n  getChecked: function(input) {\n    if (input.props.checkedLink) {\n      _assertCheckedLink(input);\n      return input.props.checkedLink.value;\n    }\n    return input.props.checked;\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {function} change callback either from onChange prop or link.\n   */\n  getOnChange: function(input) {\n    if (input.props.valueLink) {\n      _assertValueLink(input);\n      return _handleLinkedValueChange;\n    } else if (input.props.checkedLink) {\n      _assertCheckedLink(input);\n      return _handleLinkedCheckChange;\n    }\n    return input.props.onChange;\n  }\n};\n\nmodule.exports = LinkedValueUtils;\n\n},{&quot;./ReactPropTypes&quot;:64,&quot;./invariant&quot;:108}],22:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule MobileSafariClickEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\n/**\n * Mobile Safari does not fire properly bubble click events on non-interactive\n * elements, which means delegated click listeners do not fire. The workaround\n * for this bug involves attaching an empty click listener on the target node.\n *\n * This particular plugin works around the bug by attaching an empty click\n * listener on `touchstart` (which does fire on every element).\n */\nvar MobileSafariClickEventPlugin = {\n\n  eventTypes: null,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    if (topLevelType === topLevelTypes.topTouchStart) {\n      var target = nativeEvent.target;\n      if (target &amp;&amp; !target.onclick) {\n        target.onclick = emptyFunction;\n      }\n    }\n  }\n\n};\n\nmodule.exports = MobileSafariClickEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./emptyFunction&quot;:95}],23:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule PooledClass\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Static poolers. Several custom versions for each potential number of\n * arguments. A completely generic pooler is easy to implement, but would\n * require accessing the `arguments` object. In each of these, `this` refers to\n * the Class itself, not an instance. If any others are needed, simply add them\n * here, or in their own files.\n */\nvar oneArgumentPooler = function(copyFieldsFrom) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, copyFieldsFrom);\n    return instance;\n  } else {\n    return new Klass(copyFieldsFrom);\n  }\n};\n\nvar twoArgumentPooler = function(a1, a2) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2);\n    return instance;\n  } else {\n    return new Klass(a1, a2);\n  }\n};\n\nvar threeArgumentPooler = function(a1, a2, a3) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2, a3);\n    return instance;\n  } else {\n    return new Klass(a1, a2, a3);\n  }\n};\n\nvar fiveArgumentPooler = function(a1, a2, a3, a4, a5) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2, a3, a4, a5);\n    return instance;\n  } else {\n    return new Klass(a1, a2, a3, a4, a5);\n  }\n};\n\nvar standardReleaser = function(instance) {\n  var Klass = this;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    instance instanceof Klass,\n    &apos;Trying to release an instance into a pool of a different type.&apos;\n  ) : invariant(instance instanceof Klass));\n  if (instance.destructor) {\n    instance.destructor();\n  }\n  if (Klass.instancePool.length &lt; Klass.poolSize) {\n    Klass.instancePool.push(instance);\n  }\n};\n\nvar DEFAULT_POOL_SIZE = 10;\nvar DEFAULT_POOLER = oneArgumentPooler;\n\n/**\n * Augments `CopyConstructor` to be a poolable class, augmenting only the class\n * itself (statically) not adding any prototypical fields. Any CopyConstructor\n * you give this may have a `poolSize` property, and will look for a\n * prototypical `destructor` on instances (optional).\n *\n * @param {Function} CopyConstructor Constructor that can be used to reset.\n * @param {Function} pooler Customizable pooler.\n */\nvar addPoolingTo = function(CopyConstructor, pooler) {\n  var NewKlass = CopyConstructor;\n  NewKlass.instancePool = [];\n  NewKlass.getPooled = pooler || DEFAULT_POOLER;\n  if (!NewKlass.poolSize) {\n    NewKlass.poolSize = DEFAULT_POOL_SIZE;\n  }\n  NewKlass.release = standardReleaser;\n  return NewKlass;\n};\n\nvar PooledClass = {\n  addPoolingTo: addPoolingTo,\n  oneArgumentPooler: oneArgumentPooler,\n  twoArgumentPooler: twoArgumentPooler,\n  threeArgumentPooler: threeArgumentPooler,\n  fiveArgumentPooler: fiveArgumentPooler\n};\n\nmodule.exports = PooledClass;\n\n},{&quot;./invariant&quot;:108}],24:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule React\n */\n\n&quot;use strict&quot;;\n\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar ReactChildren = require(&quot;./ReactChildren&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactContext = require(&quot;./ReactContext&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactDOMComponent = require(&quot;./ReactDOMComponent&quot;);\nvar ReactDefaultInjection = require(&quot;./ReactDefaultInjection&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactMultiChild = require(&quot;./ReactMultiChild&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactPropTypes = require(&quot;./ReactPropTypes&quot;);\nvar ReactServerRendering = require(&quot;./ReactServerRendering&quot;);\nvar ReactTextComponent = require(&quot;./ReactTextComponent&quot;);\n\nvar onlyChild = require(&quot;./onlyChild&quot;);\n\nReactDefaultInjection.inject();\n\nvar React = {\n  Children: {\n    map: ReactChildren.map,\n    forEach: ReactChildren.forEach,\n    only: onlyChild\n  },\n  DOM: ReactDOM,\n  PropTypes: ReactPropTypes,\n  initializeTouchEvents: function(shouldUseTouch) {\n    EventPluginUtils.useTouchEvents = shouldUseTouch;\n  },\n  createClass: ReactCompositeComponent.createClass,\n  constructAndRenderComponent: ReactMount.constructAndRenderComponent,\n  constructAndRenderComponentByID: ReactMount.constructAndRenderComponentByID,\n  renderComponent: ReactPerf.measure(\n    &apos;React&apos;,\n    &apos;renderComponent&apos;,\n    ReactMount.renderComponent\n  ),\n  renderComponentToString: ReactServerRendering.renderComponentToString,\n  unmountComponentAtNode: ReactMount.unmountComponentAtNode,\n  isValidClass: ReactCompositeComponent.isValidClass,\n  isValidComponent: ReactComponent.isValidComponent,\n  withContext: ReactContext.withContext,\n  __internals: {\n    Component: ReactComponent,\n    CurrentOwner: ReactCurrentOwner,\n    DOMComponent: ReactDOMComponent,\n    DOMPropertyOperations: DOMPropertyOperations,\n    InstanceHandles: ReactInstanceHandles,\n    Mount: ReactMount,\n    MultiChild: ReactMultiChild,\n    TextComponent: ReactTextComponent\n  }\n};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  var ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n  if (ExecutionEnvironment.canUseDOM &amp;&amp;\n      window.top === window.self &amp;&amp;\n      navigator.userAgent.indexOf(&apos;Chrome&apos;) &gt; -1) {\n    console.debug(\n      &apos;Download the React DevTools for a better development experience: &apos; +\n      &apos;http://fb.me/react-devtools&apos;\n    );\n  }\n}\n\n// Version exists only in the open-source version of React, not in Facebook&apos;s\n// internal version.\nReact.version = &apos;0.9.0&apos;;\n\nmodule.exports = React;\n\n},{&quot;./DOMPropertyOperations&quot;:9,&quot;./EventPluginUtils&quot;:18,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactChildren&quot;:25,&quot;./ReactComponent&quot;:26,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactContext&quot;:30,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactDOM&quot;:32,&quot;./ReactDOMComponent&quot;:34,&quot;./ReactDefaultInjection&quot;:44,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./ReactMultiChild&quot;:57,&quot;./ReactPerf&quot;:60,&quot;./ReactPropTypes&quot;:64,&quot;./ReactServerRendering&quot;:68,&quot;./ReactTextComponent&quot;:69,&quot;./onlyChild&quot;:123}],25:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactChildren\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar traverseAllChildren = require(&quot;./traverseAllChildren&quot;);\n\nvar twoArgumentPooler = PooledClass.twoArgumentPooler;\nvar threeArgumentPooler = PooledClass.threeArgumentPooler;\n\n/**\n * PooledClass representing the bookkeeping associated with performing a child\n * traversal. Allows avoiding binding callbacks.\n *\n * @constructor ForEachBookKeeping\n * @param {!function} forEachFunction Function to perform traversal with.\n * @param {?*} forEachContext Context to perform context with.\n */\nfunction ForEachBookKeeping(forEachFunction, forEachContext) {\n  this.forEachFunction = forEachFunction;\n  this.forEachContext = forEachContext;\n}\nPooledClass.addPoolingTo(ForEachBookKeeping, twoArgumentPooler);\n\nfunction forEachSingleChild(traverseContext, child, name, i) {\n  var forEachBookKeeping = traverseContext;\n  forEachBookKeeping.forEachFunction.call(\n    forEachBookKeeping.forEachContext, child, i);\n}\n\n/**\n * Iterates through children that are typically specified as `props.children`.\n *\n * The provided forEachFunc(child, index) will be called for each\n * leaf child.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} forEachFunc.\n * @param {*} forEachContext Context for forEachContext.\n */\nfunction forEachChildren(children, forEachFunc, forEachContext) {\n  if (children == null) {\n    return children;\n  }\n\n  var traverseContext =\n    ForEachBookKeeping.getPooled(forEachFunc, forEachContext);\n  traverseAllChildren(children, forEachSingleChild, traverseContext);\n  ForEachBookKeeping.release(traverseContext);\n}\n\n/**\n * PooledClass representing the bookkeeping associated with performing a child\n * mapping. Allows avoiding binding callbacks.\n *\n * @constructor MapBookKeeping\n * @param {!*} mapResult Object containing the ordered map of results.\n * @param {!function} mapFunction Function to perform mapping with.\n * @param {?*} mapContext Context to perform mapping with.\n */\nfunction MapBookKeeping(mapResult, mapFunction, mapContext) {\n  this.mapResult = mapResult;\n  this.mapFunction = mapFunction;\n  this.mapContext = mapContext;\n}\nPooledClass.addPoolingTo(MapBookKeeping, threeArgumentPooler);\n\nfunction mapSingleChildIntoContext(traverseContext, child, name, i) {\n  var mapBookKeeping = traverseContext;\n  var mapResult = mapBookKeeping.mapResult;\n  var mappedChild =\n    mapBookKeeping.mapFunction.call(mapBookKeeping.mapContext, child, i);\n  // We found a component instance\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !mapResult.hasOwnProperty(name),\n    &apos;ReactChildren.map(...): Encountered two children with the same key, &apos; +\n    &apos;`%s`. Children keys must be unique.&apos;,\n    name\n  ) : invariant(!mapResult.hasOwnProperty(name)));\n  mapResult[name] = mappedChild;\n}\n\n/**\n * Maps children that are typically specified as `props.children`.\n *\n * The provided mapFunction(child, key, index) will be called for each\n * leaf child.\n *\n * TODO: This may likely break any calls to `ReactChildren.map` that were\n * previously relying on the fact that we guarded against null children.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} mapFunction.\n * @param {*} mapContext Context for mapFunction.\n * @return {object} Object containing the ordered map of results.\n */\nfunction mapChildren(children, func, context) {\n  if (children == null) {\n    return children;\n  }\n\n  var mapResult = {};\n  var traverseContext = MapBookKeeping.getPooled(mapResult, func, context);\n  traverseAllChildren(children, mapSingleChildIntoContext, traverseContext);\n  MapBookKeeping.release(traverseContext);\n  return mapResult;\n}\n\nvar ReactChildren = {\n  forEach: forEachChildren,\n  map: mapChildren\n};\n\nmodule.exports = ReactChildren;\n\n},{&quot;./PooledClass&quot;:23,&quot;./invariant&quot;:108,&quot;./traverseAllChildren&quot;:128}],26:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponent\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponentEnvironment = require(&quot;./ReactComponentEnvironment&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactOwner = require(&quot;./ReactOwner&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Every React component is in one of these life cycles.\n */\nvar ComponentLifeCycle = keyMirror({\n  /**\n   * Mounted components have a DOM node representation and are capable of\n   * receiving new props.\n   */\n  MOUNTED: null,\n  /**\n   * Unmounted components are inactive and cannot receive new props.\n   */\n  UNMOUNTED: null\n});\n\n/**\n * Warn if there&apos;s no key explicitly set on dynamic arrays of children or\n * object keys are not valid. This allows us to keep track of children between\n * updates.\n */\n\nvar ownerHasExplicitKeyWarning = {};\nvar ownerHasPropertyWarning = {};\n\nvar NUMERIC_PROPERTY_REGEX = /^\\d+$/;\n\n/**\n * Warn if the component doesn&apos;t have an explicit key assigned to it.\n * This component is in an array. The array could grow and shrink or be\n * reordered. All children that haven&apos;t already been validated are required to\n * have a &quot;key&quot; property assigned to it.\n *\n * @internal\n * @param {ReactComponent} component Component that requires a key.\n */\nfunction validateExplicitKey(component) {\n  if (component.__keyValidated__ || component.props.key != null) {\n    return;\n  }\n  component.__keyValidated__ = true;\n\n  // We can&apos;t provide friendly warnings for top level components.\n  if (!ReactCurrentOwner.current) {\n    return;\n  }\n\n  // Name of the component whose render method tried to pass children.\n  var currentName = ReactCurrentOwner.current.constructor.displayName;\n  if (ownerHasExplicitKeyWarning.hasOwnProperty(currentName)) {\n    return;\n  }\n  ownerHasExplicitKeyWarning[currentName] = true;\n\n  var message = &apos;Each child in an array should have a unique &quot;key&quot; prop. &apos; +\n                &apos;Check the render method of &apos; + currentName + &apos;.&apos;;\n  if (!component.isOwnedBy(ReactCurrentOwner.current)) {\n    // Name of the component that originally created this child.\n    var childOwnerName =\n      component._owner &amp;&amp;\n      component._owner.constructor.displayName;\n\n    // Usually the current owner is the offender, but if it accepts\n    // children as a property, it may be the creator of the child that&apos;s\n    // responsible for assigning it a key.\n    message += &apos; It was passed a child from &apos; + childOwnerName + &apos;.&apos;;\n  }\n\n  message += &apos; See http://fb.me/react-warning-keys for more information.&apos;;\n  console.warn(message);\n}\n\n/**\n * Warn if the key is being defined as an object property but has an incorrect\n * value.\n *\n * @internal\n * @param {string} name Property name of the key.\n * @param {ReactComponent} component Component that requires a key.\n */\nfunction validatePropertyKey(name) {\n  if (NUMERIC_PROPERTY_REGEX.test(name)) {\n    // Name of the component whose render method tried to pass children.\n    var currentName = ReactCurrentOwner.current.constructor.displayName;\n    if (ownerHasPropertyWarning.hasOwnProperty(currentName)) {\n      return;\n    }\n    ownerHasPropertyWarning[currentName] = true;\n\n    console.warn(\n      &apos;Child objects should have non-numeric keys so ordering is preserved. &apos; +\n      &apos;Check the render method of &apos; + currentName + &apos;. &apos; +\n      &apos;See http://fb.me/react-warning-keys for more information.&apos;\n    );\n  }\n}\n\n/**\n * Ensure that every component either is passed in a static location, in an\n * array with an explicit keys property defined, or in an object literal\n * with valid key property.\n *\n * @internal\n * @param {*} component Statically passed child of any type.\n * @return {boolean}\n */\nfunction validateChildKeys(component) {\n  if (Array.isArray(component)) {\n    for (var i = 0; i &lt; component.length; i++) {\n      var child = component[i];\n      if (ReactComponent.isValidComponent(child)) {\n        validateExplicitKey(child);\n      }\n    }\n  } else if (ReactComponent.isValidComponent(component)) {\n    // This component was passed in a valid location.\n    component.__keyValidated__ = true;\n  } else if (component &amp;&amp; typeof component === &apos;object&apos;) {\n    for (var name in component) {\n      validatePropertyKey(name, component);\n    }\n  }\n}\n\n/**\n * Components are the basic units of composition in React.\n *\n * Every component accepts a set of keyed input parameters known as &quot;props&quot; that\n * are initialized by the constructor. Once a component is mounted, the props\n * can be mutated using `setProps` or `replaceProps`.\n *\n * Every component is capable of the following operations:\n *\n *   `mountComponent`\n *     Initializes the component, renders markup, and registers event listeners.\n *\n *   `receiveComponent`\n *     Updates the rendered DOM nodes to match the given component.\n *\n *   `unmountComponent`\n *     Releases any resources allocated by this component.\n *\n * Components can also be &quot;owned&quot; by other components. Being owned by another\n * component means being constructed by that component. This is different from\n * being the child of a component, which means having a DOM representation that\n * is a child of the DOM representation of that component.\n *\n * @class ReactComponent\n */\nvar ReactComponent = {\n\n  /**\n   * @param {?object} object\n   * @return {boolean} True if `object` is a valid component.\n   * @final\n   */\n  isValidComponent: function(object) {\n    if (!object || !object.type || !object.type.prototype) {\n      return false;\n    }\n    // This is the safer way of duck checking the type of instance this is.\n    // The object can be a generic descriptor but the type property refers to\n    // the constructor and it&apos;s prototype can be used to inspect the type that\n    // will actually get mounted.\n    var prototype = object.type.prototype;\n    return (\n      typeof prototype.mountComponentIntoNode === &apos;function&apos; &amp;&amp;\n      typeof prototype.receiveComponent === &apos;function&apos;\n    );\n  },\n\n  /**\n   * @internal\n   */\n  LifeCycle: ComponentLifeCycle,\n\n  /**\n   * Injected module that provides ability to mutate individual properties.\n   * Injected into the base class because many different subclasses need access\n   * to this.\n   *\n   * @internal\n   */\n  BackendIDOperations: ReactComponentEnvironment.BackendIDOperations,\n\n  /**\n   * Optionally injectable environment dependent cleanup hook. (server vs.\n   * browser etc). Example: A browser system caches DOM nodes based on component\n   * ID and must remove that cache entry when this instance is unmounted.\n   *\n   * @private\n   */\n  unmountIDFromEnvironment: ReactComponentEnvironment.unmountIDFromEnvironment,\n\n  /**\n   * The &quot;image&quot; of a component tree, is the platform specific (typically\n   * serialized) data that represents a tree of lower level UI building blocks.\n   * On the web, this &quot;image&quot; is HTML markup which describes a construction of\n   * low level `div` and `span` nodes. Other platforms may have different\n   * encoding of this &quot;image&quot;. This must be injected.\n   *\n   * @private\n   */\n  mountImageIntoNode: ReactComponentEnvironment.mountImageIntoNode,\n\n  /**\n   * React references `ReactReconcileTransaction` using this property in order\n   * to allow dependency injection.\n   *\n   * @internal\n   */\n  ReactReconcileTransaction:\n    ReactComponentEnvironment.ReactReconcileTransaction,\n\n  /**\n   * Base functionality for every ReactComponent constructor. Mixed into the\n   * `ReactComponent` prototype, but exposed statically for easy access.\n   *\n   * @lends {ReactComponent.prototype}\n   */\n  Mixin: merge(ReactComponentEnvironment.Mixin, {\n\n    /**\n     * Checks whether or not this component is mounted.\n     *\n     * @return {boolean} True if mounted, false otherwise.\n     * @final\n     * @protected\n     */\n    isMounted: function() {\n      return this._lifeCycleState === ComponentLifeCycle.MOUNTED;\n    },\n\n    /**\n     * Sets a subset of the props.\n     *\n     * @param {object} partialProps Subset of the next props.\n     * @param {?function} callback Called after props are updated.\n     * @final\n     * @public\n     */\n    setProps: function(partialProps, callback) {\n      // Merge with `_pendingProps` if it exists, otherwise with existing props.\n      this.replaceProps(\n        merge(this._pendingProps || this.props, partialProps),\n        callback\n      );\n    },\n\n    /**\n     * Replaces all of the props.\n     *\n     * @param {object} props New props.\n     * @param {?function} callback Called after props are updated.\n     * @final\n     * @public\n     */\n    replaceProps: function(props, callback) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;replaceProps(...): Can only update a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this._mountDepth === 0,\n        &apos;replaceProps(...): You called `setProps` or `replaceProps` on a &apos; +\n        &apos;component with a parent. This is an anti-pattern since props will &apos; +\n        &apos;get reactively updated when rendered. Instead, change the owner\\&apos;s &apos; +\n        &apos;`render` method to pass the correct value as props to the component &apos; +\n        &apos;where it is created.&apos;\n      ) : invariant(this._mountDepth === 0));\n      this._pendingProps = props;\n      ReactUpdates.enqueueUpdate(this, callback);\n    },\n\n    /**\n     * Base constructor for all React components.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.construct.call(this, ...)`.\n     *\n     * @param {?object} initialProps\n     * @param {*} children\n     * @internal\n     */\n    construct: function(initialProps, children) {\n      this.props = initialProps || {};\n      // Record the component responsible for creating this component.\n      this._owner = ReactCurrentOwner.current;\n      // All components start unmounted.\n      this._lifeCycleState = ComponentLifeCycle.UNMOUNTED;\n\n      this._pendingProps = null;\n      this._pendingCallbacks = null;\n\n      // Unlike _pendingProps and _pendingCallbacks, we won&apos;t use null to\n      // indicate that nothing is pending because it&apos;s possible for a component\n      // to have a null owner. Instead, an owner change is pending when\n      // this._owner !== this._pendingOwner.\n      this._pendingOwner = this._owner;\n\n      // Children can be more than one argument\n      var childrenLength = arguments.length - 1;\n      if (childrenLength === 1) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          validateChildKeys(children);\n        }\n        this.props.children = children;\n      } else if (childrenLength &gt; 1) {\n        var childArray = Array(childrenLength);\n        for (var i = 0; i &lt; childrenLength; i++) {\n          if (&quot;production&quot; !== &quot;development&quot;) {\n            validateChildKeys(arguments[i + 1]);\n          }\n          childArray[i] = arguments[i + 1];\n        }\n        this.props.children = childArray;\n      }\n    },\n\n    /**\n     * Initializes the component, renders markup, and registers event listeners.\n     *\n     * NOTE: This does not insert any nodes into the DOM.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.mountComponent.call(this, ...)`.\n     *\n     * @param {string} rootID DOM ID of the root node.\n     * @param {ReactReconcileTransaction} transaction\n     * @param {number} mountDepth number of components in the owner hierarchy.\n     * @return {?string} Rendered markup to be inserted into the DOM.\n     * @internal\n     */\n    mountComponent: function(rootID, transaction, mountDepth) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !this.isMounted(),\n        &apos;mountComponent(%s, ...): Can only mount an unmounted component. &apos; +\n        &apos;Make sure to avoid storing components between renders or reusing a &apos; +\n        &apos;single component instance in multiple places.&apos;,\n        rootID\n      ) : invariant(!this.isMounted()));\n      var props = this.props;\n      if (props.ref != null) {\n        ReactOwner.addComponentAsRefTo(this, props.ref, this._owner);\n      }\n      this._rootNodeID = rootID;\n      this._lifeCycleState = ComponentLifeCycle.MOUNTED;\n      this._mountDepth = mountDepth;\n      // Effectively: return &apos;&apos;;\n    },\n\n    /**\n     * Releases any resources allocated by `mountComponent`.\n     *\n     * NOTE: This does not remove any nodes from the DOM.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.unmountComponent.call(this)`.\n     *\n     * @internal\n     */\n    unmountComponent: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;unmountComponent(): Can only unmount a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      var props = this.props;\n      if (props.ref != null) {\n        ReactOwner.removeComponentAsRefFrom(this, props.ref, this._owner);\n      }\n      ReactComponent.unmountIDFromEnvironment(this._rootNodeID);\n      this._rootNodeID = null;\n      this._lifeCycleState = ComponentLifeCycle.UNMOUNTED;\n    },\n\n    /**\n     * Given a new instance of this component, updates the rendered DOM nodes\n     * as if that instance was rendered instead.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.receiveComponent.call(this, ...)`.\n     *\n     * @param {object} nextComponent Next set of properties.\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    receiveComponent: function(nextComponent, transaction) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;receiveComponent(...): Can only update a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      this._pendingOwner = nextComponent._owner;\n      this._pendingProps = nextComponent.props;\n      this._performUpdateIfNecessary(transaction);\n    },\n\n    /**\n     * Call `_performUpdateIfNecessary` within a new transaction.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    performUpdateIfNecessary: function() {\n      var transaction = ReactComponent.ReactReconcileTransaction.getPooled();\n      transaction.perform(this._performUpdateIfNecessary, this, transaction);\n      ReactComponent.ReactReconcileTransaction.release(transaction);\n    },\n\n    /**\n     * If `_pendingProps` is set, update the component.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    _performUpdateIfNecessary: function(transaction) {\n      if (this._pendingProps == null) {\n        return;\n      }\n      var prevProps = this.props;\n      var prevOwner = this._owner;\n      this.props = this._pendingProps;\n      this._owner = this._pendingOwner;\n      this._pendingProps = null;\n      this.updateComponent(transaction, prevProps, prevOwner);\n    },\n\n    /**\n     * Updates the component&apos;s currently mounted representation.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @param {object} prevProps\n     * @internal\n     */\n    updateComponent: function(transaction, prevProps, prevOwner) {\n      var props = this.props;\n      // If either the owner or a `ref` has changed, make sure the newest owner\n      // has stored a reference to `this`, and the previous owner (if different)\n      // has forgotten the reference to `this`.\n      if (this._owner !== prevOwner || props.ref !== prevProps.ref) {\n        if (prevProps.ref != null) {\n          ReactOwner.removeComponentAsRefFrom(\n            this, prevProps.ref, prevOwner\n          );\n        }\n        // Correct, even if the owner is the same, and only the ref has changed.\n        if (props.ref != null) {\n          ReactOwner.addComponentAsRefTo(this, props.ref, this._owner);\n        }\n      }\n    },\n\n    /**\n     * Mounts this component and inserts it into the DOM.\n     *\n     * @param {string} rootID DOM ID of the root node.\n     * @param {DOMElement} container DOM element to mount into.\n     * @param {boolean} shouldReuseMarkup If true, do not insert markup\n     * @final\n     * @internal\n     * @see {ReactMount.renderComponent}\n     */\n    mountComponentIntoNode: function(rootID, container, shouldReuseMarkup) {\n      var transaction = ReactComponent.ReactReconcileTransaction.getPooled();\n      transaction.perform(\n        this._mountComponentIntoNode,\n        this,\n        rootID,\n        container,\n        transaction,\n        shouldReuseMarkup\n      );\n      ReactComponent.ReactReconcileTransaction.release(transaction);\n    },\n\n    /**\n     * @param {string} rootID DOM ID of the root node.\n     * @param {DOMElement} container DOM element to mount into.\n     * @param {ReactReconcileTransaction} transaction\n     * @param {boolean} shouldReuseMarkup If true, do not insert markup\n     * @final\n     * @private\n     */\n    _mountComponentIntoNode: function(\n        rootID,\n        container,\n        transaction,\n        shouldReuseMarkup) {\n      var markup = this.mountComponent(rootID, transaction, 0);\n      ReactComponent.mountImageIntoNode(markup, container, shouldReuseMarkup);\n    },\n\n    /**\n     * Checks if this component is owned by the supplied `owner` component.\n     *\n     * @param {ReactComponent} owner Component to check.\n     * @return {boolean} True if `owners` owns this component.\n     * @final\n     * @internal\n     */\n    isOwnedBy: function(owner) {\n      return this._owner === owner;\n    },\n\n    /**\n     * Gets another component, that shares the same owner as this one, by ref.\n     *\n     * @param {string} ref of a sibling Component.\n     * @return {?ReactComponent} the actual sibling Component.\n     * @final\n     * @internal\n     */\n    getSiblingByRef: function(ref) {\n      var owner = this._owner;\n      if (!owner || !owner.refs) {\n        return null;\n      }\n      return owner.refs[ref];\n    }\n  })\n};\n\nmodule.exports = ReactComponent;\n\n},{&quot;./ReactComponentEnvironment&quot;:28,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactOwner&quot;:59,&quot;./ReactUpdates&quot;:70,&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114,&quot;./merge&quot;:117}],27:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponentBrowserEnvironment\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar ReactDOMIDOperations = require(&quot;./ReactDOMIDOperations&quot;);\nvar ReactMarkupChecksum = require(&quot;./ReactMarkupChecksum&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactReconcileTransaction = require(&quot;./ReactReconcileTransaction&quot;);\n\nvar getReactRootElementInContainer = require(&quot;./getReactRootElementInContainer&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\n\nvar ELEMENT_NODE_TYPE = 1;\nvar DOC_NODE_TYPE = 9;\n\n\n/**\n * Abstracts away all functionality of `ReactComponent` requires knowledge of\n * the browser context.\n */\nvar ReactComponentBrowserEnvironment = {\n  /**\n   * Mixed into every component instance.\n   */\n  Mixin: {\n    /**\n     * Returns the DOM node rendered by this component.\n     *\n     * @return {DOMElement} The root node of this component.\n     * @final\n     * @protected\n     */\n    getDOMNode: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;getDOMNode(): A component must be mounted to have a DOM node.&apos;\n      ) : invariant(this.isMounted()));\n      return ReactMount.getNode(this._rootNodeID);\n    }\n  },\n\n  ReactReconcileTransaction: ReactReconcileTransaction,\n\n  BackendIDOperations: ReactDOMIDOperations,\n\n  /**\n   * If a particular environment requires that some resources be cleaned up,\n   * specify this in the injected Mixin. In the DOM, we would likely want to\n   * purge any cached node ID lookups.\n   *\n   * @private\n   */\n  unmountIDFromEnvironment: function(rootNodeID) {\n    ReactMount.purgeID(rootNodeID);\n  },\n\n  /**\n   * @param {string} markup Markup string to place into the DOM Element.\n   * @param {DOMElement} container DOM Element to insert markup into.\n   * @param {boolean} shouldReuseMarkup Should reuse the existing markup in the\n   * container if possible.\n   */\n  mountImageIntoNode: ReactPerf.measure(\n    &apos;ReactComponentBrowserEnvironment&apos;,\n    &apos;mountImageIntoNode&apos;,\n    function(markup, container, shouldReuseMarkup) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        container &amp;&amp; (\n          container.nodeType === ELEMENT_NODE_TYPE ||\n            container.nodeType === DOC_NODE_TYPE\n        ),\n        &apos;mountComponentIntoNode(...): Target container is not valid.&apos;\n      ) : invariant(container &amp;&amp; (\n        container.nodeType === ELEMENT_NODE_TYPE ||\n          container.nodeType === DOC_NODE_TYPE\n      )));\n\n      if (shouldReuseMarkup) {\n        if (ReactMarkupChecksum.canReuseMarkup(\n          markup,\n          getReactRootElementInContainer(container))) {\n          return;\n        } else {\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            container.nodeType !== DOC_NODE_TYPE,\n            &apos;You\\&apos;re trying to render a component to the document using &apos; +\n            &apos;server rendering but the checksum was invalid. This usually &apos; +\n            &apos;means you rendered a different component type or props on &apos; +\n            &apos;the client from the one on the server, or your render() &apos; +\n            &apos;methods are impure. React cannot handle this case due to &apos; +\n            &apos;cross-browser quirks by rendering at the document root. You &apos; +\n            &apos;should look for environment dependent code in your components &apos; +\n            &apos;and ensure the props are the same client and server side.&apos;\n          ) : invariant(container.nodeType !== DOC_NODE_TYPE));\n\n          if (&quot;production&quot; !== &quot;development&quot;) {\n            console.warn(\n              &apos;React attempted to use reuse markup in a container but the &apos; +\n              &apos;checksum was invalid. This generally means that you are &apos; +\n              &apos;using server rendering and the markup generated on the &apos; +\n              &apos;server was not what the client was expecting. React injected&apos; +\n              &apos;new markup to compensate which works but you have lost many &apos; +\n              &apos;of the benefits of server rendering. Instead, figure out &apos; +\n              &apos;why the markup being generated is different on the client &apos; +\n              &apos;or server.&apos;\n            );\n          }\n        }\n      }\n\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        container.nodeType !== DOC_NODE_TYPE,\n        &apos;You\\&apos;re trying to render a component to the document but &apos; +\n          &apos;you didn\\&apos;t use server rendering. We can\\&apos;t do this &apos; +\n          &apos;without using server rendering due to cross-browser quirks. &apos; +\n          &apos;See renderComponentToString() for server rendering.&apos;\n      ) : invariant(container.nodeType !== DOC_NODE_TYPE));\n\n      // Asynchronously inject markup by ensuring that the container is not in\n      // the document when settings its `innerHTML`.\n      var parent = container.parentNode;\n      if (parent) {\n        var next = container.nextSibling;\n        parent.removeChild(container);\n        container.innerHTML = markup;\n        if (next) {\n          parent.insertBefore(container, next);\n        } else {\n          parent.appendChild(container);\n        }\n      } else {\n        container.innerHTML = markup;\n      }\n    }\n  )\n};\n\nmodule.exports = ReactComponentBrowserEnvironment;\n\n},{&quot;./ReactDOMIDOperations&quot;:36,&quot;./ReactMarkupChecksum&quot;:54,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./ReactReconcileTransaction&quot;:66,&quot;./getReactRootElementInContainer&quot;:104,&quot;./invariant&quot;:108}],28:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponentEnvironment\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponentBrowserEnvironment =\n  require(&quot;./ReactComponentBrowserEnvironment&quot;);\n\nvar ReactComponentEnvironment = ReactComponentBrowserEnvironment;\n\nmodule.exports = ReactComponentEnvironment;\n\n},{&quot;./ReactComponentBrowserEnvironment&quot;:27}],29:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactCompositeComponent\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactContext = require(&quot;./ReactContext&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactErrorUtils = require(&quot;./ReactErrorUtils&quot;);\nvar ReactOwner = require(&quot;./ReactOwner&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactPropTransferer = require(&quot;./ReactPropTransferer&quot;);\nvar ReactPropTypeLocations = require(&quot;./ReactPropTypeLocations&quot;);\nvar ReactPropTypeLocationNames = require(&quot;./ReactPropTypeLocationNames&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\nvar objMap = require(&quot;./objMap&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\n/**\n * Policies that describe methods in `ReactCompositeComponentInterface`.\n */\nvar SpecPolicy = keyMirror({\n  /**\n   * These methods may be defined only once by the class specification or mixin.\n   */\n  DEFINE_ONCE: null,\n  /**\n   * These methods may be defined by both the class specification and mixins.\n   * Subsequent definitions will be chained. These methods must return void.\n   */\n  DEFINE_MANY: null,\n  /**\n   * These methods are overriding the base ReactCompositeComponent class.\n   */\n  OVERRIDE_BASE: null,\n  /**\n   * These methods are similar to DEFINE_MANY, except we assume they return\n   * objects. We try to merge the keys of the return values of all the mixed in\n   * functions. If there is a key conflict we throw.\n   */\n  DEFINE_MANY_MERGED: null\n});\n\n/**\n * Composite components are higher-level components that compose other composite\n * or native components.\n *\n * To create a new type of `ReactCompositeComponent`, pass a specification of\n * your new class to `React.createClass`. The only requirement of your class\n * specification is that you implement a `render` method.\n *\n *   var MyComponent = React.createClass({\n *     render: function() {\n *       return &lt;div&gt;Hello World&lt;/div&gt;;\n *     }\n *   });\n *\n * The class specification supports a specific protocol of methods that have\n * special meaning (e.g. `render`). See `ReactCompositeComponentInterface` for\n * more the comprehensive protocol. Any other properties and methods in the\n * class specification will available on the prototype.\n *\n * @interface ReactCompositeComponentInterface\n * @internal\n */\nvar ReactCompositeComponentInterface = {\n\n  /**\n   * An array of Mixin objects to include when defining your component.\n   *\n   * @type {array}\n   * @optional\n   */\n  mixins: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * An object containing properties and methods that should be defined on\n   * the component&apos;s constructor instead of its prototype (static methods).\n   *\n   * @type {object}\n   * @optional\n   */\n  statics: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of prop types for this component.\n   *\n   * @type {object}\n   * @optional\n   */\n  propTypes: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of context types for this component.\n   *\n   * @type {object}\n   * @optional\n   */\n  contextTypes: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of context types this component sets for its children.\n   *\n   * @type {object}\n   * @optional\n   */\n  childContextTypes: SpecPolicy.DEFINE_MANY,\n\n  // ==== Definition methods ====\n\n  /**\n   * Invoked when the component is mounted. Values in the mapping will be set on\n   * `this.props` if that prop is not specified (i.e. using an `in` check).\n   *\n   * This method is invoked before `getInitialState` and therefore cannot rely\n   * on `this.state` or use `this.setState`.\n   *\n   * @return {object}\n   * @optional\n   */\n  getDefaultProps: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * Invoked once before the component is mounted. The return value will be used\n   * as the initial value of `this.state`.\n   *\n   *   getInitialState: function() {\n   *     return {\n   *       isOn: false,\n   *       fooBaz: new BazFoo()\n   *     }\n   *   }\n   *\n   * @return {object}\n   * @optional\n   */\n  getInitialState: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * @return {object}\n   * @optional\n   */\n  getChildContext: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * Uses props from `this.props` and state from `this.state` to render the\n   * structure of the component.\n   *\n   * No guarantees are made about when or how often this method is invoked, so\n   * it must not have side effects.\n   *\n   *   render: function() {\n   *     var name = this.props.name;\n   *     return &lt;div&gt;Hello, {name}!&lt;/div&gt;;\n   *   }\n   *\n   * @return {ReactComponent}\n   * @nosideeffects\n   * @required\n   */\n  render: SpecPolicy.DEFINE_ONCE,\n\n\n\n  // ==== Delegate methods ====\n\n  /**\n   * Invoked when the component is initially created and about to be mounted.\n   * This may have side effects, but any external subscriptions or data created\n   * by this method must be cleaned up in `componentWillUnmount`.\n   *\n   * @optional\n   */\n  componentWillMount: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component has been mounted and has a DOM representation.\n   * However, there is no guarantee that the DOM node is in the document.\n   *\n   * Use this as an opportunity to operate on the DOM when the component has\n   * been mounted (initialized and rendered) for the first time.\n   *\n   * @param {DOMElement} rootNode DOM element representing the component.\n   * @optional\n   */\n  componentDidMount: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked before the component receives new props.\n   *\n   * Use this as an opportunity to react to a prop transition by updating the\n   * state using `this.setState`. Current props are accessed via `this.props`.\n   *\n   *   componentWillReceiveProps: function(nextProps, nextContext) {\n   *     this.setState({\n   *       likesIncreasing: nextProps.likeCount &gt; this.props.likeCount\n   *     });\n   *   }\n   *\n   * NOTE: There is no equivalent `componentWillReceiveState`. An incoming prop\n   * transition may cause a state change, but the opposite is not true. If you\n   * need it, you are probably looking for `componentWillUpdate`.\n   *\n   * @param {object} nextProps\n   * @optional\n   */\n  componentWillReceiveProps: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked while deciding if the component should be updated as a result of\n   * receiving new props, state and/or context.\n   *\n   * Use this as an opportunity to `return false` when you&apos;re certain that the\n   * transition to the new props/state/context will not require a component\n   * update.\n   *\n   *   shouldComponentUpdate: function(nextProps, nextState, nextContext) {\n   *     return !equal(nextProps, this.props) ||\n   *       !equal(nextState, this.state) ||\n   *       !equal(nextContext, this.context);\n   *   }\n   *\n   * @param {object} nextProps\n   * @param {?object} nextState\n   * @param {?object} nextContext\n   * @return {boolean} True if the component should update.\n   * @optional\n   */\n  shouldComponentUpdate: SpecPolicy.DEFINE_ONCE,\n\n  /**\n   * Invoked when the component is about to update due to a transition from\n   * `this.props`, `this.state` and `this.context` to `nextProps`, `nextState`\n   * and `nextContext`.\n   *\n   * Use this as an opportunity to perform preparation before an update occurs.\n   *\n   * NOTE: You **cannot** use `this.setState()` in this method.\n   *\n   * @param {object} nextProps\n   * @param {?object} nextState\n   * @param {?object} nextContext\n   * @param {ReactReconcileTransaction} transaction\n   * @optional\n   */\n  componentWillUpdate: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component&apos;s DOM representation has been updated.\n   *\n   * Use this as an opportunity to operate on the DOM when the component has\n   * been updated.\n   *\n   * @param {object} prevProps\n   * @param {?object} prevState\n   * @param {?object} prevContext\n   * @param {DOMElement} rootNode DOM element representing the component.\n   * @optional\n   */\n  componentDidUpdate: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component is about to be removed from its parent and have\n   * its DOM representation destroyed.\n   *\n   * Use this as an opportunity to deallocate any external resources.\n   *\n   * NOTE: There is no `componentDidUnmount` since your component will have been\n   * destroyed by that point.\n   *\n   * @optional\n   */\n  componentWillUnmount: SpecPolicy.DEFINE_MANY,\n\n\n\n  // ==== Advanced methods ====\n\n  /**\n   * Updates the component&apos;s currently mounted DOM representation.\n   *\n   * By default, this implements React&apos;s rendering and reconciliation algorithm.\n   * Sophisticated clients may wish to override this.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   * @overridable\n   */\n  updateComponent: SpecPolicy.OVERRIDE_BASE\n\n};\n\n/**\n * Mapping from class specification keys to special processing functions.\n *\n * Although these are declared like instance properties in the specification\n * when defining classes using `React.createClass`, they are actually static\n * and are accessible on the constructor instead of the prototype. Despite\n * being static, they must be defined outside of the &quot;statics&quot; key under\n * which all other static methods are defined.\n */\nvar RESERVED_SPEC_KEYS = {\n  displayName: function(ConvenienceConstructor, displayName) {\n    ConvenienceConstructor.componentConstructor.displayName = displayName;\n  },\n  mixins: function(ConvenienceConstructor, mixins) {\n    if (mixins) {\n      for (var i = 0; i &lt; mixins.length; i++) {\n        mixSpecIntoComponent(ConvenienceConstructor, mixins[i]);\n      }\n    }\n  },\n  childContextTypes: function(ConvenienceConstructor, childContextTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      childContextTypes,\n      ReactPropTypeLocations.childContext\n    );\n    Constructor.childContextTypes = merge(\n      Constructor.childContextTypes,\n      childContextTypes\n    );\n  },\n  contextTypes: function(ConvenienceConstructor, contextTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      contextTypes,\n      ReactPropTypeLocations.context\n    );\n    Constructor.contextTypes = merge(Constructor.contextTypes, contextTypes);\n  },\n  propTypes: function(ConvenienceConstructor, propTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      propTypes,\n      ReactPropTypeLocations.prop\n    );\n    Constructor.propTypes = merge(Constructor.propTypes, propTypes);\n  },\n  statics: function(ConvenienceConstructor, statics) {\n    mixStaticSpecIntoComponent(ConvenienceConstructor, statics);\n  }\n};\n\nfunction validateTypeDef(Constructor, typeDef, location) {\n  for (var propName in typeDef) {\n    if (typeDef.hasOwnProperty(propName)) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof typeDef[propName] == &apos;function&apos;,\n        &apos;%s: %s type `%s` is invalid; it must be a function, usually from &apos; +\n        &apos;React.PropTypes.&apos;,\n        Constructor.displayName || &apos;ReactCompositeComponent&apos;,\n        ReactPropTypeLocationNames[location],\n        propName\n      ) : invariant(typeof typeDef[propName] == &apos;function&apos;));\n    }\n  }\n}\n\nfunction validateMethodOverride(proto, name) {\n  var specPolicy = ReactCompositeComponentInterface[name];\n\n  // Disallow overriding of base class methods unless explicitly allowed.\n  if (ReactCompositeComponentMixin.hasOwnProperty(name)) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      specPolicy === SpecPolicy.OVERRIDE_BASE,\n      &apos;ReactCompositeComponentInterface: You are attempting to override &apos; +\n      &apos;`%s` from your class specification. Ensure that your method names &apos; +\n      &apos;do not overlap with React methods.&apos;,\n      name\n    ) : invariant(specPolicy === SpecPolicy.OVERRIDE_BASE));\n  }\n\n  // Disallow defining methods more than once unless explicitly allowed.\n  if (proto.hasOwnProperty(name)) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      specPolicy === SpecPolicy.DEFINE_MANY ||\n      specPolicy === SpecPolicy.DEFINE_MANY_MERGED,\n      &apos;ReactCompositeComponentInterface: You are attempting to define &apos; +\n      &apos;`%s` on your component more than once. This conflict may be due &apos; +\n      &apos;to a mixin.&apos;,\n      name\n    ) : invariant(specPolicy === SpecPolicy.DEFINE_MANY ||\n    specPolicy === SpecPolicy.DEFINE_MANY_MERGED));\n  }\n}\n\nfunction validateLifeCycleOnReplaceState(instance) {\n  var compositeLifeCycleState = instance._compositeLifeCycleState;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    instance.isMounted() ||\n      compositeLifeCycleState === CompositeLifeCycle.MOUNTING,\n    &apos;replaceState(...): Can only update a mounted or mounting component.&apos;\n  ) : invariant(instance.isMounted() ||\n    compositeLifeCycleState === CompositeLifeCycle.MOUNTING));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE,\n    &apos;replaceState(...): Cannot update during an existing state transition &apos; +\n    &apos;(such as within `render`). This could potentially cause an infinite &apos; +\n    &apos;loop so it is forbidden.&apos;\n  ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING,\n    &apos;replaceState(...): Cannot update while unmounting component. This &apos; +\n    &apos;usually means you called setState() on an unmounted component.&apos;\n  ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING));\n}\n\n/**\n * Custom version of `mixInto` which handles policy validation and reserved\n * specification keys when building `ReactCompositeComponent` classses.\n */\nfunction mixSpecIntoComponent(ConvenienceConstructor, spec) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !isValidClass(spec),\n    &apos;ReactCompositeComponent: You\\&apos;re attempting to &apos; +\n    &apos;use a component class as a mixin. Instead, just use a regular object.&apos;\n  ) : invariant(!isValidClass(spec)));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !ReactComponent.isValidComponent(spec),\n    &apos;ReactCompositeComponent: You\\&apos;re attempting to &apos; +\n    &apos;use a component as a mixin. Instead, just use a regular object.&apos;\n  ) : invariant(!ReactComponent.isValidComponent(spec)));\n\n  var Constructor = ConvenienceConstructor.componentConstructor;\n  var proto = Constructor.prototype;\n  for (var name in spec) {\n    var property = spec[name];\n    if (!spec.hasOwnProperty(name)) {\n      continue;\n    }\n\n    validateMethodOverride(proto, name);\n\n    if (RESERVED_SPEC_KEYS.hasOwnProperty(name)) {\n      RESERVED_SPEC_KEYS[name](ConvenienceConstructor, property);\n    } else {\n      // Setup methods on prototype:\n      // The following member methods should not be automatically bound:\n      // 1. Expected ReactCompositeComponent methods (in the &quot;interface&quot;).\n      // 2. Overridden methods (that were mixed in).\n      var isCompositeComponentMethod = name in ReactCompositeComponentInterface;\n      var isInherited = name in proto;\n      var markedDontBind = property &amp;&amp; property.__reactDontBind;\n      var isFunction = typeof property === &apos;function&apos;;\n      var shouldAutoBind =\n        isFunction &amp;&amp;\n        !isCompositeComponentMethod &amp;&amp;\n        !isInherited &amp;&amp;\n        !markedDontBind;\n\n      if (shouldAutoBind) {\n        if (!proto.__reactAutoBindMap) {\n          proto.__reactAutoBindMap = {};\n        }\n        proto.__reactAutoBindMap[name] = property;\n        proto[name] = property;\n      } else {\n        if (isInherited) {\n          // For methods which are defined more than once, call the existing\n          // methods before calling the new property.\n          if (ReactCompositeComponentInterface[name] ===\n              SpecPolicy.DEFINE_MANY_MERGED) {\n            proto[name] = createMergedResultFunction(proto[name], property);\n          } else {\n            proto[name] = createChainedFunction(proto[name], property);\n          }\n        } else {\n          proto[name] = property;\n        }\n      }\n    }\n  }\n}\n\nfunction mixStaticSpecIntoComponent(ConvenienceConstructor, statics) {\n  if (!statics) {\n    return;\n  }\n  for (var name in statics) {\n    var property = statics[name];\n    if (!statics.hasOwnProperty(name) || !property) {\n      return;\n    }\n\n    var isInherited = name in ConvenienceConstructor;\n    var result = property;\n    if (isInherited) {\n      var existingProperty = ConvenienceConstructor[name];\n      var existingType = typeof existingProperty;\n      var propertyType = typeof property;\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        existingType === &apos;function&apos; &amp;&amp; propertyType === &apos;function&apos;,\n        &apos;ReactCompositeComponent: You are attempting to define &apos; +\n        &apos;`%s` on your component more than once, but that is only supported &apos; +\n        &apos;for functions, which are chained together. This conflict may be &apos; +\n        &apos;due to a mixin.&apos;,\n        name\n      ) : invariant(existingType === &apos;function&apos; &amp;&amp; propertyType === &apos;function&apos;));\n      result = createChainedFunction(existingProperty, property);\n    }\n    ConvenienceConstructor[name] = result;\n    ConvenienceConstructor.componentConstructor[name] = result;\n  }\n}\n\n/**\n * Merge two objects, but throw if both contain the same key.\n *\n * @param {object} one The first object, which is mutated.\n * @param {object} two The second object\n * @return {object} one after it has been mutated to contain everything in two.\n */\nfunction mergeObjectsWithNoDuplicateKeys(one, two) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    one &amp;&amp; two &amp;&amp; typeof one === &apos;object&apos; &amp;&amp; typeof two === &apos;object&apos;,\n    &apos;mergeObjectsWithNoDuplicateKeys(): Cannot merge non-objects&apos;\n  ) : invariant(one &amp;&amp; two &amp;&amp; typeof one === &apos;object&apos; &amp;&amp; typeof two === &apos;object&apos;));\n\n  objMap(two, function(value, key) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      one[key] === undefined,\n      &apos;mergeObjectsWithNoDuplicateKeys(): &apos; +\n      &apos;Tried to merge two objects with the same key: %s&apos;,\n      key\n    ) : invariant(one[key] === undefined));\n    one[key] = value;\n  });\n  return one;\n}\n\n/**\n * Creates a function that invokes two functions and merges their return values.\n *\n * @param {function} one Function to invoke first.\n * @param {function} two Function to invoke second.\n * @return {function} Function that invokes the two argument functions.\n * @private\n */\nfunction createMergedResultFunction(one, two) {\n  return function mergedResult() {\n    var a = one.apply(this, arguments);\n    var b = two.apply(this, arguments);\n    if (a == null) {\n      return b;\n    } else if (b == null) {\n      return a;\n    }\n    return mergeObjectsWithNoDuplicateKeys(a, b);\n  };\n}\n\n/**\n * Creates a function that invokes two functions and ignores their return vales.\n *\n * @param {function} one Function to invoke first.\n * @param {function} two Function to invoke second.\n * @return {function} Function that invokes the two argument functions.\n * @private\n */\nfunction createChainedFunction(one, two) {\n  return function chainedFunction() {\n    one.apply(this, arguments);\n    two.apply(this, arguments);\n  };\n}\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n\n  var unmountedPropertyWhitelist = {\n    constructor: true,\n    construct: true,\n    isOwnedBy: true, // should be deprecated but can have code mod (internal)\n    mountComponent: true,\n    mountComponentIntoNode: true,\n    props: true,\n    type: true,\n    _checkPropTypes: true,\n    _mountComponentIntoNode: true,\n    _processContext: true\n  };\n\n  var hasWarnedOnComponentType = {};\n\n  var warnIfUnmounted = function(instance, key) {\n    if (instance.__hasBeenMounted) {\n      return;\n    }\n    var name = instance.constructor.displayName || &apos;Unknown&apos;;\n    var owner = ReactCurrentOwner.current;\n    var ownerName = (owner &amp;&amp; owner.constructor.displayName) || &apos;Unknown&apos;;\n    var warningKey = key + &apos;|&apos; + name + &apos;|&apos; + ownerName;\n    if (hasWarnedOnComponentType.hasOwnProperty(warningKey)) {\n      // We have already warned for this combination. Skip it this time.\n      return;\n    }\n    hasWarnedOnComponentType[warningKey] = true;\n\n    var context = owner ? &apos; in &apos; + ownerName + &apos;.&apos; : &apos; at the top level.&apos;;\n    var staticMethodExample = &apos;&lt;&apos; + name + &apos; /&gt;.type.&apos; + key + &apos;(...)&apos;;\n\n    console.warn(\n      &apos;Invalid access to component property &quot;&apos; + key + &apos;&quot; on &apos; + name +\n      context + &apos; See http://fb.me/react-warning-descriptors .&apos; +\n      &apos; Use a static method instead: &apos; + staticMethodExample\n    );\n  };\n\n  var defineMembraneProperty = function(membrane, prototype, key) {\n    Object.defineProperty(membrane, key, {\n\n      configurable: false,\n      enumerable: true,\n\n      get: function() {\n        if (this !== membrane) {\n          // When this is accessed through a prototype chain we need to check if\n          // this component was mounted.\n          warnIfUnmounted(this, key);\n        }\n        return prototype[key];\n      },\n\n      set: function(value) {\n        if (this !== membrane) {\n          // When this is accessed through a prototype chain, we first check if\n          // this component was mounted. Then we define a value on &quot;this&quot;\n          // instance, effectively disabling the membrane on that prototype\n          // chain.\n          warnIfUnmounted(this, key);\n          Object.defineProperty(this, key, {\n            enumerable: true,\n            configurable: true,\n            writable: true,\n            value: value\n          });\n        } else {\n          // Otherwise, this should modify the prototype\n          prototype[key] = value;\n        }\n      }\n\n    });\n  };\n\n  /**\n   * Creates a membrane prototype which wraps the original prototype. If any\n   * property is accessed in an unmounted state, a warning is issued.\n   *\n   * @param {object} prototype Original prototype.\n   * @return {object} The membrane prototype.\n   * @private\n   */\n  var createMountWarningMembrane = function(prototype) {\n    try {\n      var membrane = Object.create(prototype);\n      for (var key in prototype) {\n        if (unmountedPropertyWhitelist.hasOwnProperty(key)) {\n          continue;\n        }\n        defineMembraneProperty(membrane, prototype, key);\n      }\n\n      membrane.mountComponent = function() {\n        this.__hasBeenMounted = true;\n        return prototype.mountComponent.apply(this, arguments);\n      };\n\n      return membrane;\n    } catch(x) {\n      // In IE8 define property will fail on non-DOM objects. If anything in\n      // the membrane creation fails, we&apos;ll bail out and just use the prototype\n      // without warnings.\n      return prototype;\n    }\n  };\n\n}\n\n/**\n * `ReactCompositeComponent` maintains an auxiliary life cycle state in\n * `this._compositeLifeCycleState` (which can be null).\n *\n * This is different from the life cycle state maintained by `ReactComponent` in\n * `this._lifeCycleState`. The following diagram shows how the states overlap in\n * time. There are times when the CompositeLifeCycle is null - at those times it\n * is only meaningful to look at ComponentLifeCycle alone.\n *\n * Top Row: ReactComponent.ComponentLifeCycle\n * Low Row: ReactComponent.CompositeLifeCycle\n *\n * +-------+------------------------------------------------------+--------+\n * |  UN   |                    MOUNTED                           |   UN   |\n * |MOUNTED|                                                      | MOUNTED|\n * +-------+------------------------------------------------------+--------+\n * |       ^--------+   +------+   +------+   +------+   +--------^        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |    0--|MOUNTING|-0-|RECEIV|-0-|RECEIV|-0-|RECEIV|-0-|   UN   |---&gt;0   |\n * |       |        |   |PROPS |   | PROPS|   | STATE|   |MOUNTING|        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |       +--------+   +------+   +------+   +------+   +--------+        |\n * |       |                                                      |        |\n * +-------+------------------------------------------------------+--------+\n */\nvar CompositeLifeCycle = keyMirror({\n  /**\n   * Components in the process of being mounted respond to state changes\n   * differently.\n   */\n  MOUNTING: null,\n  /**\n   * Components in the process of being unmounted are guarded against state\n   * changes.\n   */\n  UNMOUNTING: null,\n  /**\n   * Components that are mounted and receiving new props respond to state\n   * changes differently.\n   */\n  RECEIVING_PROPS: null,\n  /**\n   * Components that are mounted and receiving new state are guarded against\n   * additional state changes.\n   */\n  RECEIVING_STATE: null\n});\n\n/**\n * @lends {ReactCompositeComponent.prototype}\n */\nvar ReactCompositeComponentMixin = {\n\n  /**\n   * Base constructor for all composite component.\n   *\n   * @param {?object} initialProps\n   * @param {*} children\n   * @final\n   * @internal\n   */\n  construct: function(initialProps, children) {\n    // Children can be either an array or more than one argument\n    ReactComponent.Mixin.construct.apply(this, arguments);\n\n    this.state = null;\n    this._pendingState = null;\n\n    this.context = this._processContext(ReactContext.current);\n    this._currentContext = ReactContext.current;\n    this._pendingContext = null;\n\n    this._compositeLifeCycleState = null;\n  },\n\n  /**\n   * Checks whether or not this composite component is mounted.\n   * @return {boolean} True if mounted, false otherwise.\n   * @protected\n   * @final\n   */\n  isMounted: function() {\n    return ReactComponent.Mixin.isMounted.call(this) &amp;&amp;\n      this._compositeLifeCycleState !== CompositeLifeCycle.MOUNTING;\n  },\n\n  /**\n   * Initializes the component, renders markup, and registers event listeners.\n   *\n   * @param {string} rootID DOM ID of the root node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {?string} Rendered markup to be inserted into the DOM.\n   * @final\n   * @internal\n   */\n  mountComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;mountComponent&apos;,\n    function(rootID, transaction, mountDepth) {\n      ReactComponent.Mixin.mountComponent.call(\n        this,\n        rootID,\n        transaction,\n        mountDepth\n      );\n      this._compositeLifeCycleState = CompositeLifeCycle.MOUNTING;\n\n      this._defaultProps = this.getDefaultProps ? this.getDefaultProps() : null;\n      this.props = this._processProps(this.props);\n\n      if (this.__reactAutoBindMap) {\n        this._bindAutoBindMethods();\n      }\n\n      this.state = this.getInitialState ? this.getInitialState() : null;\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof this.state === &apos;object&apos; &amp;&amp; !Array.isArray(this.state),\n        &apos;%s.getInitialState(): must return an object or null&apos;,\n        this.constructor.displayName || &apos;ReactCompositeComponent&apos;\n      ) : invariant(typeof this.state === &apos;object&apos; &amp;&amp; !Array.isArray(this.state)));\n\n      this._pendingState = null;\n      this._pendingForceUpdate = false;\n\n      if (this.componentWillMount) {\n        this.componentWillMount();\n        // When mounting, calls to `setState` by `componentWillMount` will set\n        // `this._pendingState` without triggering a re-render.\n        if (this._pendingState) {\n          this.state = this._pendingState;\n          this._pendingState = null;\n        }\n      }\n\n      this._renderedComponent = this._renderValidatedComponent();\n\n      // Done with mounting, `setState` will now trigger UI changes.\n      this._compositeLifeCycleState = null;\n      var markup = this._renderedComponent.mountComponent(\n        rootID,\n        transaction,\n        mountDepth + 1\n      );\n      if (this.componentDidMount) {\n        transaction.getReactMountReady().enqueue(this, this.componentDidMount);\n      }\n      return markup;\n    }\n  ),\n\n  /**\n   * Releases any resources allocated by `mountComponent`.\n   *\n   * @final\n   * @internal\n   */\n  unmountComponent: function() {\n    this._compositeLifeCycleState = CompositeLifeCycle.UNMOUNTING;\n    if (this.componentWillUnmount) {\n      this.componentWillUnmount();\n    }\n    this._compositeLifeCycleState = null;\n\n    this._defaultProps = null;\n\n    this._renderedComponent.unmountComponent();\n    this._renderedComponent = null;\n\n    ReactComponent.Mixin.unmountComponent.call(this);\n\n    if (this.refs) {\n      this.refs = null;\n    }\n\n    // Some existing components rely on this.props even after they&apos;ve been\n    // destroyed (in event handlers).\n    // TODO: this.props = null;\n    // TODO: this.state = null;\n  },\n\n  /**\n   * Sets a subset of the state. Always use this or `replaceState` to mutate\n   * state. You should treat `this.state` as immutable.\n   *\n   * There is no guarantee that `this.state` will be immediately updated, so\n   * accessing `this.state` after calling this method may return the old value.\n   *\n   * There is no guarantee that calls to `setState` will run synchronously,\n   * as they may eventually be batched together.  You can provide an optional\n   * callback that will be executed when the call to setState is actually\n   * completed.\n   *\n   * @param {object} partialState Next partial state to be merged with state.\n   * @param {?function} callback Called after state is updated.\n   * @final\n   * @protected\n   */\n  setState: function(partialState, callback) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof partialState === &apos;object&apos; || partialState == null,\n      &apos;setState(...): takes an object of state variables to update.&apos;\n    ) : invariant(typeof partialState === &apos;object&apos; || partialState == null));\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      if (partialState == null) {\n        console.warn(\n          &apos;setState(...): You passed an undefined or null state object; &apos; +\n          &apos;instead, use forceUpdate().&apos;\n        );\n      }\n    }\n    // Merge with `_pendingState` if it exists, otherwise with existing state.\n    this.replaceState(\n      merge(this._pendingState || this.state, partialState),\n      callback\n    );\n  },\n\n  /**\n   * Replaces all of the state. Always use this or `setState` to mutate state.\n   * You should treat `this.state` as immutable.\n   *\n   * There is no guarantee that `this.state` will be immediately updated, so\n   * accessing `this.state` after calling this method may return the old value.\n   *\n   * @param {object} completeState Next state.\n   * @param {?function} callback Called after state is updated.\n   * @final\n   * @protected\n   */\n  replaceState: function(completeState, callback) {\n    validateLifeCycleOnReplaceState(this);\n    this._pendingState = completeState;\n    ReactUpdates.enqueueUpdate(this, callback);\n  },\n\n  /**\n   * Filters the context object to only contain keys specified in\n   * `contextTypes`, and asserts that they are valid.\n   *\n   * @param {object} context\n   * @return {?object}\n   * @private\n   */\n  _processContext: function(context) {\n    var maskedContext = null;\n    var contextTypes = this.constructor.contextTypes;\n    if (contextTypes) {\n      maskedContext = {};\n      for (var contextName in contextTypes) {\n        maskedContext[contextName] = context[contextName];\n      }\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        this._checkPropTypes(\n          contextTypes,\n          maskedContext,\n          ReactPropTypeLocations.context\n        );\n      }\n    }\n    return maskedContext;\n  },\n\n  /**\n   * @param {object} currentContext\n   * @return {object}\n   * @private\n   */\n  _processChildContext: function(currentContext) {\n    var childContext = this.getChildContext &amp;&amp; this.getChildContext();\n    var displayName = this.constructor.displayName || &apos;ReactCompositeComponent&apos;;\n    if (childContext) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof this.constructor.childContextTypes === &apos;object&apos;,\n        &apos;%s.getChildContext(): childContextTypes must be defined in order to &apos; +\n        &apos;use getChildContext().&apos;,\n        displayName\n      ) : invariant(typeof this.constructor.childContextTypes === &apos;object&apos;));\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        this._checkPropTypes(\n          this.constructor.childContextTypes,\n          childContext,\n          ReactPropTypeLocations.childContext\n        );\n      }\n      for (var name in childContext) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          name in this.constructor.childContextTypes,\n          &apos;%s.getChildContext(): key &quot;%s&quot; is not defined in childContextTypes.&apos;,\n          displayName,\n          name\n        ) : invariant(name in this.constructor.childContextTypes));\n      }\n      return merge(currentContext, childContext);\n    }\n    return currentContext;\n  },\n\n  /**\n   * Processes props by setting default values for unspecified props and\n   * asserting that the props are valid. Does not mutate its argument; returns\n   * a new props object with defaults merged in.\n   *\n   * @param {object} newProps\n   * @return {object}\n   * @private\n   */\n  _processProps: function(newProps) {\n    var props = merge(newProps);\n    var defaultProps = this._defaultProps;\n    for (var propName in defaultProps) {\n      if (typeof props[propName] === &apos;undefined&apos;) {\n        props[propName] = defaultProps[propName];\n      }\n    }\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var propTypes = this.constructor.propTypes;\n      if (propTypes) {\n        this._checkPropTypes(propTypes, props, ReactPropTypeLocations.prop);\n      }\n    }\n    return props;\n  },\n\n  /**\n   * Assert that the props are valid\n   *\n   * @param {object} propTypes Map of prop name to a ReactPropType\n   * @param {object} props\n   * @param {string} location e.g. &quot;prop&quot;, &quot;context&quot;, &quot;child context&quot;\n   * @private\n   */\n  _checkPropTypes: function(propTypes, props, location) {\n    var componentName = this.constructor.displayName;\n    for (var propName in propTypes) {\n      if (propTypes.hasOwnProperty(propName)) {\n        propTypes[propName](props, propName, componentName, location);\n      }\n    }\n  },\n\n  performUpdateIfNecessary: function() {\n    var compositeLifeCycleState = this._compositeLifeCycleState;\n    // Do not trigger a state transition if we are in the middle of mounting or\n    // receiving props because both of those will already be doing this.\n    if (compositeLifeCycleState === CompositeLifeCycle.MOUNTING ||\n        compositeLifeCycleState === CompositeLifeCycle.RECEIVING_PROPS) {\n      return;\n    }\n    ReactComponent.Mixin.performUpdateIfNecessary.call(this);\n  },\n\n  /**\n   * If any of `_pendingProps`, `_pendingState`, or `_pendingForceUpdate` is\n   * set, update the component.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   */\n  _performUpdateIfNecessary: function(transaction) {\n    if (this._pendingProps == null &amp;&amp;\n        this._pendingState == null &amp;&amp;\n        this._pendingContext == null &amp;&amp;\n        !this._pendingForceUpdate) {\n      return;\n    }\n\n    var nextFullContext = this._pendingContext || this._currentContext;\n    var nextContext = this._processContext(nextFullContext);\n    this._pendingContext = null;\n\n    var nextProps = this.props;\n    if (this._pendingProps != null) {\n      nextProps = this._processProps(this._pendingProps);\n      this._pendingProps = null;\n\n      this._compositeLifeCycleState = CompositeLifeCycle.RECEIVING_PROPS;\n      if (this.componentWillReceiveProps) {\n        this.componentWillReceiveProps(nextProps, nextContext);\n      }\n    }\n\n    this._compositeLifeCycleState = CompositeLifeCycle.RECEIVING_STATE;\n\n    // Unlike props, state, and context, we specifically don&apos;t want to set\n    // _pendingOwner to null here because it&apos;s possible for a component to have\n    // a null owner, so we instead make `this._owner === this._pendingOwner`\n    // mean that there&apos;s no owner change pending.\n    var nextOwner = this._pendingOwner;\n\n    var nextState = this._pendingState || this.state;\n    this._pendingState = null;\n\n    try {\n      if (this._pendingForceUpdate ||\n          !this.shouldComponentUpdate ||\n          this.shouldComponentUpdate(nextProps, nextState, nextContext)) {\n        this._pendingForceUpdate = false;\n        // Will set `this.props`, `this.state` and `this.context`.\n        this._performComponentUpdate(\n          nextProps,\n          nextOwner,\n          nextState,\n          nextFullContext,\n          nextContext,\n          transaction\n        );\n      } else {\n        // If it&apos;s determined that a component should not update, we still want\n        // to set props and state.\n        this.props = nextProps;\n        this._owner = nextOwner;\n        this.state = nextState;\n        this._currentContext = nextFullContext;\n        this.context = nextContext;\n      }\n    } finally {\n      this._compositeLifeCycleState = null;\n    }\n  },\n\n  /**\n   * Merges new props and state, notifies delegate methods of update and\n   * performs update.\n   *\n   * @param {object} nextProps Next object to set as properties.\n   * @param {?ReactComponent} nextOwner Next component to set as owner\n   * @param {?object} nextState Next object to set as state.\n   * @param {?object} nextFullContext Next object to set as _currentContext.\n   * @param {?object} nextContext Next object to set as context.\n   * @param {ReactReconcileTransaction} transaction\n   * @private\n   */\n  _performComponentUpdate: function(\n    nextProps,\n    nextOwner,\n    nextState,\n    nextFullContext,\n    nextContext,\n    transaction\n  ) {\n    var prevProps = this.props;\n    var prevOwner = this._owner;\n    var prevState = this.state;\n    var prevContext = this.context;\n\n    if (this.componentWillUpdate) {\n      this.componentWillUpdate(nextProps, nextState, nextContext);\n    }\n\n    this.props = nextProps;\n    this._owner = nextOwner;\n    this.state = nextState;\n    this._currentContext = nextFullContext;\n    this.context = nextContext;\n\n    this.updateComponent(\n      transaction,\n      prevProps,\n      prevOwner,\n      prevState,\n      prevContext\n    );\n\n    if (this.componentDidUpdate) {\n      transaction.getReactMountReady().enqueue(\n        this,\n        this.componentDidUpdate.bind(this, prevProps, prevState, prevContext)\n      );\n    }\n  },\n\n  receiveComponent: function(nextComponent, transaction) {\n    if (nextComponent === this) {\n      // Since props and context are immutable after the component is\n      // mounted, we can do a cheap identity compare here to determine\n      // if this is a superfluous reconcile.\n      return;\n    }\n\n    this._pendingContext = nextComponent._currentContext;\n    ReactComponent.Mixin.receiveComponent.call(\n      this,\n      nextComponent,\n      transaction\n    );\n  },\n\n  /**\n   * Updates the component&apos;s currently mounted DOM representation.\n   *\n   * By default, this implements React&apos;s rendering and reconciliation algorithm.\n   * Sophisticated clients may wish to override this.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @param {object} prevProps\n   * @param {?ReactComponent} prevOwner\n   * @param {?object} prevState\n   * @param {?object} prevContext\n   * @internal\n   * @overridable\n   */\n  updateComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;updateComponent&apos;,\n    function(transaction, prevProps, prevOwner, prevState, prevContext) {\n      ReactComponent.Mixin.updateComponent.call(\n        this,\n        transaction,\n        prevProps,\n        prevOwner\n      );\n      var prevComponent = this._renderedComponent;\n      var nextComponent = this._renderValidatedComponent();\n      if (shouldUpdateReactComponent(prevComponent, nextComponent)) {\n        prevComponent.receiveComponent(nextComponent, transaction);\n      } else {\n        // These two IDs are actually the same! But nothing should rely on that.\n        var thisID = this._rootNodeID;\n        var prevComponentID = prevComponent._rootNodeID;\n        prevComponent.unmountComponent();\n        this._renderedComponent = nextComponent;\n        var nextMarkup = nextComponent.mountComponent(\n          thisID,\n          transaction,\n          this._mountDepth + 1\n        );\n        ReactComponent.BackendIDOperations.dangerouslyReplaceNodeWithMarkupByID(\n          prevComponentID,\n          nextMarkup\n        );\n      }\n    }\n  ),\n\n  /**\n   * Forces an update. This should only be invoked when it is known with\n   * certainty that we are **not** in a DOM transaction.\n   *\n   * You may want to call this when you know that some deeper aspect of the\n   * component&apos;s state has changed but `setState` was not called.\n   *\n   * This will not invoke `shouldUpdateComponent`, but it will invoke\n   * `componentWillUpdate` and `componentDidUpdate`.\n   *\n   * @param {?function} callback Called after update is complete.\n   * @final\n   * @protected\n   */\n  forceUpdate: function(callback) {\n    var compositeLifeCycleState = this._compositeLifeCycleState;\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      this.isMounted() ||\n        compositeLifeCycleState === CompositeLifeCycle.MOUNTING,\n      &apos;forceUpdate(...): Can only force an update on mounted or mounting &apos; +\n        &apos;components.&apos;\n    ) : invariant(this.isMounted() ||\n      compositeLifeCycleState === CompositeLifeCycle.MOUNTING));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE &amp;&amp;\n      compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING,\n      &apos;forceUpdate(...): Cannot force an update while unmounting component &apos; +\n      &apos;or during an existing state transition (such as within `render`).&apos;\n    ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE &amp;&amp;\n    compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING));\n    this._pendingForceUpdate = true;\n    ReactUpdates.enqueueUpdate(this, callback);\n  },\n\n  /**\n   * @private\n   */\n  _renderValidatedComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;_renderValidatedComponent&apos;,\n    function() {\n      var renderedComponent;\n      var previousContext = ReactContext.current;\n      ReactContext.current = this._processChildContext(this._currentContext);\n      ReactCurrentOwner.current = this;\n      try {\n        renderedComponent = this.render();\n      } finally {\n        ReactContext.current = previousContext;\n        ReactCurrentOwner.current = null;\n      }\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        ReactComponent.isValidComponent(renderedComponent),\n        &apos;%s.render(): A valid ReactComponent must be returned. You may have &apos; +\n          &apos;returned null, undefined, an array, or some other invalid object.&apos;,\n        this.constructor.displayName || &apos;ReactCompositeComponent&apos;\n      ) : invariant(ReactComponent.isValidComponent(renderedComponent)));\n      return renderedComponent;\n    }\n  ),\n\n  /**\n   * @private\n   */\n  _bindAutoBindMethods: function() {\n    for (var autoBindKey in this.__reactAutoBindMap) {\n      if (!this.__reactAutoBindMap.hasOwnProperty(autoBindKey)) {\n        continue;\n      }\n      var method = this.__reactAutoBindMap[autoBindKey];\n      this[autoBindKey] = this._bindAutoBindMethod(ReactErrorUtils.guard(\n        method,\n        this.constructor.displayName + &apos;.&apos; + autoBindKey\n      ));\n    }\n  },\n\n  /**\n   * Binds a method to the component.\n   *\n   * @param {function} method Method to be bound.\n   * @private\n   */\n  _bindAutoBindMethod: function(method) {\n    var component = this;\n    var boundMethod = function() {\n      return method.apply(component, arguments);\n    };\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      boundMethod.__reactBoundContext = component;\n      boundMethod.__reactBoundMethod = method;\n      boundMethod.__reactBoundArguments = null;\n      var componentName = component.constructor.displayName;\n      var _bind = boundMethod.bind;\n      boundMethod.bind = function(newThis ) {var args=Array.prototype.slice.call(arguments,1);\n        // User is trying to bind() an autobound method; we effectively will\n        // ignore the value of &quot;this&quot; that the user is trying to use, so\n        // let&apos;s warn.\n        if (newThis !== component &amp;&amp; newThis !== null) {\n          console.warn(\n            &apos;bind(): React component methods may only be bound to the &apos; +\n            &apos;component instance. See &apos; + componentName\n          );\n        } else if (!args.length) {\n          console.warn(\n            &apos;bind(): You are binding a component method to the component. &apos; +\n            &apos;React does this for you automatically in a high-performance &apos; +\n            &apos;way, so you can safely remove this call. See &apos; + componentName\n          );\n          return boundMethod;\n        }\n        var reboundMethod = _bind.apply(boundMethod, arguments);\n        reboundMethod.__reactBoundContext = component;\n        reboundMethod.__reactBoundMethod = method;\n        reboundMethod.__reactBoundArguments = args;\n        return reboundMethod;\n      };\n    }\n    return boundMethod;\n  }\n};\n\nvar ReactCompositeComponentBase = function() {};\nmixInto(ReactCompositeComponentBase, ReactComponent.Mixin);\nmixInto(ReactCompositeComponentBase, ReactOwner.Mixin);\nmixInto(ReactCompositeComponentBase, ReactPropTransferer.Mixin);\nmixInto(ReactCompositeComponentBase, ReactCompositeComponentMixin);\n\n/**\n * Checks if a value is a valid component constructor.\n *\n * @param {*}\n * @return {boolean}\n * @public\n */\nfunction isValidClass(componentClass) {\n  return componentClass instanceof Function &amp;&amp;\n         &apos;componentConstructor&apos; in componentClass &amp;&amp;\n         componentClass.componentConstructor instanceof Function;\n}\n/**\n * Module for creating composite components.\n *\n * @class ReactCompositeComponent\n * @extends ReactComponent\n * @extends ReactOwner\n * @extends ReactPropTransferer\n */\nvar ReactCompositeComponent = {\n\n  LifeCycle: CompositeLifeCycle,\n\n  Base: ReactCompositeComponentBase,\n\n  /**\n   * Creates a composite component class given a class specification.\n   *\n   * @param {object} spec Class specification (which must define `render`).\n   * @return {function} Component constructor function.\n   * @public\n   */\n  createClass: function(spec) {\n    var Constructor = function() {};\n    Constructor.prototype = new ReactCompositeComponentBase();\n    Constructor.prototype.constructor = Constructor;\n\n    var ConvenienceConstructor = function(props, children) {\n      var instance = new Constructor();\n      instance.construct.apply(instance, arguments);\n      return instance;\n    };\n    ConvenienceConstructor.componentConstructor = Constructor;\n    Constructor.ConvenienceConstructor = ConvenienceConstructor;\n    ConvenienceConstructor.originalSpec = spec;\n\n    mixSpecIntoComponent(ConvenienceConstructor, spec);\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Constructor.prototype.render,\n      &apos;createClass(...): Class specification must implement a `render` method.&apos;\n    ) : invariant(Constructor.prototype.render));\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      if (Constructor.prototype.componentShouldUpdate) {\n        console.warn(\n          (spec.displayName || &apos;A component&apos;) + &apos; has a method called &apos; +\n          &apos;componentShouldUpdate(). Did you mean shouldComponentUpdate()? &apos; +\n          &apos;The name is phrased as a question because the function is &apos; +\n          &apos;expected to return a value.&apos;\n         );\n      }\n    }\n\n    // Expose the convience constructor on the prototype so that it can be\n    // easily accessed on descriptors. E.g. &lt;Foo /&gt;.type === Foo.type and for\n    // static methods like &lt;Foo /&gt;.type.staticMethod();\n    // This should not be named constructor since this may not be the function\n    // that created the descriptor, and it may not even be a constructor.\n    ConvenienceConstructor.type = Constructor;\n    Constructor.prototype.type = Constructor;\n\n    // Reduce time spent doing lookups by setting these on the prototype.\n    for (var methodName in ReactCompositeComponentInterface) {\n      if (!Constructor.prototype[methodName]) {\n        Constructor.prototype[methodName] = null;\n      }\n    }\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      Constructor.prototype = createMountWarningMembrane(Constructor.prototype);\n    }\n\n    return ConvenienceConstructor;\n  },\n\n  isValidClass: isValidClass\n};\n\nmodule.exports = ReactCompositeComponent;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactContext&quot;:30,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactErrorUtils&quot;:47,&quot;./ReactOwner&quot;:59,&quot;./ReactPerf&quot;:60,&quot;./ReactPropTransferer&quot;:61,&quot;./ReactPropTypeLocationNames&quot;:62,&quot;./ReactPropTypeLocations&quot;:63,&quot;./ReactUpdates&quot;:70,&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114,&quot;./merge&quot;:117,&quot;./mixInto&quot;:120,&quot;./objMap&quot;:121,&quot;./shouldUpdateReactComponent&quot;:126}],30:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactContext\n */\n\n&quot;use strict&quot;;\n\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Keeps track of the current context.\n *\n * The context is automatically passed down the component ownership hierarchy\n * and is accessible via `this.context` on ReactCompositeComponents.\n */\nvar ReactContext = {\n\n  /**\n   * @internal\n   * @type {object}\n   */\n  current: {},\n\n  /**\n   * Temporarily extends the current context while executing scopedCallback.\n   *\n   * A typical use case might look like\n   *\n   *  render: function() {\n   *    var children = ReactContext.withContext({foo: &apos;foo&apos;} () =&gt; (\n   *\n   *    ));\n   *    return &lt;div&gt;{children}&lt;/div&gt;;\n   *  }\n   *\n   * @param {object} newContext New context to merge into the existing context\n   * @param {function} scopedCallback Callback to run with the new context\n   * @return {ReactComponent|array&lt;ReactComponent&gt;}\n   */\n  withContext: function(newContext, scopedCallback) {\n    var result;\n    var previousContext = ReactContext.current;\n    ReactContext.current = merge(previousContext, newContext);\n    try {\n      result = scopedCallback();\n    } finally {\n      ReactContext.current = previousContext;\n    }\n    return result;\n  }\n\n};\n\nmodule.exports = ReactContext;\n\n},{&quot;./merge&quot;:117}],31:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactCurrentOwner\n */\n\n&quot;use strict&quot;;\n\n/**\n * Keeps track of the current owner.\n *\n * The current owner is the component who should own any components that are\n * currently being constructed.\n *\n * The depth indicate how many composite components are above this render level.\n */\nvar ReactCurrentOwner = {\n\n  /**\n   * @internal\n   * @type {ReactComponent}\n   */\n  current: null\n\n};\n\nmodule.exports = ReactCurrentOwner;\n\n},{}],32:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOM\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactDOMComponent = require(&quot;./ReactDOMComponent&quot;);\n\nvar mergeInto = require(&quot;./mergeInto&quot;);\nvar objMapKeyVal = require(&quot;./objMapKeyVal&quot;);\n\n/**\n * Creates a new React class that is idempotent and capable of containing other\n * React components. It accepts event listeners and DOM properties that are\n * valid according to `DOMProperty`.\n *\n *  - Event listeners: `onClick`, `onMouseDown`, etc.\n *  - DOM properties: `className`, `name`, `title`, etc.\n *\n * The `style` property functions differently from the DOM API. It accepts an\n * object mapping of style properties to values.\n *\n * @param {string} tag Tag name (e.g. `div`).\n * @param {boolean} omitClose True if the close tag should be omitted.\n * @private\n */\nfunction createDOMComponentClass(tag, omitClose) {\n  var Constructor = function() {};\n  Constructor.prototype = new ReactDOMComponent(tag, omitClose);\n  Constructor.prototype.constructor = Constructor;\n  Constructor.displayName = tag;\n\n  var ConvenienceConstructor = function(props, children) {\n    var instance = new Constructor();\n    instance.construct.apply(instance, arguments);\n    return instance;\n  };\n\n  // Expose the constructor on the ConvenienceConstructor and prototype so that\n  // it can be easily easily accessed on descriptors.\n  // E.g. &lt;div /&gt;.type === div.type\n  ConvenienceConstructor.type = Constructor;\n  Constructor.prototype.type = Constructor;\n\n  Constructor.ConvenienceConstructor = ConvenienceConstructor;\n  ConvenienceConstructor.componentConstructor = Constructor;\n  return ConvenienceConstructor;\n}\n\n/**\n * Creates a mapping from supported HTML tags to `ReactDOMComponent` classes.\n * This is also accessible via `React.DOM`.\n *\n * @public\n */\nvar ReactDOM = objMapKeyVal({\n  a: false,\n  abbr: false,\n  address: false,\n  area: false,\n  article: false,\n  aside: false,\n  audio: false,\n  b: false,\n  base: false,\n  bdi: false,\n  bdo: false,\n  big: false,\n  blockquote: false,\n  body: false,\n  br: true,\n  button: false,\n  canvas: false,\n  caption: false,\n  cite: false,\n  code: false,\n  col: true,\n  colgroup: false,\n  data: false,\n  datalist: false,\n  dd: false,\n  del: false,\n  details: false,\n  dfn: false,\n  div: false,\n  dl: false,\n  dt: false,\n  em: false,\n  embed: true,\n  fieldset: false,\n  figcaption: false,\n  figure: false,\n  footer: false,\n  form: false, // NOTE: Injected, see `ReactDOMForm`.\n  h1: false,\n  h2: false,\n  h3: false,\n  h4: false,\n  h5: false,\n  h6: false,\n  head: false,\n  header: false,\n  hr: true,\n  html: false,\n  i: false,\n  iframe: false,\n  img: true,\n  input: true,\n  ins: false,\n  kbd: false,\n  keygen: true,\n  label: false,\n  legend: false,\n  li: false,\n  link: false,\n  main: false,\n  map: false,\n  mark: false,\n  menu: false,\n  menuitem: false, // NOTE: Close tag should be omitted, but causes problems.\n  meta: true,\n  meter: false,\n  nav: false,\n  noscript: false,\n  object: false,\n  ol: false,\n  optgroup: false,\n  option: false,\n  output: false,\n  p: false,\n  param: true,\n  pre: false,\n  progress: false,\n  q: false,\n  rp: false,\n  rt: false,\n  ruby: false,\n  s: false,\n  samp: false,\n  script: false,\n  section: false,\n  select: false,\n  small: false,\n  source: false,\n  span: false,\n  strong: false,\n  style: false,\n  sub: false,\n  summary: false,\n  sup: false,\n  table: false,\n  tbody: false,\n  td: false,\n  textarea: false, // NOTE: Injected, see `ReactDOMTextarea`.\n  tfoot: false,\n  th: false,\n  thead: false,\n  time: false,\n  title: false,\n  tr: false,\n  track: true,\n  u: false,\n  ul: false,\n  &apos;var&apos;: false,\n  video: false,\n  wbr: false,\n\n  // SVG\n  circle: false,\n  defs: false,\n  g: false,\n  line: false,\n  linearGradient: false,\n  path: false,\n  polygon: false,\n  polyline: false,\n  radialGradient: false,\n  rect: false,\n  stop: false,\n  svg: false,\n  text: false\n}, createDOMComponentClass);\n\nvar injection = {\n  injectComponentClasses: function(componentClasses) {\n    mergeInto(ReactDOM, componentClasses);\n  }\n};\n\nReactDOM.injection = injection;\n\nmodule.exports = ReactDOM;\n\n},{&quot;./ReactDOMComponent&quot;:34,&quot;./mergeInto&quot;:119,&quot;./objMapKeyVal&quot;:122}],33:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMButton\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n// Store a reference to the &lt;button&gt; `ReactDOMComponent`.\nvar button = ReactDOM.button;\n\nvar mouseListenerNames = keyMirror({\n  onClick: true,\n  onDoubleClick: true,\n  onMouseDown: true,\n  onMouseMove: true,\n  onMouseUp: true,\n  onClickCapture: true,\n  onDoubleClickCapture: true,\n  onMouseDownCapture: true,\n  onMouseMoveCapture: true,\n  onMouseUpCapture: true\n});\n\n/**\n * Implements a &lt;button&gt; native component that does not receive mouse events\n * when `disabled` is set.\n */\nvar ReactDOMButton = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMButton&apos;,\n\n  mixins: [AutoFocusMixin],\n\n  render: function() {\n    var props = {};\n\n    // Copy the props; except the mouse listeners if we&apos;re disabled\n    for (var key in this.props) {\n      if (this.props.hasOwnProperty(key) &amp;&amp;\n          (!this.props.disabled || !mouseListenerNames[key])) {\n        props[key] = this.props[key];\n      }\n    }\n\n    return button(props, this.props.children);\n  }\n\n});\n\nmodule.exports = ReactDOMButton;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./keyMirror&quot;:114}],34:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSPropertyOperations = require(&quot;./CSSPropertyOperations&quot;);\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactMultiChild = require(&quot;./ReactMultiChild&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\nvar deleteListener = ReactEventEmitter.deleteListener;\nvar listenTo = ReactEventEmitter.listenTo;\nvar registrationNameModules = ReactEventEmitter.registrationNameModules;\n\n// For quickly matching children type, to test if can be treated as content.\nvar CONTENT_TYPES = {&apos;string&apos;: true, &apos;number&apos;: true};\n\nvar STYLE = keyOf({style: null});\n\nvar ELEMENT_NODE_TYPE = 1;\n\n/**\n * @param {?object} props\n */\nfunction assertValidProps(props) {\n  if (!props) {\n    return;\n  }\n  // Note the use of `==` which checks for null or undefined.\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    props.children == null || props.dangerouslySetInnerHTML == null,\n    &apos;Can only set one of `children` or `props.dangerouslySetInnerHTML`.&apos;\n  ) : invariant(props.children == null || props.dangerouslySetInnerHTML == null));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    props.style == null || typeof props.style === &apos;object&apos;,\n    &apos;The `style` prop expects a mapping from style properties to values, &apos; +\n    &apos;not a string.&apos;\n  ) : invariant(props.style == null || typeof props.style === &apos;object&apos;));\n}\n\nfunction putListener(id, registrationName, listener, transaction) {\n  var container = ReactMount.findReactContainerForID(id);\n  if (container) {\n    var doc = container.nodeType === ELEMENT_NODE_TYPE ?\n      container.ownerDocument :\n      container;\n    listenTo(registrationName, doc);\n  }\n  transaction.getPutListenerQueue().enqueuePutListener(\n    id,\n    registrationName,\n    listener\n  );\n}\n\n\n/**\n * @constructor ReactDOMComponent\n * @extends ReactComponent\n * @extends ReactMultiChild\n */\nfunction ReactDOMComponent(tag, omitClose) {\n  this._tagOpen = &apos;&lt;&apos; + tag;\n  this._tagClose = omitClose ? &apos;&apos; : &apos;&lt;/&apos; + tag + &apos;&gt;&apos;;\n  this.tagName = tag.toUpperCase();\n}\n\nReactDOMComponent.Mixin = {\n\n  /**\n   * Generates root tag markup then recurses. This method has side effects and\n   * is not idempotent.\n   *\n   * @internal\n   * @param {string} rootID The root DOM ID for this node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {string} The computed markup.\n   */\n  mountComponent: ReactPerf.measure(\n    &apos;ReactDOMComponent&apos;,\n    &apos;mountComponent&apos;,\n    function(rootID, transaction, mountDepth) {\n      ReactComponent.Mixin.mountComponent.call(\n        this,\n        rootID,\n        transaction,\n        mountDepth\n      );\n      assertValidProps(this.props);\n      return (\n        this._createOpenTagMarkupAndPutListeners(transaction) +\n        this._createContentMarkup(transaction) +\n        this._tagClose\n      );\n    }\n  ),\n\n  /**\n   * Creates markup for the open tag and all attributes.\n   *\n   * This method has side effects because events get registered.\n   *\n   * Iterating over object properties is faster than iterating over arrays.\n   * @see http://jsperf.com/obj-vs-arr-iteration\n   *\n   * @private\n   * @param {ReactReconcileTransaction} transaction\n   * @return {string} Markup of opening tag.\n   */\n  _createOpenTagMarkupAndPutListeners: function(transaction) {\n    var props = this.props;\n    var ret = this._tagOpen;\n\n    for (var propKey in props) {\n      if (!props.hasOwnProperty(propKey)) {\n        continue;\n      }\n      var propValue = props[propKey];\n      if (propValue == null) {\n        continue;\n      }\n      if (registrationNameModules[propKey]) {\n        putListener(this._rootNodeID, propKey, propValue, transaction);\n      } else {\n        if (propKey === STYLE) {\n          if (propValue) {\n            propValue = props.style = merge(props.style);\n          }\n          propValue = CSSPropertyOperations.createMarkupForStyles(propValue);\n        }\n        var markup =\n          DOMPropertyOperations.createMarkupForProperty(propKey, propValue);\n        if (markup) {\n          ret += &apos; &apos; + markup;\n        }\n      }\n    }\n\n    var idMarkup = DOMPropertyOperations.createMarkupForID(this._rootNodeID);\n    return ret + &apos; &apos; + idMarkup + &apos;&gt;&apos;;\n  },\n\n  /**\n   * Creates markup for the content between the tags.\n   *\n   * @private\n   * @param {ReactReconcileTransaction} transaction\n   * @return {string} Content markup.\n   */\n  _createContentMarkup: function(transaction) {\n    // Intentional use of != to avoid catching zero/false.\n    var innerHTML = this.props.dangerouslySetInnerHTML;\n    if (innerHTML != null) {\n      if (innerHTML.__html != null) {\n        return innerHTML.__html;\n      }\n    } else {\n      var contentToUse =\n        CONTENT_TYPES[typeof this.props.children] ? this.props.children : null;\n      var childrenToUse = contentToUse != null ? null : this.props.children;\n      if (contentToUse != null) {\n        return escapeTextForBrowser(contentToUse);\n      } else if (childrenToUse != null) {\n        var mountImages = this.mountChildren(\n          childrenToUse,\n          transaction\n        );\n        return mountImages.join(&apos;&apos;);\n      }\n    }\n    return &apos;&apos;;\n  },\n\n  receiveComponent: function(nextComponent, transaction) {\n    assertValidProps(nextComponent.props);\n    ReactComponent.Mixin.receiveComponent.call(\n      this,\n      nextComponent,\n      transaction\n    );\n  },\n\n  /**\n   * Updates a native DOM component after it has already been allocated and\n   * attached to the DOM. Reconciles the root DOM node, then recurses.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @param {object} prevProps\n   * @internal\n   * @overridable\n   */\n  updateComponent: ReactPerf.measure(\n    &apos;ReactDOMComponent&apos;,\n    &apos;updateComponent&apos;,\n    function(transaction, prevProps, prevOwner) {\n      ReactComponent.Mixin.updateComponent.call(\n        this,\n        transaction,\n        prevProps,\n        prevOwner\n      );\n      this._updateDOMProperties(prevProps, transaction);\n      this._updateDOMChildren(prevProps, transaction);\n    }\n  ),\n\n  /**\n   * Reconciles the properties by detecting differences in property values and\n   * updating the DOM as necessary. This function is probably the single most\n   * critical path for performance optimization.\n   *\n   * TODO: Benchmark whether checking for changed values in memory actually\n   *       improves performance (especially statically positioned elements).\n   * TODO: Benchmark the effects of putting this at the top since 99% of props\n   *       do not change for a given reconciliation.\n   * TODO: Benchmark areas that can be improved with caching.\n   *\n   * @private\n   * @param {object} lastProps\n   * @param {ReactReconcileTransaction} transaction\n   */\n  _updateDOMProperties: function(lastProps, transaction) {\n    var nextProps = this.props;\n    var propKey;\n    var styleName;\n    var styleUpdates;\n    for (propKey in lastProps) {\n      if (nextProps.hasOwnProperty(propKey) ||\n         !lastProps.hasOwnProperty(propKey)) {\n        continue;\n      }\n      if (propKey === STYLE) {\n        var lastStyle = lastProps[propKey];\n        for (styleName in lastStyle) {\n          if (lastStyle.hasOwnProperty(styleName)) {\n            styleUpdates = styleUpdates || {};\n            styleUpdates[styleName] = &apos;&apos;;\n          }\n        }\n      } else if (registrationNameModules[propKey]) {\n        deleteListener(this._rootNodeID, propKey);\n      } else if (\n          DOMProperty.isStandardName[propKey] ||\n          DOMProperty.isCustomAttribute(propKey)) {\n        ReactComponent.BackendIDOperations.deletePropertyByID(\n          this._rootNodeID,\n          propKey\n        );\n      }\n    }\n    for (propKey in nextProps) {\n      var nextProp = nextProps[propKey];\n      var lastProp = lastProps[propKey];\n      if (!nextProps.hasOwnProperty(propKey) || nextProp === lastProp) {\n        continue;\n      }\n      if (propKey === STYLE) {\n        if (nextProp) {\n          nextProp = nextProps.style = merge(nextProp);\n        }\n        if (lastProp) {\n          // Unset styles on `lastProp` but not on `nextProp`.\n          for (styleName in lastProp) {\n            if (lastProp.hasOwnProperty(styleName) &amp;&amp;\n                !nextProp.hasOwnProperty(styleName)) {\n              styleUpdates = styleUpdates || {};\n              styleUpdates[styleName] = &apos;&apos;;\n            }\n          }\n          // Update styles that changed since `lastProp`.\n          for (styleName in nextProp) {\n            if (nextProp.hasOwnProperty(styleName) &amp;&amp;\n                lastProp[styleName] !== nextProp[styleName]) {\n              styleUpdates = styleUpdates || {};\n              styleUpdates[styleName] = nextProp[styleName];\n            }\n          }\n        } else {\n          // Relies on `updateStylesByID` not mutating `styleUpdates`.\n          styleUpdates = nextProp;\n        }\n      } else if (registrationNameModules[propKey]) {\n        putListener(this._rootNodeID, propKey, nextProp, transaction);\n      } else if (\n          DOMProperty.isStandardName[propKey] ||\n          DOMProperty.isCustomAttribute(propKey)) {\n        ReactComponent.BackendIDOperations.updatePropertyByID(\n          this._rootNodeID,\n          propKey,\n          nextProp\n        );\n      }\n    }\n    if (styleUpdates) {\n      ReactComponent.BackendIDOperations.updateStylesByID(\n        this._rootNodeID,\n        styleUpdates\n      );\n    }\n  },\n\n  /**\n   * Reconciles the children with the various properties that affect the\n   * children content.\n   *\n   * @param {object} lastProps\n   * @param {ReactReconcileTransaction} transaction\n   */\n  _updateDOMChildren: function(lastProps, transaction) {\n    var nextProps = this.props;\n\n    var lastContent =\n      CONTENT_TYPES[typeof lastProps.children] ? lastProps.children : null;\n    var nextContent =\n      CONTENT_TYPES[typeof nextProps.children] ? nextProps.children : null;\n\n    var lastHtml =\n      lastProps.dangerouslySetInnerHTML &amp;&amp;\n      lastProps.dangerouslySetInnerHTML.__html;\n    var nextHtml =\n      nextProps.dangerouslySetInnerHTML &amp;&amp;\n      nextProps.dangerouslySetInnerHTML.__html;\n\n    // Note the use of `!=` which checks for null or undefined.\n    var lastChildren = lastContent != null ? null : lastProps.children;\n    var nextChildren = nextContent != null ? null : nextProps.children;\n\n    // If we&apos;re switching from children to content/html or vice versa, remove\n    // the old content\n    var lastHasContentOrHtml = lastContent != null || lastHtml != null;\n    var nextHasContentOrHtml = nextContent != null || nextHtml != null;\n    if (lastChildren != null &amp;&amp; nextChildren == null) {\n      this.updateChildren(null, transaction);\n    } else if (lastHasContentOrHtml &amp;&amp; !nextHasContentOrHtml) {\n      this.updateTextContent(&apos;&apos;);\n    }\n\n    if (nextContent != null) {\n      if (lastContent !== nextContent) {\n        this.updateTextContent(&apos;&apos; + nextContent);\n      }\n    } else if (nextHtml != null) {\n      if (lastHtml !== nextHtml) {\n        ReactComponent.BackendIDOperations.updateInnerHTMLByID(\n          this._rootNodeID,\n          nextHtml\n        );\n      }\n    } else if (nextChildren != null) {\n      this.updateChildren(nextChildren, transaction);\n    }\n  },\n\n  /**\n   * Destroys all event registrations for this instance. Does not remove from\n   * the DOM. That must be done by the parent.\n   *\n   * @internal\n   */\n  unmountComponent: function() {\n    this.unmountChildren();\n    ReactEventEmitter.deleteAllListeners(this._rootNodeID);\n    ReactComponent.Mixin.unmountComponent.call(this);\n  }\n\n};\n\nmixInto(ReactDOMComponent, ReactComponent.Mixin);\nmixInto(ReactDOMComponent, ReactDOMComponent.Mixin);\nmixInto(ReactDOMComponent, ReactMultiChild.Mixin);\n\nmodule.exports = ReactDOMComponent;\n\n},{&quot;./CSSPropertyOperations&quot;:3,&quot;./DOMProperty&quot;:8,&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactComponent&quot;:26,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactMount&quot;:55,&quot;./ReactMultiChild&quot;:57,&quot;./ReactPerf&quot;:60,&quot;./escapeTextForBrowser&quot;:96,&quot;./invariant&quot;:108,&quot;./keyOf&quot;:115,&quot;./merge&quot;:117,&quot;./mixInto&quot;:120}],35:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMForm\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\n// Store a reference to the &lt;form&gt; `ReactDOMComponent`.\nvar form = ReactDOM.form;\n\n/**\n * Since onSubmit doesn&apos;t bubble OR capture on the top level in IE8, we need\n * to capture it on the &lt;form&gt; element itself. There are lots of hacks we could\n * do to accomplish this, but the most reliable is to make &lt;form&gt; a\n * composite component and use `componentDidMount` to attach the event handlers.\n */\nvar ReactDOMForm = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMForm&apos;,\n\n  render: function() {\n    // TODO: Instead of using `ReactDOM` directly, we should use JSX. However,\n    // `jshint` fails to parse JSX so in order for linting to work in the open\n    // source repo, we need to just use `ReactDOM.form`.\n    return this.transferPropsTo(form(null, this.props.children));\n  },\n\n  componentDidMount: function() {\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topReset,\n      &apos;reset&apos;,\n      this.getDOMNode()\n    );\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topSubmit,\n      &apos;submit&apos;,\n      this.getDOMNode()\n    );\n  }\n});\n\nmodule.exports = ReactDOMForm;\n\n},{&quot;./EventConstants&quot;:14,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48}],36:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMIDOperations\n * @typechecks static-only\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar CSSPropertyOperations = require(&quot;./CSSPropertyOperations&quot;);\nvar DOMChildrenOperations = require(&quot;./DOMChildrenOperations&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Errors for properties that should not be updated with `updatePropertyById()`.\n *\n * @type {object}\n * @private\n */\nvar INVALID_PROPERTY_ERRORS = {\n  dangerouslySetInnerHTML:\n    &apos;`dangerouslySetInnerHTML` must be set using `updateInnerHTMLByID()`.&apos;,\n  style: &apos;`style` must be set using `updateStylesByID()`.&apos;\n};\n\nvar useWhitespaceWorkaround;\n\n/**\n * Operations used to process updates to DOM nodes. This is made injectable via\n * `ReactComponent.BackendIDOperations`.\n */\nvar ReactDOMIDOperations = {\n\n  /**\n   * Updates a DOM node with new property values. This should only be used to\n   * update DOM properties in `DOMProperty`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} name A valid property name, see `DOMProperty`.\n   * @param {*} value New value of the property.\n   * @internal\n   */\n  updatePropertyByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updatePropertyByID&apos;,\n    function(id, name, value) {\n      var node = ReactMount.getNode(id);\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !INVALID_PROPERTY_ERRORS.hasOwnProperty(name),\n        &apos;updatePropertyByID(...): %s&apos;,\n        INVALID_PROPERTY_ERRORS[name]\n      ) : invariant(!INVALID_PROPERTY_ERRORS.hasOwnProperty(name)));\n\n      // If we&apos;re updating to null or undefined, we should remove the property\n      // from the DOM node instead of inadvertantly setting to a string. This\n      // brings us in line with the same behavior we have on initial render.\n      if (value != null) {\n        DOMPropertyOperations.setValueForProperty(node, name, value);\n      } else {\n        DOMPropertyOperations.deleteValueForProperty(node, name);\n      }\n    }\n  ),\n\n  /**\n   * Updates a DOM node to remove a property. This should only be used to remove\n   * DOM properties in `DOMProperty`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} name A property name to remove, see `DOMProperty`.\n   * @internal\n   */\n  deletePropertyByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;deletePropertyByID&apos;,\n    function(id, name, value) {\n      var node = ReactMount.getNode(id);\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !INVALID_PROPERTY_ERRORS.hasOwnProperty(name),\n        &apos;updatePropertyByID(...): %s&apos;,\n        INVALID_PROPERTY_ERRORS[name]\n      ) : invariant(!INVALID_PROPERTY_ERRORS.hasOwnProperty(name)));\n      DOMPropertyOperations.deleteValueForProperty(node, name, value);\n    }\n  ),\n\n  /**\n   * Updates a DOM node with new style values. If a value is specified as &apos;&apos;,\n   * the corresponding style property will be unset.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {object} styles Mapping from styles to values.\n   * @internal\n   */\n  updateStylesByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateStylesByID&apos;,\n    function(id, styles) {\n      var node = ReactMount.getNode(id);\n      CSSPropertyOperations.setValueForStyles(node, styles);\n    }\n  ),\n\n  /**\n   * Updates a DOM node&apos;s innerHTML.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} html An HTML string.\n   * @internal\n   */\n  updateInnerHTMLByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateInnerHTMLByID&apos;,\n    function(id, html) {\n      var node = ReactMount.getNode(id);\n\n      // IE8: When updating a just created node with innerHTML only leading\n      // whitespace is removed. When updating an existing node with innerHTML\n      // whitespace in root TextNodes is also collapsed.\n      // @see quirksmode.org/bugreports/archives/2004/11/innerhtml_and_t.html\n\n      if (useWhitespaceWorkaround === undefined) {\n        // Feature detection; only IE8 is known to behave improperly like this.\n        var temp = document.createElement(&apos;div&apos;);\n        temp.innerHTML = &apos; &apos;;\n        useWhitespaceWorkaround = temp.innerHTML === &apos;&apos;;\n      }\n\n      if (useWhitespaceWorkaround) {\n        // Magic theory: IE8 supposedly differentiates between added and updated\n        // nodes when processing innerHTML, innerHTML on updated nodes suffers\n        // from worse whitespace behavior. Re-adding a node like this triggers\n        // the initial and more favorable whitespace behavior.\n        node.parentNode.replaceChild(node, node);\n      }\n\n      if (useWhitespaceWorkaround &amp;&amp; html.match(/^[ \\r\\n\\t\\f]/)) {\n        // Recover leading whitespace by temporarily prepending any character.\n        // \\uFEFF has the potential advantage of being zero-width/invisible.\n        node.innerHTML = &apos;\\uFEFF&apos; + html;\n        node.firstChild.deleteData(0, 1);\n      } else {\n        node.innerHTML = html;\n      }\n    }\n  ),\n\n  /**\n   * Updates a DOM node&apos;s text content set by `props.content`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} content Text content.\n   * @internal\n   */\n  updateTextContentByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateTextContentByID&apos;,\n    function(id, content) {\n      var node = ReactMount.getNode(id);\n      DOMChildrenOperations.updateTextContent(node, content);\n    }\n  ),\n\n  /**\n   * Replaces a DOM node that exists in the document with markup.\n   *\n   * @param {string} id ID of child to be replaced.\n   * @param {string} markup Dangerous markup to inject in place of child.\n   * @internal\n   * @see {Danger.dangerouslyReplaceNodeWithMarkup}\n   */\n  dangerouslyReplaceNodeWithMarkupByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;dangerouslyReplaceNodeWithMarkupByID&apos;,\n    function(id, markup) {\n      var node = ReactMount.getNode(id);\n      DOMChildrenOperations.dangerouslyReplaceNodeWithMarkup(node, markup);\n    }\n  ),\n\n  /**\n   * Updates a component&apos;s children by processing a series of updates.\n   *\n   * @param {array&lt;object&gt;} updates List of update configurations.\n   * @param {array&lt;string&gt;} markup List of markup strings.\n   * @internal\n   */\n  dangerouslyProcessChildrenUpdates: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;dangerouslyProcessChildrenUpdates&apos;,\n    function(updates, markup) {\n      for (var i = 0; i &lt; updates.length; i++) {\n        updates[i].parentNode = ReactMount.getNode(updates[i].parentID);\n      }\n      DOMChildrenOperations.processUpdates(updates, markup);\n    }\n  )\n};\n\nmodule.exports = ReactDOMIDOperations;\n\n},{&quot;./CSSPropertyOperations&quot;:3,&quot;./DOMChildrenOperations&quot;:7,&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./invariant&quot;:108}],37:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMImg\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\n// Store a reference to the &lt;img&gt; `ReactDOMComponent`.\nvar img = ReactDOM.img;\n\n/**\n * Since onLoad doesn&apos;t bubble OR capture on the top level in IE8, we need to\n * capture it on the &lt;img&gt; element itself. There are lots of hacks we could do\n * to accomplish this, but the most reliable is to make &lt;img&gt; a composite\n * component and use `componentDidMount` to attach the event handlers.\n */\nvar ReactDOMImg = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMImg&apos;,\n  tagName: &apos;IMG&apos;,\n\n  render: function() {\n    return img(this.props);\n  },\n\n  componentDidMount: function() {\n    var node = this.getDOMNode();\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topLoad,\n      &apos;load&apos;,\n      node\n    );\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topError,\n      &apos;error&apos;,\n      node\n    );\n  }\n});\n\nmodule.exports = ReactDOMImg;\n\n},{&quot;./EventConstants&quot;:14,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48}],38:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMInput\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;input&gt; `ReactDOMComponent`.\nvar input = ReactDOM.input;\n\nvar instancesByReactID = {};\n\n/**\n * Implements an &lt;input&gt; native component that allows setting these optional\n * props: `checked`, `value`, `defaultChecked`, and `defaultValue`.\n *\n * If `checked` or `value` are not supplied (or null/undefined), user actions\n * that affect the checked state or value will trigger updates to the element.\n *\n * If they are supplied (and not null/undefined), the rendered element will not\n * trigger updates to the element. Instead, the props must change in order for\n * the rendered element to be updated.\n *\n * The rendered element will be initialized as unchecked (or `defaultChecked`)\n * with an empty value (or `defaultValue`).\n *\n * @see http://www.w3.org/TR/2012/WD-html5-20121025/the-input-element.html\n */\nvar ReactDOMInput = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMInput&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  getInitialState: function() {\n    var defaultValue = this.props.defaultValue;\n    return {\n      checked: this.props.defaultChecked || false,\n      value: defaultValue != null ? defaultValue : null\n    };\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n\n    props.defaultChecked = null;\n    props.defaultValue = null;\n\n    var value = LinkedValueUtils.getValue(this);\n    props.value = value != null ? value : this.state.value;\n\n    var checked = LinkedValueUtils.getChecked(this);\n    props.checked = checked != null ? checked : this.state.checked;\n\n    props.onChange = this._handleChange;\n\n    return input(props, this.props.children);\n  },\n\n  componentDidMount: function() {\n    var id = ReactMount.getID(this.getDOMNode());\n    instancesByReactID[id] = this;\n  },\n\n  componentWillUnmount: function() {\n    var rootNode = this.getDOMNode();\n    var id = ReactMount.getID(rootNode);\n    delete instancesByReactID[id];\n  },\n\n  componentDidUpdate: function(prevProps, prevState, prevContext) {\n    var rootNode = this.getDOMNode();\n    if (this.props.checked != null) {\n      DOMPropertyOperations.setValueForProperty(\n        rootNode,\n        &apos;checked&apos;,\n        this.props.checked || false\n      );\n    }\n\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      // Cast `value` to a string to ensure the value is set correctly. While\n      // browsers typically do this as necessary, jsdom doesn&apos;t.\n      DOMPropertyOperations.setValueForProperty(rootNode, &apos;value&apos;, &apos;&apos; + value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n    this.setState({\n      checked: event.target.checked,\n      value: event.target.value\n    });\n\n    var name = this.props.name;\n    if (this.props.type === &apos;radio&apos; &amp;&amp; name != null) {\n      var rootNode = this.getDOMNode();\n      var queryRoot = rootNode;\n\n      while (queryRoot.parentNode) {\n        queryRoot = queryRoot.parentNode;\n      }\n\n      // If `rootNode.form` was non-null, then we could try `form.elements`,\n      // but that sometimes behaves strangely in IE8. We could also try using\n      // `form.getElementsByName`, but that will only return direct children\n      // and won&apos;t include inputs that use the HTML5 `form=` attribute. Since\n      // the input might not even be in a form, let&apos;s just use the global\n      // `querySelectorAll` to ensure we don&apos;t miss anything.\n      var group = queryRoot.querySelectorAll(\n        &apos;input[name=&apos; + JSON.stringify(&apos;&apos; + name) + &apos;][type=&quot;radio&quot;]&apos;);\n\n      for (var i = 0, groupLen = group.length; i &lt; groupLen; i++) {\n        var otherNode = group[i];\n        if (otherNode === rootNode ||\n            otherNode.form !== rootNode.form) {\n          continue;\n        }\n        var otherID = ReactMount.getID(otherNode);\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          otherID,\n          &apos;ReactDOMInput: Mixing React and non-React radio inputs with the &apos; +\n          &apos;same `name` is not supported.&apos;\n        ) : invariant(otherID));\n        var otherInstance = instancesByReactID[otherID];\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          otherInstance,\n          &apos;ReactDOMInput: Unknown radio button ID %s.&apos;,\n          otherID\n        ) : invariant(otherInstance));\n        // In some cases, this will actually change the `checked` state value.\n        // In other cases, there&apos;s no change but this forces a reconcile upon\n        // which componentDidUpdate will reset the DOM property to whatever it\n        // should be.\n        otherInstance.setState({\n          checked: false\n        });\n      }\n    }\n\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMInput;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./DOMPropertyOperations&quot;:9,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactMount&quot;:55,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],39:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMOption\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\n// Store a reference to the &lt;option&gt; `ReactDOMComponent`.\nvar option = ReactDOM.option;\n\n/**\n * Implements an &lt;option&gt; native component that warns when `selected` is set.\n */\nvar ReactDOMOption = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMOption&apos;,\n\n  componentWillMount: function() {\n    // TODO (yungsters): Remove support for `selected` in &lt;option&gt;.\n    if (this.props.selected != null) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.warn(\n          &apos;Use the `defaultValue` or `value` props on &lt;select&gt; instead of &apos; +\n          &apos;setting `selected` on &lt;option&gt;.&apos;\n        );\n      }\n    }\n  },\n\n  render: function() {\n    return option(this.props, this.props.children);\n  }\n\n});\n\nmodule.exports = ReactDOMOption;\n\n},{&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32}],40:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMSelect\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;select&gt; `ReactDOMComponent`.\nvar select = ReactDOM.select;\n\n/**\n * Validation function for `value` and `defaultValue`.\n * @private\n */\nfunction selectValueType(props, propName, componentName) {\n  if (props[propName] == null) {\n    return;\n  }\n  if (props.multiple) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Array.isArray(props[propName]),\n      &apos;The `%s` prop supplied to &lt;select&gt; must be an array if `multiple` is &apos; +\n      &apos;true.&apos;,\n      propName\n    ) : invariant(Array.isArray(props[propName])));\n  } else {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !Array.isArray(props[propName]),\n      &apos;The `%s` prop supplied to &lt;select&gt; must be a scalar value if &apos; +\n      &apos;`multiple` is false.&apos;,\n      propName\n    ) : invariant(!Array.isArray(props[propName])));\n  }\n}\n\n/**\n * If `value` is supplied, updates &lt;option&gt; elements on mount and update.\n * @param {ReactComponent} component Instance of ReactDOMSelect\n * @param {?*} propValue For uncontrolled components, null/undefined. For\n * controlled components, a string (or with `multiple`, a list of strings).\n * @private\n */\nfunction updateOptions(component, propValue) {\n  var multiple = component.props.multiple;\n  var value = propValue != null ? propValue : component.state.value;\n  var options = component.getDOMNode().options;\n  var selectedValue, i, l;\n  if (multiple) {\n    selectedValue = {};\n    for (i = 0, l = value.length; i &lt; l; ++i) {\n      selectedValue[&apos;&apos; + value[i]] = true;\n    }\n  } else {\n    selectedValue = &apos;&apos; + value;\n  }\n  for (i = 0, l = options.length; i &lt; l; i++) {\n    var selected = multiple ?\n      selectedValue.hasOwnProperty(options[i].value) :\n      options[i].value === selectedValue;\n\n    if (selected !== options[i].selected) {\n      options[i].selected = selected;\n    }\n  }\n}\n\n/**\n * Implements a &lt;select&gt; native component that allows optionally setting the\n * props `value` and `defaultValue`. If `multiple` is false, the prop must be a\n * string. If `multiple` is true, the prop must be an array of strings.\n *\n * If `value` is not supplied (or null/undefined), user actions that change the\n * selected option will trigger updates to the rendered options.\n *\n * If it is supplied (and not null/undefined), the rendered options will not\n * update in response to user actions. Instead, the `value` prop must change in\n * order for the rendered options to update.\n *\n * If `defaultValue` is provided, any options with the supplied values will be\n * selected.\n */\nvar ReactDOMSelect = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMSelect&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  propTypes: {\n    defaultValue: selectValueType,\n    value: selectValueType\n  },\n\n  getInitialState: function() {\n    return {value: this.props.defaultValue || (this.props.multiple ? [] : &apos;&apos;)};\n  },\n\n  componentWillReceiveProps: function(nextProps) {\n    if (!this.props.multiple &amp;&amp; nextProps.multiple) {\n      this.setState({value: [this.state.value]});\n    } else if (this.props.multiple &amp;&amp; !nextProps.multiple) {\n      this.setState({value: this.state.value[0]});\n    }\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n\n    props.onChange = this._handleChange;\n    props.value = null;\n\n    return select(props, this.props.children);\n  },\n\n  componentDidMount: function() {\n    updateOptions(this, LinkedValueUtils.getValue(this));\n  },\n\n  componentDidUpdate: function() {\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      updateOptions(this, value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n\n    var selectedValue;\n    if (this.props.multiple) {\n      selectedValue = [];\n      var options = event.target.options;\n      for (var i = 0, l = options.length; i &lt; l; i++) {\n        if (options[i].selected) {\n          selectedValue.push(options[i].value);\n        }\n      }\n    } else {\n      selectedValue = event.target.value;\n    }\n\n    this.setState({value: selectedValue});\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMSelect;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],41:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMSelection\n */\n\n&quot;use strict&quot;;\n\nvar getNodeForCharacterOffset = require(&quot;./getNodeForCharacterOffset&quot;);\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\n\n/**\n * Get the appropriate anchor and focus node/offset pairs for IE.\n *\n * The catch here is that IE&apos;s selection API doesn&apos;t provide information\n * about whether the selection is forward or backward, so we have to\n * behave as though it&apos;s always forward.\n *\n * IE text differs from modern selection in that it behaves as though\n * block elements end with a new line. This means character offsets will\n * differ between the two APIs.\n *\n * @param {DOMElement} node\n * @return {object}\n */\nfunction getIEOffsets(node) {\n  var selection = document.selection;\n  var selectedRange = selection.createRange();\n  var selectedLength = selectedRange.text.length;\n\n  // Duplicate selection so we can move range without breaking user selection.\n  var fromStart = selectedRange.duplicate();\n  fromStart.moveToElementText(node);\n  fromStart.setEndPoint(&apos;EndToStart&apos;, selectedRange);\n\n  var startOffset = fromStart.text.length;\n  var endOffset = startOffset + selectedLength;\n\n  return {\n    start: startOffset,\n    end: endOffset\n  };\n}\n\n/**\n * @param {DOMElement} node\n * @return {?object}\n */\nfunction getModernOffsets(node) {\n  var selection = window.getSelection();\n\n  if (selection.rangeCount === 0) {\n    return null;\n  }\n\n  var anchorNode = selection.anchorNode;\n  var anchorOffset = selection.anchorOffset;\n  var focusNode = selection.focusNode;\n  var focusOffset = selection.focusOffset;\n\n  var currentRange = selection.getRangeAt(0);\n  var rangeLength = currentRange.toString().length;\n\n  var tempRange = currentRange.cloneRange();\n  tempRange.selectNodeContents(node);\n  tempRange.setEnd(currentRange.startContainer, currentRange.startOffset);\n\n  var start = tempRange.toString().length;\n  var end = start + rangeLength;\n\n  // Detect whether the selection is backward.\n  var detectionRange = document.createRange();\n  detectionRange.setStart(anchorNode, anchorOffset);\n  detectionRange.setEnd(focusNode, focusOffset);\n  var isBackward = detectionRange.collapsed;\n  detectionRange.detach();\n\n  return {\n    start: isBackward ? end : start,\n    end: isBackward ? start : end\n  };\n}\n\n/**\n * @param {DOMElement|DOMTextNode} node\n * @param {object} offsets\n */\nfunction setIEOffsets(node, offsets) {\n  var range = document.selection.createRange().duplicate();\n  var start, end;\n\n  if (typeof offsets.end === &apos;undefined&apos;) {\n    start = offsets.start;\n    end = start;\n  } else if (offsets.start &gt; offsets.end) {\n    start = offsets.end;\n    end = offsets.start;\n  } else {\n    start = offsets.start;\n    end = offsets.end;\n  }\n\n  range.moveToElementText(node);\n  range.moveStart(&apos;character&apos;, start);\n  range.setEndPoint(&apos;EndToStart&apos;, range);\n  range.moveEnd(&apos;character&apos;, end - start);\n  range.select();\n}\n\n/**\n * In modern non-IE browsers, we can support both forward and backward\n * selections.\n *\n * Note: IE10+ supports the Selection object, but it does not support\n * the `extend` method, which means that even in modern IE, it&apos;s not possible\n * to programatically create a backward selection. Thus, for all IE\n * versions, we use the old IE API to create our selections.\n *\n * @param {DOMElement|DOMTextNode} node\n * @param {object} offsets\n */\nfunction setModernOffsets(node, offsets) {\n  var selection = window.getSelection();\n\n  var length = node[getTextContentAccessor()].length;\n  var start = Math.min(offsets.start, length);\n  var end = typeof offsets.end === &apos;undefined&apos; ?\n            start : Math.min(offsets.end, length);\n\n  // IE 11 uses modern selection, but doesn&apos;t support the extend method.\n  // Flip backward selections, so we can set with a single range.\n  if (!selection.extend &amp;&amp; start &gt; end) {\n    var temp = end;\n    end = start;\n    start = temp;\n  }\n\n  var startMarker = getNodeForCharacterOffset(node, start);\n  var endMarker = getNodeForCharacterOffset(node, end);\n\n  if (startMarker &amp;&amp; endMarker) {\n    var range = document.createRange();\n    range.setStart(startMarker.node, startMarker.offset);\n    selection.removeAllRanges();\n\n    if (start &gt; end) {\n      selection.addRange(range);\n      selection.extend(endMarker.node, endMarker.offset);\n    } else {\n      range.setEnd(endMarker.node, endMarker.offset);\n      selection.addRange(range);\n    }\n\n    range.detach();\n  }\n}\n\nvar ReactDOMSelection = {\n  /**\n   * @param {DOMElement} node\n   */\n  getOffsets: function(node) {\n    var getOffsets = document.selection ? getIEOffsets : getModernOffsets;\n    return getOffsets(node);\n  },\n\n  /**\n   * @param {DOMElement|DOMTextNode} node\n   * @param {object} offsets\n   */\n  setOffsets: function(node, offsets) {\n    var setOffsets = document.selection ? setIEOffsets : setModernOffsets;\n    setOffsets(node, offsets);\n  }\n};\n\nmodule.exports = ReactDOMSelection;\n\n},{&quot;./getNodeForCharacterOffset&quot;:103,&quot;./getTextContentAccessor&quot;:105}],42:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMTextarea\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;textarea&gt; `ReactDOMComponent`.\nvar textarea = ReactDOM.textarea;\n\n/**\n * Implements a &lt;textarea&gt; native component that allows setting `value`, and\n * `defaultValue`. This differs from the traditional DOM API because value is\n * usually set as PCDATA children.\n *\n * If `value` is not supplied (or null/undefined), user actions that affect the\n * value will trigger updates to the element.\n *\n * If `value` is supplied (and not null/undefined), the rendered element will\n * not trigger updates to the element. Instead, the `value` prop must change in\n * order for the rendered element to be updated.\n *\n * The rendered element will be initialized with an empty value, the prop\n * `defaultValue` if specified, or the children content (deprecated).\n */\nvar ReactDOMTextarea = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMTextarea&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  getInitialState: function() {\n    var defaultValue = this.props.defaultValue;\n    // TODO (yungsters): Remove support for children content in &lt;textarea&gt;.\n    var children = this.props.children;\n    if (children != null) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.warn(\n          &apos;Use the `defaultValue` or `value` props instead of setting &apos; +\n          &apos;children on &lt;textarea&gt;.&apos;\n        );\n      }\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        defaultValue == null,\n        &apos;If you supply `defaultValue` on a &lt;textarea&gt;, do not pass children.&apos;\n      ) : invariant(defaultValue == null));\n      if (Array.isArray(children)) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          children.length &lt;= 1,\n          &apos;&lt;textarea&gt; can only have at most one child.&apos;\n        ) : invariant(children.length &lt;= 1));\n        children = children[0];\n      }\n\n      defaultValue = &apos;&apos; + children;\n    }\n    if (defaultValue == null) {\n      defaultValue = &apos;&apos;;\n    }\n    var value = LinkedValueUtils.getValue(this);\n    return {\n      // We save the initial value so that `ReactDOMComponent` doesn&apos;t update\n      // `textContent` (unnecessary since we update value).\n      // The initial value can be a boolean or object so that&apos;s why it&apos;s\n      // forced to be a string.\n      initialValue: &apos;&apos; + (value != null ? value : defaultValue),\n      value: defaultValue\n    };\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n    var value = LinkedValueUtils.getValue(this);\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      props.dangerouslySetInnerHTML == null,\n      &apos;`dangerouslySetInnerHTML` does not make sense on &lt;textarea&gt;.&apos;\n    ) : invariant(props.dangerouslySetInnerHTML == null));\n\n    props.defaultValue = null;\n    props.value = value != null ? value : this.state.value;\n    props.onChange = this._handleChange;\n\n    // Always set children to the same thing. In IE9, the selection range will\n    // get reset if `textContent` is mutated.\n    return textarea(props, this.state.initialValue);\n  },\n\n  componentDidUpdate: function(prevProps, prevState, prevContext) {\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      var rootNode = this.getDOMNode();\n      // Cast `value` to a string to ensure the value is set correctly. While\n      // browsers typically do this as necessary, jsdom doesn&apos;t.\n      DOMPropertyOperations.setValueForProperty(rootNode, &apos;value&apos;, &apos;&apos; + value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n    this.setState({value: event.target.value});\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMTextarea;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./DOMPropertyOperations&quot;:9,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],43:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultBatchingStrategy\n */\n\n&quot;use strict&quot;;\n\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\nvar Transaction = require(&quot;./Transaction&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\nvar RESET_BATCHED_UPDATES = {\n  initialize: emptyFunction,\n  close: function() {\n    ReactDefaultBatchingStrategy.isBatchingUpdates = false;\n  }\n};\n\nvar FLUSH_BATCHED_UPDATES = {\n  initialize: emptyFunction,\n  close: ReactUpdates.flushBatchedUpdates.bind(ReactUpdates)\n};\n\nvar TRANSACTION_WRAPPERS = [FLUSH_BATCHED_UPDATES, RESET_BATCHED_UPDATES];\n\nfunction ReactDefaultBatchingStrategyTransaction() {\n  this.reinitializeTransaction();\n}\n\nmixInto(ReactDefaultBatchingStrategyTransaction, Transaction.Mixin);\nmixInto(ReactDefaultBatchingStrategyTransaction, {\n  getTransactionWrappers: function() {\n    return TRANSACTION_WRAPPERS;\n  }\n});\n\nvar transaction = new ReactDefaultBatchingStrategyTransaction();\n\nvar ReactDefaultBatchingStrategy = {\n  isBatchingUpdates: false,\n\n  /**\n   * Call the provided function in a context within which calls to `setState`\n   * and friends are batched such that components aren&apos;t updated unnecessarily.\n   */\n  batchedUpdates: function(callback, param) {\n    var alreadyBatchingUpdates = ReactDefaultBatchingStrategy.isBatchingUpdates;\n\n    ReactDefaultBatchingStrategy.isBatchingUpdates = true;\n\n    // The code is written this way to avoid extra allocations\n    if (alreadyBatchingUpdates) {\n      callback(param);\n    } else {\n      transaction.perform(callback, null, param);\n    }\n  }\n};\n\nmodule.exports = ReactDefaultBatchingStrategy;\n\n},{&quot;./ReactUpdates&quot;:70,&quot;./Transaction&quot;:84,&quot;./emptyFunction&quot;:95,&quot;./mixInto&quot;:120}],44:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultInjection\n */\n\n&quot;use strict&quot;;\n\nvar ReactInjection = require(&quot;./ReactInjection&quot;);\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar DefaultDOMPropertyConfig = require(&quot;./DefaultDOMPropertyConfig&quot;);\n\nvar ChangeEventPlugin = require(&quot;./ChangeEventPlugin&quot;);\nvar ClientReactRootIndex = require(&quot;./ClientReactRootIndex&quot;);\nvar CompositionEventPlugin = require(&quot;./CompositionEventPlugin&quot;);\nvar DefaultEventPluginOrder = require(&quot;./DefaultEventPluginOrder&quot;);\nvar EnterLeaveEventPlugin = require(&quot;./EnterLeaveEventPlugin&quot;);\nvar MobileSafariClickEventPlugin = require(&quot;./MobileSafariClickEventPlugin&quot;);\nvar ReactEventTopLevelCallback = require(&quot;./ReactEventTopLevelCallback&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactDOMButton = require(&quot;./ReactDOMButton&quot;);\nvar ReactDOMForm = require(&quot;./ReactDOMForm&quot;);\nvar ReactDOMImg = require(&quot;./ReactDOMImg&quot;);\nvar ReactDOMInput = require(&quot;./ReactDOMInput&quot;);\nvar ReactDOMOption = require(&quot;./ReactDOMOption&quot;);\nvar ReactDOMSelect = require(&quot;./ReactDOMSelect&quot;);\nvar ReactDOMTextarea = require(&quot;./ReactDOMTextarea&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar SelectEventPlugin = require(&quot;./SelectEventPlugin&quot;);\nvar ServerReactRootIndex = require(&quot;./ServerReactRootIndex&quot;);\nvar SimpleEventPlugin = require(&quot;./SimpleEventPlugin&quot;);\n\nvar ReactDefaultBatchingStrategy = require(&quot;./ReactDefaultBatchingStrategy&quot;);\n\nvar createFullPageComponent = require(&quot;./createFullPageComponent&quot;);\n\nfunction inject() {\n  ReactInjection.EventEmitter.injectTopLevelCallbackCreator(\n    ReactEventTopLevelCallback\n  );\n\n  /**\n   * Inject modules for resolving DOM hierarchy and plugin ordering.\n   */\n  ReactInjection.EventPluginHub.injectEventPluginOrder(DefaultEventPluginOrder);\n  ReactInjection.EventPluginHub.injectInstanceHandle(ReactInstanceHandles);\n  ReactInjection.EventPluginHub.injectMount(ReactMount);\n\n  /**\n   * Some important event plugins included by default (without having to require\n   * them).\n   */\n  ReactInjection.EventPluginHub.injectEventPluginsByName({\n    SimpleEventPlugin: SimpleEventPlugin,\n    EnterLeaveEventPlugin: EnterLeaveEventPlugin,\n    ChangeEventPlugin: ChangeEventPlugin,\n    CompositionEventPlugin: CompositionEventPlugin,\n    MobileSafariClickEventPlugin: MobileSafariClickEventPlugin,\n    SelectEventPlugin: SelectEventPlugin\n  });\n\n  ReactInjection.DOM.injectComponentClasses({\n    button: ReactDOMButton,\n    form: ReactDOMForm,\n    img: ReactDOMImg,\n    input: ReactDOMInput,\n    option: ReactDOMOption,\n    select: ReactDOMSelect,\n    textarea: ReactDOMTextarea,\n\n    html: createFullPageComponent(ReactDOM.html),\n    head: createFullPageComponent(ReactDOM.head),\n    title: createFullPageComponent(ReactDOM.title),\n    body: createFullPageComponent(ReactDOM.body)\n  });\n\n  ReactInjection.DOMProperty.injectDOMPropertyConfig(DefaultDOMPropertyConfig);\n\n  ReactInjection.Updates.injectBatchingStrategy(\n    ReactDefaultBatchingStrategy\n  );\n\n  ReactInjection.RootIndex.injectCreateReactRootIndex(\n    ExecutionEnvironment.canUseDOM ?\n      ClientReactRootIndex.createReactRootIndex :\n      ServerReactRootIndex.createReactRootIndex\n  );\n\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    var url = (ExecutionEnvironment.canUseDOM &amp;&amp; window.location.href) || &apos;&apos;;\n    if ((/[?&amp;]react_perf\\b/).test(url)) {\n      var ReactDefaultPerf = require(&quot;./ReactDefaultPerf&quot;);\n      ReactDefaultPerf.start();\n    }\n  }\n}\n\nmodule.exports = {\n  inject: inject\n};\n\n},{&quot;./ChangeEventPlugin&quot;:4,&quot;./ClientReactRootIndex&quot;:5,&quot;./CompositionEventPlugin&quot;:6,&quot;./DefaultDOMPropertyConfig&quot;:11,&quot;./DefaultEventPluginOrder&quot;:12,&quot;./EnterLeaveEventPlugin&quot;:13,&quot;./ExecutionEnvironment&quot;:20,&quot;./MobileSafariClickEventPlugin&quot;:22,&quot;./ReactDOM&quot;:32,&quot;./ReactDOMButton&quot;:33,&quot;./ReactDOMForm&quot;:35,&quot;./ReactDOMImg&quot;:37,&quot;./ReactDOMInput&quot;:38,&quot;./ReactDOMOption&quot;:39,&quot;./ReactDOMSelect&quot;:40,&quot;./ReactDOMTextarea&quot;:42,&quot;./ReactDefaultBatchingStrategy&quot;:43,&quot;./ReactDefaultPerf&quot;:45,&quot;./ReactEventTopLevelCallback&quot;:50,&quot;./ReactInjection&quot;:51,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./SelectEventPlugin&quot;:71,&quot;./ServerReactRootIndex&quot;:72,&quot;./SimpleEventPlugin&quot;:73,&quot;./createFullPageComponent&quot;:91}],45:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultPerf\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar ReactDefaultPerfAnalysis = require(&quot;./ReactDefaultPerfAnalysis&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar performanceNow = require(&quot;./performanceNow&quot;);\n\nfunction roundFloat(val) {\n  return Math.floor(val * 100) / 100;\n}\n\nvar ReactDefaultPerf = {\n  _allMeasurements: [], // last item in the list is the current one\n  _injected: false,\n\n  start: function() {\n    if (!ReactDefaultPerf._injected) {\n      ReactPerf.injection.injectMeasure(ReactDefaultPerf.measure);\n    }\n\n    ReactDefaultPerf._allMeasurements.length = 0;\n    ReactPerf.enableMeasure = true;\n  },\n\n  stop: function() {\n    ReactPerf.enableMeasure = false;\n  },\n\n  getLastMeasurements: function() {\n    return ReactDefaultPerf._allMeasurements;\n  },\n\n  printExclusive: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getExclusiveSummary(measurements);\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Component class name&apos;: item.componentName,\n        &apos;Total inclusive time (ms)&apos;: roundFloat(item.inclusive),\n        &apos;Total exclusive time (ms)&apos;: roundFloat(item.exclusive),\n        &apos;Exclusive time per instance (ms)&apos;: roundFloat(item.exclusive / item.count),\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printInclusive: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getInclusiveSummary(measurements);\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Owner &gt; component&apos;: item.componentName,\n        &apos;Inclusive time (ms)&apos;: roundFloat(item.time),\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printWasted: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getInclusiveSummary(\n      measurements,\n      true\n    );\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Owner &gt; component&apos;: item.componentName,\n        &apos;Wasted time (ms)&apos;: item.time,\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printDOM: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getDOMSummary(measurements);\n    console.table(summary.map(function(item) {\n      var result = {};\n      result[DOMProperty.ID_ATTRIBUTE_NAME] = item.id;\n      result[&apos;type&apos;] = item.type;\n      result[&apos;args&apos;] = JSON.stringify(item.args);\n      return result;\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  _recordWrite: function(id, fnName, totalTime, args) {\n    // TODO: totalTime isn&apos;t that useful since it doesn&apos;t count paints/reflows\n    var writes =\n      ReactDefaultPerf\n        ._allMeasurements[ReactDefaultPerf._allMeasurements.length - 1]\n        .writes;\n    writes[id] = writes[id] || [];\n    writes[id].push({\n      type: fnName,\n      time: totalTime,\n      args: args\n    });\n  },\n\n  measure: function(moduleName, fnName, func) {\n    return function() {var args=Array.prototype.slice.call(arguments,0);\n      var totalTime;\n      var rv;\n      var start;\n\n      if (fnName === &apos;_renderNewRootComponent&apos; ||\n          fnName === &apos;flushBatchedUpdates&apos;) {\n        // A &quot;measurement&quot; is a set of metrics recorded for each flush. We want\n        // to group the metrics for a given flush together so we can look at the\n        // components that rendered and the DOM operations that actually\n        // happened to determine the amount of &quot;wasted work&quot; performed.\n        ReactDefaultPerf._allMeasurements.push({\n          exclusive: {},\n          inclusive: {},\n          counts: {},\n          writes: {},\n          displayNames: {},\n          totalTime: 0\n        });\n        start = performanceNow();\n        rv = func.apply(this, args);\n        ReactDefaultPerf._allMeasurements[\n          ReactDefaultPerf._allMeasurements.length - 1\n        ].totalTime = performanceNow() - start;\n        return rv;\n      } else if (moduleName === &apos;ReactDOMIDOperations&apos; ||\n        moduleName === &apos;ReactComponentBrowserEnvironment&apos;) {\n        start = performanceNow();\n        rv = func.apply(this, args);\n        totalTime = performanceNow() - start;\n\n        if (fnName === &apos;mountImageIntoNode&apos;) {\n          var mountID = ReactMount.getID(args[1]);\n          ReactDefaultPerf._recordWrite(mountID, fnName, totalTime, args[0]);\n        } else if (fnName === &apos;dangerouslyProcessChildrenUpdates&apos;) {\n          // special format\n          args[0].forEach(function(update) {\n            var writeArgs = {};\n            if (update.fromIndex !== null) {\n              writeArgs.fromIndex = update.fromIndex;\n            }\n            if (update.toIndex !== null) {\n              writeArgs.toIndex = update.toIndex;\n            }\n            if (update.textContent !== null) {\n              writeArgs.textContent = update.textContent;\n            }\n            if (update.markupIndex !== null) {\n              writeArgs.markup = args[1][update.markupIndex];\n            }\n            ReactDefaultPerf._recordWrite(\n              update.parentID,\n              update.type,\n              totalTime,\n              writeArgs\n            );\n          });\n        } else {\n          // basic format\n          ReactDefaultPerf._recordWrite(\n            args[0],\n            fnName,\n            totalTime,\n            Array.prototype.slice.call(args, 1)\n          );\n        }\n        return rv;\n      } else if (moduleName === &apos;ReactCompositeComponent&apos; &amp;&amp; (\n        fnName === &apos;mountComponent&apos; ||\n        fnName === &apos;updateComponent&apos; || // TODO: receiveComponent()?\n        fnName === &apos;_renderValidatedComponent&apos;)) {\n\n        var rootNodeID = fnName === &apos;mountComponent&apos; ?\n          args[0] :\n          this._rootNodeID;\n        var isRender = fnName === &apos;_renderValidatedComponent&apos;;\n        var entry = ReactDefaultPerf._allMeasurements[\n          ReactDefaultPerf._allMeasurements.length - 1\n        ];\n\n        if (isRender) {\n          entry.counts[rootNodeID] = entry.counts[rootNodeID] || 0;\n          entry.counts[rootNodeID] += 1;\n        }\n\n        start = performanceNow();\n        rv = func.apply(this, args);\n        totalTime = performanceNow() - start;\n\n        var typeOfLog = isRender ? entry.exclusive : entry.inclusive;\n        typeOfLog[rootNodeID] = typeOfLog[rootNodeID] || 0;\n        typeOfLog[rootNodeID] += totalTime;\n\n        entry.displayNames[rootNodeID] = {\n          current: this.constructor.displayName,\n          owner: this._owner ? this._owner.constructor.displayName : &apos;&lt;root&gt;&apos;\n        };\n\n        return rv;\n      } else {\n        return func.apply(this, args);\n      }\n    };\n  }\n};\n\nmodule.exports = ReactDefaultPerf;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./ReactDefaultPerfAnalysis&quot;:46,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./performanceNow&quot;:124}],46:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultPerfAnalysis\n */\n\nvar merge = require(&quot;./merge&quot;);\n\n// Don&apos;t try to save users less than 1.2ms (a number I made up)\nvar DONT_CARE_THRESHOLD = 1.2;\nvar DOM_OPERATION_TYPES = {\n  &apos;mountImageIntoNode&apos;: &apos;set innerHTML&apos;,\n  INSERT_MARKUP: &apos;set innerHTML&apos;,\n  MOVE_EXISTING: &apos;move&apos;,\n  REMOVE_NODE: &apos;remove&apos;,\n  TEXT_CONTENT: &apos;set textContent&apos;,\n  &apos;updatePropertyByID&apos;: &apos;update attribute&apos;,\n  &apos;deletePropertyByID&apos;: &apos;delete attribute&apos;,\n  &apos;updateStylesByID&apos;: &apos;update styles&apos;,\n  &apos;updateInnerHTMLByID&apos;: &apos;set innerHTML&apos;,\n  &apos;dangerouslyReplaceNodeWithMarkupByID&apos;: &apos;replace&apos;\n};\n\nfunction getTotalTime(measurements) {\n  // TODO: return number of DOM ops? could be misleading.\n  // TODO: measure dropped frames after reconcile?\n  // TODO: log total time of each reconcile and the top-level component\n  // class that triggered it.\n  var totalTime = 0;\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    totalTime += measurement.totalTime;\n  }\n  return totalTime;\n}\n\nfunction getDOMSummary(measurements) {\n  var items = [];\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var id;\n\n    for (id in measurement.writes) {\n      measurement.writes[id].forEach(function(write) {\n        items.push({\n          id: id,\n          type: DOM_OPERATION_TYPES[write.type] || write.type,\n          args: write.args\n        });\n      });\n    }\n  }\n  return items;\n}\n\nfunction getExclusiveSummary(measurements) {\n  var candidates = {};\n  var displayName;\n\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var allIDs = merge(measurement.exclusive, measurement.inclusive);\n\n    for (var id in allIDs) {\n      displayName = measurement.displayNames[id].current;\n\n      candidates[displayName] = candidates[displayName] || {\n        componentName: displayName,\n        inclusive: 0,\n        exclusive: 0,\n        count: 0\n      };\n      if (measurement.exclusive[id]) {\n        candidates[displayName].exclusive += measurement.exclusive[id];\n      }\n      if (measurement.inclusive[id]) {\n        candidates[displayName].inclusive += measurement.inclusive[id];\n      }\n      if (measurement.counts[id]) {\n        candidates[displayName].count += measurement.counts[id];\n      }\n    }\n  }\n\n  // Now make a sorted array with the results.\n  var arr = [];\n  for (displayName in candidates) {\n    if (candidates[displayName].exclusive &gt;= DONT_CARE_THRESHOLD) {\n      arr.push(candidates[displayName]);\n    }\n  }\n\n  arr.sort(function(a, b) {\n    return b.exclusive - a.exclusive;\n  });\n\n  return arr;\n}\n\nfunction getInclusiveSummary(measurements, onlyClean) {\n  var candidates = {};\n  var inclusiveKey;\n\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var allIDs = merge(measurement.exclusive, measurement.inclusive);\n    var cleanComponents;\n\n    if (onlyClean) {\n      cleanComponents = getUnchangedComponents(measurement);\n    }\n\n    for (var id in allIDs) {\n      if (onlyClean &amp;&amp; !cleanComponents[id]) {\n        continue;\n      }\n\n      var displayName = measurement.displayNames[id];\n\n      // Inclusive time is not useful for many components without knowing where\n      // they are instantiated. So we aggregate inclusive time with both the\n      // owner and current displayName as the key.\n      inclusiveKey = displayName.owner + &apos; &gt; &apos; + displayName.current;\n\n      candidates[inclusiveKey] = candidates[inclusiveKey] || {\n        componentName: inclusiveKey,\n        time: 0,\n        count: 0\n      };\n\n      if (measurement.inclusive[id]) {\n        candidates[inclusiveKey].time += measurement.inclusive[id];\n      }\n      if (measurement.counts[id]) {\n        candidates[inclusiveKey].count += measurement.counts[id];\n      }\n    }\n  }\n\n  // Now make a sorted array with the results.\n  var arr = [];\n  for (inclusiveKey in candidates) {\n    if (candidates[inclusiveKey].time &gt;= DONT_CARE_THRESHOLD) {\n      arr.push(candidates[inclusiveKey]);\n    }\n  }\n\n  arr.sort(function(a, b) {\n    return b.time - a.time;\n  });\n\n  return arr;\n}\n\nfunction getUnchangedComponents(measurement) {\n  // For a given reconcile, look at which components did not actually\n  // render anything to the DOM and return a mapping of their ID to\n  // the amount of time it took to render the entire subtree.\n  var cleanComponents = {};\n  var dirtyLeafIDs = Object.keys(measurement.writes);\n  var allIDs = merge(measurement.exclusive, measurement.inclusive);\n\n  for (var id in allIDs) {\n    var isDirty = false;\n    // For each component that rendered, see if a component that triggerd\n    // a DOM op is in its subtree.\n    for (var i = 0; i &lt; dirtyLeafIDs.length; i++) {\n      if (dirtyLeafIDs[i].indexOf(id) === 0) {\n        isDirty = true;\n        break;\n      }\n    }\n    if (!isDirty &amp;&amp; measurement.counts[id] &gt; 0) {\n      cleanComponents[id] = true;\n    }\n  }\n  return cleanComponents;\n}\n\nvar ReactDefaultPerfAnalysis = {\n  getExclusiveSummary: getExclusiveSummary,\n  getInclusiveSummary: getInclusiveSummary,\n  getDOMSummary: getDOMSummary,\n  getTotalTime: getTotalTime\n};\n\nmodule.exports = ReactDefaultPerfAnalysis;\n\n},{&quot;./merge&quot;:117}],47:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactErrorUtils\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar ReactErrorUtils = {\n  /**\n   * Creates a guarded version of a function. This is supposed to make debugging\n   * of event handlers easier. To aid debugging with the browser&apos;s debugger,\n   * this currently simply returns the original function.\n   *\n   * @param {function} func Function to be executed\n   * @param {string} name The name of the guard\n   * @return {function}\n   */\n  guard: function(func, name) {\n    return func;\n  }\n};\n\nmodule.exports = ReactErrorUtils;\n\n},{}],48:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventEmitter\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventListener = require(&quot;./EventListener&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar EventPluginRegistry = require(&quot;./EventPluginRegistry&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactEventEmitterMixin = require(&quot;./ReactEventEmitterMixin&quot;);\nvar ViewportMetrics = require(&quot;./ViewportMetrics&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Summary of `ReactEventEmitter` event handling:\n *\n *  - Top-level delegation is used to trap native browser events. We normalize\n *    and de-duplicate events to account for browser quirks.\n *\n *  - Forward these native events (with the associated top-level type used to\n *    trap it) to `EventPluginHub`, which in turn will ask plugins if they want\n *    to extract any synthetic events.\n *\n *  - The `EventPluginHub` will then process each event by annotating them with\n *    &quot;dispatches&quot;, a sequence of listeners and IDs that care about that event.\n *\n *  - The `EventPluginHub` then dispatches the events.\n *\n * Overview of React and the event system:\n *\n *                   .\n * +------------+    .\n * |    DOM     |    .\n * +------------+    .                         +-----------+\n *       +           .               +--------+|SimpleEvent|\n *       |           .               |         |Plugin     |\n * +-----|------+    .               v         +-----------+\n * |     |      |    .    +--------------+                    +------------+\n * |     +-----------.---&gt;|EventPluginHub|                    |    Event   |\n * |            |    .    |              |     +-----------+  | Propagators|\n * | ReactEvent |    .    |              |     |TapEvent   |  |------------|\n * |  Emitter   |    .    |              |&lt;---+|Plugin     |  |other plugin|\n * |            |    .    |              |     +-----------+  |  utilities |\n * |     +-----------.---&gt;|              |                    +------------+\n * |     |      |    .    +--------------+\n * +-----|------+    .                ^        +-----------+\n *       |           .                |        |Enter/Leave|\n *       +           .                +-------+|Plugin     |\n * +-------------+   .                         +-----------+\n * | application |   .\n * |-------------|   .\n * |             |   .\n * |             |   .\n * +-------------+   .\n *                   .\n *    React Core     .  General Purpose Event Plugin System\n */\n\nvar alreadyListeningTo = {};\nvar isMonitoringScrollValue = false;\nvar reactTopListenersCounter = 0;\n\n// For events like &apos;submit&apos; which don&apos;t consistently bubble (which we trap at a\n// lower node than `document`), binding at `document` would cause duplicate\n// events so we don&apos;t include them here\nvar topEventMapping = {\n  topBlur: &apos;blur&apos;,\n  topChange: &apos;change&apos;,\n  topClick: &apos;click&apos;,\n  topCompositionEnd: &apos;compositionend&apos;,\n  topCompositionStart: &apos;compositionstart&apos;,\n  topCompositionUpdate: &apos;compositionupdate&apos;,\n  topContextMenu: &apos;contextmenu&apos;,\n  topCopy: &apos;copy&apos;,\n  topCut: &apos;cut&apos;,\n  topDoubleClick: &apos;dblclick&apos;,\n  topDrag: &apos;drag&apos;,\n  topDragEnd: &apos;dragend&apos;,\n  topDragEnter: &apos;dragenter&apos;,\n  topDragExit: &apos;dragexit&apos;,\n  topDragLeave: &apos;dragleave&apos;,\n  topDragOver: &apos;dragover&apos;,\n  topDragStart: &apos;dragstart&apos;,\n  topDrop: &apos;drop&apos;,\n  topFocus: &apos;focus&apos;,\n  topInput: &apos;input&apos;,\n  topKeyDown: &apos;keydown&apos;,\n  topKeyPress: &apos;keypress&apos;,\n  topKeyUp: &apos;keyup&apos;,\n  topMouseDown: &apos;mousedown&apos;,\n  topMouseMove: &apos;mousemove&apos;,\n  topMouseOut: &apos;mouseout&apos;,\n  topMouseOver: &apos;mouseover&apos;,\n  topMouseUp: &apos;mouseup&apos;,\n  topPaste: &apos;paste&apos;,\n  topScroll: &apos;scroll&apos;,\n  topSelectionChange: &apos;selectionchange&apos;,\n  topTouchCancel: &apos;touchcancel&apos;,\n  topTouchEnd: &apos;touchend&apos;,\n  topTouchMove: &apos;touchmove&apos;,\n  topTouchStart: &apos;touchstart&apos;,\n  topWheel: &apos;wheel&apos;\n};\n\n/**\n * To ensure no conflicts with other potential React instances on the page\n */\nvar topListenersIDKey = &quot;_reactListenersID&quot; + String(Math.random()).slice(2);\n\nfunction getListeningForDocument(mountAt) {\n  if (mountAt[topListenersIDKey] == null) {\n    mountAt[topListenersIDKey] = reactTopListenersCounter++;\n    alreadyListeningTo[mountAt[topListenersIDKey]] = {};\n  }\n  return alreadyListeningTo[mountAt[topListenersIDKey]];\n}\n\n/**\n * Traps top-level events by using event bubbling.\n *\n * @param {string} topLevelType Record from `EventConstants`.\n * @param {string} handlerBaseName Event name (e.g. &quot;click&quot;).\n * @param {DOMEventTarget} element Element on which to attach listener.\n * @internal\n */\nfunction trapBubbledEvent(topLevelType, handlerBaseName, element) {\n  EventListener.listen(\n    element,\n    handlerBaseName,\n    ReactEventEmitter.TopLevelCallbackCreator.createTopLevelCallback(\n      topLevelType\n    )\n  );\n}\n\n/**\n * Traps a top-level event by using event capturing.\n *\n * @param {string} topLevelType Record from `EventConstants`.\n * @param {string} handlerBaseName Event name (e.g. &quot;click&quot;).\n * @param {DOMEventTarget} element Element on which to attach listener.\n * @internal\n */\nfunction trapCapturedEvent(topLevelType, handlerBaseName, element) {\n  EventListener.capture(\n    element,\n    handlerBaseName,\n    ReactEventEmitter.TopLevelCallbackCreator.createTopLevelCallback(\n      topLevelType\n    )\n  );\n}\n\n/**\n * `ReactEventEmitter` is used to attach top-level event listeners. For example:\n *\n *   ReactEventEmitter.putListener(&apos;myID&apos;, &apos;onClick&apos;, myFunction);\n *\n * This would allocate a &quot;registration&quot; of `(&apos;onClick&apos;, myFunction)` on &apos;myID&apos;.\n *\n * @internal\n */\nvar ReactEventEmitter = merge(ReactEventEmitterMixin, {\n\n  /**\n   * React references `ReactEventTopLevelCallback` using this property in order\n   * to allow dependency injection.\n   */\n  TopLevelCallbackCreator: null,\n\n  injection: {\n    /**\n     * @param {function} TopLevelCallbackCreator\n     */\n    injectTopLevelCallbackCreator: function(TopLevelCallbackCreator) {\n      ReactEventEmitter.TopLevelCallbackCreator = TopLevelCallbackCreator;\n    }\n  },\n\n  /**\n   * Sets whether or not any created callbacks should be enabled.\n   *\n   * @param {boolean} enabled True if callbacks should be enabled.\n   */\n  setEnabled: function(enabled) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;setEnabled(...): Cannot toggle event listening in a Worker thread. &apos; +\n      &apos;This is likely a bug in the framework. Please report immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    if (ReactEventEmitter.TopLevelCallbackCreator) {\n      ReactEventEmitter.TopLevelCallbackCreator.setEnabled(enabled);\n    }\n  },\n\n  /**\n   * @return {boolean} True if callbacks are enabled.\n   */\n  isEnabled: function() {\n    return !!(\n      ReactEventEmitter.TopLevelCallbackCreator &amp;&amp;\n      ReactEventEmitter.TopLevelCallbackCreator.isEnabled()\n    );\n  },\n\n  /**\n   * We listen for bubbled touch events on the document object.\n   *\n   * Firefox v8.01 (and possibly others) exhibited strange behavior when\n   * mounting `onmousemove` events at some node that was not the document\n   * element. The symptoms were that if your mouse is not moving over something\n   * contained within that mount point (for example on the background) the\n   * top-level listeners for `onmousemove` won&apos;t be called. However, if you\n   * register the `mousemove` on the document object, then it will of course\n   * catch all `mousemove`s. This along with iOS quirks, justifies restricting\n   * top-level listeners to the document object only, at least for these\n   * movement types of events and possibly all events.\n   *\n   * @see http://www.quirksmode.org/blog/archives/2010/09/click_event_del.html\n   *\n   * Also, `keyup`/`keypress`/`keydown` do not bubble to the window on IE, but\n   * they bubble to document.\n   *\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @param {DOMDocument} contentDocument Document which owns the container\n   */\n  listenTo: function(registrationName, contentDocument) {\n    var mountAt = contentDocument;\n    var isListening = getListeningForDocument(mountAt);\n    var dependencies = EventPluginRegistry.\n      registrationNameDependencies[registrationName];\n\n    var topLevelTypes = EventConstants.topLevelTypes;\n    for (var i = 0, l = dependencies.length; i &lt; l; i++) {\n      var dependency = dependencies[i];\n      if (!isListening[dependency]) {\n        var topLevelType = topLevelTypes[dependency];\n\n        if (topLevelType === topLevelTypes.topWheel) {\n          if (isEventSupported(&apos;wheel&apos;)) {\n            trapBubbledEvent(topLevelTypes.topWheel, &apos;wheel&apos;, mountAt);\n          } else if (isEventSupported(&apos;mousewheel&apos;)) {\n            trapBubbledEvent(topLevelTypes.topWheel, &apos;mousewheel&apos;, mountAt);\n          } else {\n            // Firefox needs to capture a different mouse scroll event.\n            // @see http://www.quirksmode.org/dom/events/tests/scroll.html\n            trapBubbledEvent(\n              topLevelTypes.topWheel,\n              &apos;DOMMouseScroll&apos;,\n              mountAt);\n          }\n        } else if (topLevelType === topLevelTypes.topScroll) {\n\n          if (isEventSupported(&apos;scroll&apos;, true)) {\n            trapCapturedEvent(topLevelTypes.topScroll, &apos;scroll&apos;, mountAt);\n          } else {\n            trapBubbledEvent(topLevelTypes.topScroll, &apos;scroll&apos;, window);\n          }\n        } else if (topLevelType === topLevelTypes.topFocus ||\n            topLevelType === topLevelTypes.topBlur) {\n\n          if (isEventSupported(&apos;focus&apos;, true)) {\n            trapCapturedEvent(topLevelTypes.topFocus, &apos;focus&apos;, mountAt);\n            trapCapturedEvent(topLevelTypes.topBlur, &apos;blur&apos;, mountAt);\n          } else if (isEventSupported(&apos;focusin&apos;)) {\n            // IE has `focusin` and `focusout` events which bubble.\n            // @see http://www.quirksmode.org/blog/archives/2008/04/delegating_the.html\n            trapBubbledEvent(topLevelTypes.topFocus, &apos;focusin&apos;, mountAt);\n            trapBubbledEvent(topLevelTypes.topBlur, &apos;focusout&apos;, mountAt);\n          }\n\n          // to make sure blur and focus event listeners are only attached once\n          isListening[topLevelTypes.topBlur] = true;\n          isListening[topLevelTypes.topFocus] = true;\n        } else if (topEventMapping[dependency]) {\n          trapBubbledEvent(topLevelType, topEventMapping[dependency], mountAt);\n        }\n\n        isListening[dependency] = true;\n      }\n    }\n  },\n\n  /**\n   * Listens to window scroll and resize events. We cache scroll values so that\n   * application code can access them without triggering reflows.\n   *\n   * NOTE: Scroll events do not bubble.\n   *\n   * @see http://www.quirksmode.org/dom/events/scroll.html\n   */\n  ensureScrollValueMonitoring: function(){\n    if (!isMonitoringScrollValue) {\n      var refresh = ViewportMetrics.refreshScrollValues;\n      EventListener.listen(window, &apos;scroll&apos;, refresh);\n      EventListener.listen(window, &apos;resize&apos;, refresh);\n      isMonitoringScrollValue = true;\n    }\n  },\n\n  eventNameDispatchConfigs: EventPluginHub.eventNameDispatchConfigs,\n\n  registrationNameModules: EventPluginHub.registrationNameModules,\n\n  putListener: EventPluginHub.putListener,\n\n  getListener: EventPluginHub.getListener,\n\n  deleteListener: EventPluginHub.deleteListener,\n\n  deleteAllListeners: EventPluginHub.deleteAllListeners,\n\n  trapBubbledEvent: trapBubbledEvent,\n\n  trapCapturedEvent: trapCapturedEvent\n\n});\n\nmodule.exports = ReactEventEmitter;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventListener&quot;:15,&quot;./EventPluginHub&quot;:16,&quot;./EventPluginRegistry&quot;:17,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactEventEmitterMixin&quot;:49,&quot;./ViewportMetrics&quot;:85,&quot;./invariant&quot;:108,&quot;./isEventSupported&quot;:109,&quot;./merge&quot;:117}],49:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventEmitterMixin\n */\n\n&quot;use strict&quot;;\n\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nfunction runEventQueueInBatch(events) {\n  EventPluginHub.enqueueEvents(events);\n  EventPluginHub.processEventQueue();\n}\n\nvar ReactEventEmitterMixin = {\n\n  /**\n   * Streams a fired top-level event to `EventPluginHub` where plugins have the\n   * opportunity to create `ReactEvent`s to be dispatched.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {object} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native environment event.\n   */\n  handleTopLevel: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var events = EventPluginHub.extractEvents(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent\n    );\n\n    // Event queue being processed in the same cycle allows `preventDefault`.\n    ReactUpdates.batchedUpdates(runEventQueueInBatch, events);\n  }\n};\n\nmodule.exports = ReactEventEmitterMixin;\n\n},{&quot;./EventPluginHub&quot;:16,&quot;./ReactUpdates&quot;:70}],50:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventTopLevelCallback\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\n\nvar getEventTarget = require(&quot;./getEventTarget&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * @type {boolean}\n * @private\n */\nvar _topLevelListenersEnabled = true;\n\n/**\n * Finds the parent React component of `node`.\n *\n * @param {*} node\n * @return {?DOMEventTarget} Parent container, or `null` if the specified node\n *                           is not nested.\n */\nfunction findParent(node) {\n  // TODO: It may be a good idea to cache this to prevent unnecessary DOM\n  // traversal, but caching is difficult to do correctly without using a\n  // mutation observer to listen for all DOM changes.\n  var nodeID = ReactMount.getID(node);\n  var rootID = ReactInstanceHandles.getReactRootIDFromNodeID(nodeID);\n  var container = ReactMount.findReactContainerForID(rootID);\n  var parent = ReactMount.getFirstReactDOM(container);\n  return parent;\n}\n\n/**\n * Calls ReactEventEmitter.handleTopLevel for each node stored in bookKeeping&apos;s\n * ancestor list. Separated from createTopLevelCallback to avoid try/finally\n * deoptimization.\n *\n * @param {string} topLevelType\n * @param {DOMEvent} nativeEvent\n * @param {TopLevelCallbackBookKeeping} bookKeeping\n */\nfunction handleTopLevelImpl(topLevelType, nativeEvent, bookKeeping) {\n  var topLevelTarget = ReactMount.getFirstReactDOM(\n    getEventTarget(nativeEvent)\n  ) || window;\n\n  // Loop through the hierarchy, in case there&apos;s any nested components.\n  // It&apos;s important that we build the array of ancestors before calling any\n  // event handlers, because event handlers can modify the DOM, leading to\n  // inconsistencies with ReactMount&apos;s node cache. See #1105.\n  var ancestor = topLevelTarget;\n  while (ancestor) {\n    bookKeeping.ancestors.push(ancestor);\n    ancestor = findParent(ancestor);\n  }\n\n  for (var i = 0, l = bookKeeping.ancestors.length; i &lt; l; i++) {\n    topLevelTarget = bookKeeping.ancestors[i];\n    var topLevelTargetID = ReactMount.getID(topLevelTarget) || &apos;&apos;;\n    ReactEventEmitter.handleTopLevel(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent\n    );\n  }\n}\n\n// Used to store ancestor hierarchy in top level callback\nfunction TopLevelCallbackBookKeeping() {\n  this.ancestors = [];\n}\nmixInto(TopLevelCallbackBookKeeping, {\n  destructor: function() {\n    this.ancestors.length = 0;\n  }\n});\nPooledClass.addPoolingTo(TopLevelCallbackBookKeeping);\n\n/**\n * Top-level callback creator used to implement event handling using delegation.\n * This is used via dependency injection.\n */\nvar ReactEventTopLevelCallback = {\n\n  /**\n   * Sets whether or not any created callbacks should be enabled.\n   *\n   * @param {boolean} enabled True if callbacks should be enabled.\n   */\n  setEnabled: function(enabled) {\n    _topLevelListenersEnabled = !!enabled;\n  },\n\n  /**\n   * @return {boolean} True if callbacks are enabled.\n   */\n  isEnabled: function() {\n    return _topLevelListenersEnabled;\n  },\n\n  /**\n   * Creates a callback for the supplied `topLevelType` that could be added as\n   * a listener to the document. The callback computes a `topLevelTarget` which\n   * should be the root node of a mounted React component where the listener\n   * is attached.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @return {function} Callback for handling top-level events.\n   */\n  createTopLevelCallback: function(topLevelType) {\n    return function(nativeEvent) {\n      if (!_topLevelListenersEnabled) {\n        return;\n      }\n\n      var bookKeeping = TopLevelCallbackBookKeeping.getPooled();\n      try {\n        handleTopLevelImpl(topLevelType, nativeEvent, bookKeeping);\n      } finally {\n        TopLevelCallbackBookKeeping.release(bookKeeping);\n      }\n    };\n  }\n\n};\n\nmodule.exports = ReactEventTopLevelCallback;\n\n},{&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./getEventTarget&quot;:101,&quot;./mixInto&quot;:120}],51:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInjection\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactRootIndex = require(&quot;./ReactRootIndex&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar ReactInjection = {\n  DOMProperty: DOMProperty.injection,\n  EventPluginHub: EventPluginHub.injection,\n  DOM: ReactDOM.injection,\n  EventEmitter: ReactEventEmitter.injection,\n  Perf: ReactPerf.injection,\n  RootIndex: ReactRootIndex.injection,\n  Updates: ReactUpdates.injection\n};\n\nmodule.exports = ReactInjection;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./EventPluginHub&quot;:16,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactPerf&quot;:60,&quot;./ReactRootIndex&quot;:67,&quot;./ReactUpdates&quot;:70}],52:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInputSelection\n */\n\n&quot;use strict&quot;;\n\nvar ReactDOMSelection = require(&quot;./ReactDOMSelection&quot;);\n\nvar containsNode = require(&quot;./containsNode&quot;);\nvar getActiveElement = require(&quot;./getActiveElement&quot;);\n\nfunction isInDocument(node) {\n  return containsNode(document.documentElement, node);\n}\n\n/**\n * @ReactInputSelection: React input selection module. Based on Selection.js,\n * but modified to be suitable for react and has a couple of bug fixes (doesn&apos;t\n * assume buttons have range selections allowed).\n * Input selection module for React.\n */\nvar ReactInputSelection = {\n\n  hasSelectionCapabilities: function(elem) {\n    return elem &amp;&amp; (\n      (elem.nodeName === &apos;INPUT&apos; &amp;&amp; elem.type === &apos;text&apos;) ||\n      elem.nodeName === &apos;TEXTAREA&apos; ||\n      elem.contentEditable === &apos;true&apos;\n    );\n  },\n\n  getSelectionInformation: function() {\n    var focusedElem = getActiveElement();\n    return {\n      focusedElem: focusedElem,\n      selectionRange:\n          ReactInputSelection.hasSelectionCapabilities(focusedElem) ?\n          ReactInputSelection.getSelection(focusedElem) :\n          null\n    };\n  },\n\n  /**\n   * @restoreSelection: If any selection information was potentially lost,\n   * restore it. This is useful when performing operations that could remove dom\n   * nodes and place them back in, resulting in focus being lost.\n   */\n  restoreSelection: function(priorSelectionInformation) {\n    var curFocusedElem = getActiveElement();\n    var priorFocusedElem = priorSelectionInformation.focusedElem;\n    var priorSelectionRange = priorSelectionInformation.selectionRange;\n    if (curFocusedElem !== priorFocusedElem &amp;&amp;\n        isInDocument(priorFocusedElem)) {\n      if (ReactInputSelection.hasSelectionCapabilities(priorFocusedElem)) {\n        ReactInputSelection.setSelection(\n          priorFocusedElem,\n          priorSelectionRange\n        );\n      }\n      priorFocusedElem.focus();\n    }\n  },\n\n  /**\n   * @getSelection: Gets the selection bounds of a focused textarea, input or\n   * contentEditable node.\n   * -@input: Look up selection bounds of this input\n   * -@return {start: selectionStart, end: selectionEnd}\n   */\n  getSelection: function(input) {\n    var selection;\n\n    if (&apos;selectionStart&apos; in input) {\n      // Modern browser with input or textarea.\n      selection = {\n        start: input.selectionStart,\n        end: input.selectionEnd\n      };\n    } else if (document.selection &amp;&amp; input.nodeName === &apos;INPUT&apos;) {\n      // IE8 input.\n      var range = document.selection.createRange();\n      // There can only be one selection per document in IE, so it must\n      // be in our element.\n      if (range.parentElement() === input) {\n        selection = {\n          start: -range.moveStart(&apos;character&apos;, -input.value.length),\n          end: -range.moveEnd(&apos;character&apos;, -input.value.length)\n        };\n      }\n    } else {\n      // Content editable or old IE textarea.\n      selection = ReactDOMSelection.getOffsets(input);\n    }\n\n    return selection || {start: 0, end: 0};\n  },\n\n  /**\n   * @setSelection: Sets the selection bounds of a textarea or input and focuses\n   * the input.\n   * -@input     Set selection bounds of this input or textarea\n   * -@offsets   Object of same form that is returned from get*\n   */\n  setSelection: function(input, offsets) {\n    var start = offsets.start;\n    var end = offsets.end;\n    if (typeof end === &apos;undefined&apos;) {\n      end = start;\n    }\n\n    if (&apos;selectionStart&apos; in input) {\n      input.selectionStart = start;\n      input.selectionEnd = Math.min(end, input.value.length);\n    } else if (document.selection &amp;&amp; input.nodeName === &apos;INPUT&apos;) {\n      var range = input.createTextRange();\n      range.collapse(true);\n      range.moveStart(&apos;character&apos;, start);\n      range.moveEnd(&apos;character&apos;, end - start);\n      range.select();\n    } else {\n      ReactDOMSelection.setOffsets(input, offsets);\n    }\n  }\n};\n\nmodule.exports = ReactInputSelection;\n\n},{&quot;./ReactDOMSelection&quot;:41,&quot;./containsNode&quot;:88,&quot;./getActiveElement&quot;:99}],53:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInstanceHandles\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactRootIndex = require(&quot;./ReactRootIndex&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar SEPARATOR = &apos;.&apos;;\nvar SEPARATOR_LENGTH = SEPARATOR.length;\n\n/**\n * Maximum depth of traversals before we consider the possibility of a bad ID.\n */\nvar MAX_TREE_DEPTH = 100;\n\n/**\n * Creates a DOM ID prefix to use when mounting React components.\n *\n * @param {number} index A unique integer\n * @return {string} React root ID.\n * @internal\n */\nfunction getReactRootIDString(index) {\n  return SEPARATOR + index.toString(36);\n}\n\n/**\n * Checks if a character in the supplied ID is a separator or the end.\n *\n * @param {string} id A React DOM ID.\n * @param {number} index Index of the character to check.\n * @return {boolean} True if the character is a separator or end of the ID.\n * @private\n */\nfunction isBoundary(id, index) {\n  return id.charAt(index) === SEPARATOR || index === id.length;\n}\n\n/**\n * Checks if the supplied string is a valid React DOM ID.\n *\n * @param {string} id A React DOM ID, maybe.\n * @return {boolean} True if the string is a valid React DOM ID.\n * @private\n */\nfunction isValidID(id) {\n  return id === &apos;&apos; || (\n    id.charAt(0) === SEPARATOR &amp;&amp; id.charAt(id.length - 1) !== SEPARATOR\n  );\n}\n\n/**\n * Checks if the first ID is an ancestor of or equal to the second ID.\n *\n * @param {string} ancestorID\n * @param {string} descendantID\n * @return {boolean} True if `ancestorID` is an ancestor of `descendantID`.\n * @internal\n */\nfunction isAncestorIDOf(ancestorID, descendantID) {\n  return (\n    descendantID.indexOf(ancestorID) === 0 &amp;&amp;\n    isBoundary(descendantID, ancestorID.length)\n  );\n}\n\n/**\n * Gets the parent ID of the supplied React DOM ID, `id`.\n *\n * @param {string} id ID of a component.\n * @return {string} ID of the parent, or an empty string.\n * @private\n */\nfunction getParentID(id) {\n  return id ? id.substr(0, id.lastIndexOf(SEPARATOR)) : &apos;&apos;;\n}\n\n/**\n * Gets the next DOM ID on the tree path from the supplied `ancestorID` to the\n * supplied `destinationID`. If they are equal, the ID is returned.\n *\n * @param {string} ancestorID ID of an ancestor node of `destinationID`.\n * @param {string} destinationID ID of the destination node.\n * @return {string} Next ID on the path from `ancestorID` to `destinationID`.\n * @private\n */\nfunction getNextDescendantID(ancestorID, destinationID) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isValidID(ancestorID) &amp;&amp; isValidID(destinationID),\n    &apos;getNextDescendantID(%s, %s): Received an invalid React DOM ID.&apos;,\n    ancestorID,\n    destinationID\n  ) : invariant(isValidID(ancestorID) &amp;&amp; isValidID(destinationID)));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isAncestorIDOf(ancestorID, destinationID),\n    &apos;getNextDescendantID(...): React has made an invalid assumption about &apos; +\n    &apos;the DOM hierarchy. Expected `%s` to be an ancestor of `%s`.&apos;,\n    ancestorID,\n    destinationID\n  ) : invariant(isAncestorIDOf(ancestorID, destinationID)));\n  if (ancestorID === destinationID) {\n    return ancestorID;\n  }\n  // Skip over the ancestor and the immediate separator. Traverse until we hit\n  // another separator or we reach the end of `destinationID`.\n  var start = ancestorID.length + SEPARATOR_LENGTH;\n  for (var i = start; i &lt; destinationID.length; i++) {\n    if (isBoundary(destinationID, i)) {\n      break;\n    }\n  }\n  return destinationID.substr(0, i);\n}\n\n/**\n * Gets the nearest common ancestor ID of two IDs.\n *\n * Using this ID scheme, the nearest common ancestor ID is the longest common\n * prefix of the two IDs that immediately preceded a &quot;marker&quot; in both strings.\n *\n * @param {string} oneID\n * @param {string} twoID\n * @return {string} Nearest common ancestor ID, or the empty string if none.\n * @private\n */\nfunction getFirstCommonAncestorID(oneID, twoID) {\n  var minLength = Math.min(oneID.length, twoID.length);\n  if (minLength === 0) {\n    return &apos;&apos;;\n  }\n  var lastCommonMarkerIndex = 0;\n  // Use `&lt;=` to traverse until the &quot;EOL&quot; of the shorter string.\n  for (var i = 0; i &lt;= minLength; i++) {\n    if (isBoundary(oneID, i) &amp;&amp; isBoundary(twoID, i)) {\n      lastCommonMarkerIndex = i;\n    } else if (oneID.charAt(i) !== twoID.charAt(i)) {\n      break;\n    }\n  }\n  var longestCommonID = oneID.substr(0, lastCommonMarkerIndex);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isValidID(longestCommonID),\n    &apos;getFirstCommonAncestorID(%s, %s): Expected a valid React DOM ID: %s&apos;,\n    oneID,\n    twoID,\n    longestCommonID\n  ) : invariant(isValidID(longestCommonID)));\n  return longestCommonID;\n}\n\n/**\n * Traverses the parent path between two IDs (either up or down). The IDs must\n * not be the same, and there must exist a parent path between them. If the\n * callback returns `false`, traversal is stopped.\n *\n * @param {?string} start ID at which to start traversal.\n * @param {?string} stop ID at which to end traversal.\n * @param {function} cb Callback to invoke each ID with.\n * @param {?boolean} skipFirst Whether or not to skip the first node.\n * @param {?boolean} skipLast Whether or not to skip the last node.\n * @private\n */\nfunction traverseParentPath(start, stop, cb, arg, skipFirst, skipLast) {\n  start = start || &apos;&apos;;\n  stop = stop || &apos;&apos;;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    start !== stop,\n    &apos;traverseParentPath(...): Cannot traverse from and to the same ID, `%s`.&apos;,\n    start\n  ) : invariant(start !== stop));\n  var traverseUp = isAncestorIDOf(stop, start);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    traverseUp || isAncestorIDOf(start, stop),\n    &apos;traverseParentPath(%s, %s, ...): Cannot traverse from two IDs that do &apos; +\n    &apos;not have a parent path.&apos;,\n    start,\n    stop\n  ) : invariant(traverseUp || isAncestorIDOf(start, stop)));\n  // Traverse from `start` to `stop` one depth at a time.\n  var depth = 0;\n  var traverse = traverseUp ? getParentID : getNextDescendantID;\n  for (var id = start; /* until break */; id = traverse(id, stop)) {\n    var ret;\n    if ((!skipFirst || id !== start) &amp;&amp; (!skipLast || id !== stop)) {\n      ret = cb(id, traverseUp, arg);\n    }\n    if (ret === false || id === stop) {\n      // Only break //after// visiting `stop`.\n      break;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      depth++ &lt; MAX_TREE_DEPTH,\n      &apos;traverseParentPath(%s, %s, ...): Detected an infinite loop while &apos; +\n      &apos;traversing the React DOM ID tree. This may be due to malformed IDs: %s&apos;,\n      start, stop\n    ) : invariant(depth++ &lt; MAX_TREE_DEPTH));\n  }\n}\n\n/**\n * Manages the IDs assigned to DOM representations of React components. This\n * uses a specific scheme in order to traverse the DOM efficiently (e.g. in\n * order to simulate events).\n *\n * @internal\n */\nvar ReactInstanceHandles = {\n\n  /**\n   * Constructs a React root ID\n   * @return {string} A React root ID.\n   */\n  createReactRootID: function() {\n    return getReactRootIDString(ReactRootIndex.createReactRootIndex());\n  },\n\n  /**\n   * Constructs a React ID by joining a root ID with a name.\n   *\n   * @param {string} rootID Root ID of a parent component.\n   * @param {string} name A component&apos;s name (as flattened children).\n   * @return {string} A React ID.\n   * @internal\n   */\n  createReactID: function(rootID, name) {\n    return rootID + name;\n  },\n\n  /**\n   * Gets the DOM ID of the React component that is the root of the tree that\n   * contains the React component with the supplied DOM ID.\n   *\n   * @param {string} id DOM ID of a React component.\n   * @return {?string} DOM ID of the React component that is the root.\n   * @internal\n   */\n  getReactRootIDFromNodeID: function(id) {\n    if (id &amp;&amp; id.charAt(0) === SEPARATOR &amp;&amp; id.length &gt; 1) {\n      var index = id.indexOf(SEPARATOR, 1);\n      return index &gt; -1 ? id.substr(0, index) : id;\n    }\n    return null;\n  },\n\n  /**\n   * Traverses the ID hierarchy and invokes the supplied `cb` on any IDs that\n   * should would receive a `mouseEnter` or `mouseLeave` event.\n   *\n   * NOTE: Does not invoke the callback on the nearest common ancestor because\n   * nothing &quot;entered&quot; or &quot;left&quot; that element.\n   *\n   * @param {string} leaveID ID being left.\n   * @param {string} enterID ID being entered.\n   * @param {function} cb Callback to invoke on each entered/left ID.\n   * @param {*} upArg Argument to invoke the callback with on left IDs.\n   * @param {*} downArg Argument to invoke the callback with on entered IDs.\n   * @internal\n   */\n  traverseEnterLeave: function(leaveID, enterID, cb, upArg, downArg) {\n    var ancestorID = getFirstCommonAncestorID(leaveID, enterID);\n    if (ancestorID !== leaveID) {\n      traverseParentPath(leaveID, ancestorID, cb, upArg, false, true);\n    }\n    if (ancestorID !== enterID) {\n      traverseParentPath(ancestorID, enterID, cb, downArg, true, false);\n    }\n  },\n\n  /**\n   * Simulates the traversal of a two-phase, capture/bubble event dispatch.\n   *\n   * NOTE: This traversal happens on IDs without touching the DOM.\n   *\n   * @param {string} targetID ID of the target node.\n   * @param {function} cb Callback to invoke.\n   * @param {*} arg Argument to invoke the callback with.\n   * @internal\n   */\n  traverseTwoPhase: function(targetID, cb, arg) {\n    if (targetID) {\n      traverseParentPath(&apos;&apos;, targetID, cb, arg, true, false);\n      traverseParentPath(targetID, &apos;&apos;, cb, arg, false, true);\n    }\n  },\n\n  /**\n   * Traverse a node ID, calling the supplied `cb` for each ancestor ID. For\n   * example, passing `.0.$row-0.1` would result in `cb` getting called\n   * with `.0`, `.0.$row-0`, and `.0.$row-0.1`.\n   *\n   * NOTE: This traversal happens on IDs without touching the DOM.\n   *\n   * @param {string} targetID ID of the target node.\n   * @param {function} cb Callback to invoke.\n   * @param {*} arg Argument to invoke the callback with.\n   * @internal\n   */\n  traverseAncestors: function(targetID, cb, arg) {\n    traverseParentPath(&apos;&apos;, targetID, cb, arg, true, false);\n  },\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _getFirstCommonAncestorID: getFirstCommonAncestorID,\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _getNextDescendantID: getNextDescendantID,\n\n  isAncestorIDOf: isAncestorIDOf,\n\n  SEPARATOR: SEPARATOR\n\n};\n\nmodule.exports = ReactInstanceHandles;\n\n},{&quot;./ReactRootIndex&quot;:67,&quot;./invariant&quot;:108}],54:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMarkupChecksum\n */\n\n&quot;use strict&quot;;\n\nvar adler32 = require(&quot;./adler32&quot;);\n\nvar ReactMarkupChecksum = {\n  CHECKSUM_ATTR_NAME: &apos;data-react-checksum&apos;,\n\n  /**\n   * @param {string} markup Markup string\n   * @return {string} Markup string with checksum attribute attached\n   */\n  addChecksumToMarkup: function(markup) {\n    var checksum = adler32(markup);\n    return markup.replace(\n      &apos;&gt;&apos;,\n      &apos; &apos; + ReactMarkupChecksum.CHECKSUM_ATTR_NAME + &apos;=&quot;&apos; + checksum + &apos;&quot;&gt;&apos;\n    );\n  },\n\n  /**\n   * @param {string} markup to use\n   * @param {DOMElement} element root React element\n   * @returns {boolean} whether or not the markup is the same\n   */\n  canReuseMarkup: function(markup, element) {\n    var existingChecksum = element.getAttribute(\n      ReactMarkupChecksum.CHECKSUM_ATTR_NAME\n    );\n    existingChecksum = existingChecksum &amp;&amp; parseInt(existingChecksum, 10);\n    var markupChecksum = adler32(markup);\n    return markupChecksum === existingChecksum;\n  }\n};\n\nmodule.exports = ReactMarkupChecksum;\n\n},{&quot;./adler32&quot;:87}],55:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMount\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar containsNode = require(&quot;./containsNode&quot;);\nvar getReactRootElementInContainer = require(&quot;./getReactRootElementInContainer&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\nvar SEPARATOR = ReactInstanceHandles.SEPARATOR;\n\nvar ATTR_NAME = DOMProperty.ID_ATTRIBUTE_NAME;\nvar nodeCache = {};\n\nvar ELEMENT_NODE_TYPE = 1;\nvar DOC_NODE_TYPE = 9;\n\n/** Mapping from reactRootID to React component instance. */\nvar instancesByReactRootID = {};\n\n/** Mapping from reactRootID to `container` nodes. */\nvar containersByReactRootID = {};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  /** __DEV__-only mapping from reactRootID to root elements. */\n  var rootElementsByReactRootID = {};\n}\n\n// Used to store breadth-first search state in findComponentRoot.\nvar findComponentRootReusableArray = [];\n\n/**\n * @param {DOMElement} container DOM element that may contain a React component.\n * @return {?string} A &quot;reactRoot&quot; ID, if a React component is rendered.\n */\nfunction getReactRootID(container) {\n  var rootElement = getReactRootElementInContainer(container);\n  return rootElement &amp;&amp; ReactMount.getID(rootElement);\n}\n\n/**\n * Accessing node[ATTR_NAME] or calling getAttribute(ATTR_NAME) on a form\n * element can return its control whose name or ID equals ATTR_NAME. All\n * DOM nodes support `getAttributeNode` but this can also get called on\n * other objects so just return &apos;&apos; if we&apos;re given something other than a\n * DOM node (such as window).\n *\n * @param {?DOMElement|DOMWindow|DOMDocument|DOMTextNode} node DOM node.\n * @return {string} ID of the supplied `domNode`.\n */\nfunction getID(node) {\n  var id = internalGetID(node);\n  if (id) {\n    if (nodeCache.hasOwnProperty(id)) {\n      var cached = nodeCache[id];\n      if (cached !== node) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          !isValid(cached, id),\n          &apos;ReactMount: Two valid but unequal nodes with the same `%s`: %s&apos;,\n          ATTR_NAME, id\n        ) : invariant(!isValid(cached, id)));\n\n        nodeCache[id] = node;\n      }\n    } else {\n      nodeCache[id] = node;\n    }\n  }\n\n  return id;\n}\n\nfunction internalGetID(node) {\n  // If node is something like a window, document, or text node, none of\n  // which support attributes or a .getAttribute method, gracefully return\n  // the empty string, as if the attribute were missing.\n  return node &amp;&amp; node.getAttribute &amp;&amp; node.getAttribute(ATTR_NAME) || &apos;&apos;;\n}\n\n/**\n * Sets the React-specific ID of the given node.\n *\n * @param {DOMElement} node The DOM node whose ID will be set.\n * @param {string} id The value of the ID attribute.\n */\nfunction setID(node, id) {\n  var oldID = internalGetID(node);\n  if (oldID !== id) {\n    delete nodeCache[oldID];\n  }\n  node.setAttribute(ATTR_NAME, id);\n  nodeCache[id] = node;\n}\n\n/**\n * Finds the node with the supplied React-generated DOM ID.\n *\n * @param {string} id A React-generated DOM ID.\n * @return {DOMElement} DOM node with the suppled `id`.\n * @internal\n */\nfunction getNode(id) {\n  if (!nodeCache.hasOwnProperty(id) || !isValid(nodeCache[id], id)) {\n    nodeCache[id] = ReactMount.findReactNodeByID(id);\n  }\n  return nodeCache[id];\n}\n\n/**\n * A node is &quot;valid&quot; if it is contained by a currently mounted container.\n *\n * This means that the node does not have to be contained by a document in\n * order to be considered valid.\n *\n * @param {?DOMElement} node The candidate DOM node.\n * @param {string} id The expected ID of the node.\n * @return {boolean} Whether the node is contained by a mounted container.\n */\nfunction isValid(node, id) {\n  if (node) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      internalGetID(node) === id,\n      &apos;ReactMount: Unexpected modification of `%s`&apos;,\n      ATTR_NAME\n    ) : invariant(internalGetID(node) === id));\n\n    var container = ReactMount.findReactContainerForID(id);\n    if (container &amp;&amp; containsNode(container, node)) {\n      return true;\n    }\n  }\n\n  return false;\n}\n\n/**\n * Causes the cache to forget about one React-specific ID.\n *\n * @param {string} id The ID to forget.\n */\nfunction purgeID(id) {\n  delete nodeCache[id];\n}\n\nvar deepestNodeSoFar = null;\nfunction findDeepestCachedAncestorImpl(ancestorID) {\n  var ancestor = nodeCache[ancestorID];\n  if (ancestor &amp;&amp; isValid(ancestor, ancestorID)) {\n    deepestNodeSoFar = ancestor;\n  } else {\n    // This node isn&apos;t populated in the cache, so presumably none of its\n    // descendants are. Break out of the loop.\n    return false;\n  }\n}\n\n/**\n * Return the deepest cached node whose ID is a prefix of `targetID`.\n */\nfunction findDeepestCachedAncestor(targetID) {\n  deepestNodeSoFar = null;\n  ReactInstanceHandles.traverseAncestors(\n    targetID,\n    findDeepestCachedAncestorImpl\n  );\n\n  var foundNode = deepestNodeSoFar;\n  deepestNodeSoFar = null;\n  return foundNode;\n}\n\n/**\n * Mounting is the process of initializing a React component by creatings its\n * representative DOM elements and inserting them into a supplied `container`.\n * Any prior content inside `container` is destroyed in the process.\n *\n *   ReactMount.renderComponent(\n *     component,\n *     document.getElementById(&apos;container&apos;)\n *   );\n *\n *   &lt;div id=&quot;container&quot;&gt;                   &lt;-- Supplied `container`.\n *     &lt;div data-reactid=&quot;.3&quot;&gt;              &lt;-- Rendered reactRoot of React\n *       // ...                                 component.\n *     &lt;/div&gt;\n *   &lt;/div&gt;\n *\n * Inside of `container`, the first element rendered is the &quot;reactRoot&quot;.\n */\nvar ReactMount = {\n  /** Time spent generating markup. */\n  totalInstantiationTime: 0,\n\n  /** Time spent inserting markup into the DOM. */\n  totalInjectionTime: 0,\n\n  /** Whether support for touch events should be initialized. */\n  useTouchEvents: false,\n\n  /** Exposed for debugging purposes **/\n  _instancesByReactRootID: instancesByReactRootID,\n\n  /**\n   * This is a hook provided to support rendering React components while\n   * ensuring that the apparent scroll position of its `container` does not\n   * change.\n   *\n   * @param {DOMElement} container The `container` being rendered into.\n   * @param {function} renderCallback This must be called once to do the render.\n   */\n  scrollMonitor: function(container, renderCallback) {\n    renderCallback();\n  },\n\n  /**\n   * Take a component that&apos;s already mounted into the DOM and replace its props\n   * @param {ReactComponent} prevComponent component instance already in the DOM\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @param {?function} callback function triggered on completion\n   */\n  _updateRootComponent: function(\n      prevComponent,\n      nextComponent,\n      container,\n      callback) {\n    var nextProps = nextComponent.props;\n    ReactMount.scrollMonitor(container, function() {\n      prevComponent.replaceProps(nextProps, callback);\n    });\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      // Record the root element in case it later gets transplanted.\n      rootElementsByReactRootID[getReactRootID(container)] =\n        getReactRootElementInContainer(container);\n    }\n\n    return prevComponent;\n  },\n\n  /**\n   * Register a component into the instance map and starts scroll value\n   * monitoring\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @return {string} reactRoot ID prefix\n   */\n  _registerComponent: function(nextComponent, container) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      container &amp;&amp; (\n        container.nodeType === ELEMENT_NODE_TYPE ||\n        container.nodeType === DOC_NODE_TYPE\n      ),\n      &apos;_registerComponent(...): Target container is not a DOM element.&apos;\n    ) : invariant(container &amp;&amp; (\n      container.nodeType === ELEMENT_NODE_TYPE ||\n      container.nodeType === DOC_NODE_TYPE\n    )));\n\n    ReactEventEmitter.ensureScrollValueMonitoring();\n\n    var reactRootID = ReactMount.registerContainer(container);\n    instancesByReactRootID[reactRootID] = nextComponent;\n    return reactRootID;\n  },\n\n  /**\n   * Render a new component into the DOM.\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @param {boolean} shouldReuseMarkup if we should skip the markup insertion\n   * @return {ReactComponent} nextComponent\n   */\n  _renderNewRootComponent: ReactPerf.measure(\n    &apos;ReactMount&apos;,\n    &apos;_renderNewRootComponent&apos;,\n    function(\n        nextComponent,\n        container,\n        shouldReuseMarkup) {\n      var reactRootID = ReactMount._registerComponent(nextComponent, container);\n      nextComponent.mountComponentIntoNode(\n        reactRootID,\n        container,\n        shouldReuseMarkup\n      );\n\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        // Record the root element in case it later gets transplanted.\n        rootElementsByReactRootID[reactRootID] =\n          getReactRootElementInContainer(container);\n      }\n\n      return nextComponent;\n    }\n  ),\n\n  /**\n   * Renders a React component into the DOM in the supplied `container`.\n   *\n   * If the React component was previously rendered into `container`, this will\n   * perform an update on it and only mutate the DOM as necessary to reflect the\n   * latest React component.\n   *\n   * @param {ReactComponent} nextComponent Component instance to render.\n   * @param {DOMElement} container DOM element to render into.\n   * @param {?function} callback function triggered on completion\n   * @return {ReactComponent} Component instance rendered in `container`.\n   */\n  renderComponent: function(nextComponent, container, callback) {\n    var prevComponent = instancesByReactRootID[getReactRootID(container)];\n\n    if (prevComponent) {\n      if (shouldUpdateReactComponent(prevComponent, nextComponent)) {\n        return ReactMount._updateRootComponent(\n          prevComponent,\n          nextComponent,\n          container,\n          callback\n        );\n      } else {\n        ReactMount.unmountComponentAtNode(container);\n      }\n    }\n\n    var reactRootElement = getReactRootElementInContainer(container);\n    var containerHasReactMarkup =\n      reactRootElement &amp;&amp; ReactMount.isRenderedByReact(reactRootElement);\n\n    var shouldReuseMarkup = containerHasReactMarkup &amp;&amp; !prevComponent;\n\n    var component = ReactMount._renderNewRootComponent(\n      nextComponent,\n      container,\n      shouldReuseMarkup\n    );\n    callback &amp;&amp; callback.call(component);\n    return component;\n  },\n\n  /**\n   * Constructs a component instance of `constructor` with `initialProps` and\n   * renders it into the supplied `container`.\n   *\n   * @param {function} constructor React component constructor.\n   * @param {?object} props Initial props of the component instance.\n   * @param {DOMElement} container DOM element to render into.\n   * @return {ReactComponent} Component instance rendered in `container`.\n   */\n  constructAndRenderComponent: function(constructor, props, container) {\n    return ReactMount.renderComponent(constructor(props), container);\n  },\n\n  /**\n   * Constructs a component instance of `constructor` with `initialProps` and\n   * renders it into a container node identified by supplied `id`.\n   *\n   * @param {function} componentConstructor React component constructor\n   * @param {?object} props Initial props of the component instance.\n   * @param {string} id ID of the DOM element to render into.\n   * @return {ReactComponent} Component instance rendered in the container node.\n   */\n  constructAndRenderComponentByID: function(constructor, props, id) {\n    var domNode = document.getElementById(id);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      domNode,\n      &apos;Tried to get element with id of &quot;%s&quot; but it is not present on the page.&apos;,\n      id\n    ) : invariant(domNode));\n    return ReactMount.constructAndRenderComponent(constructor, props, domNode);\n  },\n\n  /**\n   * Registers a container node into which React components will be rendered.\n   * This also creates the &quot;reactRoot&quot; ID that will be assigned to the element\n   * rendered within.\n   *\n   * @param {DOMElement} container DOM element to register as a container.\n   * @return {string} The &quot;reactRoot&quot; ID of elements rendered within.\n   */\n  registerContainer: function(container) {\n    var reactRootID = getReactRootID(container);\n    if (reactRootID) {\n      // If one exists, make sure it is a valid &quot;reactRoot&quot; ID.\n      reactRootID = ReactInstanceHandles.getReactRootIDFromNodeID(reactRootID);\n    }\n    if (!reactRootID) {\n      // No valid &quot;reactRoot&quot; ID found, create one.\n      reactRootID = ReactInstanceHandles.createReactRootID();\n    }\n    containersByReactRootID[reactRootID] = container;\n    return reactRootID;\n  },\n\n  /**\n   * Unmounts and destroys the React component rendered in the `container`.\n   *\n   * @param {DOMElement} container DOM element containing a React component.\n   * @return {boolean} True if a component was found in and unmounted from\n   *                   `container`\n   */\n  unmountComponentAtNode: function(container) {\n    var reactRootID = getReactRootID(container);\n    var component = instancesByReactRootID[reactRootID];\n    if (!component) {\n      return false;\n    }\n    ReactMount.unmountComponentFromNode(component, container);\n    delete instancesByReactRootID[reactRootID];\n    delete containersByReactRootID[reactRootID];\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      delete rootElementsByReactRootID[reactRootID];\n    }\n    return true;\n  },\n\n  /**\n   * Unmounts a component and removes it from the DOM.\n   *\n   * @param {ReactComponent} instance React component instance.\n   * @param {DOMElement} container DOM element to unmount from.\n   * @final\n   * @internal\n   * @see {ReactMount.unmountComponentAtNode}\n   */\n  unmountComponentFromNode: function(instance, container) {\n    instance.unmountComponent();\n\n    if (container.nodeType === DOC_NODE_TYPE) {\n      container = container.documentElement;\n    }\n\n    // http://jsperf.com/emptying-a-node\n    while (container.lastChild) {\n      container.removeChild(container.lastChild);\n    }\n  },\n\n  /**\n   * Finds the container DOM element that contains React component to which the\n   * supplied DOM `id` belongs.\n   *\n   * @param {string} id The ID of an element rendered by a React component.\n   * @return {?DOMElement} DOM element that contains the `id`.\n   */\n  findReactContainerForID: function(id) {\n    var reactRootID = ReactInstanceHandles.getReactRootIDFromNodeID(id);\n    var container = containersByReactRootID[reactRootID];\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var rootElement = rootElementsByReactRootID[reactRootID];\n      if (rootElement &amp;&amp; rootElement.parentNode !== container) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          // Call internalGetID here because getID calls isValid which calls\n          // findReactContainerForID (this function).\n          internalGetID(rootElement) === reactRootID,\n          &apos;ReactMount: Root element ID differed from reactRootID.&apos;\n        ) : invariant(// Call internalGetID here because getID calls isValid which calls\n        // findReactContainerForID (this function).\n        internalGetID(rootElement) === reactRootID));\n\n        var containerChild = container.firstChild;\n        if (containerChild &amp;&amp;\n            reactRootID === internalGetID(containerChild)) {\n          // If the container has a new child with the same ID as the old\n          // root element, then rootElementsByReactRootID[reactRootID] is\n          // just stale and needs to be updated. The case that deserves a\n          // warning is when the container is empty.\n          rootElementsByReactRootID[reactRootID] = containerChild;\n        } else {\n          console.warn(\n            &apos;ReactMount: Root element has been removed from its original &apos; +\n            &apos;container. New container:&apos;, rootElement.parentNode\n          );\n        }\n      }\n    }\n\n    return container;\n  },\n\n  /**\n   * Finds an element rendered by React with the supplied ID.\n   *\n   * @param {string} id ID of a DOM node in the React component.\n   * @return {DOMElement} Root DOM node of the React component.\n   */\n  findReactNodeByID: function(id) {\n    var reactRoot = ReactMount.findReactContainerForID(id);\n    return ReactMount.findComponentRoot(reactRoot, id);\n  },\n\n  /**\n   * True if the supplied `node` is rendered by React.\n   *\n   * @param {*} node DOM Element to check.\n   * @return {boolean} True if the DOM Element appears to be rendered by React.\n   * @internal\n   */\n  isRenderedByReact: function(node) {\n    if (node.nodeType !== 1) {\n      // Not a DOMElement, therefore not a React component\n      return false;\n    }\n    var id = ReactMount.getID(node);\n    return id ? id.charAt(0) === SEPARATOR : false;\n  },\n\n  /**\n   * Traverses up the ancestors of the supplied node to find a node that is a\n   * DOM representation of a React component.\n   *\n   * @param {*} node\n   * @return {?DOMEventTarget}\n   * @internal\n   */\n  getFirstReactDOM: function(node) {\n    var current = node;\n    while (current &amp;&amp; current.parentNode !== current) {\n      if (ReactMount.isRenderedByReact(current)) {\n        return current;\n      }\n      current = current.parentNode;\n    }\n    return null;\n  },\n\n  /**\n   * Finds a node with the supplied `targetID` inside of the supplied\n   * `ancestorNode`.  Exploits the ID naming scheme to perform the search\n   * quickly.\n   *\n   * @param {DOMEventTarget} ancestorNode Search from this root.\n   * @pararm {string} targetID ID of the DOM representation of the component.\n   * @return {DOMEventTarget} DOM node with the supplied `targetID`.\n   * @internal\n   */\n  findComponentRoot: function(ancestorNode, targetID) {\n    var firstChildren = findComponentRootReusableArray;\n    var childIndex = 0;\n\n    var deepestAncestor = findDeepestCachedAncestor(targetID) || ancestorNode;\n\n    firstChildren[0] = deepestAncestor.firstChild;\n    firstChildren.length = 1;\n\n    while (childIndex &lt; firstChildren.length) {\n      var child = firstChildren[childIndex++];\n      var targetChild;\n\n      while (child) {\n        var childID = ReactMount.getID(child);\n        if (childID) {\n          // Even if we find the node we&apos;re looking for, we finish looping\n          // through its siblings to ensure they&apos;re cached so that we don&apos;t have\n          // to revisit this node again. Otherwise, we make n^2 calls to getID\n          // when visiting the many children of a single node in order.\n\n          if (targetID === childID) {\n            targetChild = child;\n          } else if (ReactInstanceHandles.isAncestorIDOf(childID, targetID)) {\n            // If we find a child whose ID is an ancestor of the given ID,\n            // then we can be sure that we only want to search the subtree\n            // rooted at this child, so we can throw out the rest of the\n            // search state.\n            firstChildren.length = childIndex = 0;\n            firstChildren.push(child.firstChild);\n          }\n\n        } else {\n          // If this child had no ID, then there&apos;s a chance that it was\n          // injected automatically by the browser, as when a `&lt;table&gt;`\n          // element sprouts an extra `&lt;tbody&gt;` child as a side effect of\n          // `.innerHTML` parsing. Optimistically continue down this\n          // branch, but not before examining the other siblings.\n          firstChildren.push(child.firstChild);\n        }\n\n        child = child.nextSibling;\n      }\n\n      if (targetChild) {\n        // Emptying firstChildren/findComponentRootReusableArray is\n        // not necessary for correctness, but it helps the GC reclaim\n        // any nodes that were left at the end of the search.\n        firstChildren.length = 0;\n\n        return targetChild;\n      }\n    }\n\n    firstChildren.length = 0;\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      false,\n      &apos;findComponentRoot(..., %s): Unable to find element. This probably &apos; +\n      &apos;means the DOM was unexpectedly mutated (e.g., by the browser). &apos; +\n      &apos;Try inspecting the child nodes of the element with React ID `%s`.&apos;,\n      targetID,\n      ReactMount.getID(ancestorNode)\n    ) : invariant(false));\n  },\n\n\n  /**\n   * React ID utilities.\n   */\n\n  getReactRootID: getReactRootID,\n\n  getID: getID,\n\n  setID: setID,\n\n  getNode: getNode,\n\n  purgeID: purgeID\n};\n\nmodule.exports = ReactMount;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactPerf&quot;:60,&quot;./containsNode&quot;:88,&quot;./getReactRootElementInContainer&quot;:104,&quot;./invariant&quot;:108,&quot;./shouldUpdateReactComponent&quot;:126}],56:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMountReady\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * A specialized pseudo-event module to help keep track of components waiting to\n * be notified when their DOM representations are available for use.\n *\n * This implements `PooledClass`, so you should never need to instantiate this.\n * Instead, use `ReactMountReady.getPooled()`.\n *\n * @param {?array&lt;function&gt;} initialCollection\n * @class ReactMountReady\n * @implements PooledClass\n * @internal\n */\nfunction ReactMountReady(initialCollection) {\n  this._queue = initialCollection || null;\n}\n\nmixInto(ReactMountReady, {\n\n  /**\n   * Enqueues a callback to be invoked when `notifyAll` is invoked. This is used\n   * to enqueue calls to `componentDidMount` and `componentDidUpdate`.\n   *\n   * @param {ReactComponent} component Component being rendered.\n   * @param {function(DOMElement)} callback Invoked when `notifyAll` is invoked.\n   * @internal\n   */\n  enqueue: function(component, callback) {\n    this._queue = this._queue || [];\n    this._queue.push({component: component, callback: callback});\n  },\n\n  /**\n   * Invokes all enqueued callbacks and clears the queue. This is invoked after\n   * the DOM representation of a component has been created or updated.\n   *\n   * @internal\n   */\n  notifyAll: function() {\n    var queue = this._queue;\n    if (queue) {\n      this._queue = null;\n      for (var i = 0, l = queue.length; i &lt; l; i++) {\n        var component = queue[i].component;\n        var callback = queue[i].callback;\n        callback.call(component);\n      }\n      queue.length = 0;\n    }\n  },\n\n  /**\n   * Resets the internal queue.\n   *\n   * @internal\n   */\n  reset: function() {\n    this._queue = null;\n  },\n\n  /**\n   * `PooledClass` looks for this.\n   */\n  destructor: function() {\n    this.reset();\n  }\n\n});\n\nPooledClass.addPoolingTo(ReactMountReady);\n\nmodule.exports = ReactMountReady;\n\n},{&quot;./PooledClass&quot;:23,&quot;./mixInto&quot;:120}],57:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMultiChild\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactMultiChildUpdateTypes = require(&quot;./ReactMultiChildUpdateTypes&quot;);\n\nvar flattenChildren = require(&quot;./flattenChildren&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\n/**\n * Updating children of a component may trigger recursive updates. The depth is\n * used to batch recursive updates to render markup more efficiently.\n *\n * @type {number}\n * @private\n */\nvar updateDepth = 0;\n\n/**\n * Queue of update configuration objects.\n *\n * Each object has a `type` property that is in `ReactMultiChildUpdateTypes`.\n *\n * @type {array&lt;object&gt;}\n * @private\n */\nvar updateQueue = [];\n\n/**\n * Queue of markup to be rendered.\n *\n * @type {array&lt;string&gt;}\n * @private\n */\nvar markupQueue = [];\n\n/**\n * Enqueues markup to be rendered and inserted at a supplied index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {string} markup Markup that renders into an element.\n * @param {number} toIndex Destination index.\n * @private\n */\nfunction enqueueMarkup(parentID, markup, toIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.INSERT_MARKUP,\n    markupIndex: markupQueue.push(markup) - 1,\n    textContent: null,\n    fromIndex: null,\n    toIndex: toIndex\n  });\n}\n\n/**\n * Enqueues moving an existing element to another index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {number} fromIndex Source index of the existing element.\n * @param {number} toIndex Destination index of the element.\n * @private\n */\nfunction enqueueMove(parentID, fromIndex, toIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.MOVE_EXISTING,\n    markupIndex: null,\n    textContent: null,\n    fromIndex: fromIndex,\n    toIndex: toIndex\n  });\n}\n\n/**\n * Enqueues removing an element at an index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {number} fromIndex Index of the element to remove.\n * @private\n */\nfunction enqueueRemove(parentID, fromIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.REMOVE_NODE,\n    markupIndex: null,\n    textContent: null,\n    fromIndex: fromIndex,\n    toIndex: null\n  });\n}\n\n/**\n * Enqueues setting the text content.\n *\n * @param {string} parentID ID of the parent component.\n * @param {string} textContent Text content to set.\n * @private\n */\nfunction enqueueTextContent(parentID, textContent) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.TEXT_CONTENT,\n    markupIndex: null,\n    textContent: textContent,\n    fromIndex: null,\n    toIndex: null\n  });\n}\n\n/**\n * Processes any enqueued updates.\n *\n * @private\n */\nfunction processQueue() {\n  if (updateQueue.length) {\n    ReactComponent.BackendIDOperations.dangerouslyProcessChildrenUpdates(\n      updateQueue,\n      markupQueue\n    );\n    clearQueue();\n  }\n}\n\n/**\n * Clears any enqueued updates.\n *\n * @private\n */\nfunction clearQueue() {\n  updateQueue.length = 0;\n  markupQueue.length = 0;\n}\n\n/**\n * ReactMultiChild are capable of reconciling multiple children.\n *\n * @class ReactMultiChild\n * @internal\n */\nvar ReactMultiChild = {\n\n  /**\n   * Provides common functionality for components that must reconcile multiple\n   * children. This is used by `ReactDOMComponent` to mount, update, and\n   * unmount child components.\n   *\n   * @lends {ReactMultiChild.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Generates a &quot;mount image&quot; for each of the supplied children. In the case\n     * of `ReactDOMComponent`, a mount image is a string of markup.\n     *\n     * @param {?object} nestedChildren Nested child maps.\n     * @return {array} An array of mounted representations.\n     * @internal\n     */\n    mountChildren: function(nestedChildren, transaction) {\n      var children = flattenChildren(nestedChildren);\n      var mountImages = [];\n      var index = 0;\n      this._renderedChildren = children;\n      for (var name in children) {\n        var child = children[name];\n        if (children.hasOwnProperty(name)) {\n          // Inlined for performance, see `ReactInstanceHandles.createReactID`.\n          var rootID = this._rootNodeID + name;\n          var mountImage = child.mountComponent(\n            rootID,\n            transaction,\n            this._mountDepth + 1\n          );\n          child._mountIndex = index;\n          mountImages.push(mountImage);\n          index++;\n        }\n      }\n      return mountImages;\n    },\n\n    /**\n     * Replaces any rendered children with a text content string.\n     *\n     * @param {string} nextContent String of content.\n     * @internal\n     */\n    updateTextContent: function(nextContent) {\n      updateDepth++;\n      var errorThrown = true;\n      try {\n        var prevChildren = this._renderedChildren;\n        // Remove any rendered children.\n        for (var name in prevChildren) {\n          if (prevChildren.hasOwnProperty(name)) {\n            this._unmountChildByName(prevChildren[name], name);\n          }\n        }\n        // Set new text content.\n        this.setTextContent(nextContent);\n        errorThrown = false;\n      } finally {\n        updateDepth--;\n        if (!updateDepth) {\n          errorThrown ? clearQueue() : processQueue();\n        }\n      }\n    },\n\n    /**\n     * Updates the rendered children with new children.\n     *\n     * @param {?object} nextNestedChildren Nested child maps.\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    updateChildren: function(nextNestedChildren, transaction) {\n      updateDepth++;\n      var errorThrown = true;\n      try {\n        this._updateChildren(nextNestedChildren, transaction);\n        errorThrown = false;\n      } finally {\n        updateDepth--;\n        if (!updateDepth) {\n          errorThrown ? clearQueue() : processQueue();\n        }\n      }\n    },\n\n    /**\n     * Improve performance by isolating this hot code path from the try/catch\n     * block in `updateChildren`.\n     *\n     * @param {?object} nextNestedChildren Nested child maps.\n     * @param {ReactReconcileTransaction} transaction\n     * @final\n     * @protected\n     */\n    _updateChildren: function(nextNestedChildren, transaction) {\n      var nextChildren = flattenChildren(nextNestedChildren);\n      var prevChildren = this._renderedChildren;\n      if (!nextChildren &amp;&amp; !prevChildren) {\n        return;\n      }\n      var name;\n      // `nextIndex` will increment for each child in `nextChildren`, but\n      // `lastIndex` will be the last index visited in `prevChildren`.\n      var lastIndex = 0;\n      var nextIndex = 0;\n      for (name in nextChildren) {\n        if (!nextChildren.hasOwnProperty(name)) {\n          continue;\n        }\n        var prevChild = prevChildren &amp;&amp; prevChildren[name];\n        var nextChild = nextChildren[name];\n        if (shouldUpdateReactComponent(prevChild, nextChild)) {\n          this.moveChild(prevChild, nextIndex, lastIndex);\n          lastIndex = Math.max(prevChild._mountIndex, lastIndex);\n          prevChild.receiveComponent(nextChild, transaction);\n          prevChild._mountIndex = nextIndex;\n        } else {\n          if (prevChild) {\n            // Update `lastIndex` before `_mountIndex` gets unset by unmounting.\n            lastIndex = Math.max(prevChild._mountIndex, lastIndex);\n            this._unmountChildByName(prevChild, name);\n          }\n          this._mountChildByNameAtIndex(\n            nextChild, name, nextIndex, transaction\n          );\n        }\n        nextIndex++;\n      }\n      // Remove children that are no longer present.\n      for (name in prevChildren) {\n        if (prevChildren.hasOwnProperty(name) &amp;&amp;\n            !(nextChildren &amp;&amp; nextChildren[name])) {\n          this._unmountChildByName(prevChildren[name], name);\n        }\n      }\n    },\n\n    /**\n     * Unmounts all rendered children. This should be used to clean up children\n     * when this component is unmounted.\n     *\n     * @internal\n     */\n    unmountChildren: function() {\n      var renderedChildren = this._renderedChildren;\n      for (var name in renderedChildren) {\n        var renderedChild = renderedChildren[name];\n        // TODO: When is this not true?\n        if (renderedChild.unmountComponent) {\n          renderedChild.unmountComponent();\n        }\n      }\n      this._renderedChildren = null;\n    },\n\n    /**\n     * Moves a child component to the supplied index.\n     *\n     * @param {ReactComponent} child Component to move.\n     * @param {number} toIndex Destination index of the element.\n     * @param {number} lastIndex Last index visited of the siblings of `child`.\n     * @protected\n     */\n    moveChild: function(child, toIndex, lastIndex) {\n      // If the index of `child` is less than `lastIndex`, then it needs to\n      // be moved. Otherwise, we do not need to move it because a child will be\n      // inserted or moved before `child`.\n      if (child._mountIndex &lt; lastIndex) {\n        enqueueMove(this._rootNodeID, child._mountIndex, toIndex);\n      }\n    },\n\n    /**\n     * Creates a child component.\n     *\n     * @param {ReactComponent} child Component to create.\n     * @param {string} mountImage Markup to insert.\n     * @protected\n     */\n    createChild: function(child, mountImage) {\n      enqueueMarkup(this._rootNodeID, mountImage, child._mountIndex);\n    },\n\n    /**\n     * Removes a child component.\n     *\n     * @param {ReactComponent} child Child to remove.\n     * @protected\n     */\n    removeChild: function(child) {\n      enqueueRemove(this._rootNodeID, child._mountIndex);\n    },\n\n    /**\n     * Sets this text content string.\n     *\n     * @param {string} textContent Text content to set.\n     * @protected\n     */\n    setTextContent: function(textContent) {\n      enqueueTextContent(this._rootNodeID, textContent);\n    },\n\n    /**\n     * Mounts a child with the supplied name.\n     *\n     * NOTE: This is part of `updateChildren` and is here for readability.\n     *\n     * @param {ReactComponent} child Component to mount.\n     * @param {string} name Name of the child.\n     * @param {number} index Index at which to insert the child.\n     * @param {ReactReconcileTransaction} transaction\n     * @private\n     */\n    _mountChildByNameAtIndex: function(child, name, index, transaction) {\n      // Inlined for performance, see `ReactInstanceHandles.createReactID`.\n      var rootID = this._rootNodeID + name;\n      var mountImage = child.mountComponent(\n        rootID,\n        transaction,\n        this._mountDepth + 1\n      );\n      child._mountIndex = index;\n      this.createChild(child, mountImage);\n      this._renderedChildren = this._renderedChildren || {};\n      this._renderedChildren[name] = child;\n    },\n\n    /**\n     * Unmounts a rendered child by name.\n     *\n     * NOTE: This is part of `updateChildren` and is here for readability.\n     *\n     * @param {ReactComponent} child Component to unmount.\n     * @param {string} name Name of the child in `this._renderedChildren`.\n     * @private\n     */\n    _unmountChildByName: function(child, name) {\n      // TODO: When is this not true?\n      if (ReactComponent.isValidComponent(child)) {\n        this.removeChild(child);\n        child._mountIndex = null;\n        child.unmountComponent();\n        delete this._renderedChildren[name];\n      }\n    }\n\n  }\n\n};\n\nmodule.exports = ReactMultiChild;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactMultiChildUpdateTypes&quot;:58,&quot;./flattenChildren&quot;:97,&quot;./shouldUpdateReactComponent&quot;:126}],58:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMultiChildUpdateTypes\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n/**\n * When a component&apos;s children are updated, a series of update configuration\n * objects are created in order to batch and serialize the required changes.\n *\n * Enumerates all the possible types of update configurations.\n *\n * @internal\n */\nvar ReactMultiChildUpdateTypes = keyMirror({\n  INSERT_MARKUP: null,\n  MOVE_EXISTING: null,\n  REMOVE_NODE: null,\n  TEXT_CONTENT: null\n});\n\nmodule.exports = ReactMultiChildUpdateTypes;\n\n},{&quot;./keyMirror&quot;:114}],59:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactOwner\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * ReactOwners are capable of storing references to owned components.\n *\n * All components are capable of //being// referenced by owner components, but\n * only ReactOwner components are capable of //referencing// owned components.\n * The named reference is known as a &quot;ref&quot;.\n *\n * Refs are available when mounted and updated during reconciliation.\n *\n *   var MyComponent = React.createClass({\n *     render: function() {\n *       return (\n *         &lt;div onClick={this.handleClick}&gt;\n *           &lt;CustomComponent ref=&quot;custom&quot; /&gt;\n *         &lt;/div&gt;\n *       );\n *     },\n *     handleClick: function() {\n *       this.refs.custom.handleClick();\n *     },\n *     componentDidMount: function() {\n *       this.refs.custom.initialize();\n *     }\n *   });\n *\n * Refs should rarely be used. When refs are used, they should only be done to\n * control data that is not handled by React&apos;s data flow.\n *\n * @class ReactOwner\n */\nvar ReactOwner = {\n\n  /**\n   * @param {?object} object\n   * @return {boolean} True if `object` is a valid owner.\n   * @final\n   */\n  isValidOwner: function(object) {\n    return !!(\n      object &amp;&amp;\n      typeof object.attachRef === &apos;function&apos; &amp;&amp;\n      typeof object.detachRef === &apos;function&apos;\n    );\n  },\n\n  /**\n   * Adds a component by ref to an owner component.\n   *\n   * @param {ReactComponent} component Component to reference.\n   * @param {string} ref Name by which to refer to the component.\n   * @param {ReactOwner} owner Component on which to record the ref.\n   * @final\n   * @internal\n   */\n  addComponentAsRefTo: function(component, ref, owner) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ReactOwner.isValidOwner(owner),\n      &apos;addComponentAsRefTo(...): Only a ReactOwner can have refs. This &apos; +\n      &apos;usually means that you\\&apos;re trying to add a ref to a component that &apos; +\n      &apos;doesn\\&apos;t have an owner (that is, was not created inside of another &apos; +\n      &apos;component\\&apos;s `render` method). Try rendering this component inside of &apos; +\n      &apos;a new top-level component which will hold the ref.&apos;\n    ) : invariant(ReactOwner.isValidOwner(owner)));\n    owner.attachRef(ref, component);\n  },\n\n  /**\n   * Removes a component by ref from an owner component.\n   *\n   * @param {ReactComponent} component Component to dereference.\n   * @param {string} ref Name of the ref to remove.\n   * @param {ReactOwner} owner Component on which the ref is recorded.\n   * @final\n   * @internal\n   */\n  removeComponentAsRefFrom: function(component, ref, owner) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ReactOwner.isValidOwner(owner),\n      &apos;removeComponentAsRefFrom(...): Only a ReactOwner can have refs. This &apos; +\n      &apos;usually means that you\\&apos;re trying to remove a ref to a component that &apos; +\n      &apos;doesn\\&apos;t have an owner (that is, was not created inside of another &apos; +\n      &apos;component\\&apos;s `render` method). Try rendering this component inside of &apos; +\n      &apos;a new top-level component which will hold the ref.&apos;\n    ) : invariant(ReactOwner.isValidOwner(owner)));\n    // Check that `component` is still the current ref because we do not want to\n    // detach the ref if another component stole it.\n    if (owner.refs[ref] === component) {\n      owner.detachRef(ref);\n    }\n  },\n\n  /**\n   * A ReactComponent must mix this in to have refs.\n   *\n   * @lends {ReactOwner.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Lazily allocates the refs object and stores `component` as `ref`.\n     *\n     * @param {string} ref Reference name.\n     * @param {component} component Component to store as `ref`.\n     * @final\n     * @private\n     */\n    attachRef: function(ref, component) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        component.isOwnedBy(this),\n        &apos;attachRef(%s, ...): Only a component\\&apos;s owner can store a ref to it.&apos;,\n        ref\n      ) : invariant(component.isOwnedBy(this)));\n      var refs = this.refs || (this.refs = {});\n      refs[ref] = component;\n    },\n\n    /**\n     * Detaches a reference name.\n     *\n     * @param {string} ref Name to dereference.\n     * @final\n     * @private\n     */\n    detachRef: function(ref) {\n      delete this.refs[ref];\n    }\n\n  }\n\n};\n\nmodule.exports = ReactOwner;\n\n},{&quot;./invariant&quot;:108}],60:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPerf\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * ReactPerf is a general AOP system designed to measure performance. This\n * module only has the hooks: see ReactDefaultPerf for the analysis tool.\n */\nvar ReactPerf = {\n  /**\n   * Boolean to enable/disable measurement. Set to false by default to prevent\n   * accidental logging and perf loss.\n   */\n  enableMeasure: false,\n\n  /**\n   * Holds onto the measure function in use. By default, don&apos;t measure\n   * anything, but we&apos;ll override this if we inject a measure function.\n   */\n  storedMeasure: _noMeasure,\n\n  /**\n   * Use this to wrap methods you want to measure. Zero overhead in production.\n   *\n   * @param {string} objName\n   * @param {string} fnName\n   * @param {function} func\n   * @return {function}\n   */\n  measure: function(objName, fnName, func) {\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var measuredFunc = null;\n      return function() {\n        if (ReactPerf.enableMeasure) {\n          if (!measuredFunc) {\n            measuredFunc = ReactPerf.storedMeasure(objName, fnName, func);\n          }\n          return measuredFunc.apply(this, arguments);\n        }\n        return func.apply(this, arguments);\n      };\n    }\n    return func;\n  },\n\n  injection: {\n    /**\n     * @param {function} measure\n     */\n    injectMeasure: function(measure) {\n      ReactPerf.storedMeasure = measure;\n    }\n  }\n};\n\n/**\n * Simply passes through the measured function, without measuring it.\n *\n * @param {string} objName\n * @param {string} fnName\n * @param {function} func\n * @return {function}\n */\nfunction _noMeasure(objName, fnName, func) {\n  return func;\n}\n\nmodule.exports = ReactPerf;\n\n},{}],61:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTransferer\n */\n\n&quot;use strict&quot;;\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar joinClasses = require(&quot;./joinClasses&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Creates a transfer strategy that will merge prop values using the supplied\n * `mergeStrategy`. If a prop was previously unset, this just sets it.\n *\n * @param {function} mergeStrategy\n * @return {function}\n */\nfunction createTransferStrategy(mergeStrategy) {\n  return function(props, key, value) {\n    if (!props.hasOwnProperty(key)) {\n      props[key] = value;\n    } else {\n      props[key] = mergeStrategy(props[key], value);\n    }\n  };\n}\n\n/**\n * Transfer strategies dictate how props are transferred by `transferPropsTo`.\n * NOTE: if you add any more exceptions to this list you should be sure to\n * update `cloneWithProps()` accordingly.\n */\nvar TransferStrategies = {\n  /**\n   * Never transfer `children`.\n   */\n  children: emptyFunction,\n  /**\n   * Transfer the `className` prop by merging them.\n   */\n  className: createTransferStrategy(joinClasses),\n  /**\n   * Never transfer the `key` prop.\n   */\n  key: emptyFunction,\n  /**\n   * Never transfer the `ref` prop.\n   */\n  ref: emptyFunction,\n  /**\n   * Transfer the `style` prop (which is an object) by merging them.\n   */\n  style: createTransferStrategy(merge)\n};\n\n/**\n * ReactPropTransferer are capable of transferring props to another component\n * using a `transferPropsTo` method.\n *\n * @class ReactPropTransferer\n */\nvar ReactPropTransferer = {\n\n  TransferStrategies: TransferStrategies,\n\n  /**\n   * Merge two props objects using TransferStrategies.\n   *\n   * @param {object} oldProps original props (they take precedence)\n   * @param {object} newProps new props to merge in\n   * @return {object} a new object containing both sets of props merged.\n   */\n  mergeProps: function(oldProps, newProps) {\n    var props = merge(oldProps);\n\n    for (var thisKey in newProps) {\n      if (!newProps.hasOwnProperty(thisKey)) {\n        continue;\n      }\n\n      var transferStrategy = TransferStrategies[thisKey];\n\n      if (transferStrategy) {\n        transferStrategy(props, thisKey, newProps[thisKey]);\n      } else if (!props.hasOwnProperty(thisKey)) {\n        props[thisKey] = newProps[thisKey];\n      }\n    }\n\n    return props;\n  },\n\n  /**\n   * @lends {ReactPropTransferer.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Transfer props from this component to a target component.\n     *\n     * Props that do not have an explicit transfer strategy will be transferred\n     * only if the target component does not already have the prop set.\n     *\n     * This is usually used to pass down props to a returned root component.\n     *\n     * @param {ReactComponent} component Component receiving the properties.\n     * @return {ReactComponent} The supplied `component`.\n     * @final\n     * @protected\n     */\n    transferPropsTo: function(component) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        component._owner === this,\n        &apos;%s: You can\\&apos;t call transferPropsTo() on a component that you &apos; +\n        &apos;don\\&apos;t own, %s. This usually means you are calling &apos; +\n        &apos;transferPropsTo() on a component passed in as props or children.&apos;,\n        this.constructor.displayName,\n        component.constructor.displayName\n      ) : invariant(component._owner === this));\n\n      component.props = ReactPropTransferer.mergeProps(\n        component.props,\n        this.props\n      );\n\n      return component;\n    }\n\n  }\n};\n\nmodule.exports = ReactPropTransferer;\n\n},{&quot;./emptyFunction&quot;:95,&quot;./invariant&quot;:108,&quot;./joinClasses&quot;:113,&quot;./merge&quot;:117}],62:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypeLocationNames\n */\n\n&quot;use strict&quot;;\n\nvar ReactPropTypeLocationNames = {};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  ReactPropTypeLocationNames = {\n    prop: &apos;prop&apos;,\n    context: &apos;context&apos;,\n    childContext: &apos;child context&apos;\n  };\n}\n\nmodule.exports = ReactPropTypeLocationNames;\n\n},{}],63:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypeLocations\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\nvar ReactPropTypeLocations = keyMirror({\n  prop: null,\n  context: null,\n  childContext: null\n});\n\nmodule.exports = ReactPropTypeLocations;\n\n},{&quot;./keyMirror&quot;:114}],64:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypes\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactPropTypeLocationNames = require(&quot;./ReactPropTypeLocationNames&quot;);\n\nvar warning = require(&quot;./warning&quot;);\nvar createObjectFrom = require(&quot;./createObjectFrom&quot;);\n\n/**\n * Collection of methods that allow declaration and validation of props that are\n * supplied to React components. Example usage:\n *\n *   var Props = require(&apos;ReactPropTypes&apos;);\n *   var MyArticle = React.createClass({\n *     propTypes: {\n *       // An optional string prop named &quot;description&quot;.\n *       description: Props.string,\n *\n *       // A required enum prop named &quot;category&quot;.\n *       category: Props.oneOf([&apos;News&apos;,&apos;Photos&apos;]).isRequired,\n *\n *       // A prop named &quot;dialog&quot; that requires an instance of Dialog.\n *       dialog: Props.instanceOf(Dialog).isRequired\n *     },\n *     render: function() { ... }\n *   });\n *\n * A more formal specification of how these methods are used:\n *\n *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)\n *   decl := ReactPropTypes.{type}(.isRequired)?\n *\n * Each and every declaration produces a function with the same signature. This\n * allows the creation of custom validation functions. For example:\n *\n *   var Props = require(&apos;ReactPropTypes&apos;);\n *   var MyLink = React.createClass({\n *     propTypes: {\n *       // An optional string or URI prop named &quot;href&quot;.\n *       href: function(props, propName, componentName) {\n *         var propValue = props[propName];\n *         warning(\n *           propValue == null ||\n *           typeof propValue === &apos;string&apos; ||\n *           propValue instanceof URI,\n *           &apos;Invalid `%s` supplied to `%s`, expected string or URI.&apos;,\n *           propName,\n *           componentName\n *         );\n *       }\n *     },\n *     render: function() { ... }\n *   });\n *\n * @internal\n */\nvar Props = {\n\n  array: createPrimitiveTypeChecker(&apos;array&apos;),\n  bool: createPrimitiveTypeChecker(&apos;boolean&apos;),\n  func: createPrimitiveTypeChecker(&apos;function&apos;),\n  number: createPrimitiveTypeChecker(&apos;number&apos;),\n  object: createPrimitiveTypeChecker(&apos;object&apos;),\n  string: createPrimitiveTypeChecker(&apos;string&apos;),\n\n  shape: createShapeTypeChecker,\n  oneOf: createEnumTypeChecker,\n  oneOfType: createUnionTypeChecker,\n  arrayOf: createArrayOfTypeChecker,\n\n  instanceOf: createInstanceTypeChecker,\n\n  renderable: createRenderableTypeChecker(),\n\n  component: createComponentTypeChecker(),\n\n  any: createAnyTypeChecker()\n};\n\nvar ANONYMOUS = &apos;&lt;&lt;anonymous&gt;&gt;&apos;;\n\nfunction isRenderable(propValue) {\n  switch(typeof propValue) {\n    case &apos;number&apos;:\n    case &apos;string&apos;:\n      return true;\n    case &apos;object&apos;:\n      if (Array.isArray(propValue)) {\n        return propValue.every(isRenderable);\n      }\n      if (ReactComponent.isValidComponent(propValue)) {\n        return true;\n      }\n      for (var k in propValue) {\n        if (!isRenderable(propValue[k])) {\n          return false;\n        }\n      }\n      return true;\n    default:\n      return false;\n  }\n}\n\n// Equivalent of typeof but with special handling for arrays\nfunction getPropType(propValue) {\n  var propType = typeof propValue;\n  if (propType === &apos;object&apos; &amp;&amp; Array.isArray(propValue)) {\n    return &apos;array&apos;;\n  }\n  return propType;\n}\n\nfunction createAnyTypeChecker() {\n  function validateAnyType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    return true; // is always valid\n  }\n  return createChainableTypeChecker(validateAnyType);\n}\n\nfunction createPrimitiveTypeChecker(expectedType) {\n  function validatePrimitiveType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var propType = getPropType(propValue);\n    var isValid = propType === expectedType;\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` of type `%s` supplied to `%s`, expected `%s`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        propType,\n        componentName,\n        expectedType\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validatePrimitiveType);\n}\n\nfunction createEnumTypeChecker(expectedValues) {\n  var expectedEnum = createObjectFrom(expectedValues);\n  function validateEnumType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = expectedEnum[propValue];\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected one of %s.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName,\n        JSON.stringify(Object.keys(expectedEnum))\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateEnumType);\n}\n\nfunction createShapeTypeChecker(shapeTypes) {\n  function validateShapeType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var propType = getPropType(propValue);\n    var isValid = propType === &apos;object&apos;;\n    if (isValid) {\n      for (var key in shapeTypes) {\n        var checker = shapeTypes[key];\n        if (checker &amp;&amp; !checker(propValue, key, componentName, location)) {\n          return false;\n        }\n      }\n    }\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` of type `%s` supplied to `%s`, expected `object`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        propType,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateShapeType);\n}\n\nfunction createInstanceTypeChecker(expectedClass) {\n  function validateInstanceType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = propValue instanceof expectedClass;\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected instance of `%s`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName,\n        expectedClass.name || ANONYMOUS\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateInstanceType);\n}\n\nfunction createArrayOfTypeChecker(propTypeChecker) {\n  function validateArrayType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = Array.isArray(propValue);\n    if (isValid) {\n      for (var i = 0; i &lt; propValue.length; i++) {\n        if (!propTypeChecker(propValue, i, componentName, location)) {\n          return false;\n        }\n      }\n    }\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected an array.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateArrayType);\n}\n\nfunction createRenderableTypeChecker() {\n  function validateRenderableType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = isRenderable(propValue);\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected a renderable prop.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateRenderableType);\n}\n\nfunction createComponentTypeChecker() {\n  function validateComponentType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = ReactComponent.isValidComponent(propValue);\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected a React component.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateComponentType);\n}\n\nfunction createUnionTypeChecker(arrayOfValidators) {\n  return function(props, propName, componentName, location) {\n    var isValid = false;\n    for (var ii = 0; ii &lt; arrayOfValidators.length; ii++) {\n      var validate = arrayOfValidators[ii];\n      if (typeof validate.weak === &apos;function&apos;) {\n        validate = validate.weak;\n      }\n      if (validate(props, propName, componentName, location)) {\n        isValid = true;\n        break;\n      }\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? warning(\n      isValid,\n      &apos;Invalid %s `%s` supplied to `%s`.&apos;,\n      ReactPropTypeLocationNames[location],\n      propName,\n      componentName || ANONYMOUS\n    ) : null);\n    return isValid;\n  };\n}\n\nfunction createChainableTypeChecker(validate) {\n  function checkType(\n    isRequired, shouldWarn, props, propName, componentName, location\n  ) {\n    var propValue = props[propName];\n    if (propValue != null) {\n      // Only validate if there is a value to check.\n      return validate(\n        shouldWarn,\n        propValue,\n        propName,\n        componentName || ANONYMOUS,\n        location\n      );\n    } else {\n      var isValid = !isRequired;\n      if (shouldWarn) {\n        (&quot;production&quot; !== &quot;development&quot; ? warning(\n          isValid,\n          &apos;Required %s `%s` was not specified in `%s`.&apos;,\n          ReactPropTypeLocationNames[location],\n          propName,\n          componentName || ANONYMOUS\n        ) : null);\n      }\n      return isValid;\n    }\n  }\n\n  var checker = checkType.bind(null, false, true);\n  checker.weak = checkType.bind(null, false, false);\n  checker.isRequired = checkType.bind(null, true, true);\n  checker.weak.isRequired = checkType.bind(null, true, false);\n  checker.isRequired.weak = checker.weak.isRequired;\n\n  return checker;\n}\n\nmodule.exports = Props;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactPropTypeLocationNames&quot;:62,&quot;./createObjectFrom&quot;:93,&quot;./warning&quot;:129}],65:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPutListenerQueue\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\nfunction ReactPutListenerQueue() {\n  this.listenersToPut = [];\n}\n\nmixInto(ReactPutListenerQueue, {\n  enqueuePutListener: function(rootNodeID, propKey, propValue) {\n    this.listenersToPut.push({\n      rootNodeID: rootNodeID,\n      propKey: propKey,\n      propValue: propValue\n    });\n  },\n\n  putListeners: function() {\n    for (var i = 0; i &lt; this.listenersToPut.length; i++) {\n      var listenerToPut = this.listenersToPut[i];\n      ReactEventEmitter.putListener(\n        listenerToPut.rootNodeID,\n        listenerToPut.propKey,\n        listenerToPut.propValue\n      );\n    }\n  },\n\n  reset: function() {\n    this.listenersToPut.length = 0;\n  },\n\n  destructor: function() {\n    this.reset();\n  }\n});\n\nPooledClass.addPoolingTo(ReactPutListenerQueue);\n\nmodule.exports = ReactPutListenerQueue;\n\n},{&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./mixInto&quot;:120}],66:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactReconcileTransaction\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar ReactMountReady = require(&quot;./ReactMountReady&quot;);\nvar ReactPutListenerQueue = require(&quot;./ReactPutListenerQueue&quot;);\nvar Transaction = require(&quot;./Transaction&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * Ensures that, when possible, the selection range (currently selected text\n * input) is not disturbed by performing the transaction.\n */\nvar SELECTION_RESTORATION = {\n  /**\n   * @return {Selection} Selection information.\n   */\n  initialize: ReactInputSelection.getSelectionInformation,\n  /**\n   * @param {Selection} sel Selection information returned from `initialize`.\n   */\n  close: ReactInputSelection.restoreSelection\n};\n\n/**\n * Suppresses events (blur/focus) that could be inadvertently dispatched due to\n * high level DOM manipulations (like temporarily removing a text input from the\n * DOM).\n */\nvar EVENT_SUPPRESSION = {\n  /**\n   * @return {boolean} The enabled status of `ReactEventEmitter` before the\n   * reconciliation.\n   */\n  initialize: function() {\n    var currentlyEnabled = ReactEventEmitter.isEnabled();\n    ReactEventEmitter.setEnabled(false);\n    return currentlyEnabled;\n  },\n\n  /**\n   * @param {boolean} previouslyEnabled Enabled status of `ReactEventEmitter`\n   *   before the reconciliation occured. `close` restores the previous value.\n   */\n  close: function(previouslyEnabled) {\n    ReactEventEmitter.setEnabled(previouslyEnabled);\n  }\n};\n\n/**\n * Provides a `ReactMountReady` queue for collecting `onDOMReady` callbacks\n * during the performing of the transaction.\n */\nvar ON_DOM_READY_QUEUEING = {\n  /**\n   * Initializes the internal `onDOMReady` queue.\n   */\n  initialize: function() {\n    this.reactMountReady.reset();\n  },\n\n  /**\n   * After DOM is flushed, invoke all registered `onDOMReady` callbacks.\n   */\n  close: function() {\n    this.reactMountReady.notifyAll();\n  }\n};\n\nvar PUT_LISTENER_QUEUEING = {\n  initialize: function() {\n    this.putListenerQueue.reset();\n  },\n\n  close: function() {\n    this.putListenerQueue.putListeners();\n  }\n};\n\n/**\n * Executed within the scope of the `Transaction` instance. Consider these as\n * being member methods, but with an implied ordering while being isolated from\n * each other.\n */\nvar TRANSACTION_WRAPPERS = [\n  PUT_LISTENER_QUEUEING,\n  SELECTION_RESTORATION,\n  EVENT_SUPPRESSION,\n  ON_DOM_READY_QUEUEING\n];\n\n/**\n * Currently:\n * - The order that these are listed in the transaction is critical:\n * - Suppresses events.\n * - Restores selection range.\n *\n * Future:\n * - Restore document/overflow scroll positions that were unintentionally\n *   modified via DOM insertions above the top viewport boundary.\n * - Implement/integrate with customized constraint based layout system and keep\n *   track of which dimensions must be remeasured.\n *\n * @class ReactReconcileTransaction\n */\nfunction ReactReconcileTransaction() {\n  this.reinitializeTransaction();\n  this.reactMountReady = ReactMountReady.getPooled(null);\n  this.putListenerQueue = ReactPutListenerQueue.getPooled();\n}\n\nvar Mixin = {\n  /**\n   * @see Transaction\n   * @abstract\n   * @final\n   * @return {array&lt;object&gt;} List of operation wrap proceedures.\n   *   TODO: convert to array&lt;TransactionWrapper&gt;\n   */\n  getTransactionWrappers: function() {\n    if (ExecutionEnvironment.canUseDOM) {\n      return TRANSACTION_WRAPPERS;\n    } else {\n      return [];\n    }\n  },\n\n  /**\n   * @return {object} The queue to collect `onDOMReady` callbacks with.\n   *   TODO: convert to ReactMountReady\n   */\n  getReactMountReady: function() {\n    return this.reactMountReady;\n  },\n\n  getPutListenerQueue: function() {\n    return this.putListenerQueue;\n  },\n\n  /**\n   * `PooledClass` looks for this, and will invoke this before allowing this\n   * instance to be resused.\n   */\n  destructor: function() {\n    ReactMountReady.release(this.reactMountReady);\n    this.reactMountReady = null;\n\n    ReactPutListenerQueue.release(this.putListenerQueue);\n    this.putListenerQueue = null;\n  }\n};\n\n\nmixInto(ReactReconcileTransaction, Transaction.Mixin);\nmixInto(ReactReconcileTransaction, Mixin);\n\nPooledClass.addPoolingTo(ReactReconcileTransaction);\n\nmodule.exports = ReactReconcileTransaction;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInputSelection&quot;:52,&quot;./ReactMountReady&quot;:56,&quot;./ReactPutListenerQueue&quot;:65,&quot;./Transaction&quot;:84,&quot;./mixInto&quot;:120}],67:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar ReactRootIndexInjection = {\n  /**\n   * @param {function} _createReactRootIndex\n   */\n  injectCreateReactRootIndex: function(_createReactRootIndex) {\n    ReactRootIndex.createReactRootIndex = _createReactRootIndex;\n  }\n};\n\nvar ReactRootIndex = {\n  createReactRootIndex: null,\n  injection: ReactRootIndexInjection\n};\n\nmodule.exports = ReactRootIndex;\n\n},{}],68:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @typechecks static-only\n * @providesModule ReactServerRendering\n */\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMarkupChecksum = require(&quot;./ReactMarkupChecksum&quot;);\nvar ReactReconcileTransaction = require(&quot;./ReactReconcileTransaction&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * @param {ReactComponent} component\n * @return {string} the markup\n */\nfunction renderComponentToString(component) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    ReactComponent.isValidComponent(component),\n    &apos;renderComponentToString(): You must pass a valid ReactComponent.&apos;\n  ) : invariant(ReactComponent.isValidComponent(component)));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !(arguments.length === 2 &amp;&amp; typeof arguments[1] === &apos;function&apos;),\n    &apos;renderComponentToString(): This function became synchronous and now &apos; +\n    &apos;returns the generated markup. Please remove the second parameter.&apos;\n  ) : invariant(!(arguments.length === 2 &amp;&amp; typeof arguments[1] === &apos;function&apos;)));\n\n  var id = ReactInstanceHandles.createReactRootID();\n  var transaction = ReactReconcileTransaction.getPooled();\n  transaction.reinitializeTransaction();\n  try {\n    return transaction.perform(function() {\n      var markup = component.mountComponent(id, transaction, 0);\n      return ReactMarkupChecksum.addChecksumToMarkup(markup);\n    }, null);\n  } finally {\n    ReactReconcileTransaction.release(transaction);\n  }\n}\n\nmodule.exports = {\n  renderComponentToString: renderComponentToString\n};\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMarkupChecksum&quot;:54,&quot;./ReactReconcileTransaction&quot;:66,&quot;./invariant&quot;:108}],69:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactTextComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * Text nodes violate a couple assumptions that React makes about components:\n *\n *  - When mounting text into the DOM, adjacent text nodes are merged.\n *  - Text nodes cannot be assigned a React root ID.\n *\n * This component is used to wrap strings in elements so that they can undergo\n * the same reconciliation that is applied to elements.\n *\n * TODO: Investigate representing React components in the DOM with text nodes.\n *\n * @class ReactTextComponent\n * @extends ReactComponent\n * @internal\n */\nvar ReactTextComponent = function(initialText) {\n  this.construct({text: initialText});\n};\n\nmixInto(ReactTextComponent, ReactComponent.Mixin);\nmixInto(ReactTextComponent, {\n\n  /**\n   * Creates the markup for this text node. This node is not intended to have\n   * any features besides containing text content.\n   *\n   * @param {string} rootID DOM ID of the root node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {string} Markup for this text node.\n   * @internal\n   */\n  mountComponent: function(rootID, transaction, mountDepth) {\n    ReactComponent.Mixin.mountComponent.call(\n      this,\n      rootID,\n      transaction,\n      mountDepth\n    );\n    return (\n      &apos;&lt;span &apos; + DOMPropertyOperations.createMarkupForID(rootID) + &apos;&gt;&apos; +\n        escapeTextForBrowser(this.props.text) +\n      &apos;&lt;/span&gt;&apos;\n    );\n  },\n\n  /**\n   * Updates this component by updating the text content.\n   *\n   * @param {object} nextComponent Contains the next text content.\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   */\n  receiveComponent: function(nextComponent, transaction) {\n    var nextProps = nextComponent.props;\n    if (nextProps.text !== this.props.text) {\n      this.props.text = nextProps.text;\n      ReactComponent.BackendIDOperations.updateTextContentByID(\n        this._rootNodeID,\n        nextProps.text\n      );\n    }\n  }\n\n});\n\n// Expose the constructor on itself and the prototype for consistency with other\n// descriptors.\nReactTextComponent.type = ReactTextComponent;\nReactTextComponent.prototype.type = ReactTextComponent;\n\nmodule.exports = ReactTextComponent;\n\n},{&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactComponent&quot;:26,&quot;./escapeTextForBrowser&quot;:96,&quot;./mixInto&quot;:120}],70:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactUpdates\n */\n\n&quot;use strict&quot;;\n\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar dirtyComponents = [];\n\nvar batchingStrategy = null;\n\nfunction ensureBatchingStrategy() {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(batchingStrategy, &apos;ReactUpdates: must inject a batching strategy&apos;) : invariant(batchingStrategy));\n}\n\nfunction batchedUpdates(callback, param) {\n  ensureBatchingStrategy();\n  batchingStrategy.batchedUpdates(callback, param);\n}\n\n/**\n * Array comparator for ReactComponents by owner depth\n *\n * @param {ReactComponent} c1 first component you&apos;re comparing\n * @param {ReactComponent} c2 second component you&apos;re comparing\n * @return {number} Return value usable by Array.prototype.sort().\n */\nfunction mountDepthComparator(c1, c2) {\n  return c1._mountDepth - c2._mountDepth;\n}\n\nfunction runBatchedUpdates() {\n  // Since reconciling a component higher in the owner hierarchy usually (not\n  // always -- see shouldComponentUpdate()) will reconcile children, reconcile\n  // them before their children by sorting the array.\n\n  dirtyComponents.sort(mountDepthComparator);\n\n  for (var i = 0; i &lt; dirtyComponents.length; i++) {\n    // If a component is unmounted before pending changes apply, ignore them\n    // TODO: Queue unmounts in the same list to avoid this happening at all\n    var component = dirtyComponents[i];\n    if (component.isMounted()) {\n      // If performUpdateIfNecessary happens to enqueue any new updates, we\n      // shouldn&apos;t execute the callbacks until the next render happens, so\n      // stash the callbacks first\n      var callbacks = component._pendingCallbacks;\n      component._pendingCallbacks = null;\n      component.performUpdateIfNecessary();\n      if (callbacks) {\n        for (var j = 0; j &lt; callbacks.length; j++) {\n          callbacks[j].call(component);\n        }\n      }\n    }\n  }\n}\n\nfunction clearDirtyComponents() {\n  dirtyComponents.length = 0;\n}\n\nvar flushBatchedUpdates = ReactPerf.measure(\n  &apos;ReactUpdates&apos;,\n  &apos;flushBatchedUpdates&apos;,\n  function() {\n    // Run these in separate functions so the JIT can optimize\n    try {\n      runBatchedUpdates();\n    } finally {\n      clearDirtyComponents();\n    }\n  }\n);\n\n/**\n * Mark a component as needing a rerender, adding an optional callback to a\n * list of functions which will be executed once the rerender occurs.\n */\nfunction enqueueUpdate(component, callback) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !callback || typeof callback === &quot;function&quot;,\n    &apos;enqueueUpdate(...): You called `setProps`, `replaceProps`, &apos; +\n    &apos;`setState`, `replaceState`, or `forceUpdate` with a callback that &apos; +\n    &apos;isn\\&apos;t callable.&apos;\n  ) : invariant(!callback || typeof callback === &quot;function&quot;));\n  ensureBatchingStrategy();\n\n  if (!batchingStrategy.isBatchingUpdates) {\n    component.performUpdateIfNecessary();\n    callback &amp;&amp; callback.call(component);\n    return;\n  }\n\n  dirtyComponents.push(component);\n\n  if (callback) {\n    if (component._pendingCallbacks) {\n      component._pendingCallbacks.push(callback);\n    } else {\n      component._pendingCallbacks = [callback];\n    }\n  }\n}\n\nvar ReactUpdatesInjection = {\n  injectBatchingStrategy: function(_batchingStrategy) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      _batchingStrategy,\n      &apos;ReactUpdates: must provide a batching strategy&apos;\n    ) : invariant(_batchingStrategy));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof _batchingStrategy.batchedUpdates === &apos;function&apos;,\n      &apos;ReactUpdates: must provide a batchedUpdates() function&apos;\n    ) : invariant(typeof _batchingStrategy.batchedUpdates === &apos;function&apos;));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof _batchingStrategy.isBatchingUpdates === &apos;boolean&apos;,\n      &apos;ReactUpdates: must provide an isBatchingUpdates boolean attribute&apos;\n    ) : invariant(typeof _batchingStrategy.isBatchingUpdates === &apos;boolean&apos;));\n    batchingStrategy = _batchingStrategy;\n  }\n};\n\nvar ReactUpdates = {\n  batchedUpdates: batchedUpdates,\n  enqueueUpdate: enqueueUpdate,\n  flushBatchedUpdates: flushBatchedUpdates,\n  injection: ReactUpdatesInjection\n};\n\nmodule.exports = ReactUpdates;\n\n},{&quot;./ReactPerf&quot;:60,&quot;./invariant&quot;:108}],71:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SelectEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\nvar getActiveElement = require(&quot;./getActiveElement&quot;);\nvar isTextInputElement = require(&quot;./isTextInputElement&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\nvar shallowEqual = require(&quot;./shallowEqual&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  select: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onSelect: null}),\n      captured: keyOf({onSelectCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topContextMenu,\n      topLevelTypes.topFocus,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topMouseDown,\n      topLevelTypes.topMouseUp,\n      topLevelTypes.topSelectionChange\n    ]\n  }\n};\n\nvar activeElement = null;\nvar activeElementID = null;\nvar lastSelection = null;\nvar mouseDown = false;\n\n/**\n * Get an object which is a unique representation of the current selection.\n *\n * The return value will not be consistent across nodes or browsers, but\n * two identical selections on the same node will return identical objects.\n *\n * @param {DOMElement} node\n * @param {object}\n */\nfunction getSelection(node) {\n  if (&apos;selectionStart&apos; in node &amp;&amp;\n      ReactInputSelection.hasSelectionCapabilities(node)) {\n    return {\n      start: node.selectionStart,\n      end: node.selectionEnd\n    };\n  } else if (document.selection) {\n    var range = document.selection.createRange();\n    return {\n      parentElement: range.parentElement(),\n      text: range.text,\n      top: range.boundingTop,\n      left: range.boundingLeft\n    };\n  } else {\n    var selection = window.getSelection();\n    return {\n      anchorNode: selection.anchorNode,\n      anchorOffset: selection.anchorOffset,\n      focusNode: selection.focusNode,\n      focusOffset: selection.focusOffset\n    };\n  }\n}\n\n/**\n * Poll selection to see whether it&apos;s changed.\n *\n * @param {object} nativeEvent\n * @return {?SyntheticEvent}\n */\nfunction constructSelectEvent(nativeEvent) {\n  // Ensure we have the right element, and that the user is not dragging a\n  // selection (this matches native `select` event behavior). In HTML5, select\n  // fires only on input and textarea thus if there&apos;s no focused element we\n  // won&apos;t dispatch.\n  if (mouseDown ||\n      activeElement == null ||\n      activeElement != getActiveElement()) {\n    return;\n  }\n\n  // Only fire when selection has actually changed.\n  var currentSelection = getSelection(activeElement);\n  if (!lastSelection || !shallowEqual(lastSelection, currentSelection)) {\n    lastSelection = currentSelection;\n\n    var syntheticEvent = SyntheticEvent.getPooled(\n      eventTypes.select,\n      activeElementID,\n      nativeEvent\n    );\n\n    syntheticEvent.type = &apos;select&apos;;\n    syntheticEvent.target = activeElement;\n\n    EventPropagators.accumulateTwoPhaseDispatches(syntheticEvent);\n\n    return syntheticEvent;\n  }\n}\n\n/**\n * This plugin creates an `onSelect` event that normalizes select events\n * across form elements.\n *\n * Supported elements are:\n * - input (see `isTextInputElement`)\n * - textarea\n * - contentEditable\n *\n * This differs from native browser implementations in the following ways:\n * - Fires on contentEditable fields as well as inputs.\n * - Fires for collapsed selection.\n * - Fires after user input.\n */\nvar SelectEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    switch (topLevelType) {\n      // Track the input node that has focus.\n      case topLevelTypes.topFocus:\n        if (isTextInputElement(topLevelTarget) ||\n            topLevelTarget.contentEditable === &apos;true&apos;) {\n          activeElement = topLevelTarget;\n          activeElementID = topLevelTargetID;\n          lastSelection = null;\n        }\n        break;\n      case topLevelTypes.topBlur:\n        activeElement = null;\n        activeElementID = null;\n        lastSelection = null;\n        break;\n\n      // Don&apos;t fire the event while the user is dragging. This matches the\n      // semantics of the native select event.\n      case topLevelTypes.topMouseDown:\n        mouseDown = true;\n        break;\n      case topLevelTypes.topContextMenu:\n      case topLevelTypes.topMouseUp:\n        mouseDown = false;\n        return constructSelectEvent(nativeEvent);\n\n      // Chrome and IE fire non-standard event when selection is changed (and\n      // sometimes when it hasn&apos;t).\n      // Firefox doesn&apos;t support selectionchange, so check selection status\n      // after each key entry. The selection changes after keydown and before\n      // keyup, but we check on keydown as well in the case of holding down a\n      // key, when multiple keydown events are fired but only one keyup is.\n      case topLevelTypes.topSelectionChange:\n      case topLevelTypes.topKeyDown:\n      case topLevelTypes.topKeyUp:\n        return constructSelectEvent(nativeEvent);\n    }\n  }\n};\n\nmodule.exports = SelectEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ReactInputSelection&quot;:52,&quot;./SyntheticEvent&quot;:77,&quot;./getActiveElement&quot;:99,&quot;./isTextInputElement&quot;:111,&quot;./keyOf&quot;:115,&quot;./shallowEqual&quot;:125}],72:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ServerReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n/**\n * Size of the reactRoot ID space. We generate random numbers for React root\n * IDs and if there&apos;s a collision the events and DOM update system will\n * get confused. In the future we need a way to generate GUIDs but for\n * now this will work on a smaller scale.\n */\nvar GLOBAL_MOUNT_POINT_MAX = Math.pow(2, 53);\n\nvar ServerReactRootIndex = {\n  createReactRootIndex: function() {\n    return Math.ceil(Math.random() * GLOBAL_MOUNT_POINT_MAX);\n  }\n};\n\nmodule.exports = ServerReactRootIndex;\n\n},{}],73:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SimpleEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar SyntheticClipboardEvent = require(&quot;./SyntheticClipboardEvent&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\nvar SyntheticFocusEvent = require(&quot;./SyntheticFocusEvent&quot;);\nvar SyntheticKeyboardEvent = require(&quot;./SyntheticKeyboardEvent&quot;);\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\nvar SyntheticDragEvent = require(&quot;./SyntheticDragEvent&quot;);\nvar SyntheticTouchEvent = require(&quot;./SyntheticTouchEvent&quot;);\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\nvar SyntheticWheelEvent = require(&quot;./SyntheticWheelEvent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  blur: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onBlur: true}),\n      captured: keyOf({onBlurCapture: true})\n    }\n  },\n  click: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onClick: true}),\n      captured: keyOf({onClickCapture: true})\n    }\n  },\n  contextMenu: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onContextMenu: true}),\n      captured: keyOf({onContextMenuCapture: true})\n    }\n  },\n  copy: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCopy: true}),\n      captured: keyOf({onCopyCapture: true})\n    }\n  },\n  cut: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCut: true}),\n      captured: keyOf({onCutCapture: true})\n    }\n  },\n  doubleClick: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDoubleClick: true}),\n      captured: keyOf({onDoubleClickCapture: true})\n    }\n  },\n  drag: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDrag: true}),\n      captured: keyOf({onDragCapture: true})\n    }\n  },\n  dragEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragEnd: true}),\n      captured: keyOf({onDragEndCapture: true})\n    }\n  },\n  dragEnter: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragEnter: true}),\n      captured: keyOf({onDragEnterCapture: true})\n    }\n  },\n  dragExit: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragExit: true}),\n      captured: keyOf({onDragExitCapture: true})\n    }\n  },\n  dragLeave: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragLeave: true}),\n      captured: keyOf({onDragLeaveCapture: true})\n    }\n  },\n  dragOver: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragOver: true}),\n      captured: keyOf({onDragOverCapture: true})\n    }\n  },\n  dragStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragStart: true}),\n      captured: keyOf({onDragStartCapture: true})\n    }\n  },\n  drop: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDrop: true}),\n      captured: keyOf({onDropCapture: true})\n    }\n  },\n  focus: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onFocus: true}),\n      captured: keyOf({onFocusCapture: true})\n    }\n  },\n  input: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onInput: true}),\n      captured: keyOf({onInputCapture: true})\n    }\n  },\n  keyDown: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyDown: true}),\n      captured: keyOf({onKeyDownCapture: true})\n    }\n  },\n  keyPress: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyPress: true}),\n      captured: keyOf({onKeyPressCapture: true})\n    }\n  },\n  keyUp: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyUp: true}),\n      captured: keyOf({onKeyUpCapture: true})\n    }\n  },\n  load: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onLoad: true}),\n      captured: keyOf({onLoadCapture: true})\n    }\n  },\n  error: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onError: true}),\n      captured: keyOf({onErrorCapture: true})\n    }\n  },\n  // Note: We do not allow listening to mouseOver events. Instead, use the\n  // onMouseEnter/onMouseLeave created by `EnterLeaveEventPlugin`.\n  mouseDown: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseDown: true}),\n      captured: keyOf({onMouseDownCapture: true})\n    }\n  },\n  mouseMove: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseMove: true}),\n      captured: keyOf({onMouseMoveCapture: true})\n    }\n  },\n  mouseOut: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseOut: true}),\n      captured: keyOf({onMouseOutCapture: true})\n    }\n  },\n  mouseOver: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseOver: true}),\n      captured: keyOf({onMouseOverCapture: true})\n    }\n  },\n  mouseUp: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseUp: true}),\n      captured: keyOf({onMouseUpCapture: true})\n    }\n  },\n  paste: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onPaste: true}),\n      captured: keyOf({onPasteCapture: true})\n    }\n  },\n  reset: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onReset: true}),\n      captured: keyOf({onResetCapture: true})\n    }\n  },\n  scroll: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onScroll: true}),\n      captured: keyOf({onScrollCapture: true})\n    }\n  },\n  submit: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onSubmit: true}),\n      captured: keyOf({onSubmitCapture: true})\n    }\n  },\n  touchCancel: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchCancel: true}),\n      captured: keyOf({onTouchCancelCapture: true})\n    }\n  },\n  touchEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchEnd: true}),\n      captured: keyOf({onTouchEndCapture: true})\n    }\n  },\n  touchMove: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchMove: true}),\n      captured: keyOf({onTouchMoveCapture: true})\n    }\n  },\n  touchStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchStart: true}),\n      captured: keyOf({onTouchStartCapture: true})\n    }\n  },\n  wheel: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onWheel: true}),\n      captured: keyOf({onWheelCapture: true})\n    }\n  }\n};\n\nvar topLevelEventsToDispatchConfig = {\n  topBlur:        eventTypes.blur,\n  topClick:       eventTypes.click,\n  topContextMenu: eventTypes.contextMenu,\n  topCopy:        eventTypes.copy,\n  topCut:         eventTypes.cut,\n  topDoubleClick: eventTypes.doubleClick,\n  topDrag:        eventTypes.drag,\n  topDragEnd:     eventTypes.dragEnd,\n  topDragEnter:   eventTypes.dragEnter,\n  topDragExit:    eventTypes.dragExit,\n  topDragLeave:   eventTypes.dragLeave,\n  topDragOver:    eventTypes.dragOver,\n  topDragStart:   eventTypes.dragStart,\n  topDrop:        eventTypes.drop,\n  topError:       eventTypes.error,\n  topFocus:       eventTypes.focus,\n  topInput:       eventTypes.input,\n  topKeyDown:     eventTypes.keyDown,\n  topKeyPress:    eventTypes.keyPress,\n  topKeyUp:       eventTypes.keyUp,\n  topLoad:        eventTypes.load,\n  topMouseDown:   eventTypes.mouseDown,\n  topMouseMove:   eventTypes.mouseMove,\n  topMouseOut:    eventTypes.mouseOut,\n  topMouseOver:   eventTypes.mouseOver,\n  topMouseUp:     eventTypes.mouseUp,\n  topPaste:       eventTypes.paste,\n  topReset:       eventTypes.reset,\n  topScroll:      eventTypes.scroll,\n  topSubmit:      eventTypes.submit,\n  topTouchCancel: eventTypes.touchCancel,\n  topTouchEnd:    eventTypes.touchEnd,\n  topTouchMove:   eventTypes.touchMove,\n  topTouchStart:  eventTypes.touchStart,\n  topWheel:       eventTypes.wheel\n};\n\nfor (var topLevelType in topLevelEventsToDispatchConfig) {\n  topLevelEventsToDispatchConfig[topLevelType].dependencies = [topLevelType];\n}\n\nvar SimpleEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * Same as the default implementation, except cancels the event when return\n   * value is false.\n   *\n   * @param {object} Event to be dispatched.\n   * @param {function} Application-level callback.\n   * @param {string} domID DOM ID to pass to the callback.\n   */\n  executeDispatch: function(event, listener, domID) {\n    var returnValue = EventPluginUtils.executeDispatch(event, listener, domID);\n    if (returnValue === false) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n  },\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var dispatchConfig = topLevelEventsToDispatchConfig[topLevelType];\n    if (!dispatchConfig) {\n      return null;\n    }\n    var EventConstructor;\n    switch (topLevelType) {\n      case topLevelTypes.topInput:\n      case topLevelTypes.topLoad:\n      case topLevelTypes.topError:\n      case topLevelTypes.topReset:\n      case topLevelTypes.topSubmit:\n        // HTML Events\n        // @see http://www.w3.org/TR/html5/index.html#events-0\n        EventConstructor = SyntheticEvent;\n        break;\n      case topLevelTypes.topKeyDown:\n      case topLevelTypes.topKeyPress:\n      case topLevelTypes.topKeyUp:\n        EventConstructor = SyntheticKeyboardEvent;\n        break;\n      case topLevelTypes.topBlur:\n      case topLevelTypes.topFocus:\n        EventConstructor = SyntheticFocusEvent;\n        break;\n      case topLevelTypes.topClick:\n        // Firefox creates a click event on right mouse clicks. This removes the\n        // unwanted click events.\n        if (nativeEvent.button === 2) {\n          return null;\n        }\n        /* falls through */\n      case topLevelTypes.topContextMenu:\n      case topLevelTypes.topDoubleClick:\n      case topLevelTypes.topMouseDown:\n      case topLevelTypes.topMouseMove:\n      case topLevelTypes.topMouseOut:\n      case topLevelTypes.topMouseOver:\n      case topLevelTypes.topMouseUp:\n        EventConstructor = SyntheticMouseEvent;\n        break;\n      case topLevelTypes.topDrag:\n      case topLevelTypes.topDragEnd:\n      case topLevelTypes.topDragEnter:\n      case topLevelTypes.topDragExit:\n      case topLevelTypes.topDragLeave:\n      case topLevelTypes.topDragOver:\n      case topLevelTypes.topDragStart:\n      case topLevelTypes.topDrop:\n        EventConstructor = SyntheticDragEvent;\n        break;\n      case topLevelTypes.topTouchCancel:\n      case topLevelTypes.topTouchEnd:\n      case topLevelTypes.topTouchMove:\n      case topLevelTypes.topTouchStart:\n        EventConstructor = SyntheticTouchEvent;\n        break;\n      case topLevelTypes.topScroll:\n        EventConstructor = SyntheticUIEvent;\n        break;\n      case topLevelTypes.topWheel:\n        EventConstructor = SyntheticWheelEvent;\n        break;\n      case topLevelTypes.topCopy:\n      case topLevelTypes.topCut:\n      case topLevelTypes.topPaste:\n        EventConstructor = SyntheticClipboardEvent;\n        break;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      EventConstructor,\n      &apos;SimpleEventPlugin: Unhandled event type, `%s`.&apos;,\n      topLevelType\n    ) : invariant(EventConstructor));\n    var event = EventConstructor.getPooled(\n      dispatchConfig,\n      topLevelTargetID,\n      nativeEvent\n    );\n    EventPropagators.accumulateTwoPhaseDispatches(event);\n    return event;\n  }\n\n};\n\nmodule.exports = SimpleEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginUtils&quot;:18,&quot;./EventPropagators&quot;:19,&quot;./SyntheticClipboardEvent&quot;:74,&quot;./SyntheticDragEvent&quot;:76,&quot;./SyntheticEvent&quot;:77,&quot;./SyntheticFocusEvent&quot;:78,&quot;./SyntheticKeyboardEvent&quot;:79,&quot;./SyntheticMouseEvent&quot;:80,&quot;./SyntheticTouchEvent&quot;:81,&quot;./SyntheticUIEvent&quot;:82,&quot;./SyntheticWheelEvent&quot;:83,&quot;./invariant&quot;:108,&quot;./keyOf&quot;:115}],74:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticClipboardEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/clipboard-apis/\n */\nvar ClipboardEventInterface = {\n  clipboardData: function(event) {\n    return (\n      &apos;clipboardData&apos; in event ?\n        event.clipboardData :\n        window.clipboardData\n    );\n  }\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticClipboardEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(SyntheticClipboardEvent, ClipboardEventInterface);\n\nmodule.exports = SyntheticClipboardEvent;\n\n\n},{&quot;./SyntheticEvent&quot;:77}],75:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticCompositionEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/DOM-Level-3-Events/#events-compositionevents\n */\nvar CompositionEventInterface = {\n  data: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticCompositionEvent(\n  dispatchConfig,\n  dispatchMarker,\n  nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(\n  SyntheticCompositionEvent,\n  CompositionEventInterface\n);\n\nmodule.exports = SyntheticCompositionEvent;\n\n\n},{&quot;./SyntheticEvent&quot;:77}],76:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticDragEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\n/**\n * @interface DragEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar DragEventInterface = {\n  dataTransfer: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticDragEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticMouseEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticMouseEvent.augmentClass(SyntheticDragEvent, DragEventInterface);\n\nmodule.exports = SyntheticDragEvent;\n\n},{&quot;./SyntheticMouseEvent&quot;:80}],77:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar getEventTarget = require(&quot;./getEventTarget&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mergeInto = require(&quot;./mergeInto&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar EventInterface = {\n  type: null,\n  target: getEventTarget,\n  // currentTarget is set when dispatching; no use in copying it here\n  currentTarget: emptyFunction.thatReturnsNull,\n  eventPhase: null,\n  bubbles: null,\n  cancelable: null,\n  timeStamp: function(event) {\n    return event.timeStamp || Date.now();\n  },\n  defaultPrevented: null,\n  isTrusted: null\n};\n\n/**\n * Synthetic events are dispatched by event plugins, typically in response to a\n * top-level event delegation handler.\n *\n * These systems should generally use pooling to reduce the frequency of garbage\n * collection. The system should check `isPersistent` to determine whether the\n * event should be released into the pool after being dispatched. Users that\n * need a persisted event should invoke `persist`.\n *\n * Synthetic events (and subclasses) implement the DOM Level 3 Events API by\n * normalizing browser quirks. Subclasses do not necessarily have to implement a\n * DOM interface; custom application-specific events can also subclass this.\n *\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n */\nfunction SyntheticEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  this.dispatchConfig = dispatchConfig;\n  this.dispatchMarker = dispatchMarker;\n  this.nativeEvent = nativeEvent;\n\n  var Interface = this.constructor.Interface;\n  for (var propName in Interface) {\n    if (!Interface.hasOwnProperty(propName)) {\n      continue;\n    }\n    var normalize = Interface[propName];\n    if (normalize) {\n      this[propName] = normalize(nativeEvent);\n    } else {\n      this[propName] = nativeEvent[propName];\n    }\n  }\n\n  var defaultPrevented = nativeEvent.defaultPrevented != null ?\n    nativeEvent.defaultPrevented :\n    nativeEvent.returnValue === false;\n  if (defaultPrevented) {\n    this.isDefaultPrevented = emptyFunction.thatReturnsTrue;\n  } else {\n    this.isDefaultPrevented = emptyFunction.thatReturnsFalse;\n  }\n  this.isPropagationStopped = emptyFunction.thatReturnsFalse;\n}\n\nmergeInto(SyntheticEvent.prototype, {\n\n  preventDefault: function() {\n    this.defaultPrevented = true;\n    var event = this.nativeEvent;\n    event.preventDefault ? event.preventDefault() : event.returnValue = false;\n    this.isDefaultPrevented = emptyFunction.thatReturnsTrue;\n  },\n\n  stopPropagation: function() {\n    var event = this.nativeEvent;\n    event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true;\n    this.isPropagationStopped = emptyFunction.thatReturnsTrue;\n  },\n\n  /**\n   * We release all dispatched `SyntheticEvent`s after each event loop, adding\n   * them back into the pool. This allows a way to hold onto a reference that\n   * won&apos;t be added back into the pool.\n   */\n  persist: function() {\n    this.isPersistent = emptyFunction.thatReturnsTrue;\n  },\n\n  /**\n   * Checks if this event should be released back into the pool.\n   *\n   * @return {boolean} True if this should not be released, false otherwise.\n   */\n  isPersistent: emptyFunction.thatReturnsFalse,\n\n  /**\n   * `PooledClass` looks for `destructor` on each instance it releases.\n   */\n  destructor: function() {\n    var Interface = this.constructor.Interface;\n    for (var propName in Interface) {\n      this[propName] = null;\n    }\n    this.dispatchConfig = null;\n    this.dispatchMarker = null;\n    this.nativeEvent = null;\n  }\n\n});\n\nSyntheticEvent.Interface = EventInterface;\n\n/**\n * Helper to reduce boilerplate when creating subclasses.\n *\n * @param {function} Class\n * @param {?object} Interface\n */\nSyntheticEvent.augmentClass = function(Class, Interface) {\n  var Super = this;\n\n  var prototype = Object.create(Super.prototype);\n  mergeInto(prototype, Class.prototype);\n  Class.prototype = prototype;\n  Class.prototype.constructor = Class;\n\n  Class.Interface = merge(Super.Interface, Interface);\n  Class.augmentClass = Super.augmentClass;\n\n  PooledClass.addPoolingTo(Class, PooledClass.threeArgumentPooler);\n};\n\nPooledClass.addPoolingTo(SyntheticEvent, PooledClass.threeArgumentPooler);\n\nmodule.exports = SyntheticEvent;\n\n},{&quot;./PooledClass&quot;:23,&quot;./emptyFunction&quot;:95,&quot;./getEventTarget&quot;:101,&quot;./merge&quot;:117,&quot;./mergeInto&quot;:119}],78:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticFocusEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\n/**\n * @interface FocusEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar FocusEventInterface = {\n  relatedTarget: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticFocusEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticFocusEvent, FocusEventInterface);\n\nmodule.exports = SyntheticFocusEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82}],79:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticKeyboardEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\nvar getEventKey = require(&quot;./getEventKey&quot;);\n\n/**\n * @interface KeyboardEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar KeyboardEventInterface = {\n  key: getEventKey,\n  location: null,\n  ctrlKey: null,\n  shiftKey: null,\n  altKey: null,\n  metaKey: null,\n  repeat: null,\n  locale: null,\n  // Legacy Interface\n  &apos;char&apos;: null,\n  charCode: null,\n  keyCode: null,\n  which: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticKeyboardEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticKeyboardEvent, KeyboardEventInterface);\n\nmodule.exports = SyntheticKeyboardEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82,&quot;./getEventKey&quot;:100}],80:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticMouseEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\nvar ViewportMetrics = require(&quot;./ViewportMetrics&quot;);\n\n/**\n * @interface MouseEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar MouseEventInterface = {\n  screenX: null,\n  screenY: null,\n  clientX: null,\n  clientY: null,\n  ctrlKey: null,\n  shiftKey: null,\n  altKey: null,\n  metaKey: null,\n  button: function(event) {\n    // Webkit, Firefox, IE9+\n    // which:  1 2 3\n    // button: 0 1 2 (standard)\n    var button = event.button;\n    if (&apos;which&apos; in event) {\n      return button;\n    }\n    // IE&lt;9\n    // which:  undefined\n    // button: 0 0 0\n    // button: 1 4 2 (onmouseup)\n    return button === 2 ? 2 : button === 4 ? 1 : 0;\n  },\n  buttons: null,\n  relatedTarget: function(event) {\n    return event.relatedTarget || (\n      event.fromElement === event.srcElement ?\n        event.toElement :\n        event.fromElement\n    );\n  },\n  // &quot;Proprietary&quot; Interface.\n  pageX: function(event) {\n    return &apos;pageX&apos; in event ?\n      event.pageX :\n      event.clientX + ViewportMetrics.currentScrollLeft;\n  },\n  pageY: function(event) {\n    return &apos;pageY&apos; in event ?\n      event.pageY :\n      event.clientY + ViewportMetrics.currentScrollTop;\n  }\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticMouseEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticMouseEvent, MouseEventInterface);\n\nmodule.exports = SyntheticMouseEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82,&quot;./ViewportMetrics&quot;:85}],81:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticTouchEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\n/**\n * @interface TouchEvent\n * @see http://www.w3.org/TR/touch-events/\n */\nvar TouchEventInterface = {\n  touches: null,\n  targetTouches: null,\n  changedTouches: null,\n  altKey: null,\n  metaKey: null,\n  ctrlKey: null,\n  shiftKey: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticTouchEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticTouchEvent, TouchEventInterface);\n\nmodule.exports = SyntheticTouchEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82}],82:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticUIEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface UIEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar UIEventInterface = {\n  view: null,\n  detail: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticEvent}\n */\nfunction SyntheticUIEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(SyntheticUIEvent, UIEventInterface);\n\nmodule.exports = SyntheticUIEvent;\n\n},{&quot;./SyntheticEvent&quot;:77}],83:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticWheelEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\n/**\n * @interface WheelEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar WheelEventInterface = {\n  deltaX: function(event) {\n    return (\n      &apos;deltaX&apos; in event ? event.deltaX :\n      // Fallback to `wheelDeltaX` for Webkit and normalize (right is positive).\n      &apos;wheelDeltaX&apos; in event ? -event.wheelDeltaX : 0\n    );\n  },\n  deltaY: function(event) {\n    return (\n      &apos;deltaY&apos; in event ? event.deltaY :\n      // Fallback to `wheelDeltaY` for Webkit and normalize (down is positive).\n      &apos;wheelDeltaY&apos; in event ? -event.wheelDeltaY :\n      // Fallback to `wheelDelta` for IE&lt;9 and normalize (down is positive).\n      &apos;wheelDelta&apos; in event ? -event.wheelDelta : 0\n    );\n  },\n  deltaZ: null,\n\n  // Browsers without &quot;deltaMode&quot; is reporting in raw wheel delta where one\n  // notch on the scroll is always +/- 120, roughly equivalent to pixels.\n  // A good approximation of DOM_DELTA_LINE (1) is 5% of viewport size or\n  // ~40 pixels, for DOM_DELTA_SCREEN (2) it is 87.5% of viewport size.\n  deltaMode: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticMouseEvent}\n */\nfunction SyntheticWheelEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticMouseEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticMouseEvent.augmentClass(SyntheticWheelEvent, WheelEventInterface);\n\nmodule.exports = SyntheticWheelEvent;\n\n},{&quot;./SyntheticMouseEvent&quot;:80}],84:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule Transaction\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * `Transaction` creates a black box that is able to wrap any method such that\n * certain invariants are maintained before and after the method is invoked\n * (Even if an exception is thrown while invoking the wrapped method). Whoever\n * instantiates a transaction can provide enforcers of the invariants at\n * creation time. The `Transaction` class itself will supply one additional\n * automatic invariant for you - the invariant that any transaction instance\n * should not be run while it is already being run. You would typically create a\n * single instance of a `Transaction` for reuse multiple times, that potentially\n * is used to wrap several different methods. Wrappers are extremely simple -\n * they only require implementing two methods.\n *\n * &lt;pre&gt;\n *                       wrappers (injected at creation time)\n *                                      +        +\n *                                      |        |\n *                    +-----------------|--------|--------------+\n *                    |                 v        |              |\n *                    |      +---------------+   |              |\n *                    |   +--|    wrapper1   |---|----+         |\n *                    |   |  +---------------+   v    |         |\n *                    |   |          +-------------+  |         |\n *                    |   |     +----|   wrapper2  |--------+   |\n *                    |   |     |    +-------------+  |     |   |\n *                    |   |     |                     |     |   |\n *                    |   v     v                     v     v   | wrapper\n *                    | +---+ +---+   +---------+   +---+ +---+ | invariants\n * perform(anyMethod) | |   | |   |   |         |   |   | |   | | maintained\n * +-----------------&gt;|-|---|-|---|--&gt;|anyMethod|---|---|-|---|-|--------&gt;\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | +---+ +---+   +---------+   +---+ +---+ |\n *                    |  initialize                    close    |\n *                    +-----------------------------------------+\n * &lt;/pre&gt;\n *\n * Bonus:\n * - Reports timing metrics by method name and wrapper index.\n *\n * Use cases:\n * - Preserving the input selection ranges before/after reconciliation.\n *   Restoring selection even in the event of an unexpected error.\n * - Deactivating events while rearranging the DOM, preventing blurs/focuses,\n *   while guaranteeing that afterwards, the event system is reactivated.\n * - Flushing a queue of collected DOM mutations to the main UI thread after a\n *   reconciliation takes place in a worker thread.\n * - Invoking any collected `componentDidUpdate` callbacks after rendering new\n *   content.\n * - (Future use case): Wrapping particular flushes of the `ReactWorker` queue\n *   to preserve the `scrollTop` (an automatic scroll aware DOM).\n * - (Future use case): Layout calculations before and after DOM upates.\n *\n * Transactional plugin API:\n * - A module that has an `initialize` method that returns any precomputation.\n * - and a `close` method that accepts the precomputation. `close` is invoked\n *   when the wrapped process is completed, or has failed.\n *\n * @param {Array&lt;TransactionalWrapper&gt;} transactionWrapper Wrapper modules\n * that implement `initialize` and `close`.\n * @return {Transaction} Single transaction for reuse in thread.\n *\n * @class Transaction\n */\nvar Mixin = {\n  /**\n   * Sets up this instance so that it is prepared for collecting metrics. Does\n   * so such that this setup method may be used on an instance that is already\n   * initialized, in a way that does not consume additional memory upon reuse.\n   * That can be useful if you decide to make your subclass of this mixin a\n   * &quot;PooledClass&quot;.\n   */\n  reinitializeTransaction: function() {\n    this.transactionWrappers = this.getTransactionWrappers();\n    if (!this.wrapperInitData) {\n      this.wrapperInitData = [];\n    } else {\n      this.wrapperInitData.length = 0;\n    }\n    if (!this.timingMetrics) {\n      this.timingMetrics = {};\n    }\n    this.timingMetrics.methodInvocationTime = 0;\n    if (!this.timingMetrics.wrapperInitTimes) {\n      this.timingMetrics.wrapperInitTimes = [];\n    } else {\n      this.timingMetrics.wrapperInitTimes.length = 0;\n    }\n    if (!this.timingMetrics.wrapperCloseTimes) {\n      this.timingMetrics.wrapperCloseTimes = [];\n    } else {\n      this.timingMetrics.wrapperCloseTimes.length = 0;\n    }\n    this._isInTransaction = false;\n  },\n\n  _isInTransaction: false,\n\n  /**\n   * @abstract\n   * @return {Array&lt;TransactionWrapper&gt;} Array of transaction wrappers.\n   */\n  getTransactionWrappers: null,\n\n  isInTransaction: function() {\n    return !!this._isInTransaction;\n  },\n\n  /**\n   * Executes the function within a safety window. Use this for the top level\n   * methods that result in large amounts of computation/mutations that would\n   * need to be safety checked.\n   *\n   * @param {function} method Member of scope to call.\n   * @param {Object} scope Scope to invoke from.\n   * @param {Object?=} args... Arguments to pass to the method (optional).\n   *                           Helps prevent need to bind in many cases.\n   * @return Return value from `method`.\n   */\n  perform: function(method, scope, a, b, c, d, e, f) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !this.isInTransaction(),\n      &apos;Transaction.perform(...): Cannot initialize a transaction when there &apos; +\n      &apos;is already an outstanding transaction.&apos;\n    ) : invariant(!this.isInTransaction()));\n    var memberStart = Date.now();\n    var errorThrown;\n    var ret;\n    try {\n      this._isInTransaction = true;\n      // Catching errors makes debugging more difficult, so we start with\n      // errorThrown set to true before setting it to false after calling\n      // close -- if it&apos;s still set to true in the finally block, it means\n      // one of these calls threw.\n      errorThrown = true;\n      this.initializeAll(0);\n      ret = method.call(scope, a, b, c, d, e, f);\n      errorThrown = false;\n    } finally {\n      var memberEnd = Date.now();\n      this.methodInvocationTime += (memberEnd - memberStart);\n      try {\n        if (errorThrown) {\n          // If `method` throws, prefer to show that stack trace over any thrown\n          // by invoking `closeAll`.\n          try {\n            this.closeAll(0);\n          } catch (err) {\n          }\n        } else {\n          // Since `method` didn&apos;t throw, we don&apos;t want to silence the exception\n          // here.\n          this.closeAll(0);\n        }\n      } finally {\n        this._isInTransaction = false;\n      }\n    }\n    return ret;\n  },\n\n  initializeAll: function(startIndex) {\n    var transactionWrappers = this.transactionWrappers;\n    var wrapperInitTimes = this.timingMetrics.wrapperInitTimes;\n    for (var i = startIndex; i &lt; transactionWrappers.length; i++) {\n      var initStart = Date.now();\n      var wrapper = transactionWrappers[i];\n      try {\n        // Catching errors makes debugging more difficult, so we start with the\n        // OBSERVED_ERROR state before overwriting it with the real return value\n        // of initialize -- if it&apos;s still set to OBSERVED_ERROR in the finally\n        // block, it means wrapper.initialize threw.\n        this.wrapperInitData[i] = Transaction.OBSERVED_ERROR;\n        this.wrapperInitData[i] = wrapper.initialize ?\n          wrapper.initialize.call(this) :\n          null;\n      } finally {\n        var curInitTime = wrapperInitTimes[i];\n        var initEnd = Date.now();\n        wrapperInitTimes[i] = (curInitTime || 0) + (initEnd - initStart);\n\n        if (this.wrapperInitData[i] === Transaction.OBSERVED_ERROR) {\n          // The initializer for wrapper i threw an error; initialize the\n          // remaining wrappers but silence any exceptions from them to ensure\n          // that the first error is the one to bubble up.\n          try {\n            this.initializeAll(i + 1);\n          } catch (err) {\n          }\n        }\n      }\n    }\n  },\n\n  /**\n   * Invokes each of `this.transactionWrappers.close[i]` functions, passing into\n   * them the respective return values of `this.transactionWrappers.init[i]`\n   * (`close`rs that correspond to initializers that failed will not be\n   * invoked).\n   */\n  closeAll: function(startIndex) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      this.isInTransaction(),\n      &apos;Transaction.closeAll(): Cannot close transaction when none are open.&apos;\n    ) : invariant(this.isInTransaction()));\n    var transactionWrappers = this.transactionWrappers;\n    var wrapperCloseTimes = this.timingMetrics.wrapperCloseTimes;\n    for (var i = startIndex; i &lt; transactionWrappers.length; i++) {\n      var wrapper = transactionWrappers[i];\n      var closeStart = Date.now();\n      var initData = this.wrapperInitData[i];\n      var errorThrown;\n      try {\n        // Catching errors makes debugging more difficult, so we start with\n        // errorThrown set to true before setting it to false after calling\n        // close -- if it&apos;s still set to true in the finally block, it means\n        // wrapper.close threw.\n        errorThrown = true;\n        if (initData !== Transaction.OBSERVED_ERROR) {\n          wrapper.close &amp;&amp; wrapper.close.call(this, initData);\n        }\n        errorThrown = false;\n      } finally {\n        var closeEnd = Date.now();\n        var curCloseTime = wrapperCloseTimes[i];\n        wrapperCloseTimes[i] = (curCloseTime || 0) + (closeEnd - closeStart);\n\n        if (errorThrown) {\n          // The closer for wrapper i threw an error; close the remaining\n          // wrappers but silence any exceptions from them to ensure that the\n          // first error is the one to bubble up.\n          try {\n            this.closeAll(i + 1);\n          } catch (e) {\n          }\n        }\n      }\n    }\n    this.wrapperInitData.length = 0;\n  }\n};\n\nvar Transaction = {\n\n  Mixin: Mixin,\n\n  /**\n   * Token to look for to determine if an error occured.\n   */\n  OBSERVED_ERROR: {}\n\n};\n\nmodule.exports = Transaction;\n\n},{&quot;./invariant&quot;:108}],85:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ViewportMetrics\n */\n\n&quot;use strict&quot;;\n\nvar getUnboundedScrollPosition = require(&quot;./getUnboundedScrollPosition&quot;);\n\nvar ViewportMetrics = {\n\n  currentScrollLeft: 0,\n\n  currentScrollTop: 0,\n\n  refreshScrollValues: function() {\n    var scrollPosition = getUnboundedScrollPosition(window);\n    ViewportMetrics.currentScrollLeft = scrollPosition.x;\n    ViewportMetrics.currentScrollTop = scrollPosition.y;\n  }\n\n};\n\nmodule.exports = ViewportMetrics;\n\n},{&quot;./getUnboundedScrollPosition&quot;:106}],86:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule accumulate\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Accumulates items that must not be null or undefined.\n *\n * This is used to conserve memory by avoiding array allocations.\n *\n * @return {*|array&lt;*&gt;} An accumulation of items.\n */\nfunction accumulate(current, next) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    next != null,\n    &apos;accumulate(...): Accumulated items must be not be null or undefined.&apos;\n  ) : invariant(next != null));\n  if (current == null) {\n    return next;\n  } else {\n    // Both are not empty. Warning: Never call x.concat(y) when you are not\n    // certain that x is an Array (x could be a string with concat method).\n    var currentIsArray = Array.isArray(current);\n    var nextIsArray = Array.isArray(next);\n    if (currentIsArray) {\n      return current.concat(next);\n    } else {\n      if (nextIsArray) {\n        return [current].concat(next);\n      } else {\n        return [current, next];\n      }\n    }\n  }\n}\n\nmodule.exports = accumulate;\n\n},{&quot;./invariant&quot;:108}],87:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule adler32\n */\n\n/* jslint bitwise:true */\n\n&quot;use strict&quot;;\n\nvar MOD = 65521;\n\n// This is a clean-room implementation of adler32 designed for detecting\n// if markup is not what we expect it to be. It does not need to be\n// cryptographically strong, only reasonable good at detecting if markup\n// generated on the server is different than that on the client.\nfunction adler32(data) {\n  var a = 1;\n  var b = 0;\n  for (var i = 0; i &lt; data.length; i++) {\n    a = (a + data.charCodeAt(i)) % MOD;\n    b = (b + a) % MOD;\n  }\n  return a | (b &lt;&lt; 16);\n}\n\nmodule.exports = adler32;\n\n},{}],88:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule containsNode\n * @typechecks\n */\n\nvar isTextNode = require(&quot;./isTextNode&quot;);\n\n/*jslint bitwise:true */\n\n/**\n * Checks if a given DOM node contains or is another DOM node.\n *\n * @param {?DOMNode} outerNode Outer DOM node.\n * @param {?DOMNode} innerNode Inner DOM node.\n * @return {boolean} True if `outerNode` contains or is `innerNode`.\n */\nfunction containsNode(outerNode, innerNode) {\n  if (!outerNode || !innerNode) {\n    return false;\n  } else if (outerNode === innerNode) {\n    return true;\n  } else if (isTextNode(outerNode)) {\n    return false;\n  } else if (isTextNode(innerNode)) {\n    return containsNode(outerNode, innerNode.parentNode);\n  } else if (outerNode.contains) {\n    return outerNode.contains(innerNode);\n  } else if (outerNode.compareDocumentPosition) {\n    return !!(outerNode.compareDocumentPosition(innerNode) &amp; 16);\n  } else {\n    return false;\n  }\n}\n\nmodule.exports = containsNode;\n\n},{&quot;./isTextNode&quot;:112}],89:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule copyProperties\n */\n\n/**\n * Copy properties from one or more objects (up to 5) into the first object.\n * This is a shallow copy. It mutates the first object and also returns it.\n *\n * NOTE: `arguments` has a very significant performance penalty, which is why\n * we don&apos;t support unlimited arguments.\n */\nfunction copyProperties(obj, a, b, c, d, e, f) {\n  obj = obj || {};\n\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (f) {\n      throw new Error(&apos;Too many arguments passed to copyProperties&apos;);\n    }\n  }\n\n  var args = [a, b, c, d, e];\n  var ii = 0, v;\n  while (args[ii]) {\n    v = args[ii++];\n    for (var k in v) {\n      obj[k] = v[k];\n    }\n\n    // IE ignores toString in object iteration.. See:\n    // webreflection.blogspot.com/2007/07/quick-fix-internet-explorer-and.html\n    if (v.hasOwnProperty &amp;&amp; v.hasOwnProperty(&apos;toString&apos;) &amp;&amp;\n        (typeof v.toString != &apos;undefined&apos;) &amp;&amp; (obj.toString !== v.toString)) {\n      obj.toString = v.toString;\n    }\n  }\n\n  return obj;\n}\n\nmodule.exports = copyProperties;\n\n},{}],90:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createArrayFrom\n * @typechecks\n */\n\nvar toArray = require(&quot;./toArray&quot;);\n\n/**\n * Perform a heuristic test to determine if an object is &quot;array-like&quot;.\n *\n *   A monk asked Joshu, a Zen master, &quot;Has a dog Buddha nature?&quot;\n *   Joshu replied: &quot;Mu.&quot;\n *\n * This function determines if its argument has &quot;array nature&quot;: it returns\n * true if the argument is an actual array, an `arguments&apos; object, or an\n * HTMLCollection (e.g. node.childNodes or node.getElementsByTagName()).\n *\n * It will return false for other array-like objects like Filelist.\n *\n * @param {*} obj\n * @return {boolean}\n */\nfunction hasArrayNature(obj) {\n  return (\n    // not null/false\n    !!obj &amp;&amp;\n    // arrays are objects, NodeLists are functions in Safari\n    (typeof obj == &apos;object&apos; || typeof obj == &apos;function&apos;) &amp;&amp;\n    // quacks like an array\n    (&apos;length&apos; in obj) &amp;&amp;\n    // not window\n    !(&apos;setInterval&apos; in obj) &amp;&amp;\n    // no DOM node should be considered an array-like\n    // a &apos;select&apos; element has &apos;length&apos; and &apos;item&apos; properties on IE8\n    (typeof obj.nodeType != &apos;number&apos;) &amp;&amp;\n    (\n      // a real array\n      (// HTMLCollection/NodeList\n      (Array.isArray(obj) ||\n      // arguments\n      (&apos;callee&apos; in obj) || &apos;item&apos; in obj))\n    )\n  );\n}\n\n/**\n * Ensure that the argument is an array by wrapping it in an array if it is not.\n * Creates a copy of the argument if it is already an array.\n *\n * This is mostly useful idiomatically:\n *\n *   var createArrayFrom = require(&apos;createArrayFrom&apos;);\n *\n *   function takesOneOrMoreThings(things) {\n *     things = createArrayFrom(things);\n *     ...\n *   }\n *\n * This allows you to treat `things&apos; as an array, but accept scalars in the API.\n *\n * If you need to convert an array-like object, like `arguments`, into an array\n * use toArray instead.\n *\n * @param {*} obj\n * @return {array}\n */\nfunction createArrayFrom(obj) {\n  if (!hasArrayNature(obj)) {\n    return [obj];\n  } else if (Array.isArray(obj)) {\n    return obj.slice();\n  } else {\n    return toArray(obj);\n  }\n}\n\nmodule.exports = createArrayFrom;\n\n},{&quot;./toArray&quot;:127}],91:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createFullPageComponent\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n// Defeat circular references by requiring this directly.\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Create a component that will throw an exception when unmounted.\n *\n * Components like &lt;html&gt; &lt;head&gt; and &lt;body&gt; can&apos;t be removed or added\n * easily in a cross-browser way, however it&apos;s valuable to be able to\n * take advantage of React&apos;s reconciliation for styling and &lt;title&gt;\n * management. So we just document it and throw in dangerous cases.\n *\n * @param {function} componentClass convenience constructor to wrap\n * @return {function} convenience constructor of new component\n */\nfunction createFullPageComponent(componentClass) {\n  var FullPageComponent = ReactCompositeComponent.createClass({\n    displayName: &apos;ReactFullPageComponent&apos; + (\n      componentClass.componentConstructor.displayName || &apos;&apos;\n    ),\n\n    componentWillUnmount: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        false,\n        &apos;%s tried to unmount. Because of cross-browser quirks it is &apos; +\n        &apos;impossible to unmount some top-level components (eg &lt;html&gt;, &lt;head&gt;, &apos; +\n        &apos;and &lt;body&gt;) reliably and efficiently. To fix this, have a single &apos; +\n        &apos;top-level component that never unmounts render these elements.&apos;,\n        this.constructor.displayName\n      ) : invariant(false));\n    },\n\n    render: function() {\n      return this.transferPropsTo(componentClass(null, this.props.children));\n    }\n  });\n\n  return FullPageComponent;\n}\n\nmodule.exports = createFullPageComponent;\n\n},{&quot;./ReactCompositeComponent&quot;:29,&quot;./invariant&quot;:108}],92:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createNodesFromMarkup\n * @typechecks\n */\n\n/*jslint evil: true, sub: true */\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar createArrayFrom = require(&quot;./createArrayFrom&quot;);\nvar getMarkupWrap = require(&quot;./getMarkupWrap&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Dummy container used to render all markup.\n */\nvar dummyNode =\n  ExecutionEnvironment.canUseDOM ? document.createElement(&apos;div&apos;) : null;\n\n/**\n * Pattern used by `getNodeName`.\n */\nvar nodeNamePattern = /^\\s*&lt;(\\w+)/;\n\n/**\n * Extracts the `nodeName` of the first element in a string of markup.\n *\n * @param {string} markup String of markup.\n * @return {?string} Node name of the supplied markup.\n */\nfunction getNodeName(markup) {\n  var nodeNameMatch = markup.match(nodeNamePattern);\n  return nodeNameMatch &amp;&amp; nodeNameMatch[1].toLowerCase();\n}\n\n/**\n * Creates an array containing the nodes rendered from the supplied markup. The\n * optionally supplied `handleScript` function will be invoked once for each\n * &lt;script&gt; element that is rendered. If no `handleScript` function is supplied,\n * an exception is thrown if any &lt;script&gt; elements are rendered.\n *\n * @param {string} markup A string of valid HTML markup.\n * @param {?function} handleScript Invoked once for each rendered &lt;script&gt;.\n * @return {array&lt;DOMElement|DOMTextNode&gt;} An array of rendered nodes.\n */\nfunction createNodesFromMarkup(markup, handleScript) {\n  var node = dummyNode;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(!!dummyNode, &apos;createNodesFromMarkup dummy not initialized&apos;) : invariant(!!dummyNode));\n  var nodeName = getNodeName(markup);\n\n  var wrap = nodeName &amp;&amp; getMarkupWrap(nodeName);\n  if (wrap) {\n    node.innerHTML = wrap[1] + markup + wrap[2];\n\n    var wrapDepth = wrap[0];\n    while (wrapDepth--) {\n      node = node.lastChild;\n    }\n  } else {\n    node.innerHTML = markup;\n  }\n\n  var scripts = node.getElementsByTagName(&apos;script&apos;);\n  if (scripts.length) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      handleScript,\n      &apos;createNodesFromMarkup(...): Unexpected &lt;script&gt; element rendered.&apos;\n    ) : invariant(handleScript));\n    createArrayFrom(scripts).forEach(handleScript);\n  }\n\n  var nodes = createArrayFrom(node.childNodes);\n  while (node.lastChild) {\n    node.removeChild(node.lastChild);\n  }\n  return nodes;\n}\n\nmodule.exports = createNodesFromMarkup;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./createArrayFrom&quot;:90,&quot;./getMarkupWrap&quot;:102,&quot;./invariant&quot;:108}],93:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createObjectFrom\n */\n\n/**\n * Construct an object from an array of keys\n * and optionally specified value or list of values.\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;]);\n *  {a: true, b: true, c: true}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], false);\n *  {a: false, b: false, c: false}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], &apos;monkey&apos;);\n *  {c:&apos;monkey&apos;, b:&apos;monkey&apos; c:&apos;monkey&apos;}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], [1,2,3]);\n *  {a: 1, b: 2, c: 3}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;women&apos;, &apos;men&apos;], [true, false]);\n *  {women: true, men: false}\n *\n * @param   Array   list of keys\n * @param   mixed   optional value or value array.  defaults true.\n * @returns object\n */\nfunction createObjectFrom(keys, values /* = true */) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (!Array.isArray(keys)) {\n      throw new TypeError(&apos;Must pass an array of keys.&apos;);\n    }\n  }\n\n  var object = {};\n  var isArray = Array.isArray(values);\n  if (typeof values == &apos;undefined&apos;) {\n    values = true;\n  }\n\n  for (var ii = keys.length; ii--;) {\n    object[keys[ii]] = isArray ? values[ii] : values;\n  }\n  return object;\n}\n\nmodule.exports = createObjectFrom;\n\n},{}],94:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule dangerousStyleValue\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSProperty = require(&quot;./CSSProperty&quot;);\n\n/**\n * Convert a value into the proper css writable value. The `styleName` name\n * name should be logical (no hyphens), as specified\n * in `CSSProperty.isUnitlessNumber`.\n *\n * @param {string} styleName CSS property name such as `topMargin`.\n * @param {*} value CSS property value such as `10px`.\n * @return {string} Normalized style value with dimensions applied.\n */\nfunction dangerousStyleValue(styleName, value) {\n  // Note that we&apos;ve removed escapeTextForBrowser() calls here since the\n  // whole string will be escaped when the attribute is injected into\n  // the markup. If you provide unsafe user data here they can inject\n  // arbitrary CSS which may be problematic (I couldn&apos;t repro this):\n  // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet\n  // http://www.thespanner.co.uk/2007/11/26/ultimate-xss-css-injection/\n  // This is not an XSS hole but instead a potential CSS injection issue\n  // which has lead to a greater discussion about how we&apos;re going to\n  // trust URLs moving forward. See #2115901\n\n  var isEmpty = value == null || typeof value === &apos;boolean&apos; || value === &apos;&apos;;\n  if (isEmpty) {\n    return &apos;&apos;;\n  }\n\n  var isNonNumeric = isNaN(value);\n  if (isNonNumeric || value === 0 || CSSProperty.isUnitlessNumber[styleName]) {\n    return &apos;&apos; + value; // cast to string\n  }\n\n  return value + &apos;px&apos;;\n}\n\nmodule.exports = dangerousStyleValue;\n\n},{&quot;./CSSProperty&quot;:2}],95:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule emptyFunction\n */\n\nvar copyProperties = require(&quot;./copyProperties&quot;);\n\nfunction makeEmptyFunction(arg) {\n  return function() {\n    return arg;\n  };\n}\n\n/**\n * This function accepts and discards inputs; it has no side effects. This is\n * primarily useful idiomatically for overridable function endpoints which\n * always need to be callable, since JS lacks a null-call idiom ala Cocoa.\n */\nfunction emptyFunction() {}\n\ncopyProperties(emptyFunction, {\n  thatReturns: makeEmptyFunction,\n  thatReturnsFalse: makeEmptyFunction(false),\n  thatReturnsTrue: makeEmptyFunction(true),\n  thatReturnsNull: makeEmptyFunction(null),\n  thatReturnsThis: function() { return this; },\n  thatReturnsArgument: function(arg) { return arg; }\n});\n\nmodule.exports = emptyFunction;\n\n},{&quot;./copyProperties&quot;:89}],96:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule escapeTextForBrowser\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ESCAPE_LOOKUP = {\n  &quot;&amp;&quot;: &quot;&amp;amp;&quot;,\n  &quot;&gt;&quot;: &quot;&amp;gt;&quot;,\n  &quot;&lt;&quot;: &quot;&amp;lt;&quot;,\n  &quot;\\&quot;&quot;: &quot;&amp;quot;&quot;,\n  &quot;&apos;&quot;: &quot;&amp;#x27;&quot;,\n  &quot;/&quot;: &quot;&amp;#x2f;&quot;\n};\n\nvar ESCAPE_REGEX = /[&amp;&gt;&lt;&quot;&apos;\\/]/g;\n\nfunction escaper(match) {\n  return ESCAPE_LOOKUP[match];\n}\n\n/**\n * Escapes text to prevent scripting attacks.\n *\n * @param {*} text Text value to escape.\n * @return {string} An escaped string.\n */\nfunction escapeTextForBrowser(text) {\n  return (&apos;&apos; + text).replace(ESCAPE_REGEX, escaper);\n}\n\nmodule.exports = escapeTextForBrowser;\n\n},{}],97:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule flattenChildren\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\nvar traverseAllChildren = require(&quot;./traverseAllChildren&quot;);\n\n/**\n * @param {function} traverseContext Context passed through traversal.\n * @param {?ReactComponent} child React child component.\n * @param {!string} name String name of key path to child.\n */\nfunction flattenSingleChildIntoContext(traverseContext, child, name) {\n  // We found a component instance.\n  var result = traverseContext;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !result.hasOwnProperty(name),\n    &apos;flattenChildren(...): Encountered two children with the same key, `%s`. &apos; +\n    &apos;Children keys must be unique.&apos;,\n    name\n  ) : invariant(!result.hasOwnProperty(name)));\n  if (child != null) {\n    result[name] = child;\n  }\n}\n\n/**\n * Flattens children that are typically specified as `props.children`. Any null\n * children will not be included in the resulting object.\n * @return {!object} flattened children keyed by name.\n */\nfunction flattenChildren(children) {\n  if (children == null) {\n    return children;\n  }\n  var result = {};\n  traverseAllChildren(children, flattenSingleChildIntoContext, result);\n  return result;\n}\n\nmodule.exports = flattenChildren;\n\n},{&quot;./invariant&quot;:108,&quot;./traverseAllChildren&quot;:128}],98:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule forEachAccumulated\n */\n\n&quot;use strict&quot;;\n\n/**\n * @param {array} an &quot;accumulation&quot; of items which is either an Array or\n * a single item. Useful when paired with the `accumulate` module. This is a\n * simple utility that allows us to reason about a collection of items, but\n * handling the case when there is exactly one item (and we do not need to\n * allocate an array).\n */\nvar forEachAccumulated = function(arr, cb, scope) {\n  if (Array.isArray(arr)) {\n    arr.forEach(cb, scope);\n  } else if (arr) {\n    cb.call(scope, arr);\n  }\n};\n\nmodule.exports = forEachAccumulated;\n\n},{}],99:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getActiveElement\n * @typechecks\n */\n\n/**\n * Same as document.activeElement but wraps in a try-catch block. In IE it is\n * not safe to call document.activeElement if there is nothing focused.\n *\n * The activeElement will be null only if the document body is not yet defined.\n */\nfunction getActiveElement() /*?DOMElement*/ {\n  try {\n    return document.activeElement || document.body;\n  } catch (e) {\n    return document.body;\n  }\n}\n\nmodule.exports = getActiveElement;\n\n},{}],100:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getEventKey\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Normalization of deprecated HTML5 &quot;key&quot; values\n * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names\n */\nvar normalizeKey = {\n  &apos;Esc&apos;: &apos;Escape&apos;,\n  &apos;Spacebar&apos;: &apos; &apos;,\n  &apos;Left&apos;: &apos;ArrowLeft&apos;,\n  &apos;Up&apos;: &apos;ArrowUp&apos;,\n  &apos;Right&apos;: &apos;ArrowRight&apos;,\n  &apos;Down&apos;: &apos;ArrowDown&apos;,\n  &apos;Del&apos;: &apos;Delete&apos;,\n  &apos;Win&apos;: &apos;OS&apos;,\n  &apos;Menu&apos;: &apos;ContextMenu&apos;,\n  &apos;Apps&apos;: &apos;ContextMenu&apos;,\n  &apos;Scroll&apos;: &apos;ScrollLock&apos;,\n  &apos;MozPrintableKey&apos;: &apos;Unidentified&apos;\n};\n\n/**\n * Translation from legacy &quot;which/keyCode&quot; to HTML5 &quot;key&quot;\n * Only special keys supported, all others depend on keyboard layout or browser\n * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names\n */\nvar translateToKey = {\n  8: &apos;Backspace&apos;,\n  9: &apos;Tab&apos;,\n  12: &apos;Clear&apos;,\n  13: &apos;Enter&apos;,\n  16: &apos;Shift&apos;,\n  17: &apos;Control&apos;,\n  18: &apos;Alt&apos;,\n  19: &apos;Pause&apos;,\n  20: &apos;CapsLock&apos;,\n  27: &apos;Escape&apos;,\n  32: &apos; &apos;,\n  33: &apos;PageUp&apos;,\n  34: &apos;PageDown&apos;,\n  35: &apos;End&apos;,\n  36: &apos;Home&apos;,\n  37: &apos;ArrowLeft&apos;,\n  38: &apos;ArrowUp&apos;,\n  39: &apos;ArrowRight&apos;,\n  40: &apos;ArrowDown&apos;,\n  45: &apos;Insert&apos;,\n  46: &apos;Delete&apos;,\n  112: &apos;F1&apos;, 113: &apos;F2&apos;, 114: &apos;F3&apos;, 115: &apos;F4&apos;, 116: &apos;F5&apos;, 117: &apos;F6&apos;,\n  118: &apos;F7&apos;, 119: &apos;F8&apos;, 120: &apos;F9&apos;, 121: &apos;F10&apos;, 122: &apos;F11&apos;, 123: &apos;F12&apos;,\n  144: &apos;NumLock&apos;,\n  145: &apos;ScrollLock&apos;,\n  224: &apos;Meta&apos;\n};\n\n/**\n * @param {object} nativeEvent Native browser event.\n * @return {string} Normalized `key` property.\n */\nfunction getEventKey(nativeEvent) {\n  return &apos;key&apos; in nativeEvent ?\n    normalizeKey[nativeEvent.key] || nativeEvent.key :\n    translateToKey[nativeEvent.which || nativeEvent.keyCode] || &apos;Unidentified&apos;;\n}\n\nmodule.exports = getEventKey;\n\n},{}],101:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getEventTarget\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Gets the target node from a native browser event by accounting for\n * inconsistencies in browser DOM APIs.\n *\n * @param {object} nativeEvent Native browser event.\n * @return {DOMEventTarget} Target node.\n */\nfunction getEventTarget(nativeEvent) {\n  var target = nativeEvent.target || nativeEvent.srcElement || window;\n  // Safari may fire events on text nodes (Node.TEXT_NODE is 3).\n  // @see http://www.quirksmode.org/js/events_properties.html\n  return target.nodeType === 3 ? target.parentNode : target;\n}\n\nmodule.exports = getEventTarget;\n\n},{}],102:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getMarkupWrap\n */\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Dummy container used to detect which wraps are necessary.\n */\nvar dummyNode =\n  ExecutionEnvironment.canUseDOM ? document.createElement(&apos;div&apos;) : null;\n\n/**\n * Some browsers cannot use `innerHTML` to render certain elements standalone,\n * so we wrap them, render the wrapped nodes, then extract the desired node.\n *\n * In IE8, certain elements cannot render alone, so wrap all elements (&apos;*&apos;).\n */\nvar shouldWrap = {\n  // Force wrapping for SVG elements because if they get created inside a &lt;div&gt;,\n  // they will be initialized in the wrong namespace (and will not display).\n  &apos;circle&apos;: true,\n  &apos;defs&apos;: true,\n  &apos;g&apos;: true,\n  &apos;line&apos;: true,\n  &apos;linearGradient&apos;: true,\n  &apos;path&apos;: true,\n  &apos;polygon&apos;: true,\n  &apos;polyline&apos;: true,\n  &apos;radialGradient&apos;: true,\n  &apos;rect&apos;: true,\n  &apos;stop&apos;: true,\n  &apos;text&apos;: true\n};\n\nvar selectWrap = [1, &apos;&lt;select multiple=&quot;true&quot;&gt;&apos;, &apos;&lt;/select&gt;&apos;];\nvar tableWrap = [1, &apos;&lt;table&gt;&apos;, &apos;&lt;/table&gt;&apos;];\nvar trWrap = [3, &apos;&lt;table&gt;&lt;tbody&gt;&lt;tr&gt;&apos;, &apos;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&apos;];\n\nvar svgWrap = [1, &apos;&lt;svg&gt;&apos;, &apos;&lt;/svg&gt;&apos;];\n\nvar markupWrap = {\n  &apos;*&apos;: [1, &apos;?&lt;div&gt;&apos;, &apos;&lt;/div&gt;&apos;],\n\n  &apos;area&apos;: [1, &apos;&lt;map&gt;&apos;, &apos;&lt;/map&gt;&apos;],\n  &apos;col&apos;: [2, &apos;&lt;table&gt;&lt;tbody&gt;&lt;/tbody&gt;&lt;colgroup&gt;&apos;, &apos;&lt;/colgroup&gt;&lt;/table&gt;&apos;],\n  &apos;legend&apos;: [1, &apos;&lt;fieldset&gt;&apos;, &apos;&lt;/fieldset&gt;&apos;],\n  &apos;param&apos;: [1, &apos;&lt;object&gt;&apos;, &apos;&lt;/object&gt;&apos;],\n  &apos;tr&apos;: [2, &apos;&lt;table&gt;&lt;tbody&gt;&apos;, &apos;&lt;/tbody&gt;&lt;/table&gt;&apos;],\n\n  &apos;optgroup&apos;: selectWrap,\n  &apos;option&apos;: selectWrap,\n\n  &apos;caption&apos;: tableWrap,\n  &apos;colgroup&apos;: tableWrap,\n  &apos;tbody&apos;: tableWrap,\n  &apos;tfoot&apos;: tableWrap,\n  &apos;thead&apos;: tableWrap,\n\n  &apos;td&apos;: trWrap,\n  &apos;th&apos;: trWrap,\n\n  &apos;circle&apos;: svgWrap,\n  &apos;defs&apos;: svgWrap,\n  &apos;g&apos;: svgWrap,\n  &apos;line&apos;: svgWrap,\n  &apos;linearGradient&apos;: svgWrap,\n  &apos;path&apos;: svgWrap,\n  &apos;polygon&apos;: svgWrap,\n  &apos;polyline&apos;: svgWrap,\n  &apos;radialGradient&apos;: svgWrap,\n  &apos;rect&apos;: svgWrap,\n  &apos;stop&apos;: svgWrap,\n  &apos;text&apos;: svgWrap\n};\n\n/**\n * Gets the markup wrap configuration for the supplied `nodeName`.\n *\n * NOTE: This lazily detects which wraps are necessary for the current browser.\n *\n * @param {string} nodeName Lowercase `nodeName`.\n * @return {?array} Markup wrap configuration, if applicable.\n */\nfunction getMarkupWrap(nodeName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(!!dummyNode, &apos;Markup wrapping node not initialized&apos;) : invariant(!!dummyNode));\n  if (!markupWrap.hasOwnProperty(nodeName)) {\n    nodeName = &apos;*&apos;;\n  }\n  if (!shouldWrap.hasOwnProperty(nodeName)) {\n    if (nodeName === &apos;*&apos;) {\n      dummyNode.innerHTML = &apos;&lt;link /&gt;&apos;;\n    } else {\n      dummyNode.innerHTML = &apos;&lt;&apos; + nodeName + &apos;&gt;&lt;/&apos; + nodeName + &apos;&gt;&apos;;\n    }\n    shouldWrap[nodeName] = !dummyNode.firstChild;\n  }\n  return shouldWrap[nodeName] ? markupWrap[nodeName] : null;\n}\n\n\nmodule.exports = getMarkupWrap;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./invariant&quot;:108}],103:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getNodeForCharacterOffset\n */\n\n&quot;use strict&quot;;\n\n/**\n * Given any node return the first leaf node without children.\n *\n * @param {DOMElement|DOMTextNode} node\n * @return {DOMElement|DOMTextNode}\n */\nfunction getLeafNode(node) {\n  while (node &amp;&amp; node.firstChild) {\n    node = node.firstChild;\n  }\n  return node;\n}\n\n/**\n * Get the next sibling within a container. This will walk up the\n * DOM if a node&apos;s siblings have been exhausted.\n *\n * @param {DOMElement|DOMTextNode} node\n * @return {?DOMElement|DOMTextNode}\n */\nfunction getSiblingNode(node) {\n  while (node) {\n    if (node.nextSibling) {\n      return node.nextSibling;\n    }\n    node = node.parentNode;\n  }\n}\n\n/**\n * Get object describing the nodes which contain characters at offset.\n *\n * @param {DOMElement|DOMTextNode} root\n * @param {number} offset\n * @return {?object}\n */\nfunction getNodeForCharacterOffset(root, offset) {\n  var node = getLeafNode(root);\n  var nodeStart = 0;\n  var nodeEnd = 0;\n\n  while (node) {\n    if (node.nodeType == 3) {\n      nodeEnd = nodeStart + node.textContent.length;\n\n      if (nodeStart &lt;= offset &amp;&amp; nodeEnd &gt;= offset) {\n        return {\n          node: node,\n          offset: offset - nodeStart\n        };\n      }\n\n      nodeStart = nodeEnd;\n    }\n\n    node = getLeafNode(getSiblingNode(node));\n  }\n}\n\nmodule.exports = getNodeForCharacterOffset;\n\n},{}],104:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getReactRootElementInContainer\n */\n\n&quot;use strict&quot;;\n\nvar DOC_NODE_TYPE = 9;\n\n/**\n * @param {DOMElement|DOMDocument} container DOM element that may contain\n *                                           a React component\n * @return {?*} DOM element that may have the reactRoot ID, or null.\n */\nfunction getReactRootElementInContainer(container) {\n  if (!container) {\n    return null;\n  }\n\n  if (container.nodeType === DOC_NODE_TYPE) {\n    return container.documentElement;\n  } else {\n    return container.firstChild;\n  }\n}\n\nmodule.exports = getReactRootElementInContainer;\n\n},{}],105:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getTextContentAccessor\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar contentKey = null;\n\n/**\n * Gets the key used to access text content on a DOM node.\n *\n * @return {?string} Key used to access text content.\n * @internal\n */\nfunction getTextContentAccessor() {\n  if (!contentKey &amp;&amp; ExecutionEnvironment.canUseDOM) {\n    // Prefer textContent to innerText because many browsers support both but\n    // SVG &lt;text&gt; elements don&apos;t support innerText even when &lt;div&gt; does.\n    contentKey = &apos;textContent&apos; in document.createElement(&apos;div&apos;) ?\n      &apos;textContent&apos; :\n      &apos;innerText&apos;;\n  }\n  return contentKey;\n}\n\nmodule.exports = getTextContentAccessor;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],106:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getUnboundedScrollPosition\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n/**\n * Gets the scroll position of the supplied element or window.\n *\n * The return values are unbounded, unlike `getScrollPosition`. This means they\n * may be negative or exceed the element boundaries (which is possible using\n * inertial scrolling).\n *\n * @param {DOMWindow|DOMElement} scrollable\n * @return {object} Map with `x` and `y` keys.\n */\nfunction getUnboundedScrollPosition(scrollable) {\n  if (scrollable === window) {\n    return {\n      x: window.pageXOffset || document.documentElement.scrollLeft,\n      y: window.pageYOffset || document.documentElement.scrollTop\n    };\n  }\n  return {\n    x: scrollable.scrollLeft,\n    y: scrollable.scrollTop\n  };\n}\n\nmodule.exports = getUnboundedScrollPosition;\n\n},{}],107:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule hyphenate\n * @typechecks\n */\n\nvar _uppercasePattern = /([A-Z])/g;\n\n/**\n * Hyphenates a camelcased string, for example:\n *\n *   &gt; hyphenate(&apos;backgroundColor&apos;)\n *   &lt; &quot;background-color&quot;\n *\n * @param {string} string\n * @return {string}\n */\nfunction hyphenate(string) {\n  return string.replace(_uppercasePattern, &apos;-$1&apos;).toLowerCase();\n}\n\nmodule.exports = hyphenate;\n\n},{}],108:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule invariant\n */\n\n&quot;use strict&quot;;\n\n/**\n * Use invariant() to assert state which your program assumes to be true.\n *\n * Provide sprintf-style format (only %s is supported) and arguments\n * to provide information about what broke and what you were\n * expecting.\n *\n * The invariant message will be stripped in production, but the invariant\n * will remain to ensure logic does not differ in production.\n */\n\nvar invariant = function(condition) {\n  if (!condition) {\n    var error = new Error(\n      &apos;Minified exception occured; use the non-minified dev environment for &apos; +\n      &apos;the full error message and additional helpful warnings.&apos;\n    );\n    error.framesToPop = 1;\n    throw error;\n  }\n};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  invariant = function(condition, format, a, b, c, d, e, f) {\n    if (format === undefined) {\n      throw new Error(&apos;invariant requires an error message argument&apos;);\n    }\n\n    if (!condition) {\n      var args = [a, b, c, d, e, f];\n      var argIndex = 0;\n      var error = new Error(\n        &apos;Invariant Violation: &apos; +\n        format.replace(/%s/g, function() { return args[argIndex++]; })\n      );\n      error.framesToPop = 1; // we don&apos;t care about invariant&apos;s own frame\n      throw error;\n    }\n  };\n}\n\nmodule.exports = invariant;\n\n},{}],109:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isEventSupported\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar useHasFeature;\nif (ExecutionEnvironment.canUseDOM) {\n  useHasFeature =\n    document.implementation &amp;&amp;\n    document.implementation.hasFeature &amp;&amp;\n    // always returns true in newer browsers as per the standard.\n    // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature\n    document.implementation.hasFeature(&apos;&apos;, &apos;&apos;) !== true;\n}\n\n/**\n * Checks if an event is supported in the current execution environment.\n *\n * NOTE: This will not work correctly for non-generic events such as `change`,\n * `reset`, `load`, `error`, and `select`.\n *\n * Borrows from Modernizr.\n *\n * @param {string} eventNameSuffix Event name, e.g. &quot;click&quot;.\n * @param {?boolean} capture Check if the capture phase is supported.\n * @return {boolean} True if the event is supported.\n * @internal\n * @license Modernizr 3.0.0pre (Custom Build) | MIT\n */\nfunction isEventSupported(eventNameSuffix, capture) {\n  if (!ExecutionEnvironment.canUseDOM ||\n      capture &amp;&amp; !(&apos;addEventListener&apos; in document)) {\n    return false;\n  }\n\n  var eventName = &apos;on&apos; + eventNameSuffix;\n  var isSupported = eventName in document;\n\n  if (!isSupported) {\n    var element = document.createElement(&apos;div&apos;);\n    element.setAttribute(eventName, &apos;return;&apos;);\n    isSupported = typeof element[eventName] === &apos;function&apos;;\n  }\n\n  if (!isSupported &amp;&amp; useHasFeature &amp;&amp; eventNameSuffix === &apos;wheel&apos;) {\n    // This is the only way to test support for the `wheel` event in IE9+.\n    isSupported = document.implementation.hasFeature(&apos;Events.wheel&apos;, &apos;3.0&apos;);\n  }\n\n  return isSupported;\n}\n\nmodule.exports = isEventSupported;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],110:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isNode\n * @typechecks\n */\n\n/**\n * @param {*} object The object to check.\n * @return {boolean} Whether or not the object is a DOM node.\n */\nfunction isNode(object) {\n  return !!(object &amp;&amp; (\n    typeof Node !== &apos;undefined&apos; ? object instanceof Node :\n      typeof object === &apos;object&apos; &amp;&amp;\n      typeof object.nodeType === &apos;number&apos; &amp;&amp;\n      typeof object.nodeName === &apos;string&apos;\n  ));\n}\n\nmodule.exports = isNode;\n\n},{}],111:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isTextInputElement\n */\n\n&quot;use strict&quot;;\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-input-element.html#input-type-attr-summary\n */\nvar supportedInputTypes = {\n  &apos;color&apos;: true,\n  &apos;date&apos;: true,\n  &apos;datetime&apos;: true,\n  &apos;datetime-local&apos;: true,\n  &apos;email&apos;: true,\n  &apos;month&apos;: true,\n  &apos;number&apos;: true,\n  &apos;password&apos;: true,\n  &apos;range&apos;: true,\n  &apos;search&apos;: true,\n  &apos;tel&apos;: true,\n  &apos;text&apos;: true,\n  &apos;time&apos;: true,\n  &apos;url&apos;: true,\n  &apos;week&apos;: true\n};\n\nfunction isTextInputElement(elem) {\n  return elem &amp;&amp; (\n    (elem.nodeName === &apos;INPUT&apos; &amp;&amp; supportedInputTypes[elem.type]) ||\n    elem.nodeName === &apos;TEXTAREA&apos;\n  );\n}\n\nmodule.exports = isTextInputElement;\n\n},{}],112:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isTextNode\n * @typechecks\n */\n\nvar isNode = require(&quot;./isNode&quot;);\n\n/**\n * @param {*} object The object to check.\n * @return {boolean} Whether or not the object is a DOM text node.\n */\nfunction isTextNode(object) {\n  return isNode(object) &amp;&amp; object.nodeType == 3;\n}\n\nmodule.exports = isTextNode;\n\n},{&quot;./isNode&quot;:110}],113:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule joinClasses\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Combines multiple className strings into one.\n * http://jsperf.com/joinclasses-args-vs-array\n *\n * @param {...?string} classes\n * @return {string}\n */\nfunction joinClasses(className/*, ... */) {\n  if (!className) {\n    className = &apos;&apos;;\n  }\n  var nextClass;\n  var argLength = arguments.length;\n  if (argLength &gt; 1) {\n    for (var ii = 1; ii &lt; argLength; ii++) {\n      nextClass = arguments[ii];\n      nextClass &amp;&amp; (className += &apos; &apos; + nextClass);\n    }\n  }\n  return className;\n}\n\nmodule.exports = joinClasses;\n\n},{}],114:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule keyMirror\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Constructs an enumeration with keys equal to their value.\n *\n * For example:\n *\n *   var COLORS = keyMirror({blue: null, red: null});\n *   var myColor = COLORS.blue;\n *   var isColorValid = !!COLORS[myColor];\n *\n * The last line could not be performed if the values of the generated enum were\n * not equal to their keys.\n *\n *   Input:  {key1: val1, key2: val2}\n *   Output: {key1: key1, key2: key2}\n *\n * @param {object} obj\n * @return {object}\n */\nvar keyMirror = function(obj) {\n  var ret = {};\n  var key;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    obj instanceof Object &amp;&amp; !Array.isArray(obj),\n    &apos;keyMirror(...): Argument must be an object.&apos;\n  ) : invariant(obj instanceof Object &amp;&amp; !Array.isArray(obj)));\n  for (key in obj) {\n    if (!obj.hasOwnProperty(key)) {\n      continue;\n    }\n    ret[key] = key;\n  }\n  return ret;\n};\n\nmodule.exports = keyMirror;\n\n},{&quot;./invariant&quot;:108}],115:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule keyOf\n */\n\n/**\n * Allows extraction of a minified key. Let&apos;s the build system minify keys\n * without loosing the ability to dynamically use key strings as values\n * themselves. Pass in an object with a single key/val pair and it will return\n * you the string key of that single record. Suppose you want to grab the\n * value for a key &apos;className&apos; inside of an object. Key/val minification may\n * have aliased that key to be &apos;xa12&apos;. keyOf({className: null}) will return\n * &apos;xa12&apos; in that case. Resolve keys you want to use once at startup time, then\n * reuse those resolutions.\n */\nvar keyOf = function(oneKeyObj) {\n  var key;\n  for (key in oneKeyObj) {\n    if (!oneKeyObj.hasOwnProperty(key)) {\n      continue;\n    }\n    return key;\n  }\n  return null;\n};\n\n\nmodule.exports = keyOf;\n\n},{}],116:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule memoizeStringOnly\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Memoizes the return value of a function that accepts one string argument.\n *\n * @param {function} callback\n * @return {function}\n */\nfunction memoizeStringOnly(callback) {\n  var cache = {};\n  return function(string) {\n    if (cache.hasOwnProperty(string)) {\n      return cache[string];\n    } else {\n      return cache[string] = callback.call(this, string);\n    }\n  };\n}\n\nmodule.exports = memoizeStringOnly;\n\n},{}],117:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule merge\n */\n\n&quot;use strict&quot;;\n\nvar mergeInto = require(&quot;./mergeInto&quot;);\n\n/**\n * Shallow merges two structures into a return value, without mutating either.\n *\n * @param {?object} one Optional object with properties to merge from.\n * @param {?object} two Optional object with properties to merge from.\n * @return {object} The shallow extension of one by two.\n */\nvar merge = function(one, two) {\n  var result = {};\n  mergeInto(result, one);\n  mergeInto(result, two);\n  return result;\n};\n\nmodule.exports = merge;\n\n},{&quot;./mergeInto&quot;:119}],118:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mergeHelpers\n *\n * requiresPolyfills: Array.isArray\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n/**\n * Maximum number of levels to traverse. Will catch circular structures.\n * @const\n */\nvar MAX_MERGE_DEPTH = 36;\n\n/**\n * We won&apos;t worry about edge cases like new String(&apos;x&apos;) or new Boolean(true).\n * Functions are considered terminals, and arrays are not.\n * @param {*} o The item/object/value to test.\n * @return {boolean} true iff the argument is a terminal.\n */\nvar isTerminal = function(o) {\n  return typeof o !== &apos;object&apos; || o === null;\n};\n\nvar mergeHelpers = {\n\n  MAX_MERGE_DEPTH: MAX_MERGE_DEPTH,\n\n  isTerminal: isTerminal,\n\n  /**\n   * Converts null/undefined values into empty object.\n   *\n   * @param {?Object=} arg Argument to be normalized (nullable optional)\n   * @return {!Object}\n   */\n  normalizeMergeArg: function(arg) {\n    return arg === undefined || arg === null ? {} : arg;\n  },\n\n  /**\n   * If merging Arrays, a merge strategy *must* be supplied. If not, it is\n   * likely the caller&apos;s fault. If this function is ever called with anything\n   * but `one` and `two` being `Array`s, it is the fault of the merge utilities.\n   *\n   * @param {*} one Array to merge into.\n   * @param {*} two Array to merge from.\n   */\n  checkMergeArrayArgs: function(one, two) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Array.isArray(one) &amp;&amp; Array.isArray(two),\n      &apos;Tried to merge arrays, instead got %s and %s.&apos;,\n      one,\n      two\n    ) : invariant(Array.isArray(one) &amp;&amp; Array.isArray(two)));\n  },\n\n  /**\n   * @param {*} one Object to merge into.\n   * @param {*} two Object to merge from.\n   */\n  checkMergeObjectArgs: function(one, two) {\n    mergeHelpers.checkMergeObjectArg(one);\n    mergeHelpers.checkMergeObjectArg(two);\n  },\n\n  /**\n   * @param {*} arg\n   */\n  checkMergeObjectArg: function(arg) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !isTerminal(arg) &amp;&amp; !Array.isArray(arg),\n      &apos;Tried to merge an object, instead got %s.&apos;,\n      arg\n    ) : invariant(!isTerminal(arg) &amp;&amp; !Array.isArray(arg)));\n  },\n\n  /**\n   * Checks that a merge was not given a circular object or an object that had\n   * too great of depth.\n   *\n   * @param {number} Level of recursion to validate against maximum.\n   */\n  checkMergeLevel: function(level) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      level &lt; MAX_MERGE_DEPTH,\n      &apos;Maximum deep merge depth exceeded. You may be attempting to merge &apos; +\n      &apos;circular structures in an unsupported way.&apos;\n    ) : invariant(level &lt; MAX_MERGE_DEPTH));\n  },\n\n  /**\n   * Checks that the supplied merge strategy is valid.\n   *\n   * @param {string} Array merge strategy.\n   */\n  checkArrayStrategy: function(strategy) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      strategy === undefined || strategy in mergeHelpers.ArrayStrategies,\n      &apos;You must provide an array strategy to deep merge functions to &apos; +\n      &apos;instruct the deep merge how to resolve merging two arrays.&apos;\n    ) : invariant(strategy === undefined || strategy in mergeHelpers.ArrayStrategies));\n  },\n\n  /**\n   * Set of possible behaviors of merge algorithms when encountering two Arrays\n   * that must be merged together.\n   * - `clobber`: The left `Array` is ignored.\n   * - `indexByIndex`: The result is achieved by recursively deep merging at\n   *   each index. (not yet supported.)\n   */\n  ArrayStrategies: keyMirror({\n    Clobber: true,\n    IndexByIndex: true\n  })\n\n};\n\nmodule.exports = mergeHelpers;\n\n},{&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114}],119:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mergeInto\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar mergeHelpers = require(&quot;./mergeHelpers&quot;);\n\nvar checkMergeObjectArg = mergeHelpers.checkMergeObjectArg;\n\n/**\n * Shallow merges two structures by mutating the first parameter.\n *\n * @param {object} one Object to be merged into.\n * @param {?object} two Optional object with properties to merge from.\n */\nfunction mergeInto(one, two) {\n  checkMergeObjectArg(one);\n  if (two != null) {\n    checkMergeObjectArg(two);\n    for (var key in two) {\n      if (!two.hasOwnProperty(key)) {\n        continue;\n      }\n      one[key] = two[key];\n    }\n  }\n}\n\nmodule.exports = mergeInto;\n\n},{&quot;./mergeHelpers&quot;:118}],120:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mixInto\n */\n\n&quot;use strict&quot;;\n\n/**\n * Simply copies properties to the prototype.\n */\nvar mixInto = function(constructor, methodBag) {\n  var methodName;\n  for (methodName in methodBag) {\n    if (!methodBag.hasOwnProperty(methodName)) {\n      continue;\n    }\n    constructor.prototype[methodName] = methodBag[methodName];\n  }\n};\n\nmodule.exports = mixInto;\n\n},{}],121:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule objMap\n */\n\n&quot;use strict&quot;;\n\n/**\n * For each key/value pair, invokes callback func and constructs a resulting\n * object which contains, for every key in obj, values that are the result of\n * of invoking the function:\n *\n *   func(value, key, iteration)\n *\n * @param {?object} obj Object to map keys over\n * @param {function} func Invoked for each key/val pair.\n * @param {?*} context\n * @return {?object} Result of mapping or null if obj is falsey\n */\nfunction objMap(obj, func, context) {\n  if (!obj) {\n    return null;\n  }\n  var i = 0;\n  var ret = {};\n  for (var key in obj) {\n    if (obj.hasOwnProperty(key)) {\n      ret[key] = func.call(context, obj[key], key, i++);\n    }\n  }\n  return ret;\n}\n\nmodule.exports = objMap;\n\n},{}],122:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule objMapKeyVal\n */\n\n&quot;use strict&quot;;\n\n/**\n * Behaves the same as `objMap` but invokes func with the key first, and value\n * second. Use `objMap` unless you need this special case.\n * Invokes func as:\n *\n *   func(key, value, iteration)\n *\n * @param {?object} obj Object to map keys over\n * @param {!function} func Invoked for each key/val pair.\n * @param {?*} context\n * @return {?object} Result of mapping or null if obj is falsey\n */\nfunction objMapKeyVal(obj, func, context) {\n  if (!obj) {\n    return null;\n  }\n  var i = 0;\n  var ret = {};\n  for (var key in obj) {\n    if (obj.hasOwnProperty(key)) {\n      ret[key] = func.call(context, key, obj[key], i++);\n    }\n  }\n  return ret;\n}\n\nmodule.exports = objMapKeyVal;\n\n},{}],123:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule onlyChild\n */\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Returns the first child in a collection of children and verifies that there\n * is only one child in the collection. The current implementation of this\n * function assumes that a single child gets passed without a wrapper, but the\n * purpose of this helper function is to abstract away the particular structure\n * of children.\n *\n * @param {?object} children Child collection structure.\n * @return {ReactComponent} The first and only `ReactComponent` contained in the\n * structure.\n */\nfunction onlyChild(children) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    ReactComponent.isValidComponent(children),\n    &apos;onlyChild must be passed a children with exactly one child.&apos;\n  ) : invariant(ReactComponent.isValidComponent(children)));\n  return children;\n}\n\nmodule.exports = onlyChild;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./invariant&quot;:108}],124:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule performanceNow\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\n/**\n * Detect if we can use window.performance.now() and gracefully\n * fallback to Date.now() if it doesn&apos;t exist.\n * We need to support Firefox &lt; 15 for now due to Facebook&apos;s webdriver\n * infrastructure.\n */\nvar performance = null;\n\nif (ExecutionEnvironment.canUseDOM) {\n  performance = window.performance || window.webkitPerformance;\n}\n\nif (!performance || !performance.now) {\n  performance = Date;\n}\n\nvar performanceNow = performance.now.bind(performance);\n\nmodule.exports = performanceNow;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],125:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule shallowEqual\n */\n\n&quot;use strict&quot;;\n\n/**\n * Performs equality by iterating through keys on an object and returning\n * false when any key has values which are not strictly equal between\n * objA and objB. Returns true when the values of all keys are strictly equal.\n *\n * @return {boolean}\n */\nfunction shallowEqual(objA, objB) {\n  if (objA === objB) {\n    return true;\n  }\n  var key;\n  // Test for A&apos;s keys different from B.\n  for (key in objA) {\n    if (objA.hasOwnProperty(key) &amp;&amp;\n        (!objB.hasOwnProperty(key) || objA[key] !== objB[key])) {\n      return false;\n    }\n  }\n  // Test for B&apos;a keys missing from A.\n  for (key in objB) {\n    if (objB.hasOwnProperty(key) &amp;&amp; !objA.hasOwnProperty(key)) {\n      return false;\n    }\n  }\n  return true;\n}\n\nmodule.exports = shallowEqual;\n\n},{}],126:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule shouldUpdateReactComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Given a `prevComponent` and `nextComponent`, determines if `prevComponent`\n * should be updated as opposed to being destroyed or replaced.\n *\n * @param {?object} prevComponent\n * @param {?object} nextComponent\n * @return {boolean} True if `prevComponent` should be updated.\n * @protected\n */\nfunction shouldUpdateReactComponent(prevComponent, nextComponent) {\n  // TODO: Remove warning after a release.\n  if (prevComponent &amp;&amp; nextComponent &amp;&amp;\n      prevComponent.constructor === nextComponent.constructor &amp;&amp; (\n        (prevComponent.props &amp;&amp; prevComponent.props.key) ===\n        (nextComponent.props &amp;&amp; nextComponent.props.key)\n      )) {\n    if (prevComponent._owner === nextComponent._owner) {\n      return true;\n    } else {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        if (prevComponent.state) {\n          console.warn(\n            &apos;A recent change to React has been found to impact your code. &apos; +\n            &apos;A mounted component will now be unmounted and replaced by a &apos; +\n            &apos;component (of the same class) if their owners are different. &apos; +\n            &apos;Previously, ownership was not considered when updating.&apos;,\n            prevComponent,\n            nextComponent\n          );\n        }\n      }\n    }\n  }\n  return false;\n}\n\nmodule.exports = shouldUpdateReactComponent;\n\n},{}],127:[function(require,module,exports){\n/**\n * Copyright 2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule toArray\n * @typechecks\n */\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Convert array-like objects to arrays.\n *\n * This API assumes the caller knows the contents of the data type. For less\n * well defined inputs use createArrayFrom.\n *\n * @param {object|function} obj\n * @return {array}\n */\nfunction toArray(obj) {\n  var length = obj.length;\n\n  // Some browse builtin objects can report typeof &apos;function&apos; (e.g. NodeList in\n  // old versions of Safari).\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !Array.isArray(obj) &amp;&amp;\n    (typeof obj === &apos;object&apos; || typeof obj === &apos;function&apos;),\n    &apos;toArray: Array-like object expected&apos;\n  ) : invariant(!Array.isArray(obj) &amp;&amp;\n  (typeof obj === &apos;object&apos; || typeof obj === &apos;function&apos;)));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    typeof length === &apos;number&apos;,\n    &apos;toArray: Object needs a length property&apos;\n  ) : invariant(typeof length === &apos;number&apos;));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    length === 0 ||\n    (length - 1) in obj,\n    &apos;toArray: Object should have keys for indices&apos;\n  ) : invariant(length === 0 ||\n  (length - 1) in obj));\n\n  // Old IE doesn&apos;t give collections access to hasOwnProperty. Assume inputs\n  // without method will throw during the slice call and skip straight to the\n  // fallback.\n  if (obj.hasOwnProperty) {\n    try {\n      return Array.prototype.slice.call(obj);\n    } catch (e) {\n      // IE &lt; 9 does not support Array#slice on collections objects\n    }\n  }\n\n  // Fall back to copying key by key. This assumes all keys have a value,\n  // so will not preserve sparsely populated inputs.\n  var ret = Array(length);\n  for (var ii = 0; ii &lt; length; ii++) {\n    ret[ii] = obj[ii];\n  }\n  return ret;\n}\n\nmodule.exports = toArray;\n\n},{&quot;./invariant&quot;:108}],128:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule traverseAllChildren\n */\n\n&quot;use strict&quot;;\n\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactTextComponent = require(&quot;./ReactTextComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar SEPARATOR = ReactInstanceHandles.SEPARATOR;\nvar SUBSEPARATOR = &apos;:&apos;;\n\n/**\n * TODO: Test that:\n * 1. `mapChildren` transforms strings and numbers into `ReactTextComponent`.\n * 2. it(&apos;should fail when supplied duplicate key&apos;, function() {\n * 3. That a single child and an array with one item have the same key pattern.\n * });\n */\n\nvar userProvidedKeyEscaperLookup = {\n  &apos;=&apos;: &apos;=0&apos;,\n  &apos;.&apos;: &apos;=1&apos;,\n  &apos;:&apos;: &apos;=2&apos;\n};\n\nvar userProvidedKeyEscapeRegex = /[=.:]/g;\n\nfunction userProvidedKeyEscaper(match) {\n  return userProvidedKeyEscaperLookup[match];\n}\n\n/**\n * Generate a key string that identifies a component within a set.\n *\n * @param {*} component A component that could contain a manual key.\n * @param {number} index Index that is used if a manual key is not provided.\n * @return {string}\n */\nfunction getComponentKey(component, index) {\n  if (component &amp;&amp; component.props &amp;&amp; component.props.key != null) {\n    // Explicit key\n    return wrapUserProvidedKey(component.props.key);\n  }\n  // Implicit key determined by the index in the set\n  return index.toString(36);\n}\n\n/**\n * Escape a component key so that it is safe to use in a reactid.\n *\n * @param {*} key Component key to be escaped.\n * @return {string} An escaped string.\n */\nfunction escapeUserProvidedKey(text) {\n  return (&apos;&apos; + text).replace(\n    userProvidedKeyEscapeRegex,\n    userProvidedKeyEscaper\n  );\n}\n\n/**\n * Wrap a `key` value explicitly provided by the user to distinguish it from\n * implicitly-generated keys generated by a component&apos;s index in its parent.\n *\n * @param {string} key Value of a user-provided `key` attribute\n * @return {string}\n */\nfunction wrapUserProvidedKey(key) {\n  return &apos;$&apos; + escapeUserProvidedKey(key);\n}\n\n/**\n * @param {?*} children Children tree container.\n * @param {!string} nameSoFar Name of the key path so far.\n * @param {!number} indexSoFar Number of children encountered until this point.\n * @param {!function} callback Callback to invoke with each child found.\n * @param {?*} traverseContext Used to pass information throughout the traversal\n * process.\n * @return {!number} The number of children in this subtree.\n */\nvar traverseAllChildrenImpl =\n  function(children, nameSoFar, indexSoFar, callback, traverseContext) {\n    var subtreeCount = 0;  // Count of children found in the current subtree.\n    if (Array.isArray(children)) {\n      for (var i = 0; i &lt; children.length; i++) {\n        var child = children[i];\n        var nextName = (\n          nameSoFar +\n          (nameSoFar ? SUBSEPARATOR : SEPARATOR) +\n          getComponentKey(child, i)\n        );\n        var nextIndex = indexSoFar + subtreeCount;\n        subtreeCount += traverseAllChildrenImpl(\n          child,\n          nextName,\n          nextIndex,\n          callback,\n          traverseContext\n        );\n      }\n    } else {\n      var type = typeof children;\n      var isOnlyChild = nameSoFar === &apos;&apos;;\n      // If it&apos;s the only child, treat the name as if it was wrapped in an array\n      // so that it&apos;s consistent if the number of children grows\n      var storageName =\n        isOnlyChild ? SEPARATOR + getComponentKey(children, 0) : nameSoFar;\n      if (children == null || type === &apos;boolean&apos;) {\n        // All of the above are perceived as null.\n        callback(traverseContext, null, storageName, indexSoFar);\n        subtreeCount = 1;\n      } else if (children.mountComponentIntoNode) {\n        callback(traverseContext, children, storageName, indexSoFar);\n        subtreeCount = 1;\n      } else {\n        if (type === &apos;object&apos;) {\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            !children || children.nodeType !== 1,\n            &apos;traverseAllChildren(...): Encountered an invalid child; DOM &apos; +\n            &apos;elements are not valid children of React components.&apos;\n          ) : invariant(!children || children.nodeType !== 1));\n          for (var key in children) {\n            if (children.hasOwnProperty(key)) {\n              subtreeCount += traverseAllChildrenImpl(\n                children[key],\n                (\n                  nameSoFar + (nameSoFar ? SUBSEPARATOR : SEPARATOR) +\n                  wrapUserProvidedKey(key) + SUBSEPARATOR +\n                  getComponentKey(children[key], 0)\n                ),\n                indexSoFar + subtreeCount,\n                callback,\n                traverseContext\n              );\n            }\n          }\n        } else if (type === &apos;string&apos;) {\n          var normalizedText = new ReactTextComponent(children);\n          callback(traverseContext, normalizedText, storageName, indexSoFar);\n          subtreeCount += 1;\n        } else if (type === &apos;number&apos;) {\n          var normalizedNumber = new ReactTextComponent(&apos;&apos; + children);\n          callback(traverseContext, normalizedNumber, storageName, indexSoFar);\n          subtreeCount += 1;\n        }\n      }\n    }\n    return subtreeCount;\n  };\n\n/**\n * Traverses children that are typically specified as `props.children`, but\n * might also be specified through attributes:\n *\n * - `traverseAllChildren(this.props.children, ...)`\n * - `traverseAllChildren(this.props.leftPanelChildren, ...)`\n *\n * The `traverseContext` is an optional argument that is passed through the\n * entire traversal. It can be used to store accumulations or anything else that\n * the callback might find relevant.\n *\n * @param {?*} children Children tree object.\n * @param {!function} callback To invoke upon traversing each child.\n * @param {?*} traverseContext Context for traversal.\n */\nfunction traverseAllChildren(children, callback, traverseContext) {\n  if (children !== null &amp;&amp; children !== undefined) {\n    traverseAllChildrenImpl(children, &apos;&apos;, 0, callback, traverseContext);\n  }\n}\n\nmodule.exports = traverseAllChildren;\n\n},{&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactTextComponent&quot;:69,&quot;./invariant&quot;:108}],129:[function(require,module,exports){\n/**\n * Copyright 2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule warning\n */\n\n&quot;use strict&quot;;\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\n/**\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar warning = emptyFunction;\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  warning = function(condition, format ) {var args=Array.prototype.slice.call(arguments,2);\n    if (format === undefined) {\n      throw new Error(\n        &apos;`warning(condition, format, ...args)` requires a warning &apos; +\n        &apos;message argument&apos;\n      );\n    }\n\n    if (!condition) {\n      var argIndex = 0;\n      console.warn(&apos;Warning: &apos; + format.replace(/%s/g, function()  {return args[argIndex++];}));\n    }\n  };\n}\n\nmodule.exports = warning;\n\n},{&quot;./emptyFunction&quot;:95}]},{},[24])\n(24)\n});if(typeof Math.imul == &quot;undefined&quot; || (Math.imul(0xffffffff,5) == 0)) {\n    Math.imul = function (a, b) {\n        var ah  = (a &gt;&gt;&gt; 16) &amp; 0xffff;\n        var al = a &amp; 0xffff;\n        var bh  = (b &gt;&gt;&gt; 16) &amp; 0xffff;\n        var bl = b &amp; 0xffff;\n        // the shift by 0 fixes the sign on the high part\n        // the final |0 converts the unsigned value into a signed value\n        return ((al * bl) + (((ah * bl + al * bh) &lt;&lt; 16) &gt;&gt;&gt; 0)|0);\n    }\n}\n\nvar CLOSURE_NO_DEPS = true;\nvar COMPILED = false;\nvar goog = goog || {};\ngoog.global = this;\ngoog.global.CLOSURE_UNCOMPILED_DEFINES;\ngoog.global.CLOSURE_DEFINES;\ngoog.isDef = function(val) {\n  return val !== void 0;\n};\ngoog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {\n  var parts = name.split(&quot;.&quot;);\n  var cur = opt_objectToExportTo || goog.global;\n  if (!(parts[0] in cur) &amp;&amp; cur.execScript) {\n    cur.execScript(&quot;var &quot; + parts[0]);\n  }\n  for (var part;parts.length &amp;&amp; (part = parts.shift());) {\n    if (!parts.length &amp;&amp; goog.isDef(opt_object)) {\n      cur[part] = opt_object;\n    } else {\n      if (cur[part]) {\n        cur = cur[part];\n      } else {\n        cur = cur[part] = {};\n      }\n    }\n  }\n};\ngoog.define = function(name, defaultValue) {\n  var value = defaultValue;\n  if (!COMPILED) {\n    if (goog.global.CLOSURE_UNCOMPILED_DEFINES &amp;&amp; Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {\n      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];\n    } else {\n      if (goog.global.CLOSURE_DEFINES &amp;&amp; Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {\n        value = goog.global.CLOSURE_DEFINES[name];\n      }\n    }\n  }\n  goog.exportPath_(name, value);\n};\ngoog.DEBUG = true;\ngoog.define(&quot;goog.LOCALE&quot;, &quot;en&quot;);\ngoog.define(&quot;goog.TRUSTED_SITE&quot;, true);\ngoog.define(&quot;goog.STRICT_MODE_COMPATIBLE&quot;, false);\ngoog.provide = function(name) {\n  if (!COMPILED) {\n    if (goog.isProvided_(name)) {\n      throw Error(&apos;Namespace &quot;&apos; + name + &apos;&quot; already declared.&apos;);\n    }\n    delete goog.implicitNamespaces_[name];\n    var namespace = name;\n    while (namespace = namespace.substring(0, namespace.lastIndexOf(&quot;.&quot;))) {\n      if (goog.getObjectByName(namespace)) {\n        break;\n      }\n      goog.implicitNamespaces_[namespace] = true;\n    }\n  }\n  goog.exportPath_(name);\n};\ngoog.setTestOnly = function(opt_message) {\n  if (COMPILED &amp;&amp; !goog.DEBUG) {\n    opt_message = opt_message || &quot;&quot;;\n    throw Error(&quot;Importing test-only code into non-debug environment&quot; + (opt_message ? &quot;: &quot; + opt_message : &quot;.&quot;));\n  }\n};\ngoog.forwardDeclare = function(name) {\n};\nif (!COMPILED) {\n  goog.isProvided_ = function(name) {\n    return!goog.implicitNamespaces_[name] &amp;&amp; goog.isDefAndNotNull(goog.getObjectByName(name));\n  };\n  goog.implicitNamespaces_ = {};\n}\ngoog.getObjectByName = function(name, opt_obj) {\n  var parts = name.split(&quot;.&quot;);\n  var cur = opt_obj || goog.global;\n  for (var part;part = parts.shift();) {\n    if (goog.isDefAndNotNull(cur[part])) {\n      cur = cur[part];\n    } else {\n      return null;\n    }\n  }\n  return cur;\n};\ngoog.globalize = function(obj, opt_global) {\n  var global = opt_global || goog.global;\n  for (var x in obj) {\n    global[x] = obj[x];\n  }\n};\ngoog.addDependency = function(relPath, provides, requires) {\n  if (goog.DEPENDENCIES_ENABLED) {\n    var provide, require;\n    var path = relPath.replace(/\\\\/g, &quot;/&quot;);\n    var deps = goog.dependencies_;\n    for (var i = 0;provide = provides[i];i++) {\n      deps.nameToPath[provide] = path;\n      if (!(path in deps.pathToNames)) {\n        deps.pathToNames[path] = {};\n      }\n      deps.pathToNames[path][provide] = true;\n    }\n    for (var j = 0;require = requires[j];j++) {\n      if (!(path in deps.requires)) {\n        deps.requires[path] = {};\n      }\n      deps.requires[path][require] = true;\n    }\n  }\n};\ngoog.define(&quot;goog.ENABLE_DEBUG_LOADER&quot;, true);\ngoog.require = function(name) {\n  if (!COMPILED) {\n    if (goog.isProvided_(name)) {\n      return;\n    }\n    if (goog.ENABLE_DEBUG_LOADER) {\n      var path = goog.getPathFromDeps_(name);\n      if (path) {\n        goog.included_[path] = true;\n        goog.writeScripts_();\n        return;\n      }\n    }\n    var errorMessage = &quot;goog.require could not find: &quot; + name;\n    if (goog.global.console) {\n      goog.global.console[&quot;error&quot;](errorMessage);\n    }\n    throw Error(errorMessage);\n  }\n};\ngoog.basePath = &quot;&quot;;\ngoog.global.CLOSURE_BASE_PATH;\ngoog.global.CLOSURE_NO_DEPS;\ngoog.global.CLOSURE_IMPORT_SCRIPT;\ngoog.nullFunction = function() {\n};\ngoog.identityFunction = function(opt_returnValue, var_args) {\n  return opt_returnValue;\n};\ngoog.abstractMethod = function() {\n  throw Error(&quot;unimplemented abstract method&quot;);\n};\ngoog.addSingletonGetter = function(ctor) {\n  ctor.getInstance = function() {\n    if (ctor.instance_) {\n      return ctor.instance_;\n    }\n    if (goog.DEBUG) {\n      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;\n    }\n    return ctor.instance_ = new ctor;\n  };\n};\ngoog.instantiatedSingletons_ = [];\ngoog.DEPENDENCIES_ENABLED = !COMPILED &amp;&amp; goog.ENABLE_DEBUG_LOADER;\nif (goog.DEPENDENCIES_ENABLED) {\n  goog.included_ = {};\n  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};\n  goog.inHtmlDocument_ = function() {\n    var doc = goog.global.document;\n    return typeof doc != &quot;undefined&quot; &amp;&amp; &quot;write&quot; in doc;\n  };\n  goog.findBasePath_ = function() {\n    if (goog.global.CLOSURE_BASE_PATH) {\n      goog.basePath = goog.global.CLOSURE_BASE_PATH;\n      return;\n    } else {\n      if (!goog.inHtmlDocument_()) {\n        return;\n      }\n    }\n    var doc = goog.global.document;\n    var scripts = doc.getElementsByTagName(&quot;script&quot;);\n    for (var i = scripts.length - 1;i &gt;= 0;--i) {\n      var src = scripts[i].src;\n      var qmark = src.lastIndexOf(&quot;?&quot;);\n      var l = qmark == -1 ? src.length : qmark;\n      if (src.substr(l - 7, 7) == &quot;base.js&quot;) {\n        goog.basePath = src.substr(0, l - 7);\n        return;\n      }\n    }\n  };\n  goog.importScript_ = function(src) {\n    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;\n    if (!goog.dependencies_.written[src] &amp;&amp; importScript(src)) {\n      goog.dependencies_.written[src] = true;\n    }\n  };\n  goog.writeScriptTag_ = function(src) {\n    if (goog.inHtmlDocument_()) {\n      var doc = goog.global.document;\n      if (doc.readyState == &quot;complete&quot;) {\n        var isDeps = /\\bdeps.js$/.test(src);\n        if (isDeps) {\n          return false;\n        } else {\n          throw Error(&apos;Cannot write &quot;&apos; + src + &apos;&quot; after document load&apos;);\n        }\n      }\n      doc.write(&apos;\\x3cscript type\\x3d&quot;text/javascript&quot; src\\x3d&quot;&apos; + src + &apos;&quot;\\x3e\\x3c/&apos; + &quot;script\\x3e&quot;);\n      return true;\n    } else {\n      return false;\n    }\n  };\n  goog.writeScripts_ = function() {\n    var scripts = [];\n    var seenScript = {};\n    var deps = goog.dependencies_;\n    function visitNode(path) {\n      if (path in deps.written) {\n        return;\n      }\n      if (path in deps.visited) {\n        if (!(path in seenScript)) {\n          seenScript[path] = true;\n          scripts.push(path);\n        }\n        return;\n      }\n      deps.visited[path] = true;\n      if (path in deps.requires) {\n        for (var requireName in deps.requires[path]) {\n          if (!goog.isProvided_(requireName)) {\n            if (requireName in deps.nameToPath) {\n              visitNode(deps.nameToPath[requireName]);\n            } else {\n              throw Error(&quot;Undefined nameToPath for &quot; + requireName);\n            }\n          }\n        }\n      }\n      if (!(path in seenScript)) {\n        seenScript[path] = true;\n        scripts.push(path);\n      }\n    }\n    for (var path in goog.included_) {\n      if (!deps.written[path]) {\n        visitNode(path);\n      }\n    }\n    for (var i = 0;i &lt; scripts.length;i++) {\n      if (scripts[i]) {\n        goog.importScript_(goog.basePath + scripts[i]);\n      } else {\n        throw Error(&quot;Undefined script input&quot;);\n      }\n    }\n  };\n  goog.getPathFromDeps_ = function(rule) {\n    if (rule in goog.dependencies_.nameToPath) {\n      return goog.dependencies_.nameToPath[rule];\n    } else {\n      return null;\n    }\n  };\n  goog.findBasePath_();\n  if (!goog.global.CLOSURE_NO_DEPS) {\n    goog.importScript_(goog.basePath + &quot;deps.js&quot;);\n  }\n}\ngoog.typeOf = function(value) {\n  var s = typeof value;\n  if (s == &quot;object&quot;) {\n    if (value) {\n      if (value instanceof Array) {\n        return &quot;array&quot;;\n      } else {\n        if (value instanceof Object) {\n          return s;\n        }\n      }\n      var className = Object.prototype.toString.call((value));\n      if (className == &quot;[object Window]&quot;) {\n        return &quot;object&quot;;\n      }\n      if (className == &quot;[object Array]&quot; || typeof value.length == &quot;number&quot; &amp;&amp; typeof value.splice != &quot;undefined&quot; &amp;&amp; typeof value.propertyIsEnumerable != &quot;undefined&quot; &amp;&amp; !value.propertyIsEnumerable(&quot;splice&quot;)) {\n        return &quot;array&quot;;\n      }\n      if (className == &quot;[object Function]&quot; || typeof value.call != &quot;undefined&quot; &amp;&amp; typeof value.propertyIsEnumerable != &quot;undefined&quot; &amp;&amp; !value.propertyIsEnumerable(&quot;call&quot;)) {\n        return &quot;function&quot;;\n      }\n    } else {\n      return &quot;null&quot;;\n    }\n  } else {\n    if (s == &quot;function&quot; &amp;&amp; typeof value.call == &quot;undefined&quot;) {\n      return &quot;object&quot;;\n    }\n  }\n  return s;\n};\ngoog.isNull = function(val) {\n  return val === null;\n};\ngoog.isDefAndNotNull = function(val) {\n  return val != null;\n};\ngoog.isArray = function(val) {\n  return goog.typeOf(val) == &quot;array&quot;;\n};\ngoog.isArrayLike = function(val) {\n  var type = goog.typeOf(val);\n  return type == &quot;array&quot; || type == &quot;object&quot; &amp;&amp; typeof val.length == &quot;number&quot;;\n};\ngoog.isDateLike = function(val) {\n  return goog.isObject(val) &amp;&amp; typeof val.getFullYear == &quot;function&quot;;\n};\ngoog.isString = function(val) {\n  return typeof val == &quot;string&quot;;\n};\ngoog.isBoolean = function(val) {\n  return typeof val == &quot;boolean&quot;;\n};\ngoog.isNumber = function(val) {\n  return typeof val == &quot;number&quot;;\n};\ngoog.isFunction = function(val) {\n  return goog.typeOf(val) == &quot;function&quot;;\n};\ngoog.isObject = function(val) {\n  var type = typeof val;\n  return type == &quot;object&quot; &amp;&amp; val != null || type == &quot;function&quot;;\n};\ngoog.getUid = function(obj) {\n  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);\n};\ngoog.hasUid = function(obj) {\n  return!!obj[goog.UID_PROPERTY_];\n};\ngoog.removeUid = function(obj) {\n  if (&quot;removeAttribute&quot; in obj) {\n    obj.removeAttribute(goog.UID_PROPERTY_);\n  }\n  try {\n    delete obj[goog.UID_PROPERTY_];\n  } catch (ex) {\n  }\n};\ngoog.UID_PROPERTY_ = &quot;closure_uid_&quot; + (Math.random() * 1E9 &gt;&gt;&gt; 0);\ngoog.uidCounter_ = 0;\ngoog.getHashCode = goog.getUid;\ngoog.removeHashCode = goog.removeUid;\ngoog.cloneObject = function(obj) {\n  var type = goog.typeOf(obj);\n  if (type == &quot;object&quot; || type == &quot;array&quot;) {\n    if (obj.clone) {\n      return obj.clone();\n    }\n    var clone = type == &quot;array&quot; ? [] : {};\n    for (var key in obj) {\n      clone[key] = goog.cloneObject(obj[key]);\n    }\n    return clone;\n  }\n  return obj;\n};\ngoog.bindNative_ = function(fn, selfObj, var_args) {\n  return(fn.call.apply(fn.bind, arguments));\n};\ngoog.bindJs_ = function(fn, selfObj, var_args) {\n  if (!fn) {\n    throw new Error;\n  }\n  if (arguments.length &gt; 2) {\n    var boundArgs = Array.prototype.slice.call(arguments, 2);\n    return function() {\n      var newArgs = Array.prototype.slice.call(arguments);\n      Array.prototype.unshift.apply(newArgs, boundArgs);\n      return fn.apply(selfObj, newArgs);\n    };\n  } else {\n    return function() {\n      return fn.apply(selfObj, arguments);\n    };\n  }\n};\ngoog.bind = function(fn, selfObj, var_args) {\n  if (Function.prototype.bind &amp;&amp; Function.prototype.bind.toString().indexOf(&quot;native code&quot;) != -1) {\n    goog.bind = goog.bindNative_;\n  } else {\n    goog.bind = goog.bindJs_;\n  }\n  return goog.bind.apply(null, arguments);\n};\ngoog.partial = function(fn, var_args) {\n  var args = Array.prototype.slice.call(arguments, 1);\n  return function() {\n    var newArgs = args.slice();\n    newArgs.push.apply(newArgs, arguments);\n    return fn.apply(this, newArgs);\n  };\n};\ngoog.mixin = function(target, source) {\n  for (var x in source) {\n    target[x] = source[x];\n  }\n};\ngoog.now = goog.TRUSTED_SITE &amp;&amp; Date.now || function() {\n  return+new Date;\n};\ngoog.globalEval = function(script) {\n  if (goog.global.execScript) {\n    goog.global.execScript(script, &quot;JavaScript&quot;);\n  } else {\n    if (goog.global.eval) {\n      if (goog.evalWorksForGlobals_ == null) {\n        goog.global.eval(&quot;var _et_ \\x3d 1;&quot;);\n        if (typeof goog.global[&quot;_et_&quot;] != &quot;undefined&quot;) {\n          delete goog.global[&quot;_et_&quot;];\n          goog.evalWorksForGlobals_ = true;\n        } else {\n          goog.evalWorksForGlobals_ = false;\n        }\n      }\n      if (goog.evalWorksForGlobals_) {\n        goog.global.eval(script);\n      } else {\n        var doc = goog.global.document;\n        var scriptElt = doc.createElement(&quot;script&quot;);\n        scriptElt.type = &quot;text/javascript&quot;;\n        scriptElt.defer = false;\n        scriptElt.appendChild(doc.createTextNode(script));\n        doc.body.appendChild(scriptElt);\n        doc.body.removeChild(scriptElt);\n      }\n    } else {\n      throw Error(&quot;goog.globalEval not available&quot;);\n    }\n  }\n};\ngoog.evalWorksForGlobals_ = null;\ngoog.cssNameMapping_;\ngoog.cssNameMappingStyle_;\ngoog.getCssName = function(className, opt_modifier) {\n  var getMapping = function(cssName) {\n    return goog.cssNameMapping_[cssName] || cssName;\n  };\n  var renameByParts = function(cssName) {\n    var parts = cssName.split(&quot;-&quot;);\n    var mapped = [];\n    for (var i = 0;i &lt; parts.length;i++) {\n      mapped.push(getMapping(parts[i]));\n    }\n    return mapped.join(&quot;-&quot;);\n  };\n  var rename;\n  if (goog.cssNameMapping_) {\n    rename = goog.cssNameMappingStyle_ == &quot;BY_WHOLE&quot; ? getMapping : renameByParts;\n  } else {\n    rename = function(a) {\n      return a;\n    };\n  }\n  if (opt_modifier) {\n    return className + &quot;-&quot; + rename(opt_modifier);\n  } else {\n    return rename(className);\n  }\n};\ngoog.setCssNameMapping = function(mapping, opt_style) {\n  goog.cssNameMapping_ = mapping;\n  goog.cssNameMappingStyle_ = opt_style;\n};\ngoog.global.CLOSURE_CSS_NAME_MAPPING;\nif (!COMPILED &amp;&amp; goog.global.CLOSURE_CSS_NAME_MAPPING) {\n  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;\n}\ngoog.getMsg = function(str, opt_values) {\n  if (opt_values) {\n    str = str.replace(/\\{\\$([^}]+)}/g, function(match, key) {\n      return key in opt_values ? opt_values[key] : match;\n    });\n  }\n  return str;\n};\ngoog.getMsgWithFallback = function(a, b) {\n  return a;\n};\ngoog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {\n  goog.exportPath_(publicPath, object, opt_objectToExportTo);\n};\ngoog.exportProperty = function(object, publicName, symbol) {\n  object[publicName] = symbol;\n};\ngoog.inherits = function(childCtor, parentCtor) {\n  function tempCtor() {\n  }\n  tempCtor.prototype = parentCtor.prototype;\n  childCtor.superClass_ = parentCtor.prototype;\n  childCtor.prototype = new tempCtor;\n  childCtor.prototype.constructor = childCtor;\n  childCtor.base = function(me, methodName, var_args) {\n    var args = Array.prototype.slice.call(arguments, 2);\n    return parentCtor.prototype[methodName].apply(me, args);\n  };\n};\ngoog.base = function(me, opt_methodName, var_args) {\n  var caller = arguments.callee.caller;\n  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG &amp;&amp; !caller) {\n    throw Error(&quot;arguments.caller not defined.  goog.base() cannot be used &quot; + &quot;with strict mode code. See &quot; + &quot;http://www.ecma-international.org/ecma-262/5.1/#sec-C&quot;);\n  }\n  if (caller.superClass_) {\n    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1));\n  }\n  var args = Array.prototype.slice.call(arguments, 2);\n  var foundCaller = false;\n  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ &amp;&amp; ctor.superClass_.constructor) {\n    if (ctor.prototype[opt_methodName] === caller) {\n      foundCaller = true;\n    } else {\n      if (foundCaller) {\n        return ctor.prototype[opt_methodName].apply(me, args);\n      }\n    }\n  }\n  if (me[opt_methodName] === caller) {\n    return me.constructor.prototype[opt_methodName].apply(me, args);\n  } else {\n    throw Error(&quot;goog.base called from a method of one name &quot; + &quot;to a method of a different name&quot;);\n  }\n};\ngoog.scope = function(fn) {\n  fn.call(goog.global);\n};\nif (!COMPILED) {\n  goog.global[&quot;COMPILED&quot;] = COMPILED;\n}\ngoog.defineClass = function(superClass, def) {\n  var constructor = def.constructor;\n  var statics = def.statics;\n  if (!constructor || constructor == Object.prototype.constructor) {\n    constructor = function() {\n      throw Error(&quot;cannot instantiate an interface (no constructor defined).&quot;);\n    };\n  }\n  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);\n  if (superClass) {\n    goog.inherits(cls, superClass);\n  }\n  delete def.constructor;\n  delete def.statics;\n  goog.defineClass.applyProperties_(cls.prototype, def);\n  if (statics != null) {\n    if (statics instanceof Function) {\n      statics(cls);\n    } else {\n      goog.defineClass.applyProperties_(cls, statics);\n    }\n  }\n  return cls;\n};\ngoog.defineClass.ClassDescriptor;\ngoog.define(&quot;goog.defineClass.SEAL_CLASS_INSTANCES&quot;, goog.DEBUG);\ngoog.defineClass.createSealingConstructor_ = function(ctr, superClass) {\n  if (goog.defineClass.SEAL_CLASS_INSTANCES &amp;&amp; Object.seal instanceof Function) {\n    if (superClass &amp;&amp; superClass.prototype &amp;&amp; superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {\n      return ctr;\n    }\n    var wrappedCtr = function() {\n      var instance = ctr.apply(this, arguments) || this;\n      if (this.constructor === wrappedCtr) {\n        Object.seal(instance);\n      }\n      return instance;\n    };\n    return wrappedCtr;\n  }\n  return ctr;\n};\ngoog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = [&quot;constructor&quot;, &quot;hasOwnProperty&quot;, &quot;isPrototypeOf&quot;, &quot;propertyIsEnumerable&quot;, &quot;toLocaleString&quot;, &quot;toString&quot;, &quot;valueOf&quot;];\ngoog.defineClass.applyProperties_ = function(target, source) {\n  var key;\n  for (key in source) {\n    if (Object.prototype.hasOwnProperty.call(source, key)) {\n      target[key] = source[key];\n    }\n  }\n  for (var i = 0;i &lt; goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {\n    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];\n    if (Object.prototype.hasOwnProperty.call(source, key)) {\n      target[key] = source[key];\n    }\n  }\n};\ngoog.tagUnsealableClass = function(ctr) {\n  if (!COMPILED &amp;&amp; goog.defineClass.SEAL_CLASS_INSTANCES) {\n    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;\n  }\n};\ngoog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = &quot;goog_defineClass_legacy_unsealable&quot;;\ngoog.provide(&quot;goog.string&quot;);\ngoog.provide(&quot;goog.string.Unicode&quot;);\ngoog.define(&quot;goog.string.DETECT_DOUBLE_ESCAPING&quot;, false);\ngoog.string.Unicode = {NBSP:&quot;\\u00a0&quot;};\ngoog.string.startsWith = function(str, prefix) {\n  return str.lastIndexOf(prefix, 0) == 0;\n};\ngoog.string.endsWith = function(str, suffix) {\n  var l = str.length - suffix.length;\n  return l &gt;= 0 &amp;&amp; str.indexOf(suffix, l) == l;\n};\ngoog.string.caseInsensitiveStartsWith = function(str, prefix) {\n  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;\n};\ngoog.string.caseInsensitiveEndsWith = function(str, suffix) {\n  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;\n};\ngoog.string.caseInsensitiveEquals = function(str1, str2) {\n  return str1.toLowerCase() == str2.toLowerCase();\n};\ngoog.string.subs = function(str, var_args) {\n  var splitParts = str.split(&quot;%s&quot;);\n  var returnString = &quot;&quot;;\n  var subsArguments = Array.prototype.slice.call(arguments, 1);\n  while (subsArguments.length &amp;&amp; splitParts.length &gt; 1) {\n    returnString += splitParts.shift() + subsArguments.shift();\n  }\n  return returnString + splitParts.join(&quot;%s&quot;);\n};\ngoog.string.collapseWhitespace = function(str) {\n  return str.replace(/[\\s\\xa0]+/g, &quot; &quot;).replace(/^\\s+|\\s+$/g, &quot;&quot;);\n};\ngoog.string.isEmpty = function(str) {\n  return/^[\\s\\xa0]*$/.test(str);\n};\ngoog.string.isEmptySafe = function(str) {\n  return goog.string.isEmpty(goog.string.makeSafe(str));\n};\ngoog.string.isBreakingWhitespace = function(str) {\n  return!/[^\\t\\n\\r ]/.test(str);\n};\ngoog.string.isAlpha = function(str) {\n  return!/[^a-zA-Z]/.test(str);\n};\ngoog.string.isNumeric = function(str) {\n  return!/[^0-9]/.test(str);\n};\ngoog.string.isAlphaNumeric = function(str) {\n  return!/[^a-zA-Z0-9]/.test(str);\n};\ngoog.string.isSpace = function(ch) {\n  return ch == &quot; &quot;;\n};\ngoog.string.isUnicodeChar = function(ch) {\n  return ch.length == 1 &amp;&amp; ch &gt;= &quot; &quot; &amp;&amp; ch &lt;= &quot;~&quot; || ch &gt;= &quot;\\u0080&quot; &amp;&amp; ch &lt;= &quot;\\ufffd&quot;;\n};\ngoog.string.stripNewlines = function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)+/g, &quot; &quot;);\n};\ngoog.string.canonicalizeNewlines = function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, &quot;\\n&quot;);\n};\ngoog.string.normalizeWhitespace = function(str) {\n  return str.replace(/\\xa0|\\s/g, &quot; &quot;);\n};\ngoog.string.normalizeSpaces = function(str) {\n  return str.replace(/\\xa0|[ \\t]+/g, &quot; &quot;);\n};\ngoog.string.collapseBreakingSpaces = function(str) {\n  return str.replace(/[\\t\\r\\n ]+/g, &quot; &quot;).replace(/^[\\t\\r\\n ]+|[\\t\\r\\n ]+$/g, &quot;&quot;);\n};\ngoog.string.trim = function(str) {\n  return str.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, &quot;&quot;);\n};\ngoog.string.trimLeft = function(str) {\n  return str.replace(/^[\\s\\xa0]+/, &quot;&quot;);\n};\ngoog.string.trimRight = function(str) {\n  return str.replace(/[\\s\\xa0]+$/, &quot;&quot;);\n};\ngoog.string.caseInsensitiveCompare = function(str1, str2) {\n  var test1 = String(str1).toLowerCase();\n  var test2 = String(str2).toLowerCase();\n  if (test1 &lt; test2) {\n    return-1;\n  } else {\n    if (test1 == test2) {\n      return 0;\n    } else {\n      return 1;\n    }\n  }\n};\ngoog.string.numerateCompareRegExp_ = /(\\.\\d+)|(\\d+)|(\\D+)/g;\ngoog.string.numerateCompare = function(str1, str2) {\n  if (str1 == str2) {\n    return 0;\n  }\n  if (!str1) {\n    return-1;\n  }\n  if (!str2) {\n    return 1;\n  }\n  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);\n  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);\n  var count = Math.min(tokens1.length, tokens2.length);\n  for (var i = 0;i &lt; count;i++) {\n    var a = tokens1[i];\n    var b = tokens2[i];\n    if (a != b) {\n      var num1 = parseInt(a, 10);\n      if (!isNaN(num1)) {\n        var num2 = parseInt(b, 10);\n        if (!isNaN(num2) &amp;&amp; num1 - num2) {\n          return num1 - num2;\n        }\n      }\n      return a &lt; b ? -1 : 1;\n    }\n  }\n  if (tokens1.length != tokens2.length) {\n    return tokens1.length - tokens2.length;\n  }\n  return str1 &lt; str2 ? -1 : 1;\n};\ngoog.string.urlEncode = function(str) {\n  return encodeURIComponent(String(str));\n};\ngoog.string.urlDecode = function(str) {\n  return decodeURIComponent(str.replace(/\\+/g, &quot; &quot;));\n};\ngoog.string.newLineToBr = function(str, opt_xml) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, opt_xml ? &quot;\\x3cbr /\\x3e&quot; : &quot;\\x3cbr\\x3e&quot;);\n};\ngoog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {\n  if (opt_isLikelyToContainHtmlChars) {\n    str = str.replace(goog.string.AMP_RE_, &quot;\\x26amp;&quot;).replace(goog.string.LT_RE_, &quot;\\x26lt;&quot;).replace(goog.string.GT_RE_, &quot;\\x26gt;&quot;).replace(goog.string.QUOT_RE_, &quot;\\x26quot;&quot;).replace(goog.string.SINGLE_QUOTE_RE_, &quot;\\x26#39;&quot;).replace(goog.string.NULL_RE_, &quot;\\x26#0;&quot;);\n    if (goog.string.DETECT_DOUBLE_ESCAPING) {\n      str = str.replace(goog.string.E_RE_, &quot;\\x26#101;&quot;);\n    }\n    return str;\n  } else {\n    if (!goog.string.ALL_RE_.test(str)) {\n      return str;\n    }\n    if (str.indexOf(&quot;\\x26&quot;) != -1) {\n      str = str.replace(goog.string.AMP_RE_, &quot;\\x26amp;&quot;);\n    }\n    if (str.indexOf(&quot;\\x3c&quot;) != -1) {\n      str = str.replace(goog.string.LT_RE_, &quot;\\x26lt;&quot;);\n    }\n    if (str.indexOf(&quot;\\x3e&quot;) != -1) {\n      str = str.replace(goog.string.GT_RE_, &quot;\\x26gt;&quot;);\n    }\n    if (str.indexOf(&apos;&quot;&apos;) != -1) {\n      str = str.replace(goog.string.QUOT_RE_, &quot;\\x26quot;&quot;);\n    }\n    if (str.indexOf(&quot;&apos;&quot;) != -1) {\n      str = str.replace(goog.string.SINGLE_QUOTE_RE_, &quot;\\x26#39;&quot;);\n    }\n    if (str.indexOf(&quot;\\x00&quot;) != -1) {\n      str = str.replace(goog.string.NULL_RE_, &quot;\\x26#0;&quot;);\n    }\n    if (goog.string.DETECT_DOUBLE_ESCAPING &amp;&amp; str.indexOf(&quot;e&quot;) != -1) {\n      str = str.replace(goog.string.E_RE_, &quot;\\x26#101;&quot;);\n    }\n    return str;\n  }\n};\ngoog.string.AMP_RE_ = /&amp;/g;\ngoog.string.LT_RE_ = /&lt;/g;\ngoog.string.GT_RE_ = /&gt;/g;\ngoog.string.QUOT_RE_ = /&quot;/g;\ngoog.string.SINGLE_QUOTE_RE_ = /&apos;/g;\ngoog.string.NULL_RE_ = /\\x00/g;\ngoog.string.E_RE_ = /e/g;\ngoog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\\x00&amp;&lt;&gt;&quot;&apos;e]/ : /[\\x00&amp;&lt;&gt;&quot;&apos;]/;\ngoog.string.unescapeEntities = function(str) {\n  if (goog.string.contains(str, &quot;\\x26&quot;)) {\n    if (&quot;document&quot; in goog.global) {\n      return goog.string.unescapeEntitiesUsingDom_(str);\n    } else {\n      return goog.string.unescapePureXmlEntities_(str);\n    }\n  }\n  return str;\n};\ngoog.string.unescapeEntitiesWithDocument = function(str, document) {\n  if (goog.string.contains(str, &quot;\\x26&quot;)) {\n    return goog.string.unescapeEntitiesUsingDom_(str, document);\n  }\n  return str;\n};\ngoog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {\n  var seen = {&quot;\\x26amp;&quot;:&quot;\\x26&quot;, &quot;\\x26lt;&quot;:&quot;\\x3c&quot;, &quot;\\x26gt;&quot;:&quot;\\x3e&quot;, &quot;\\x26quot;&quot;:&apos;&quot;&apos;};\n  var div;\n  if (opt_document) {\n    div = opt_document.createElement(&quot;div&quot;);\n  } else {\n    div = goog.global.document.createElement(&quot;div&quot;);\n  }\n  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {\n    var value = seen[s];\n    if (value) {\n      return value;\n    }\n    if (entity.charAt(0) == &quot;#&quot;) {\n      var n = Number(&quot;0&quot; + entity.substr(1));\n      if (!isNaN(n)) {\n        value = String.fromCharCode(n);\n      }\n    }\n    if (!value) {\n      div.innerHTML = s + &quot; &quot;;\n      value = div.firstChild.nodeValue.slice(0, -1);\n    }\n    return seen[s] = value;\n  });\n};\ngoog.string.unescapePureXmlEntities_ = function(str) {\n  return str.replace(/&amp;([^;]+);/g, function(s, entity) {\n    switch(entity) {\n      case &quot;amp&quot;:\n        return &quot;\\x26&quot;;\n      case &quot;lt&quot;:\n        return &quot;\\x3c&quot;;\n      case &quot;gt&quot;:\n        return &quot;\\x3e&quot;;\n      case &quot;quot&quot;:\n        return&apos;&quot;&apos;;\n      default:\n        if (entity.charAt(0) == &quot;#&quot;) {\n          var n = Number(&quot;0&quot; + entity.substr(1));\n          if (!isNaN(n)) {\n            return String.fromCharCode(n);\n          }\n        }\n        return s;\n    }\n  });\n};\ngoog.string.HTML_ENTITY_PATTERN_ = /&amp;([^;\\s&lt;&amp;]+);?/g;\ngoog.string.whitespaceEscape = function(str, opt_xml) {\n  return goog.string.newLineToBr(str.replace(/  /g, &quot; \\x26#160;&quot;), opt_xml);\n};\ngoog.string.preserveSpaces = function(str) {\n  return str.replace(/(^|[\\n ]) /g, &quot;$1&quot; + goog.string.Unicode.NBSP);\n};\ngoog.string.stripQuotes = function(str, quoteChars) {\n  var length = quoteChars.length;\n  for (var i = 0;i &lt; length;i++) {\n    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);\n    if (str.charAt(0) == quoteChar &amp;&amp; str.charAt(str.length - 1) == quoteChar) {\n      return str.substring(1, str.length - 1);\n    }\n  }\n  return str;\n};\ngoog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {\n  if (opt_protectEscapedCharacters) {\n    str = goog.string.unescapeEntities(str);\n  }\n  if (str.length &gt; chars) {\n    str = str.substring(0, chars - 3) + &quot;...&quot;;\n  }\n  if (opt_protectEscapedCharacters) {\n    str = goog.string.htmlEscape(str);\n  }\n  return str;\n};\ngoog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {\n  if (opt_protectEscapedCharacters) {\n    str = goog.string.unescapeEntities(str);\n  }\n  if (opt_trailingChars &amp;&amp; str.length &gt; chars) {\n    if (opt_trailingChars &gt; chars) {\n      opt_trailingChars = chars;\n    }\n    var endPoint = str.length - opt_trailingChars;\n    var startPoint = chars - opt_trailingChars;\n    str = str.substring(0, startPoint) + &quot;...&quot; + str.substring(endPoint);\n  } else {\n    if (str.length &gt; chars) {\n      var half = Math.floor(chars / 2);\n      var endPos = str.length - half;\n      half += chars % 2;\n      str = str.substring(0, half) + &quot;...&quot; + str.substring(endPos);\n    }\n  }\n  if (opt_protectEscapedCharacters) {\n    str = goog.string.htmlEscape(str);\n  }\n  return str;\n};\ngoog.string.specialEscapeChars_ = {&quot;\\x00&quot;:&quot;\\\\0&quot;, &quot;\\b&quot;:&quot;\\\\b&quot;, &quot;\\f&quot;:&quot;\\\\f&quot;, &quot;\\n&quot;:&quot;\\\\n&quot;, &quot;\\r&quot;:&quot;\\\\r&quot;, &quot;\\t&quot;:&quot;\\\\t&quot;, &quot;\\x0B&quot;:&quot;\\\\x0B&quot;, &apos;&quot;&apos;:&apos;\\\\&quot;&apos;, &quot;\\\\&quot;:&quot;\\\\\\\\&quot;};\ngoog.string.jsEscapeCache_ = {&quot;&apos;&quot;:&quot;\\\\&apos;&quot;};\ngoog.string.quote = function(s) {\n  s = String(s);\n  if (s.quote) {\n    return s.quote();\n  } else {\n    var sb = [&apos;&quot;&apos;];\n    for (var i = 0;i &lt; s.length;i++) {\n      var ch = s.charAt(i);\n      var cc = ch.charCodeAt(0);\n      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc &gt; 31 &amp;&amp; cc &lt; 127 ? ch : goog.string.escapeChar(ch));\n    }\n    sb.push(&apos;&quot;&apos;);\n    return sb.join(&quot;&quot;);\n  }\n};\ngoog.string.escapeString = function(str) {\n  var sb = [];\n  for (var i = 0;i &lt; str.length;i++) {\n    sb[i] = goog.string.escapeChar(str.charAt(i));\n  }\n  return sb.join(&quot;&quot;);\n};\ngoog.string.escapeChar = function(c) {\n  if (c in goog.string.jsEscapeCache_) {\n    return goog.string.jsEscapeCache_[c];\n  }\n  if (c in goog.string.specialEscapeChars_) {\n    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];\n  }\n  var rv = c;\n  var cc = c.charCodeAt(0);\n  if (cc &gt; 31 &amp;&amp; cc &lt; 127) {\n    rv = c;\n  } else {\n    if (cc &lt; 256) {\n      rv = &quot;\\\\x&quot;;\n      if (cc &lt; 16 || cc &gt; 256) {\n        rv += &quot;0&quot;;\n      }\n    } else {\n      rv = &quot;\\\\u&quot;;\n      if (cc &lt; 4096) {\n        rv += &quot;0&quot;;\n      }\n    }\n    rv += cc.toString(16).toUpperCase();\n  }\n  return goog.string.jsEscapeCache_[c] = rv;\n};\ngoog.string.toMap = function(s) {\n  var rv = {};\n  for (var i = 0;i &lt; s.length;i++) {\n    rv[s.charAt(i)] = true;\n  }\n  return rv;\n};\ngoog.string.contains = function(str, subString) {\n  return str.indexOf(subString) != -1;\n};\ngoog.string.caseInsensitiveContains = function(str, subString) {\n  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());\n};\ngoog.string.countOf = function(s, ss) {\n  return s &amp;&amp; ss ? s.split(ss).length - 1 : 0;\n};\ngoog.string.removeAt = function(s, index, stringLength) {\n  var resultStr = s;\n  if (index &gt;= 0 &amp;&amp; index &lt; s.length &amp;&amp; stringLength &gt; 0) {\n    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);\n  }\n  return resultStr;\n};\ngoog.string.remove = function(s, ss) {\n  var re = new RegExp(goog.string.regExpEscape(ss), &quot;&quot;);\n  return s.replace(re, &quot;&quot;);\n};\ngoog.string.removeAll = function(s, ss) {\n  var re = new RegExp(goog.string.regExpEscape(ss), &quot;g&quot;);\n  return s.replace(re, &quot;&quot;);\n};\ngoog.string.regExpEscape = function(s) {\n  return String(s).replace(/([-()\\[\\]{}+?*.$\\^|,:#&lt;!\\\\])/g, &quot;\\\\$1&quot;).replace(/\\x08/g, &quot;\\\\x08&quot;);\n};\ngoog.string.repeat = function(string, length) {\n  return(new Array(length + 1)).join(string);\n};\ngoog.string.padNumber = function(num, length, opt_precision) {\n  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);\n  var index = s.indexOf(&quot;.&quot;);\n  if (index == -1) {\n    index = s.length;\n  }\n  return goog.string.repeat(&quot;0&quot;, Math.max(0, length - index)) + s;\n};\ngoog.string.makeSafe = function(obj) {\n  return obj == null ? &quot;&quot; : String(obj);\n};\ngoog.string.buildString = function(var_args) {\n  return Array.prototype.join.call(arguments, &quot;&quot;);\n};\ngoog.string.getRandomString = function() {\n  var x = 2147483648;\n  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);\n};\ngoog.string.compareVersions = function(version1, version2) {\n  var order = 0;\n  var v1Subs = goog.string.trim(String(version1)).split(&quot;.&quot;);\n  var v2Subs = goog.string.trim(String(version2)).split(&quot;.&quot;);\n  var subCount = Math.max(v1Subs.length, v2Subs.length);\n  for (var subIdx = 0;order == 0 &amp;&amp; subIdx &lt; subCount;subIdx++) {\n    var v1Sub = v1Subs[subIdx] || &quot;&quot;;\n    var v2Sub = v2Subs[subIdx] || &quot;&quot;;\n    var v1CompParser = new RegExp(&quot;(\\\\d*)(\\\\D*)&quot;, &quot;g&quot;);\n    var v2CompParser = new RegExp(&quot;(\\\\d*)(\\\\D*)&quot;, &quot;g&quot;);\n    do {\n      var v1Comp = v1CompParser.exec(v1Sub) || [&quot;&quot;, &quot;&quot;, &quot;&quot;];\n      var v2Comp = v2CompParser.exec(v2Sub) || [&quot;&quot;, &quot;&quot;, &quot;&quot;];\n      if (v1Comp[0].length == 0 &amp;&amp; v2Comp[0].length == 0) {\n        break;\n      }\n      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);\n      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);\n      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);\n    } while (order == 0);\n  }\n  return order;\n};\ngoog.string.compareElements_ = function(left, right) {\n  if (left &lt; right) {\n    return-1;\n  } else {\n    if (left &gt; right) {\n      return 1;\n    }\n  }\n  return 0;\n};\ngoog.string.HASHCODE_MAX_ = 4294967296;\ngoog.string.hashCode = function(str) {\n  var result = 0;\n  for (var i = 0;i &lt; str.length;++i) {\n    result = 31 * result + str.charCodeAt(i);\n    result %= goog.string.HASHCODE_MAX_;\n  }\n  return result;\n};\ngoog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;\ngoog.string.createUniqueString = function() {\n  return &quot;goog_&quot; + goog.string.uniqueStringCounter_++;\n};\ngoog.string.toNumber = function(str) {\n  var num = Number(str);\n  if (num == 0 &amp;&amp; goog.string.isEmpty(str)) {\n    return NaN;\n  }\n  return num;\n};\ngoog.string.isLowerCamelCase = function(str) {\n  return/^[a-z]+([A-Z][a-z]*)*$/.test(str);\n};\ngoog.string.isUpperCamelCase = function(str) {\n  return/^([A-Z][a-z]*)+$/.test(str);\n};\ngoog.string.toCamelCase = function(str) {\n  return String(str).replace(/\\-([a-z])/g, function(all, match) {\n    return match.toUpperCase();\n  });\n};\ngoog.string.toSelectorCase = function(str) {\n  return String(str).replace(/([A-Z])/g, &quot;-$1&quot;).toLowerCase();\n};\ngoog.string.toTitleCase = function(str, opt_delimiters) {\n  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : &quot;\\\\s&quot;;\n  delimiters = delimiters ? &quot;|[&quot; + delimiters + &quot;]+&quot; : &quot;&quot;;\n  var regexp = new RegExp(&quot;(^&quot; + delimiters + &quot;)([a-z])&quot;, &quot;g&quot;);\n  return str.replace(regexp, function(all, p1, p2) {\n    return p1 + p2.toUpperCase();\n  });\n};\ngoog.string.parseInt = function(value) {\n  if (isFinite(value)) {\n    value = String(value);\n  }\n  if (goog.isString(value)) {\n    return/^\\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);\n  }\n  return NaN;\n};\ngoog.string.splitLimit = function(str, separator, limit) {\n  var parts = str.split(separator);\n  var returnVal = [];\n  while (limit &gt; 0 &amp;&amp; parts.length) {\n    returnVal.push(parts.shift());\n    limit--;\n  }\n  if (parts.length) {\n    returnVal.push(parts.join(separator));\n  }\n  return returnVal;\n};\ngoog.provide(&quot;goog.object&quot;);\ngoog.object.forEach = function(obj, f, opt_obj) {\n  for (var key in obj) {\n    f.call(opt_obj, obj[key], key, obj);\n  }\n};\ngoog.object.filter = function(obj, f, opt_obj) {\n  var res = {};\n  for (var key in obj) {\n    if (f.call(opt_obj, obj[key], key, obj)) {\n      res[key] = obj[key];\n    }\n  }\n  return res;\n};\ngoog.object.map = function(obj, f, opt_obj) {\n  var res = {};\n  for (var key in obj) {\n    res[key] = f.call(opt_obj, obj[key], key, obj);\n  }\n  return res;\n};\ngoog.object.some = function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (f.call(opt_obj, obj[key], key, obj)) {\n      return true;\n    }\n  }\n  return false;\n};\ngoog.object.every = function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (!f.call(opt_obj, obj[key], key, obj)) {\n      return false;\n    }\n  }\n  return true;\n};\ngoog.object.getCount = function(obj) {\n  var rv = 0;\n  for (var key in obj) {\n    rv++;\n  }\n  return rv;\n};\ngoog.object.getAnyKey = function(obj) {\n  for (var key in obj) {\n    return key;\n  }\n};\ngoog.object.getAnyValue = function(obj) {\n  for (var key in obj) {\n    return obj[key];\n  }\n};\ngoog.object.contains = function(obj, val) {\n  return goog.object.containsValue(obj, val);\n};\ngoog.object.getValues = function(obj) {\n  var res = [];\n  var i = 0;\n  for (var key in obj) {\n    res[i++] = obj[key];\n  }\n  return res;\n};\ngoog.object.getKeys = function(obj) {\n  var res = [];\n  var i = 0;\n  for (var key in obj) {\n    res[i++] = key;\n  }\n  return res;\n};\ngoog.object.getValueByKeys = function(obj, var_args) {\n  var isArrayLike = goog.isArrayLike(var_args);\n  var keys = isArrayLike ? var_args : arguments;\n  for (var i = isArrayLike ? 0 : 1;i &lt; keys.length;i++) {\n    obj = obj[keys[i]];\n    if (!goog.isDef(obj)) {\n      break;\n    }\n  }\n  return obj;\n};\ngoog.object.containsKey = function(obj, key) {\n  return key in obj;\n};\ngoog.object.containsValue = function(obj, val) {\n  for (var key in obj) {\n    if (obj[key] == val) {\n      return true;\n    }\n  }\n  return false;\n};\ngoog.object.findKey = function(obj, f, opt_this) {\n  for (var key in obj) {\n    if (f.call(opt_this, obj[key], key, obj)) {\n      return key;\n    }\n  }\n  return undefined;\n};\ngoog.object.findValue = function(obj, f, opt_this) {\n  var key = goog.object.findKey(obj, f, opt_this);\n  return key &amp;&amp; obj[key];\n};\ngoog.object.isEmpty = function(obj) {\n  for (var key in obj) {\n    return false;\n  }\n  return true;\n};\ngoog.object.clear = function(obj) {\n  for (var i in obj) {\n    delete obj[i];\n  }\n};\ngoog.object.remove = function(obj, key) {\n  var rv;\n  if (rv = key in obj) {\n    delete obj[key];\n  }\n  return rv;\n};\ngoog.object.add = function(obj, key, val) {\n  if (key in obj) {\n    throw Error(&apos;The object already contains the key &quot;&apos; + key + &apos;&quot;&apos;);\n  }\n  goog.object.set(obj, key, val);\n};\ngoog.object.get = function(obj, key, opt_val) {\n  if (key in obj) {\n    return obj[key];\n  }\n  return opt_val;\n};\ngoog.object.set = function(obj, key, value) {\n  obj[key] = value;\n};\ngoog.object.setIfUndefined = function(obj, key, value) {\n  return key in obj ? obj[key] : obj[key] = value;\n};\ngoog.object.clone = function(obj) {\n  var res = {};\n  for (var key in obj) {\n    res[key] = obj[key];\n  }\n  return res;\n};\ngoog.object.unsafeClone = function(obj) {\n  var type = goog.typeOf(obj);\n  if (type == &quot;object&quot; || type == &quot;array&quot;) {\n    if (obj.clone) {\n      return obj.clone();\n    }\n    var clone = type == &quot;array&quot; ? [] : {};\n    for (var key in obj) {\n      clone[key] = goog.object.unsafeClone(obj[key]);\n    }\n    return clone;\n  }\n  return obj;\n};\ngoog.object.transpose = function(obj) {\n  var transposed = {};\n  for (var key in obj) {\n    transposed[obj[key]] = key;\n  }\n  return transposed;\n};\ngoog.object.PROTOTYPE_FIELDS_ = [&quot;constructor&quot;, &quot;hasOwnProperty&quot;, &quot;isPrototypeOf&quot;, &quot;propertyIsEnumerable&quot;, &quot;toLocaleString&quot;, &quot;toString&quot;, &quot;valueOf&quot;];\ngoog.object.extend = function(target, var_args) {\n  var key, source;\n  for (var i = 1;i &lt; arguments.length;i++) {\n    source = arguments[i];\n    for (key in source) {\n      target[key] = source[key];\n    }\n    for (var j = 0;j &lt; goog.object.PROTOTYPE_FIELDS_.length;j++) {\n      key = goog.object.PROTOTYPE_FIELDS_[j];\n      if (Object.prototype.hasOwnProperty.call(source, key)) {\n        target[key] = source[key];\n      }\n    }\n  }\n};\ngoog.object.create = function(var_args) {\n  var argLength = arguments.length;\n  if (argLength == 1 &amp;&amp; goog.isArray(arguments[0])) {\n    return goog.object.create.apply(null, arguments[0]);\n  }\n  if (argLength % 2) {\n    throw Error(&quot;Uneven number of arguments&quot;);\n  }\n  var rv = {};\n  for (var i = 0;i &lt; argLength;i += 2) {\n    rv[arguments[i]] = arguments[i + 1];\n  }\n  return rv;\n};\ngoog.object.createSet = function(var_args) {\n  var argLength = arguments.length;\n  if (argLength == 1 &amp;&amp; goog.isArray(arguments[0])) {\n    return goog.object.createSet.apply(null, arguments[0]);\n  }\n  var rv = {};\n  for (var i = 0;i &lt; argLength;i++) {\n    rv[arguments[i]] = true;\n  }\n  return rv;\n};\ngoog.object.createImmutableView = function(obj) {\n  var result = obj;\n  if (Object.isFrozen &amp;&amp; !Object.isFrozen(obj)) {\n    result = Object.create(obj);\n    Object.freeze(result);\n  }\n  return result;\n};\ngoog.object.isImmutableView = function(obj) {\n  return!!Object.isFrozen &amp;&amp; Object.isFrozen(obj);\n};\ngoog.provide(&quot;goog.string.StringBuffer&quot;);\ngoog.string.StringBuffer = function(opt_a1, var_args) {\n  if (opt_a1 != null) {\n    this.append.apply(this, arguments);\n  }\n};\ngoog.string.StringBuffer.prototype.buffer_ = &quot;&quot;;\ngoog.string.StringBuffer.prototype.set = function(s) {\n  this.buffer_ = &quot;&quot; + s;\n};\ngoog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {\n  this.buffer_ += a1;\n  if (opt_a2 != null) {\n    for (var i = 1;i &lt; arguments.length;i++) {\n      this.buffer_ += arguments[i];\n    }\n  }\n  return this;\n};\ngoog.string.StringBuffer.prototype.clear = function() {\n  this.buffer_ = &quot;&quot;;\n};\ngoog.string.StringBuffer.prototype.getLength = function() {\n  return this.buffer_.length;\n};\ngoog.string.StringBuffer.prototype.toString = function() {\n  return this.buffer_;\n};\ngoog.provide(&quot;goog.debug.Error&quot;);\ngoog.debug.Error = function(opt_msg) {\n  if (Error.captureStackTrace) {\n    Error.captureStackTrace(this, goog.debug.Error);\n  } else {\n    var stack = (new Error).stack;\n    if (stack) {\n      this.stack = stack;\n    }\n  }\n  if (opt_msg) {\n    this.message = String(opt_msg);\n  }\n};\ngoog.inherits(goog.debug.Error, Error);\ngoog.debug.Error.prototype.name = &quot;CustomError&quot;;\ngoog.provide(&quot;goog.dom.NodeType&quot;);\ngoog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};\ngoog.provide(&quot;goog.asserts&quot;);\ngoog.provide(&quot;goog.asserts.AssertionError&quot;);\ngoog.require(&quot;goog.debug.Error&quot;);\ngoog.require(&quot;goog.dom.NodeType&quot;);\ngoog.require(&quot;goog.string&quot;);\ngoog.define(&quot;goog.asserts.ENABLE_ASSERTS&quot;, goog.DEBUG);\ngoog.asserts.AssertionError = function(messagePattern, messageArgs) {\n  messageArgs.unshift(messagePattern);\n  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));\n  messageArgs.shift();\n  this.messagePattern = messagePattern;\n};\ngoog.inherits(goog.asserts.AssertionError, goog.debug.Error);\ngoog.asserts.AssertionError.prototype.name = &quot;AssertionError&quot;;\ngoog.asserts.DEFAULT_ERROR_HANDLER = function(e) {\n  throw e;\n};\ngoog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;\ngoog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {\n  var message = &quot;Assertion failed&quot;;\n  if (givenMessage) {\n    message += &quot;: &quot; + givenMessage;\n    var args = givenArgs;\n  } else {\n    if (defaultMessage) {\n      message += &quot;: &quot; + defaultMessage;\n      args = defaultArgs;\n    }\n  }\n  var e = new goog.asserts.AssertionError(&quot;&quot; + message, args || []);\n  goog.asserts.errorHandler_(e);\n};\ngoog.asserts.setErrorHandler = function(errorHandler) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_ = errorHandler;\n  }\n};\ngoog.asserts.assert = function(condition, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !condition) {\n    goog.asserts.doAssertFailure_(&quot;&quot;, null, opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return condition;\n};\ngoog.asserts.fail = function(opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_(new goog.asserts.AssertionError(&quot;Failure&quot; + (opt_message ? &quot;: &quot; + opt_message : &quot;&quot;), Array.prototype.slice.call(arguments, 1)));\n  }\n};\ngoog.asserts.assertNumber = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isNumber(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected number but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertString = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isString(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected string but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertFunction = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isFunction(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected function but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertObject = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isObject(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected object but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertArray = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isArray(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected array but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertBoolean = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !goog.isBoolean(value)) {\n    goog.asserts.doAssertFailure_(&quot;Expected boolean but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertElement = function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {\n    goog.asserts.doAssertFailure_(&quot;Expected Element but got %s: %s.&quot;, [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return(value);\n};\ngoog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS &amp;&amp; !(value instanceof type)) {\n    goog.asserts.doAssertFailure_(&quot;instanceof check failed.&quot;, null, opt_message, Array.prototype.slice.call(arguments, 3));\n  }\n  return value;\n};\ngoog.asserts.assertObjectPrototypeIsIntact = function() {\n  for (var key in Object.prototype) {\n    goog.asserts.fail(key + &quot; should not be enumerable in Object.prototype.&quot;);\n  }\n};\ngoog.provide(&quot;goog.array&quot;);\ngoog.provide(&quot;goog.array.ArrayLike&quot;);\ngoog.require(&quot;goog.asserts&quot;);\ngoog.define(&quot;goog.NATIVE_ARRAY_PROTOTYPES&quot;, goog.TRUSTED_SITE);\ngoog.define(&quot;goog.array.ASSUME_NATIVE_FUNCTIONS&quot;, false);\ngoog.array.ArrayLike;\ngoog.array.peek = function(array) {\n  return array[array.length - 1];\n};\ngoog.array.last = goog.array.peek;\ngoog.array.ARRAY_PROTOTYPE_ = Array.prototype;\ngoog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);\n} : function(arr, obj, opt_fromIndex) {\n  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex &lt; 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;\n  if (goog.isString(arr)) {\n    if (!goog.isString(obj) || obj.length != 1) {\n      return-1;\n    }\n    return arr.indexOf(obj, fromIndex);\n  }\n  for (var i = fromIndex;i &lt; arr.length;i++) {\n    if (i in arr &amp;&amp; arr[i] === obj) {\n      return i;\n    }\n  }\n  return-1;\n};\ngoog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {\n  goog.asserts.assert(arr.length != null);\n  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;\n  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);\n} : function(arr, obj, opt_fromIndex) {\n  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;\n  if (fromIndex &lt; 0) {\n    fromIndex = Math.max(0, arr.length + fromIndex);\n  }\n  if (goog.isString(arr)) {\n    if (!goog.isString(obj) || obj.length != 1) {\n      return-1;\n    }\n    return arr.lastIndexOf(obj, fromIndex);\n  }\n  for (var i = fromIndex;i &gt;= 0;i--) {\n    if (i in arr &amp;&amp; arr[i] === obj) {\n      return i;\n    }\n  }\n  return-1;\n};\ngoog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2) {\n      f.call(opt_obj, arr2[i], i, arr);\n    }\n  }\n};\ngoog.array.forEachRight = function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = l - 1;i &gt;= 0;--i) {\n    if (i in arr2) {\n      f.call(opt_obj, arr2[i], i, arr);\n    }\n  }\n};\ngoog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l = arr.length;\n  var res = [];\n  var resLength = 0;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2) {\n      var val = arr2[i];\n      if (f.call(opt_obj, val, i, arr)) {\n        res[resLength++] = val;\n      }\n    }\n  }\n  return res;\n};\ngoog.array.map = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l = arr.length;\n  var res = new Array(l);\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2) {\n      res[i] = f.call(opt_obj, arr2[i], i, arr);\n    }\n  }\n  return res;\n};\ngoog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  if (opt_obj) {\n    f = goog.bind(f, opt_obj);\n  }\n  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);\n} : function(arr, f, val, opt_obj) {\n  var rval = val;\n  goog.array.forEach(arr, function(val, index) {\n    rval = f.call(opt_obj, rval, val, index, arr);\n  });\n  return rval;\n};\ngoog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  if (opt_obj) {\n    f = goog.bind(f, opt_obj);\n  }\n  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);\n} : function(arr, f, val, opt_obj) {\n  var rval = val;\n  goog.array.forEachRight(arr, function(val, index) {\n    rval = f.call(opt_obj, rval, val, index, arr);\n  });\n  return rval;\n};\ngoog.array.some = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2 &amp;&amp; f.call(opt_obj, arr2[i], i, arr)) {\n      return true;\n    }\n  }\n  return false;\n};\ngoog.array.every = goog.NATIVE_ARRAY_PROTOTYPES &amp;&amp; (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);\n} : function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2 &amp;&amp; !f.call(opt_obj, arr2[i], i, arr)) {\n      return false;\n    }\n  }\n  return true;\n};\ngoog.array.count = function(arr, f, opt_obj) {\n  var count = 0;\n  goog.array.forEach(arr, function(element, index, arr) {\n    if (f.call(opt_obj, element, index, arr)) {\n      ++count;\n    }\n  }, opt_obj);\n  return count;\n};\ngoog.array.find = function(arr, f, opt_obj) {\n  var i = goog.array.findIndex(arr, f, opt_obj);\n  return i &lt; 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];\n};\ngoog.array.findIndex = function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = 0;i &lt; l;i++) {\n    if (i in arr2 &amp;&amp; f.call(opt_obj, arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return-1;\n};\ngoog.array.findRight = function(arr, f, opt_obj) {\n  var i = goog.array.findIndexRight(arr, f, opt_obj);\n  return i &lt; 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];\n};\ngoog.array.findIndexRight = function(arr, f, opt_obj) {\n  var l = arr.length;\n  var arr2 = goog.isString(arr) ? arr.split(&quot;&quot;) : arr;\n  for (var i = l - 1;i &gt;= 0;i--) {\n    if (i in arr2 &amp;&amp; f.call(opt_obj, arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return-1;\n};\ngoog.array.contains = function(arr, obj) {\n  return goog.array.indexOf(arr, obj) &gt;= 0;\n};\ngoog.array.isEmpty = function(arr) {\n  return arr.length == 0;\n};\ngoog.array.clear = function(arr) {\n  if (!goog.isArray(arr)) {\n    for (var i = arr.length - 1;i &gt;= 0;i--) {\n      delete arr[i];\n    }\n  }\n  arr.length = 0;\n};\ngoog.array.insert = function(arr, obj) {\n  if (!goog.array.contains(arr, obj)) {\n    arr.push(obj);\n  }\n};\ngoog.array.insertAt = function(arr, obj, opt_i) {\n  goog.array.splice(arr, opt_i, 0, obj);\n};\ngoog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {\n  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);\n};\ngoog.array.insertBefore = function(arr, obj, opt_obj2) {\n  var i;\n  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) &lt; 0) {\n    arr.push(obj);\n  } else {\n    goog.array.insertAt(arr, obj, i);\n  }\n};\ngoog.array.remove = function(arr, obj) {\n  var i = goog.array.indexOf(arr, obj);\n  var rv;\n  if (rv = i &gt;= 0) {\n    goog.array.removeAt(arr, i);\n  }\n  return rv;\n};\ngoog.array.removeAt = function(arr, i) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;\n};\ngoog.array.removeIf = function(arr, f, opt_obj) {\n  var i = goog.array.findIndex(arr, f, opt_obj);\n  if (i &gt;= 0) {\n    goog.array.removeAt(arr, i);\n    return true;\n  }\n  return false;\n};\ngoog.array.concat = function(var_args) {\n  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);\n};\ngoog.array.join = function(var_args) {\n  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);\n};\ngoog.array.toArray = function(object) {\n  var length = object.length;\n  if (length &gt; 0) {\n    var rv = new Array(length);\n    for (var i = 0;i &lt; length;i++) {\n      rv[i] = object[i];\n    }\n    return rv;\n  }\n  return[];\n};\ngoog.array.clone = goog.array.toArray;\ngoog.array.extend = function(arr1, var_args) {\n  for (var i = 1;i &lt; arguments.length;i++) {\n    var arr2 = arguments[i];\n    var isArrayLike;\n    if (goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) &amp;&amp; Object.prototype.hasOwnProperty.call(arr2, &quot;callee&quot;)) {\n      arr1.push.apply(arr1, arr2);\n    } else {\n      if (isArrayLike) {\n        var len1 = arr1.length;\n        var len2 = arr2.length;\n        for (var j = 0;j &lt; len2;j++) {\n          arr1[len1 + j] = arr2[j];\n        }\n      } else {\n        arr1.push(arr2);\n      }\n    }\n  }\n};\ngoog.array.splice = function(arr, index, howMany, var_args) {\n  goog.asserts.assert(arr.length != null);\n  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));\n};\ngoog.array.slice = function(arr, start, opt_end) {\n  goog.asserts.assert(arr.length != null);\n  if (arguments.length &lt;= 2) {\n    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);\n  } else {\n    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);\n  }\n};\ngoog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {\n  var returnArray = opt_rv || arr;\n  var defaultHashFn = function(item) {\n    return goog.isObject(current) ? &quot;o&quot; + goog.getUid(current) : (typeof current).charAt(0) + current;\n  };\n  var hashFn = opt_hashFn || defaultHashFn;\n  var seen = {}, cursorInsert = 0, cursorRead = 0;\n  while (cursorRead &lt; arr.length) {\n    var current = arr[cursorRead++];\n    var key = hashFn(current);\n    if (!Object.prototype.hasOwnProperty.call(seen, key)) {\n      seen[key] = true;\n      returnArray[cursorInsert++] = current;\n    }\n  }\n  returnArray.length = cursorInsert;\n};\ngoog.array.binarySearch = function(arr, target, opt_compareFn) {\n  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);\n};\ngoog.array.binarySelect = function(arr, evaluator, opt_obj) {\n  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);\n};\ngoog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {\n  var left = 0;\n  var right = arr.length;\n  var found;\n  while (left &lt; right) {\n    var middle = left + right &gt;&gt; 1;\n    var compareResult;\n    if (isEvaluator) {\n      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);\n    } else {\n      compareResult = compareFn(opt_target, arr[middle]);\n    }\n    if (compareResult &gt; 0) {\n      left = middle + 1;\n    } else {\n      right = middle;\n      found = !compareResult;\n    }\n  }\n  return found ? left : ~left;\n};\ngoog.array.sort = function(arr, opt_compareFn) {\n  arr.sort(opt_compareFn || goog.array.defaultCompare);\n};\ngoog.array.stableSort = function(arr, opt_compareFn) {\n  for (var i = 0;i &lt; arr.length;i++) {\n    arr[i] = {index:i, value:arr[i]};\n  }\n  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;\n  function stableCompareFn(obj1, obj2) {\n    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;\n  }\n  goog.array.sort(arr, stableCompareFn);\n  for (var i = 0;i &lt; arr.length;i++) {\n    arr[i] = arr[i].value;\n  }\n};\ngoog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {\n  var compare = opt_compareFn || goog.array.defaultCompare;\n  goog.array.sort(arr, function(a, b) {\n    return compare(a[key], b[key]);\n  });\n};\ngoog.array.isSorted = function(arr, opt_compareFn, opt_strict) {\n  var compare = opt_compareFn || goog.array.defaultCompare;\n  for (var i = 1;i &lt; arr.length;i++) {\n    var compareResult = compare(arr[i - 1], arr[i]);\n    if (compareResult &gt; 0 || compareResult == 0 &amp;&amp; opt_strict) {\n      return false;\n    }\n  }\n  return true;\n};\ngoog.array.equals = function(arr1, arr2, opt_equalsFn) {\n  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {\n    return false;\n  }\n  var l = arr1.length;\n  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;\n  for (var i = 0;i &lt; l;i++) {\n    if (!equalsFn(arr1[i], arr2[i])) {\n      return false;\n    }\n  }\n  return true;\n};\ngoog.array.compare3 = function(arr1, arr2, opt_compareFn) {\n  var compare = opt_compareFn || goog.array.defaultCompare;\n  var l = Math.min(arr1.length, arr2.length);\n  for (var i = 0;i &lt; l;i++) {\n    var result = compare(arr1[i], arr2[i]);\n    if (result != 0) {\n      return result;\n    }\n  }\n  return goog.array.defaultCompare(arr1.length, arr2.length);\n};\ngoog.array.defaultCompare = function(a, b) {\n  return a &gt; b ? 1 : a &lt; b ? -1 : 0;\n};\ngoog.array.defaultCompareEquality = function(a, b) {\n  return a === b;\n};\ngoog.array.binaryInsert = function(array, value, opt_compareFn) {\n  var index = goog.array.binarySearch(array, value, opt_compareFn);\n  if (index &lt; 0) {\n    goog.array.insertAt(array, value, -(index + 1));\n    return true;\n  }\n  return false;\n};\ngoog.array.binaryRemove = function(array, value, opt_compareFn) {\n  var index = goog.array.binarySearch(array, value, opt_compareFn);\n  return index &gt;= 0 ? goog.array.removeAt(array, index) : false;\n};\ngoog.array.bucket = function(array, sorter, opt_obj) {\n  var buckets = {};\n  for (var i = 0;i &lt; array.length;i++) {\n    var value = array[i];\n    var key = sorter.call(opt_obj, value, i, array);\n    if (goog.isDef(key)) {\n      var bucket = buckets[key] || (buckets[key] = []);\n      bucket.push(value);\n    }\n  }\n  return buckets;\n};\ngoog.array.toObject = function(arr, keyFunc, opt_obj) {\n  var ret = {};\n  goog.array.forEach(arr, function(element, index) {\n    ret[keyFunc.call(opt_obj, element, index, arr)] = element;\n  });\n  return ret;\n};\ngoog.array.range = function(startOrEnd, opt_end, opt_step) {\n  var array = [];\n  var start = 0;\n  var end = startOrEnd;\n  var step = opt_step || 1;\n  if (opt_end !== undefined) {\n    start = startOrEnd;\n    end = opt_end;\n  }\n  if (step * (end - start) &lt; 0) {\n    return[];\n  }\n  if (step &gt; 0) {\n    for (var i = start;i &lt; end;i += step) {\n      array.push(i);\n    }\n  } else {\n    for (var i = start;i &gt; end;i += step) {\n      array.push(i);\n    }\n  }\n  return array;\n};\ngoog.array.repeat = function(value, n) {\n  var array = [];\n  for (var i = 0;i &lt; n;i++) {\n    array[i] = value;\n  }\n  return array;\n};\ngoog.array.flatten = function(var_args) {\n  var result = [];\n  for (var i = 0;i &lt; arguments.length;i++) {\n    var element = arguments[i];\n    if (goog.isArray(element)) {\n      result.push.apply(result, goog.array.flatten.apply(null, element));\n    } else {\n      result.push(element);\n    }\n  }\n  return result;\n};\ngoog.array.rotate = function(array, n) {\n  goog.asserts.assert(array.length != null);\n  if (array.length) {\n    n %= array.length;\n    if (n &gt; 0) {\n      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));\n    } else {\n      if (n &lt; 0) {\n        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));\n      }\n    }\n  }\n  return array;\n};\ngoog.array.moveItem = function(arr, fromIndex, toIndex) {\n  goog.asserts.assert(fromIndex &gt;= 0 &amp;&amp; fromIndex &lt; arr.length);\n  goog.asserts.assert(toIndex &gt;= 0 &amp;&amp; toIndex &lt; arr.length);\n  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);\n  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);\n};\ngoog.array.zip = function(var_args) {\n  if (!arguments.length) {\n    return[];\n  }\n  var result = [];\n  for (var i = 0;true;i++) {\n    var value = [];\n    for (var j = 0;j &lt; arguments.length;j++) {\n      var arr = arguments[j];\n      if (i &gt;= arr.length) {\n        return result;\n      }\n      value.push(arr[i]);\n    }\n    result.push(value);\n  }\n};\ngoog.array.shuffle = function(arr, opt_randFn) {\n  var randFn = opt_randFn || Math.random;\n  for (var i = arr.length - 1;i &gt; 0;i--) {\n    var j = Math.floor(randFn() * (i + 1));\n    var tmp = arr[i];\n    arr[i] = arr[j];\n    arr[j] = tmp;\n  }\n};\ngoog.provide(&quot;cljs.core&quot;);\ngoog.require(&quot;goog.string.StringBuffer&quot;);\ngoog.require(&quot;goog.array&quot;);\ngoog.require(&quot;goog.array&quot;);\ngoog.require(&quot;goog.object&quot;);\ngoog.require(&quot;goog.object&quot;);\ngoog.require(&quot;goog.string&quot;);\ngoog.require(&quot;goog.string&quot;);\ncljs.core._STAR_clojurescript_version_STAR_ = &quot;0.0-2322&quot;;\ncljs.core._STAR_unchecked_if_STAR_ = false;\ncljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {\n  throw new Error(&quot;No *print-fn* fn set for evaluation environment&quot;);\n};\ncljs.core.set_print_fn_BANG_ = function set_print_fn_BANG_(f) {\n  return cljs.core._STAR_print_fn_STAR_ = f;\n};\ncljs.core._STAR_flush_on_newline_STAR_ = true;\ncljs.core._STAR_print_newline_STAR_ = true;\ncljs.core._STAR_print_readably_STAR_ = true;\ncljs.core._STAR_print_meta_STAR_ = false;\ncljs.core._STAR_print_dup_STAR_ = false;\ncljs.core._STAR_print_length_STAR_ = null;\ncljs.core._STAR_print_level_STAR_ = null;\ncljs.core.pr_opts = function pr_opts() {\n  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, &quot;flush-on-newline&quot;, &quot;flush-on-newline&quot;, -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, &quot;readably&quot;, &quot;readably&quot;, 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, &quot;meta&quot;, &quot;meta&quot;, 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, &quot;dup&quot;, &quot;dup&quot;, 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, &quot;print-length&quot;, &quot;print-length&quot;, \n  1931866356), cljs.core._STAR_print_length_STAR_], null);\n};\ncljs.core.enable_console_print_BANG_ = function enable_console_print_BANG_() {\n  cljs.core._STAR_print_newline_STAR_ = false;\n  return cljs.core._STAR_print_fn_STAR_ = function() {\n    var G__32291__delegate = function(args) {\n      return console.log.apply(console, cljs.core.into_array.call(null, args));\n    };\n    var G__32291 = function(var_args) {\n      var args = null;\n      if (arguments.length &gt; 0) {\n        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0);\n      }\n      return G__32291__delegate.call(this, args);\n    };\n    G__32291.cljs$lang$maxFixedArity = 0;\n    G__32291.cljs$lang$applyTo = function(arglist__32292) {\n      var args = cljs.core.seq(arglist__32292);\n      return G__32291__delegate(args);\n    };\n    G__32291.cljs$core$IFn$_invoke$arity$variadic = G__32291__delegate;\n    return G__32291;\n  }();\n};\ncljs.core.truth_ = function truth_(x) {\n  return x != null &amp;&amp; x !== false;\n};\ncljs.core.not_native = null;\ncljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {\n  return x === y;\n};\ncljs.core.nil_QMARK_ = function nil_QMARK_(x) {\n  return x == null;\n};\ncljs.core.array_QMARK_ = function array_QMARK_(x) {\n  return x instanceof Array;\n};\ncljs.core.number_QMARK_ = function number_QMARK_(n) {\n  return typeof n === &quot;number&quot;;\n};\ncljs.core.not = function not(x) {\n  if (cljs.core.truth_(x)) {\n    return false;\n  } else {\n    return true;\n  }\n};\ncljs.core.some_QMARK_ = function some_QMARK_(x) {\n  return!(x == null);\n};\ncljs.core.object_QMARK_ = function object_QMARK_(x) {\n  if (!(x == null)) {\n    return x.constructor === Object;\n  } else {\n    return false;\n  }\n};\ncljs.core.string_QMARK_ = function string_QMARK_(x) {\n  return goog.isString(x);\n};\ncljs.core.native_satisfies_QMARK_ = function native_satisfies_QMARK_(p, x) {\n  var x__$1 = x == null ? null : x;\n  if (p[goog.typeOf(x__$1)]) {\n    return true;\n  } else {\n    if (p[&quot;_&quot;]) {\n      return true;\n    } else {\n      return false;\n    }\n  }\n};\ncljs.core.is_proto_ = function is_proto_(x) {\n  return x.constructor.prototype === x;\n};\ncljs.core._STAR_main_cli_fn_STAR_ = null;\ncljs.core.type = function type(x) {\n  if (x == null) {\n    return null;\n  } else {\n    return x.constructor;\n  }\n};\ncljs.core.missing_protocol = function missing_protocol(proto, obj) {\n  var ty = cljs.core.type.call(null, obj);\n  var ty__$1 = cljs.core.truth_(function() {\n    var and__26159__auto__ = ty;\n    if (cljs.core.truth_(and__26159__auto__)) {\n      return ty.cljs$lang$type;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);\n  return new Error([&quot;No protocol method &quot;, proto, &quot; defined for type &quot;, ty__$1, &quot;: &quot;, obj].join(&quot;&quot;));\n};\ncljs.core.type__GT_str = function type__GT_str(ty) {\n  var temp__4124__auto__ = ty.cljs$lang$ctorStr;\n  if (cljs.core.truth_(temp__4124__auto__)) {\n    var s = temp__4124__auto__;\n    return s;\n  } else {\n    return &quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);\n  }\n};\ncljs.core.make_array = function() {\n  var make_array = null;\n  var make_array__1 = function(size) {\n    return new Array(size);\n  };\n  var make_array__2 = function(type, size) {\n    return make_array.call(null, size);\n  };\n  make_array = function(type, size) {\n    switch(arguments.length) {\n      case 1:\n        return make_array__1.call(this, type);\n      case 2:\n        return make_array__2.call(this, type, size);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  make_array.cljs$core$IFn$_invoke$arity$1 = make_array__1;\n  make_array.cljs$core$IFn$_invoke$arity$2 = make_array__2;\n  return make_array;\n}();\ncljs.core.aclone = function aclone(arr) {\n  var len = arr.length;\n  var new_arr = new Array(len);\n  var n__27027__auto___32293 = len;\n  var i_32294 = 0;\n  while (true) {\n    if (i_32294 &lt; n__27027__auto___32293) {\n      new_arr[i_32294] = arr[i_32294];\n      var G__32295 = i_32294 + 1;\n      i_32294 = G__32295;\n      continue;\n    } else {\n    }\n    break;\n  }\n  return new_arr;\n};\ncljs.core.array = function array(var_args) {\n  return Array.prototype.slice.call(arguments);\n};\ncljs.core.aget = function() {\n  var aget = null;\n  var aget__2 = function(array, i) {\n    return array[i];\n  };\n  var aget__3 = function() {\n    var G__32296__delegate = function(array, i, idxs) {\n      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs);\n    };\n    var G__32296 = function(array, i, var_args) {\n      var idxs = null;\n      if (arguments.length &gt; 2) {\n        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32296__delegate.call(this, array, i, idxs);\n    };\n    G__32296.cljs$lang$maxFixedArity = 2;\n    G__32296.cljs$lang$applyTo = function(arglist__32297) {\n      var array = cljs.core.first(arglist__32297);\n      arglist__32297 = cljs.core.next(arglist__32297);\n      var i = cljs.core.first(arglist__32297);\n      var idxs = cljs.core.rest(arglist__32297);\n      return G__32296__delegate(array, i, idxs);\n    };\n    G__32296.cljs$core$IFn$_invoke$arity$variadic = G__32296__delegate;\n    return G__32296;\n  }();\n  aget = function(array, i, var_args) {\n    var idxs = var_args;\n    switch(arguments.length) {\n      case 2:\n        return aget__2.call(this, array, i);\n      default:\n        return aget__3.cljs$core$IFn$_invoke$arity$variadic(array, i, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  aget.cljs$lang$maxFixedArity = 2;\n  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;\n  aget.cljs$core$IFn$_invoke$arity$2 = aget__2;\n  aget.cljs$core$IFn$_invoke$arity$variadic = aget__3.cljs$core$IFn$_invoke$arity$variadic;\n  return aget;\n}();\ncljs.core.aset = function() {\n  var aset = null;\n  var aset__3 = function(array, i, val) {\n    return array[i] = val;\n  };\n  var aset__4 = function() {\n    var G__32298__delegate = function(array, idx, idx2, idxv) {\n      return cljs.core.apply.call(null, aset, array[idx], idx2, idxv);\n    };\n    var G__32298 = function(array, idx, idx2, var_args) {\n      var idxv = null;\n      if (arguments.length &gt; 3) {\n        idxv = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0);\n      }\n      return G__32298__delegate.call(this, array, idx, idx2, idxv);\n    };\n    G__32298.cljs$lang$maxFixedArity = 3;\n    G__32298.cljs$lang$applyTo = function(arglist__32299) {\n      var array = cljs.core.first(arglist__32299);\n      arglist__32299 = cljs.core.next(arglist__32299);\n      var idx = cljs.core.first(arglist__32299);\n      arglist__32299 = cljs.core.next(arglist__32299);\n      var idx2 = cljs.core.first(arglist__32299);\n      var idxv = cljs.core.rest(arglist__32299);\n      return G__32298__delegate(array, idx, idx2, idxv);\n    };\n    G__32298.cljs$core$IFn$_invoke$arity$variadic = G__32298__delegate;\n    return G__32298;\n  }();\n  aset = function(array, idx, idx2, var_args) {\n    var idxv = var_args;\n    switch(arguments.length) {\n      case 3:\n        return aset__3.call(this, array, idx, idx2);\n      default:\n        return aset__4.cljs$core$IFn$_invoke$arity$variadic(array, idx, idx2, cljs.core.array_seq(arguments, 3));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  aset.cljs$lang$maxFixedArity = 3;\n  aset.cljs$lang$applyTo = aset__4.cljs$lang$applyTo;\n  aset.cljs$core$IFn$_invoke$arity$3 = aset__3;\n  aset.cljs$core$IFn$_invoke$arity$variadic = aset__4.cljs$core$IFn$_invoke$arity$variadic;\n  return aset;\n}();\ncljs.core.alength = function alength(array) {\n  return array.length;\n};\ncljs.core.into_array = function() {\n  var into_array = null;\n  var into_array__1 = function(aseq) {\n    return into_array.call(null, null, aseq);\n  };\n  var into_array__2 = function(type, aseq) {\n    return cljs.core.reduce.call(null, function(a, x) {\n      a.push(x);\n      return a;\n    }, [], aseq);\n  };\n  into_array = function(type, aseq) {\n    switch(arguments.length) {\n      case 1:\n        return into_array__1.call(this, type);\n      case 2:\n        return into_array__2.call(this, type, aseq);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  into_array.cljs$core$IFn$_invoke$arity$1 = into_array__1;\n  into_array.cljs$core$IFn$_invoke$arity$2 = into_array__2;\n  return into_array;\n}();\ncljs.core.Fn = function() {\n  var obj32301 = {};\n  return obj32301;\n}();\ncljs.core.IFn = function() {\n  var obj32303 = {};\n  return obj32303;\n}();\ncljs.core._invoke = function() {\n  var _invoke = null;\n  var _invoke__1 = function(this$) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$1;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$1(this$);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$);\n    }\n  };\n  var _invoke__2 = function(this$, a) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$2;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$2(this$, a);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a);\n    }\n  };\n  var _invoke__3 = function(this$, a, b) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$3;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b);\n    }\n  };\n  var _invoke__4 = function(this$, a, b, c) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$4;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c);\n    }\n  };\n  var _invoke__5 = function(this$, a, b, c, d) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$5;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d);\n    }\n  };\n  var _invoke__6 = function(this$, a, b, c, d, e) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$6;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e);\n    }\n  };\n  var _invoke__7 = function(this$, a, b, c, d, e, f) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$7;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f);\n    }\n  };\n  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$8;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g);\n    }\n  };\n  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$9;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h);\n    }\n  };\n  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$10;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i);\n    }\n  };\n  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$11;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j);\n    }\n  };\n  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$12;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k);\n    }\n  };\n  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$13;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);\n    }\n  };\n  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$14;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);\n    }\n  };\n  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$15;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n    }\n  };\n  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$16;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n    }\n  };\n  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$17;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n    }\n  };\n  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$18;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n    }\n  };\n  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$19;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);\n    }\n  };\n  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$20;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);\n    }\n  };\n  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {\n    if (function() {\n      var and__26159__auto__ = this$;\n      if (and__26159__auto__) {\n        return this$.cljs$core$IFn$_invoke$arity$21;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest);\n    } else {\n      var x__26798__auto__ = this$ == null ? null : this$;\n      return function() {\n        var or__26171__auto__ = cljs.core._invoke[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._invoke[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IFn.-invoke&quot;, this$);\n          }\n        }\n      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest);\n    }\n  };\n  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {\n    switch(arguments.length) {\n      case 1:\n        return _invoke__1.call(this, this$);\n      case 2:\n        return _invoke__2.call(this, this$, a);\n      case 3:\n        return _invoke__3.call(this, this$, a, b);\n      case 4:\n        return _invoke__4.call(this, this$, a, b, c);\n      case 5:\n        return _invoke__5.call(this, this$, a, b, c, d);\n      case 6:\n        return _invoke__6.call(this, this$, a, b, c, d, e);\n      case 7:\n        return _invoke__7.call(this, this$, a, b, c, d, e, f);\n      case 8:\n        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);\n      case 9:\n        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);\n      case 10:\n        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);\n      case 11:\n        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);\n      case 12:\n        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);\n      case 13:\n        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);\n      case 14:\n        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);\n      case 15:\n        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n      case 16:\n        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n      case 17:\n        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n      case 18:\n        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n      case 19:\n        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);\n      case 20:\n        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);\n      case 21:\n        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _invoke.cljs$core$IFn$_invoke$arity$1 = _invoke__1;\n  _invoke.cljs$core$IFn$_invoke$arity$2 = _invoke__2;\n  _invoke.cljs$core$IFn$_invoke$arity$3 = _invoke__3;\n  _invoke.cljs$core$IFn$_invoke$arity$4 = _invoke__4;\n  _invoke.cljs$core$IFn$_invoke$arity$5 = _invoke__5;\n  _invoke.cljs$core$IFn$_invoke$arity$6 = _invoke__6;\n  _invoke.cljs$core$IFn$_invoke$arity$7 = _invoke__7;\n  _invoke.cljs$core$IFn$_invoke$arity$8 = _invoke__8;\n  _invoke.cljs$core$IFn$_invoke$arity$9 = _invoke__9;\n  _invoke.cljs$core$IFn$_invoke$arity$10 = _invoke__10;\n  _invoke.cljs$core$IFn$_invoke$arity$11 = _invoke__11;\n  _invoke.cljs$core$IFn$_invoke$arity$12 = _invoke__12;\n  _invoke.cljs$core$IFn$_invoke$arity$13 = _invoke__13;\n  _invoke.cljs$core$IFn$_invoke$arity$14 = _invoke__14;\n  _invoke.cljs$core$IFn$_invoke$arity$15 = _invoke__15;\n  _invoke.cljs$core$IFn$_invoke$arity$16 = _invoke__16;\n  _invoke.cljs$core$IFn$_invoke$arity$17 = _invoke__17;\n  _invoke.cljs$core$IFn$_invoke$arity$18 = _invoke__18;\n  _invoke.cljs$core$IFn$_invoke$arity$19 = _invoke__19;\n  _invoke.cljs$core$IFn$_invoke$arity$20 = _invoke__20;\n  _invoke.cljs$core$IFn$_invoke$arity$21 = _invoke__21;\n  return _invoke;\n}();\ncljs.core.ICloneable = function() {\n  var obj32305 = {};\n  return obj32305;\n}();\ncljs.core._clone = function _clone(value) {\n  if (function() {\n    var and__26159__auto__ = value;\n    if (and__26159__auto__) {\n      return value.cljs$core$ICloneable$_clone$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return value.cljs$core$ICloneable$_clone$arity$1(value);\n  } else {\n    var x__26798__auto__ = value == null ? null : value;\n    return function() {\n      var or__26171__auto__ = cljs.core._clone[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._clone[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ICloneable.-clone&quot;, value);\n        }\n      }\n    }().call(null, value);\n  }\n};\ncljs.core.ICounted = function() {\n  var obj32307 = {};\n  return obj32307;\n}();\ncljs.core._count = function _count(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ICounted$_count$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ICounted$_count$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._count[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._count[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ICounted.-count&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.IEmptyableCollection = function() {\n  var obj32309 = {};\n  return obj32309;\n}();\ncljs.core._empty = function _empty(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IEmptyableCollection$_empty$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._empty[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._empty[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IEmptyableCollection.-empty&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.ICollection = function() {\n  var obj32311 = {};\n  return obj32311;\n}();\ncljs.core._conj = function _conj(coll, o) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ICollection$_conj$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._conj[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._conj[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ICollection.-conj&quot;, coll);\n        }\n      }\n    }().call(null, coll, o);\n  }\n};\ncljs.core.IIndexed = function() {\n  var obj32313 = {};\n  return obj32313;\n}();\ncljs.core._nth = function() {\n  var _nth = null;\n  var _nth__2 = function(coll, n) {\n    if (function() {\n      var and__26159__auto__ = coll;\n      if (and__26159__auto__) {\n        return coll.cljs$core$IIndexed$_nth$arity$2;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);\n    } else {\n      var x__26798__auto__ = coll == null ? null : coll;\n      return function() {\n        var or__26171__auto__ = cljs.core._nth[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._nth[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IIndexed.-nth&quot;, coll);\n          }\n        }\n      }().call(null, coll, n);\n    }\n  };\n  var _nth__3 = function(coll, n, not_found) {\n    if (function() {\n      var and__26159__auto__ = coll;\n      if (and__26159__auto__) {\n        return coll.cljs$core$IIndexed$_nth$arity$3;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);\n    } else {\n      var x__26798__auto__ = coll == null ? null : coll;\n      return function() {\n        var or__26171__auto__ = cljs.core._nth[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._nth[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IIndexed.-nth&quot;, coll);\n          }\n        }\n      }().call(null, coll, n, not_found);\n    }\n  };\n  _nth = function(coll, n, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return _nth__2.call(this, coll, n);\n      case 3:\n        return _nth__3.call(this, coll, n, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _nth.cljs$core$IFn$_invoke$arity$2 = _nth__2;\n  _nth.cljs$core$IFn$_invoke$arity$3 = _nth__3;\n  return _nth;\n}();\ncljs.core.ASeq = function() {\n  var obj32315 = {};\n  return obj32315;\n}();\ncljs.core.ISeq = function() {\n  var obj32317 = {};\n  return obj32317;\n}();\ncljs.core._first = function _first(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISeq$_first$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISeq$_first$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._first[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._first[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISeq.-first&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core._rest = function _rest(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISeq$_rest$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISeq$_rest$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._rest[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._rest[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISeq.-rest&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.INext = function() {\n  var obj32319 = {};\n  return obj32319;\n}();\ncljs.core._next = function _next(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$INext$_next$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$INext$_next$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._next[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._next[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;INext.-next&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.ILookup = function() {\n  var obj32321 = {};\n  return obj32321;\n}();\ncljs.core._lookup = function() {\n  var _lookup = null;\n  var _lookup__2 = function(o, k) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ILookup$_lookup$arity$2;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ILookup$_lookup$arity$2(o, k);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._lookup[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._lookup[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ILookup.-lookup&quot;, o);\n          }\n        }\n      }().call(null, o, k);\n    }\n  };\n  var _lookup__3 = function(o, k, not_found) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ILookup$_lookup$arity$3;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._lookup[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._lookup[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ILookup.-lookup&quot;, o);\n          }\n        }\n      }().call(null, o, k, not_found);\n    }\n  };\n  _lookup = function(o, k, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return _lookup__2.call(this, o, k);\n      case 3:\n        return _lookup__3.call(this, o, k, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _lookup.cljs$core$IFn$_invoke$arity$2 = _lookup__2;\n  _lookup.cljs$core$IFn$_invoke$arity$3 = _lookup__3;\n  return _lookup;\n}();\ncljs.core.IAssociative = function() {\n  var obj32323 = {};\n  return obj32323;\n}();\ncljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._contains_key_QMARK_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IAssociative.-contains-key?&quot;, coll);\n        }\n      }\n    }().call(null, coll, k);\n  }\n};\ncljs.core._assoc = function _assoc(coll, k, v) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IAssociative$_assoc$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._assoc[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._assoc[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IAssociative.-assoc&quot;, coll);\n        }\n      }\n    }().call(null, coll, k, v);\n  }\n};\ncljs.core.IMap = function() {\n  var obj32325 = {};\n  return obj32325;\n}();\ncljs.core._dissoc = function _dissoc(coll, k) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IMap$_dissoc$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._dissoc[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._dissoc[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IMap.-dissoc&quot;, coll);\n        }\n      }\n    }().call(null, coll, k);\n  }\n};\ncljs.core.IMapEntry = function() {\n  var obj32327 = {};\n  return obj32327;\n}();\ncljs.core._key = function _key(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IMapEntry$_key$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IMapEntry$_key$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._key[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._key[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IMapEntry.-key&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core._val = function _val(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IMapEntry$_val$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IMapEntry$_val$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._val[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._val[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IMapEntry.-val&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.ISet = function() {\n  var obj32329 = {};\n  return obj32329;\n}();\ncljs.core._disjoin = function _disjoin(coll, v) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISet$_disjoin$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._disjoin[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._disjoin[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISet.-disjoin&quot;, coll);\n        }\n      }\n    }().call(null, coll, v);\n  }\n};\ncljs.core.IStack = function() {\n  var obj32331 = {};\n  return obj32331;\n}();\ncljs.core._peek = function _peek(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IStack$_peek$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IStack$_peek$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._peek[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._peek[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IStack.-peek&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core._pop = function _pop(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IStack$_pop$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IStack$_pop$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._pop[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._pop[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IStack.-pop&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.IVector = function() {\n  var obj32333 = {};\n  return obj32333;\n}();\ncljs.core._assoc_n = function _assoc_n(coll, n, val) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IVector$_assoc_n$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._assoc_n[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._assoc_n[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IVector.-assoc-n&quot;, coll);\n        }\n      }\n    }().call(null, coll, n, val);\n  }\n};\ncljs.core.IDeref = function() {\n  var obj32335 = {};\n  return obj32335;\n}();\ncljs.core._deref = function _deref(o) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IDeref$_deref$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IDeref$_deref$arity$1(o);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._deref[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._deref[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IDeref.-deref&quot;, o);\n        }\n      }\n    }().call(null, o);\n  }\n};\ncljs.core.IDerefWithTimeout = function() {\n  var obj32337 = {};\n  return obj32337;\n}();\ncljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._deref_with_timeout[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IDerefWithTimeout.-deref-with-timeout&quot;, o);\n        }\n      }\n    }().call(null, o, msec, timeout_val);\n  }\n};\ncljs.core.IMeta = function() {\n  var obj32339 = {};\n  return obj32339;\n}();\ncljs.core._meta = function _meta(o) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IMeta$_meta$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IMeta$_meta$arity$1(o);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._meta[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._meta[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IMeta.-meta&quot;, o);\n        }\n      }\n    }().call(null, o);\n  }\n};\ncljs.core.IWithMeta = function() {\n  var obj32341 = {};\n  return obj32341;\n}();\ncljs.core._with_meta = function _with_meta(o, meta) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IWithMeta$_with_meta$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._with_meta[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._with_meta[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWithMeta.-with-meta&quot;, o);\n        }\n      }\n    }().call(null, o, meta);\n  }\n};\ncljs.core.IReduce = function() {\n  var obj32343 = {};\n  return obj32343;\n}();\ncljs.core._reduce = function() {\n  var _reduce = null;\n  var _reduce__2 = function(coll, f) {\n    if (function() {\n      var and__26159__auto__ = coll;\n      if (and__26159__auto__) {\n        return coll.cljs$core$IReduce$_reduce$arity$2;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);\n    } else {\n      var x__26798__auto__ = coll == null ? null : coll;\n      return function() {\n        var or__26171__auto__ = cljs.core._reduce[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._reduce[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IReduce.-reduce&quot;, coll);\n          }\n        }\n      }().call(null, coll, f);\n    }\n  };\n  var _reduce__3 = function(coll, f, start) {\n    if (function() {\n      var and__26159__auto__ = coll;\n      if (and__26159__auto__) {\n        return coll.cljs$core$IReduce$_reduce$arity$3;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);\n    } else {\n      var x__26798__auto__ = coll == null ? null : coll;\n      return function() {\n        var or__26171__auto__ = cljs.core._reduce[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._reduce[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;IReduce.-reduce&quot;, coll);\n          }\n        }\n      }().call(null, coll, f, start);\n    }\n  };\n  _reduce = function(coll, f, start) {\n    switch(arguments.length) {\n      case 2:\n        return _reduce__2.call(this, coll, f);\n      case 3:\n        return _reduce__3.call(this, coll, f, start);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _reduce.cljs$core$IFn$_invoke$arity$2 = _reduce__2;\n  _reduce.cljs$core$IFn$_invoke$arity$3 = _reduce__3;\n  return _reduce;\n}();\ncljs.core.IKVReduce = function() {\n  var obj32345 = {};\n  return obj32345;\n}();\ncljs.core._kv_reduce = function _kv_reduce(coll, f, init) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._kv_reduce[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._kv_reduce[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IKVReduce.-kv-reduce&quot;, coll);\n        }\n      }\n    }().call(null, coll, f, init);\n  }\n};\ncljs.core.IEquiv = function() {\n  var obj32347 = {};\n  return obj32347;\n}();\ncljs.core._equiv = function _equiv(o, other) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IEquiv$_equiv$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._equiv[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._equiv[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IEquiv.-equiv&quot;, o);\n        }\n      }\n    }().call(null, o, other);\n  }\n};\ncljs.core.IHash = function() {\n  var obj32349 = {};\n  return obj32349;\n}();\ncljs.core._hash = function _hash(o) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IHash$_hash$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IHash$_hash$arity$1(o);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._hash[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._hash[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IHash.-hash&quot;, o);\n        }\n      }\n    }().call(null, o);\n  }\n};\ncljs.core.ISeqable = function() {\n  var obj32351 = {};\n  return obj32351;\n}();\ncljs.core._seq = function _seq(o) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$ISeqable$_seq$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$ISeqable$_seq$arity$1(o);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._seq[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._seq[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISeqable.-seq&quot;, o);\n        }\n      }\n    }().call(null, o);\n  }\n};\ncljs.core.ISequential = function() {\n  var obj32353 = {};\n  return obj32353;\n}();\ncljs.core.IList = function() {\n  var obj32355 = {};\n  return obj32355;\n}();\ncljs.core.IRecord = function() {\n  var obj32357 = {};\n  return obj32357;\n}();\ncljs.core.IReversible = function() {\n  var obj32359 = {};\n  return obj32359;\n}();\ncljs.core._rseq = function _rseq(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IReversible$_rseq$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IReversible$_rseq$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._rseq[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._rseq[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IReversible.-rseq&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.ISorted = function() {\n  var obj32361 = {};\n  return obj32361;\n}();\ncljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISorted$_sorted_seq$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._sorted_seq[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._sorted_seq[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISorted.-sorted-seq&quot;, coll);\n        }\n      }\n    }().call(null, coll, ascending_QMARK_);\n  }\n};\ncljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._sorted_seq_from[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISorted.-sorted-seq-from&quot;, coll);\n        }\n      }\n    }().call(null, coll, k, ascending_QMARK_);\n  }\n};\ncljs.core._entry_key = function _entry_key(coll, entry) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISorted$_entry_key$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._entry_key[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._entry_key[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISorted.-entry-key&quot;, coll);\n        }\n      }\n    }().call(null, coll, entry);\n  }\n};\ncljs.core._comparator = function _comparator(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$ISorted$_comparator$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$ISorted$_comparator$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._comparator[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._comparator[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ISorted.-comparator&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.IWriter = function() {\n  var obj32363 = {};\n  return obj32363;\n}();\ncljs.core._write = function _write(writer, s) {\n  if (function() {\n    var and__26159__auto__ = writer;\n    if (and__26159__auto__) {\n      return writer.cljs$core$IWriter$_write$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return writer.cljs$core$IWriter$_write$arity$2(writer, s);\n  } else {\n    var x__26798__auto__ = writer == null ? null : writer;\n    return function() {\n      var or__26171__auto__ = cljs.core._write[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._write[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWriter.-write&quot;, writer);\n        }\n      }\n    }().call(null, writer, s);\n  }\n};\ncljs.core._flush = function _flush(writer) {\n  if (function() {\n    var and__26159__auto__ = writer;\n    if (and__26159__auto__) {\n      return writer.cljs$core$IWriter$_flush$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return writer.cljs$core$IWriter$_flush$arity$1(writer);\n  } else {\n    var x__26798__auto__ = writer == null ? null : writer;\n    return function() {\n      var or__26171__auto__ = cljs.core._flush[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._flush[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWriter.-flush&quot;, writer);\n        }\n      }\n    }().call(null, writer);\n  }\n};\ncljs.core.IPrintWithWriter = function() {\n  var obj32365 = {};\n  return obj32365;\n}();\ncljs.core._pr_writer = function _pr_writer(o, writer, opts) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._pr_writer[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._pr_writer[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IPrintWithWriter.-pr-writer&quot;, o);\n        }\n      }\n    }().call(null, o, writer, opts);\n  }\n};\ncljs.core.IPending = function() {\n  var obj32367 = {};\n  return obj32367;\n}();\ncljs.core._realized_QMARK_ = function _realized_QMARK_(d) {\n  if (function() {\n    var and__26159__auto__ = d;\n    if (and__26159__auto__) {\n      return d.cljs$core$IPending$_realized_QMARK_$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);\n  } else {\n    var x__26798__auto__ = d == null ? null : d;\n    return function() {\n      var or__26171__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._realized_QMARK_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IPending.-realized?&quot;, d);\n        }\n      }\n    }().call(null, d);\n  }\n};\ncljs.core.IWatchable = function() {\n  var obj32369 = {};\n  return obj32369;\n}();\ncljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {\n  if (function() {\n    var and__26159__auto__ = this$;\n    if (and__26159__auto__) {\n      return this$.cljs$core$IWatchable$_notify_watches$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);\n  } else {\n    var x__26798__auto__ = this$ == null ? null : this$;\n    return function() {\n      var or__26171__auto__ = cljs.core._notify_watches[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._notify_watches[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWatchable.-notify-watches&quot;, this$);\n        }\n      }\n    }().call(null, this$, oldval, newval);\n  }\n};\ncljs.core._add_watch = function _add_watch(this$, key, f) {\n  if (function() {\n    var and__26159__auto__ = this$;\n    if (and__26159__auto__) {\n      return this$.cljs$core$IWatchable$_add_watch$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);\n  } else {\n    var x__26798__auto__ = this$ == null ? null : this$;\n    return function() {\n      var or__26171__auto__ = cljs.core._add_watch[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._add_watch[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWatchable.-add-watch&quot;, this$);\n        }\n      }\n    }().call(null, this$, key, f);\n  }\n};\ncljs.core._remove_watch = function _remove_watch(this$, key) {\n  if (function() {\n    var and__26159__auto__ = this$;\n    if (and__26159__auto__) {\n      return this$.cljs$core$IWatchable$_remove_watch$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);\n  } else {\n    var x__26798__auto__ = this$ == null ? null : this$;\n    return function() {\n      var or__26171__auto__ = cljs.core._remove_watch[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._remove_watch[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IWatchable.-remove-watch&quot;, this$);\n        }\n      }\n    }().call(null, this$, key);\n  }\n};\ncljs.core.IEditableCollection = function() {\n  var obj32371 = {};\n  return obj32371;\n}();\ncljs.core._as_transient = function _as_transient(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IEditableCollection$_as_transient$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._as_transient[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._as_transient[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IEditableCollection.-as-transient&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.ITransientCollection = function() {\n  var obj32373 = {};\n  return obj32373;\n}();\ncljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._conj_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientCollection.-conj!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll, val);\n  }\n};\ncljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._persistent_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientCollection.-persistent!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll);\n  }\n};\ncljs.core.ITransientAssociative = function() {\n  var obj32375 = {};\n  return obj32375;\n}();\ncljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._assoc_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientAssociative.-assoc!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll, key, val);\n  }\n};\ncljs.core.ITransientMap = function() {\n  var obj32377 = {};\n  return obj32377;\n}();\ncljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._dissoc_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientMap.-dissoc!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll, key);\n  }\n};\ncljs.core.ITransientVector = function() {\n  var obj32379 = {};\n  return obj32379;\n}();\ncljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._assoc_n_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientVector.-assoc-n!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll, n, val);\n  }\n};\ncljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._pop_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientVector.-pop!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll);\n  }\n};\ncljs.core.ITransientSet = function() {\n  var obj32381 = {};\n  return obj32381;\n}();\ncljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {\n  if (function() {\n    var and__26159__auto__ = tcoll;\n    if (and__26159__auto__) {\n      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);\n  } else {\n    var x__26798__auto__ = tcoll == null ? null : tcoll;\n    return function() {\n      var or__26171__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._disjoin_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;ITransientSet.-disjoin!&quot;, tcoll);\n        }\n      }\n    }().call(null, tcoll, v);\n  }\n};\ncljs.core.IComparable = function() {\n  var obj32383 = {};\n  return obj32383;\n}();\ncljs.core._compare = function _compare(x, y) {\n  if (function() {\n    var and__26159__auto__ = x;\n    if (and__26159__auto__) {\n      return x.cljs$core$IComparable$_compare$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return x.cljs$core$IComparable$_compare$arity$2(x, y);\n  } else {\n    var x__26798__auto__ = x == null ? null : x;\n    return function() {\n      var or__26171__auto__ = cljs.core._compare[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._compare[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IComparable.-compare&quot;, x);\n        }\n      }\n    }().call(null, x, y);\n  }\n};\ncljs.core.IChunk = function() {\n  var obj32385 = {};\n  return obj32385;\n}();\ncljs.core._drop_first = function _drop_first(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IChunk$_drop_first$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._drop_first[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._drop_first[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IChunk.-drop-first&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.IChunkedSeq = function() {\n  var obj32387 = {};\n  return obj32387;\n}();\ncljs.core._chunked_first = function _chunked_first(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._chunked_first[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._chunked_first[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IChunkedSeq.-chunked-first&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core._chunked_rest = function _chunked_rest(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._chunked_rest[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._chunked_rest[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IChunkedSeq.-chunked-rest&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.IChunkedNext = function() {\n  var obj32389 = {};\n  return obj32389;\n}();\ncljs.core._chunked_next = function _chunked_next(coll) {\n  if (function() {\n    var and__26159__auto__ = coll;\n    if (and__26159__auto__) {\n      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);\n  } else {\n    var x__26798__auto__ = coll == null ? null : coll;\n    return function() {\n      var or__26171__auto__ = cljs.core._chunked_next[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._chunked_next[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IChunkedNext.-chunked-next&quot;, coll);\n        }\n      }\n    }().call(null, coll);\n  }\n};\ncljs.core.INamed = function() {\n  var obj32391 = {};\n  return obj32391;\n}();\ncljs.core._name = function _name(x) {\n  if (function() {\n    var and__26159__auto__ = x;\n    if (and__26159__auto__) {\n      return x.cljs$core$INamed$_name$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return x.cljs$core$INamed$_name$arity$1(x);\n  } else {\n    var x__26798__auto__ = x == null ? null : x;\n    return function() {\n      var or__26171__auto__ = cljs.core._name[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._name[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;INamed.-name&quot;, x);\n        }\n      }\n    }().call(null, x);\n  }\n};\ncljs.core._namespace = function _namespace(x) {\n  if (function() {\n    var and__26159__auto__ = x;\n    if (and__26159__auto__) {\n      return x.cljs$core$INamed$_namespace$arity$1;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return x.cljs$core$INamed$_namespace$arity$1(x);\n  } else {\n    var x__26798__auto__ = x == null ? null : x;\n    return function() {\n      var or__26171__auto__ = cljs.core._namespace[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._namespace[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;INamed.-namespace&quot;, x);\n        }\n      }\n    }().call(null, x);\n  }\n};\ncljs.core.IAtom = function() {\n  var obj32393 = {};\n  return obj32393;\n}();\ncljs.core.IReset = function() {\n  var obj32395 = {};\n  return obj32395;\n}();\ncljs.core._reset_BANG_ = function _reset_BANG_(o, new_value) {\n  if (function() {\n    var and__26159__auto__ = o;\n    if (and__26159__auto__) {\n      return o.cljs$core$IReset$_reset_BANG_$arity$2;\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);\n  } else {\n    var x__26798__auto__ = o == null ? null : o;\n    return function() {\n      var or__26171__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__26798__auto__)];\n      if (or__26171__auto__) {\n        return or__26171__auto__;\n      } else {\n        var or__26171__auto____$1 = cljs.core._reset_BANG_[&quot;_&quot;];\n        if (or__26171__auto____$1) {\n          return or__26171__auto____$1;\n        } else {\n          throw cljs.core.missing_protocol.call(null, &quot;IReset.-reset!&quot;, o);\n        }\n      }\n    }().call(null, o, new_value);\n  }\n};\ncljs.core.ISwap = function() {\n  var obj32397 = {};\n  return obj32397;\n}();\ncljs.core._swap_BANG_ = function() {\n  var _swap_BANG_ = null;\n  var _swap_BANG___2 = function(o, f) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ISwap$_swap_BANG_$arity$2;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._swap_BANG_[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ISwap.-swap!&quot;, o);\n          }\n        }\n      }().call(null, o, f);\n    }\n  };\n  var _swap_BANG___3 = function(o, f, a) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ISwap$_swap_BANG_$arity$3;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._swap_BANG_[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ISwap.-swap!&quot;, o);\n          }\n        }\n      }().call(null, o, f, a);\n    }\n  };\n  var _swap_BANG___4 = function(o, f, a, b) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ISwap$_swap_BANG_$arity$4;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._swap_BANG_[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ISwap.-swap!&quot;, o);\n          }\n        }\n      }().call(null, o, f, a, b);\n    }\n  };\n  var _swap_BANG___5 = function(o, f, a, b, xs) {\n    if (function() {\n      var and__26159__auto__ = o;\n      if (and__26159__auto__) {\n        return o.cljs$core$ISwap$_swap_BANG_$arity$5;\n      } else {\n        return and__26159__auto__;\n      }\n    }()) {\n      return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);\n    } else {\n      var x__26798__auto__ = o == null ? null : o;\n      return function() {\n        var or__26171__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__26798__auto__)];\n        if (or__26171__auto__) {\n          return or__26171__auto__;\n        } else {\n          var or__26171__auto____$1 = cljs.core._swap_BANG_[&quot;_&quot;];\n          if (or__26171__auto____$1) {\n            return or__26171__auto____$1;\n          } else {\n            throw cljs.core.missing_protocol.call(null, &quot;ISwap.-swap!&quot;, o);\n          }\n        }\n      }().call(null, o, f, a, b, xs);\n    }\n  };\n  _swap_BANG_ = function(o, f, a, b, xs) {\n    switch(arguments.length) {\n      case 2:\n        return _swap_BANG___2.call(this, o, f);\n      case 3:\n        return _swap_BANG___3.call(this, o, f, a);\n      case 4:\n        return _swap_BANG___4.call(this, o, f, a, b);\n      case 5:\n        return _swap_BANG___5.call(this, o, f, a, b, xs);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _swap_BANG_.cljs$core$IFn$_invoke$arity$2 = _swap_BANG___2;\n  _swap_BANG_.cljs$core$IFn$_invoke$arity$3 = _swap_BANG___3;\n  _swap_BANG_.cljs$core$IFn$_invoke$arity$4 = _swap_BANG___4;\n  _swap_BANG_.cljs$core$IFn$_invoke$arity$5 = _swap_BANG___5;\n  return _swap_BANG_;\n}();\ncljs.core.StringBufferWriter = function(sb) {\n  this.sb = sb;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 1073741824;\n};\ncljs.core.StringBufferWriter.cljs$lang$type = true;\ncljs.core.StringBufferWriter.cljs$lang$ctorStr = &quot;cljs.core/StringBufferWriter&quot;;\ncljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/StringBufferWriter&quot;);\n};\ncljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.sb.append(s);\n};\ncljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return null;\n};\ncljs.core.__GT_StringBufferWriter = function __GT_StringBufferWriter(sb) {\n  return new cljs.core.StringBufferWriter(sb);\n};\ncljs.core.pr_str_STAR_ = function pr_str_STAR_(obj) {\n  var sb = new goog.string.StringBuffer;\n  var writer = new cljs.core.StringBufferWriter(sb);\n  cljs.core._pr_writer.call(null, obj, writer, cljs.core.pr_opts.call(null));\n  cljs.core._flush.call(null, writer);\n  return &quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);\n};\ncljs.core.int_rotate_left = function int_rotate_left(x, n) {\n  return x &lt;&lt; n | x &gt;&gt;&gt; -n;\n};\nif (typeof Math.imul !== &quot;undefined&quot; &amp;&amp; !(Math.imul.call(null, 4294967295, 5) === 0)) {\n  cljs.core.imul = function imul(a, b) {\n    return Math.imul.call(null, a, b);\n  };\n} else {\n  cljs.core.imul = function imul(a, b) {\n    var ah = a &gt;&gt;&gt; 16 &amp; 65535;\n    var al = a &amp; 65535;\n    var bh = b &gt;&gt;&gt; 16 &amp; 65535;\n    var bl = b &amp; 65535;\n    return al * bl + (ah * bl + al * bh &lt;&lt; 16 &gt;&gt;&gt; 0) | 0;\n  };\n}\ncljs.core.m3_seed = 0;\ncljs.core.m3_C1 = 3432918353;\ncljs.core.m3_C2 = 461845907;\ncljs.core.m3_mix_K1 = function m3_mix_K1(k1) {\n  return cljs.core.imul.call(null, cljs.core.int_rotate_left.call(null, cljs.core.imul.call(null, k1, cljs.core.m3_C1), 15), cljs.core.m3_C2);\n};\ncljs.core.m3_mix_H1 = function m3_mix_H1(h1, k1) {\n  return cljs.core.imul.call(null, cljs.core.int_rotate_left.call(null, h1 ^ k1, 13), 5) + 3864292196;\n};\ncljs.core.m3_fmix = function m3_fmix(h1, len) {\n  var h1__$1 = h1;\n  var h1__$2 = h1__$1 ^ len;\n  var h1__$3 = h1__$2 ^ h1__$2 &gt;&gt;&gt; 16;\n  var h1__$4 = cljs.core.imul.call(null, h1__$3, 2246822507);\n  var h1__$5 = h1__$4 ^ h1__$4 &gt;&gt;&gt; 13;\n  var h1__$6 = cljs.core.imul.call(null, h1__$5, 3266489909);\n  var h1__$7 = h1__$6 ^ h1__$6 &gt;&gt;&gt; 16;\n  return h1__$7;\n};\ncljs.core.m3_hash_int = function m3_hash_int(in$) {\n  if (in$ === 0) {\n    return in$;\n  } else {\n    var k1 = cljs.core.m3_mix_K1.call(null, in$);\n    var h1 = cljs.core.m3_mix_H1.call(null, cljs.core.m3_seed, k1);\n    return cljs.core.m3_fmix.call(null, h1, 4);\n  }\n};\ncljs.core.m3_hash_unencoded_chars = function m3_hash_unencoded_chars(in$) {\n  var h1 = function() {\n    var i = 1;\n    var h1 = cljs.core.m3_seed;\n    while (true) {\n      if (i &lt; in$.length) {\n        var G__32398 = i + 2;\n        var G__32399 = cljs.core.m3_mix_H1.call(null, h1, cljs.core.m3_mix_K1.call(null, in$.charCodeAt(i - 1) | in$.charCodeAt(i) &lt;&lt; 16));\n        i = G__32398;\n        h1 = G__32399;\n        continue;\n      } else {\n        return h1;\n      }\n      break;\n    }\n  }();\n  var h1__$1 = (in$.length &amp; 1) === 1 ? h1 ^ cljs.core.m3_mix_K1.call(null, in$.charCodeAt(in$.length - 1)) : h1;\n  return cljs.core.m3_fmix.call(null, h1__$1, cljs.core.imul.call(null, 2, in$.length));\n};\ncljs.core.string_hash_cache = function() {\n  var obj32401 = {};\n  return obj32401;\n}();\ncljs.core.string_hash_cache_count = 0;\ncljs.core.hash_string_STAR_ = function hash_string_STAR_(s) {\n  if (!(s == null)) {\n    var len = s.length;\n    if (len &gt; 0) {\n      var i = 0;\n      var hash = 0;\n      while (true) {\n        if (i &lt; len) {\n          var G__32402 = i + 1;\n          var G__32403 = cljs.core.imul.call(null, 31, hash) + s.charCodeAt(i);\n          i = G__32402;\n          hash = G__32403;\n          continue;\n        } else {\n          return hash;\n        }\n        break;\n      }\n    } else {\n      return 0;\n    }\n  } else {\n    return 0;\n  }\n};\ncljs.core.add_to_string_hash_cache = function add_to_string_hash_cache(k) {\n  var h = cljs.core.hash_string_STAR_.call(null, k);\n  cljs.core.string_hash_cache[k] = h;\n  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;\n  return h;\n};\ncljs.core.hash_string = function hash_string(k) {\n  if (cljs.core.string_hash_cache_count &gt; 255) {\n    cljs.core.string_hash_cache = function() {\n      var obj32407 = {};\n      return obj32407;\n    }();\n    cljs.core.string_hash_cache_count = 0;\n  } else {\n  }\n  var h = cljs.core.string_hash_cache[k];\n  if (typeof h === &quot;number&quot;) {\n    return h;\n  } else {\n    return cljs.core.add_to_string_hash_cache.call(null, k);\n  }\n};\ncljs.core.hash = function hash(o) {\n  if (function() {\n    var G__32409 = o;\n    if (G__32409) {\n      var bit__26814__auto__ = G__32409.cljs$lang$protocol_mask$partition0$ &amp; 4194304;\n      if (bit__26814__auto__ || G__32409.cljs$core$IHash$) {\n        return true;\n      } else {\n        return false;\n      }\n    } else {\n      return false;\n    }\n  }()) {\n    return cljs.core._hash.call(null, o);\n  } else {\n    if (typeof o === &quot;number&quot;) {\n      return Math.floor.call(null, o) % 2147483647;\n    } else {\n      if (o === true) {\n        return 1;\n      } else {\n        if (o === false) {\n          return 0;\n        } else {\n          if (typeof o === &quot;string&quot;) {\n            return cljs.core.m3_hash_int.call(null, cljs.core.hash_string.call(null, o));\n          } else {\n            if (o == null) {\n              return 0;\n            } else {\n              return cljs.core._hash.call(null, o);\n            }\n          }\n        }\n      }\n    }\n  }\n};\ncljs.core.hash_combine = function hash_combine(seed, hash) {\n  return seed ^ hash + 2654435769 + (seed &lt;&lt; 6) + (seed &gt;&gt; 2);\n};\ncljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {\n  return o instanceof t;\n};\ncljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {\n  return x instanceof cljs.core.Symbol;\n};\ncljs.core.hash_symbol = function hash_symbol(sym) {\n  return cljs.core.hash_combine.call(null, cljs.core.m3_hash_unencoded_chars.call(null, sym.name), cljs.core.hash_string.call(null, sym.ns));\n};\ncljs.core.compare_symbols = function compare_symbols(a, b) {\n  if (cljs.core.truth_(cljs.core._EQ_.call(null, a, b))) {\n    return 0;\n  } else {\n    if (cljs.core.truth_(function() {\n      var and__26159__auto__ = cljs.core.not.call(null, a.ns);\n      if (and__26159__auto__) {\n        return b.ns;\n      } else {\n        return and__26159__auto__;\n      }\n    }())) {\n      return-1;\n    } else {\n      if (cljs.core.truth_(a.ns)) {\n        if (cljs.core.not.call(null, b.ns)) {\n          return 1;\n        } else {\n          var nsc = cljs.core.compare.call(null, a.ns, b.ns);\n          if (nsc === 0) {\n            return cljs.core.compare.call(null, a.name, b.name);\n          } else {\n            return nsc;\n          }\n        }\n      } else {\n        return cljs.core.compare.call(null, a.name, b.name);\n      }\n    }\n  }\n};\ncljs.core.Symbol = function(ns, name, str, _hash, _meta) {\n  this.ns = ns;\n  this.name = name;\n  this.str = str;\n  this._hash = _hash;\n  this._meta = _meta;\n  this.cljs$lang$protocol_mask$partition0$ = 2154168321;\n  this.cljs$lang$protocol_mask$partition1$ = 4096;\n};\ncljs.core.Symbol.cljs$lang$type = true;\ncljs.core.Symbol.cljs$lang$ctorStr = &quot;cljs.core/Symbol&quot;;\ncljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/Symbol&quot;);\n};\ncljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {\n  var self__ = this;\n  var o__$1 = this;\n  return cljs.core._write.call(null, writer, self__.str);\n};\ncljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.name;\n};\ncljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.ns;\n};\ncljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {\n  var self__ = this;\n  var sym__$1 = this;\n  var h__26582__auto__ = self__._hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_symbol.call(null, sym__$1);\n    self__._hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);\n};\ncljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__._meta;\n};\ncljs.core.Symbol.prototype.call = function() {\n  var G__32411 = null;\n  var G__32411__2 = function(self__, coll) {\n    var self__ = this;\n    var self____$1 = this;\n    var sym = self____$1;\n    return cljs.core._lookup.call(null, coll, sym, null);\n  };\n  var G__32411__3 = function(self__, coll, not_found) {\n    var self__ = this;\n    var self____$1 = this;\n    var sym = self____$1;\n    return cljs.core._lookup.call(null, coll, sym, not_found);\n  };\n  G__32411 = function(self__, coll, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return G__32411__2.call(this, self__, coll);\n      case 3:\n        return G__32411__3.call(this, self__, coll, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  G__32411.cljs$core$IFn$_invoke$arity$2 = G__32411__2;\n  G__32411.cljs$core$IFn$_invoke$arity$3 = G__32411__3;\n  return G__32411;\n}();\ncljs.core.Symbol.prototype.apply = function(self__, args32410) {\n  var self__ = this;\n  var self____$1 = this;\n  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone.call(null, args32410)));\n};\ncljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {\n  var self__ = this;\n  var sym = this;\n  return cljs.core._lookup.call(null, coll, sym, null);\n};\ncljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {\n  var self__ = this;\n  var sym = this;\n  return cljs.core._lookup.call(null, coll, sym, not_found);\n};\ncljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {\n  var self__ = this;\n  var ___$1 = this;\n  if (other instanceof cljs.core.Symbol) {\n    return self__.str === other.str;\n  } else {\n    return false;\n  }\n};\ncljs.core.Symbol.prototype.toString = function() {\n  var self__ = this;\n  var _ = this;\n  return self__.str;\n};\ncljs.core.Symbol.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.__GT_Symbol = function __GT_Symbol(ns, name, str, _hash, _meta) {\n  return new cljs.core.Symbol(ns, name, str, _hash, _meta);\n};\ncljs.core.symbol = function() {\n  var symbol = null;\n  var symbol__1 = function(name) {\n    if (name instanceof cljs.core.Symbol) {\n      return name;\n    } else {\n      return symbol.call(null, null, name);\n    }\n  };\n  var symbol__2 = function(ns, name) {\n    var sym_str = !(ns == null) ? &quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns) + &quot;/&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(name) : name;\n    return new cljs.core.Symbol(ns, name, sym_str, null, null);\n  };\n  symbol = function(ns, name) {\n    switch(arguments.length) {\n      case 1:\n        return symbol__1.call(this, ns);\n      case 2:\n        return symbol__2.call(this, ns, name);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  symbol.cljs$core$IFn$_invoke$arity$1 = symbol__1;\n  symbol.cljs$core$IFn$_invoke$arity$2 = symbol__2;\n  return symbol;\n}();\ncljs.core.clone = function clone(value) {\n  return cljs.core._clone.call(null, value);\n};\ncljs.core.cloneable_QMARK_ = function cloneable_QMARK_(value) {\n  var G__32413 = value;\n  if (G__32413) {\n    var bit__26821__auto__ = G__32413.cljs$lang$protocol_mask$partition1$ &amp; 8192;\n    if (bit__26821__auto__ || G__32413.cljs$core$ICloneable$) {\n      return true;\n    } else {\n      if (!G__32413.cljs$lang$protocol_mask$partition1$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICloneable, G__32413);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICloneable, G__32413);\n  }\n};\ncljs.core.seq = function seq(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    if (function() {\n      var G__32415 = coll;\n      if (G__32415) {\n        var bit__26814__auto__ = G__32415.cljs$lang$protocol_mask$partition0$ &amp; 8388608;\n        if (bit__26814__auto__ || G__32415.cljs$core$ISeqable$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._seq.call(null, coll);\n    } else {\n      if (coll instanceof Array) {\n        if (coll.length === 0) {\n          return null;\n        } else {\n          return new cljs.core.IndexedSeq(coll, 0);\n        }\n      } else {\n        if (typeof coll === &quot;string&quot;) {\n          if (coll.length === 0) {\n            return null;\n          } else {\n            return new cljs.core.IndexedSeq(coll, 0);\n          }\n        } else {\n          if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeqable, coll)) {\n            return cljs.core._seq.call(null, coll);\n          } else {\n            throw new Error(&quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll) + &quot; is not ISeqable&quot;);\n          }\n        }\n      }\n    }\n  }\n};\ncljs.core.first = function first(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    if (function() {\n      var G__32417 = coll;\n      if (G__32417) {\n        var bit__26814__auto__ = G__32417.cljs$lang$protocol_mask$partition0$ &amp; 64;\n        if (bit__26814__auto__ || G__32417.cljs$core$ISeq$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._first.call(null, coll);\n    } else {\n      var s = cljs.core.seq.call(null, coll);\n      if (s == null) {\n        return null;\n      } else {\n        return cljs.core._first.call(null, s);\n      }\n    }\n  }\n};\ncljs.core.rest = function rest(coll) {\n  if (!(coll == null)) {\n    if (function() {\n      var G__32419 = coll;\n      if (G__32419) {\n        var bit__26814__auto__ = G__32419.cljs$lang$protocol_mask$partition0$ &amp; 64;\n        if (bit__26814__auto__ || G__32419.cljs$core$ISeq$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._rest.call(null, coll);\n    } else {\n      var s = cljs.core.seq.call(null, coll);\n      if (s) {\n        return cljs.core._rest.call(null, s);\n      } else {\n        return cljs.core.List.EMPTY;\n      }\n    }\n  } else {\n    return cljs.core.List.EMPTY;\n  }\n};\ncljs.core.next = function next(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    if (function() {\n      var G__32421 = coll;\n      if (G__32421) {\n        var bit__26814__auto__ = G__32421.cljs$lang$protocol_mask$partition0$ &amp; 128;\n        if (bit__26814__auto__ || G__32421.cljs$core$INext$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._next.call(null, coll);\n    } else {\n      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll));\n    }\n  }\n};\ncljs.core._EQ_ = function() {\n  var _EQ_ = null;\n  var _EQ___1 = function(x) {\n    return true;\n  };\n  var _EQ___2 = function(x, y) {\n    if (x == null) {\n      return y == null;\n    } else {\n      return x === y || cljs.core._equiv.call(null, x, y);\n    }\n  };\n  var _EQ___3 = function() {\n    var G__32422__delegate = function(x, y, more) {\n      while (true) {\n        if (_EQ_.call(null, x, y)) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32423 = y;\n            var G__32424 = cljs.core.first.call(null, more);\n            var G__32425 = cljs.core.next.call(null, more);\n            x = G__32423;\n            y = G__32424;\n            more = G__32425;\n            continue;\n          } else {\n            return _EQ_.call(null, y, cljs.core.first.call(null, more));\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32422 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32422__delegate.call(this, x, y, more);\n    };\n    G__32422.cljs$lang$maxFixedArity = 2;\n    G__32422.cljs$lang$applyTo = function(arglist__32426) {\n      var x = cljs.core.first(arglist__32426);\n      arglist__32426 = cljs.core.next(arglist__32426);\n      var y = cljs.core.first(arglist__32426);\n      var more = cljs.core.rest(arglist__32426);\n      return G__32422__delegate(x, y, more);\n    };\n    G__32422.cljs$core$IFn$_invoke$arity$variadic = G__32422__delegate;\n    return G__32422;\n  }();\n  _EQ_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _EQ___1.call(this, x);\n      case 2:\n        return _EQ___2.call(this, x, y);\n      default:\n        return _EQ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _EQ_.cljs$lang$maxFixedArity = 2;\n  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;\n  _EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ___1;\n  _EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ___2;\n  _EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _EQ_;\n}();\ncljs.core.mix_collection_hash = function mix_collection_hash(hash_basis, count) {\n  var h1 = cljs.core.m3_seed;\n  var k1 = cljs.core.m3_mix_K1.call(null, hash_basis);\n  var h1__$1 = cljs.core.m3_mix_H1.call(null, h1, k1);\n  return cljs.core.m3_fmix.call(null, h1__$1, count);\n};\ncljs.core.hash_ordered_coll = function hash_ordered_coll(coll) {\n  var n = 0;\n  var hash_code = 1;\n  var coll__$1 = cljs.core.seq.call(null, coll);\n  while (true) {\n    if (!(coll__$1 == null)) {\n      var G__32427 = n + 1;\n      var G__32428 = cljs.core.imul.call(null, 31, hash_code) + cljs.core.hash.call(null, cljs.core.first.call(null, coll__$1)) | 0;\n      var G__32429 = cljs.core.next.call(null, coll__$1);\n      n = G__32427;\n      hash_code = G__32428;\n      coll__$1 = G__32429;\n      continue;\n    } else {\n      return cljs.core.mix_collection_hash.call(null, hash_code, n);\n    }\n    break;\n  }\n};\ncljs.core.hash_unordered_coll = function hash_unordered_coll(coll) {\n  var n = 0;\n  var hash_code = 0;\n  var coll__$1 = cljs.core.seq.call(null, coll);\n  while (true) {\n    if (!(coll__$1 == null)) {\n      var G__32430 = n + 1;\n      var G__32431 = hash_code + cljs.core.hash.call(null, cljs.core.first.call(null, coll__$1)) | 0;\n      var G__32432 = cljs.core.next.call(null, coll__$1);\n      n = G__32430;\n      hash_code = G__32431;\n      coll__$1 = G__32432;\n      continue;\n    } else {\n      return cljs.core.mix_collection_hash.call(null, hash_code, n);\n    }\n    break;\n  }\n};\ncljs.core.ICounted[&quot;null&quot;] = true;\ncljs.core._count[&quot;null&quot;] = function(_) {\n  return 0;\n};\nDate.prototype.cljs$core$IEquiv$ = true;\nDate.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {\n  var o__$1 = this;\n  return other instanceof Date &amp;&amp; o__$1.toString() === other.toString();\n};\ncljs.core.IEquiv[&quot;number&quot;] = true;\ncljs.core._equiv[&quot;number&quot;] = function(x, o) {\n  return x === o;\n};\ncljs.core.IMeta[&quot;function&quot;] = true;\ncljs.core._meta[&quot;function&quot;] = function(_) {\n  return null;\n};\ncljs.core.Fn[&quot;function&quot;] = true;\ncljs.core.IHash[&quot;_&quot;] = true;\ncljs.core._hash[&quot;_&quot;] = function(o) {\n  return goog.getUid(o);\n};\ncljs.core.inc = function inc(x) {\n  return x + 1;\n};\ncljs.core.Reduced = function(val) {\n  this.val = val;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 32768;\n};\ncljs.core.Reduced.cljs$lang$type = true;\ncljs.core.Reduced.cljs$lang$ctorStr = &quot;cljs.core/Reduced&quot;;\ncljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/Reduced&quot;);\n};\ncljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {\n  var self__ = this;\n  var o__$1 = this;\n  return self__.val;\n};\ncljs.core.__GT_Reduced = function __GT_Reduced(val) {\n  return new cljs.core.Reduced(val);\n};\ncljs.core.reduced = function reduced(x) {\n  return new cljs.core.Reduced(x);\n};\ncljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {\n  return r instanceof cljs.core.Reduced;\n};\ncljs.core.deref = function deref(o) {\n  return cljs.core._deref.call(null, o);\n};\ncljs.core.ci_reduce = function() {\n  var ci_reduce = null;\n  var ci_reduce__2 = function(cicoll, f) {\n    var cnt = cljs.core._count.call(null, cicoll);\n    if (cnt === 0) {\n      return f.call(null);\n    } else {\n      var val = cljs.core._nth.call(null, cicoll, 0);\n      var n = 1;\n      while (true) {\n        if (n &lt; cnt) {\n          var nval = f.call(null, val, cljs.core._nth.call(null, cicoll, n));\n          if (cljs.core.reduced_QMARK_.call(null, nval)) {\n            return cljs.core.deref.call(null, nval);\n          } else {\n            var G__32433 = nval;\n            var G__32434 = n + 1;\n            val = G__32433;\n            n = G__32434;\n            continue;\n          }\n        } else {\n          return val;\n        }\n        break;\n      }\n    }\n  };\n  var ci_reduce__3 = function(cicoll, f, val) {\n    var cnt = cljs.core._count.call(null, cicoll);\n    var val__$1 = val;\n    var n = 0;\n    while (true) {\n      if (n &lt; cnt) {\n        var nval = f.call(null, val__$1, cljs.core._nth.call(null, cicoll, n));\n        if (cljs.core.reduced_QMARK_.call(null, nval)) {\n          return cljs.core.deref.call(null, nval);\n        } else {\n          var G__32435 = nval;\n          var G__32436 = n + 1;\n          val__$1 = G__32435;\n          n = G__32436;\n          continue;\n        }\n      } else {\n        return val__$1;\n      }\n      break;\n    }\n  };\n  var ci_reduce__4 = function(cicoll, f, val, idx) {\n    var cnt = cljs.core._count.call(null, cicoll);\n    var val__$1 = val;\n    var n = idx;\n    while (true) {\n      if (n &lt; cnt) {\n        var nval = f.call(null, val__$1, cljs.core._nth.call(null, cicoll, n));\n        if (cljs.core.reduced_QMARK_.call(null, nval)) {\n          return cljs.core.deref.call(null, nval);\n        } else {\n          var G__32437 = nval;\n          var G__32438 = n + 1;\n          val__$1 = G__32437;\n          n = G__32438;\n          continue;\n        }\n      } else {\n        return val__$1;\n      }\n      break;\n    }\n  };\n  ci_reduce = function(cicoll, f, val, idx) {\n    switch(arguments.length) {\n      case 2:\n        return ci_reduce__2.call(this, cicoll, f);\n      case 3:\n        return ci_reduce__3.call(this, cicoll, f, val);\n      case 4:\n        return ci_reduce__4.call(this, cicoll, f, val, idx);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  ci_reduce.cljs$core$IFn$_invoke$arity$2 = ci_reduce__2;\n  ci_reduce.cljs$core$IFn$_invoke$arity$3 = ci_reduce__3;\n  ci_reduce.cljs$core$IFn$_invoke$arity$4 = ci_reduce__4;\n  return ci_reduce;\n}();\ncljs.core.array_reduce = function() {\n  var array_reduce = null;\n  var array_reduce__2 = function(arr, f) {\n    var cnt = arr.length;\n    if (arr.length === 0) {\n      return f.call(null);\n    } else {\n      var val = arr[0];\n      var n = 1;\n      while (true) {\n        if (n &lt; cnt) {\n          var nval = f.call(null, val, arr[n]);\n          if (cljs.core.reduced_QMARK_.call(null, nval)) {\n            return cljs.core.deref.call(null, nval);\n          } else {\n            var G__32439 = nval;\n            var G__32440 = n + 1;\n            val = G__32439;\n            n = G__32440;\n            continue;\n          }\n        } else {\n          return val;\n        }\n        break;\n      }\n    }\n  };\n  var array_reduce__3 = function(arr, f, val) {\n    var cnt = arr.length;\n    var val__$1 = val;\n    var n = 0;\n    while (true) {\n      if (n &lt; cnt) {\n        var nval = f.call(null, val__$1, arr[n]);\n        if (cljs.core.reduced_QMARK_.call(null, nval)) {\n          return cljs.core.deref.call(null, nval);\n        } else {\n          var G__32441 = nval;\n          var G__32442 = n + 1;\n          val__$1 = G__32441;\n          n = G__32442;\n          continue;\n        }\n      } else {\n        return val__$1;\n      }\n      break;\n    }\n  };\n  var array_reduce__4 = function(arr, f, val, idx) {\n    var cnt = arr.length;\n    var val__$1 = val;\n    var n = idx;\n    while (true) {\n      if (n &lt; cnt) {\n        var nval = f.call(null, val__$1, arr[n]);\n        if (cljs.core.reduced_QMARK_.call(null, nval)) {\n          return cljs.core.deref.call(null, nval);\n        } else {\n          var G__32443 = nval;\n          var G__32444 = n + 1;\n          val__$1 = G__32443;\n          n = G__32444;\n          continue;\n        }\n      } else {\n        return val__$1;\n      }\n      break;\n    }\n  };\n  array_reduce = function(arr, f, val, idx) {\n    switch(arguments.length) {\n      case 2:\n        return array_reduce__2.call(this, arr, f);\n      case 3:\n        return array_reduce__3.call(this, arr, f, val);\n      case 4:\n        return array_reduce__4.call(this, arr, f, val, idx);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  array_reduce.cljs$core$IFn$_invoke$arity$2 = array_reduce__2;\n  array_reduce.cljs$core$IFn$_invoke$arity$3 = array_reduce__3;\n  array_reduce.cljs$core$IFn$_invoke$arity$4 = array_reduce__4;\n  return array_reduce;\n}();\ncljs.core.counted_QMARK_ = function counted_QMARK_(x) {\n  var G__32446 = x;\n  if (G__32446) {\n    var bit__26821__auto__ = G__32446.cljs$lang$protocol_mask$partition0$ &amp; 2;\n    if (bit__26821__auto__ || G__32446.cljs$core$ICounted$) {\n      return true;\n    } else {\n      if (!G__32446.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICounted, G__32446);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICounted, G__32446);\n  }\n};\ncljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {\n  var G__32448 = x;\n  if (G__32448) {\n    var bit__26821__auto__ = G__32448.cljs$lang$protocol_mask$partition0$ &amp; 16;\n    if (bit__26821__auto__ || G__32448.cljs$core$IIndexed$) {\n      return true;\n    } else {\n      if (!G__32448.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IIndexed, G__32448);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IIndexed, G__32448);\n  }\n};\ncljs.core.IndexedSeq = function(arr, i) {\n  this.arr = arr;\n  this.i = i;\n  this.cljs$lang$protocol_mask$partition0$ = 166199550;\n  this.cljs$lang$protocol_mask$partition1$ = 8192;\n};\ncljs.core.IndexedSeq.cljs$lang$type = true;\ncljs.core.IndexedSeq.cljs$lang$ctorStr = &quot;cljs.core/IndexedSeq&quot;;\ncljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/IndexedSeq&quot;);\n};\ncljs.core.IndexedSeq.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.IndexedSeq.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {\n  var self__ = this;\n  var coll__$1 = this;\n  var i__$1 = n + self__.i;\n  if (i__$1 &lt; self__.arr.length) {\n    return self__.arr[i__$1];\n  } else {\n    return null;\n  }\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {\n  var self__ = this;\n  var coll__$1 = this;\n  var i__$1 = n + self__.i;\n  if (i__$1 &lt; self__.arr.length) {\n    return self__.arr[i__$1];\n  } else {\n    return not_found;\n  }\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.IndexedSeq(self__.arr, self__.i);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  if (self__.i + 1 &lt; self__.arr.length) {\n    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);\n  } else {\n    return null;\n  }\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.arr.length - self__.i;\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  var c = cljs.core._count.call(null, coll__$1);\n  if (c &gt; 0) {\n    return new cljs.core.RSeq(coll__$1, c - 1, null);\n  } else {\n    return null;\n  }\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.hash_ordered_coll.call(null, coll__$1);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.List.EMPTY;\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.array_reduce.call(null, self__.arr, f, self__.arr[self__.i], self__.i + 1);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.array_reduce.call(null, self__.arr, f, start, self__.i);\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.arr[self__.i];\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  if (self__.i + 1 &lt; self__.arr.length) {\n    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);\n  } else {\n    return cljs.core.List.EMPTY;\n  }\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  return this$__$1;\n};\ncljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.cons.call(null, o, coll__$1);\n};\ncljs.core.__GT_IndexedSeq = function __GT_IndexedSeq(arr, i) {\n  return new cljs.core.IndexedSeq(arr, i);\n};\ncljs.core.prim_seq = function() {\n  var prim_seq = null;\n  var prim_seq__1 = function(prim) {\n    return prim_seq.call(null, prim, 0);\n  };\n  var prim_seq__2 = function(prim, i) {\n    if (i &lt; prim.length) {\n      return new cljs.core.IndexedSeq(prim, i);\n    } else {\n      return null;\n    }\n  };\n  prim_seq = function(prim, i) {\n    switch(arguments.length) {\n      case 1:\n        return prim_seq__1.call(this, prim);\n      case 2:\n        return prim_seq__2.call(this, prim, i);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  prim_seq.cljs$core$IFn$_invoke$arity$1 = prim_seq__1;\n  prim_seq.cljs$core$IFn$_invoke$arity$2 = prim_seq__2;\n  return prim_seq;\n}();\ncljs.core.array_seq = function() {\n  var array_seq = null;\n  var array_seq__1 = function(array) {\n    return cljs.core.prim_seq.call(null, array, 0);\n  };\n  var array_seq__2 = function(array, i) {\n    return cljs.core.prim_seq.call(null, array, i);\n  };\n  array_seq = function(array, i) {\n    switch(arguments.length) {\n      case 1:\n        return array_seq__1.call(this, array);\n      case 2:\n        return array_seq__2.call(this, array, i);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  array_seq.cljs$core$IFn$_invoke$arity$1 = array_seq__1;\n  array_seq.cljs$core$IFn$_invoke$arity$2 = array_seq__2;\n  return array_seq;\n}();\ncljs.core.RSeq = function(ci, i, meta) {\n  this.ci = ci;\n  this.i = i;\n  this.meta = meta;\n  this.cljs$lang$protocol_mask$partition0$ = 32374990;\n  this.cljs$lang$protocol_mask$partition1$ = 8192;\n};\ncljs.core.RSeq.cljs$lang$type = true;\ncljs.core.RSeq.cljs$lang$ctorStr = &quot;cljs.core/RSeq&quot;;\ncljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/RSeq&quot;);\n};\ncljs.core.RSeq.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.RSeq.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);\n};\ncljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.i &gt; 0) {\n    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);\n  } else {\n    return null;\n  }\n};\ncljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.i + 1;\n};\ncljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.hash_ordered_coll.call(null, coll__$1);\n};\ncljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, self__.meta);\n};\ncljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {\n  var self__ = this;\n  var col__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, col__$1);\n};\ncljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {\n  var self__ = this;\n  var col__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, start, col__$1);\n};\ncljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core._nth.call(null, self__.ci, self__.i);\n};\ncljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.i &gt; 0) {\n    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);\n  } else {\n    return cljs.core.List.EMPTY;\n  }\n};\ncljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return coll__$1;\n};\ncljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);\n};\ncljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.cons.call(null, o, coll__$1);\n};\ncljs.core.__GT_RSeq = function __GT_RSeq(ci, i, meta) {\n  return new cljs.core.RSeq(ci, i, meta);\n};\ncljs.core.second = function second(coll) {\n  return cljs.core.first.call(null, cljs.core.next.call(null, coll));\n};\ncljs.core.ffirst = function ffirst(coll) {\n  return cljs.core.first.call(null, cljs.core.first.call(null, coll));\n};\ncljs.core.nfirst = function nfirst(coll) {\n  return cljs.core.next.call(null, cljs.core.first.call(null, coll));\n};\ncljs.core.fnext = function fnext(coll) {\n  return cljs.core.first.call(null, cljs.core.next.call(null, coll));\n};\ncljs.core.nnext = function nnext(coll) {\n  return cljs.core.next.call(null, cljs.core.next.call(null, coll));\n};\ncljs.core.last = function last(s) {\n  while (true) {\n    var sn = cljs.core.next.call(null, s);\n    if (!(sn == null)) {\n      var G__32449 = sn;\n      s = G__32449;\n      continue;\n    } else {\n      return cljs.core.first.call(null, s);\n    }\n    break;\n  }\n};\ncljs.core.IEquiv[&quot;_&quot;] = true;\ncljs.core._equiv[&quot;_&quot;] = function(x, o) {\n  return x === o;\n};\ncljs.core.conj = function() {\n  var conj = null;\n  var conj__0 = function() {\n    return cljs.core.PersistentVector.EMPTY;\n  };\n  var conj__1 = function(coll) {\n    return coll;\n  };\n  var conj__2 = function(coll, x) {\n    if (!(coll == null)) {\n      return cljs.core._conj.call(null, coll, x);\n    } else {\n      return cljs.core._conj.call(null, cljs.core.List.EMPTY, x);\n    }\n  };\n  var conj__3 = function() {\n    var G__32450__delegate = function(coll, x, xs) {\n      while (true) {\n        if (cljs.core.truth_(xs)) {\n          var G__32451 = conj.call(null, coll, x);\n          var G__32452 = cljs.core.first.call(null, xs);\n          var G__32453 = cljs.core.next.call(null, xs);\n          coll = G__32451;\n          x = G__32452;\n          xs = G__32453;\n          continue;\n        } else {\n          return conj.call(null, coll, x);\n        }\n        break;\n      }\n    };\n    var G__32450 = function(coll, x, var_args) {\n      var xs = null;\n      if (arguments.length &gt; 2) {\n        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32450__delegate.call(this, coll, x, xs);\n    };\n    G__32450.cljs$lang$maxFixedArity = 2;\n    G__32450.cljs$lang$applyTo = function(arglist__32454) {\n      var coll = cljs.core.first(arglist__32454);\n      arglist__32454 = cljs.core.next(arglist__32454);\n      var x = cljs.core.first(arglist__32454);\n      var xs = cljs.core.rest(arglist__32454);\n      return G__32450__delegate(coll, x, xs);\n    };\n    G__32450.cljs$core$IFn$_invoke$arity$variadic = G__32450__delegate;\n    return G__32450;\n  }();\n  conj = function(coll, x, var_args) {\n    var xs = var_args;\n    switch(arguments.length) {\n      case 0:\n        return conj__0.call(this);\n      case 1:\n        return conj__1.call(this, coll);\n      case 2:\n        return conj__2.call(this, coll, x);\n      default:\n        return conj__3.cljs$core$IFn$_invoke$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  conj.cljs$lang$maxFixedArity = 2;\n  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;\n  conj.cljs$core$IFn$_invoke$arity$0 = conj__0;\n  conj.cljs$core$IFn$_invoke$arity$1 = conj__1;\n  conj.cljs$core$IFn$_invoke$arity$2 = conj__2;\n  conj.cljs$core$IFn$_invoke$arity$variadic = conj__3.cljs$core$IFn$_invoke$arity$variadic;\n  return conj;\n}();\ncljs.core.empty = function empty(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    return cljs.core._empty.call(null, coll);\n  }\n};\ncljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {\n  var s = cljs.core.seq.call(null, coll);\n  var acc = 0;\n  while (true) {\n    if (cljs.core.counted_QMARK_.call(null, s)) {\n      return acc + cljs.core._count.call(null, s);\n    } else {\n      var G__32455 = cljs.core.next.call(null, s);\n      var G__32456 = acc + 1;\n      s = G__32455;\n      acc = G__32456;\n      continue;\n    }\n    break;\n  }\n};\ncljs.core.count = function count(coll) {\n  if (!(coll == null)) {\n    if (function() {\n      var G__32458 = coll;\n      if (G__32458) {\n        var bit__26814__auto__ = G__32458.cljs$lang$protocol_mask$partition0$ &amp; 2;\n        if (bit__26814__auto__ || G__32458.cljs$core$ICounted$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._count.call(null, coll);\n    } else {\n      if (coll instanceof Array) {\n        return coll.length;\n      } else {\n        if (typeof coll === &quot;string&quot;) {\n          return coll.length;\n        } else {\n          if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICounted, coll)) {\n            return cljs.core._count.call(null, coll);\n          } else {\n            return cljs.core.accumulating_seq_count.call(null, coll);\n          }\n        }\n      }\n    }\n  } else {\n    return 0;\n  }\n};\ncljs.core.linear_traversal_nth = function() {\n  var linear_traversal_nth = null;\n  var linear_traversal_nth__2 = function(coll, n) {\n    while (true) {\n      if (coll == null) {\n        throw new Error(&quot;Index out of bounds&quot;);\n      } else {\n        if (n === 0) {\n          if (cljs.core.seq.call(null, coll)) {\n            return cljs.core.first.call(null, coll);\n          } else {\n            throw new Error(&quot;Index out of bounds&quot;);\n          }\n        } else {\n          if (cljs.core.indexed_QMARK_.call(null, coll)) {\n            return cljs.core._nth.call(null, coll, n);\n          } else {\n            if (cljs.core.seq.call(null, coll)) {\n              var G__32459 = cljs.core.next.call(null, coll);\n              var G__32460 = n - 1;\n              coll = G__32459;\n              n = G__32460;\n              continue;\n            } else {\n              throw new Error(&quot;Index out of bounds&quot;);\n            }\n          }\n        }\n      }\n      break;\n    }\n  };\n  var linear_traversal_nth__3 = function(coll, n, not_found) {\n    while (true) {\n      if (coll == null) {\n        return not_found;\n      } else {\n        if (n === 0) {\n          if (cljs.core.seq.call(null, coll)) {\n            return cljs.core.first.call(null, coll);\n          } else {\n            return not_found;\n          }\n        } else {\n          if (cljs.core.indexed_QMARK_.call(null, coll)) {\n            return cljs.core._nth.call(null, coll, n, not_found);\n          } else {\n            if (cljs.core.seq.call(null, coll)) {\n              var G__32461 = cljs.core.next.call(null, coll);\n              var G__32462 = n - 1;\n              var G__32463 = not_found;\n              coll = G__32461;\n              n = G__32462;\n              not_found = G__32463;\n              continue;\n            } else {\n              return not_found;\n            }\n          }\n        }\n      }\n      break;\n    }\n  };\n  linear_traversal_nth = function(coll, n, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return linear_traversal_nth__2.call(this, coll, n);\n      case 3:\n        return linear_traversal_nth__3.call(this, coll, n, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = linear_traversal_nth__2;\n  linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = linear_traversal_nth__3;\n  return linear_traversal_nth;\n}();\ncljs.core.nth = function() {\n  var nth = null;\n  var nth__2 = function(coll, n) {\n    if (!(typeof n === &quot;number&quot;)) {\n      throw new Error(&quot;index argument to nth must be a number&quot;);\n    } else {\n      if (coll == null) {\n        return coll;\n      } else {\n        if (function() {\n          var G__32468 = coll;\n          if (G__32468) {\n            var bit__26814__auto__ = G__32468.cljs$lang$protocol_mask$partition0$ &amp; 16;\n            if (bit__26814__auto__ || G__32468.cljs$core$IIndexed$) {\n              return true;\n            } else {\n              return false;\n            }\n          } else {\n            return false;\n          }\n        }()) {\n          return cljs.core._nth.call(null, coll, n);\n        } else {\n          if (coll instanceof Array) {\n            if (n &lt; coll.length) {\n              return coll[n];\n            } else {\n              return null;\n            }\n          } else {\n            if (typeof coll === &quot;string&quot;) {\n              if (n &lt; coll.length) {\n                return coll[n];\n              } else {\n                return null;\n              }\n            } else {\n              if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IIndexed, coll)) {\n                return cljs.core._nth.call(null, coll, n);\n              } else {\n                if (function() {\n                  var G__32469 = coll;\n                  if (G__32469) {\n                    var bit__26821__auto__ = G__32469.cljs$lang$protocol_mask$partition0$ &amp; 64;\n                    if (bit__26821__auto__ || G__32469.cljs$core$ISeq$) {\n                      return true;\n                    } else {\n                      if (!G__32469.cljs$lang$protocol_mask$partition0$) {\n                        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32469);\n                      } else {\n                        return false;\n                      }\n                    }\n                  } else {\n                    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32469);\n                  }\n                }()) {\n                  return cljs.core.linear_traversal_nth.call(null, coll, n);\n                } else {\n                  throw new Error(&quot;nth not supported on this type &quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str.call(null, cljs.core.type.call(null, coll))));\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  };\n  var nth__3 = function(coll, n, not_found) {\n    if (!(typeof n === &quot;number&quot;)) {\n      throw new Error(&quot;index argument to nth must be a number.&quot;);\n    } else {\n      if (coll == null) {\n        return not_found;\n      } else {\n        if (function() {\n          var G__32470 = coll;\n          if (G__32470) {\n            var bit__26814__auto__ = G__32470.cljs$lang$protocol_mask$partition0$ &amp; 16;\n            if (bit__26814__auto__ || G__32470.cljs$core$IIndexed$) {\n              return true;\n            } else {\n              return false;\n            }\n          } else {\n            return false;\n          }\n        }()) {\n          return cljs.core._nth.call(null, coll, n, not_found);\n        } else {\n          if (coll instanceof Array) {\n            if (n &lt; coll.length) {\n              return coll[n];\n            } else {\n              return not_found;\n            }\n          } else {\n            if (typeof coll === &quot;string&quot;) {\n              if (n &lt; coll.length) {\n                return coll[n];\n              } else {\n                return not_found;\n              }\n            } else {\n              if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IIndexed, coll)) {\n                return cljs.core._nth.call(null, coll, n);\n              } else {\n                if (function() {\n                  var G__32471 = coll;\n                  if (G__32471) {\n                    var bit__26821__auto__ = G__32471.cljs$lang$protocol_mask$partition0$ &amp; 64;\n                    if (bit__26821__auto__ || G__32471.cljs$core$ISeq$) {\n                      return true;\n                    } else {\n                      if (!G__32471.cljs$lang$protocol_mask$partition0$) {\n                        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32471);\n                      } else {\n                        return false;\n                      }\n                    }\n                  } else {\n                    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32471);\n                  }\n                }()) {\n                  return cljs.core.linear_traversal_nth.call(null, coll, n, not_found);\n                } else {\n                  throw new Error(&quot;nth not supported on this type &quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str.call(null, cljs.core.type.call(null, coll))));\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  };\n  nth = function(coll, n, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return nth__2.call(this, coll, n);\n      case 3:\n        return nth__3.call(this, coll, n, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  nth.cljs$core$IFn$_invoke$arity$2 = nth__2;\n  nth.cljs$core$IFn$_invoke$arity$3 = nth__3;\n  return nth;\n}();\ncljs.core.get = function() {\n  var get = null;\n  var get__2 = function(o, k) {\n    if (o == null) {\n      return null;\n    } else {\n      if (function() {\n        var G__32474 = o;\n        if (G__32474) {\n          var bit__26814__auto__ = G__32474.cljs$lang$protocol_mask$partition0$ &amp; 256;\n          if (bit__26814__auto__ || G__32474.cljs$core$ILookup$) {\n            return true;\n          } else {\n            return false;\n          }\n        } else {\n          return false;\n        }\n      }()) {\n        return cljs.core._lookup.call(null, o, k);\n      } else {\n        if (o instanceof Array) {\n          if (k &lt; o.length) {\n            return o[k];\n          } else {\n            return null;\n          }\n        } else {\n          if (typeof o === &quot;string&quot;) {\n            if (k &lt; o.length) {\n              return o[k];\n            } else {\n              return null;\n            }\n          } else {\n            if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ILookup, o)) {\n              return cljs.core._lookup.call(null, o, k);\n            } else {\n              return null;\n            }\n          }\n        }\n      }\n    }\n  };\n  var get__3 = function(o, k, not_found) {\n    if (!(o == null)) {\n      if (function() {\n        var G__32475 = o;\n        if (G__32475) {\n          var bit__26814__auto__ = G__32475.cljs$lang$protocol_mask$partition0$ &amp; 256;\n          if (bit__26814__auto__ || G__32475.cljs$core$ILookup$) {\n            return true;\n          } else {\n            return false;\n          }\n        } else {\n          return false;\n        }\n      }()) {\n        return cljs.core._lookup.call(null, o, k, not_found);\n      } else {\n        if (o instanceof Array) {\n          if (k &lt; o.length) {\n            return o[k];\n          } else {\n            return not_found;\n          }\n        } else {\n          if (typeof o === &quot;string&quot;) {\n            if (k &lt; o.length) {\n              return o[k];\n            } else {\n              return not_found;\n            }\n          } else {\n            if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ILookup, o)) {\n              return cljs.core._lookup.call(null, o, k, not_found);\n            } else {\n              return not_found;\n            }\n          }\n        }\n      }\n    } else {\n      return not_found;\n    }\n  };\n  get = function(o, k, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return get__2.call(this, o, k);\n      case 3:\n        return get__3.call(this, o, k, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  get.cljs$core$IFn$_invoke$arity$2 = get__2;\n  get.cljs$core$IFn$_invoke$arity$3 = get__3;\n  return get;\n}();\ncljs.core.assoc = function() {\n  var assoc = null;\n  var assoc__3 = function(coll, k, v) {\n    if (!(coll == null)) {\n      return cljs.core._assoc.call(null, coll, k, v);\n    } else {\n      return cljs.core.PersistentHashMap.fromArrays([k], [v]);\n    }\n  };\n  var assoc__4 = function() {\n    var G__32476__delegate = function(coll, k, v, kvs) {\n      while (true) {\n        var ret = assoc.call(null, coll, k, v);\n        if (cljs.core.truth_(kvs)) {\n          var G__32477 = ret;\n          var G__32478 = cljs.core.first.call(null, kvs);\n          var G__32479 = cljs.core.second.call(null, kvs);\n          var G__32480 = cljs.core.nnext.call(null, kvs);\n          coll = G__32477;\n          k = G__32478;\n          v = G__32479;\n          kvs = G__32480;\n          continue;\n        } else {\n          return ret;\n        }\n        break;\n      }\n    };\n    var G__32476 = function(coll, k, v, var_args) {\n      var kvs = null;\n      if (arguments.length &gt; 3) {\n        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0);\n      }\n      return G__32476__delegate.call(this, coll, k, v, kvs);\n    };\n    G__32476.cljs$lang$maxFixedArity = 3;\n    G__32476.cljs$lang$applyTo = function(arglist__32481) {\n      var coll = cljs.core.first(arglist__32481);\n      arglist__32481 = cljs.core.next(arglist__32481);\n      var k = cljs.core.first(arglist__32481);\n      arglist__32481 = cljs.core.next(arglist__32481);\n      var v = cljs.core.first(arglist__32481);\n      var kvs = cljs.core.rest(arglist__32481);\n      return G__32476__delegate(coll, k, v, kvs);\n    };\n    G__32476.cljs$core$IFn$_invoke$arity$variadic = G__32476__delegate;\n    return G__32476;\n  }();\n  assoc = function(coll, k, v, var_args) {\n    var kvs = var_args;\n    switch(arguments.length) {\n      case 3:\n        return assoc__3.call(this, coll, k, v);\n      default:\n        return assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  assoc.cljs$lang$maxFixedArity = 3;\n  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;\n  assoc.cljs$core$IFn$_invoke$arity$3 = assoc__3;\n  assoc.cljs$core$IFn$_invoke$arity$variadic = assoc__4.cljs$core$IFn$_invoke$arity$variadic;\n  return assoc;\n}();\ncljs.core.dissoc = function() {\n  var dissoc = null;\n  var dissoc__1 = function(coll) {\n    return coll;\n  };\n  var dissoc__2 = function(coll, k) {\n    if (coll == null) {\n      return null;\n    } else {\n      return cljs.core._dissoc.call(null, coll, k);\n    }\n  };\n  var dissoc__3 = function() {\n    var G__32482__delegate = function(coll, k, ks) {\n      while (true) {\n        if (coll == null) {\n          return null;\n        } else {\n          var ret = dissoc.call(null, coll, k);\n          if (cljs.core.truth_(ks)) {\n            var G__32483 = ret;\n            var G__32484 = cljs.core.first.call(null, ks);\n            var G__32485 = cljs.core.next.call(null, ks);\n            coll = G__32483;\n            k = G__32484;\n            ks = G__32485;\n            continue;\n          } else {\n            return ret;\n          }\n        }\n        break;\n      }\n    };\n    var G__32482 = function(coll, k, var_args) {\n      var ks = null;\n      if (arguments.length &gt; 2) {\n        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32482__delegate.call(this, coll, k, ks);\n    };\n    G__32482.cljs$lang$maxFixedArity = 2;\n    G__32482.cljs$lang$applyTo = function(arglist__32486) {\n      var coll = cljs.core.first(arglist__32486);\n      arglist__32486 = cljs.core.next(arglist__32486);\n      var k = cljs.core.first(arglist__32486);\n      var ks = cljs.core.rest(arglist__32486);\n      return G__32482__delegate(coll, k, ks);\n    };\n    G__32482.cljs$core$IFn$_invoke$arity$variadic = G__32482__delegate;\n    return G__32482;\n  }();\n  dissoc = function(coll, k, var_args) {\n    var ks = var_args;\n    switch(arguments.length) {\n      case 1:\n        return dissoc__1.call(this, coll);\n      case 2:\n        return dissoc__2.call(this, coll, k);\n      default:\n        return dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  dissoc.cljs$lang$maxFixedArity = 2;\n  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;\n  dissoc.cljs$core$IFn$_invoke$arity$1 = dissoc__1;\n  dissoc.cljs$core$IFn$_invoke$arity$2 = dissoc__2;\n  dissoc.cljs$core$IFn$_invoke$arity$variadic = dissoc__3.cljs$core$IFn$_invoke$arity$variadic;\n  return dissoc;\n}();\ncljs.core.fn_QMARK_ = function fn_QMARK_(f) {\n  var or__26171__auto__ = goog.isFunction(f);\n  if (or__26171__auto__) {\n    return or__26171__auto__;\n  } else {\n    var G__32490 = f;\n    if (G__32490) {\n      var bit__26821__auto__ = null;\n      if (cljs.core.truth_(function() {\n        var or__26171__auto____$1 = bit__26821__auto__;\n        if (cljs.core.truth_(or__26171__auto____$1)) {\n          return or__26171__auto____$1;\n        } else {\n          return G__32490.cljs$core$Fn$;\n        }\n      }())) {\n        return true;\n      } else {\n        if (!G__32490.cljs$lang$protocol_mask$partition$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.Fn, G__32490);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.Fn, G__32490);\n    }\n  }\n};\ncljs.core.MetaFn = function(afn, meta) {\n  this.afn = afn;\n  this.meta = meta;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 393217;\n};\ncljs.core.MetaFn.cljs$lang$type = true;\ncljs.core.MetaFn.cljs$lang$ctorStr = &quot;cljs.core/MetaFn&quot;;\ncljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/MetaFn&quot;);\n};\ncljs.core.MetaFn.prototype.call = function() {\n  var G__32492 = null;\n  var G__32492__1 = function(self__) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null);\n  };\n  var G__32492__2 = function(self__, a) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a);\n  };\n  var G__32492__3 = function(self__, a, b) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b);\n  };\n  var G__32492__4 = function(self__, a, b, c) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c);\n  };\n  var G__32492__5 = function(self__, a, b, c, d) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d);\n  };\n  var G__32492__6 = function(self__, a, b, c, d, e) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e);\n  };\n  var G__32492__7 = function(self__, a, b, c, d, e, f) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f);\n  };\n  var G__32492__8 = function(self__, a, b, c, d, e, f, g) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g);\n  };\n  var G__32492__9 = function(self__, a, b, c, d, e, f, g, h) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h);\n  };\n  var G__32492__10 = function(self__, a, b, c, d, e, f, g, h, i) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i);\n  };\n  var G__32492__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);\n  };\n  var G__32492__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);\n  };\n  var G__32492__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);\n  };\n  var G__32492__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);\n  };\n  var G__32492__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n  };\n  var G__32492__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n  };\n  var G__32492__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n  };\n  var G__32492__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n  };\n  var G__32492__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);\n  };\n  var G__32492__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);\n  };\n  var G__32492__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);\n  };\n  var G__32492__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {\n    var self__ = this;\n    var self____$1 = this;\n    var _ = self____$1;\n    return cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);\n  };\n  G__32492 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {\n    switch(arguments.length) {\n      case 1:\n        return G__32492__1.call(this, self__);\n      case 2:\n        return G__32492__2.call(this, self__, a);\n      case 3:\n        return G__32492__3.call(this, self__, a, b);\n      case 4:\n        return G__32492__4.call(this, self__, a, b, c);\n      case 5:\n        return G__32492__5.call(this, self__, a, b, c, d);\n      case 6:\n        return G__32492__6.call(this, self__, a, b, c, d, e);\n      case 7:\n        return G__32492__7.call(this, self__, a, b, c, d, e, f);\n      case 8:\n        return G__32492__8.call(this, self__, a, b, c, d, e, f, g);\n      case 9:\n        return G__32492__9.call(this, self__, a, b, c, d, e, f, g, h);\n      case 10:\n        return G__32492__10.call(this, self__, a, b, c, d, e, f, g, h, i);\n      case 11:\n        return G__32492__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);\n      case 12:\n        return G__32492__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);\n      case 13:\n        return G__32492__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);\n      case 14:\n        return G__32492__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);\n      case 15:\n        return G__32492__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n      case 16:\n        return G__32492__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n      case 17:\n        return G__32492__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n      case 18:\n        return G__32492__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n      case 19:\n        return G__32492__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);\n      case 20:\n        return G__32492__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);\n      case 21:\n        return G__32492__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);\n      case 22:\n        return G__32492__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  G__32492.cljs$core$IFn$_invoke$arity$1 = G__32492__1;\n  G__32492.cljs$core$IFn$_invoke$arity$2 = G__32492__2;\n  G__32492.cljs$core$IFn$_invoke$arity$3 = G__32492__3;\n  G__32492.cljs$core$IFn$_invoke$arity$4 = G__32492__4;\n  G__32492.cljs$core$IFn$_invoke$arity$5 = G__32492__5;\n  G__32492.cljs$core$IFn$_invoke$arity$6 = G__32492__6;\n  G__32492.cljs$core$IFn$_invoke$arity$7 = G__32492__7;\n  G__32492.cljs$core$IFn$_invoke$arity$8 = G__32492__8;\n  G__32492.cljs$core$IFn$_invoke$arity$9 = G__32492__9;\n  G__32492.cljs$core$IFn$_invoke$arity$10 = G__32492__10;\n  G__32492.cljs$core$IFn$_invoke$arity$11 = G__32492__11;\n  G__32492.cljs$core$IFn$_invoke$arity$12 = G__32492__12;\n  G__32492.cljs$core$IFn$_invoke$arity$13 = G__32492__13;\n  G__32492.cljs$core$IFn$_invoke$arity$14 = G__32492__14;\n  G__32492.cljs$core$IFn$_invoke$arity$15 = G__32492__15;\n  G__32492.cljs$core$IFn$_invoke$arity$16 = G__32492__16;\n  G__32492.cljs$core$IFn$_invoke$arity$17 = G__32492__17;\n  G__32492.cljs$core$IFn$_invoke$arity$18 = G__32492__18;\n  G__32492.cljs$core$IFn$_invoke$arity$19 = G__32492__19;\n  G__32492.cljs$core$IFn$_invoke$arity$20 = G__32492__20;\n  G__32492.cljs$core$IFn$_invoke$arity$21 = G__32492__21;\n  G__32492.cljs$core$IFn$_invoke$arity$22 = G__32492__22;\n  return G__32492;\n}();\ncljs.core.MetaFn.prototype.apply = function(self__, args32491) {\n  var self__ = this;\n  var self____$1 = this;\n  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone.call(null, args32491)));\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {\n  var self__ = this;\n  var _ = this;\n  return self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);\n};\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {\n  var self__ = this;\n  var _ = this;\n  return cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);\n};\ncljs.core.MetaFn.prototype.cljs$core$Fn$ = true;\ncljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.MetaFn(self__.afn, new_meta);\n};\ncljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.meta;\n};\ncljs.core.__GT_MetaFn = function __GT_MetaFn(afn, meta) {\n  return new cljs.core.MetaFn(afn, meta);\n};\ncljs.core.with_meta = function with_meta(o, meta) {\n  if (cljs.core.fn_QMARK_.call(null, o) &amp;&amp; !function() {\n    var G__32496 = o;\n    if (G__32496) {\n      var bit__26821__auto__ = G__32496.cljs$lang$protocol_mask$partition0$ &amp; 262144;\n      if (bit__26821__auto__ || G__32496.cljs$core$IWithMeta$) {\n        return true;\n      } else {\n        if (!G__32496.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IWithMeta, G__32496);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IWithMeta, G__32496);\n    }\n  }()) {\n    return new cljs.core.MetaFn(o, meta);\n  } else {\n    if (o == null) {\n      return null;\n    } else {\n      return cljs.core._with_meta.call(null, o, meta);\n    }\n  }\n};\ncljs.core.meta = function meta(o) {\n  if (function() {\n    var and__26159__auto__ = !(o == null);\n    if (and__26159__auto__) {\n      var G__32500 = o;\n      if (G__32500) {\n        var bit__26821__auto__ = G__32500.cljs$lang$protocol_mask$partition0$ &amp; 131072;\n        if (bit__26821__auto__ || G__32500.cljs$core$IMeta$) {\n          return true;\n        } else {\n          if (!G__32500.cljs$lang$protocol_mask$partition0$) {\n            return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IMeta, G__32500);\n          } else {\n            return false;\n          }\n        }\n      } else {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IMeta, G__32500);\n      }\n    } else {\n      return and__26159__auto__;\n    }\n  }()) {\n    return cljs.core._meta.call(null, o);\n  } else {\n    return null;\n  }\n};\ncljs.core.peek = function peek(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    return cljs.core._peek.call(null, coll);\n  }\n};\ncljs.core.pop = function pop(coll) {\n  if (coll == null) {\n    return null;\n  } else {\n    return cljs.core._pop.call(null, coll);\n  }\n};\ncljs.core.disj = function() {\n  var disj = null;\n  var disj__1 = function(coll) {\n    return coll;\n  };\n  var disj__2 = function(coll, k) {\n    if (coll == null) {\n      return null;\n    } else {\n      return cljs.core._disjoin.call(null, coll, k);\n    }\n  };\n  var disj__3 = function() {\n    var G__32501__delegate = function(coll, k, ks) {\n      while (true) {\n        if (coll == null) {\n          return null;\n        } else {\n          var ret = disj.call(null, coll, k);\n          if (cljs.core.truth_(ks)) {\n            var G__32502 = ret;\n            var G__32503 = cljs.core.first.call(null, ks);\n            var G__32504 = cljs.core.next.call(null, ks);\n            coll = G__32502;\n            k = G__32503;\n            ks = G__32504;\n            continue;\n          } else {\n            return ret;\n          }\n        }\n        break;\n      }\n    };\n    var G__32501 = function(coll, k, var_args) {\n      var ks = null;\n      if (arguments.length &gt; 2) {\n        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32501__delegate.call(this, coll, k, ks);\n    };\n    G__32501.cljs$lang$maxFixedArity = 2;\n    G__32501.cljs$lang$applyTo = function(arglist__32505) {\n      var coll = cljs.core.first(arglist__32505);\n      arglist__32505 = cljs.core.next(arglist__32505);\n      var k = cljs.core.first(arglist__32505);\n      var ks = cljs.core.rest(arglist__32505);\n      return G__32501__delegate(coll, k, ks);\n    };\n    G__32501.cljs$core$IFn$_invoke$arity$variadic = G__32501__delegate;\n    return G__32501;\n  }();\n  disj = function(coll, k, var_args) {\n    var ks = var_args;\n    switch(arguments.length) {\n      case 1:\n        return disj__1.call(this, coll);\n      case 2:\n        return disj__2.call(this, coll, k);\n      default:\n        return disj__3.cljs$core$IFn$_invoke$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  disj.cljs$lang$maxFixedArity = 2;\n  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;\n  disj.cljs$core$IFn$_invoke$arity$1 = disj__1;\n  disj.cljs$core$IFn$_invoke$arity$2 = disj__2;\n  disj.cljs$core$IFn$_invoke$arity$variadic = disj__3.cljs$core$IFn$_invoke$arity$variadic;\n  return disj;\n}();\ncljs.core.empty_QMARK_ = function empty_QMARK_(coll) {\n  return coll == null || cljs.core.not.call(null, cljs.core.seq.call(null, coll));\n};\ncljs.core.coll_QMARK_ = function coll_QMARK_(x) {\n  if (x == null) {\n    return false;\n  } else {\n    var G__32507 = x;\n    if (G__32507) {\n      var bit__26821__auto__ = G__32507.cljs$lang$protocol_mask$partition0$ &amp; 8;\n      if (bit__26821__auto__ || G__32507.cljs$core$ICollection$) {\n        return true;\n      } else {\n        if (!G__32507.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICollection, G__32507);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ICollection, G__32507);\n    }\n  }\n};\ncljs.core.set_QMARK_ = function set_QMARK_(x) {\n  if (x == null) {\n    return false;\n  } else {\n    var G__32509 = x;\n    if (G__32509) {\n      var bit__26821__auto__ = G__32509.cljs$lang$protocol_mask$partition0$ &amp; 4096;\n      if (bit__26821__auto__ || G__32509.cljs$core$ISet$) {\n        return true;\n      } else {\n        if (!G__32509.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISet, G__32509);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISet, G__32509);\n    }\n  }\n};\ncljs.core.associative_QMARK_ = function associative_QMARK_(x) {\n  var G__32511 = x;\n  if (G__32511) {\n    var bit__26821__auto__ = G__32511.cljs$lang$protocol_mask$partition0$ &amp; 512;\n    if (bit__26821__auto__ || G__32511.cljs$core$IAssociative$) {\n      return true;\n    } else {\n      if (!G__32511.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IAssociative, G__32511);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IAssociative, G__32511);\n  }\n};\ncljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {\n  var G__32513 = x;\n  if (G__32513) {\n    var bit__26821__auto__ = G__32513.cljs$lang$protocol_mask$partition0$ &amp; 16777216;\n    if (bit__26821__auto__ || G__32513.cljs$core$ISequential$) {\n      return true;\n    } else {\n      if (!G__32513.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISequential, G__32513);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISequential, G__32513);\n  }\n};\ncljs.core.sorted_QMARK_ = function sorted_QMARK_(x) {\n  var G__32515 = x;\n  if (G__32515) {\n    var bit__26821__auto__ = G__32515.cljs$lang$protocol_mask$partition0$ &amp; 268435456;\n    if (bit__26821__auto__ || G__32515.cljs$core$ISorted$) {\n      return true;\n    } else {\n      if (!G__32515.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISorted, G__32515);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISorted, G__32515);\n  }\n};\ncljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {\n  var G__32517 = x;\n  if (G__32517) {\n    var bit__26821__auto__ = G__32517.cljs$lang$protocol_mask$partition0$ &amp; 524288;\n    if (bit__26821__auto__ || G__32517.cljs$core$IReduce$) {\n      return true;\n    } else {\n      if (!G__32517.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReduce, G__32517);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReduce, G__32517);\n  }\n};\ncljs.core.map_QMARK_ = function map_QMARK_(x) {\n  if (x == null) {\n    return false;\n  } else {\n    var G__32519 = x;\n    if (G__32519) {\n      var bit__26821__auto__ = G__32519.cljs$lang$protocol_mask$partition0$ &amp; 1024;\n      if (bit__26821__auto__ || G__32519.cljs$core$IMap$) {\n        return true;\n      } else {\n        if (!G__32519.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IMap, G__32519);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IMap, G__32519);\n    }\n  }\n};\ncljs.core.vector_QMARK_ = function vector_QMARK_(x) {\n  var G__32521 = x;\n  if (G__32521) {\n    var bit__26821__auto__ = G__32521.cljs$lang$protocol_mask$partition0$ &amp; 16384;\n    if (bit__26821__auto__ || G__32521.cljs$core$IVector$) {\n      return true;\n    } else {\n      if (!G__32521.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IVector, G__32521);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IVector, G__32521);\n  }\n};\ncljs.core.chunked_seq_QMARK_ = function chunked_seq_QMARK_(x) {\n  var G__32523 = x;\n  if (G__32523) {\n    var bit__26814__auto__ = G__32523.cljs$lang$protocol_mask$partition1$ &amp; 512;\n    if (bit__26814__auto__ || G__32523.cljs$core$IChunkedSeq$) {\n      return true;\n    } else {\n      return false;\n    }\n  } else {\n    return false;\n  }\n};\ncljs.core.js_obj = function() {\n  var js_obj = null;\n  var js_obj__0 = function() {\n    var obj32527 = {};\n    return obj32527;\n  };\n  var js_obj__1 = function() {\n    var G__32528__delegate = function(keyvals) {\n      return cljs.core.apply.call(null, goog.object.create, keyvals);\n    };\n    var G__32528 = function(var_args) {\n      var keyvals = null;\n      if (arguments.length &gt; 0) {\n        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0);\n      }\n      return G__32528__delegate.call(this, keyvals);\n    };\n    G__32528.cljs$lang$maxFixedArity = 0;\n    G__32528.cljs$lang$applyTo = function(arglist__32529) {\n      var keyvals = cljs.core.seq(arglist__32529);\n      return G__32528__delegate(keyvals);\n    };\n    G__32528.cljs$core$IFn$_invoke$arity$variadic = G__32528__delegate;\n    return G__32528;\n  }();\n  js_obj = function(var_args) {\n    var keyvals = var_args;\n    switch(arguments.length) {\n      case 0:\n        return js_obj__0.call(this);\n      default:\n        return js_obj__1.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(arguments, 0));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  js_obj.cljs$lang$maxFixedArity = 0;\n  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;\n  js_obj.cljs$core$IFn$_invoke$arity$0 = js_obj__0;\n  js_obj.cljs$core$IFn$_invoke$arity$variadic = js_obj__1.cljs$core$IFn$_invoke$arity$variadic;\n  return js_obj;\n}();\ncljs.core.js_keys = function js_keys(obj) {\n  var keys = [];\n  goog.object.forEach(obj, function(keys) {\n    return function(val, key, obj__$1) {\n      return keys.push(key);\n    };\n  }(keys));\n  return keys;\n};\ncljs.core.js_delete = function js_delete(obj, key) {\n  return delete obj[key];\n};\ncljs.core.array_copy = function array_copy(from, i, to, j, len) {\n  var i__$1 = i;\n  var j__$1 = j;\n  var len__$1 = len;\n  while (true) {\n    if (len__$1 === 0) {\n      return to;\n    } else {\n      to[j__$1] = from[i__$1];\n      var G__32530 = i__$1 + 1;\n      var G__32531 = j__$1 + 1;\n      var G__32532 = len__$1 - 1;\n      i__$1 = G__32530;\n      j__$1 = G__32531;\n      len__$1 = G__32532;\n      continue;\n    }\n    break;\n  }\n};\ncljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {\n  var i__$1 = i + (len - 1);\n  var j__$1 = j + (len - 1);\n  var len__$1 = len;\n  while (true) {\n    if (len__$1 === 0) {\n      return to;\n    } else {\n      to[j__$1] = from[i__$1];\n      var G__32533 = i__$1 - 1;\n      var G__32534 = j__$1 - 1;\n      var G__32535 = len__$1 - 1;\n      i__$1 = G__32533;\n      j__$1 = G__32534;\n      len__$1 = G__32535;\n      continue;\n    }\n    break;\n  }\n};\ncljs.core.lookup_sentinel = function() {\n  var obj32537 = {};\n  return obj32537;\n}();\ncljs.core.false_QMARK_ = function false_QMARK_(x) {\n  return x === false;\n};\ncljs.core.true_QMARK_ = function true_QMARK_(x) {\n  return x === true;\n};\ncljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {\n  return void 0 === x;\n};\ncljs.core.seq_QMARK_ = function seq_QMARK_(s) {\n  if (s == null) {\n    return false;\n  } else {\n    var G__32539 = s;\n    if (G__32539) {\n      var bit__26821__auto__ = G__32539.cljs$lang$protocol_mask$partition0$ &amp; 64;\n      if (bit__26821__auto__ || G__32539.cljs$core$ISeq$) {\n        return true;\n      } else {\n        if (!G__32539.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32539);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeq, G__32539);\n    }\n  }\n};\ncljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {\n  var G__32541 = s;\n  if (G__32541) {\n    var bit__26821__auto__ = G__32541.cljs$lang$protocol_mask$partition0$ &amp; 8388608;\n    if (bit__26821__auto__ || G__32541.cljs$core$ISeqable$) {\n      return true;\n    } else {\n      if (!G__32541.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeqable, G__32541);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.ISeqable, G__32541);\n  }\n};\ncljs.core.boolean$ = function boolean$(x) {\n  if (cljs.core.truth_(x)) {\n    return true;\n  } else {\n    return false;\n  }\n};\ncljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {\n  var or__26171__auto__ = cljs.core.fn_QMARK_.call(null, f);\n  if (or__26171__auto__) {\n    return or__26171__auto__;\n  } else {\n    var G__32545 = f;\n    if (G__32545) {\n      var bit__26821__auto__ = G__32545.cljs$lang$protocol_mask$partition0$ &amp; 1;\n      if (bit__26821__auto__ || G__32545.cljs$core$IFn$) {\n        return true;\n      } else {\n        if (!G__32545.cljs$lang$protocol_mask$partition0$) {\n          return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IFn, G__32545);\n        } else {\n          return false;\n        }\n      }\n    } else {\n      return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IFn, G__32545);\n    }\n  }\n};\ncljs.core.integer_QMARK_ = function integer_QMARK_(n) {\n  return typeof n === &quot;number&quot; &amp;&amp; !isNaN(n) &amp;&amp; !(n === Infinity) &amp;&amp; parseFloat(n) === parseInt(n, 10);\n};\ncljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {\n  if (cljs.core.get.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {\n    return false;\n  } else {\n    return true;\n  }\n};\ncljs.core.find = function find(coll, k) {\n  if (!(coll == null) &amp;&amp; cljs.core.associative_QMARK_.call(null, coll) &amp;&amp; cljs.core.contains_QMARK_.call(null, coll, k)) {\n    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.call(null, coll, k)], null);\n  } else {\n    return null;\n  }\n};\ncljs.core.distinct_QMARK_ = function() {\n  var distinct_QMARK_ = null;\n  var distinct_QMARK___1 = function(x) {\n    return true;\n  };\n  var distinct_QMARK___2 = function(x, y) {\n    return!cljs.core._EQ_.call(null, x, y);\n  };\n  var distinct_QMARK___3 = function() {\n    var G__32546__delegate = function(x, y, more) {\n      if (!cljs.core._EQ_.call(null, x, y)) {\n        var s = cljs.core.PersistentHashSet.fromArray([x, y], true);\n        var xs = more;\n        while (true) {\n          var x__$1 = cljs.core.first.call(null, xs);\n          var etc = cljs.core.next.call(null, xs);\n          if (cljs.core.truth_(xs)) {\n            if (cljs.core.contains_QMARK_.call(null, s, x__$1)) {\n              return false;\n            } else {\n              var G__32547 = cljs.core.conj.call(null, s, x__$1);\n              var G__32548 = etc;\n              s = G__32547;\n              xs = G__32548;\n              continue;\n            }\n          } else {\n            return true;\n          }\n          break;\n        }\n      } else {\n        return false;\n      }\n    };\n    var G__32546 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32546__delegate.call(this, x, y, more);\n    };\n    G__32546.cljs$lang$maxFixedArity = 2;\n    G__32546.cljs$lang$applyTo = function(arglist__32549) {\n      var x = cljs.core.first(arglist__32549);\n      arglist__32549 = cljs.core.next(arglist__32549);\n      var y = cljs.core.first(arglist__32549);\n      var more = cljs.core.rest(arglist__32549);\n      return G__32546__delegate(x, y, more);\n    };\n    G__32546.cljs$core$IFn$_invoke$arity$variadic = G__32546__delegate;\n    return G__32546;\n  }();\n  distinct_QMARK_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return distinct_QMARK___1.call(this, x);\n      case 2:\n        return distinct_QMARK___2.call(this, x, y);\n      default:\n        return distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  distinct_QMARK_.cljs$lang$maxFixedArity = 2;\n  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;\n  distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = distinct_QMARK___1;\n  distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = distinct_QMARK___2;\n  distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;\n  return distinct_QMARK_;\n}();\ncljs.core.sequence = function sequence(coll) {\n  if (cljs.core.seq_QMARK_.call(null, coll)) {\n    return coll;\n  } else {\n    var or__26171__auto__ = cljs.core.seq.call(null, coll);\n    if (or__26171__auto__) {\n      return or__26171__auto__;\n    } else {\n      return cljs.core.List.EMPTY;\n    }\n  }\n};\ncljs.core.compare = function compare(x, y) {\n  if (x === y) {\n    return 0;\n  } else {\n    if (x == null) {\n      return-1;\n    } else {\n      if (y == null) {\n        return 1;\n      } else {\n        if (cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {\n          if (function() {\n            var G__32551 = x;\n            if (G__32551) {\n              var bit__26814__auto__ = G__32551.cljs$lang$protocol_mask$partition1$ &amp; 2048;\n              if (bit__26814__auto__ || G__32551.cljs$core$IComparable$) {\n                return true;\n              } else {\n                return false;\n              }\n            } else {\n              return false;\n            }\n          }()) {\n            return cljs.core._compare.call(null, x, y);\n          } else {\n            return goog.array.defaultCompare(x, y);\n          }\n        } else {\n          throw new Error(&quot;compare on non-nil objects of different types&quot;);\n        }\n      }\n    }\n  }\n};\ncljs.core.compare_indexed = function() {\n  var compare_indexed = null;\n  var compare_indexed__2 = function(xs, ys) {\n    var xl = cljs.core.count.call(null, xs);\n    var yl = cljs.core.count.call(null, ys);\n    if (xl &lt; yl) {\n      return-1;\n    } else {\n      if (xl &gt; yl) {\n        return 1;\n      } else {\n        return compare_indexed.call(null, xs, ys, xl, 0);\n      }\n    }\n  };\n  var compare_indexed__4 = function(xs, ys, len, n) {\n    while (true) {\n      var d = cljs.core.compare.call(null, cljs.core.nth.call(null, xs, n), cljs.core.nth.call(null, ys, n));\n      if (d === 0 &amp;&amp; n + 1 &lt; len) {\n        var G__32552 = xs;\n        var G__32553 = ys;\n        var G__32554 = len;\n        var G__32555 = n + 1;\n        xs = G__32552;\n        ys = G__32553;\n        len = G__32554;\n        n = G__32555;\n        continue;\n      } else {\n        return d;\n      }\n      break;\n    }\n  };\n  compare_indexed = function(xs, ys, len, n) {\n    switch(arguments.length) {\n      case 2:\n        return compare_indexed__2.call(this, xs, ys);\n      case 4:\n        return compare_indexed__4.call(this, xs, ys, len, n);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  compare_indexed.cljs$core$IFn$_invoke$arity$2 = compare_indexed__2;\n  compare_indexed.cljs$core$IFn$_invoke$arity$4 = compare_indexed__4;\n  return compare_indexed;\n}();\ncljs.core.fn__GT_comparator = function fn__GT_comparator(f) {\n  if (cljs.core._EQ_.call(null, f, cljs.core.compare)) {\n    return cljs.core.compare;\n  } else {\n    return function(x, y) {\n      var r = f.call(null, x, y);\n      if (typeof r === &quot;number&quot;) {\n        return r;\n      } else {\n        if (cljs.core.truth_(r)) {\n          return-1;\n        } else {\n          if (cljs.core.truth_(f.call(null, y, x))) {\n            return 1;\n          } else {\n            return 0;\n          }\n        }\n      }\n    };\n  }\n};\ncljs.core.sort = function() {\n  var sort = null;\n  var sort__1 = function(coll) {\n    return sort.call(null, cljs.core.compare, coll);\n  };\n  var sort__2 = function(comp, coll) {\n    if (cljs.core.seq.call(null, coll)) {\n      var a = cljs.core.to_array.call(null, coll);\n      goog.array.stableSort(a, cljs.core.fn__GT_comparator.call(null, comp));\n      return cljs.core.seq.call(null, a);\n    } else {\n      return cljs.core.List.EMPTY;\n    }\n  };\n  sort = function(comp, coll) {\n    switch(arguments.length) {\n      case 1:\n        return sort__1.call(this, comp);\n      case 2:\n        return sort__2.call(this, comp, coll);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  sort.cljs$core$IFn$_invoke$arity$1 = sort__1;\n  sort.cljs$core$IFn$_invoke$arity$2 = sort__2;\n  return sort;\n}();\ncljs.core.sort_by = function() {\n  var sort_by = null;\n  var sort_by__2 = function(keyfn, coll) {\n    return sort_by.call(null, keyfn, cljs.core.compare, coll);\n  };\n  var sort_by__3 = function(keyfn, comp, coll) {\n    return cljs.core.sort.call(null, function(x, y) {\n      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y));\n    }, coll);\n  };\n  sort_by = function(keyfn, comp, coll) {\n    switch(arguments.length) {\n      case 2:\n        return sort_by__2.call(this, keyfn, comp);\n      case 3:\n        return sort_by__3.call(this, keyfn, comp, coll);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  sort_by.cljs$core$IFn$_invoke$arity$2 = sort_by__2;\n  sort_by.cljs$core$IFn$_invoke$arity$3 = sort_by__3;\n  return sort_by;\n}();\ncljs.core.seq_reduce = function() {\n  var seq_reduce = null;\n  var seq_reduce__2 = function(f, coll) {\n    var temp__4124__auto__ = cljs.core.seq.call(null, coll);\n    if (temp__4124__auto__) {\n      var s = temp__4124__auto__;\n      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s), cljs.core.next.call(null, s));\n    } else {\n      return f.call(null);\n    }\n  };\n  var seq_reduce__3 = function(f, val, coll) {\n    var val__$1 = val;\n    var coll__$1 = cljs.core.seq.call(null, coll);\n    while (true) {\n      if (coll__$1) {\n        var nval = f.call(null, val__$1, cljs.core.first.call(null, coll__$1));\n        if (cljs.core.reduced_QMARK_.call(null, nval)) {\n          return cljs.core.deref.call(null, nval);\n        } else {\n          var G__32556 = nval;\n          var G__32557 = cljs.core.next.call(null, coll__$1);\n          val__$1 = G__32556;\n          coll__$1 = G__32557;\n          continue;\n        }\n      } else {\n        return val__$1;\n      }\n      break;\n    }\n  };\n  seq_reduce = function(f, val, coll) {\n    switch(arguments.length) {\n      case 2:\n        return seq_reduce__2.call(this, f, val);\n      case 3:\n        return seq_reduce__3.call(this, f, val, coll);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  seq_reduce.cljs$core$IFn$_invoke$arity$2 = seq_reduce__2;\n  seq_reduce.cljs$core$IFn$_invoke$arity$3 = seq_reduce__3;\n  return seq_reduce;\n}();\ncljs.core.shuffle = function shuffle(coll) {\n  var a = cljs.core.to_array.call(null, coll);\n  goog.array.shuffle(a);\n  return cljs.core.vec.call(null, a);\n};\ncljs.core.reduce = function() {\n  var reduce = null;\n  var reduce__2 = function(f, coll) {\n    if (function() {\n      var G__32560 = coll;\n      if (G__32560) {\n        var bit__26814__auto__ = G__32560.cljs$lang$protocol_mask$partition0$ &amp; 524288;\n        if (bit__26814__auto__ || G__32560.cljs$core$IReduce$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._reduce.call(null, coll, f);\n    } else {\n      if (coll instanceof Array) {\n        return cljs.core.array_reduce.call(null, coll, f);\n      } else {\n        if (typeof coll === &quot;string&quot;) {\n          return cljs.core.array_reduce.call(null, coll, f);\n        } else {\n          if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReduce, coll)) {\n            return cljs.core._reduce.call(null, coll, f);\n          } else {\n            return cljs.core.seq_reduce.call(null, f, coll);\n          }\n        }\n      }\n    }\n  };\n  var reduce__3 = function(f, val, coll) {\n    if (function() {\n      var G__32561 = coll;\n      if (G__32561) {\n        var bit__26814__auto__ = G__32561.cljs$lang$protocol_mask$partition0$ &amp; 524288;\n        if (bit__26814__auto__ || G__32561.cljs$core$IReduce$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }()) {\n      return cljs.core._reduce.call(null, coll, f, val);\n    } else {\n      if (coll instanceof Array) {\n        return cljs.core.array_reduce.call(null, coll, f, val);\n      } else {\n        if (typeof coll === &quot;string&quot;) {\n          return cljs.core.array_reduce.call(null, coll, f, val);\n        } else {\n          if (cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReduce, coll)) {\n            return cljs.core._reduce.call(null, coll, f, val);\n          } else {\n            return cljs.core.seq_reduce.call(null, f, val, coll);\n          }\n        }\n      }\n    }\n  };\n  reduce = function(f, val, coll) {\n    switch(arguments.length) {\n      case 2:\n        return reduce__2.call(this, f, val);\n      case 3:\n        return reduce__3.call(this, f, val, coll);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  reduce.cljs$core$IFn$_invoke$arity$2 = reduce__2;\n  reduce.cljs$core$IFn$_invoke$arity$3 = reduce__3;\n  return reduce;\n}();\ncljs.core.reduce_kv = function reduce_kv(f, init, coll) {\n  if (!(coll == null)) {\n    return cljs.core._kv_reduce.call(null, coll, f, init);\n  } else {\n    return init;\n  }\n};\ncljs.core.completing = function completing(f) {\n  return function() {\n    var G__32562 = null;\n    var G__32562__0 = function() {\n      return f.call(null);\n    };\n    var G__32562__1 = function(x) {\n      return x;\n    };\n    var G__32562__2 = function(x, y) {\n      return f.call(null, x, y);\n    };\n    G__32562 = function(x, y) {\n      switch(arguments.length) {\n        case 0:\n          return G__32562__0.call(this);\n        case 1:\n          return G__32562__1.call(this, x);\n        case 2:\n          return G__32562__2.call(this, x, y);\n      }\n      throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n    };\n    G__32562.cljs$core$IFn$_invoke$arity$0 = G__32562__0;\n    G__32562.cljs$core$IFn$_invoke$arity$1 = G__32562__1;\n    G__32562.cljs$core$IFn$_invoke$arity$2 = G__32562__2;\n    return G__32562;\n  }();\n};\ncljs.core.transduce = function() {\n  var transduce = null;\n  var transduce__3 = function(xform, f, coll) {\n    return transduce.call(null, xform, f, f.call(null), coll);\n  };\n  var transduce__4 = function(xform, f, init, coll) {\n    var f__$1 = xform.call(null, cljs.core.completing.call(null, f));\n    var ret = cljs.core.reduce.call(null, f__$1, init, coll);\n    var ret__$1 = f__$1.call(null, cljs.core.reduced_QMARK_.call(null, ret) ? cljs.core.deref.call(null, ret) : ret);\n    if (cljs.core.reduced_QMARK_.call(null, ret__$1)) {\n      return cljs.core.deref.call(null, ret__$1);\n    } else {\n      return ret__$1;\n    }\n  };\n  transduce = function(xform, f, init, coll) {\n    switch(arguments.length) {\n      case 3:\n        return transduce__3.call(this, xform, f, init);\n      case 4:\n        return transduce__4.call(this, xform, f, init, coll);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  transduce.cljs$core$IFn$_invoke$arity$3 = transduce__3;\n  transduce.cljs$core$IFn$_invoke$arity$4 = transduce__4;\n  return transduce;\n}();\ncljs.core._PLUS_ = function() {\n  var _PLUS_ = null;\n  var _PLUS___0 = function() {\n    return 0;\n  };\n  var _PLUS___1 = function(x) {\n    return x;\n  };\n  var _PLUS___2 = function(x, y) {\n    return x + y;\n  };\n  var _PLUS___3 = function() {\n    var G__32563__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, _PLUS_, x + y, more);\n    };\n    var G__32563 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32563__delegate.call(this, x, y, more);\n    };\n    G__32563.cljs$lang$maxFixedArity = 2;\n    G__32563.cljs$lang$applyTo = function(arglist__32564) {\n      var x = cljs.core.first(arglist__32564);\n      arglist__32564 = cljs.core.next(arglist__32564);\n      var y = cljs.core.first(arglist__32564);\n      var more = cljs.core.rest(arglist__32564);\n      return G__32563__delegate(x, y, more);\n    };\n    G__32563.cljs$core$IFn$_invoke$arity$variadic = G__32563__delegate;\n    return G__32563;\n  }();\n  _PLUS_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return _PLUS___0.call(this);\n      case 1:\n        return _PLUS___1.call(this, x);\n      case 2:\n        return _PLUS___2.call(this, x, y);\n      default:\n        return _PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _PLUS_.cljs$lang$maxFixedArity = 2;\n  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;\n  _PLUS_.cljs$core$IFn$_invoke$arity$0 = _PLUS___0;\n  _PLUS_.cljs$core$IFn$_invoke$arity$1 = _PLUS___1;\n  _PLUS_.cljs$core$IFn$_invoke$arity$2 = _PLUS___2;\n  _PLUS_.cljs$core$IFn$_invoke$arity$variadic = _PLUS___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _PLUS_;\n}();\ncljs.core._ = function() {\n  var _ = null;\n  var ___1 = function(x) {\n    return-x;\n  };\n  var ___2 = function(x, y) {\n    return x - y;\n  };\n  var ___3 = function() {\n    var G__32565__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, _, x - y, more);\n    };\n    var G__32565 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32565__delegate.call(this, x, y, more);\n    };\n    G__32565.cljs$lang$maxFixedArity = 2;\n    G__32565.cljs$lang$applyTo = function(arglist__32566) {\n      var x = cljs.core.first(arglist__32566);\n      arglist__32566 = cljs.core.next(arglist__32566);\n      var y = cljs.core.first(arglist__32566);\n      var more = cljs.core.rest(arglist__32566);\n      return G__32565__delegate(x, y, more);\n    };\n    G__32565.cljs$core$IFn$_invoke$arity$variadic = G__32565__delegate;\n    return G__32565;\n  }();\n  _ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return ___1.call(this, x);\n      case 2:\n        return ___2.call(this, x, y);\n      default:\n        return ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _.cljs$lang$maxFixedArity = 2;\n  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;\n  _.cljs$core$IFn$_invoke$arity$1 = ___1;\n  _.cljs$core$IFn$_invoke$arity$2 = ___2;\n  _.cljs$core$IFn$_invoke$arity$variadic = ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _;\n}();\ncljs.core._STAR_ = function() {\n  var _STAR_ = null;\n  var _STAR___0 = function() {\n    return 1;\n  };\n  var _STAR___1 = function(x) {\n    return x;\n  };\n  var _STAR___2 = function(x, y) {\n    return x * y;\n  };\n  var _STAR___3 = function() {\n    var G__32567__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, _STAR_, x * y, more);\n    };\n    var G__32567 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32567__delegate.call(this, x, y, more);\n    };\n    G__32567.cljs$lang$maxFixedArity = 2;\n    G__32567.cljs$lang$applyTo = function(arglist__32568) {\n      var x = cljs.core.first(arglist__32568);\n      arglist__32568 = cljs.core.next(arglist__32568);\n      var y = cljs.core.first(arglist__32568);\n      var more = cljs.core.rest(arglist__32568);\n      return G__32567__delegate(x, y, more);\n    };\n    G__32567.cljs$core$IFn$_invoke$arity$variadic = G__32567__delegate;\n    return G__32567;\n  }();\n  _STAR_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return _STAR___0.call(this);\n      case 1:\n        return _STAR___1.call(this, x);\n      case 2:\n        return _STAR___2.call(this, x, y);\n      default:\n        return _STAR___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _STAR_.cljs$lang$maxFixedArity = 2;\n  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;\n  _STAR_.cljs$core$IFn$_invoke$arity$0 = _STAR___0;\n  _STAR_.cljs$core$IFn$_invoke$arity$1 = _STAR___1;\n  _STAR_.cljs$core$IFn$_invoke$arity$2 = _STAR___2;\n  _STAR_.cljs$core$IFn$_invoke$arity$variadic = _STAR___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _STAR_;\n}();\ncljs.core._SLASH_ = function() {\n  var _SLASH_ = null;\n  var _SLASH___1 = function(x) {\n    return _SLASH_.call(null, 1, x);\n  };\n  var _SLASH___2 = function(x, y) {\n    return x / y;\n  };\n  var _SLASH___3 = function() {\n    var G__32569__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more);\n    };\n    var G__32569 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32569__delegate.call(this, x, y, more);\n    };\n    G__32569.cljs$lang$maxFixedArity = 2;\n    G__32569.cljs$lang$applyTo = function(arglist__32570) {\n      var x = cljs.core.first(arglist__32570);\n      arglist__32570 = cljs.core.next(arglist__32570);\n      var y = cljs.core.first(arglist__32570);\n      var more = cljs.core.rest(arglist__32570);\n      return G__32569__delegate(x, y, more);\n    };\n    G__32569.cljs$core$IFn$_invoke$arity$variadic = G__32569__delegate;\n    return G__32569;\n  }();\n  _SLASH_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _SLASH___1.call(this, x);\n      case 2:\n        return _SLASH___2.call(this, x, y);\n      default:\n        return _SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _SLASH_.cljs$lang$maxFixedArity = 2;\n  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;\n  _SLASH_.cljs$core$IFn$_invoke$arity$1 = _SLASH___1;\n  _SLASH_.cljs$core$IFn$_invoke$arity$2 = _SLASH___2;\n  _SLASH_.cljs$core$IFn$_invoke$arity$variadic = _SLASH___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _SLASH_;\n}();\ncljs.core._LT_ = function() {\n  var _LT_ = null;\n  var _LT___1 = function(x) {\n    return true;\n  };\n  var _LT___2 = function(x, y) {\n    return x &lt; y;\n  };\n  var _LT___3 = function() {\n    var G__32571__delegate = function(x, y, more) {\n      while (true) {\n        if (x &lt; y) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32572 = y;\n            var G__32573 = cljs.core.first.call(null, more);\n            var G__32574 = cljs.core.next.call(null, more);\n            x = G__32572;\n            y = G__32573;\n            more = G__32574;\n            continue;\n          } else {\n            return y &lt; cljs.core.first.call(null, more);\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32571 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32571__delegate.call(this, x, y, more);\n    };\n    G__32571.cljs$lang$maxFixedArity = 2;\n    G__32571.cljs$lang$applyTo = function(arglist__32575) {\n      var x = cljs.core.first(arglist__32575);\n      arglist__32575 = cljs.core.next(arglist__32575);\n      var y = cljs.core.first(arglist__32575);\n      var more = cljs.core.rest(arglist__32575);\n      return G__32571__delegate(x, y, more);\n    };\n    G__32571.cljs$core$IFn$_invoke$arity$variadic = G__32571__delegate;\n    return G__32571;\n  }();\n  _LT_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _LT___1.call(this, x);\n      case 2:\n        return _LT___2.call(this, x, y);\n      default:\n        return _LT___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _LT_.cljs$lang$maxFixedArity = 2;\n  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;\n  _LT_.cljs$core$IFn$_invoke$arity$1 = _LT___1;\n  _LT_.cljs$core$IFn$_invoke$arity$2 = _LT___2;\n  _LT_.cljs$core$IFn$_invoke$arity$variadic = _LT___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _LT_;\n}();\ncljs.core._LT__EQ_ = function() {\n  var _LT__EQ_ = null;\n  var _LT__EQ___1 = function(x) {\n    return true;\n  };\n  var _LT__EQ___2 = function(x, y) {\n    return x &lt;= y;\n  };\n  var _LT__EQ___3 = function() {\n    var G__32576__delegate = function(x, y, more) {\n      while (true) {\n        if (x &lt;= y) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32577 = y;\n            var G__32578 = cljs.core.first.call(null, more);\n            var G__32579 = cljs.core.next.call(null, more);\n            x = G__32577;\n            y = G__32578;\n            more = G__32579;\n            continue;\n          } else {\n            return y &lt;= cljs.core.first.call(null, more);\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32576 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32576__delegate.call(this, x, y, more);\n    };\n    G__32576.cljs$lang$maxFixedArity = 2;\n    G__32576.cljs$lang$applyTo = function(arglist__32580) {\n      var x = cljs.core.first(arglist__32580);\n      arglist__32580 = cljs.core.next(arglist__32580);\n      var y = cljs.core.first(arglist__32580);\n      var more = cljs.core.rest(arglist__32580);\n      return G__32576__delegate(x, y, more);\n    };\n    G__32576.cljs$core$IFn$_invoke$arity$variadic = G__32576__delegate;\n    return G__32576;\n  }();\n  _LT__EQ_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _LT__EQ___1.call(this, x);\n      case 2:\n        return _LT__EQ___2.call(this, x, y);\n      default:\n        return _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _LT__EQ_.cljs$lang$maxFixedArity = 2;\n  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;\n  _LT__EQ_.cljs$core$IFn$_invoke$arity$1 = _LT__EQ___1;\n  _LT__EQ_.cljs$core$IFn$_invoke$arity$2 = _LT__EQ___2;\n  _LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _LT__EQ_;\n}();\ncljs.core._GT_ = function() {\n  var _GT_ = null;\n  var _GT___1 = function(x) {\n    return true;\n  };\n  var _GT___2 = function(x, y) {\n    return x &gt; y;\n  };\n  var _GT___3 = function() {\n    var G__32581__delegate = function(x, y, more) {\n      while (true) {\n        if (x &gt; y) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32582 = y;\n            var G__32583 = cljs.core.first.call(null, more);\n            var G__32584 = cljs.core.next.call(null, more);\n            x = G__32582;\n            y = G__32583;\n            more = G__32584;\n            continue;\n          } else {\n            return y &gt; cljs.core.first.call(null, more);\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32581 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32581__delegate.call(this, x, y, more);\n    };\n    G__32581.cljs$lang$maxFixedArity = 2;\n    G__32581.cljs$lang$applyTo = function(arglist__32585) {\n      var x = cljs.core.first(arglist__32585);\n      arglist__32585 = cljs.core.next(arglist__32585);\n      var y = cljs.core.first(arglist__32585);\n      var more = cljs.core.rest(arglist__32585);\n      return G__32581__delegate(x, y, more);\n    };\n    G__32581.cljs$core$IFn$_invoke$arity$variadic = G__32581__delegate;\n    return G__32581;\n  }();\n  _GT_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _GT___1.call(this, x);\n      case 2:\n        return _GT___2.call(this, x, y);\n      default:\n        return _GT___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _GT_.cljs$lang$maxFixedArity = 2;\n  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;\n  _GT_.cljs$core$IFn$_invoke$arity$1 = _GT___1;\n  _GT_.cljs$core$IFn$_invoke$arity$2 = _GT___2;\n  _GT_.cljs$core$IFn$_invoke$arity$variadic = _GT___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _GT_;\n}();\ncljs.core._GT__EQ_ = function() {\n  var _GT__EQ_ = null;\n  var _GT__EQ___1 = function(x) {\n    return true;\n  };\n  var _GT__EQ___2 = function(x, y) {\n    return x &gt;= y;\n  };\n  var _GT__EQ___3 = function() {\n    var G__32586__delegate = function(x, y, more) {\n      while (true) {\n        if (x &gt;= y) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32587 = y;\n            var G__32588 = cljs.core.first.call(null, more);\n            var G__32589 = cljs.core.next.call(null, more);\n            x = G__32587;\n            y = G__32588;\n            more = G__32589;\n            continue;\n          } else {\n            return y &gt;= cljs.core.first.call(null, more);\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32586 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32586__delegate.call(this, x, y, more);\n    };\n    G__32586.cljs$lang$maxFixedArity = 2;\n    G__32586.cljs$lang$applyTo = function(arglist__32590) {\n      var x = cljs.core.first(arglist__32590);\n      arglist__32590 = cljs.core.next(arglist__32590);\n      var y = cljs.core.first(arglist__32590);\n      var more = cljs.core.rest(arglist__32590);\n      return G__32586__delegate(x, y, more);\n    };\n    G__32586.cljs$core$IFn$_invoke$arity$variadic = G__32586__delegate;\n    return G__32586;\n  }();\n  _GT__EQ_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _GT__EQ___1.call(this, x);\n      case 2:\n        return _GT__EQ___2.call(this, x, y);\n      default:\n        return _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _GT__EQ_.cljs$lang$maxFixedArity = 2;\n  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;\n  _GT__EQ_.cljs$core$IFn$_invoke$arity$1 = _GT__EQ___1;\n  _GT__EQ_.cljs$core$IFn$_invoke$arity$2 = _GT__EQ___2;\n  _GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _GT__EQ_;\n}();\ncljs.core.dec = function dec(x) {\n  return x - 1;\n};\ncljs.core.max = function() {\n  var max = null;\n  var max__1 = function(x) {\n    return x;\n  };\n  var max__2 = function(x, y) {\n    var x__26478__auto__ = x;\n    var y__26479__auto__ = y;\n    return x__26478__auto__ &gt; y__26479__auto__ ? x__26478__auto__ : y__26479__auto__;\n  };\n  var max__3 = function() {\n    var G__32591__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, max, function() {\n        var x__26478__auto__ = x;\n        var y__26479__auto__ = y;\n        return x__26478__auto__ &gt; y__26479__auto__ ? x__26478__auto__ : y__26479__auto__;\n      }(), more);\n    };\n    var G__32591 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32591__delegate.call(this, x, y, more);\n    };\n    G__32591.cljs$lang$maxFixedArity = 2;\n    G__32591.cljs$lang$applyTo = function(arglist__32592) {\n      var x = cljs.core.first(arglist__32592);\n      arglist__32592 = cljs.core.next(arglist__32592);\n      var y = cljs.core.first(arglist__32592);\n      var more = cljs.core.rest(arglist__32592);\n      return G__32591__delegate(x, y, more);\n    };\n    G__32591.cljs$core$IFn$_invoke$arity$variadic = G__32591__delegate;\n    return G__32591;\n  }();\n  max = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return max__1.call(this, x);\n      case 2:\n        return max__2.call(this, x, y);\n      default:\n        return max__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  max.cljs$lang$maxFixedArity = 2;\n  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;\n  max.cljs$core$IFn$_invoke$arity$1 = max__1;\n  max.cljs$core$IFn$_invoke$arity$2 = max__2;\n  max.cljs$core$IFn$_invoke$arity$variadic = max__3.cljs$core$IFn$_invoke$arity$variadic;\n  return max;\n}();\ncljs.core.min = function() {\n  var min = null;\n  var min__1 = function(x) {\n    return x;\n  };\n  var min__2 = function(x, y) {\n    var x__26485__auto__ = x;\n    var y__26486__auto__ = y;\n    return x__26485__auto__ &lt; y__26486__auto__ ? x__26485__auto__ : y__26486__auto__;\n  };\n  var min__3 = function() {\n    var G__32593__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, min, function() {\n        var x__26485__auto__ = x;\n        var y__26486__auto__ = y;\n        return x__26485__auto__ &lt; y__26486__auto__ ? x__26485__auto__ : y__26486__auto__;\n      }(), more);\n    };\n    var G__32593 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32593__delegate.call(this, x, y, more);\n    };\n    G__32593.cljs$lang$maxFixedArity = 2;\n    G__32593.cljs$lang$applyTo = function(arglist__32594) {\n      var x = cljs.core.first(arglist__32594);\n      arglist__32594 = cljs.core.next(arglist__32594);\n      var y = cljs.core.first(arglist__32594);\n      var more = cljs.core.rest(arglist__32594);\n      return G__32593__delegate(x, y, more);\n    };\n    G__32593.cljs$core$IFn$_invoke$arity$variadic = G__32593__delegate;\n    return G__32593;\n  }();\n  min = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return min__1.call(this, x);\n      case 2:\n        return min__2.call(this, x, y);\n      default:\n        return min__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  min.cljs$lang$maxFixedArity = 2;\n  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;\n  min.cljs$core$IFn$_invoke$arity$1 = min__1;\n  min.cljs$core$IFn$_invoke$arity$2 = min__2;\n  min.cljs$core$IFn$_invoke$arity$variadic = min__3.cljs$core$IFn$_invoke$arity$variadic;\n  return min;\n}();\ncljs.core.byte$ = function byte$(x) {\n  return x;\n};\ncljs.core.char$ = function char$(x) {\n  if (typeof x === &quot;number&quot;) {\n    return String.fromCharCode(x);\n  } else {\n    if (typeof x === &quot;string&quot; &amp;&amp; x.length === 1) {\n      return x;\n    } else {\n      throw new Error(&quot;Argument to char must be a character or number&quot;);\n    }\n  }\n};\ncljs.core.short$ = function short$(x) {\n  return x;\n};\ncljs.core.float$ = function float$(x) {\n  return x;\n};\ncljs.core.double$ = function double$(x) {\n  return x;\n};\ncljs.core.unchecked_byte = function unchecked_byte(x) {\n  return x;\n};\ncljs.core.unchecked_char = function unchecked_char(x) {\n  return x;\n};\ncljs.core.unchecked_short = function unchecked_short(x) {\n  return x;\n};\ncljs.core.unchecked_float = function unchecked_float(x) {\n  return x;\n};\ncljs.core.unchecked_double = function unchecked_double(x) {\n  return x;\n};\ncljs.core.unchecked_add = function() {\n  var unchecked_add = null;\n  var unchecked_add__0 = function() {\n    return 0;\n  };\n  var unchecked_add__1 = function(x) {\n    return x;\n  };\n  var unchecked_add__2 = function(x, y) {\n    return x + y;\n  };\n  var unchecked_add__3 = function() {\n    var G__32595__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_add, x + y, more);\n    };\n    var G__32595 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32595__delegate.call(this, x, y, more);\n    };\n    G__32595.cljs$lang$maxFixedArity = 2;\n    G__32595.cljs$lang$applyTo = function(arglist__32596) {\n      var x = cljs.core.first(arglist__32596);\n      arglist__32596 = cljs.core.next(arglist__32596);\n      var y = cljs.core.first(arglist__32596);\n      var more = cljs.core.rest(arglist__32596);\n      return G__32595__delegate(x, y, more);\n    };\n    G__32595.cljs$core$IFn$_invoke$arity$variadic = G__32595__delegate;\n    return G__32595;\n  }();\n  unchecked_add = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return unchecked_add__0.call(this);\n      case 1:\n        return unchecked_add__1.call(this, x);\n      case 2:\n        return unchecked_add__2.call(this, x, y);\n      default:\n        return unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_add.cljs$lang$maxFixedArity = 2;\n  unchecked_add.cljs$lang$applyTo = unchecked_add__3.cljs$lang$applyTo;\n  unchecked_add.cljs$core$IFn$_invoke$arity$0 = unchecked_add__0;\n  unchecked_add.cljs$core$IFn$_invoke$arity$1 = unchecked_add__1;\n  unchecked_add.cljs$core$IFn$_invoke$arity$2 = unchecked_add__2;\n  unchecked_add.cljs$core$IFn$_invoke$arity$variadic = unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_add;\n}();\ncljs.core.unchecked_add_int = function() {\n  var unchecked_add_int = null;\n  var unchecked_add_int__0 = function() {\n    return 0;\n  };\n  var unchecked_add_int__1 = function(x) {\n    return x;\n  };\n  var unchecked_add_int__2 = function(x, y) {\n    return x + y;\n  };\n  var unchecked_add_int__3 = function() {\n    var G__32597__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_add_int, x + y, more);\n    };\n    var G__32597 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32597__delegate.call(this, x, y, more);\n    };\n    G__32597.cljs$lang$maxFixedArity = 2;\n    G__32597.cljs$lang$applyTo = function(arglist__32598) {\n      var x = cljs.core.first(arglist__32598);\n      arglist__32598 = cljs.core.next(arglist__32598);\n      var y = cljs.core.first(arglist__32598);\n      var more = cljs.core.rest(arglist__32598);\n      return G__32597__delegate(x, y, more);\n    };\n    G__32597.cljs$core$IFn$_invoke$arity$variadic = G__32597__delegate;\n    return G__32597;\n  }();\n  unchecked_add_int = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return unchecked_add_int__0.call(this);\n      case 1:\n        return unchecked_add_int__1.call(this, x);\n      case 2:\n        return unchecked_add_int__2.call(this, x, y);\n      default:\n        return unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_add_int.cljs$lang$maxFixedArity = 2;\n  unchecked_add_int.cljs$lang$applyTo = unchecked_add_int__3.cljs$lang$applyTo;\n  unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = unchecked_add_int__0;\n  unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = unchecked_add_int__1;\n  unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = unchecked_add_int__2;\n  unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_add_int;\n}();\ncljs.core.unchecked_dec = function unchecked_dec(x) {\n  return x - 1;\n};\ncljs.core.unchecked_dec_int = function unchecked_dec_int(x) {\n  return x - 1;\n};\ncljs.core.unchecked_divide_int = function() {\n  var unchecked_divide_int = null;\n  var unchecked_divide_int__1 = function(x) {\n    return unchecked_divide_int.call(null, 1, x);\n  };\n  var unchecked_divide_int__2 = function(x, y) {\n    return x / y;\n  };\n  var unchecked_divide_int__3 = function() {\n    var G__32599__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_divide_int, unchecked_divide_int.call(null, x, y), more);\n    };\n    var G__32599 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32599__delegate.call(this, x, y, more);\n    };\n    G__32599.cljs$lang$maxFixedArity = 2;\n    G__32599.cljs$lang$applyTo = function(arglist__32600) {\n      var x = cljs.core.first(arglist__32600);\n      arglist__32600 = cljs.core.next(arglist__32600);\n      var y = cljs.core.first(arglist__32600);\n      var more = cljs.core.rest(arglist__32600);\n      return G__32599__delegate(x, y, more);\n    };\n    G__32599.cljs$core$IFn$_invoke$arity$variadic = G__32599__delegate;\n    return G__32599;\n  }();\n  unchecked_divide_int = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return unchecked_divide_int__1.call(this, x);\n      case 2:\n        return unchecked_divide_int__2.call(this, x, y);\n      default:\n        return unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_divide_int.cljs$lang$maxFixedArity = 2;\n  unchecked_divide_int.cljs$lang$applyTo = unchecked_divide_int__3.cljs$lang$applyTo;\n  unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = unchecked_divide_int__1;\n  unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = unchecked_divide_int__2;\n  unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_divide_int;\n}();\ncljs.core.unchecked_inc = function unchecked_inc(x) {\n  return x + 1;\n};\ncljs.core.unchecked_inc_int = function unchecked_inc_int(x) {\n  return x + 1;\n};\ncljs.core.unchecked_multiply = function() {\n  var unchecked_multiply = null;\n  var unchecked_multiply__0 = function() {\n    return 1;\n  };\n  var unchecked_multiply__1 = function(x) {\n    return x;\n  };\n  var unchecked_multiply__2 = function(x, y) {\n    return x * y;\n  };\n  var unchecked_multiply__3 = function() {\n    var G__32601__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_multiply, x * y, more);\n    };\n    var G__32601 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32601__delegate.call(this, x, y, more);\n    };\n    G__32601.cljs$lang$maxFixedArity = 2;\n    G__32601.cljs$lang$applyTo = function(arglist__32602) {\n      var x = cljs.core.first(arglist__32602);\n      arglist__32602 = cljs.core.next(arglist__32602);\n      var y = cljs.core.first(arglist__32602);\n      var more = cljs.core.rest(arglist__32602);\n      return G__32601__delegate(x, y, more);\n    };\n    G__32601.cljs$core$IFn$_invoke$arity$variadic = G__32601__delegate;\n    return G__32601;\n  }();\n  unchecked_multiply = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return unchecked_multiply__0.call(this);\n      case 1:\n        return unchecked_multiply__1.call(this, x);\n      case 2:\n        return unchecked_multiply__2.call(this, x, y);\n      default:\n        return unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_multiply.cljs$lang$maxFixedArity = 2;\n  unchecked_multiply.cljs$lang$applyTo = unchecked_multiply__3.cljs$lang$applyTo;\n  unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply__0;\n  unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply__1;\n  unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply__2;\n  unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_multiply;\n}();\ncljs.core.unchecked_multiply_int = function() {\n  var unchecked_multiply_int = null;\n  var unchecked_multiply_int__0 = function() {\n    return 1;\n  };\n  var unchecked_multiply_int__1 = function(x) {\n    return x;\n  };\n  var unchecked_multiply_int__2 = function(x, y) {\n    return x * y;\n  };\n  var unchecked_multiply_int__3 = function() {\n    var G__32603__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_multiply_int, x * y, more);\n    };\n    var G__32603 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32603__delegate.call(this, x, y, more);\n    };\n    G__32603.cljs$lang$maxFixedArity = 2;\n    G__32603.cljs$lang$applyTo = function(arglist__32604) {\n      var x = cljs.core.first(arglist__32604);\n      arglist__32604 = cljs.core.next(arglist__32604);\n      var y = cljs.core.first(arglist__32604);\n      var more = cljs.core.rest(arglist__32604);\n      return G__32603__delegate(x, y, more);\n    };\n    G__32603.cljs$core$IFn$_invoke$arity$variadic = G__32603__delegate;\n    return G__32603;\n  }();\n  unchecked_multiply_int = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 0:\n        return unchecked_multiply_int__0.call(this);\n      case 1:\n        return unchecked_multiply_int__1.call(this, x);\n      case 2:\n        return unchecked_multiply_int__2.call(this, x, y);\n      default:\n        return unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_multiply_int.cljs$lang$maxFixedArity = 2;\n  unchecked_multiply_int.cljs$lang$applyTo = unchecked_multiply_int__3.cljs$lang$applyTo;\n  unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply_int__0;\n  unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply_int__1;\n  unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply_int__2;\n  unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_multiply_int;\n}();\ncljs.core.unchecked_negate = function unchecked_negate(x) {\n  return-x;\n};\ncljs.core.unchecked_negate_int = function unchecked_negate_int(x) {\n  return-x;\n};\ncljs.core.unchecked_remainder_int = function unchecked_remainder_int(x, n) {\n  return cljs.core.mod.call(null, x, n);\n};\ncljs.core.unchecked_subtract = function() {\n  var unchecked_subtract = null;\n  var unchecked_subtract__1 = function(x) {\n    return-x;\n  };\n  var unchecked_subtract__2 = function(x, y) {\n    return x - y;\n  };\n  var unchecked_subtract__3 = function() {\n    var G__32605__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_subtract, x - y, more);\n    };\n    var G__32605 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32605__delegate.call(this, x, y, more);\n    };\n    G__32605.cljs$lang$maxFixedArity = 2;\n    G__32605.cljs$lang$applyTo = function(arglist__32606) {\n      var x = cljs.core.first(arglist__32606);\n      arglist__32606 = cljs.core.next(arglist__32606);\n      var y = cljs.core.first(arglist__32606);\n      var more = cljs.core.rest(arglist__32606);\n      return G__32605__delegate(x, y, more);\n    };\n    G__32605.cljs$core$IFn$_invoke$arity$variadic = G__32605__delegate;\n    return G__32605;\n  }();\n  unchecked_subtract = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return unchecked_subtract__1.call(this, x);\n      case 2:\n        return unchecked_subtract__2.call(this, x, y);\n      default:\n        return unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_subtract.cljs$lang$maxFixedArity = 2;\n  unchecked_subtract.cljs$lang$applyTo = unchecked_subtract__3.cljs$lang$applyTo;\n  unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract__1;\n  unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract__2;\n  unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_subtract;\n}();\ncljs.core.unchecked_subtract_int = function() {\n  var unchecked_subtract_int = null;\n  var unchecked_subtract_int__1 = function(x) {\n    return-x;\n  };\n  var unchecked_subtract_int__2 = function(x, y) {\n    return x - y;\n  };\n  var unchecked_subtract_int__3 = function() {\n    var G__32607__delegate = function(x, y, more) {\n      return cljs.core.reduce.call(null, unchecked_subtract_int, x - y, more);\n    };\n    var G__32607 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32607__delegate.call(this, x, y, more);\n    };\n    G__32607.cljs$lang$maxFixedArity = 2;\n    G__32607.cljs$lang$applyTo = function(arglist__32608) {\n      var x = cljs.core.first(arglist__32608);\n      arglist__32608 = cljs.core.next(arglist__32608);\n      var y = cljs.core.first(arglist__32608);\n      var more = cljs.core.rest(arglist__32608);\n      return G__32607__delegate(x, y, more);\n    };\n    G__32607.cljs$core$IFn$_invoke$arity$variadic = G__32607__delegate;\n    return G__32607;\n  }();\n  unchecked_subtract_int = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return unchecked_subtract_int__1.call(this, x);\n      case 2:\n        return unchecked_subtract_int__2.call(this, x, y);\n      default:\n        return unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  unchecked_subtract_int.cljs$lang$maxFixedArity = 2;\n  unchecked_subtract_int.cljs$lang$applyTo = unchecked_subtract_int__3.cljs$lang$applyTo;\n  unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract_int__1;\n  unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract_int__2;\n  unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;\n  return unchecked_subtract_int;\n}();\ncljs.core.fix = function fix(q) {\n  if (q &gt;= 0) {\n    return Math.floor.call(null, q);\n  } else {\n    return Math.ceil.call(null, q);\n  }\n};\ncljs.core.int$ = function int$(x) {\n  return x | 0;\n};\ncljs.core.unchecked_int = function unchecked_int(x) {\n  return cljs.core.fix.call(null, x);\n};\ncljs.core.long$ = function long$(x) {\n  return cljs.core.fix.call(null, x);\n};\ncljs.core.unchecked_long = function unchecked_long(x) {\n  return cljs.core.fix.call(null, x);\n};\ncljs.core.booleans = function booleans(x) {\n  return x;\n};\ncljs.core.bytes = function bytes(x) {\n  return x;\n};\ncljs.core.chars = function chars(x) {\n  return x;\n};\ncljs.core.shorts = function shorts(x) {\n  return x;\n};\ncljs.core.ints = function ints(x) {\n  return x;\n};\ncljs.core.floats = function floats(x) {\n  return x;\n};\ncljs.core.doubles = function doubles(x) {\n  return x;\n};\ncljs.core.longs = function longs(x) {\n  return x;\n};\ncljs.core.js_mod = function js_mod(n, d) {\n  return n % d;\n};\ncljs.core.mod = function mod(n, d) {\n  return(n % d + d) % d;\n};\ncljs.core.quot = function quot(n, d) {\n  var rem = n % d;\n  return cljs.core.fix.call(null, (n - rem) / d);\n};\ncljs.core.rem = function rem(n, d) {\n  var q = cljs.core.quot.call(null, n, d);\n  return n - d * q;\n};\ncljs.core.rand = function() {\n  var rand = null;\n  var rand__0 = function() {\n    return Math.random.call(null);\n  };\n  var rand__1 = function(n) {\n    return n * rand.call(null);\n  };\n  rand = function(n) {\n    switch(arguments.length) {\n      case 0:\n        return rand__0.call(this);\n      case 1:\n        return rand__1.call(this, n);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  rand.cljs$core$IFn$_invoke$arity$0 = rand__0;\n  rand.cljs$core$IFn$_invoke$arity$1 = rand__1;\n  return rand;\n}();\ncljs.core.rand_int = function rand_int(n) {\n  return cljs.core.fix.call(null, cljs.core.rand.call(null, n));\n};\ncljs.core.bit_xor = function bit_xor(x, y) {\n  return x ^ y;\n};\ncljs.core.bit_and = function bit_and(x, y) {\n  return x &amp; y;\n};\ncljs.core.bit_or = function bit_or(x, y) {\n  return x | y;\n};\ncljs.core.bit_and_not = function bit_and_not(x, y) {\n  return x &amp; ~y;\n};\ncljs.core.bit_clear = function bit_clear(x, n) {\n  return x &amp; ~(1 &lt;&lt; n);\n};\ncljs.core.bit_flip = function bit_flip(x, n) {\n  return x ^ 1 &lt;&lt; n;\n};\ncljs.core.bit_not = function bit_not(x) {\n  return~x;\n};\ncljs.core.bit_set = function bit_set(x, n) {\n  return x | 1 &lt;&lt; n;\n};\ncljs.core.bit_test = function bit_test(x, n) {\n  return(x &amp; 1 &lt;&lt; n) != 0;\n};\ncljs.core.bit_shift_left = function bit_shift_left(x, n) {\n  return x &lt;&lt; n;\n};\ncljs.core.bit_shift_right = function bit_shift_right(x, n) {\n  return x &gt;&gt; n;\n};\ncljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {\n  return x &gt;&gt;&gt; n;\n};\ncljs.core.unsigned_bit_shift_right = function unsigned_bit_shift_right(x, n) {\n  return x &gt;&gt;&gt; n;\n};\ncljs.core.bit_count = function bit_count(v) {\n  var v__$1 = v - (v &gt;&gt; 1 &amp; 1431655765);\n  var v__$2 = (v__$1 &amp; 858993459) + (v__$1 &gt;&gt; 2 &amp; 858993459);\n  return(v__$2 + (v__$2 &gt;&gt; 4) &amp; 252645135) * 16843009 &gt;&gt; 24;\n};\ncljs.core._EQ__EQ_ = function() {\n  var _EQ__EQ_ = null;\n  var _EQ__EQ___1 = function(x) {\n    return true;\n  };\n  var _EQ__EQ___2 = function(x, y) {\n    return cljs.core._equiv.call(null, x, y);\n  };\n  var _EQ__EQ___3 = function() {\n    var G__32609__delegate = function(x, y, more) {\n      while (true) {\n        if (_EQ__EQ_.call(null, x, y)) {\n          if (cljs.core.next.call(null, more)) {\n            var G__32610 = y;\n            var G__32611 = cljs.core.first.call(null, more);\n            var G__32612 = cljs.core.next.call(null, more);\n            x = G__32610;\n            y = G__32611;\n            more = G__32612;\n            continue;\n          } else {\n            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more));\n          }\n        } else {\n          return false;\n        }\n        break;\n      }\n    };\n    var G__32609 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32609__delegate.call(this, x, y, more);\n    };\n    G__32609.cljs$lang$maxFixedArity = 2;\n    G__32609.cljs$lang$applyTo = function(arglist__32613) {\n      var x = cljs.core.first(arglist__32613);\n      arglist__32613 = cljs.core.next(arglist__32613);\n      var y = cljs.core.first(arglist__32613);\n      var more = cljs.core.rest(arglist__32613);\n      return G__32609__delegate(x, y, more);\n    };\n    G__32609.cljs$core$IFn$_invoke$arity$variadic = G__32609__delegate;\n    return G__32609;\n  }();\n  _EQ__EQ_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return _EQ__EQ___1.call(this, x);\n      case 2:\n        return _EQ__EQ___2.call(this, x, y);\n      default:\n        return _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  _EQ__EQ_.cljs$lang$maxFixedArity = 2;\n  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;\n  _EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ__EQ___1;\n  _EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ__EQ___2;\n  _EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return _EQ__EQ_;\n}();\ncljs.core.pos_QMARK_ = function pos_QMARK_(n) {\n  return n &gt; 0;\n};\ncljs.core.zero_QMARK_ = function zero_QMARK_(n) {\n  return n === 0;\n};\ncljs.core.neg_QMARK_ = function neg_QMARK_(x) {\n  return x &lt; 0;\n};\ncljs.core.nthnext = function nthnext(coll, n) {\n  var n__$1 = n;\n  var xs = cljs.core.seq.call(null, coll);\n  while (true) {\n    if (xs &amp;&amp; n__$1 &gt; 0) {\n      var G__32614 = n__$1 - 1;\n      var G__32615 = cljs.core.next.call(null, xs);\n      n__$1 = G__32614;\n      xs = G__32615;\n      continue;\n    } else {\n      return xs;\n    }\n    break;\n  }\n};\ncljs.core.str = function() {\n  var str = null;\n  var str__0 = function() {\n    return &quot;&quot;;\n  };\n  var str__1 = function(x) {\n    if (x == null) {\n      return &quot;&quot;;\n    } else {\n      return x.toString();\n    }\n  };\n  var str__2 = function() {\n    var G__32616__delegate = function(x, ys) {\n      var sb = new goog.string.StringBuffer(str.call(null, x));\n      var more = ys;\n      while (true) {\n        if (cljs.core.truth_(more)) {\n          var G__32617 = sb.append(str.call(null, cljs.core.first.call(null, more)));\n          var G__32618 = cljs.core.next.call(null, more);\n          sb = G__32617;\n          more = G__32618;\n          continue;\n        } else {\n          return sb.toString();\n        }\n        break;\n      }\n    };\n    var G__32616 = function(x, var_args) {\n      var ys = null;\n      if (arguments.length &gt; 1) {\n        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0);\n      }\n      return G__32616__delegate.call(this, x, ys);\n    };\n    G__32616.cljs$lang$maxFixedArity = 1;\n    G__32616.cljs$lang$applyTo = function(arglist__32619) {\n      var x = cljs.core.first(arglist__32619);\n      var ys = cljs.core.rest(arglist__32619);\n      return G__32616__delegate(x, ys);\n    };\n    G__32616.cljs$core$IFn$_invoke$arity$variadic = G__32616__delegate;\n    return G__32616;\n  }();\n  str = function(x, var_args) {\n    var ys = var_args;\n    switch(arguments.length) {\n      case 0:\n        return str__0.call(this);\n      case 1:\n        return str__1.call(this, x);\n      default:\n        return str__2.cljs$core$IFn$_invoke$arity$variadic(x, cljs.core.array_seq(arguments, 1));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  str.cljs$lang$maxFixedArity = 1;\n  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;\n  str.cljs$core$IFn$_invoke$arity$0 = str__0;\n  str.cljs$core$IFn$_invoke$arity$1 = str__1;\n  str.cljs$core$IFn$_invoke$arity$variadic = str__2.cljs$core$IFn$_invoke$arity$variadic;\n  return str;\n}();\ncljs.core.subs = function() {\n  var subs = null;\n  var subs__2 = function(s, start) {\n    return s.substring(start);\n  };\n  var subs__3 = function(s, start, end) {\n    return s.substring(start, end);\n  };\n  subs = function(s, start, end) {\n    switch(arguments.length) {\n      case 2:\n        return subs__2.call(this, s, start);\n      case 3:\n        return subs__3.call(this, s, start, end);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  subs.cljs$core$IFn$_invoke$arity$2 = subs__2;\n  subs.cljs$core$IFn$_invoke$arity$3 = subs__3;\n  return subs;\n}();\ncljs.core.equiv_sequential = function equiv_sequential(x, y) {\n  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? cljs.core.counted_QMARK_.call(null, x) &amp;&amp; cljs.core.counted_QMARK_.call(null, y) &amp;&amp; !(cljs.core.count.call(null, x) === cljs.core.count.call(null, y)) ? false : function() {\n    var xs = cljs.core.seq.call(null, x);\n    var ys = cljs.core.seq.call(null, y);\n    while (true) {\n      if (xs == null) {\n        return ys == null;\n      } else {\n        if (ys == null) {\n          return false;\n        } else {\n          if (cljs.core._EQ_.call(null, cljs.core.first.call(null, xs), cljs.core.first.call(null, ys))) {\n            var G__32620 = cljs.core.next.call(null, xs);\n            var G__32621 = cljs.core.next.call(null, ys);\n            xs = G__32620;\n            ys = G__32621;\n            continue;\n          } else {\n            return false;\n          }\n        }\n      }\n      break;\n    }\n  }() : null);\n};\ncljs.core.hash_coll = function hash_coll(coll) {\n  if (cljs.core.seq.call(null, coll)) {\n    var res = cljs.core.hash.call(null, cljs.core.first.call(null, coll));\n    var s = cljs.core.next.call(null, coll);\n    while (true) {\n      if (s == null) {\n        return res;\n      } else {\n        var G__32622 = cljs.core.hash_combine.call(null, res, cljs.core.hash.call(null, cljs.core.first.call(null, s)));\n        var G__32623 = cljs.core.next.call(null, s);\n        res = G__32622;\n        s = G__32623;\n        continue;\n      }\n      break;\n    }\n  } else {\n    return 0;\n  }\n};\ncljs.core.hash_imap = function hash_imap(m) {\n  var h = 0;\n  var s = cljs.core.seq.call(null, m);\n  while (true) {\n    if (s) {\n      var e = cljs.core.first.call(null, s);\n      var G__32624 = (h + (cljs.core.hash.call(null, cljs.core.key.call(null, e)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e)))) % 4503599627370496;\n      var G__32625 = cljs.core.next.call(null, s);\n      h = G__32624;\n      s = G__32625;\n      continue;\n    } else {\n      return h;\n    }\n    break;\n  }\n};\ncljs.core.hash_iset = function hash_iset(s) {\n  var h = 0;\n  var s__$1 = cljs.core.seq.call(null, s);\n  while (true) {\n    if (s__$1) {\n      var e = cljs.core.first.call(null, s__$1);\n      var G__32626 = (h + cljs.core.hash.call(null, e)) % 4503599627370496;\n      var G__32627 = cljs.core.next.call(null, s__$1);\n      h = G__32626;\n      s__$1 = G__32627;\n      continue;\n    } else {\n      return h;\n    }\n    break;\n  }\n};\ncljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {\n  var seq__32634_32640 = cljs.core.seq.call(null, fn_map);\n  var chunk__32635_32641 = null;\n  var count__32636_32642 = 0;\n  var i__32637_32643 = 0;\n  while (true) {\n    if (i__32637_32643 &lt; count__32636_32642) {\n      var vec__32638_32644 = cljs.core._nth.call(null, chunk__32635_32641, i__32637_32643);\n      var key_name_32645 = cljs.core.nth.call(null, vec__32638_32644, 0, null);\n      var f_32646 = cljs.core.nth.call(null, vec__32638_32644, 1, null);\n      var str_name_32647 = cljs.core.name.call(null, key_name_32645);\n      obj[str_name_32647] = f_32646;\n      var G__32648 = seq__32634_32640;\n      var G__32649 = chunk__32635_32641;\n      var G__32650 = count__32636_32642;\n      var G__32651 = i__32637_32643 + 1;\n      seq__32634_32640 = G__32648;\n      chunk__32635_32641 = G__32649;\n      count__32636_32642 = G__32650;\n      i__32637_32643 = G__32651;\n      continue;\n    } else {\n      var temp__4126__auto___32652 = cljs.core.seq.call(null, seq__32634_32640);\n      if (temp__4126__auto___32652) {\n        var seq__32634_32653__$1 = temp__4126__auto___32652;\n        if (cljs.core.chunked_seq_QMARK_.call(null, seq__32634_32653__$1)) {\n          var c__26927__auto___32654 = cljs.core.chunk_first.call(null, seq__32634_32653__$1);\n          var G__32655 = cljs.core.chunk_rest.call(null, seq__32634_32653__$1);\n          var G__32656 = c__26927__auto___32654;\n          var G__32657 = cljs.core.count.call(null, c__26927__auto___32654);\n          var G__32658 = 0;\n          seq__32634_32640 = G__32655;\n          chunk__32635_32641 = G__32656;\n          count__32636_32642 = G__32657;\n          i__32637_32643 = G__32658;\n          continue;\n        } else {\n          var vec__32639_32659 = cljs.core.first.call(null, seq__32634_32653__$1);\n          var key_name_32660 = cljs.core.nth.call(null, vec__32639_32659, 0, null);\n          var f_32661 = cljs.core.nth.call(null, vec__32639_32659, 1, null);\n          var str_name_32662 = cljs.core.name.call(null, key_name_32660);\n          obj[str_name_32662] = f_32661;\n          var G__32663 = cljs.core.next.call(null, seq__32634_32653__$1);\n          var G__32664 = null;\n          var G__32665 = 0;\n          var G__32666 = 0;\n          seq__32634_32640 = G__32663;\n          chunk__32635_32641 = G__32664;\n          count__32636_32642 = G__32665;\n          i__32637_32643 = G__32666;\n          continue;\n        }\n      } else {\n      }\n    }\n    break;\n  }\n  return obj;\n};\ncljs.core.List = function(meta, first, rest, count, __hash) {\n  this.meta = meta;\n  this.first = first;\n  this.rest = rest;\n  this.count = count;\n  this.__hash = __hash;\n  this.cljs$lang$protocol_mask$partition0$ = 65937646;\n  this.cljs$lang$protocol_mask$partition1$ = 8192;\n};\ncljs.core.List.cljs$lang$type = true;\ncljs.core.List.cljs$lang$ctorStr = &quot;cljs.core/List&quot;;\ncljs.core.List.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/List&quot;);\n};\ncljs.core.List.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.List.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);\n};\ncljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.count === 1) {\n    return null;\n  } else {\n    return self__.rest;\n  }\n};\ncljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.count;\n};\ncljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.first;\n};\ncljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core._rest.call(null, coll__$1);\n};\ncljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  var h__26582__auto__ = self__.__hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_ordered_coll.call(null, coll__$1);\n    self__.__hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.List.EMPTY;\n};\ncljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, coll__$1);\n};\ncljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, start, coll__$1);\n};\ncljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.first;\n};\ncljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.count === 1) {\n    return cljs.core.List.EMPTY;\n  } else {\n    return self__.rest;\n  }\n};\ncljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return coll__$1;\n};\ncljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);\n};\ncljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);\n};\ncljs.core.__GT_List = function __GT_List(meta, first, rest, count, __hash) {\n  return new cljs.core.List(meta, first, rest, count, __hash);\n};\ncljs.core.EmptyList = function(meta) {\n  this.meta = meta;\n  this.cljs$lang$protocol_mask$partition0$ = 65937614;\n  this.cljs$lang$protocol_mask$partition1$ = 8192;\n};\ncljs.core.EmptyList.cljs$lang$type = true;\ncljs.core.EmptyList.cljs$lang$ctorStr = &quot;cljs.core/EmptyList&quot;;\ncljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/EmptyList&quot;);\n};\ncljs.core.EmptyList.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.EmptyList.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.EmptyList(self__.meta);\n};\ncljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return null;\n};\ncljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return 0;\n};\ncljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return null;\n};\ncljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  throw new Error(&quot;Can&apos;t pop empty list&quot;);\n};\ncljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return 0;\n};\ncljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return coll__$1;\n};\ncljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, coll__$1);\n};\ncljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, start, coll__$1);\n};\ncljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return null;\n};\ncljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.List.EMPTY;\n};\ncljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return null;\n};\ncljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.EmptyList(meta__$1);\n};\ncljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.List(self__.meta, o, null, 1, null);\n};\ncljs.core.__GT_EmptyList = function __GT_EmptyList(meta) {\n  return new cljs.core.EmptyList(meta);\n};\ncljs.core.List.EMPTY = new cljs.core.EmptyList(null);\ncljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {\n  var G__32668 = coll;\n  if (G__32668) {\n    var bit__26821__auto__ = G__32668.cljs$lang$protocol_mask$partition0$ &amp; 134217728;\n    if (bit__26821__auto__ || G__32668.cljs$core$IReversible$) {\n      return true;\n    } else {\n      if (!G__32668.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReversible, G__32668);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IReversible, G__32668);\n  }\n};\ncljs.core.rseq = function rseq(coll) {\n  return cljs.core._rseq.call(null, coll);\n};\ncljs.core.reverse = function reverse(coll) {\n  if (cljs.core.reversible_QMARK_.call(null, coll)) {\n    return cljs.core.rseq.call(null, coll);\n  } else {\n    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll);\n  }\n};\ncljs.core.list = function() {\n  var list__delegate = function(xs) {\n    var arr = xs instanceof cljs.core.IndexedSeq &amp;&amp; xs.i === 0 ? xs.arr : function() {\n      var arr = [];\n      var xs__$1 = xs;\n      while (true) {\n        if (!(xs__$1 == null)) {\n          arr.push(cljs.core._first.call(null, xs__$1));\n          var G__32669 = cljs.core._next.call(null, xs__$1);\n          xs__$1 = G__32669;\n          continue;\n        } else {\n          return arr;\n        }\n        break;\n      }\n    }();\n    var i = arr.length;\n    var r = cljs.core.List.EMPTY;\n    while (true) {\n      if (i &gt; 0) {\n        var G__32670 = i - 1;\n        var G__32671 = cljs.core._conj.call(null, r, arr[i - 1]);\n        i = G__32670;\n        r = G__32671;\n        continue;\n      } else {\n        return r;\n      }\n      break;\n    }\n  };\n  var list = function(var_args) {\n    var xs = null;\n    if (arguments.length &gt; 0) {\n      xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0);\n    }\n    return list__delegate.call(this, xs);\n  };\n  list.cljs$lang$maxFixedArity = 0;\n  list.cljs$lang$applyTo = function(arglist__32672) {\n    var xs = cljs.core.seq(arglist__32672);\n    return list__delegate(xs);\n  };\n  list.cljs$core$IFn$_invoke$arity$variadic = list__delegate;\n  return list;\n}();\ncljs.core.Cons = function(meta, first, rest, __hash) {\n  this.meta = meta;\n  this.first = first;\n  this.rest = rest;\n  this.__hash = __hash;\n  this.cljs$lang$protocol_mask$partition0$ = 65929452;\n  this.cljs$lang$protocol_mask$partition1$ = 8192;\n};\ncljs.core.Cons.cljs$lang$type = true;\ncljs.core.Cons.cljs$lang$ctorStr = &quot;cljs.core/Cons&quot;;\ncljs.core.Cons.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/Cons&quot;);\n};\ncljs.core.Cons.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.Cons.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);\n};\ncljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.rest == null) {\n    return null;\n  } else {\n    return cljs.core.seq.call(null, self__.rest);\n  }\n};\ncljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  var h__26582__auto__ = self__.__hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_ordered_coll.call(null, coll__$1);\n    self__.__hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, self__.meta);\n};\ncljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, coll__$1);\n};\ncljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, start, coll__$1);\n};\ncljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.first;\n};\ncljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.rest == null) {\n    return cljs.core.List.EMPTY;\n  } else {\n    return self__.rest;\n  }\n};\ncljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return coll__$1;\n};\ncljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);\n};\ncljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.Cons(null, o, coll__$1, self__.__hash);\n};\ncljs.core.__GT_Cons = function __GT_Cons(meta, first, rest, __hash) {\n  return new cljs.core.Cons(meta, first, rest, __hash);\n};\ncljs.core.cons = function cons(x, coll) {\n  if (function() {\n    var or__26171__auto__ = coll == null;\n    if (or__26171__auto__) {\n      return or__26171__auto__;\n    } else {\n      var G__32676 = coll;\n      if (G__32676) {\n        var bit__26814__auto__ = G__32676.cljs$lang$protocol_mask$partition0$ &amp; 64;\n        if (bit__26814__auto__ || G__32676.cljs$core$ISeq$) {\n          return true;\n        } else {\n          return false;\n        }\n      } else {\n        return false;\n      }\n    }\n  }()) {\n    return new cljs.core.Cons(null, x, coll, null);\n  } else {\n    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null);\n  }\n};\ncljs.core.list_QMARK_ = function list_QMARK_(x) {\n  var G__32678 = x;\n  if (G__32678) {\n    var bit__26821__auto__ = G__32678.cljs$lang$protocol_mask$partition0$ &amp; 33554432;\n    if (bit__26821__auto__ || G__32678.cljs$core$IList$) {\n      return true;\n    } else {\n      if (!G__32678.cljs$lang$protocol_mask$partition0$) {\n        return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IList, G__32678);\n      } else {\n        return false;\n      }\n    }\n  } else {\n    return cljs.core.native_satisfies_QMARK_.call(null, cljs.core.IList, G__32678);\n  }\n};\ncljs.core.hash_keyword = function hash_keyword(k) {\n  return cljs.core.hash_symbol.call(null, k) + 2654435769 | 0;\n};\ncljs.core.Keyword = function(ns, name, fqn, _hash) {\n  this.ns = ns;\n  this.name = name;\n  this.fqn = fqn;\n  this._hash = _hash;\n  this.cljs$lang$protocol_mask$partition0$ = 2153775105;\n  this.cljs$lang$protocol_mask$partition1$ = 4096;\n};\ncljs.core.Keyword.cljs$lang$type = true;\ncljs.core.Keyword.cljs$lang$ctorStr = &quot;cljs.core/Keyword&quot;;\ncljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/Keyword&quot;);\n};\ncljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {\n  var self__ = this;\n  var o__$1 = this;\n  return cljs.core._write.call(null, writer, &quot;:&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn));\n};\ncljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.name;\n};\ncljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.ns;\n};\ncljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  var h__26582__auto__ = self__._hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_keyword.call(null, this$__$1);\n    self__._hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.Keyword.prototype.call = function() {\n  var G__32680 = null;\n  var G__32680__2 = function(self__, coll) {\n    var self__ = this;\n    var self____$1 = this;\n    var kw = self____$1;\n    return cljs.core.get.call(null, coll, kw);\n  };\n  var G__32680__3 = function(self__, coll, not_found) {\n    var self__ = this;\n    var self____$1 = this;\n    var kw = self____$1;\n    return cljs.core.get.call(null, coll, kw, not_found);\n  };\n  G__32680 = function(self__, coll, not_found) {\n    switch(arguments.length) {\n      case 2:\n        return G__32680__2.call(this, self__, coll);\n      case 3:\n        return G__32680__3.call(this, self__, coll, not_found);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  G__32680.cljs$core$IFn$_invoke$arity$2 = G__32680__2;\n  G__32680.cljs$core$IFn$_invoke$arity$3 = G__32680__3;\n  return G__32680;\n}();\ncljs.core.Keyword.prototype.apply = function(self__, args32679) {\n  var self__ = this;\n  var self____$1 = this;\n  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone.call(null, args32679)));\n};\ncljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {\n  var self__ = this;\n  var kw = this;\n  return cljs.core.get.call(null, coll, kw);\n};\ncljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {\n  var self__ = this;\n  var kw = this;\n  return cljs.core.get.call(null, coll, kw, not_found);\n};\ncljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {\n  var self__ = this;\n  var ___$1 = this;\n  if (other instanceof cljs.core.Keyword) {\n    return self__.fqn === other.fqn;\n  } else {\n    return false;\n  }\n};\ncljs.core.Keyword.prototype.toString = function() {\n  var self__ = this;\n  var _ = this;\n  return &quot;:&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn);\n};\ncljs.core.Keyword.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.__GT_Keyword = function __GT_Keyword(ns, name, fqn, _hash) {\n  return new cljs.core.Keyword(ns, name, fqn, _hash);\n};\ncljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {\n  return x instanceof cljs.core.Keyword;\n};\ncljs.core.keyword_identical_QMARK_ = function keyword_identical_QMARK_(x, y) {\n  if (x === y) {\n    return true;\n  } else {\n    if (x instanceof cljs.core.Keyword &amp;&amp; y instanceof cljs.core.Keyword) {\n      return x.fqn === y.fqn;\n    } else {\n      return false;\n    }\n  }\n};\ncljs.core.namespace = function namespace(x) {\n  if (function() {\n    var G__32682 = x;\n    if (G__32682) {\n      var bit__26814__auto__ = G__32682.cljs$lang$protocol_mask$partition1$ &amp; 4096;\n      if (bit__26814__auto__ || G__32682.cljs$core$INamed$) {\n        return true;\n      } else {\n        return false;\n      }\n    } else {\n      return false;\n    }\n  }()) {\n    return cljs.core._namespace.call(null, x);\n  } else {\n    throw new Error(&quot;Doesn&apos;t support namespace: &quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));\n  }\n};\ncljs.core.keyword = function() {\n  var keyword = null;\n  var keyword__1 = function(name) {\n    if (name instanceof cljs.core.Keyword) {\n      return name;\n    } else {\n      if (name instanceof cljs.core.Symbol) {\n        return new cljs.core.Keyword(cljs.core.namespace.call(null, name), cljs.core.name.call(null, name), name.str, null);\n      } else {\n        if (typeof name === &quot;string&quot;) {\n          var parts = name.split(&quot;/&quot;);\n          if (parts.length === 2) {\n            return new cljs.core.Keyword(parts[0], parts[1], name, null);\n          } else {\n            return new cljs.core.Keyword(null, parts[0], name, null);\n          }\n        } else {\n          return null;\n        }\n      }\n    }\n  };\n  var keyword__2 = function(ns, name) {\n    return new cljs.core.Keyword(ns, name, &quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.truth_(ns) ? &quot;&quot; + cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns) + &quot;/&quot; : null) + cljs.core.str.cljs$core$IFn$_invoke$arity$1(name), null);\n  };\n  keyword = function(ns, name) {\n    switch(arguments.length) {\n      case 1:\n        return keyword__1.call(this, ns);\n      case 2:\n        return keyword__2.call(this, ns, name);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  keyword.cljs$core$IFn$_invoke$arity$1 = keyword__1;\n  keyword.cljs$core$IFn$_invoke$arity$2 = keyword__2;\n  return keyword;\n}();\ncljs.core.LazySeq = function(meta, fn, s, __hash) {\n  this.meta = meta;\n  this.fn = fn;\n  this.s = s;\n  this.__hash = __hash;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 32374988;\n};\ncljs.core.LazySeq.cljs$lang$type = true;\ncljs.core.LazySeq.cljs$lang$ctorStr = &quot;cljs.core/LazySeq&quot;;\ncljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/LazySeq&quot;);\n};\ncljs.core.LazySeq.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.LazySeq.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.LazySeq.prototype.sval = function() {\n  var self__ = this;\n  var coll = this;\n  if (self__.fn == null) {\n    return self__.s;\n  } else {\n    self__.s = self__.fn.call(null);\n    self__.fn = null;\n    return self__.s;\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  cljs.core._seq.call(null, coll__$1);\n  if (self__.s == null) {\n    return null;\n  } else {\n    return cljs.core.next.call(null, self__.s);\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  var h__26582__auto__ = self__.__hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_ordered_coll.call(null, coll__$1);\n    self__.__hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, self__.meta);\n};\ncljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, coll__$1);\n};\ncljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.seq_reduce.call(null, f, start, coll__$1);\n};\ncljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  cljs.core._seq.call(null, coll__$1);\n  if (self__.s == null) {\n    return null;\n  } else {\n    return cljs.core.first.call(null, self__.s);\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  cljs.core._seq.call(null, coll__$1);\n  if (!(self__.s == null)) {\n    return cljs.core.rest.call(null, self__.s);\n  } else {\n    return cljs.core.List.EMPTY;\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  coll__$1.sval();\n  if (self__.s == null) {\n    return null;\n  } else {\n    var ls = self__.s;\n    while (true) {\n      if (ls instanceof cljs.core.LazySeq) {\n        var G__32683 = ls.sval();\n        ls = G__32683;\n        continue;\n      } else {\n        self__.s = ls;\n        return cljs.core.seq.call(null, self__.s);\n      }\n      break;\n    }\n  }\n};\ncljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);\n};\ncljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.cons.call(null, o, coll__$1);\n};\ncljs.core.__GT_LazySeq = function __GT_LazySeq(meta, fn, s, __hash) {\n  return new cljs.core.LazySeq(meta, fn, s, __hash);\n};\ncljs.core.ChunkBuffer = function(buf, end) {\n  this.buf = buf;\n  this.end = end;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 2;\n};\ncljs.core.ChunkBuffer.cljs$lang$type = true;\ncljs.core.ChunkBuffer.cljs$lang$ctorStr = &quot;cljs.core/ChunkBuffer&quot;;\ncljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/ChunkBuffer&quot;);\n};\ncljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.end;\n};\ncljs.core.ChunkBuffer.prototype.add = function(o) {\n  var self__ = this;\n  var _ = this;\n  self__.buf[self__.end] = o;\n  return self__.end = self__.end + 1;\n};\ncljs.core.ChunkBuffer.prototype.chunk = function(o) {\n  var self__ = this;\n  var _ = this;\n  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);\n  self__.buf = null;\n  return ret;\n};\ncljs.core.__GT_ChunkBuffer = function __GT_ChunkBuffer(buf, end) {\n  return new cljs.core.ChunkBuffer(buf, end);\n};\ncljs.core.chunk_buffer = function chunk_buffer(capacity) {\n  return new cljs.core.ChunkBuffer(new Array(capacity), 0);\n};\ncljs.core.ArrayChunk = function(arr, off, end) {\n  this.arr = arr;\n  this.off = off;\n  this.end = end;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 524306;\n};\ncljs.core.ArrayChunk.cljs$lang$type = true;\ncljs.core.ArrayChunk.cljs$lang$ctorStr = &quot;cljs.core/ArrayChunk&quot;;\ncljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/ArrayChunk&quot;);\n};\ncljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.array_reduce.call(null, self__.arr, f, self__.arr[self__.off], self__.off + 1);\n};\ncljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.array_reduce.call(null, self__.arr, f, start, self__.off);\n};\ncljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;\ncljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.off === self__.end) {\n    throw new Error(&quot;-drop-first of empty chunk&quot;);\n  } else {\n    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);\n  }\n};\ncljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.arr[self__.off + i];\n};\ncljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (i &gt;= 0 &amp;&amp; i &lt; self__.end - self__.off) {\n    return self__.arr[self__.off + i];\n  } else {\n    return not_found;\n  }\n};\ncljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {\n  var self__ = this;\n  var ___$1 = this;\n  return self__.end - self__.off;\n};\ncljs.core.__GT_ArrayChunk = function __GT_ArrayChunk(arr, off, end) {\n  return new cljs.core.ArrayChunk(arr, off, end);\n};\ncljs.core.array_chunk = function() {\n  var array_chunk = null;\n  var array_chunk__1 = function(arr) {\n    return new cljs.core.ArrayChunk(arr, 0, arr.length);\n  };\n  var array_chunk__2 = function(arr, off) {\n    return new cljs.core.ArrayChunk(arr, off, arr.length);\n  };\n  var array_chunk__3 = function(arr, off, end) {\n    return new cljs.core.ArrayChunk(arr, off, end);\n  };\n  array_chunk = function(arr, off, end) {\n    switch(arguments.length) {\n      case 1:\n        return array_chunk__1.call(this, arr);\n      case 2:\n        return array_chunk__2.call(this, arr, off);\n      case 3:\n        return array_chunk__3.call(this, arr, off, end);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  array_chunk.cljs$core$IFn$_invoke$arity$1 = array_chunk__1;\n  array_chunk.cljs$core$IFn$_invoke$arity$2 = array_chunk__2;\n  array_chunk.cljs$core$IFn$_invoke$arity$3 = array_chunk__3;\n  return array_chunk;\n}();\ncljs.core.ChunkedCons = function(chunk, more, meta, __hash) {\n  this.chunk = chunk;\n  this.more = more;\n  this.meta = meta;\n  this.__hash = __hash;\n  this.cljs$lang$protocol_mask$partition0$ = 31850732;\n  this.cljs$lang$protocol_mask$partition1$ = 1536;\n};\ncljs.core.ChunkedCons.cljs$lang$type = true;\ncljs.core.ChunkedCons.cljs$lang$ctorStr = &quot;cljs.core/ChunkedCons&quot;;\ncljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/ChunkedCons&quot;);\n};\ncljs.core.ChunkedCons.prototype.toString = function() {\n  var self__ = this;\n  var coll = this;\n  return cljs.core.pr_str_STAR_.call(null, coll);\n};\ncljs.core.ChunkedCons.prototype.equiv = function(other) {\n  var self__ = this;\n  var this$ = this;\n  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.meta;\n};\ncljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (cljs.core._count.call(null, self__.chunk) &gt; 1) {\n    return new cljs.core.ChunkedCons(cljs.core._drop_first.call(null, self__.chunk), self__.more, self__.meta, null);\n  } else {\n    var more__$1 = cljs.core._seq.call(null, self__.more);\n    if (more__$1 == null) {\n      return null;\n    } else {\n      return more__$1;\n    }\n  }\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  var h__26582__auto__ = self__.__hash;\n  if (!(h__26582__auto__ == null)) {\n    return h__26582__auto__;\n  } else {\n    var h__26582__auto____$1 = cljs.core.hash_ordered_coll.call(null, coll__$1);\n    self__.__hash = h__26582__auto____$1;\n    return h__26582__auto____$1;\n  }\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.equiv_sequential.call(null, coll__$1, other);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, self__.meta);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return cljs.core._nth.call(null, self__.chunk, 0);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (cljs.core._count.call(null, self__.chunk) &gt; 1) {\n    return new cljs.core.ChunkedCons(cljs.core._drop_first.call(null, self__.chunk), self__.more, self__.meta, null);\n  } else {\n    if (self__.more == null) {\n      return cljs.core.List.EMPTY;\n    } else {\n      return self__.more;\n    }\n  }\n};\ncljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return coll__$1;\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  return self__.chunk;\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.more == null) {\n    return cljs.core.List.EMPTY;\n  } else {\n    return self__.more;\n  }\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {\n  var self__ = this;\n  var coll__$1 = this;\n  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {\n  var self__ = this;\n  var this$__$1 = this;\n  return cljs.core.cons.call(null, o, this$__$1);\n};\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {\n  var self__ = this;\n  var coll__$1 = this;\n  if (self__.more == null) {\n    return null;\n  } else {\n    return self__.more;\n  }\n};\ncljs.core.__GT_ChunkedCons = function __GT_ChunkedCons(chunk, more, meta, __hash) {\n  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);\n};\ncljs.core.chunk_cons = function chunk_cons(chunk, rest) {\n  if (cljs.core._count.call(null, chunk) === 0) {\n    return rest;\n  } else {\n    return new cljs.core.ChunkedCons(chunk, rest, null, null);\n  }\n};\ncljs.core.chunk_append = function chunk_append(b, x) {\n  return b.add(x);\n};\ncljs.core.chunk = function chunk(b) {\n  return b.chunk();\n};\ncljs.core.chunk_first = function chunk_first(s) {\n  return cljs.core._chunked_first.call(null, s);\n};\ncljs.core.chunk_rest = function chunk_rest(s) {\n  return cljs.core._chunked_rest.call(null, s);\n};\ncljs.core.chunk_next = function chunk_next(s) {\n  if (function() {\n    var G__32685 = s;\n    if (G__32685) {\n      var bit__26814__auto__ = G__32685.cljs$lang$protocol_mask$partition1$ &amp; 1024;\n      if (bit__26814__auto__ || G__32685.cljs$core$IChunkedNext$) {\n        return true;\n      } else {\n        return false;\n      }\n    } else {\n      return false;\n    }\n  }()) {\n    return cljs.core._chunked_next.call(null, s);\n  } else {\n    return cljs.core.seq.call(null, cljs.core._chunked_rest.call(null, s));\n  }\n};\ncljs.core.to_array = function to_array(s) {\n  var ary = [];\n  var s__$1 = s;\n  while (true) {\n    if (cljs.core.seq.call(null, s__$1)) {\n      ary.push(cljs.core.first.call(null, s__$1));\n      var G__32686 = cljs.core.next.call(null, s__$1);\n      s__$1 = G__32686;\n      continue;\n    } else {\n      return ary;\n    }\n    break;\n  }\n};\ncljs.core.to_array_2d = function to_array_2d(coll) {\n  var ret = new Array(cljs.core.count.call(null, coll));\n  var i_32687 = 0;\n  var xs_32688 = cljs.core.seq.call(null, coll);\n  while (true) {\n    if (xs_32688) {\n      ret[i_32687] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs_32688));\n      var G__32689 = i_32687 + 1;\n      var G__32690 = cljs.core.next.call(null, xs_32688);\n      i_32687 = G__32689;\n      xs_32688 = G__32690;\n      continue;\n    } else {\n    }\n    break;\n  }\n  return ret;\n};\ncljs.core.int_array = function() {\n  var int_array = null;\n  var int_array__1 = function(size_or_seq) {\n    if (typeof size_or_seq === &quot;number&quot;) {\n      return int_array.call(null, size_or_seq, null);\n    } else {\n      return cljs.core.into_array.call(null, size_or_seq);\n    }\n  };\n  var int_array__2 = function(size, init_val_or_seq) {\n    var a = new Array(size);\n    if (cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {\n      var s = cljs.core.seq.call(null, init_val_or_seq);\n      var i = 0;\n      var s__$1 = s;\n      while (true) {\n        if (s__$1 &amp;&amp; i &lt; size) {\n          a[i] = cljs.core.first.call(null, s__$1);\n          var G__32691 = i + 1;\n          var G__32692 = cljs.core.next.call(null, s__$1);\n          i = G__32691;\n          s__$1 = G__32692;\n          continue;\n        } else {\n          return a;\n        }\n        break;\n      }\n    } else {\n      var n__27027__auto___32693 = size;\n      var i_32694 = 0;\n      while (true) {\n        if (i_32694 &lt; n__27027__auto___32693) {\n          a[i_32694] = init_val_or_seq;\n          var G__32695 = i_32694 + 1;\n          i_32694 = G__32695;\n          continue;\n        } else {\n        }\n        break;\n      }\n      return a;\n    }\n  };\n  int_array = function(size, init_val_or_seq) {\n    switch(arguments.length) {\n      case 1:\n        return int_array__1.call(this, size);\n      case 2:\n        return int_array__2.call(this, size, init_val_or_seq);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  int_array.cljs$core$IFn$_invoke$arity$1 = int_array__1;\n  int_array.cljs$core$IFn$_invoke$arity$2 = int_array__2;\n  return int_array;\n}();\ncljs.core.long_array = function() {\n  var long_array = null;\n  var long_array__1 = function(size_or_seq) {\n    if (typeof size_or_seq === &quot;number&quot;) {\n      return long_array.call(null, size_or_seq, null);\n    } else {\n      return cljs.core.into_array.call(null, size_or_seq);\n    }\n  };\n  var long_array__2 = function(size, init_val_or_seq) {\n    var a = new Array(size);\n    if (cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {\n      var s = cljs.core.seq.call(null, init_val_or_seq);\n      var i = 0;\n      var s__$1 = s;\n      while (true) {\n        if (s__$1 &amp;&amp; i &lt; size) {\n          a[i] = cljs.core.first.call(null, s__$1);\n          var G__32696 = i + 1;\n          var G__32697 = cljs.core.next.call(null, s__$1);\n          i = G__32696;\n          s__$1 = G__32697;\n          continue;\n        } else {\n          return a;\n        }\n        break;\n      }\n    } else {\n      var n__27027__auto___32698 = size;\n      var i_32699 = 0;\n      while (true) {\n        if (i_32699 &lt; n__27027__auto___32698) {\n          a[i_32699] = init_val_or_seq;\n          var G__32700 = i_32699 + 1;\n          i_32699 = G__32700;\n          continue;\n        } else {\n        }\n        break;\n      }\n      return a;\n    }\n  };\n  long_array = function(size, init_val_or_seq) {\n    switch(arguments.length) {\n      case 1:\n        return long_array__1.call(this, size);\n      case 2:\n        return long_array__2.call(this, size, init_val_or_seq);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  long_array.cljs$core$IFn$_invoke$arity$1 = long_array__1;\n  long_array.cljs$core$IFn$_invoke$arity$2 = long_array__2;\n  return long_array;\n}();\ncljs.core.double_array = function() {\n  var double_array = null;\n  var double_array__1 = function(size_or_seq) {\n    if (typeof size_or_seq === &quot;number&quot;) {\n      return double_array.call(null, size_or_seq, null);\n    } else {\n      return cljs.core.into_array.call(null, size_or_seq);\n    }\n  };\n  var double_array__2 = function(size, init_val_or_seq) {\n    var a = new Array(size);\n    if (cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {\n      var s = cljs.core.seq.call(null, init_val_or_seq);\n      var i = 0;\n      var s__$1 = s;\n      while (true) {\n        if (s__$1 &amp;&amp; i &lt; size) {\n          a[i] = cljs.core.first.call(null, s__$1);\n          var G__32701 = i + 1;\n          var G__32702 = cljs.core.next.call(null, s__$1);\n          i = G__32701;\n          s__$1 = G__32702;\n          continue;\n        } else {\n          return a;\n        }\n        break;\n      }\n    } else {\n      var n__27027__auto___32703 = size;\n      var i_32704 = 0;\n      while (true) {\n        if (i_32704 &lt; n__27027__auto___32703) {\n          a[i_32704] = init_val_or_seq;\n          var G__32705 = i_32704 + 1;\n          i_32704 = G__32705;\n          continue;\n        } else {\n        }\n        break;\n      }\n      return a;\n    }\n  };\n  double_array = function(size, init_val_or_seq) {\n    switch(arguments.length) {\n      case 1:\n        return double_array__1.call(this, size);\n      case 2:\n        return double_array__2.call(this, size, init_val_or_seq);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  double_array.cljs$core$IFn$_invoke$arity$1 = double_array__1;\n  double_array.cljs$core$IFn$_invoke$arity$2 = double_array__2;\n  return double_array;\n}();\ncljs.core.object_array = function() {\n  var object_array = null;\n  var object_array__1 = function(size_or_seq) {\n    if (typeof size_or_seq === &quot;number&quot;) {\n      return object_array.call(null, size_or_seq, null);\n    } else {\n      return cljs.core.into_array.call(null, size_or_seq);\n    }\n  };\n  var object_array__2 = function(size, init_val_or_seq) {\n    var a = new Array(size);\n    if (cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {\n      var s = cljs.core.seq.call(null, init_val_or_seq);\n      var i = 0;\n      var s__$1 = s;\n      while (true) {\n        if (s__$1 &amp;&amp; i &lt; size) {\n          a[i] = cljs.core.first.call(null, s__$1);\n          var G__32706 = i + 1;\n          var G__32707 = cljs.core.next.call(null, s__$1);\n          i = G__32706;\n          s__$1 = G__32707;\n          continue;\n        } else {\n          return a;\n        }\n        break;\n      }\n    } else {\n      var n__27027__auto___32708 = size;\n      var i_32709 = 0;\n      while (true) {\n        if (i_32709 &lt; n__27027__auto___32708) {\n          a[i_32709] = init_val_or_seq;\n          var G__32710 = i_32709 + 1;\n          i_32709 = G__32710;\n          continue;\n        } else {\n        }\n        break;\n      }\n      return a;\n    }\n  };\n  object_array = function(size, init_val_or_seq) {\n    switch(arguments.length) {\n      case 1:\n        return object_array__1.call(this, size);\n      case 2:\n        return object_array__2.call(this, size, init_val_or_seq);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  object_array.cljs$core$IFn$_invoke$arity$1 = object_array__1;\n  object_array.cljs$core$IFn$_invoke$arity$2 = object_array__2;\n  return object_array;\n}();\ncljs.core.bounded_count = function bounded_count(s, n) {\n  if (cljs.core.counted_QMARK_.call(null, s)) {\n    return cljs.core.count.call(null, s);\n  } else {\n    var s__$1 = s;\n    var i = n;\n    var sum = 0;\n    while (true) {\n      if (i &gt; 0 &amp;&amp; cljs.core.seq.call(null, s__$1)) {\n        var G__32711 = cljs.core.next.call(null, s__$1);\n        var G__32712 = i - 1;\n        var G__32713 = sum + 1;\n        s__$1 = G__32711;\n        i = G__32712;\n        sum = G__32713;\n        continue;\n      } else {\n        return sum;\n      }\n      break;\n    }\n  }\n};\ncljs.core.spread = function spread(arglist) {\n  if (arglist == null) {\n    return null;\n  } else {\n    if (cljs.core.next.call(null, arglist) == null) {\n      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist));\n    } else {\n      return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)));\n    }\n  }\n};\ncljs.core.concat = function() {\n  var concat = null;\n  var concat__0 = function() {\n    return new cljs.core.LazySeq(null, function() {\n      return null;\n    }, null, null);\n  };\n  var concat__1 = function(x) {\n    return new cljs.core.LazySeq(null, function() {\n      return x;\n    }, null, null);\n  };\n  var concat__2 = function(x, y) {\n    return new cljs.core.LazySeq(null, function() {\n      var s = cljs.core.seq.call(null, x);\n      if (s) {\n        if (cljs.core.chunked_seq_QMARK_.call(null, s)) {\n          return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, s), concat.call(null, cljs.core.chunk_rest.call(null, s), y));\n        } else {\n          return cljs.core.cons.call(null, cljs.core.first.call(null, s), concat.call(null, cljs.core.rest.call(null, s), y));\n        }\n      } else {\n        return y;\n      }\n    }, null, null);\n  };\n  var concat__3 = function() {\n    var G__32714__delegate = function(x, y, zs) {\n      var cat = function cat(xys, zs__$1) {\n        return new cljs.core.LazySeq(null, function() {\n          var xys__$1 = cljs.core.seq.call(null, xys);\n          if (xys__$1) {\n            if (cljs.core.chunked_seq_QMARK_.call(null, xys__$1)) {\n              return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, xys__$1), cat.call(null, cljs.core.chunk_rest.call(null, xys__$1), zs__$1));\n            } else {\n              return cljs.core.cons.call(null, cljs.core.first.call(null, xys__$1), cat.call(null, cljs.core.rest.call(null, xys__$1), zs__$1));\n            }\n          } else {\n            if (cljs.core.truth_(zs__$1)) {\n              return cat.call(null, cljs.core.first.call(null, zs__$1), cljs.core.next.call(null, zs__$1));\n            } else {\n              return null;\n            }\n          }\n        }, null, null);\n      };\n      return cat.call(null, concat.call(null, x, y), zs);\n    };\n    var G__32714 = function(x, y, var_args) {\n      var zs = null;\n      if (arguments.length &gt; 2) {\n        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32714__delegate.call(this, x, y, zs);\n    };\n    G__32714.cljs$lang$maxFixedArity = 2;\n    G__32714.cljs$lang$applyTo = function(arglist__32715) {\n      var x = cljs.core.first(arglist__32715);\n      arglist__32715 = cljs.core.next(arglist__32715);\n      var y = cljs.core.first(arglist__32715);\n      var zs = cljs.core.rest(arglist__32715);\n      return G__32714__delegate(x, y, zs);\n    };\n    G__32714.cljs$core$IFn$_invoke$arity$variadic = G__32714__delegate;\n    return G__32714;\n  }();\n  concat = function(x, y, var_args) {\n    var zs = var_args;\n    switch(arguments.length) {\n      case 0:\n        return concat__0.call(this);\n      case 1:\n        return concat__1.call(this, x);\n      case 2:\n        return concat__2.call(this, x, y);\n      default:\n        return concat__3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  concat.cljs$lang$maxFixedArity = 2;\n  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;\n  concat.cljs$core$IFn$_invoke$arity$0 = concat__0;\n  concat.cljs$core$IFn$_invoke$arity$1 = concat__1;\n  concat.cljs$core$IFn$_invoke$arity$2 = concat__2;\n  concat.cljs$core$IFn$_invoke$arity$variadic = concat__3.cljs$core$IFn$_invoke$arity$variadic;\n  return concat;\n}();\ncljs.core.list_STAR_ = function() {\n  var list_STAR_ = null;\n  var list_STAR___1 = function(args) {\n    return cljs.core.seq.call(null, args);\n  };\n  var list_STAR___2 = function(a, args) {\n    return cljs.core.cons.call(null, a, args);\n  };\n  var list_STAR___3 = function(a, b, args) {\n    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args));\n  };\n  var list_STAR___4 = function(a, b, c, args) {\n    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)));\n  };\n  var list_STAR___5 = function() {\n    var G__32716__delegate = function(a, b, c, d, more) {\n      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))));\n    };\n    var G__32716 = function(a, b, c, d, var_args) {\n      var more = null;\n      if (arguments.length &gt; 4) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0);\n      }\n      return G__32716__delegate.call(this, a, b, c, d, more);\n    };\n    G__32716.cljs$lang$maxFixedArity = 4;\n    G__32716.cljs$lang$applyTo = function(arglist__32717) {\n      var a = cljs.core.first(arglist__32717);\n      arglist__32717 = cljs.core.next(arglist__32717);\n      var b = cljs.core.first(arglist__32717);\n      arglist__32717 = cljs.core.next(arglist__32717);\n      var c = cljs.core.first(arglist__32717);\n      arglist__32717 = cljs.core.next(arglist__32717);\n      var d = cljs.core.first(arglist__32717);\n      var more = cljs.core.rest(arglist__32717);\n      return G__32716__delegate(a, b, c, d, more);\n    };\n    G__32716.cljs$core$IFn$_invoke$arity$variadic = G__32716__delegate;\n    return G__32716;\n  }();\n  list_STAR_ = function(a, b, c, d, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return list_STAR___1.call(this, a);\n      case 2:\n        return list_STAR___2.call(this, a, b);\n      case 3:\n        return list_STAR___3.call(this, a, b, c);\n      case 4:\n        return list_STAR___4.call(this, a, b, c, d);\n      default:\n        return list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  list_STAR_.cljs$lang$maxFixedArity = 4;\n  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;\n  list_STAR_.cljs$core$IFn$_invoke$arity$1 = list_STAR___1;\n  list_STAR_.cljs$core$IFn$_invoke$arity$2 = list_STAR___2;\n  list_STAR_.cljs$core$IFn$_invoke$arity$3 = list_STAR___3;\n  list_STAR_.cljs$core$IFn$_invoke$arity$4 = list_STAR___4;\n  list_STAR_.cljs$core$IFn$_invoke$arity$variadic = list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;\n  return list_STAR_;\n}();\ncljs.core.transient$ = function transient$(coll) {\n  return cljs.core._as_transient.call(null, coll);\n};\ncljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {\n  return cljs.core._persistent_BANG_.call(null, tcoll);\n};\ncljs.core.conj_BANG_ = function() {\n  var conj_BANG_ = null;\n  var conj_BANG___0 = function() {\n    return cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY);\n  };\n  var conj_BANG___1 = function(coll) {\n    return coll;\n  };\n  var conj_BANG___2 = function(tcoll, val) {\n    return cljs.core._conj_BANG_.call(null, tcoll, val);\n  };\n  var conj_BANG___3 = function() {\n    var G__32718__delegate = function(tcoll, val, vals) {\n      while (true) {\n        var ntcoll = cljs.core._conj_BANG_.call(null, tcoll, val);\n        if (cljs.core.truth_(vals)) {\n          var G__32719 = ntcoll;\n          var G__32720 = cljs.core.first.call(null, vals);\n          var G__32721 = cljs.core.next.call(null, vals);\n          tcoll = G__32719;\n          val = G__32720;\n          vals = G__32721;\n          continue;\n        } else {\n          return ntcoll;\n        }\n        break;\n      }\n    };\n    var G__32718 = function(tcoll, val, var_args) {\n      var vals = null;\n      if (arguments.length &gt; 2) {\n        vals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32718__delegate.call(this, tcoll, val, vals);\n    };\n    G__32718.cljs$lang$maxFixedArity = 2;\n    G__32718.cljs$lang$applyTo = function(arglist__32722) {\n      var tcoll = cljs.core.first(arglist__32722);\n      arglist__32722 = cljs.core.next(arglist__32722);\n      var val = cljs.core.first(arglist__32722);\n      var vals = cljs.core.rest(arglist__32722);\n      return G__32718__delegate(tcoll, val, vals);\n    };\n    G__32718.cljs$core$IFn$_invoke$arity$variadic = G__32718__delegate;\n    return G__32718;\n  }();\n  conj_BANG_ = function(tcoll, val, var_args) {\n    var vals = var_args;\n    switch(arguments.length) {\n      case 0:\n        return conj_BANG___0.call(this);\n      case 1:\n        return conj_BANG___1.call(this, tcoll);\n      case 2:\n        return conj_BANG___2.call(this, tcoll, val);\n      default:\n        return conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll, val, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  conj_BANG_.cljs$lang$maxFixedArity = 2;\n  conj_BANG_.cljs$lang$applyTo = conj_BANG___3.cljs$lang$applyTo;\n  conj_BANG_.cljs$core$IFn$_invoke$arity$0 = conj_BANG___0;\n  conj_BANG_.cljs$core$IFn$_invoke$arity$1 = conj_BANG___1;\n  conj_BANG_.cljs$core$IFn$_invoke$arity$2 = conj_BANG___2;\n  conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;\n  return conj_BANG_;\n}();\ncljs.core.assoc_BANG_ = function() {\n  var assoc_BANG_ = null;\n  var assoc_BANG___3 = function(tcoll, key, val) {\n    return cljs.core._assoc_BANG_.call(null, tcoll, key, val);\n  };\n  var assoc_BANG___4 = function() {\n    var G__32723__delegate = function(tcoll, key, val, kvs) {\n      while (true) {\n        var ntcoll = cljs.core._assoc_BANG_.call(null, tcoll, key, val);\n        if (cljs.core.truth_(kvs)) {\n          var G__32724 = ntcoll;\n          var G__32725 = cljs.core.first.call(null, kvs);\n          var G__32726 = cljs.core.second.call(null, kvs);\n          var G__32727 = cljs.core.nnext.call(null, kvs);\n          tcoll = G__32724;\n          key = G__32725;\n          val = G__32726;\n          kvs = G__32727;\n          continue;\n        } else {\n          return ntcoll;\n        }\n        break;\n      }\n    };\n    var G__32723 = function(tcoll, key, val, var_args) {\n      var kvs = null;\n      if (arguments.length &gt; 3) {\n        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0);\n      }\n      return G__32723__delegate.call(this, tcoll, key, val, kvs);\n    };\n    G__32723.cljs$lang$maxFixedArity = 3;\n    G__32723.cljs$lang$applyTo = function(arglist__32728) {\n      var tcoll = cljs.core.first(arglist__32728);\n      arglist__32728 = cljs.core.next(arglist__32728);\n      var key = cljs.core.first(arglist__32728);\n      arglist__32728 = cljs.core.next(arglist__32728);\n      var val = cljs.core.first(arglist__32728);\n      var kvs = cljs.core.rest(arglist__32728);\n      return G__32723__delegate(tcoll, key, val, kvs);\n    };\n    G__32723.cljs$core$IFn$_invoke$arity$variadic = G__32723__delegate;\n    return G__32723;\n  }();\n  assoc_BANG_ = function(tcoll, key, val, var_args) {\n    var kvs = var_args;\n    switch(arguments.length) {\n      case 3:\n        return assoc_BANG___3.call(this, tcoll, key, val);\n      default:\n        return assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll, key, val, cljs.core.array_seq(arguments, 3));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  assoc_BANG_.cljs$lang$maxFixedArity = 3;\n  assoc_BANG_.cljs$lang$applyTo = assoc_BANG___4.cljs$lang$applyTo;\n  assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = assoc_BANG___3;\n  assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;\n  return assoc_BANG_;\n}();\ncljs.core.dissoc_BANG_ = function() {\n  var dissoc_BANG_ = null;\n  var dissoc_BANG___2 = function(tcoll, key) {\n    return cljs.core._dissoc_BANG_.call(null, tcoll, key);\n  };\n  var dissoc_BANG___3 = function() {\n    var G__32729__delegate = function(tcoll, key, ks) {\n      while (true) {\n        var ntcoll = cljs.core._dissoc_BANG_.call(null, tcoll, key);\n        if (cljs.core.truth_(ks)) {\n          var G__32730 = ntcoll;\n          var G__32731 = cljs.core.first.call(null, ks);\n          var G__32732 = cljs.core.next.call(null, ks);\n          tcoll = G__32730;\n          key = G__32731;\n          ks = G__32732;\n          continue;\n        } else {\n          return ntcoll;\n        }\n        break;\n      }\n    };\n    var G__32729 = function(tcoll, key, var_args) {\n      var ks = null;\n      if (arguments.length &gt; 2) {\n        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32729__delegate.call(this, tcoll, key, ks);\n    };\n    G__32729.cljs$lang$maxFixedArity = 2;\n    G__32729.cljs$lang$applyTo = function(arglist__32733) {\n      var tcoll = cljs.core.first(arglist__32733);\n      arglist__32733 = cljs.core.next(arglist__32733);\n      var key = cljs.core.first(arglist__32733);\n      var ks = cljs.core.rest(arglist__32733);\n      return G__32729__delegate(tcoll, key, ks);\n    };\n    G__32729.cljs$core$IFn$_invoke$arity$variadic = G__32729__delegate;\n    return G__32729;\n  }();\n  dissoc_BANG_ = function(tcoll, key, var_args) {\n    var ks = var_args;\n    switch(arguments.length) {\n      case 2:\n        return dissoc_BANG___2.call(this, tcoll, key);\n      default:\n        return dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll, key, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  dissoc_BANG_.cljs$lang$maxFixedArity = 2;\n  dissoc_BANG_.cljs$lang$applyTo = dissoc_BANG___3.cljs$lang$applyTo;\n  dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = dissoc_BANG___2;\n  dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;\n  return dissoc_BANG_;\n}();\ncljs.core.pop_BANG_ = function pop_BANG_(tcoll) {\n  return cljs.core._pop_BANG_.call(null, tcoll);\n};\ncljs.core.disj_BANG_ = function() {\n  var disj_BANG_ = null;\n  var disj_BANG___2 = function(tcoll, val) {\n    return cljs.core._disjoin_BANG_.call(null, tcoll, val);\n  };\n  var disj_BANG___3 = function() {\n    var G__32734__delegate = function(tcoll, val, vals) {\n      while (true) {\n        var ntcoll = cljs.core._disjoin_BANG_.call(null, tcoll, val);\n        if (cljs.core.truth_(vals)) {\n          var G__32735 = ntcoll;\n          var G__32736 = cljs.core.first.call(null, vals);\n          var G__32737 = cljs.core.next.call(null, vals);\n          tcoll = G__32735;\n          val = G__32736;\n          vals = G__32737;\n          continue;\n        } else {\n          return ntcoll;\n        }\n        break;\n      }\n    };\n    var G__32734 = function(tcoll, val, var_args) {\n      var vals = null;\n      if (arguments.length &gt; 2) {\n        vals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32734__delegate.call(this, tcoll, val, vals);\n    };\n    G__32734.cljs$lang$maxFixedArity = 2;\n    G__32734.cljs$lang$applyTo = function(arglist__32738) {\n      var tcoll = cljs.core.first(arglist__32738);\n      arglist__32738 = cljs.core.next(arglist__32738);\n      var val = cljs.core.first(arglist__32738);\n      var vals = cljs.core.rest(arglist__32738);\n      return G__32734__delegate(tcoll, val, vals);\n    };\n    G__32734.cljs$core$IFn$_invoke$arity$variadic = G__32734__delegate;\n    return G__32734;\n  }();\n  disj_BANG_ = function(tcoll, val, var_args) {\n    var vals = var_args;\n    switch(arguments.length) {\n      case 2:\n        return disj_BANG___2.call(this, tcoll, val);\n      default:\n        return disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll, val, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  disj_BANG_.cljs$lang$maxFixedArity = 2;\n  disj_BANG_.cljs$lang$applyTo = disj_BANG___3.cljs$lang$applyTo;\n  disj_BANG_.cljs$core$IFn$_invoke$arity$2 = disj_BANG___2;\n  disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;\n  return disj_BANG_;\n}();\ncljs.core.apply_to = function apply_to(f, argc, args) {\n  var args__$1 = cljs.core.seq.call(null, args);\n  if (argc === 0) {\n    return f.call(null);\n  } else {\n    var a27071 = cljs.core._first.call(null, args__$1);\n    var args__$2 = cljs.core._rest.call(null, args__$1);\n    if (argc === 1) {\n      if (f.cljs$core$IFn$_invoke$arity$1) {\n        return f.cljs$core$IFn$_invoke$arity$1(a27071);\n      } else {\n        return f.call(null, a27071);\n      }\n    } else {\n      var b27072 = cljs.core._first.call(null, args__$2);\n      var args__$3 = cljs.core._rest.call(null, args__$2);\n      if (argc === 2) {\n        if (f.cljs$core$IFn$_invoke$arity$2) {\n          return f.cljs$core$IFn$_invoke$arity$2(a27071, b27072);\n        } else {\n          return f.call(null, a27071, b27072);\n        }\n      } else {\n        var c27073 = cljs.core._first.call(null, args__$3);\n        var args__$4 = cljs.core._rest.call(null, args__$3);\n        if (argc === 3) {\n          if (f.cljs$core$IFn$_invoke$arity$3) {\n            return f.cljs$core$IFn$_invoke$arity$3(a27071, b27072, c27073);\n          } else {\n            return f.call(null, a27071, b27072, c27073);\n          }\n        } else {\n          var d27074 = cljs.core._first.call(null, args__$4);\n          var args__$5 = cljs.core._rest.call(null, args__$4);\n          if (argc === 4) {\n            if (f.cljs$core$IFn$_invoke$arity$4) {\n              return f.cljs$core$IFn$_invoke$arity$4(a27071, b27072, c27073, d27074);\n            } else {\n              return f.call(null, a27071, b27072, c27073, d27074);\n            }\n          } else {\n            var e27075 = cljs.core._first.call(null, args__$5);\n            var args__$6 = cljs.core._rest.call(null, args__$5);\n            if (argc === 5) {\n              if (f.cljs$core$IFn$_invoke$arity$5) {\n                return f.cljs$core$IFn$_invoke$arity$5(a27071, b27072, c27073, d27074, e27075);\n              } else {\n                return f.call(null, a27071, b27072, c27073, d27074, e27075);\n              }\n            } else {\n              var f27076 = cljs.core._first.call(null, args__$6);\n              var args__$7 = cljs.core._rest.call(null, args__$6);\n              if (argc === 6) {\n                if (f.cljs$core$IFn$_invoke$arity$6) {\n                  return f.cljs$core$IFn$_invoke$arity$6(a27071, b27072, c27073, d27074, e27075, f27076);\n                } else {\n                  return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076);\n                }\n              } else {\n                var g27077 = cljs.core._first.call(null, args__$7);\n                var args__$8 = cljs.core._rest.call(null, args__$7);\n                if (argc === 7) {\n                  if (f.cljs$core$IFn$_invoke$arity$7) {\n                    return f.cljs$core$IFn$_invoke$arity$7(a27071, b27072, c27073, d27074, e27075, f27076, g27077);\n                  } else {\n                    return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077);\n                  }\n                } else {\n                  var h27078 = cljs.core._first.call(null, args__$8);\n                  var args__$9 = cljs.core._rest.call(null, args__$8);\n                  if (argc === 8) {\n                    if (f.cljs$core$IFn$_invoke$arity$8) {\n                      return f.cljs$core$IFn$_invoke$arity$8(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078);\n                    } else {\n                      return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078);\n                    }\n                  } else {\n                    var i27079 = cljs.core._first.call(null, args__$9);\n                    var args__$10 = cljs.core._rest.call(null, args__$9);\n                    if (argc === 9) {\n                      if (f.cljs$core$IFn$_invoke$arity$9) {\n                        return f.cljs$core$IFn$_invoke$arity$9(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079);\n                      } else {\n                        return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079);\n                      }\n                    } else {\n                      var j27080 = cljs.core._first.call(null, args__$10);\n                      var args__$11 = cljs.core._rest.call(null, args__$10);\n                      if (argc === 10) {\n                        if (f.cljs$core$IFn$_invoke$arity$10) {\n                          return f.cljs$core$IFn$_invoke$arity$10(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080);\n                        } else {\n                          return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080);\n                        }\n                      } else {\n                        var k27081 = cljs.core._first.call(null, args__$11);\n                        var args__$12 = cljs.core._rest.call(null, args__$11);\n                        if (argc === 11) {\n                          if (f.cljs$core$IFn$_invoke$arity$11) {\n                            return f.cljs$core$IFn$_invoke$arity$11(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081);\n                          } else {\n                            return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081);\n                          }\n                        } else {\n                          var l27082 = cljs.core._first.call(null, args__$12);\n                          var args__$13 = cljs.core._rest.call(null, args__$12);\n                          if (argc === 12) {\n                            if (f.cljs$core$IFn$_invoke$arity$12) {\n                              return f.cljs$core$IFn$_invoke$arity$12(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082);\n                            } else {\n                              return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082);\n                            }\n                          } else {\n                            var m27083 = cljs.core._first.call(null, args__$13);\n                            var args__$14 = cljs.core._rest.call(null, args__$13);\n                            if (argc === 13) {\n                              if (f.cljs$core$IFn$_invoke$arity$13) {\n                                return f.cljs$core$IFn$_invoke$arity$13(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083);\n                              } else {\n                                return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083);\n                              }\n                            } else {\n                              var n27084 = cljs.core._first.call(null, args__$14);\n                              var args__$15 = cljs.core._rest.call(null, args__$14);\n                              if (argc === 14) {\n                                if (f.cljs$core$IFn$_invoke$arity$14) {\n                                  return f.cljs$core$IFn$_invoke$arity$14(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084);\n                                } else {\n                                  return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084);\n                                }\n                              } else {\n                                var o27085 = cljs.core._first.call(null, args__$15);\n                                var args__$16 = cljs.core._rest.call(null, args__$15);\n                                if (argc === 15) {\n                                  if (f.cljs$core$IFn$_invoke$arity$15) {\n                                    return f.cljs$core$IFn$_invoke$arity$15(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085);\n                                  } else {\n                                    return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085);\n                                  }\n                                } else {\n                                  var p27086 = cljs.core._first.call(null, args__$16);\n                                  var args__$17 = cljs.core._rest.call(null, args__$16);\n                                  if (argc === 16) {\n                                    if (f.cljs$core$IFn$_invoke$arity$16) {\n                                      return f.cljs$core$IFn$_invoke$arity$16(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086);\n                                    } else {\n                                      return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086);\n                                    }\n                                  } else {\n                                    var q27087 = cljs.core._first.call(null, args__$17);\n                                    var args__$18 = cljs.core._rest.call(null, args__$17);\n                                    if (argc === 17) {\n                                      if (f.cljs$core$IFn$_invoke$arity$17) {\n                                        return f.cljs$core$IFn$_invoke$arity$17(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087);\n                                      } else {\n                                        return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087);\n                                      }\n                                    } else {\n                                      var r27088 = cljs.core._first.call(null, args__$18);\n                                      var args__$19 = cljs.core._rest.call(null, args__$18);\n                                      if (argc === 18) {\n                                        if (f.cljs$core$IFn$_invoke$arity$18) {\n                                          return f.cljs$core$IFn$_invoke$arity$18(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088);\n                                        } else {\n                                          return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088);\n                                        }\n                                      } else {\n                                        var s27089 = cljs.core._first.call(null, args__$19);\n                                        var args__$20 = cljs.core._rest.call(null, args__$19);\n                                        if (argc === 19) {\n                                          if (f.cljs$core$IFn$_invoke$arity$19) {\n                                            return f.cljs$core$IFn$_invoke$arity$19(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088, s27089);\n                                          } else {\n                                            return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088, s27089);\n                                          }\n                                        } else {\n                                          var t27090 = cljs.core._first.call(null, args__$20);\n                                          var args__$21 = cljs.core._rest.call(null, args__$20);\n                                          if (argc === 20) {\n                                            if (f.cljs$core$IFn$_invoke$arity$20) {\n                                              return f.cljs$core$IFn$_invoke$arity$20(a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088, s27089, t27090);\n                                            } else {\n                                              return f.call(null, a27071, b27072, c27073, d27074, e27075, f27076, g27077, h27078, i27079, j27080, k27081, l27082, m27083, n27084, o27085, p27086, q27087, r27088, s27089, t27090);\n                                            }\n                                          } else {\n                                            throw new Error(&quot;Only up to 20 arguments supported on functions&quot;);\n                                          }\n                                        }\n                                      }\n                                    }\n                                  }\n                                }\n                              }\n                            }\n                          }\n                        }\n                      }\n                    }\n                  }\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n};\ncljs.core.apply = function() {\n  var apply = null;\n  var apply__2 = function(f, args) {\n    var fixed_arity = f.cljs$lang$maxFixedArity;\n    if (f.cljs$lang$applyTo) {\n      var bc = cljs.core.bounded_count.call(null, args, fixed_arity + 1);\n      if (bc &lt;= fixed_arity) {\n        return cljs.core.apply_to.call(null, f, bc, args);\n      } else {\n        return f.cljs$lang$applyTo(args);\n      }\n    } else {\n      return f.apply(f, cljs.core.to_array.call(null, args));\n    }\n  };\n  var apply__3 = function(f, x, args) {\n    var arglist = cljs.core.list_STAR_.call(null, x, args);\n    var fixed_arity = f.cljs$lang$maxFixedArity;\n    if (f.cljs$lang$applyTo) {\n      var bc = cljs.core.bounded_count.call(null, arglist, fixed_arity + 1);\n      if (bc &lt;= fixed_arity) {\n        return cljs.core.apply_to.call(null, f, bc, arglist);\n      } else {\n        return f.cljs$lang$applyTo(arglist);\n      }\n    } else {\n      return f.apply(f, cljs.core.to_array.call(null, arglist));\n    }\n  };\n  var apply__4 = function(f, x, y, args) {\n    var arglist = cljs.core.list_STAR_.call(null, x, y, args);\n    var fixed_arity = f.cljs$lang$maxFixedArity;\n    if (f.cljs$lang$applyTo) {\n      var bc = cljs.core.bounded_count.call(null, arglist, fixed_arity + 1);\n      if (bc &lt;= fixed_arity) {\n        return cljs.core.apply_to.call(null, f, bc, arglist);\n      } else {\n        return f.cljs$lang$applyTo(arglist);\n      }\n    } else {\n      return f.apply(f, cljs.core.to_array.call(null, arglist));\n    }\n  };\n  var apply__5 = function(f, x, y, z, args) {\n    var arglist = cljs.core.list_STAR_.call(null, x, y, z, args);\n    var fixed_arity = f.cljs$lang$maxFixedArity;\n    if (f.cljs$lang$applyTo) {\n      var bc = cljs.core.bounded_count.call(null, arglist, fixed_arity + 1);\n      if (bc &lt;= fixed_arity) {\n        return cljs.core.apply_to.call(null, f, bc, arglist);\n      } else {\n        return f.cljs$lang$applyTo(arglist);\n      }\n    } else {\n      return f.apply(f, cljs.core.to_array.call(null, arglist));\n    }\n  };\n  var apply__6 = function() {\n    var G__32739__delegate = function(f, a, b, c, d, args) {\n      var arglist = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));\n      var fixed_arity = f.cljs$lang$maxFixedArity;\n      if (f.cljs$lang$applyTo) {\n        var bc = cljs.core.bounded_count.call(null, arglist, fixed_arity + 1);\n        if (bc &lt;= fixed_arity) {\n          return cljs.core.apply_to.call(null, f, bc, arglist);\n        } else {\n          return f.cljs$lang$applyTo(arglist);\n        }\n      } else {\n        return f.apply(f, cljs.core.to_array.call(null, arglist));\n      }\n    };\n    var G__32739 = function(f, a, b, c, d, var_args) {\n      var args = null;\n      if (arguments.length &gt; 5) {\n        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0);\n      }\n      return G__32739__delegate.call(this, f, a, b, c, d, args);\n    };\n    G__32739.cljs$lang$maxFixedArity = 5;\n    G__32739.cljs$lang$applyTo = function(arglist__32740) {\n      var f = cljs.core.first(arglist__32740);\n      arglist__32740 = cljs.core.next(arglist__32740);\n      var a = cljs.core.first(arglist__32740);\n      arglist__32740 = cljs.core.next(arglist__32740);\n      var b = cljs.core.first(arglist__32740);\n      arglist__32740 = cljs.core.next(arglist__32740);\n      var c = cljs.core.first(arglist__32740);\n      arglist__32740 = cljs.core.next(arglist__32740);\n      var d = cljs.core.first(arglist__32740);\n      var args = cljs.core.rest(arglist__32740);\n      return G__32739__delegate(f, a, b, c, d, args);\n    };\n    G__32739.cljs$core$IFn$_invoke$arity$variadic = G__32739__delegate;\n    return G__32739;\n  }();\n  apply = function(f, a, b, c, d, var_args) {\n    var args = var_args;\n    switch(arguments.length) {\n      case 2:\n        return apply__2.call(this, f, a);\n      case 3:\n        return apply__3.call(this, f, a, b);\n      case 4:\n        return apply__4.call(this, f, a, b, c);\n      case 5:\n        return apply__5.call(this, f, a, b, c, d);\n      default:\n        return apply__6.cljs$core$IFn$_invoke$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  apply.cljs$lang$maxFixedArity = 5;\n  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;\n  apply.cljs$core$IFn$_invoke$arity$2 = apply__2;\n  apply.cljs$core$IFn$_invoke$arity$3 = apply__3;\n  apply.cljs$core$IFn$_invoke$arity$4 = apply__4;\n  apply.cljs$core$IFn$_invoke$arity$5 = apply__5;\n  apply.cljs$core$IFn$_invoke$arity$variadic = apply__6.cljs$core$IFn$_invoke$arity$variadic;\n  return apply;\n}();\ncljs.core.vary_meta = function() {\n  var vary_meta = null;\n  var vary_meta__2 = function(obj, f) {\n    return cljs.core.with_meta.call(null, obj, f.call(null, cljs.core.meta.call(null, obj)));\n  };\n  var vary_meta__3 = function(obj, f, a) {\n    return cljs.core.with_meta.call(null, obj, f.call(null, cljs.core.meta.call(null, obj), a));\n  };\n  var vary_meta__4 = function(obj, f, a, b) {\n    return cljs.core.with_meta.call(null, obj, f.call(null, cljs.core.meta.call(null, obj), a, b));\n  };\n  var vary_meta__5 = function(obj, f, a, b, c) {\n    return cljs.core.with_meta.call(null, obj, f.call(null, cljs.core.meta.call(null, obj), a, b, c));\n  };\n  var vary_meta__6 = function(obj, f, a, b, c, d) {\n    return cljs.core.with_meta.call(null, obj, f.call(null, cljs.core.meta.call(null, obj), a, b, c, d));\n  };\n  var vary_meta__7 = function() {\n    var G__32741__delegate = function(obj, f, a, b, c, d, args) {\n      return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), a, b, c, d, args));\n    };\n    var G__32741 = function(obj, f, a, b, c, d, var_args) {\n      var args = null;\n      if (arguments.length &gt; 6) {\n        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 6), 0);\n      }\n      return G__32741__delegate.call(this, obj, f, a, b, c, d, args);\n    };\n    G__32741.cljs$lang$maxFixedArity = 6;\n    G__32741.cljs$lang$applyTo = function(arglist__32742) {\n      var obj = cljs.core.first(arglist__32742);\n      arglist__32742 = cljs.core.next(arglist__32742);\n      var f = cljs.core.first(arglist__32742);\n      arglist__32742 = cljs.core.next(arglist__32742);\n      var a = cljs.core.first(arglist__32742);\n      arglist__32742 = cljs.core.next(arglist__32742);\n      var b = cljs.core.first(arglist__32742);\n      arglist__32742 = cljs.core.next(arglist__32742);\n      var c = cljs.core.first(arglist__32742);\n      arglist__32742 = cljs.core.next(arglist__32742);\n      var d = cljs.core.first(arglist__32742);\n      var args = cljs.core.rest(arglist__32742);\n      return G__32741__delegate(obj, f, a, b, c, d, args);\n    };\n    G__32741.cljs$core$IFn$_invoke$arity$variadic = G__32741__delegate;\n    return G__32741;\n  }();\n  vary_meta = function(obj, f, a, b, c, d, var_args) {\n    var args = var_args;\n    switch(arguments.length) {\n      case 2:\n        return vary_meta__2.call(this, obj, f);\n      case 3:\n        return vary_meta__3.call(this, obj, f, a);\n      case 4:\n        return vary_meta__4.call(this, obj, f, a, b);\n      case 5:\n        return vary_meta__5.call(this, obj, f, a, b, c);\n      case 6:\n        return vary_meta__6.call(this, obj, f, a, b, c, d);\n      default:\n        return vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj, f, a, b, c, d, cljs.core.array_seq(arguments, 6));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  vary_meta.cljs$lang$maxFixedArity = 6;\n  vary_meta.cljs$lang$applyTo = vary_meta__7.cljs$lang$applyTo;\n  vary_meta.cljs$core$IFn$_invoke$arity$2 = vary_meta__2;\n  vary_meta.cljs$core$IFn$_invoke$arity$3 = vary_meta__3;\n  vary_meta.cljs$core$IFn$_invoke$arity$4 = vary_meta__4;\n  vary_meta.cljs$core$IFn$_invoke$arity$5 = vary_meta__5;\n  vary_meta.cljs$core$IFn$_invoke$arity$6 = vary_meta__6;\n  vary_meta.cljs$core$IFn$_invoke$arity$variadic = vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;\n  return vary_meta;\n}();\ncljs.core.not_EQ_ = function() {\n  var not_EQ_ = null;\n  var not_EQ___1 = function(x) {\n    return false;\n  };\n  var not_EQ___2 = function(x, y) {\n    return!cljs.core._EQ_.call(null, x, y);\n  };\n  var not_EQ___3 = function() {\n    var G__32743__delegate = function(x, y, more) {\n      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more));\n    };\n    var G__32743 = function(x, y, var_args) {\n      var more = null;\n      if (arguments.length &gt; 2) {\n        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0);\n      }\n      return G__32743__delegate.call(this, x, y, more);\n    };\n    G__32743.cljs$lang$maxFixedArity = 2;\n    G__32743.cljs$lang$applyTo = function(arglist__32744) {\n      var x = cljs.core.first(arglist__32744);\n      arglist__32744 = cljs.core.next(arglist__32744);\n      var y = cljs.core.first(arglist__32744);\n      var more = cljs.core.rest(arglist__32744);\n      return G__32743__delegate(x, y, more);\n    };\n    G__32743.cljs$core$IFn$_invoke$arity$variadic = G__32743__delegate;\n    return G__32743;\n  }();\n  not_EQ_ = function(x, y, var_args) {\n    var more = var_args;\n    switch(arguments.length) {\n      case 1:\n        return not_EQ___1.call(this, x);\n      case 2:\n        return not_EQ___2.call(this, x, y);\n      default:\n        return not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x, y, cljs.core.array_seq(arguments, 2));\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  not_EQ_.cljs$lang$maxFixedArity = 2;\n  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;\n  not_EQ_.cljs$core$IFn$_invoke$arity$1 = not_EQ___1;\n  not_EQ_.cljs$core$IFn$_invoke$arity$2 = not_EQ___2;\n  not_EQ_.cljs$core$IFn$_invoke$arity$variadic = not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;\n  return not_EQ_;\n}();\ncljs.core.not_empty = function not_empty(coll) {\n  if (cljs.core.seq.call(null, coll)) {\n    return coll;\n  } else {\n    return null;\n  }\n};\ncljs.core.nil_iter = function nil_iter() {\n  if (typeof cljs.core.t32748 !== &quot;undefined&quot;) {\n  } else {\n    cljs.core.t32748 = function(nil_iter, meta32749) {\n      this.nil_iter = nil_iter;\n      this.meta32749 = meta32749;\n      this.cljs$lang$protocol_mask$partition1$ = 0;\n      this.cljs$lang$protocol_mask$partition0$ = 393216;\n    };\n    cljs.core.t32748.cljs$lang$type = true;\n    cljs.core.t32748.cljs$lang$ctorStr = &quot;cljs.core/t32748&quot;;\n    cljs.core.t32748.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n      return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/t32748&quot;);\n    };\n    cljs.core.t32748.prototype.hasNext = function() {\n      var self__ = this;\n      var _ = this;\n      return false;\n    };\n    cljs.core.t32748.prototype.next = function() {\n      var self__ = this;\n      var _ = this;\n      return new Error(&quot;No such element&quot;);\n    };\n    cljs.core.t32748.prototype.remove = function() {\n      var self__ = this;\n      var _ = this;\n      return new Error(&quot;Unsupported operation&quot;);\n    };\n    cljs.core.t32748.prototype.cljs$core$IMeta$_meta$arity$1 = function(_32750) {\n      var self__ = this;\n      var _32750__$1 = this;\n      return self__.meta32749;\n    };\n    cljs.core.t32748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_32750, meta32749__$1) {\n      var self__ = this;\n      var _32750__$1 = this;\n      return new cljs.core.t32748(self__.nil_iter, meta32749__$1);\n    };\n    cljs.core.__GT_t32748 = function __GT_t32748(nil_iter__$1, meta32749) {\n      return new cljs.core.t32748(nil_iter__$1, meta32749);\n    };\n  }\n  return new cljs.core.t32748(nil_iter, null);\n};\ncljs.core.StringIter = function(s, i) {\n  this.s = s;\n  this.i = i;\n};\ncljs.core.StringIter.cljs$lang$type = true;\ncljs.core.StringIter.cljs$lang$ctorStr = &quot;cljs.core/StringIter&quot;;\ncljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/StringIter&quot;);\n};\ncljs.core.StringIter.prototype.hasNext = function() {\n  var self__ = this;\n  var _ = this;\n  return self__.i &lt; self__.s.length;\n};\ncljs.core.StringIter.prototype.next = function() {\n  var self__ = this;\n  var _ = this;\n  var ret = self__.s.charAt(self__.i);\n  self__.i = self__.i + 1;\n  return ret;\n};\ncljs.core.StringIter.prototype.remove = function() {\n  var self__ = this;\n  var _ = this;\n  return new Error(&quot;Unsupported operation&quot;);\n};\ncljs.core.__GT_StringIter = function __GT_StringIter(s, i) {\n  return new cljs.core.StringIter(s, i);\n};\ncljs.core.string_iter = function string_iter(x) {\n  return new cljs.core.StringIter(x, 0);\n};\ncljs.core.ArrayIter = function(arr, i) {\n  this.arr = arr;\n  this.i = i;\n};\ncljs.core.ArrayIter.cljs$lang$type = true;\ncljs.core.ArrayIter.cljs$lang$ctorStr = &quot;cljs.core/ArrayIter&quot;;\ncljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/ArrayIter&quot;);\n};\ncljs.core.ArrayIter.prototype.hasNext = function() {\n  var self__ = this;\n  var _ = this;\n  return self__.i &lt; self__.arr.length;\n};\ncljs.core.ArrayIter.prototype.next = function() {\n  var self__ = this;\n  var _ = this;\n  var ret = self__.arr[self__.i];\n  self__.i = self__.i + 1;\n  return ret;\n};\ncljs.core.ArrayIter.prototype.remove = function() {\n  var self__ = this;\n  var _ = this;\n  return new Error(&quot;Unsupported operation&quot;);\n};\ncljs.core.__GT_ArrayIter = function __GT_ArrayIter(arr, i) {\n  return new cljs.core.ArrayIter(arr, i);\n};\ncljs.core.array_iter = function array_iter(x) {\n  return new cljs.core.ArrayIter(x, 0);\n};\ncljs.core.INIT = {};\ncljs.core.START = {};\ncljs.core.SeqIter = function(_seq, _next) {\n  this._seq = _seq;\n  this._next = _next;\n};\ncljs.core.SeqIter.cljs$lang$type = true;\ncljs.core.SeqIter.cljs$lang$ctorStr = &quot;cljs.core/SeqIter&quot;;\ncljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/SeqIter&quot;);\n};\ncljs.core.SeqIter.prototype.hasNext = function() {\n  var self__ = this;\n  var _ = this;\n  if (self__._seq === cljs.core.INIT) {\n    self__._seq = cljs.core.START;\n    self__._next = cljs.core.seq.call(null, self__._next);\n  } else {\n    if (self__._seq === self__._next) {\n      self__._next = cljs.core.next.call(null, self__._seq);\n    } else {\n    }\n  }\n  return!(self__._next == null);\n};\ncljs.core.SeqIter.prototype.next = function() {\n  var self__ = this;\n  var this$ = this;\n  if (cljs.core.not.call(null, this$.hasNext())) {\n    throw new Error(&quot;No such element&quot;);\n  } else {\n    self__._seq = self__._next;\n    return cljs.core.first.call(null, self__._next);\n  }\n};\ncljs.core.SeqIter.prototype.remove = function() {\n  var self__ = this;\n  var _ = this;\n  return new Error(&quot;Unsupported operation&quot;);\n};\ncljs.core.__GT_SeqIter = function __GT_SeqIter(_seq, _next) {\n  return new cljs.core.SeqIter(_seq, _next);\n};\ncljs.core.seq_iter = function seq_iter(coll) {\n  return new cljs.core.SeqIter(cljs.core.INIT, coll);\n};\ncljs.core.iter = function iter(coll) {\n  if (coll == null) {\n    return cljs.core.nil_iter.call(null);\n  } else {\n    if (typeof coll === &quot;string&quot;) {\n      return cljs.core.string_iter.call(null, coll);\n    } else {\n      if (coll instanceof Array) {\n        return cljs.core.array_iter.call(null, coll);\n      } else {\n        return cljs.core.seq_iter.call(null, coll);\n      }\n    }\n  }\n};\ncljs.core.lazy_transformer = function lazy_transformer(stepper) {\n  return new cljs.core.LazyTransformer(stepper, null, null, null);\n};\ncljs.core.Stepper = function(xform, iter) {\n  this.xform = xform;\n  this.iter = iter;\n};\ncljs.core.Stepper.cljs$lang$type = true;\ncljs.core.Stepper.cljs$lang$ctorStr = &quot;cljs.core/Stepper&quot;;\ncljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/Stepper&quot;);\n};\ncljs.core.Stepper.prototype.step = function(lt) {\n  var self__ = this;\n  var this$ = this;\n  while (true) {\n    if (cljs.core.truth_(function() {\n      var and__26159__auto__ = !(lt.stepper == null);\n      if (and__26159__auto__) {\n        return self__.iter.hasNext();\n      } else {\n        return and__26159__auto__;\n      }\n    }())) {\n      if (cljs.core.reduced_QMARK_.call(null, self__.xform.call(null, lt, self__.iter.next()))) {\n        if (lt.rest == null) {\n        } else {\n          lt.rest.stepper = null;\n        }\n      } else {\n        continue;\n      }\n    } else {\n    }\n    break;\n  }\n  if (lt.stepper == null) {\n    return null;\n  } else {\n    return self__.xform.call(null, lt);\n  }\n};\ncljs.core.__GT_Stepper = function __GT_Stepper(xform, iter) {\n  return new cljs.core.Stepper(xform, iter);\n};\ncljs.core.stepper = function stepper(xform, iter) {\n  var stepfn = function() {\n    var stepfn = null;\n    var stepfn__1 = function(result) {\n      var lt = cljs.core.reduced_QMARK_.call(null, result) ? cljs.core.deref.call(null, result) : result;\n      lt.stepper = null;\n      return result;\n    };\n    var stepfn__2 = function(result, input) {\n      var lt = result;\n      lt.first = input;\n      lt.rest = cljs.core.lazy_transformer.call(null, lt.stepper);\n      lt.stepper = null;\n      return lt.rest;\n    };\n    stepfn = function(result, input) {\n      switch(arguments.length) {\n        case 1:\n          return stepfn__1.call(this, result);\n        case 2:\n          return stepfn__2.call(this, result, input);\n      }\n      throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n    };\n    stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;\n    stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;\n    return stepfn;\n  }();\n  return new cljs.core.Stepper(xform.call(null, stepfn), iter);\n};\ncljs.core.MultiStepper = function(xform, iters, nexts) {\n  this.xform = xform;\n  this.iters = iters;\n  this.nexts = nexts;\n};\ncljs.core.MultiStepper.cljs$lang$type = true;\ncljs.core.MultiStepper.cljs$lang$ctorStr = &quot;cljs.core/MultiStepper&quot;;\ncljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/MultiStepper&quot;);\n};\ncljs.core.MultiStepper.prototype.hasNext = function() {\n  var self__ = this;\n  var _ = this;\n  var iters__$1 = cljs.core.seq.call(null, self__.iters);\n  while (true) {\n    if (!(iters__$1 == null)) {\n      var iter = cljs.core.first.call(null, iters__$1);\n      if (cljs.core.not.call(null, iter.hasNext())) {\n        return false;\n      } else {\n        var G__32751 = cljs.core.next.call(null, iters__$1);\n        iters__$1 = G__32751;\n        continue;\n      }\n    } else {\n      return true;\n    }\n    break;\n  }\n};\ncljs.core.MultiStepper.prototype.next = function() {\n  var self__ = this;\n  var _ = this;\n  var n__27027__auto___32752 = self__.iters.length;\n  var i_32753 = 0;\n  while (true) {\n    if (i_32753 &lt; n__27027__auto___32752) {\n      self__.nexts[i_32753] = self__.iters[i_32753].next();\n      var G__32754 = i_32753 + 1;\n      i_32753 = G__32754;\n      continue;\n    } else {\n    }\n    break;\n  }\n  return cljs.core.prim_seq.call(null, self__.nexts, 0);\n};\ncljs.core.MultiStepper.prototype.step = function(lt) {\n  var self__ = this;\n  var this$ = this;\n  while (true) {\n    if (cljs.core.truth_(function() {\n      var and__26159__auto__ = !(lt.stepper == null);\n      if (and__26159__auto__) {\n        return this$.hasNext();\n      } else {\n        return and__26159__auto__;\n      }\n    }())) {\n      if (cljs.core.reduced_QMARK_.call(null, cljs.core.apply.call(null, self__.xform, cljs.core.cons.call(null, lt, this$.next())))) {\n        if (lt.rest == null) {\n        } else {\n          lt.rest.stepper = null;\n        }\n      } else {\n        continue;\n      }\n    } else {\n    }\n    break;\n  }\n  if (lt.stepper == null) {\n    return null;\n  } else {\n    return self__.xform.call(null, lt);\n  }\n};\ncljs.core.__GT_MultiStepper = function __GT_MultiStepper(xform, iters, nexts) {\n  return new cljs.core.MultiStepper(xform, iters, nexts);\n};\ncljs.core.multi_stepper = function() {\n  var multi_stepper = null;\n  var multi_stepper__2 = function(xform, iters) {\n    return multi_stepper.call(null, xform, iters, new Array(iters.length));\n  };\n  var multi_stepper__3 = function(xform, iters, nexts) {\n    var stepfn = function() {\n      var stepfn = null;\n      var stepfn__1 = function(result) {\n        var lt = cljs.core.reduced_QMARK_.call(null, result) ? cljs.core.deref.call(null, result) : result;\n        lt.stepper = null;\n        return lt;\n      };\n      var stepfn__2 = function(result, input) {\n        var lt = result;\n        lt.first = input;\n        lt.rest = cljs.core.lazy_transformer.call(null, lt.stepper);\n        lt.stepper = null;\n        return lt.rest;\n      };\n      stepfn = function(result, input) {\n        switch(arguments.length) {\n          case 1:\n            return stepfn__1.call(this, result);\n          case 2:\n            return stepfn__2.call(this, result, input);\n        }\n        throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n      };\n      stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;\n      stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;\n      return stepfn;\n    }();\n    return new cljs.core.MultiStepper(xform.call(null, stepfn), iters, nexts);\n  };\n  multi_stepper = function(xform, iters, nexts) {\n    switch(arguments.length) {\n      case 2:\n        return multi_stepper__2.call(this, xform, iters);\n      case 3:\n        return multi_stepper__3.call(this, xform, iters, nexts);\n    }\n    throw new Error(&quot;Invalid arity: &quot; + arguments.length);\n  };\n  multi_stepper.cljs$core$IFn$_invoke$arity$2 = multi_stepper__2;\n  multi_stepper.cljs$core$IFn$_invoke$arity$3 = multi_stepper__3;\n  return multi_stepper;\n}();\ncljs.core.LazyTransformer = function(stepper, first, rest, meta) {\n  this.stepper = stepper;\n  this.first = first;\n  this.rest = rest;\n  this.meta = meta;\n  this.cljs$lang$protocol_mask$partition1$ = 0;\n  this.cljs$lang$protocol_mask$partition0$ = 31719628;\n};\ncljs.core.LazyTransformer.cljs$lang$type = true;\ncljs.core.LazyTransformer.cljs$lang$ctorStr = &quot;cljs.core/LazyTransformer&quot;;\ncljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__26738__auto__, writer__26739__auto__, opt__26740__auto__) {\n  return cljs.core._write.call(null, writer__26739__auto__, &quot;cljs.core/LazyTransformer&quot;);\n};\ncljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  if (self__.stepper == null) {\n  } else {\n    cljs.core._seq.call(null, this$__$1);\n  }\n  if (self__.rest == null) {\n    return null;\n  } else {\n    return cljs.core._seq.call(null, self__.rest);\n  }\n};\ncljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  if (self__.stepper == null) {\n  } else {\n    cljs.core._seq.call(null, this$__$1);\n  }\n  if (self__.rest == null) {\n    return null;\n  } else {\n    return self__.first;\n  }\n};\ncljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  if (self__.stepper == null) {\n  } else {\n    cljs.core._seq.call(null, this$__$1);\n  }\n  if (self__.rest == null) {\n    return cljs.core.List.EMPTY;\n  } else {\n    return self__.rest;\n  }\n};\ncljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  if (self__.stepper == null) {\n  } else {\n    self__.stepper.step(this$__$1);\n  }\n  if (self__.rest == null) {\n    return null;\n  } else {\n    return this$__$1;\n  }\n};\ncljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {\n  var self__ = this;\n  var this$__$1 = this;\n  return cljs.core.hash_ordered_coll.call(null, this$__$1);\n};\ncljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {\n  var self__ = this;\n  var this$__$1 = this;\n  var s = cljs.core._seq.call(null, this$__$1);\n  if (!(s == null)) {\n    return cljs.core.equiv_sequential.call(null, this$__$1, other);\n  } else {\n    return cljs.core.sequential_QMARK_.call(null, other) &amp;&amp; cljs.core.seq.call(null, other) == null;\n  }\n};\ncljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {\n  var self__ =