/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.util;

import com.google.protobuf.ByteString;
import com.slimjars.dist.gnu.trove.map.TObjectIntMap;
import com.slimjars.dist.gnu.trove.map.hash.TObjectIntHashMap;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import java.util.Arrays;
import java.util.Comparator;

public class StringTable {
    private TObjectIntMap<String> counts = new TObjectIntHashMap(100);
    private TObjectIntMap<String> stringMap;
    private String[] set;

    public void incr(String s) {
        if (this.counts.containsKey((Object)s)) {
            this.counts.put((Object)s, this.counts.get((Object)s) + 1);
        } else {
            this.counts.put((Object)s, 1);
        }
    }

    public int getIndex(String s) {
        return this.stringMap.get((Object)s);
    }

    public void finish() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int diff = StringTable.this.counts.get((Object)s2) - StringTable.this.counts.get((Object)s1);
                return diff;
            }
        };
        this.set = this.counts.keySet().toArray(new String[0]);
        if (this.set.length > 0) {
            Arrays.sort(this.set, comparator);
            Arrays.sort(this.set, Math.min(128, this.set.length - 1), Math.min(16384, this.set.length - 1));
            Arrays.sort(this.set, Math.min(16384, this.set.length - 1), Math.min(0x200000, this.set.length - 1), comparator);
        }
        this.stringMap = new TObjectIntHashMap(2 * this.set.length);
        for (int i = 0; i < this.set.length; ++i) {
            this.stringMap.put((Object)this.set[i], new Integer(i + 1).intValue());
        }
        this.counts = null;
    }

    public void clear() {
        this.counts = new TObjectIntHashMap(100);
        this.stringMap = null;
        this.set = null;
    }

    public Osmformat.StringTable.Builder serialize() {
        Osmformat.StringTable.Builder builder = Osmformat.StringTable.newBuilder();
        builder.addS(ByteString.copyFromUtf8((String)""));
        for (int i = 0; i < this.set.length; ++i) {
            builder.addS(ByteString.copyFromUtf8((String)this.set[i]));
        }
        return builder;
    }
}

