/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.util;

import com.google.protobuf.ByteString;
import de.topobyte.osm4j.core.model.iface.OsmBounds;
import de.topobyte.osm4j.core.model.impl.Bounds;
import de.topobyte.osm4j.pbf.Compression;
import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import de.topobyte.osm4j.pbf.util.BlockData;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class PbfUtil {
    private static LZ4FastDecompressor lz4Decompressor = null;

    public static Osmformat.HeaderBlock createHeader(String writingProgram, boolean requiresDense, OsmBounds bound) {
        Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
        if (bound != null) {
            Osmformat.HeaderBBox.Builder bbox = Osmformat.HeaderBBox.newBuilder();
            bbox.setLeft(PbfUtil.bboxDegreesToLong(bound.getLeft()));
            bbox.setBottom(PbfUtil.bboxDegreesToLong(bound.getBottom()));
            bbox.setRight(PbfUtil.bboxDegreesToLong(bound.getRight()));
            bbox.setTop(PbfUtil.bboxDegreesToLong(bound.getTop()));
            headerblock.setBbox(bbox);
        }
        headerblock.setWritingprogram(writingProgram);
        headerblock.addRequiredFeatures("OsmSchema-V0.6");
        if (requiresDense) {
            headerblock.addRequiredFeatures("DenseNodes");
        }
        return headerblock.build();
    }

    private static long bboxDegreesToLong(double value) {
        return (long)(value / 1.0E-9);
    }

    public static double bboxLongToDegrees(long value) {
        return (double)value * 1.0E-9;
    }

    public static BlobHeader parseHeader(DataInput input) throws IOException {
        int lengthHeader = input.readInt();
        try {
            return PbfUtil.parseHeader(input, lengthHeader);
        }
        catch (EOFException e) {
            throw new IOException("Unable to parse blob header", e);
        }
    }

    public static BlobHeader parseHeader(DataInput input, int lengthHeader) throws IOException {
        byte[] buf = new byte[lengthHeader];
        input.readFully(buf);
        Fileformat.BlobHeader header = Fileformat.BlobHeader.parseFrom(buf);
        BlobHeader h = new BlobHeader(header.getType(), header.getDatasize(), header.getIndexdata());
        return h;
    }

    public static Fileformat.Blob parseBlock(DataInput data, int lengthData) throws IOException {
        byte[] buf = new byte[lengthData];
        data.readFully(buf);
        Fileformat.Blob blob = Fileformat.Blob.parseFrom(buf);
        return blob;
    }

    private static void initLz4() {
        if (lz4Decompressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            lz4Decompressor = factory.fastDecompressor();
        }
    }

    public static BlockData getBlockData(Fileformat.Blob blob) throws IOException {
        ByteString blobData;
        Compression compression;
        if (blob.hasRaw()) {
            compression = Compression.NONE;
            blobData = blob.getRaw();
        } else if (blob.hasZlibData()) {
            compression = Compression.DEFLATE;
            byte[] uncompressed = new byte[blob.getRawSize()];
            Inflater decompresser = new Inflater();
            decompresser.setInput(blob.getZlibData().toByteArray());
            try {
                decompresser.inflate(uncompressed);
            }
            catch (DataFormatException e) {
                throw new IOException("Error while decompressing gzipped data", e);
            }
            decompresser.end();
            blobData = ByteString.copyFrom((byte[])uncompressed);
        } else if (blob.hasLz4Data()) {
            compression = Compression.LZ4;
            byte[] uncompressed = new byte[blob.getRawSize()];
            PbfUtil.initLz4();
            lz4Decompressor.decompress(blob.getLz4Data().toByteArray(), 0, uncompressed, 0, blob.getRawSize());
            blobData = ByteString.copyFrom((byte[])uncompressed);
        } else {
            throw new IOException("Encountered block without data");
        }
        return new BlockData(blobData, compression);
    }

    public static OsmBounds bounds(Osmformat.HeaderBBox bbox) {
        double left = PbfUtil.bboxLongToDegrees(bbox.getLeft());
        double right = PbfUtil.bboxLongToDegrees(bbox.getRight());
        double top = PbfUtil.bboxLongToDegrees(bbox.getTop());
        double bottom = PbfUtil.bboxLongToDegrees(bbox.getBottom());
        return new Bounds(left, right, top, bottom);
    }
}

