/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.seq.BlockWriter;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import de.topobyte.osm4j.pbf.util.PbfUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CopyBlockwise {
    private static DataInputStream data;
    private static BlockWriter blockWriter;

    public static void main(String[] args) throws IOException {
        if (args.length != 2 && args.length != 3) {
            System.out.println("usage: " + CopyBlockwise.class.getSimpleName() + " <input> <output> [<num blocks>]");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        FileOutputStream output = new FileOutputStream(args[1]);
        boolean nBlocksSpecified = false;
        int nBlocks = 0;
        if (args.length == 3) {
            nBlocksSpecified = true;
            nBlocks = Integer.parseInt(args[2]);
        }
        data = new DataInputStream(input);
        blockWriter = new BlockWriter((OutputStream)output);
        if (nBlocksSpecified) {
            CopyBlockwise.copyBlocks(nBlocks);
        } else {
            CopyBlockwise.copyAllBlocks();
        }
        ((OutputStream)output).close();
    }

    private static void copyAllBlocks() throws IOException {
        try {
            while (true) {
                BlobHeader header = PbfUtil.parseHeader((DataInput)data);
                Fileformat.Blob blob = PbfUtil.parseBlock((DataInput)data, (int)header.getDataLength());
                blockWriter.write(header.getType(), null, blob);
            }
        }
        catch (EOFException eof) {
            return;
        }
    }

    private static void copyBlocks(int nBlocks) throws IOException {
        for (int i = 0; i < nBlocks; ++i) {
            try {
                BlobHeader header = PbfUtil.parseHeader((DataInput)data);
                Fileformat.Blob blob = PbfUtil.parseBlock((DataInput)data, (int)header.getDataLength());
                blockWriter.write(header.getType(), null, blob);
                continue;
            }
            catch (EOFException eof) {
                break;
            }
        }
    }
}

