/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.seq.BlockParser;
import de.topobyte.osm4j.pbf.util.PbfMeta;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;

public class BlockTypeInfo
extends BlockParser {
    private long nBlocks = 0L;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: " + BlockTypeInfo.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        BlockTypeInfo task = new BlockTypeInfo();
        task.parse(input);
        task.finish();
    }

    protected void parse(Osmformat.HeaderBlock block) {
        System.out.println("Header block: " + this.nBlocks);
        ++this.nBlocks;
    }

    protected void parse(Osmformat.PrimitiveBlock block) {
        if (PbfMeta.hasMixedContent((Osmformat.PrimitiveBlock)block)) {
            Set types = PbfMeta.getContentTypes((Osmformat.PrimitiveBlock)block);
            System.out.println(String.format("Mixed content block (%d): %s", this.nBlocks, types.toString()));
        }
        ++this.nBlocks;
    }

    private void finish() {
        System.out.println("Number of blocks: " + this.nBlocks);
    }
}

