/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.seq.BlobParser;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import java.io.FileInputStream;
import java.io.IOException;

public class BlockSizeInfo
extends BlobParser {
    private long nBlocks = 0L;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: " + BlockSizeInfo.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        BlockSizeInfo task = new BlockSizeInfo();
        task.parse(input);
        task.finish();
    }

    protected void parse(BlobHeader header, Fileformat.Blob blob) throws IOException {
        int rawSize = blob.getRawSize();
        if (blob.hasRaw()) {
            System.out.println(String.format("Block %d (uncompressed): raw size: %d", this.nBlocks, rawSize));
        } else if (blob.hasZlibData()) {
            int zlibSize = blob.getZlibData().size();
            System.out.println(String.format("Block %d (gzip): raw size: %d, compressed: %d", this.nBlocks, rawSize, zlibSize));
        } else if (blob.hasLz4Data()) {
            int lz4Size = blob.getLz4Data().size();
            System.out.println(String.format("Block %d (lz4): raw size: %d, compressed: %d", this.nBlocks, rawSize, lz4Size));
        }
        ++this.nBlocks;
    }

    private void finish() {
        System.out.println("Number of blocks: " + this.nBlocks);
    }
}

