/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.seq.BlockParser;
import java.io.FileInputStream;
import java.io.IOException;

public class BlockElementCountInfo
extends BlockParser {
    private long nBlocks = 0L;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: " + BlockElementCountInfo.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        BlockElementCountInfo task = new BlockElementCountInfo();
        task.parse(input);
        task.finish();
    }

    protected void parse(Osmformat.HeaderBlock block) {
        System.out.println("Header block: " + this.nBlocks);
        ++this.nBlocks;
    }

    protected void parse(Osmformat.PrimitiveBlock block) {
        int elements = 0;
        for (int i = 0; i < block.getPrimitivegroupCount(); ++i) {
            Osmformat.PrimitiveGroup group = block.getPrimitivegroup(i);
            elements += group.getNodesCount();
            elements += group.getWaysCount();
            elements += group.getRelationsCount();
            if (!group.hasDense()) continue;
            elements += group.getDense().getIdCount();
        }
        System.out.println(String.format("Block %d: %d", this.nBlocks, elements));
        ++this.nBlocks;
    }

    private void finish() {
        System.out.println("Number of blocks: " + this.nBlocks);
    }
}

