// Compiled by ClojureScript 0.0-2173
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('sablono.util');
goog.require('goog.dom');
goog.require('goog.dom');
goog.require('sablono.interpreter');
goog.require('sablono.interpreter');
goog.require('sablono.util');
goog.require('clojure.walk');
goog.require('clojure.string');
/**
* Add an optional attribute argument to a function that returns a element vector.
*/
sablono.core.wrap_attrs = (function wrap_attrs(func){return (function() { 
var G__12999__delegate = function (args){if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args)))
{var vec__12998 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));var tag = cljs.core.nth.call(null,vec__12998,0,null);var body = cljs.core.nthnext.call(null,vec__12998,1);if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body)))
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else
{return cljs.core.apply.call(null,func,args);
}
};
var G__12999 = function (var_args){
var args = null;if (arguments.length > 0) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return G__12999__delegate.call(this,args);};
G__12999.cljs$lang$maxFixedArity = 0;
G__12999.cljs$lang$applyTo = (function (arglist__13000){
var args = cljs.core.seq(arglist__13000);
return G__12999__delegate(args);
});
G__12999.cljs$core$IFn$_invoke$arity$variadic = G__12999__delegate;
return G__12999;
})()
;
});
sablono.core.update_arglists = (function update_arglists(arglists){var iter__4160__auto__ = (function iter__13005(s__13006){return (new cljs.core.LazySeq(null,(function (){var s__13006__$1 = s__13006;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__13006__$1);if(temp__4092__auto__)
{var s__13006__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__13006__$2))
{var c__4158__auto__ = cljs.core.chunk_first.call(null,s__13006__$2);var size__4159__auto__ = cljs.core.count.call(null,c__4158__auto__);var b__13008 = cljs.core.chunk_buffer.call(null,size__4159__auto__);if((function (){var i__13007 = 0;while(true){
if((i__13007 < size__4159__auto__))
{var args = cljs.core._nth.call(null,c__4158__auto__,i__13007);cljs.core.chunk_append.call(null,b__13008,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",-1682549128,null),args)));
{
var G__13009 = (i__13007 + 1);
i__13007 = G__13009;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13008),iter__13005.call(null,cljs.core.chunk_rest.call(null,s__13006__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13008),null);
}
} else
{var args = cljs.core.first.call(null,s__13006__$2);return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",-1682549128,null),args)),iter__13005.call(null,cljs.core.rest.call(null,s__13006__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4160__auto__.call(null,arglists);
});
/**
* Render the React `component` as an HTML string.
*/
sablono.core.render = (function render(component){var html = cljs.core.atom.call(null,null);React.renderComponentToString(component,(function (p1__13010_SHARP_){return cljs.core.reset_BANG_.call(null,html,p1__13010_SHARP_);
}));
return cljs.core.deref.call(null,html);
});
/**
* Include a list of external stylesheet files.
* @param {...*} var_args
*/
sablono.core.include_css = (function() { 
var include_css__delegate = function (styles){var iter__4160__auto__ = (function iter__13015(s__13016){return (new cljs.core.LazySeq(null,(function (){var s__13016__$1 = s__13016;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__13016__$1);if(temp__4092__auto__)
{var s__13016__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__13016__$2))
{var c__4158__auto__ = cljs.core.chunk_first.call(null,s__13016__$2);var size__4159__auto__ = cljs.core.count.call(null,c__4158__auto__);var b__13018 = cljs.core.chunk_buffer.call(null,size__4159__auto__);if((function (){var i__13017 = 0;while(true){
if((i__13017 < size__4159__auto__))
{var style = cljs.core._nth.call(null,c__4158__auto__,i__13017);cljs.core.chunk_append.call(null,b__13018,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",1017226092),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1017479852),"text/css",new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1014017035),"stylesheet"], null)], null));
{
var G__13019 = (i__13017 + 1);
i__13017 = G__13019;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13018),iter__13015.call(null,cljs.core.chunk_rest.call(null,s__13016__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13018),null);
}
} else
{var style = cljs.core.first.call(null,s__13016__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",1017226092),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1017479852),"text/css",new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1014017035),"stylesheet"], null)], null),iter__13015.call(null,cljs.core.rest.call(null,s__13016__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4160__auto__.call(null,styles);
};
var include_css = function (var_args){
var styles = null;if (arguments.length > 0) {
  styles = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return include_css__delegate.call(this,styles);};
include_css.cljs$lang$maxFixedArity = 0;
include_css.cljs$lang$applyTo = (function (arglist__13020){
var styles = cljs.core.seq(arglist__13020);
return include_css__delegate(styles);
});
include_css.cljs$core$IFn$_invoke$arity$variadic = include_css__delegate;
return include_css;
})()
;
/**
* Include the JavaScript library at `src`.
*/
sablono.core.include_js = (function include_js(src){return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
* Include Facebook's React JavaScript library.
*/
sablono.core.include_react = (function include_react(){return sablono.core.include_js.call(null,"http://fb.me/react-0.8.0.js");
});
/**
* Wraps some content in a HTML hyperlink with the supplied URL.
* @param {...*} var_args
*/
sablono.core.link_to13021 = (function() { 
var link_to13021__delegate = function (url,content){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",1013904339),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,url)], null),content], null);
};
var link_to13021 = function (url,var_args){
var content = null;if (arguments.length > 1) {
  content = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return link_to13021__delegate.call(this,url,content);};
link_to13021.cljs$lang$maxFixedArity = 1;
link_to13021.cljs$lang$applyTo = (function (arglist__13022){
var url = cljs.core.first(arglist__13022);
var content = cljs.core.rest(arglist__13022);
return link_to13021__delegate(url,content);
});
link_to13021.cljs$core$IFn$_invoke$arity$variadic = link_to13021__delegate;
return link_to13021;
})()
;
sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to13021);
/**
* Wraps some content in a HTML hyperlink with the supplied e-mail
* address. If no content provided use the e-mail address as content.
* @param {...*} var_args
*/
sablono.core.mail_to13023 = (function() { 
var mail_to13023__delegate = function (e_mail,p__13024){var vec__13026 = p__13024;var content = cljs.core.nth.call(null,vec__13026,0,null);return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",1013904339),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",1017115293),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__3443__auto__ = content;if(cljs.core.truth_(or__3443__auto__))
{return or__3443__auto__;
} else
{return e_mail;
}
})()], null);
};
var mail_to13023 = function (e_mail,var_args){
var p__13024 = null;if (arguments.length > 1) {
  p__13024 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return mail_to13023__delegate.call(this,e_mail,p__13024);};
mail_to13023.cljs$lang$maxFixedArity = 1;
mail_to13023.cljs$lang$applyTo = (function (arglist__13027){
var e_mail = cljs.core.first(arglist__13027);
var p__13024 = cljs.core.rest(arglist__13027);
return mail_to13023__delegate(e_mail,p__13024);
});
mail_to13023.cljs$core$IFn$_invoke$arity$variadic = mail_to13023__delegate;
return mail_to13023;
})()
;
sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to13023);
/**
* Wrap a collection in an unordered list.
*/
sablono.core.unordered_list13028 = (function unordered_list13028(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",1013907977),(function (){var iter__4160__auto__ = (function iter__13033(s__13034){return (new cljs.core.LazySeq(null,(function (){var s__13034__$1 = s__13034;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__13034__$1);if(temp__4092__auto__)
{var s__13034__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__13034__$2))
{var c__4158__auto__ = cljs.core.chunk_first.call(null,s__13034__$2);var size__4159__auto__ = cljs.core.count.call(null,c__4158__auto__);var b__13036 = cljs.core.chunk_buffer.call(null,size__4159__auto__);if((function (){var i__13035 = 0;while(true){
if((i__13035 < size__4159__auto__))
{var x = cljs.core._nth.call(null,c__4158__auto__,i__13035);cljs.core.chunk_append.call(null,b__13036,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null));
{
var G__13037 = (i__13035 + 1);
i__13035 = G__13037;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13036),iter__13033.call(null,cljs.core.chunk_rest.call(null,s__13034__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13036),null);
}
} else
{var x = cljs.core.first.call(null,s__13034__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null),iter__13033.call(null,cljs.core.rest.call(null,s__13034__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4160__auto__.call(null,coll);
})()], null);
});
sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list13028);
/**
* Wrap a collection in an ordered list.
*/
sablono.core.ordered_list13038 = (function ordered_list13038(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",1013907791),(function (){var iter__4160__auto__ = (function iter__13043(s__13044){return (new cljs.core.LazySeq(null,(function (){var s__13044__$1 = s__13044;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__13044__$1);if(temp__4092__auto__)
{var s__13044__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__13044__$2))
{var c__4158__auto__ = cljs.core.chunk_first.call(null,s__13044__$2);var size__4159__auto__ = cljs.core.count.call(null,c__4158__auto__);var b__13046 = cljs.core.chunk_buffer.call(null,size__4159__auto__);if((function (){var i__13045 = 0;while(true){
if((i__13045 < size__4159__auto__))
{var x = cljs.core._nth.call(null,c__4158__auto__,i__13045);cljs.core.chunk_append.call(null,b__13046,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null));
{
var G__13047 = (i__13045 + 1);
i__13045 = G__13047;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13046),iter__13043.call(null,cljs.core.chunk_rest.call(null,s__13044__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13046),null);
}
} else
{var x = cljs.core.first.call(null,s__13044__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null),iter__13043.call(null,cljs.core.rest.call(null,s__13044__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4160__auto__.call(null,coll);
})()], null);
});
sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list13038);
/**
* Create an image element.
*/
sablono.core.image13048 = (function() {
var image13048 = null;
var image13048__1 = (function (src){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1014008629),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",1014018390),sablono.util.as_str.call(null,src)], null)], null);
});
var image13048__2 = (function (src,alt){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1014008629),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",1014018390),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",1014000923),alt], null)], null);
});
image13048 = function(src,alt){
switch(arguments.length){
case 1:
return image13048__1.call(this,src);
case 2:
return image13048__2.call(this,src,alt);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
image13048.cljs$core$IFn$_invoke$arity$1 = image13048__1;
image13048.cljs$core$IFn$_invoke$arity$2 = image13048__2;
return image13048;
})()
;
sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image13048);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
* Create a field name from the supplied argument the current field group.
*/
sablono.core.make_name = (function make_name(name){return cljs.core.reduce.call(null,(function (p1__13049_SHARP_,p2__13050_SHARP_){return [cljs.core.str(p1__13049_SHARP_),cljs.core.str("["),cljs.core.str(p2__13050_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Create a field id from the supplied argument and current field group.
*/
sablono.core.make_id = (function make_id(name){return cljs.core.reduce.call(null,(function (p1__13051_SHARP_,p2__13052_SHARP_){return [cljs.core.str(p1__13051_SHARP_),cljs.core.str("-"),cljs.core.str(p2__13052_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Creates a new <input> element.
*/
sablono.core.input_field = (function input_field(type,name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1017479852),type,new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value], null)], null);
});
/**
* Creates a hidden input field.
*/
sablono.core.hidden_field13053 = (function() {
var hidden_field13053 = null;
var hidden_field13053__1 = (function (name){return hidden_field13053.call(null,name,null);
});
var hidden_field13053__2 = (function (name,value){return sablono.core.input_field.call(null,"hidden",name,value);
});
hidden_field13053 = function(name,value){
switch(arguments.length){
case 1:
return hidden_field13053__1.call(this,name);
case 2:
return hidden_field13053__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hidden_field13053.cljs$core$IFn$_invoke$arity$1 = hidden_field13053__1;
hidden_field13053.cljs$core$IFn$_invoke$arity$2 = hidden_field13053__2;
return hidden_field13053;
})()
;
sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field13053);
/**
* Creates a new text input field.
*/
sablono.core.text_field13054 = (function() {
var text_field13054 = null;
var text_field13054__1 = (function (name){return text_field13054.call(null,name,null);
});
var text_field13054__2 = (function (name,value){return sablono.core.input_field.call(null,"text",name,value);
});
text_field13054 = function(name,value){
switch(arguments.length){
case 1:
return text_field13054__1.call(this,name);
case 2:
return text_field13054__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_field13054.cljs$core$IFn$_invoke$arity$1 = text_field13054__1;
text_field13054.cljs$core$IFn$_invoke$arity$2 = text_field13054__2;
return text_field13054;
})()
;
sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field13054);
/**
* Creates a new password field.
*/
sablono.core.password_field13055 = (function() {
var password_field13055 = null;
var password_field13055__1 = (function (name){return password_field13055.call(null,name,null);
});
var password_field13055__2 = (function (name,value){return sablono.core.input_field.call(null,"password",name,value);
});
password_field13055 = function(name,value){
switch(arguments.length){
case 1:
return password_field13055__1.call(this,name);
case 2:
return password_field13055__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
password_field13055.cljs$core$IFn$_invoke$arity$1 = password_field13055__1;
password_field13055.cljs$core$IFn$_invoke$arity$2 = password_field13055__2;
return password_field13055;
})()
;
sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field13055);
/**
* Creates a new email input field.
*/
sablono.core.email_field13056 = (function() {
var email_field13056 = null;
var email_field13056__1 = (function (name){return email_field13056.call(null,name,null);
});
var email_field13056__2 = (function (name,value){return sablono.core.input_field.call(null,"email",name,value);
});
email_field13056 = function(name,value){
switch(arguments.length){
case 1:
return email_field13056__1.call(this,name);
case 2:
return email_field13056__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
email_field13056.cljs$core$IFn$_invoke$arity$1 = email_field13056__1;
email_field13056.cljs$core$IFn$_invoke$arity$2 = email_field13056__2;
return email_field13056;
})()
;
sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field13056);
/**
* Creates a check box.
*/
sablono.core.check_box13057 = (function() {
var check_box13057 = null;
var check_box13057__1 = (function (name){return check_box13057.call(null,name,null);
});
var check_box13057__2 = (function (name,checked_QMARK_){return check_box13057.call(null,name,checked_QMARK_,"true");
});
var check_box13057__3 = (function (name,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1017479852),"checkbox",new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value,new cljs.core.Keyword(null,"checked","checked",1756218137),checked_QMARK_], null)], null);
});
check_box13057 = function(name,checked_QMARK_,value){
switch(arguments.length){
case 1:
return check_box13057__1.call(this,name);
case 2:
return check_box13057__2.call(this,name,checked_QMARK_);
case 3:
return check_box13057__3.call(this,name,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
check_box13057.cljs$core$IFn$_invoke$arity$1 = check_box13057__1;
check_box13057.cljs$core$IFn$_invoke$arity$2 = check_box13057__2;
check_box13057.cljs$core$IFn$_invoke$arity$3 = check_box13057__3;
return check_box13057;
})()
;
sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box13057);
/**
* Creates a radio button.
*/
sablono.core.radio_button13058 = (function() {
var radio_button13058 = null;
var radio_button13058__1 = (function (group){return radio_button13058.call(null,group,null);
});
var radio_button13058__2 = (function (group,checked_QMARK_){return radio_button13058.call(null,group,checked_QMARK_,"true");
});
var radio_button13058__3 = (function (group,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1017479852),"radio",new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",1125876963),value,new cljs.core.Keyword(null,"checked","checked",1756218137),checked_QMARK_], null)], null);
});
radio_button13058 = function(group,checked_QMARK_,value){
switch(arguments.length){
case 1:
return radio_button13058__1.call(this,group);
case 2:
return radio_button13058__2.call(this,group,checked_QMARK_);
case 3:
return radio_button13058__3.call(this,group,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
radio_button13058.cljs$core$IFn$_invoke$arity$1 = radio_button13058__1;
radio_button13058.cljs$core$IFn$_invoke$arity$2 = radio_button13058__2;
radio_button13058.cljs$core$IFn$_invoke$arity$3 = radio_button13058__3;
return radio_button13058;
})()
;
sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button13058);
/**
* Creates a seq of option tags from a collection.
*/
sablono.core.select_options13059 = (function() {
var select_options13059 = null;
var select_options13059__1 = (function (coll){return select_options13059.call(null,coll,null);
});
var select_options13059__2 = (function (coll,selected){var iter__4160__auto__ = (function iter__13068(s__13069){return (new cljs.core.LazySeq(null,(function (){var s__13069__$1 = s__13069;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__13069__$1);if(temp__4092__auto__)
{var s__13069__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__13069__$2))
{var c__4158__auto__ = cljs.core.chunk_first.call(null,s__13069__$2);var size__4159__auto__ = cljs.core.count.call(null,c__4158__auto__);var b__13071 = cljs.core.chunk_buffer.call(null,size__4159__auto__);if((function (){var i__13070 = 0;while(true){
if((i__13070 < size__4159__auto__))
{var x = cljs.core._nth.call(null,c__4158__auto__,i__13070);cljs.core.chunk_append.call(null,b__13071,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__13074 = x;var text = cljs.core.nth.call(null,vec__13074,0,null);var val = cljs.core.nth.call(null,vec__13074,1,null);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",933131038),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),text], null),select_options13059.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",1125876963),val,new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,val,selected)], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,x,selected)], null),x], null)));
{
var G__13076 = (i__13070 + 1);
i__13070 = G__13076;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13071),iter__13068.call(null,cljs.core.chunk_rest.call(null,s__13069__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13071),null);
}
} else
{var x = cljs.core.first.call(null,s__13069__$2);return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__13075 = x;var text = cljs.core.nth.call(null,vec__13075,0,null);var val = cljs.core.nth.call(null,vec__13075,1,null);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",933131038),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),text], null),select_options13059.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",1125876963),val,new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,val,selected)], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,x,selected)], null),x], null)),iter__13068.call(null,cljs.core.rest.call(null,s__13069__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4160__auto__.call(null,coll);
});
select_options13059 = function(coll,selected){
switch(arguments.length){
case 1:
return select_options13059__1.call(this,coll);
case 2:
return select_options13059__2.call(this,coll,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
select_options13059.cljs$core$IFn$_invoke$arity$1 = select_options13059__1;
select_options13059.cljs$core$IFn$_invoke$arity$2 = select_options13059__2;
return select_options13059;
})()
;
sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options13059);
/**
* Creates a drop-down box using the <select> tag.
*/
sablono.core.drop_down13077 = (function() {
var drop_down13077 = null;
var drop_down13077__2 = (function (name,options){return drop_down13077.call(null,name,options,null);
});
var drop_down13077__3 = (function (name,options,selected){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",4402849902),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});
drop_down13077 = function(name,options,selected){
switch(arguments.length){
case 2:
return drop_down13077__2.call(this,name,options);
case 3:
return drop_down13077__3.call(this,name,options,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_down13077.cljs$core$IFn$_invoke$arity$2 = drop_down13077__2;
drop_down13077.cljs$core$IFn$_invoke$arity$3 = drop_down13077__3;
return drop_down13077;
})()
;
sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down13077);
/**
* Creates a text area element.
*/
sablono.core.text_area13078 = (function() {
var text_area13078 = null;
var text_area13078__1 = (function (name){return text_area13078.call(null,name,null);
});
var text_area13078__2 = (function (name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",4305627820),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value], null)], null);
});
text_area13078 = function(name,value){
switch(arguments.length){
case 1:
return text_area13078__1.call(this,name);
case 2:
return text_area13078__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_area13078.cljs$core$IFn$_invoke$arity$1 = text_area13078__1;
text_area13078.cljs$core$IFn$_invoke$arity$2 = text_area13078__2;
return text_area13078;
})()
;
sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area13078);
/**
* Creates a file upload input.
*/
sablono.core.file_upload13079 = (function file_upload13079(name){return sablono.core.input_field.call(null,"file",name,null);
});
sablono.core.file_upload = sablono.core.wrap_attrs.call(null,sablono.core.file_upload13079);
/**
* Creates a label for an input field with the supplied name.
*/
sablono.core.label13080 = (function label13080(name,text){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1116631654),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",2249940112),sablono.core.make_id.call(null,name)], null),text], null);
});
sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label13080);
/**
* Creates a submit button.
*/
sablono.core.submit_button13081 = (function submit_button13081(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"submit",new cljs.core.Keyword(null,"value","value",1125876963),text], null)], null);
});
sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button13081);
/**
* Creates a form reset button.
*/
sablono.core.reset_button13082 = (function reset_button13082(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"reset",new cljs.core.Keyword(null,"value","value",1125876963),text], null)], null);
});
sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button13082);
/**
* Create a form that points to a particular method and route.
* e.g. (form-to [:put "/post"]
* ...)
* @param {...*} var_args
*/
sablono.core.form_to13083 = (function() { 
var form_to13083__delegate = function (p__13084,body){var vec__13086 = p__13084;var method = cljs.core.nth.call(null,vec__13086,0,null);var action = cljs.core.nth.call(null,vec__13086,1,null);var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));var action_uri = sablono.util.to_uri.call(null,action);return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1014006472),null,new cljs.core.Keyword(null,"post","post",1017351186),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",1017053238),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",4231316563),method_str,new cljs.core.Keyword(null,"action","action",3885920680),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",1017053238),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",4231316563),"POST",new cljs.core.Keyword(null,"action","action",3885920680),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
};
var form_to13083 = function (p__13084,var_args){
var body = null;if (arguments.length > 1) {
  body = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return form_to13083__delegate.call(this,p__13084,body);};
form_to13083.cljs$lang$maxFixedArity = 1;
form_to13083.cljs$lang$applyTo = (function (arglist__13087){
var p__13084 = cljs.core.first(arglist__13087);
var body = cljs.core.rest(arglist__13087);
return form_to13083__delegate(p__13084,body);
});
form_to13083.cljs$core$IFn$_invoke$arity$variadic = form_to13083__delegate;
return form_to13083;
})()
;
sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to13083);

//# sourceMappingURL=core.js.map