// Compiled by ClojureScript 0.0-2173
goog.provide('om_sync.core');
goog.require('cljs.core');
goog.require('om_sync.util');
goog.require('cljs.core.async');
goog.require('om_sync.util');
goog.require('om.dom');
goog.require('om.dom');
goog.require('om.core');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
om_sync.core.type__GT_method = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"create","create",3956577390),new cljs.core.Keyword(null,"post","post",1017351186),new cljs.core.Keyword(null,"update","update",4470025275),new cljs.core.Keyword(null,"put","put",1014015617),new cljs.core.Keyword(null,"delete","delete",3973413149),new cljs.core.Keyword(null,"delete","delete",3973413149)], null);
om_sync.core.sync_server = (function sync_server(url,tag,edn){var res_chan = cljs.core.async.chan.call(null);om_sync.util.edn_xhr.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",4231316563),om_sync.core.type__GT_method.call(null,tag),new cljs.core.Keyword(null,"url","url",1014020321),url,new cljs.core.Keyword(null,"data","data",1016980252),edn,new cljs.core.Keyword(null,"on-error","on-error",1418576908),(function (err){return cljs.core.async.put_BANG_.call(null,res_chan,err);
}),new cljs.core.Keyword(null,"on-complete","on-complete",2943599833),(function (res){return cljs.core.async.put_BANG_.call(null,res_chan,res);
})], null));
return res_chan;
});
om_sync.core.tag_and_edn = (function tag_and_edn(coll_path,path,tag_fn,id_key,tx_data){var tag = ((!((tag_fn == null)))?tag_fn.call(null,tx_data):om_sync.util.tx_tag.call(null,tx_data));var edn = (function (){var pred__12575 = cljs.core._EQ_;var expr__12576 = tag;if(cljs.core.truth_(pred__12575.call(null,new cljs.core.Keyword(null,"create","create",3956577390),expr__12576)))
{return new cljs.core.Keyword(null,"new-value","new-value",3626601078).cljs$core$IFn$_invoke$arity$1(tx_data);
} else
{if(cljs.core.truth_(pred__12575.call(null,new cljs.core.Keyword(null,"update","update",4470025275),expr__12576)))
{var ppath = om_sync.util.popn.call(null,(cljs.core.count.call(null,path) - (cljs.core.count.call(null,coll_path) + 1)),path);var m = cljs.core.select_keys.call(null,cljs.core.get_in.call(null,new cljs.core.Keyword(null,"new-state","new-state",3624385942).cljs$core$IFn$_invoke$arity$1(tx_data),ppath),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [id_key], null));var rel = om_sync.util.sub.call(null,path,coll_path);return cljs.core.assoc_in.call(null,m,cljs.core.rest.call(null,rel),new cljs.core.Keyword(null,"new-value","new-value",3626601078).cljs$core$IFn$_invoke$arity$1(tx_data));
} else
{if(cljs.core.truth_(pred__12575.call(null,new cljs.core.Keyword(null,"delete","delete",3973413149),expr__12576)))
{return id_key.call(null,new cljs.core.Keyword(null,"old-value","old-value",1451216317).cljs$core$IFn$_invoke$arity$1(tx_data));
} else
{return null;
}
}
}
})();return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,edn], null);
});
/**
* ALPHA: Creates a reusable sync componet. Data must be a map containing
* :url and :coll keys. :url must identify a server endpoint that can
* takes EDN data via POST for create, PUT for update, and DELETE for
* delete. :coll must be a cursor into the application state. Note the
* first argument could of course just be a cursor itself.
* 
* In order to function you must provide a subscribeable core.async
* channel that will stream all :tx-listen events. This channel must be
* called :tx-chan and provided via the :share option to om.core/root. It
* must be a channel constructed with cljs.core.async/pub with the topic
* :txs.
* 
* Once built om-sync will act on any transactions to the :coll value
* regardless of depth. In order to identiy which transactions to act
* on these transactions must be labeled as :create, :update, or
* :delete.
* 
* om-sync takes a variety of options via the :opts passed to
* om.core/build:
* 
* :view - a required Om component function to render the collection.
* 
* :id-key - which property represents the server id for a item in the
* collection.
* 
* :filter - a function which filters which tagged transaction to actually sync.
* 
* :tag-fn - not all components you might want to interact with may
* have properly tagged their transactions. This function will
* receive the transaction data and return the determined tag.
* 
* :on-success - a callback function that will receive the server
* response and the transaction data on success.
* 
* :on-error - a callback function that will receive the server error
* and the transaction data on failure. The transaction data can
* easily be leveraged to rollback the application state.
* 
* :sync-chan - if given this option, om-sync will not invoke
* sync-server instead it will put a map containing the :listen-path,
* :url, :tag, :edn, :on-success, :on-error, and :tx-data on the
* provided channel. This higher level operations such as server
* request batching and multiple om-sync component coordination.
*/
om_sync.core.om_sync = (function() {
var om_sync__$1 = null;
var om_sync__$1__2 = (function (data,owner){return om_sync__$1.call(null,data,owner,null);
});
var om_sync__$1__3 = (function (p__12578,owner,opts){var map__12703 = p__12578;var map__12703__$1 = ((cljs.core.seq_QMARK_.call(null,map__12703))?cljs.core.apply.call(null,cljs.core.hash_map,map__12703):map__12703);var data = map__12703__$1;var coll = cljs.core.get.call(null,map__12703__$1,new cljs.core.Keyword(null,"coll","coll",1016963678));var url = cljs.core.get.call(null,map__12703__$1,new cljs.core.Keyword(null,"url","url",1014020321));if(!((url == null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("om-sync component not given url"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",-1640422260,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",-1637150201,null),new cljs.core.Symbol(null,"url","url",-1640415448,null)))))].join('')));
}
if(typeof om_sync.core.t12704 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_sync.core.t12704 = (function (url,coll,data,map__12703,opts,owner,p__12578,om_sync,meta12705){
this.url = url;
this.coll = coll;
this.data = data;
this.map__12703 = map__12703;
this.opts = opts;
this.owner = owner;
this.p__12578 = p__12578;
this.om_sync = om_sync;
this.meta12705 = meta12705;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_sync.core.t12704.cljs$lang$type = true;
om_sync.core.t12704.cljs$lang$ctorStr = "om-sync.core/t12704";
om_sync.core.t12704.cljs$lang$ctorPrWriter = (function (this__4010__auto__,writer__4011__auto__,opt__4012__auto__){return cljs.core._write.call(null,writer__4011__auto__,"om-sync.core/t12704");
});
om_sync.core.t12704.prototype.om$core$IRender$ = true;
om_sync.core.t12704.prototype.om$core$IRender$render$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return om.core.build.call(null,new cljs.core.Keyword(null,"view","view",1017523735).cljs$core$IFn$_invoke$arity$1(self__.opts),self__.coll);
});
om_sync.core.t12704.prototype.om$core$IWillUnmount$ = true;
om_sync.core.t12704.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){var self__ = this;
var ___$1 = this;var map__12707 = om.core.get_state.call(null,self__.owner);var map__12707__$1 = ((cljs.core.seq_QMARK_.call(null,map__12707))?cljs.core.apply.call(null,cljs.core.hash_map,map__12707):map__12707);var txs = cljs.core.get.call(null,map__12707__$1,new cljs.core.Keyword(null,"txs","txs",1014019553));var kill_chan = cljs.core.get.call(null,map__12707__$1,new cljs.core.Keyword(null,"kill-chan","kill-chan",3698972627));if(cljs.core.truth_(kill_chan))
{cljs.core.async.put_BANG_.call(null,kill_chan,(new Date()));
} else
{}
if(cljs.core.truth_(txs))
{return cljs.core.async.unsub.call(null,om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"tx-chan","tx-chan",4365225069)),new cljs.core.Keyword(null,"txs","txs",1014019553),txs);
} else
{return null;
}
});
om_sync.core.t12704.prototype.om$core$IWillMount$ = true;
om_sync.core.t12704.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){var self__ = this;
var ___$1 = this;var map__12708 = self__.opts;var map__12708__$1 = ((cljs.core.seq_QMARK_.call(null,map__12708))?cljs.core.apply.call(null,cljs.core.hash_map,map__12708):map__12708);var sync_chan = cljs.core.get.call(null,map__12708__$1,new cljs.core.Keyword(null,"sync-chan","sync-chan",1461778102));var tag_fn = cljs.core.get.call(null,map__12708__$1,new cljs.core.Keyword(null,"tag-fn","tag-fn",4427582285));var filter = cljs.core.get.call(null,map__12708__$1,new cljs.core.Keyword(null,"filter","filter",4034379498));var id_key = cljs.core.get.call(null,map__12708__$1,new cljs.core.Keyword(null,"id-key","id-key",4113763871));var map__12709 = self__.opts;var map__12709__$1 = ((cljs.core.seq_QMARK_.call(null,map__12709))?cljs.core.apply.call(null,cljs.core.hash_map,map__12709):map__12709);var on_error = cljs.core.get.call(null,map__12709__$1,new cljs.core.Keyword(null,"on-error","on-error",1418576908));var on_success = cljs.core.get.call(null,map__12709__$1,new cljs.core.Keyword(null,"on-success","on-success",2969097607));var kill_chan = om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"kill-chan","kill-chan",3698972627));var tx_chan = om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"tx-chan","tx-chan",4365225069));var txs = cljs.core.async.chan.call(null);var coll_path = om.core.path.call(null,self__.coll);if(!((tx_chan == null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("om-sync requires shared :tx-chan pub channel with :txs topic"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",-1640422260,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",-1637150201,null),new cljs.core.Symbol(null,"tx-chan","tx-chan",1710789300,null)))))].join('')));
}
cljs.core.async.sub.call(null,tx_chan,new cljs.core.Keyword(null,"txs","txs",1014019553),txs);
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"txs","txs",1014019553),txs);
var c__7142__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,(function (){var f__7143__auto__ = (function (){var switch__7127__auto__ = (function (state_12781){var state_val_12782 = (state_12781[1]);if((state_val_12782 === 1))
{var state_12781__$1 = state_12781;var statearr_12783_12827 = state_12781__$1;(statearr_12783_12827[2] = null);
(statearr_12783_12827[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 2))
{var inst_12712 = [txs,kill_chan];var inst_12713 = (new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,inst_12712,null));var state_12781__$1 = state_12781;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_12781__$1,4,inst_12713);
} else
{if((state_val_12782 === 3))
{var inst_12779 = (state_12781[2]);var state_12781__$1 = state_12781;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12781__$1,inst_12779);
} else
{if((state_val_12782 === 4))
{var inst_12715 = (state_12781[2]);var inst_12716 = cljs.core.nth.call(null,inst_12715,0,null);var inst_12717 = cljs.core.nth.call(null,inst_12715,1,null);var inst_12718 = cljs.core._EQ_.call(null,inst_12717,kill_chan);var state_12781__$1 = (function (){var statearr_12784 = state_12781;(statearr_12784[7] = inst_12716);
return statearr_12784;
})();if(inst_12718)
{var statearr_12785_12828 = state_12781__$1;(statearr_12785_12828[1] = 5);
} else
{var statearr_12786_12829 = state_12781__$1;(statearr_12786_12829[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 5))
{var state_12781__$1 = state_12781;var statearr_12787_12830 = state_12781__$1;(statearr_12787_12830[2] = new cljs.core.Keyword(null,"done","done",1016993524));
(statearr_12787_12830[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 6))
{var inst_12716 = (state_12781[7]);var inst_12723 = (state_12781[8]);var inst_12723__$1 = cljs.core.nth.call(null,inst_12716,0,null);var inst_12724 = cljs.core.seq_QMARK_.call(null,inst_12723__$1);var state_12781__$1 = (function (){var statearr_12788 = state_12781;(statearr_12788[8] = inst_12723__$1);
return statearr_12788;
})();if(inst_12724)
{var statearr_12789_12831 = state_12781__$1;(statearr_12789_12831[1] = 8);
} else
{var statearr_12790_12832 = state_12781__$1;(statearr_12790_12832[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 7))
{var inst_12777 = (state_12781[2]);var state_12781__$1 = state_12781;var statearr_12791_12833 = state_12781__$1;(statearr_12791_12833[2] = inst_12777);
(statearr_12791_12833[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 8))
{var inst_12723 = (state_12781[8]);var inst_12726 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12723);var state_12781__$1 = state_12781;var statearr_12792_12834 = state_12781__$1;(statearr_12792_12834[2] = inst_12726);
(statearr_12792_12834[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 9))
{var inst_12723 = (state_12781[8]);var state_12781__$1 = state_12781;var statearr_12793_12835 = state_12781__$1;(statearr_12793_12835[2] = inst_12723);
(statearr_12793_12835[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 10))
{var inst_12716 = (state_12781[7]);var inst_12732 = (state_12781[9]);var inst_12729 = (state_12781[10]);var inst_12734 = (state_12781[11]);var inst_12729__$1 = (state_12781[2]);var inst_12730 = cljs.core.get.call(null,inst_12729__$1,new cljs.core.Keyword(null,"new-state","new-state",3624385942));var inst_12731 = cljs.core.get.call(null,inst_12729__$1,new cljs.core.Keyword(null,"new-value","new-value",3626601078));var inst_12732__$1 = cljs.core.get.call(null,inst_12729__$1,new cljs.core.Keyword(null,"path","path",1017337751));var inst_12733 = cljs.core.nth.call(null,inst_12716,1,null);var inst_12734__$1 = om_sync.util.subpath_QMARK_.call(null,coll_path,inst_12732__$1);var state_12781__$1 = (function (){var statearr_12794 = state_12781;(statearr_12794[9] = inst_12732__$1);
(statearr_12794[12] = inst_12733);
(statearr_12794[10] = inst_12729__$1);
(statearr_12794[11] = inst_12734__$1);
(statearr_12794[13] = inst_12731);
(statearr_12794[14] = inst_12730);
return statearr_12794;
})();if(inst_12734__$1)
{var statearr_12795_12836 = state_12781__$1;(statearr_12795_12836[1] = 11);
} else
{var statearr_12796_12837 = state_12781__$1;(statearr_12796_12837[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 11))
{var inst_12736 = (state_12781[15]);var inst_12736__$1 = (filter == null);var state_12781__$1 = (function (){var statearr_12797 = state_12781;(statearr_12797[15] = inst_12736__$1);
return statearr_12797;
})();if(cljs.core.truth_(inst_12736__$1))
{var statearr_12798_12838 = state_12781__$1;(statearr_12798_12838[1] = 14);
} else
{var statearr_12799_12839 = state_12781__$1;(statearr_12799_12839[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 12))
{var inst_12734 = (state_12781[11]);var state_12781__$1 = state_12781;var statearr_12800_12840 = state_12781__$1;(statearr_12800_12840[2] = inst_12734);
(statearr_12800_12840[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 13))
{var inst_12744 = (state_12781[2]);var state_12781__$1 = state_12781;if(cljs.core.truth_(inst_12744))
{var statearr_12801_12841 = state_12781__$1;(statearr_12801_12841[1] = 17);
} else
{var statearr_12802_12842 = state_12781__$1;(statearr_12802_12842[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 14))
{var inst_12736 = (state_12781[15]);var state_12781__$1 = state_12781;var statearr_12803_12843 = state_12781__$1;(statearr_12803_12843[2] = inst_12736);
(statearr_12803_12843[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 15))
{var inst_12729 = (state_12781[10]);var inst_12739 = filter.call(null,inst_12729);var state_12781__$1 = state_12781;var statearr_12804_12844 = state_12781__$1;(statearr_12804_12844[2] = inst_12739);
(statearr_12804_12844[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 16))
{var inst_12741 = (state_12781[2]);var state_12781__$1 = state_12781;var statearr_12805_12845 = state_12781__$1;(statearr_12805_12845[2] = inst_12741);
(statearr_12805_12845[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 17))
{var inst_12732 = (state_12781[9]);var inst_12729 = (state_12781[10]);var inst_12748 = (state_12781[16]);var inst_12747 = om_sync.core.tag_and_edn.call(null,coll_path,inst_12732,tag_fn,id_key,inst_12729);var inst_12748__$1 = cljs.core.nth.call(null,inst_12747,0,null);var inst_12749 = cljs.core.nth.call(null,inst_12747,1,null);var inst_12750 = cljs.core.assoc.call(null,inst_12729,new cljs.core.Keyword("om-sync.core","tag","om-sync.core/tag",858767137),inst_12748__$1);var inst_12751 = (sync_chan == null);var inst_12752 = cljs.core.not.call(null,inst_12751);var state_12781__$1 = (function (){var statearr_12806 = state_12781;(statearr_12806[17] = inst_12750);
(statearr_12806[16] = inst_12748__$1);
(statearr_12806[18] = inst_12749);
return statearr_12806;
})();if(inst_12752)
{var statearr_12807_12846 = state_12781__$1;(statearr_12807_12846[1] = 20);
} else
{var statearr_12808_12847 = state_12781__$1;(statearr_12808_12847[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 18))
{var state_12781__$1 = state_12781;var statearr_12809_12848 = state_12781__$1;(statearr_12809_12848[2] = null);
(statearr_12809_12848[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 19))
{var inst_12774 = (state_12781[2]);var state_12781__$1 = (function (){var statearr_12810 = state_12781;(statearr_12810[19] = inst_12774);
return statearr_12810;
})();var statearr_12811_12849 = state_12781__$1;(statearr_12811_12849[2] = null);
(statearr_12811_12849[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 20))
{var inst_12750 = (state_12781[17]);var inst_12748 = (state_12781[16]);var inst_12749 = (state_12781[18]);var inst_12754 = [new cljs.core.Keyword(null,"url","url",1014020321),new cljs.core.Keyword(null,"tag","tag",1014018828),new cljs.core.Keyword(null,"edn","edn",1014004513),new cljs.core.Keyword(null,"listen-path","listen-path",2299064285),new cljs.core.Keyword(null,"on-success","on-success",2969097607),new cljs.core.Keyword(null,"on-error","on-error",1418576908),new cljs.core.Keyword(null,"tx-data","tx-data",4365248709)];var inst_12755 = [self__.url,inst_12748,inst_12749,coll_path,on_success,on_error,inst_12750];var inst_12756 = cljs.core.PersistentHashMap.fromArrays.call(null,inst_12754,inst_12755);var state_12781__$1 = state_12781;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12781__$1,23,sync_chan,inst_12756);
} else
{if((state_val_12782 === 21))
{var inst_12748 = (state_12781[16]);var inst_12749 = (state_12781[18]);var inst_12760 = om_sync.core.sync_server.call(null,self__.url,inst_12748,inst_12749);var state_12781__$1 = state_12781;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12781__$1,24,inst_12760);
} else
{if((state_val_12782 === 22))
{var inst_12771 = (state_12781[2]);var state_12781__$1 = state_12781;var statearr_12812_12850 = state_12781__$1;(statearr_12812_12850[2] = inst_12771);
(statearr_12812_12850[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 23))
{var inst_12758 = (state_12781[2]);var state_12781__$1 = state_12781;var statearr_12813_12851 = state_12781__$1;(statearr_12813_12851[2] = inst_12758);
(statearr_12813_12851[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 24))
{var inst_12762 = (state_12781[20]);var inst_12762__$1 = (state_12781[2]);var inst_12763 = om_sync.util.error_QMARK_.call(null,inst_12762__$1);var state_12781__$1 = (function (){var statearr_12814 = state_12781;(statearr_12814[20] = inst_12762__$1);
return statearr_12814;
})();if(inst_12763)
{var statearr_12815_12852 = state_12781__$1;(statearr_12815_12852[1] = 25);
} else
{var statearr_12816_12853 = state_12781__$1;(statearr_12816_12853[1] = 26);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 25))
{var inst_12750 = (state_12781[17]);var inst_12762 = (state_12781[20]);var inst_12765 = on_error.call(null,inst_12762,inst_12750);var state_12781__$1 = state_12781;var statearr_12817_12854 = state_12781__$1;(statearr_12817_12854[2] = inst_12765);
(statearr_12817_12854[1] = 27);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 26))
{var inst_12750 = (state_12781[17]);var inst_12762 = (state_12781[20]);var inst_12767 = on_success.call(null,inst_12762,inst_12750);var state_12781__$1 = state_12781;var statearr_12818_12855 = state_12781__$1;(statearr_12818_12855[2] = inst_12767);
(statearr_12818_12855[1] = 27);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_12782 === 27))
{var inst_12769 = (state_12781[2]);var state_12781__$1 = state_12781;var statearr_12819_12856 = state_12781__$1;(statearr_12819_12856[2] = inst_12769);
(statearr_12819_12856[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});return ((function (switch__7127__auto__){
return (function() {
var state_machine__7128__auto__ = null;
var state_machine__7128__auto____0 = (function (){var statearr_12823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_12823[0] = state_machine__7128__auto__);
(statearr_12823[1] = 1);
return statearr_12823;
});
var state_machine__7128__auto____1 = (function (state_12781){while(true){
var ret_value__7129__auto__ = (function (){try{while(true){
var result__7130__auto__ = switch__7127__auto__.call(null,state_12781);if(cljs.core.keyword_identical_QMARK_.call(null,result__7130__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__7130__auto__;
}
break;
}
}catch (e12824){if((e12824 instanceof Object))
{var ex__7131__auto__ = e12824;var statearr_12825_12857 = state_12781;(statearr_12825_12857[5] = ex__7131__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12781);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e12824;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7129__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__12858 = state_12781;
state_12781 = G__12858;
continue;
}
} else
{return ret_value__7129__auto__;
}
break;
}
});
state_machine__7128__auto__ = function(state_12781){
switch(arguments.length){
case 0:
return state_machine__7128__auto____0.call(this);
case 1:
return state_machine__7128__auto____1.call(this,state_12781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7128__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7128__auto____0;
state_machine__7128__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7128__auto____1;
return state_machine__7128__auto__;
})()
;})(switch__7127__auto__))
})();var state__7144__auto__ = (function (){var statearr_12826 = f__7143__auto__.call(null);(statearr_12826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7142__auto__);
return statearr_12826;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7144__auto__);
}));
return c__7142__auto__;
});
om_sync.core.t12704.prototype.om$core$IInitState$ = true;
om_sync.core.t12704.prototype.om$core$IInitState$init_state$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"kill-chan","kill-chan",3698972627),cljs.core.async.chan.call(null)], null);
});
om_sync.core.t12704.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12706){var self__ = this;
var _12706__$1 = this;return self__.meta12705;
});
om_sync.core.t12704.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12706,meta12705__$1){var self__ = this;
var _12706__$1 = this;return (new om_sync.core.t12704(self__.url,self__.coll,self__.data,self__.map__12703,self__.opts,self__.owner,self__.p__12578,self__.om_sync,meta12705__$1));
});
om_sync.core.__GT_t12704 = (function __GT_t12704(url__$1,coll__$1,data__$1,map__12703__$2,opts__$1,owner__$1,p__12578__$1,om_sync__$2,meta12705){return (new om_sync.core.t12704(url__$1,coll__$1,data__$1,map__12703__$2,opts__$1,owner__$1,p__12578__$1,om_sync__$2,meta12705));
});
}
return (new om_sync.core.t12704(url,coll,data,map__12703__$1,opts,owner,p__12578,om_sync__$1,null));
});
om_sync__$1 = function(p__12578,owner,opts){
switch(arguments.length){
case 2:
return om_sync__$1__2.call(this,p__12578,owner);
case 3:
return om_sync__$1__3.call(this,p__12578,owner,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
om_sync__$1.cljs$core$IFn$_invoke$arity$2 = om_sync__$1__2;
om_sync__$1.cljs$core$IFn$_invoke$arity$3 = om_sync__$1__3;
return om_sync__$1;
})()
;

//# sourceMappingURL=core.js.map