(ns de.sushi3003.batteries)

(defn compact
  "Remove all nil values from a map.
   e.g.
   (compact {:a 1 :b nil :c 3}) => {:c 3, :a 1}"
  [map]
  (apply dissoc map (for [[k v] map :when (nil? v)] k)))

(defn map-keys
  "Apply a fn to all keys of a map.
   e.g.
   (map-keys name {:a 1 :b 2}) => {\"b\" 2, \"a\" 1}"
  [f map]
  (into {} (for [[k v] map] [(f k) v])))

(defn map-values
  "Apply a fn to all values of a map.
   e.g.
   (map-values inc {:a 1 :b 2}) => {:a 2 :b 3}"
  [f map]
  (into {} (for [[k v] map] [k (f v)])))

(defn select-values
  "Returns a vector containing only those values whose key is in keyseq.
   The values are in the same order as the keys in keyseq.
   e.g.
   (select-values {:a 1 :b 2} [:b :a :c :a]) => [2 1 nil 1]"
  [map keyseq]
  (reduce #(conj %1 (map %2)) [] keyseq))
