(ns de.sushi3003.batteries)

(defn compact
  "Remove all nil values from a map.
   e.g.
   (compact {:a 1 :b nil :c 3}) => {:c 3, :a 1}"
  [map]
  (apply dissoc map (for [[k v] map :when (nil? v)] k)))

(defn map-keys
  "Apply a fn to all keys of a map.
   e.g.
   (map-keys name {:a 1 :b 2}) => {\"b\" 2, \"a\" 1}"
  [f map]
  (into {} (for [[k v] map] [(f k) v])));TODO besser reduce-kv verwenden?

(defn map-values
  "Apply a fn to all values of a map.
   e.g.
   (map-values inc {:a 1 :b 2}) => {:a 2 :b 3}"
  [f map]
  (into {} (for [[k v] map] [k (f v)])))  ;TODO besser reduce-kv verwenden?

(defn map-kv
  "Applies the key-fn to all keys- and the val-fn to all values of the map."
  [key-fn val-fn map]
  (reduce-kv (fn [memo k v] (conj memo [(key-fn k) (val-fn v)])) 
             {} 
             map))

(defn select-values
  "Returns a vector containing only those values whose key is in keyseq.  The
   values are in the same order as the keys in keyseq. The optional function f
   is applied to each selected value.
   e.g.
   (select-values {:a 1 :b 2} [:b :a :c :a]) => [2 1 nil 1]"
  ([map keyseq]
   (select-values map keyseq identity))
  ([map keyseq f]
   (persistent! (reduce #(conj! %1 (f (map %2))) (transient []) keyseq))))

(defn group-by-id 
  "Returns a map of the elements of coll keyed by the result of f on each
   element.  The value at each key will be a single element (in contrast to
   clojure.core/group-by).  Therefore f should generally return an unique key
   for every element - otherwise elements get discarded."
  [f coll]
; (map-values first (group-by f coll)))  ; TODO optimize
; (reduce #(assoc %1 (f %2) %2) {} coll))
  (persistent! (reduce #(assoc! %1 (f %2) %2) (transient {}) coll)))

(defn str-trim 
  "Removes whitespace from both ends of string (like clojure.string/trim), but
   if nil is passed in, nil is returned (unlike clojure.string/trim, wich
   throws a NullPointerException)."
  [s]
  (when s (.trim s)))

(defn date-format
  "Formats the Date into a date/time string, according to the format-string."
  [fmt d]
  (.format (java.text.SimpleDateFormat. fmt) d))

(defn through 
  "Apply all functions in a seq to the same argument.
   e.g.
   (through [dec identity inc] 1) => [0 1 2]"
  [fns x]
  ((apply juxt fns) x))

(defn apply-to-each 
  "Applies f to each item in the collection. Therefore each item should be a
   vector, whose length matches the number of fs' input params.
   e.g.
  (apply-to-each + [[1 2] [3]]) => [3 3]"
  [f coll]
  (map #(apply f %) coll))

(def sum 
  "Returns the sum of all nums in a seq.
   e.g.
   (sum [1 2 3]) => 6" 
  (partial reduce +))

(defn str->int 
  "Parses the string argument as a signed decimal integer."
  [s]
  (Integer/parseInt s))

(defn not-zero?
  "Returns true if n is not zero."
  [n]
  (not (zero? n)))
