/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.InetAddress;
import java.util.ArrayList;
import netP5.Bytes;
import netP5.TcpClient;
import oscP5.OscMessage;

public abstract class OscPatcher {
    protected static final byte ZEROBYTE = 0;
    protected static final byte KOMMA = 44;
    protected static final long TIMETAG_OFFSET = 2208988800L;
    protected static final long TIEMTAG_NOW = 1L;
    protected ArrayList<OscMessage> messages;
    protected byte[] _myAddrPattern;
    protected int _myAddrInt = -1;
    protected byte[] _myTypetag = new byte[0];
    protected byte[] _myData = new byte[0];
    protected Object[] _myArguments;
    protected boolean isValid = false;
    protected long timetag = 1L;
    protected boolean isArray = false;
    protected byte _myArrayType = 0;

    protected OscPatcher() {
    }

    protected int parseBundle(byte[] theBytes, InetAddress theAddress, int thePort, TcpClient theClient) {
        if (theBytes.length > 16) {
            this.timetag = new Long(Bytes.toLong(Bytes.copy(theBytes, 8, 8)));
            int myPosition = 16;
            this.messages = new ArrayList();
            int myMessageLength = Bytes.toInt(Bytes.copy(theBytes, myPosition, 4));
            while (myMessageLength != 0 && myMessageLength % 4 == 0 && myPosition < theBytes.length) {
                this.messages.add(new OscMessage(Bytes.copy(theBytes, myPosition += 4, myMessageLength), theAddress, thePort, this.timetag, theClient));
                if ((myPosition += myMessageLength) >= theBytes.length) break;
                myMessageLength = Bytes.toInt(Bytes.copy(theBytes, myPosition, 4));
            }
        }
        for (int i = 0; i < this.messages.size(); ++i) {
            if (this.messages.get((int)i).isValid) continue;
            this.messages.remove(this.messages.get(i));
        }
        if (this.messages.size() > 0) {
            this.isValid = true;
        }
        return this.messages.size();
    }

    protected void parseMessage(byte[] theBytes) {
        int myLength = theBytes.length;
        int myIndex = 0;
        if ((myIndex = this.parseAddrPattern(theBytes, myLength, myIndex)) != -1) {
            myIndex = this.parseTypetag(theBytes, myLength, myIndex);
        }
        if (myIndex != -1) {
            this._myData = Bytes.copy(theBytes, myIndex);
            this._myArguments = this.parseArguments(this._myData);
            this.isValid = true;
        }
    }

    protected int parseAddrPattern(byte[] theBytes, int theLength, int theIndex) {
        if (theLength > 4 && theBytes[4] == 44) {
            this._myAddrInt = Bytes.toInt(Bytes.copy(theBytes, 0, 4));
        }
        for (int i = theIndex; i < theLength; ++i) {
            if (theBytes[i] != 0) continue;
            this._myAddrPattern = Bytes.copy(theBytes, theIndex, i);
            return i + OscPatcher.align(i);
        }
        return -1;
    }

    protected int parseTypetag(byte[] theBytes, int theLength, int theIndex) {
        if (theBytes[theIndex] == 44) {
            for (int i = ++theIndex; i < theLength; ++i) {
                if (theBytes[i] != 0) continue;
                this._myTypetag = Bytes.copy(theBytes, theIndex, i - theIndex);
                return i + OscPatcher.align(i);
            }
        }
        return -1;
    }

    protected Object[] parseArguments(byte[] theBytes) {
        Object[] myArguments = new Object[]{};
        int myIndex = 0;
        myArguments = new Object[this._myTypetag.length];
        boolean bl = this.isArray = this._myTypetag.length > 0;
        block10: for (int myTagIndex = 0; myTagIndex < this._myTypetag.length; ++myTagIndex) {
            if (myTagIndex == 0) {
                this._myArrayType = this._myTypetag[myTagIndex];
            } else if (this._myTypetag[myTagIndex] != this._myArrayType) {
                this.isArray = false;
            }
            switch (this._myTypetag[myTagIndex]) {
                case 99: {
                    myArguments[myTagIndex] = new Character((char)Bytes.toInt(Bytes.copy(theBytes, myIndex, 4)));
                    myIndex += 4;
                    continue block10;
                }
                case 105: {
                    myArguments[myTagIndex] = new Integer(Bytes.toInt(Bytes.copy(theBytes, myIndex, 4)));
                    myIndex += 4;
                    continue block10;
                }
                case 102: {
                    myArguments[myTagIndex] = new Float(Bytes.toFloat(Bytes.copy(theBytes, myIndex, 4)));
                    myIndex += 4;
                    continue block10;
                }
                case 104: 
                case 108: {
                    myArguments[myTagIndex] = new Long(Bytes.toLong(Bytes.copy(theBytes, myIndex, 8)));
                    myIndex += 8;
                    continue block10;
                }
                case 100: {
                    myArguments[myTagIndex] = new Double(Bytes.toDouble(Bytes.copy(theBytes, myIndex, 8)));
                    myIndex += 8;
                    continue block10;
                }
                case 83: 
                case 115: {
                    int newIndex = myIndex;
                    StringBuffer stringBuffer = new StringBuffer();
                    while (theBytes[newIndex] != 0) {
                        stringBuffer.append((char)theBytes[newIndex]);
                        if (++newIndex < theBytes.length) continue;
                    }
                    myArguments[myTagIndex] = stringBuffer.toString();
                    myIndex = newIndex + OscPatcher.align(newIndex);
                    continue block10;
                }
                case 98: {
                    int myLen = Bytes.toInt(Bytes.copy(theBytes, myIndex, 4));
                    myArguments[myTagIndex] = Bytes.copy(theBytes, myIndex += 4, myLen);
                    myIndex += myLen + OscPatcher.align(myLen) % 4;
                    continue block10;
                }
                case 109: {
                    myArguments[myTagIndex] = Bytes.copy(theBytes, myIndex, 4);
                    myIndex += 4;
                }
            }
        }
        this._myData = Bytes.copy(this._myData, 0, myIndex);
        return myArguments;
    }

    protected static int align(int theInt) {
        return 4 - theInt % 4;
    }
}

