/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.util.ArrayList;
import netP5.AbstractMulticast;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.Multicast;
import netP5.NetAddress;
import netP5.NetAddressList;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;
import netP5.TcpServer;
import netP5.UdpClient;
import netP5.UdpPacketListener;
import netP5.UdpServer;
import oscP5.OscMessage;
import oscP5.OscPacket;
import oscP5.OscProperties;

public class OscNetManager
implements UdpPacketListener,
TcpPacketListener {
    protected OscProperties _myOscProperties;
    protected UdpClient _myUdpClient = null;
    protected UdpServer _myUdpServer = null;
    protected TcpServer _myTcpServer = null;
    protected TcpClient _myTcpClient = null;
    protected boolean isTcpClient = false;
    protected boolean isTcpServer = false;
    protected AbstractMulticast _myMulticast = null;
    protected ArrayList<UdpPacketListener> _myUdpListener = new ArrayList();
    protected ArrayList<TcpPacketListener> _myTcpListener = new ArrayList();
    public static final int NONE = 0;

    public void start(OscProperties theOscProperties) {
        this.stop();
        this._myOscProperties = theOscProperties;
        int networkProtocol = this._myOscProperties.networkProtocol();
        switch (networkProtocol) {
            case 0: {
                this.newUdp();
                break;
            }
            case 1: {
                this.newMulticast();
                break;
            }
            case 2: {
                this.newTcp();
            }
        }
        this._myOscProperties.isLocked = true;
    }

    protected void stop() {
        this._myUdpClient = null;
        if (this._myMulticast != null) {
            Logger.printDebug("OscP5.stop", "multicast.");
            this._myMulticast.dispose();
        }
        if (this._myUdpServer != null) {
            Logger.printDebug("OscP5.stop", "stopping udpserver.");
            this._myUdpServer.dispose();
        }
        this._myMulticast = null;
        this._myUdpServer = null;
        Logger.printProcess("OscP5", "stopped.");
    }

    private void newUdp() {
        this._myUdpClient = this._myOscProperties.remoteAddress() != null && this._myOscProperties.remoteAddress().isvalid() ? new UdpClient(this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port()) : new UdpClient();
        if (this._myOscProperties.listeningPort() > 0) {
            this._myUdpServer = new UdpServer(this, this._myOscProperties.listeningPort(), this._myOscProperties.datagramSize());
        }
    }

    private void newTcp() {
        if (this._myOscProperties.listeningPort() > 0) {
            this._myTcpServer = new TcpServer(this, this._myOscProperties.listeningPort(), 3);
            this.isTcpServer = true;
        } else if (this._myOscProperties.remoteAddress().isvalid()) {
            this._myTcpClient = new TcpClient(this, this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port(), 3);
            this.isTcpClient = true;
        }
    }

    private void newMulticast() {
        if (this._myOscProperties.remoteAddress() != null && this._myOscProperties.remoteAddress().isvalid()) {
            this._myMulticast = new Multicast(this, this._myOscProperties.remoteAddress().address(), this._myOscProperties.remoteAddress().port(), this._myOscProperties.datagramSize());
        } else {
            System.out.println("ERROR @ Multicast");
        }
    }

    public void setTimeToLive(int theTTL) {
        if (this._myMulticast != null) {
            this._myMulticast.setTimeToLive(theTTL);
        } else {
            Logger.printWarning("OscNetManager.setTimeToLive", "only supported for multicast session.");
        }
    }

    public TcpServer tcpServer() {
        return this._myTcpServer;
    }

    public TcpClient tcpClient() {
        return this._myTcpClient;
    }

    public void addUdpListener(UdpPacketListener theListener) {
        this._myUdpListener.add(theListener);
    }

    public void removeUdpListener(UdpPacketListener theListener) {
        this._myUdpListener.remove(theListener);
    }

    public void addTcpListener(TcpPacketListener theListener) {
        this._myTcpListener.add(theListener);
    }

    public void removeTcpListener(TcpPacketListener theListener) {
        this._myTcpListener.remove(theListener);
    }

    public void send(OscPacket thePacket) {
        if (!this._myOscProperties.sendStatus() && this._myOscProperties.networkProtocol() != 2) {
            Logger.printWarning("OscNetManager.send", "please specify a remote address. send(OscPacket theOscPacket) is only supported when there is a host specified in OscProperties.");
        } else {
            try {
                switch (this._myOscProperties.networkProtocol()) {
                    case 0: {
                        if (this._myOscProperties.srsp()) {
                            this._myUdpServer.send(thePacket.getBytes(), this._myOscProperties.remoteAddress().inetaddress(), this._myOscProperties.remoteAddress().port());
                            break;
                        }
                        this._myUdpClient.send(thePacket.getBytes(), this._myOscProperties.remoteAddress().inetaddress(), this._myOscProperties.remoteAddress().port());
                        break;
                    }
                    case 2: {
                        if (this.isTcpServer) {
                            this._myTcpServer.send(thePacket.getBytes());
                            break;
                        }
                        if (!this.isTcpClient) break;
                        this._myTcpClient.send(thePacket.getBytes());
                        break;
                    }
                    case 1: {
                        this._myMulticast.send(thePacket.getBytes());
                    }
                }
            }
            catch (NullPointerException e) {
                Logger.printError("OscManager.send", "NullPointerException " + e);
            }
        }
    }

    public void send(DatagramPacket thePacket) {
        if (this._myOscProperties.srsp()) {
            this._myUdpServer.send(thePacket);
        } else {
            this._myUdpClient.send(thePacket);
        }
    }

    public void send(OscPacket thePacket, String theAddress, int thePort) {
        try {
            switch (this._myOscProperties.networkProtocol()) {
                case 0: {
                    if (this._myOscProperties.srsp()) {
                        this._myUdpServer.send(thePacket.getBytes(), theAddress, thePort);
                        break;
                    }
                    this._myUdpClient.send(thePacket.getBytes(), theAddress, thePort);
                    break;
                }
                case 1: {
                    this._myMulticast.send(thePacket.getBytes());
                    break;
                }
                case 2: {
                    Logger.printWarning("OscP5.send", "send(OscPacket thePacket,String theAddress,int thePort) is not supported in TCP mode.");
                }
            }
        }
        catch (NullPointerException e) {
            Logger.printError("OscP5.send", "NullPointerException " + e);
        }
    }

    public void send(OscPacket thePacket, NetAddressList theList) {
        switch (this._myOscProperties.networkProtocol()) {
            case 0: {
                byte[] myBytes = thePacket.getBytes();
                DatagramPacket myPacket = new DatagramPacket(myBytes, myBytes.length);
                for (int i = 0; i < theList.list().size(); ++i) {
                    myPacket.setAddress(theList.get(i).inetaddress());
                    myPacket.setPort(theList.get(i).port());
                    this.send(myPacket);
                }
                break;
            }
            case 2: {
                Logger.printWarning("OscP5.send", "send(OscPacket thePacket,NetAddressList theList) is not supported in TCP mode.");
            }
        }
    }

    public void send(OscPacket thePacket, NetAddress theHost) {
        switch (this._myOscProperties.networkProtocol()) {
            case 0: {
                if (!theHost.isvalid()) break;
                byte[] myBytes = thePacket.getBytes();
                DatagramPacket myPacket = new DatagramPacket(myBytes, myBytes.length);
                myPacket.setAddress(theHost.inetaddress());
                myPacket.setPort(theHost.port());
                this.send(myPacket);
                break;
            }
            case 2: {
                Logger.printWarning("OscP5.send", "send(OscPacket thePacket,NetAddress theHost) is not supported in TCP mode.");
            }
        }
    }

    public void send(String theAddrPattern, Object[] theArguments) {
        this.send(new OscMessage(theAddrPattern, theArguments));
    }

    public void send(String theAddrPattern, Object[] theArguments, String theAddress, int thePort) {
        this.send(new OscMessage(theAddrPattern, theArguments), theAddress, thePort);
    }

    public void send(String theAddrPattern, Object[] theArguments, NetAddressList theList) {
        this.send((OscPacket)new OscMessage(theAddrPattern, theArguments), theList);
    }

    public void send(String theAddrPattern, Object[] theArguments, NetAddress theHost) {
        this.send((OscPacket)new OscMessage(theAddrPattern, theArguments), theHost);
    }

    public void process(DatagramPacket thePacket, int thePort) {
        for (int i = 0; i < this._myUdpListener.size(); ++i) {
            this._myUdpListener.get(i).process(thePacket, thePort);
        }
    }

    public void process(TcpPacket thePacket, int thePort) {
        for (int i = 0; i < this._myTcpListener.size(); ++i) {
            this._myTcpListener.get(i).process(thePacket, thePort);
        }
    }

    public void remove(AbstractTcpClient theClient) {
    }

    public void status(int theIndex) {
    }
}

