/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.Bytes;
import netP5.Logger;
import netP5.TcpClient;
import netP5.TcpPacket;
import oscP5.OscArgument;
import oscP5.OscPacket;

public class OscMessage
extends OscPacket {
    protected final OscArgument _myOscArgument = new OscArgument();
    protected boolean isPlugged = false;

    protected OscMessage(DatagramPacket theDatagramPacket) {
        this.inetAddress = theDatagramPacket.getAddress();
        this.port = theDatagramPacket.getPort();
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(theDatagramPacket.getData());
        this._myType = 0;
    }

    protected OscMessage(TcpPacket thePacket) {
        this._myTcpClient = thePacket.getTcpConnection();
        this.inetAddress = this._myTcpClient.netAddress().inetaddress();
        this.port = this._myTcpClient.netAddress().port();
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(thePacket.getData());
        this._myType = 0;
    }

    public OscMessage(OscMessage theOscMessage) {
        this.inetAddress = theOscMessage.inetAddress;
        this.port = theOscMessage.port;
        this.hostAddress = theOscMessage.hostAddress;
        this._myTcpClient = theOscMessage.tcpConnection();
        this._myAddrPattern = theOscMessage._myAddrPattern;
        this._myTypetag = theOscMessage._myTypetag;
        this._myData = theOscMessage._myData;
        this._myArguments = theOscMessage._myArguments;
        this.isValid = true;
    }

    public OscMessage(String theAddrPattern) {
        this(theAddrPattern, new Object[0]);
    }

    public OscMessage(int theAddrInt) {
        this(theAddrInt, new Object[0]);
    }

    public OscMessage(String theAddrPattern, Object[] theArguments) {
        this.init();
        this.setAddrPattern(theAddrPattern);
        this.setArguments(theArguments);
    }

    public OscMessage(int theAddrPattern, Object[] theArguments) {
        this.init();
        this.setAddrPattern(theAddrPattern);
        this.setArguments(theArguments);
    }

    protected OscMessage(byte[] theBytes, InetAddress theInetAddress, int thePort, TcpClient theClient) {
        this._myTcpClient = theClient;
        this.inetAddress = theInetAddress;
        this.port = thePort;
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(theBytes);
    }

    protected OscMessage(byte[] theBytes, InetAddress theInetAddress, int thePort, long theTimetag, TcpClient theClient) {
        this(theBytes, theInetAddress, thePort, theClient);
        this.timetag = theTimetag;
    }

    protected void init() {
        this._myTypetag = new byte[0];
        this._myData = new byte[0];
    }

    public void clear() {
        this.init();
        this.setAddrPattern("");
        this.setArguments(new Object[0]);
    }

    public void clearArguments() {
        this._myTypetag = new byte[0];
        this._myData = new byte[0];
        this._myArguments = new Object[0];
    }

    public void set(int theIndex, Object theObject) {
        System.out.println("Typetag:\t" + this._myTypetag.length);
        System.out.println("Arguments:\t");
        Bytes.printBytes(this._myData);
        System.out.println(this._myArguments.length);
        for (int i = 0; i < this._myArguments.length; ++i) {
            System.out.println(this._myArguments[i]);
        }
    }

    public boolean checkTypetag(String theTypeTag) {
        return theTypeTag.equals(this.typetag());
    }

    public boolean checkAddrPattern(String theAddrPattern) {
        return theAddrPattern.equals(this.addrPattern());
    }

    public void setAddrPattern(String theAddrPattern) {
        this._myAddrPattern = theAddrPattern.getBytes();
    }

    public void setAddrPattern(int theAddrPattern) {
        this._myAddrPattern = Bytes.toBytes(theAddrPattern);
    }

    public void setArguments(Object[] theArguments) {
        this.clearArguments();
        this.addArguments(theArguments);
    }

    public OscMessage addArguments(Object[] theArguments) {
        return this.add(theArguments);
    }

    public String addrPattern() {
        return Bytes.getAsString(this._myAddrPattern);
    }

    public int addrInt() {
        return this._myAddrInt;
    }

    public String typetag() {
        return Bytes.getAsString(this._myTypetag);
    }

    public long timetag() {
        return this.timetag;
    }

    public Object[] arguments() {
        return this._myArguments;
    }

    protected Object[] argsAsArray() {
        switch (this._myTypetag[0]) {
            case 102: {
                float[] myFloatArray = new float[this._myArguments.length];
                for (int i = 0; i < myFloatArray.length; ++i) {
                    myFloatArray[i] = ((Float)this._myArguments[i]).floatValue();
                }
                return new Object[]{myFloatArray};
            }
            case 105: {
                int[] myIntArray = new int[this._myArguments.length];
                for (int i = 0; i < myIntArray.length; ++i) {
                    myIntArray[i] = (Integer)this._myArguments[i];
                }
                return new Object[]{myIntArray};
            }
            case 83: 
            case 115: {
                String[] myStringArray = new String[this._myArguments.length];
                for (int i = 0; i < myStringArray.length; ++i) {
                    myStringArray[i] = (String)this._myArguments[i];
                }
                return new Object[]{myStringArray};
            }
        }
        return new Object[0];
    }

    public byte[] getAddrPatternAsBytes() {
        return Bytes.append(this._myAddrPattern, new byte[OscMessage.align(this._myAddrPattern.length)]);
    }

    public byte[] getTypetagAsBytes() {
        return this._myTypetag;
    }

    public byte[] getBytes() {
        byte[] myBytes = new byte[]{};
        byte[] myTypeTag = Bytes.copy(this._myTypetag, 0);
        myBytes = Bytes.append(myBytes, this._myAddrPattern, new byte[OscMessage.align(this._myAddrPattern.length)]);
        if (myTypeTag.length == 0) {
            myTypeTag = new byte[]{44};
        } else if (myTypeTag[0] != 44) {
            myTypeTag = Bytes.append(new byte[]{44}, myTypeTag);
        }
        myBytes = Bytes.append(myBytes, myTypeTag, new byte[OscMessage.align(myTypeTag.length)]);
        myBytes = Bytes.append(myBytes, this._myData, new byte[OscMessage.align(this._myData.length) % 4]);
        return myBytes;
    }

    protected Object[] increase(int theAmount) {
        if (this._myArguments.length < 1 || this._myArguments == null) {
            return new Object[1];
        }
        Object[] myArguments = new Object[this._myArguments.length + theAmount];
        System.arraycopy(this._myArguments, 0, myArguments, 0, this._myArguments.length);
        return myArguments;
    }

    public OscMessage add() {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{78});
        return this;
    }

    public OscMessage add(int theValue) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{105});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(theValue));
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = new Integer(theValue);
        return this;
    }

    public OscMessage add(String theValue) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{115});
        byte[] myString = theValue.getBytes();
        this._myData = Bytes.append(this._myData, myString, new byte[OscMessage.align(myString.length)]);
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = theValue;
        return this;
    }

    public OscMessage add(float theValue) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{102});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(Float.floatToIntBits(theValue)));
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = new Float(theValue);
        return this;
    }

    public OscMessage add(double theValue) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{100});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(Double.doubleToLongBits(theValue)));
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = new Double(theValue);
        return this;
    }

    public OscMessage add(boolean theValue) {
        this._myTypetag = theValue ? Bytes.append(this._myTypetag, new byte[]{84}) : Bytes.append(this._myTypetag, new byte[]{70});
        return this;
    }

    public OscMessage add(Boolean theValue) {
        this.add((boolean)theValue);
        return this;
    }

    public OscMessage add(Integer theValue) {
        this.add((int)theValue);
        return this;
    }

    public OscMessage add(Float theValue) {
        this.add(theValue.floatValue());
        return this;
    }

    public OscMessage add(Double theValue) {
        this.add((double)theValue);
        return this;
    }

    public OscMessage add(Character theValue) {
        this.add(theValue.charValue());
        return this;
    }

    public OscMessage add(char theValue) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{99});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(theValue));
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = new Character(theValue);
        return this;
    }

    public OscMessage add(int channel, int status, int value1, int value2) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{109});
        byte[] theBytes = new byte[]{(byte)channel, (byte)status, (byte)value1, (byte)value2};
        this._myData = Bytes.append(this._myData, theBytes);
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = theBytes;
        return this;
    }

    public OscMessage add(int[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            this.add(theArray[i]);
        }
        return this;
    }

    public OscMessage add(char[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            this.add(theArray[i]);
        }
        return this;
    }

    public OscMessage add(float[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            this.add(theArray[i]);
        }
        return this;
    }

    public OscMessage add(String[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            this.add(theArray[i]);
        }
        return this;
    }

    public OscMessage add(byte[] theArray) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{98});
        this._myData = Bytes.append(this._myData, OscMessage.makeBlob(theArray));
        this._myArguments = this.increase(1);
        this._myArguments[this._myArguments.length - 1] = theArray;
        return this;
    }

    public OscMessage add(Object[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            if (this.add(theArray[i])) continue;
            System.out.println("type of Argument not defined in osc specs.");
        }
        return this;
    }

    private boolean add(Object theObject) {
        if (theObject instanceof Number) {
            if (theObject instanceof Integer) {
                this.add((Integer)theObject);
            } else if (theObject instanceof Float) {
                this.add((Float)theObject);
            } else if (theObject instanceof Double) {
                this.add((Double)theObject);
            } else if (theObject instanceof Long) {
                this.add((Long)theObject);
            }
        } else if (theObject instanceof String) {
            this.add((String)theObject);
        } else if (theObject instanceof Boolean) {
            this.add((Boolean)theObject);
        } else if (theObject instanceof Character) {
            this.add((Character)theObject);
        } else {
            if (theObject instanceof int[]) {
                this.add((int[])theObject);
                return true;
            }
            if (theObject instanceof float[]) {
                this.add((float[])theObject);
                return true;
            }
            if (theObject instanceof byte[]) {
                this.add((byte[])theObject);
                return true;
            }
            if (theObject instanceof String[]) {
                this.add((String[])theObject);
                return true;
            }
            if (theObject instanceof char[]) {
                this.add((char[])theObject);
                return true;
            }
            if (theObject instanceof double[]) {
                this.add((float[])theObject);
                return true;
            }
            return false;
        }
        return true;
    }

    public static byte[] makeBlob(byte[] b) {
        int tLength = b.length;
        byte[] b1 = Bytes.toBytes(tLength);
        b1 = Bytes.append(b1, b);
        int t = tLength % 4;
        if (t != 0) {
            b1 = Bytes.append(b1, new byte[4 - t]);
        }
        return b1;
    }

    public OscArgument get(int theIndex) {
        if (theIndex < this.arguments().length) {
            this._myOscArgument.value = this.arguments()[theIndex];
            return this._myOscArgument;
        }
        return null;
    }

    public final String toString() {
        return this.hostAddress + ":" + this.port + " | " + this.addrPattern() + " " + this.typetag();
    }

    public boolean isPlugged() {
        return this.isPlugged;
    }

    public void print() {
        Logger.println("-OscMessage----------");
        Logger.println("received from\t" + this.hostAddress + ":" + this.port);
        Logger.println("addrpattern\t" + Bytes.getAsString(this._myAddrPattern));
        Logger.println("typetag\t" + Bytes.getAsString(this._myTypetag));
        Logger.println(Bytes.getAsString(this._myArguments));
        Logger.println("---------------------");
    }

    public void printData() {
        Bytes.printBytes(this._myData);
    }
}

