/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.util.ArrayList;
import netP5.Bytes;
import netP5.TcpPacket;
import oscP5.OscMessage;
import oscP5.OscPacket;

public class OscBundle
extends OscPacket {
    protected static final int BUNDLE_HEADER_SIZE = 16;
    protected static final byte[] BUNDLE_AS_BYTES = new byte[]{35, 98, 117, 110, 100, 108, 101, 0};
    private int _myMessageSize = 0;

    public OscBundle() {
        this.messages = new ArrayList();
    }

    protected OscBundle(DatagramPacket theDatagramPacket) {
        this.inetAddress = theDatagramPacket.getAddress();
        this.port = theDatagramPacket.getPort();
        this.hostAddress = this.inetAddress.toString();
        this._myMessageSize = this.parseBundle(theDatagramPacket.getData(), this.inetAddress, this.port, null);
        this._myType = 1;
    }

    protected OscBundle(TcpPacket thePacket) {
        this._myTcpClient = thePacket.getTcpConnection();
        this.inetAddress = this._myTcpClient.netAddress().inetaddress();
        this.port = this._myTcpClient.netAddress().port();
        this.hostAddress = this.inetAddress.toString();
        this._myMessageSize = this.parseBundle(thePacket.getData(), this.inetAddress, this.port, this._myTcpClient);
        this._myType = 1;
    }

    public void add(OscMessage theOscMessage) {
        this.messages.add(new OscMessage(theOscMessage));
        this._myMessageSize = this.messages.size();
    }

    public void clear() {
        this.messages = new ArrayList();
    }

    public void remove(int theIndex) {
        this.messages.remove(theIndex);
    }

    public void remove(OscMessage theOscMessage) {
        this.messages.remove(theOscMessage);
    }

    public OscMessage getMessage(int theIndex) {
        return (OscMessage)this.messages.get(theIndex);
    }

    public int size() {
        return this._myMessageSize;
    }

    public void setTimetag(long theTime) {
        long secsSince1900 = theTime / 1000L + 2208988800L;
        long secsFractional = (theTime % 1000L << 32) / 1000L;
        this.timetag = secsSince1900 << 32 | secsFractional;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public byte[] timetag() {
        return Bytes.toBytes(this.timetag);
    }

    public byte[] getBytes() {
        byte[] myBytes = new byte[]{};
        myBytes = Bytes.append(myBytes, BUNDLE_AS_BYTES);
        myBytes = Bytes.append(myBytes, this.timetag());
        for (int i = 0; i < this.size(); ++i) {
            byte[] tBytes = this.getMessage(i).getBytes();
            myBytes = Bytes.append(myBytes, Bytes.toBytes(tBytes.length));
            myBytes = Bytes.append(myBytes, tBytes);
        }
        return myBytes;
    }
}

