/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    protected static String VALID_RANDOM_CHARACTERS = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ-_.,;:<>()1234567890%&/=?+";

    protected StringUtils() {
    }

    public static String right(String source, String searchFor) {
        int index = source.indexOf(searchFor) + searchFor.length();
        if (index < 0) {
            return "";
        }
        return source.substring(index);
    }

    public static String rightBack(String source, String searchFor) {
        int index = source.lastIndexOf(searchFor) + searchFor.length();
        if (index < 0) {
            return "";
        }
        return source.substring(index);
    }

    public static String left(String source, String searchFor) {
        int index = source.indexOf(searchFor);
        if (index <= 0) {
            return "";
        }
        return source.substring(0, index);
    }

    public static String leftBack(String source, String searchFor) {
        int index = source.lastIndexOf(searchFor);
        if (index <= 0) {
            return "";
        }
        return source.substring(0, index);
    }

    public static String middle(String source, String start, String end) {
        String one = StringUtils.right(source, start);
        return StringUtils.leftBack(one, end);
    }

    public static String middle(String source, int startIndex, int length) {
        return source.substring(startIndex, source.length() - length);
    }

    public static String replace(String source, String searchFor, String replaceWith) {
        if (source.length() < 1) {
            return "";
        }
        for (int p = 0; p < source.length() && (p = source.indexOf(searchFor, p)) >= 0; p += replaceWith.length()) {
            source = source.substring(0, p) + replaceWith + source.substring(p + searchFor.length(), source.length());
        }
        return source;
    }

    public static String replace(String source, String[] searchFor, String replaceWith) {
        for (int i = 0; i < searchFor.length; ++i) {
            StringUtils.replace(source, searchFor[i], replaceWith);
        }
        return source;
    }

    public static Vector explode(String[] source, int[] lengths) {
        Vector<String[]> v = new Vector<String[]>();
        for (int i = 0; i < source.length; ++i) {
            v.addElement(StringUtils.explode(source[i], lengths));
        }
        return v;
    }

    public static String[] explode(String source, int[] lengths) {
        String[] result = new String[lengths.length];
        int position = 0;
        for (int i = 0; i < lengths.length; ++i) {
            if (lengths[i] + position > source.length()) {
                throw new IndexOutOfBoundsException();
            }
            result[i] = source.substring(position, position + lengths[i]);
            position += lengths[i];
        }
        return result;
    }

    public static String[] explode(String source) {
        return StringUtils.explode(source, " ");
    }

    public static String[] explode(String s, String delimiter) {
        int end;
        int delimiterLength;
        int stringLength = s.length();
        if (delimiter == null || (delimiterLength = delimiter.length()) == 0) {
            return new String[]{s};
        }
        int count = 0;
        int start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            ++count;
            start = end + delimiterLength;
        }
        String[] result = new String[++count];
        count = 0;
        start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            result[count] = s.substring(start, end);
            ++count;
            start = end + delimiterLength;
        }
        end = stringLength;
        result[count] = s.substring(start, end);
        return result;
    }

    public static String[] slice(int theNum, String[] theStringArray) {
        if (theNum < theStringArray.length) {
            String[] t = new String[theStringArray.length - theNum];
            for (int i = theNum; i < theStringArray.length; ++i) {
                t[i - theNum] = theStringArray[i];
            }
            return t;
        }
        return theStringArray;
    }

    public static String implode(Object[] elements, String delimiter) {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < elements.length - 1; ++i) {
            buffer.append((String)elements[i] + delimiter);
        }
        buffer.append((String)elements[elements.length - 1]);
        return buffer.toString();
    }

    public static String implode(Object[] elements) {
        return StringUtils.implode(elements, ", ");
    }

    public static String remove(String source, char searchFor) {
        String s = String.valueOf(searchFor);
        return StringUtils.remove(source, s);
    }

    public static String remove(String source, String searchFor) {
        return StringUtils.replace(source, searchFor, "");
    }

    public static String remove(String source, String[] searchFor) {
        return StringUtils.replace(source, searchFor, "");
    }

    public static String removeDuplicates(String source, String searchFor) {
        StringBuffer result = new StringBuffer("");
        StringTokenizer myEnum = new StringTokenizer(source, searchFor, true);
        String current = "";
        String previous = "";
        while (myEnum.hasMoreElements()) {
            current = (String)myEnum.nextElement();
            if (!current.equals(previous)) {
                result.append(current);
            }
            previous = current;
        }
        return result.toString();
    }

    protected String unique(String source) {
        String result = "";
        for (int k = 0; k < source.length(); ++k) {
            if (result.indexOf(source.charAt(k)) != -1) continue;
            result = result + source.charAt(k);
        }
        return result;
    }

    public static String getStackTrace(Throwable t) throws IOException {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        sw.close();
        return sw.toString();
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.equals("");
    }

    public static String leftJustify(String source, int length) {
        if (source.length() >= length) {
            return source;
        }
        return StringUtils.spaces(length - source.length()) + source;
    }

    public static String rightJustify(String source, int length) {
        if (source.length() >= length) {
            return source;
        }
        return source + StringUtils.spaces(length - source.length());
    }

    public static String centerJustify(String source, int length) {
        if (source.length() >= length) {
            return source;
        }
        int leftLength = (length - source.length()) / 2;
        int rightLength = length - (leftLength + source.length());
        return StringUtils.spaces(leftLength) + source + StringUtils.spaces(rightLength);
    }

    public static String spaces(int length) {
        return StringUtils.duplicate(" ", length);
    }

    public static String duplicate(String source, int copies) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < copies; ++i) {
            buf.append(source);
        }
        return buf.toString();
    }

    public static String switchCase(String source) {
        char[] sourceArray = source.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sourceArray.length; ++i) {
            result.append(StringUtils.switchCase(sourceArray[i]));
        }
        return result.toString();
    }

    public static char switchCase(char source) {
        if (Character.isUpperCase(source)) {
            return Character.toLowerCase(source);
        }
        if (Character.isLowerCase(source)) {
            return Character.toUpperCase(source);
        }
        return source;
    }

    public static int getInt(String theString) {
        int i = 0;
        try {
            i = Integer.valueOf(theString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static float getFloat(String theString) {
        float i = 0.0f;
        try {
            i = Float.valueOf(theString).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static String arrayToString(String[] theArray) {
        String myString = "";
        for (int i = 0; i < theArray.length; ++i) {
            myString = myString + theArray[i] + ",";
        }
        myString = myString.substring(0, myString.length() - 1);
        return myString;
    }

    public static String arrayToString(String[] theArray, int theStart, int theEnd) {
        String myString = "";
        if (theArray.length > theStart) {
            for (int i = theStart; i < theEnd; ++i) {
                myString = myString + theArray[i] + " ";
            }
            myString = myString.substring(0, myString.length() - 1);
        }
        return myString;
    }
}

