/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.util.Vector;
import netP5.NetListener;
import netP5.NetMessage;
import netP5.NetStatus;
import netP5.TcpPacket;

class NetPlug {
    protected boolean isEventMethod = false;
    protected Method _myEventMethod;
    protected String _myEventMethodName = "netEvent";
    protected boolean isStatusMethod = false;
    protected Method _myStatusMethod;
    protected String _myStatusMethodName = "netStatus";
    protected Class _myParentClass;
    protected Object _myParent;
    protected Vector _myNetListeners;
    protected boolean isNetListener;

    protected NetPlug(Object theObject) {
        this._myParent = theObject;
        this._myNetListeners = new Vector();
        this.checkMethod();
    }

    protected void invoke(Object theObject, Method theMethod, Object[] theArgs) {
        try {
            theMethod.invoke(theObject, theArgs);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.out.println("NetP5 ClassCastException. parsing failed for NetMessage " + e);
        }
    }

    protected void checkMethod() {
        try {
            this.checkEventMethod();
            this.checkStatusMethod();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkEventMethod() {
        this._myParentClass = this._myParent.getClass();
        if (this._myEventMethodName != null) {
            try {
                this._myEventMethod = this._myParentClass.getDeclaredMethod(this._myEventMethodName, NetMessage.class);
                this.isEventMethod = true;
                this._myEventMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                System.out.println("### NOTE. no netEvent(NetMessage theMessage) method available.");
            }
        }
        return this._myEventMethod != null;
    }

    private boolean checkStatusMethod() {
        this._myParentClass = this._myParent.getClass();
        if (this._myStatusMethodName != null) {
            try {
                this._myStatusMethod = this._myParentClass.getDeclaredMethod(this._myStatusMethodName, NetStatus.class);
                this.isStatusMethod = true;
                this._myStatusMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this._myStatusMethod != null;
    }

    public void process(DatagramPacket theDatagramPacket, int thePort) {
        if (this.isNetListener || this.isEventMethod) {
            NetMessage n = new NetMessage(theDatagramPacket);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netEvent(n);
            }
            if (this.isEventMethod) {
                try {
                    this.invoke(this._myParent, this._myEventMethod, new Object[]{n});
                }
                catch (ClassCastException e) {
                    System.out.println("ChatP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    public void status(int theIndex) {
        if (this.isNetListener || this.isEventMethod) {
            NetStatus n = new NetStatus(theIndex);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netStatus(n);
            }
            if (this.isStatusMethod) {
                try {
                    this.invoke(this._myParent, this._myStatusMethod, new Object[]{n});
                }
                catch (ClassCastException e) {
                    System.out.println("ChatP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    public void process(TcpPacket theTcpPacket, int thePort) {
        if (this.isNetListener || this.isEventMethod) {
            NetMessage n = new NetMessage(theTcpPacket);
            for (int i = 0; i < this._myNetListeners.size(); ++i) {
                this.getListener(i).netEvent(n);
            }
            if (this.isEventMethod) {
                try {
                    this.invoke(this._myParent, this._myEventMethod, new Object[]{n});
                }
                catch (ClassCastException e) {
                    System.out.println("NetP5.callMessage ClassCastException. failed to forward ChatMessage.");
                }
            }
        }
    }

    protected void addListener(NetListener theListener) {
        this._myNetListeners.add(theListener);
        this.isNetListener = true;
    }

    protected void removeListener(NetListener theListener) {
        this._myNetListeners.remove(theListener);
        this.isNetListener = this._myNetListeners.size() > 0;
    }

    protected NetListener getListener(int theIndex) {
        return (NetListener)this._myNetListeners.get(theIndex);
    }

    protected Vector getListeners() {
        return this._myNetListeners;
    }
}

