/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import netP5.Logger;
import netP5.UdpPacketListener;

public abstract class AbstractUdpServer
implements Runnable {
    private DatagramSocket _myDatagramSocket = null;
    protected UdpPacketListener _myListener;
    private Thread _myThread = null;
    private int _myPort;
    private String _myAddress;
    private InetAddress _myInetAddress;
    protected int _myDatagramSize = 1536;
    private boolean isRunning = true;
    private boolean isSocket = false;

    public AbstractUdpServer(UdpPacketListener theListener, int thePort, int theBufferSize) {
        this._myDatagramSize = theBufferSize;
        this._myPort = thePort;
        this._myListener = theListener;
        if (this._myListener != null) {
            this.start();
        }
    }

    protected AbstractUdpServer(UdpPacketListener theListener, String theAddress, int thePort, int theBufferSize) {
        this._myDatagramSize = theBufferSize;
        this._myAddress = theAddress;
        this._myPort = thePort;
        this._myListener = theListener;
        if (this._myListener != null) {
            this.start();
        }
    }

    public DatagramSocket socket() {
        return this._myDatagramSocket;
    }

    public void start() {
        this._myThread = null;
        this._myDatagramSocket = null;
        this._myThread = new Thread(this);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            Logger.printError("UdpServer.start()", "oscServer sleep interruption " + iex);
        }
        try {
            this._myDatagramSocket = new DatagramSocket(this._myPort);
            this._myInetAddress = InetAddress.getByName(this._myAddress);
            Logger.printProcess("UdpServer.start()", "new Unicast DatagramSocket created @ port " + this._myPort);
        }
        catch (IOException ioex) {
            Logger.printError("UdpServer.start()", " IOException, couldnt create new DatagramSocket @ port " + this._myPort + " " + ioex);
        }
        if (this._myDatagramSocket != null) {
            this._myThread.start();
            this.isRunning = this._myThread.isAlive();
            this.isSocket = true;
        } else {
            this.isRunning = false;
        }
    }

    public void run() {
        if (this._myDatagramSocket != null) {
            if (this.isRunning) {
                Logger.printProcess("UdpServer.run()", "UdpServer is running @ " + this._myPort);
            }
        } else {
            Logger.printError("UdpServer.run()", "Socket is null. closing UdpServer.");
            return;
        }
        while (this.isRunning) {
            try {
                byte[] myBuffer = new byte[this._myDatagramSize];
                DatagramPacket myPacket = new DatagramPacket(myBuffer, this._myDatagramSize);
                this._myDatagramSocket.receive(myPacket);
                this._myListener.process(myPacket, this._myPort);
            }
            catch (IOException ioex) {
                Logger.printProcess("UdpServer.run()", " socket closed.");
                break;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Logger.printError("UdpServer.run()", "ArrayIndexOutOfBoundsException:  " + ex);
            }
        }
        this.dispose();
    }

    public void dispose() {
        this.isRunning = false;
        this._myThread = null;
        if (this._myDatagramSocket != null) {
            if (this._myDatagramSocket.isConnected()) {
                Logger.printDebug("UdpServer.dispose()", "disconnect()");
                this._myDatagramSocket.disconnect();
            }
            Logger.printDebug("UdpServer.dispose()", "close()");
            this._myDatagramSocket.close();
            this._myDatagramSocket = null;
            Logger.printDebug("UdpServer.dispose()", "Closing unicast datagram socket.");
        }
    }

    public void send(byte[] theBytes) {
        if (this.isSocket) {
            this.send(theBytes, this._myInetAddress, this._myPort);
        } else {
            Logger.printWarning("UdpClient.send", "no InetAddress and port has been set. Packet has not been sent.");
        }
    }

    public void send(byte[] theBytes, String theAddress, int thePort) {
        try {
            InetAddress myInetAddress = InetAddress.getByName(theAddress);
            this.send(theBytes, myInetAddress, thePort);
        }
        catch (UnknownHostException e) {
            Logger.printError("UdpClient.send", "while sending to " + theAddress + " " + e);
        }
    }

    public void send(DatagramPacket thePacket) {
        if (this.isSocket) {
            try {
                this._myDatagramSocket.send(thePacket);
            }
            catch (IOException e) {
                Logger.printError("UdpClient.send", "ioexception while sending packet.");
            }
        }
    }

    public void send(byte[] theBytes, InetAddress theAddress, int thePort) {
        if (this.isSocket) {
            try {
                DatagramPacket myPacket = new DatagramPacket(theBytes, theBytes.length, theAddress, thePort);
                this.send(myPacket);
            }
            catch (NullPointerException npe) {
                Logger.printError("UdpServer.send", "a nullpointer exception occured." + npe);
            }
        } else {
            Logger.printWarning("UdpServer.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

