/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import netP5.Logger;
import netP5.NetAddress;

public abstract class AbstractUdpClient {
    protected NetAddress _myNetAddress;
    protected DatagramSocket _mySocket;
    protected boolean isRunning = false;

    public AbstractUdpClient() {
        this.isRunning = this.openSocket();
    }

    public AbstractUdpClient(String theAddr, int thePort) {
        this._myNetAddress = new NetAddress(theAddr, thePort);
        if (!this._myNetAddress.isvalid()) {
            Logger.printError("UdpClient", "unknown host " + theAddr);
        }
        this.isRunning = this.openSocket();
    }

    public DatagramSocket socket() {
        return this._mySocket;
    }

    private boolean openSocket() {
        try {
            this._mySocket = new DatagramSocket();
        }
        catch (SocketException e) {
            Logger.printError("UdpClient.openSocket", "cant create socket " + e.getMessage());
            return false;
        }
        Logger.printProcess("UdpClient.openSocket", "udp socket initialized.");
        return true;
    }

    public void send(String theString) {
        this.send(theString.getBytes());
    }

    public void send(byte[] theBytes) {
        if (this._myNetAddress.isvalid()) {
            this.send(theBytes, this._myNetAddress);
        } else {
            Logger.printWarning("UdpClient.send", "no InetAddress and port has been set. Packet has not been sent.");
        }
    }

    public void send(byte[] theBytes, NetAddress theNetAddress) {
        if (this._myNetAddress.isvalid()) {
            this.send(theBytes, theNetAddress.inetaddress(), theNetAddress.port());
        }
    }

    public void send(byte[] theBytes, String theAddress, int thePort) {
        try {
            InetAddress myInetAddress = InetAddress.getByName(theAddress);
            this.send(theBytes, myInetAddress, thePort);
        }
        catch (UnknownHostException e) {
            Logger.printError("UdpClient.send", "while sending to " + theAddress + " " + e);
        }
    }

    public void send(DatagramPacket thePacket) {
        if (this.isRunning) {
            try {
                this._mySocket.send(thePacket);
            }
            catch (IOException e) {
                Logger.printError("UdpClient.send", "ioexception while sending packet. " + e);
            }
        }
    }

    public void send(byte[] theBytes, InetAddress theAddress, int thePort) {
        if (this.isRunning) {
            try {
                DatagramPacket myPacket = new DatagramPacket(theBytes, theBytes.length, theAddress, thePort);
                this.send(myPacket);
            }
            catch (NullPointerException npe) {
                Logger.printError("UdpClient.send", "a nullpointer exception occured." + npe);
            }
        } else {
            Logger.printWarning("UdpClient.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

