/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import netP5.Logger;
import netP5.NetAddress;
import netP5.UdpPacketListener;

public abstract class AbstractMulticast
implements Runnable {
    protected NetAddress _myNetAddress;
    protected boolean isRunning;
    protected boolean isSocket;
    protected MulticastSocket _myMulticastSocket;
    protected UdpPacketListener _myListener;
    protected int _myDatagramSize = 1536;
    private Thread _myThread;

    public AbstractMulticast(UdpPacketListener theDatagramListener, String theMulticastAddress, int thePort, int theBufferSize) {
        this._myDatagramSize = theBufferSize;
        this._myListener = theDatagramListener;
        if (this._myListener != null) {
            this.init(theMulticastAddress, thePort);
        }
    }

    public AbstractMulticast(UdpPacketListener theDatagramListener, String theMulticastAddress, int thePort) {
        this._myListener = theDatagramListener;
        if (this._myListener != null) {
            this.init(theMulticastAddress, thePort);
        }
    }

    protected void init(String theMulticastAddress, int thePort) {
        this._myNetAddress = new NetAddress(theMulticastAddress, thePort);
        if (!this._myNetAddress.isvalid()) {
            Logger.printError("UdpClient", "unknown host " + theMulticastAddress);
        }
        this.isRunning = this.openSocket();
        this.start();
    }

    public MulticastSocket socket() {
        return this._myMulticastSocket;
    }

    public void setDatagramSize(int theDatagramSize) {
        this._myDatagramSize = theDatagramSize;
    }

    public void start() {
        this._myThread = null;
        this._myMulticastSocket = null;
        this._myThread = new Thread(this);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            Logger.printError("Multicast.start()", "Multicast sleep interuption " + iex);
        }
        try {
            this._myMulticastSocket = new MulticastSocket(this._myNetAddress.port());
            this._myMulticastSocket.joinGroup(this._myNetAddress.inetaddress());
            Logger.printProcess("Multicast.start()", "new Multicast DatagramSocket created @ port " + this._myNetAddress.port());
        }
        catch (IOException ioex) {
            Logger.printError("Multicast.start()", " IOException, couldnt create new DatagramSocket @ port " + this._myNetAddress.port() + " " + ioex);
        }
        if (this._myMulticastSocket != null) {
            this._myThread.start();
            this.isRunning = this._myThread.isAlive();
            this.isSocket = true;
        } else {
            this.isRunning = false;
        }
    }

    public void run() {
        if (this._myMulticastSocket != null) {
            if (this.isRunning) {
                Logger.printProcess("Multicast.run()", "Multicast is running @ " + this._myNetAddress.inetaddress().getHostAddress() + ":" + this._myNetAddress.port());
            }
        } else {
            Logger.printError("UdpServer.run()", "Socket is null. closing UdpServer.");
            return;
        }
        while (this.isRunning) {
            try {
                byte[] myBuffer = new byte[this._myDatagramSize];
                DatagramPacket myPacket = new DatagramPacket(myBuffer, this._myDatagramSize);
                this._myMulticastSocket.receive(myPacket);
                Logger.printDebug("Multicast.run()", "got it.");
                this._myListener.process(myPacket, this._myNetAddress.port());
            }
            catch (IOException ioex) {
                Logger.printError("UdpServer.run()", "IOException:  " + ioex);
                break;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Logger.printError("UdpServer.run()", "ArrayIndexOutOfBoundsException:  " + ex);
            }
        }
        this.dispose();
    }

    public void dispose() {
        this.close();
    }

    public void close() {
        this.isRunning = false;
        if (this._myMulticastSocket != null) {
            try {
                this._myMulticastSocket.leaveGroup(this._myNetAddress.inetaddress());
                this._myMulticastSocket.disconnect();
                this._myMulticastSocket.close();
                this._myMulticastSocket = null;
                Logger.printProcess("Multicast.close", "Closing multicast datagram socket.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean openSocket() {
        try {
            this._myMulticastSocket = new MulticastSocket();
        }
        catch (SocketException e) {
            Logger.printError("Multicast.openSocket", "cant create socket " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            Logger.printError("Multicast.openSocket", "cant create multicastSocket " + e.getMessage());
            return false;
        }
        Logger.printProcess("Multicast.openSocket", "multicast socket initialized.");
        return true;
    }

    public boolean setTimeToLive(int theTTL) {
        try {
            this._myMulticastSocket.setTimeToLive(theTTL);
            return true;
        }
        catch (IOException ioe) {
            Logger.printError("UdpServer.setTimeToLive()", "" + ioe);
        }
        catch (IllegalArgumentException iae) {
            Logger.printError("UdpServer.setTimeToLive()", "" + iae);
        }
        return false;
    }

    public int timeToLive() {
        try {
            return this._myMulticastSocket.getTimeToLive();
        }
        catch (IOException ioe) {
            Logger.printError("Multicast.getTimeToLive()", "" + ioe);
            return -1;
        }
    }

    public void setLoopback(boolean theFlag) {
        try {
            this._myMulticastSocket.setLoopbackMode(theFlag);
        }
        catch (SocketException se) {
            Logger.printError("Multicast.setLoopback()", "" + se);
        }
    }

    public boolean loopback() {
        try {
            return this._myMulticastSocket.getLoopbackMode();
        }
        catch (SocketException se) {
            Logger.printError("Multicast.loopback()", "" + se);
            return false;
        }
    }

    protected void send(DatagramPacket thePacket) {
        if (this.isRunning) {
            try {
                this._myMulticastSocket.send(thePacket);
            }
            catch (IOException e) {
                Logger.printError("Multicast.send", "ioexception while sending packet.");
            }
        }
    }

    public void send(String theString) {
        this.send(theString.getBytes());
    }

    public void send(byte[] theBytes) {
        if (this.isRunning) {
            try {
                DatagramPacket myPacket = new DatagramPacket(theBytes, theBytes.length, this._myNetAddress.inetaddress(), this._myNetAddress.port());
                this.send(myPacket);
            }
            catch (NullPointerException npe) {
                Logger.printError("Multicast.send", "a nullpointer exception occured." + npe);
            }
        } else {
            Logger.printWarning("Multicast.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

