// Compiled by ClojureScript 1.10.773 {}
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.utils');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__2551__2552__auto__){
if((!((p1__2551__2552__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__2551__2552__auto__.schema$core$Schema$)))){
return true;
} else {
if((!p1__2551__2552__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__2551__2552__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__2551__2552__auto__);
}
})], null));
plumbing.fnk.schema.InputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.cond_pre.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.cond_pre.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.MapOutputSchema = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,plumbing.fnk.schema.Schema]);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
 * Like (assert (distinct? things)) but with a more helpful error message.
 */
plumbing.fnk.schema.assert_distinct = (function plumbing$fnk$schema$assert_distinct(things){
var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__4247_SHARP_){
return (cljs.core.val.call(null,p1__4247_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));
if(cljs.core.empty_QMARK_.call(null,repeated_things)){
return null;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
 * Like (get m k), but throws if k is not present in m.
 */
plumbing.fnk.schema.safe_get = (function plumbing$fnk$schema$safe_get(m,k,key_path){
if(cljs.core.map_QMARK_.call(null,m)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}

var vec__4248 = cljs.core.find.call(null,m,k);
var _ = cljs.core.nth.call(null,vec__4248,(0),null);
var v = cljs.core.nth.call(null,vec__4248,(1),null);
var p = vec__4248;
if(cljs.core.truth_(p)){
} else {
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}

return v;
});
plumbing.fnk.schema.non_map_union = (function plumbing$fnk$schema$non_map_union(s1,s2){
if(cljs.core._EQ_.call(null,s1,s2)){
return s1;
} else {
if(cljs.core._EQ_.call(null,s1,schema.core.Any)){
return s2;
} else {
if(cljs.core._EQ_.call(null,s2,schema.core.Any)){
return s1;
} else {
return s1;

}
}
}
});
/**
 * Return a difference of schmas s1 and s2, where one is not a map.
 * Punt for now, assuming s2 always satisfies s1.
 */
plumbing.fnk.schema.non_map_diff = (function plumbing$fnk$schema$non_map_diff(s1,s2){
return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function plumbing$fnk$schema$map_schema_QMARK_(m){
return (((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap)));
});
var ufv___4256 = schema.utils.use_fn_validation;
var output_schema4251_4257 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));
var input_schema4252_4258 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker4253_4259 = schema.core.checker.call(null,input_schema4252_4258);
var output_checker4254_4260 = schema.core.checker.call(null,output_schema4251_4257);
/**
 * Inputs: [k]
 *   Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
 * 
 *   Given a possibly-unevaluated schema map key form, unpack an explicit keyword
 * and optional? flag, or return nil for a non-explicit key
 */
plumbing.fnk.schema.unwrap_schema_form_key = (function plumbing$fnk$schema$unwrap_schema_form_key(G__4255){
var validate__1756__auto__ = ufv___4256.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4261 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4255], null);
var temp__5735__auto___4262 = input_checker4253_4259.call(null,args__1757__auto___4261);
if(cljs.core.truth_(temp__5735__auto___4262)){
var error__1758__auto___4263 = temp__5735__auto___4262;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__1758__auto___4263)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4252_4258,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4261,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4263], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var k = G__4255;
while(true){
if(schema.core.specific_key_QMARK_.call(null,k)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else {
if(((cljs.core.sequential_QMARK_.call(null,k)) && ((!(cljs.core.vector_QMARK_.call(null,k)))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else {
return null;
}
}
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4264 = output_checker4254_4260.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4264)){
var error__1758__auto___4265 = temp__5735__auto___4264;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__1758__auto___4265)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4251_4257,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4265], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema4251_4257,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4252_4258], null)));
var ufv___4271 = schema.utils.use_fn_validation;
var output_schema4266_4272 = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,schema.core.Bool]);
var input_schema4267_4273 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker4268_4274 = schema.core.checker.call(null,input_schema4267_4273);
var output_checker4269_4275 = schema.core.checker.call(null,output_schema4266_4272);
/**
 * Inputs: [s]
 *   Returns: #:s{Keyword s/Bool}
 * 
 *   Given a possibly-unevaluated map schema, return a map from bare keyword to true
 * (for required) or false (for optional)
 */
plumbing.fnk.schema.explicit_schema_key_map = (function plumbing$fnk$schema$explicit_schema_key_map(G__4270){
var validate__1756__auto__ = ufv___4271.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4276 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4270], null);
var temp__5735__auto___4277 = input_checker4268_4274.call(null,args__1757__auto___4276);
if(cljs.core.truth_(temp__5735__auto___4277)){
var error__1758__auto___4278 = temp__5735__auto___4277;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__1758__auto___4278)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4267_4273,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4276,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4278], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var s = G__4270;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4279 = output_checker4269_4275.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4279)){
var error__1758__auto___4280 = temp__5735__auto___4279;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__1758__auto___4280)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4266_4272,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4280], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema4266_4272,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4267_4273], null)));
var ufv___4286 = schema.utils.use_fn_validation;
var output_schema4281_4287 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
var input_schema4282_4288 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,schema.core.Bool]),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)], null)))], null);
var input_checker4283_4289 = schema.core.checker.call(null,input_schema4282_4288);
var output_checker4284_4290 = schema.core.checker.call(null,output_schema4281_4287);
/**
 * Inputs: [s :- #:s{Keyword s/Bool}]
 *   Returns: [(s/one [s/Keyword] (quote required)) (s/one [s/Keyword] (quote optional))]
 * 
 *   Given output of explicit-schema-key-map, split into seq [req opt].
 */
plumbing.fnk.schema.split_schema_keys = (function plumbing$fnk$schema$split_schema_keys(G__4285){
var validate__1756__auto__ = ufv___4286.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4291 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4285], null);
var temp__5735__auto___4292 = input_checker4283_4289.call(null,args__1757__auto___4291);
if(cljs.core.truth_(temp__5735__auto___4292)){
var error__1758__auto___4293 = temp__5735__auto___4292;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__1758__auto___4293)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4282_4288,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4291,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4293], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var s = G__4285;
while(true){
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4294 = output_checker4284_4290.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4294)){
var error__1758__auto___4295 = temp__5735__auto___4294;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__1758__auto___4295)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4281_4287,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4295], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema4281_4287,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4282_4288], null)));
/**
 * Like merge-with, but also projects keys to a smaller space and merges them similar to the
 * values.
 */
plumbing.fnk.schema.merge_on_with = (function plumbing$fnk$schema$merge_on_with(var_args){
var args__4742__auto__ = [];
var len__4736__auto___4307 = arguments.length;
var i__4737__auto___4308 = (0);
while(true){
if((i__4737__auto___4308 < len__4736__auto___4307)){
args__4742__auto__.push((arguments[i__4737__auto___4308]));

var G__4309 = (i__4737__auto___4308 + (1));
i__4737__auto___4308 = G__4309;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic = (function (key_project,key_combine,val_combine,maps){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__4300){
var vec__4301 = p__4300;
var k = cljs.core.nth.call(null,vec__4301,(0),null);
var v = cljs.core.nth.call(null,vec__4301,(1),null);
var pk = key_project.call(null,k);
var temp__5733__auto__ = cljs.core.get.call(null,m,pk);
if(cljs.core.truth_(temp__5733__auto__)){
var vec__4304 = temp__5733__auto__;
var ok = cljs.core.nth.call(null,vec__4304,(0),null);
var ov = cljs.core.nth.call(null,vec__4304,(1),null);
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else {
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
}));

(plumbing.fnk.schema.merge_on_with.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(plumbing.fnk.schema.merge_on_with.cljs$lang$applyTo = (function (seq4296){
var G__4297 = cljs.core.first.call(null,seq4296);
var seq4296__$1 = cljs.core.next.call(null,seq4296);
var G__4298 = cljs.core.first.call(null,seq4296__$1);
var seq4296__$2 = cljs.core.next.call(null,seq4296__$1);
var G__4299 = cljs.core.first.call(null,seq4296__$2);
var seq4296__$3 = cljs.core.next.call(null,seq4296__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4297,G__4298,G__4299,seq4296__$3);
}));

var ufv___4317 = schema.utils.use_fn_validation;
var output_schema4311_4318 = plumbing.fnk.schema.InputSchema;
var input_schema4312_4319 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i1","i1",-572470430,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i2","i2",850408895,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker4313_4320 = schema.core.checker.call(null,input_schema4312_4319);
var output_checker4314_4321 = schema.core.checker.call(null,output_schema4311_4318);
/**
 * Inputs: [i1 :- InputSchema i2 :- InputSchema]
 *   Returns: InputSchema
 * 
 *   Returns a minimal input schema schema that entails satisfaction of both s1 and s2
 */
plumbing.fnk.schema.union_input_schemata = (function plumbing$fnk$schema$union_input_schemata(G__4315,G__4316){
var validate__1756__auto__ = ufv___4317.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4322 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4315,G__4316], null);
var temp__5735__auto___4323 = input_checker4313_4320.call(null,args__1757__auto___4322);
if(cljs.core.truth_(temp__5735__auto___4323)){
var error__1758__auto___4324 = temp__5735__auto___4323;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__1758__auto___4324)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4312_4319,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4322,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4324], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var i1 = G__4315;
var i2 = G__4316;
while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321){
return (function (p1__4310_SHARP_){
if(schema.core.specific_key_QMARK_.call(null,p1__4310_SHARP_)){
return schema.core.explicit_schema_key.call(null,p1__4310_SHARP_);
} else {
return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321))
,((function (validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321){
return (function (k1,k2){
if(schema.core.required_key_QMARK_.call(null,k1)){
return k1;
} else {
if(schema.core.required_key_QMARK_.call(null,k2)){
return k2;
} else {
if(schema.core.optional_key_QMARK_.call(null,k1)){
if(cljs.core._EQ_.call(null,k1,k2)){
} else {
throw (new Error("Assert failed: (= k1 k2)"));
}

return k1;
} else {
if(cljs.core._EQ_.call(null,k1,k2)){
return k1;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));


}
}
}
}
});})(validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321))
,((function (validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321){
return (function (s1,s2){
if(((plumbing.fnk.schema.map_schema_QMARK_.call(null,s1)) && (plumbing.fnk.schema.map_schema_QMARK_.call(null,s2)))){
return plumbing.fnk.schema.union_input_schemata.call(null,s1,s2);
} else {
return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__1756__auto__,ufv___4317,output_schema4311_4318,input_schema4312_4319,input_checker4313_4320,output_checker4314_4321))
,i1,i2);
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4325 = output_checker4314_4321.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4325)){
var error__1758__auto___4326 = temp__5735__auto___4325;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__1758__auto___4326)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4311_4318,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4326], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema4311_4318,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4312_4319], null)));
var ufv___4332 = schema.utils.use_fn_validation;
var output_schema4327_4333 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema4328_4334 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker4329_4335 = schema.core.checker.call(null,input_schema4328_4334);
var output_checker4330_4336 = schema.core.checker.call(null,output_schema4327_4333);
/**
 * Inputs: [input-schema :- InputSchema]
 *   Returns: [s/Keyword]
 * 
 *   Which top-level keys are required (i.e., non-false) by this input schema.
 */
plumbing.fnk.schema.required_toplevel_keys = (function plumbing$fnk$schema$required_toplevel_keys(G__4331){
var validate__1756__auto__ = ufv___4332.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4337 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4331], null);
var temp__5735__auto___4338 = input_checker4329_4335.call(null,args__1757__auto___4337);
if(cljs.core.truth_(temp__5735__auto___4338)){
var error__1758__auto___4339 = temp__5735__auto___4338;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__1758__auto___4339)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4328_4334,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4337,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4339], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var input_schema = G__4331;
while(true){
return cljs.core.keep.call(null,((function (validate__1756__auto__,ufv___4332,output_schema4327_4333,input_schema4328_4334,input_checker4329_4335,output_checker4330_4336){
return (function (k){
if(schema.core.required_key_QMARK_.call(null,k)){
return schema.core.explicit_schema_key.call(null,k);
} else {
return null;
}
});})(validate__1756__auto__,ufv___4332,output_schema4327_4333,input_schema4328_4334,input_checker4329_4335,output_checker4330_4336))
,cljs.core.keys.call(null,input_schema));
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4340 = output_checker4330_4336.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4340)){
var error__1758__auto___4341 = temp__5735__auto___4340;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__1758__auto___4341)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4327_4333,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4341], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema4327_4333,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4328_4334], null)));
/**
 * Guess an output schema for an expr.  Currently just looks for literal map structure and
 * all keyword keys.
 */
plumbing.fnk.schema.guess_expr_output_schema = (function plumbing$fnk$schema$guess_expr_output_schema(expr){
if(((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr))))){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4529__auto__ = (function plumbing$fnk$schema$guess_expr_output_schema_$_iter__4342(s__4343){
return (new cljs.core.LazySeq(null,(function (){
var s__4343__$1 = s__4343;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__4343__$1);
if(temp__5735__auto__){
var s__4343__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4343__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__4343__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__4345 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__4344 = (0);
while(true){
if((i__4344 < size__4528__auto__)){
var vec__4346 = cljs.core._nth.call(null,c__4527__auto__,i__4344);
var k = cljs.core.nth.call(null,vec__4346,(0),null);
var v = cljs.core.nth.call(null,vec__4346,(1),null);
cljs.core.chunk_append.call(null,b__4345,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null));

var G__4352 = (i__4344 + (1));
i__4344 = G__4352;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4345),plumbing$fnk$schema$guess_expr_output_schema_$_iter__4342.call(null,cljs.core.chunk_rest.call(null,s__4343__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4345),null);
}
} else {
var vec__4349 = cljs.core.first.call(null,s__4343__$2);
var k = cljs.core.nth.call(null,vec__4349,(0),null);
var v = cljs.core.nth.call(null,vec__4349,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null),plumbing$fnk$schema$guess_expr_output_schema_$_iter__4342.call(null,cljs.core.rest.call(null,s__4343__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,expr);
})());
} else {
return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
 * Subtract output-schema from input-schema, returning nil if it's possible that an object
 * satisfying the output-schema satisfies the input-schema, or otherwise a description
 * of the part(s) of input-schema not met by output-schema.  Strict about the map structure
 * of output-schema matching input-schema, but loose about everything else (only looks at
 * required keys of output-schema.
 */
plumbing.fnk.schema.schema_diff = (function plumbing$fnk$schema$schema_diff(input_schema,output_schema){
if((!(plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema)))){
return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else {
if((!(plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema)))){
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){
return (new cljs.core.List(null,new cljs.core.Symbol(null,"map?","map?",-1780568534,null),(new cljs.core.List(null,schema.core.explain.call(null,output_schema),null,(1),null)),(2),null));
}),null)),null));
} else {
return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4529__auto__ = (function plumbing$fnk$schema$schema_diff_$_iter__4353(s__4354){
return (new cljs.core.LazySeq(null,(function (){
var s__4354__$1 = s__4354;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__4354__$1);
if(temp__5735__auto__){
var s__4354__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4354__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__4354__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__4356 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__4355 = (0);
while(true){
if((i__4355 < size__4528__auto__)){
var vec__4357 = cljs.core._nth.call(null,c__4527__auto__,i__4355);
var k = cljs.core.nth.call(null,vec__4357,(0),null);
var v = cljs.core.nth.call(null,vec__4357,(1),null);
if(schema.core.specific_key_QMARK_.call(null,k)){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(((required_QMARK_) || (present_QMARK_))){
var fail = (((!(present_QMARK_)))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
cljs.core.chunk_append.call(null,b__4356,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));

var G__4363 = (i__4355 + (1));
i__4355 = G__4363;
continue;
} else {
var G__4364 = (i__4355 + (1));
i__4355 = G__4364;
continue;
}
} else {
var G__4365 = (i__4355 + (1));
i__4355 = G__4365;
continue;
}
} else {
var G__4366 = (i__4355 + (1));
i__4355 = G__4366;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4356),plumbing$fnk$schema$schema_diff_$_iter__4353.call(null,cljs.core.chunk_rest.call(null,s__4354__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4356),null);
}
} else {
var vec__4360 = cljs.core.first.call(null,s__4354__$2);
var k = cljs.core.nth.call(null,vec__4360,(0),null);
var v = cljs.core.nth.call(null,vec__4360,(1),null);
if(schema.core.specific_key_QMARK_.call(null,k)){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(((required_QMARK_) || (present_QMARK_))){
var fail = (((!(present_QMARK_)))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),plumbing$fnk$schema$schema_diff_$_iter__4353.call(null,cljs.core.rest.call(null,s__4354__$2)));
} else {
var G__4367 = cljs.core.rest.call(null,s__4354__$2);
s__4354__$1 = G__4367;
continue;
}
} else {
var G__4368 = cljs.core.rest.call(null,s__4354__$2);
s__4354__$1 = G__4368;
continue;
}
} else {
var G__4369 = cljs.core.rest.call(null,s__4354__$2);
s__4354__$1 = G__4369;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,input_schema);
})()));

}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function plumbing$fnk$schema$assert_satisfies_schema(input_schema,output_schema){
var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);
if(cljs.core.truth_(fails)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fails),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else {
return null;
}
});
var ufv___4396 = schema.utils.use_fn_validation;
var output_schema4370_4397 = schema.core.Any;
var input_schema4371_4398 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker4372_4399 = schema.core.checker.call(null,input_schema4371_4398);
var output_checker4373_4400 = schema.core.checker.call(null,output_schema4370_4397);
/**
 * Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2,
 * return a pair of input and output schemata for #(f2 (merge % (f1 %))).
 * f1's output schema must not contain any optional keys.
 */
plumbing.fnk.schema.compose_schemata = (function plumbing$fnk$schema$compose_schemata(G__4374,G__4375){
var validate__1756__auto__ = true;
if(validate__1756__auto__){
var args__1757__auto___4401 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4374,G__4375], null);
var temp__5735__auto___4402 = input_checker4372_4399.call(null,args__1757__auto___4401);
if(cljs.core.truth_(temp__5735__auto___4402)){
var error__1758__auto___4403 = temp__5735__auto___4402;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__1758__auto___4403)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4371_4398,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4401,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4403], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var G__4382 = G__4374;
var vec__4384 = G__4382;
var i2 = cljs.core.nth.call(null,vec__4384,(0),null);
var o2 = cljs.core.nth.call(null,vec__4384,(1),null);
var G__4383 = G__4375;
var vec__4387 = G__4383;
var i1 = cljs.core.nth.call(null,vec__4387,(0),null);
var o1 = cljs.core.nth.call(null,vec__4387,(1),null);
var G__4382__$1 = G__4382;
var G__4383__$1 = G__4383;
while(true){
var vec__4390 = G__4382__$1;
var i2__$1 = cljs.core.nth.call(null,vec__4390,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__4390,(1),null);
var vec__4393 = G__4383__$1;
var i1__$1 = cljs.core.nth.call(null,vec__4393,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__4393,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();
if(validate__1756__auto__){
var temp__5735__auto___4404 = output_checker4373_4400.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4404)){
var error__1758__auto___4405 = temp__5735__auto___4404;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__1758__auto___4405)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4370_4397,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4405], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema4370_4397,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4371_4398], null)));
plumbing.fnk.schema.schema_key = (function plumbing$fnk$schema$schema_key(m,k){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return k;
} else {
if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k))){
return schema.core.optional_key.call(null,k);
} else {
return null;

}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function plumbing$fnk$schema$possibly_contains_QMARK_(m,k){
return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___4436 = schema.utils.use_fn_validation;
var output_schema4406_4437 = schema.core.Any;
var input_schema4407_4438 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"ks","ks",-754231827,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker4408_4439 = schema.core.checker.call(null,input_schema4407_4438);
var output_checker4409_4440 = schema.core.checker.call(null,output_schema4406_4437);
/**
 * Inputs: [s :- InputSchema ks :- [s/Keyword]]
 * 
 *   Return a pair [ks-part non-ks-part], with any extra schema removed.
 */
plumbing.fnk.schema.split_schema = (function plumbing$fnk$schema$split_schema(G__4410,G__4411){
var validate__1756__auto__ = ufv___4436.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4441 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4410,G__4411], null);
var temp__5735__auto___4442 = input_checker4408_4439.call(null,args__1757__auto___4441);
if(cljs.core.truth_(temp__5735__auto___4442)){
var error__1758__auto___4443 = temp__5735__auto___4442;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__1758__auto___4443)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4407_4438,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4441,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4443], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var s = G__4410;
var ks = G__4411;
while(true){
var ks__$1 = cljs.core.set.call(null,ks);
var iter__4529__auto__ = ((function (ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440){
return (function plumbing$fnk$schema$split_schema_$_iter__4412(s__4413){
return (new cljs.core.LazySeq(null,(function (){
var s__4413__$1 = s__4413;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__4413__$1);
if(temp__5735__auto__){
var s__4413__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4413__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__4413__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__4415 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__4414 = (0);
while(true){
if((i__4414 < size__4528__auto__)){
var in_QMARK_ = cljs.core._nth.call(null,c__4527__auto__,i__4414);
cljs.core.chunk_append.call(null,b__4415,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4529__auto__ = ((function (i__4414,in_QMARK_,c__4527__auto__,size__4528__auto__,b__4415,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440){
return (function plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4416(s__4417){
return (new cljs.core.LazySeq(null,((function (i__4414,in_QMARK_,c__4527__auto__,size__4528__auto__,b__4415,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440){
return (function (){
var s__4417__$1 = s__4417;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__4417__$1);
if(temp__5735__auto____$1){
var s__4417__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4417__$2)){
var c__4527__auto____$1 = cljs.core.chunk_first.call(null,s__4417__$2);
var size__4528__auto____$1 = cljs.core.count.call(null,c__4527__auto____$1);
var b__4419 = cljs.core.chunk_buffer.call(null,size__4528__auto____$1);
if((function (){var i__4418 = (0);
while(true){
if((i__4418 < size__4528__auto____$1)){
var vec__4420 = cljs.core._nth.call(null,c__4527__auto____$1,i__4418);
var k = cljs.core.nth.call(null,vec__4420,(0),null);
var v = cljs.core.nth.call(null,vec__4420,(1),null);
if(((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))){
cljs.core.chunk_append.call(null,b__4419,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__4444 = (i__4418 + (1));
i__4418 = G__4444;
continue;
} else {
var G__4445 = (i__4418 + (1));
i__4418 = G__4445;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4419),plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4416.call(null,cljs.core.chunk_rest.call(null,s__4417__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4419),null);
}
} else {
var vec__4423 = cljs.core.first.call(null,s__4417__$2);
var k = cljs.core.nth.call(null,vec__4423,(0),null);
var v = cljs.core.nth.call(null,vec__4423,(1),null);
if(((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4416.call(null,cljs.core.rest.call(null,s__4417__$2)));
} else {
var G__4446 = cljs.core.rest.call(null,s__4417__$2);
s__4417__$1 = G__4446;
continue;
}
}
} else {
return null;
}
break;
}
});})(i__4414,in_QMARK_,c__4527__auto__,size__4528__auto__,b__4415,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440))
,null,null));
});})(i__4414,in_QMARK_,c__4527__auto__,size__4528__auto__,b__4415,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440))
;
return iter__4529__auto__.call(null,s);
})()));

var G__4447 = (i__4414 + (1));
i__4414 = G__4447;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4415),plumbing$fnk$schema$split_schema_$_iter__4412.call(null,cljs.core.chunk_rest.call(null,s__4413__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4415),null);
}
} else {
var in_QMARK_ = cljs.core.first.call(null,s__4413__$2);
return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4529__auto__ = ((function (in_QMARK_,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440){
return (function plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4426(s__4427){
return (new cljs.core.LazySeq(null,(function (){
var s__4427__$1 = s__4427;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__4427__$1);
if(temp__5735__auto____$1){
var s__4427__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4427__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__4427__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__4429 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__4428 = (0);
while(true){
if((i__4428 < size__4528__auto__)){
var vec__4430 = cljs.core._nth.call(null,c__4527__auto__,i__4428);
var k = cljs.core.nth.call(null,vec__4430,(0),null);
var v = cljs.core.nth.call(null,vec__4430,(1),null);
if(((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))){
cljs.core.chunk_append.call(null,b__4429,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__4448 = (i__4428 + (1));
i__4428 = G__4448;
continue;
} else {
var G__4449 = (i__4428 + (1));
i__4428 = G__4449;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4429),plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4426.call(null,cljs.core.chunk_rest.call(null,s__4427__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4429),null);
}
} else {
var vec__4433 = cljs.core.first.call(null,s__4427__$2);
var k = cljs.core.nth.call(null,vec__4433,(0),null);
var v = cljs.core.nth.call(null,vec__4433,(1),null);
if(((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__4412_$_iter__4426.call(null,cljs.core.rest.call(null,s__4427__$2)));
} else {
var G__4450 = cljs.core.rest.call(null,s__4427__$2);
s__4427__$1 = G__4450;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});})(in_QMARK_,s__4413__$2,temp__5735__auto__,ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440))
;
return iter__4529__auto__.call(null,s);
})()),plumbing$fnk$schema$split_schema_$_iter__4412.call(null,cljs.core.rest.call(null,s__4413__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});})(ks__$1,validate__1756__auto__,ufv___4436,output_schema4406_4437,input_schema4407_4438,input_checker4408_4439,output_checker4409_4440))
;
return iter__4529__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4451 = output_checker4409_4440.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4451)){
var error__1758__auto___4452 = temp__5735__auto___4451;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__1758__auto___4452)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4406_4437,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4452], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema4406_4437,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4407_4438], null)));
var ufv___4491 = schema.utils.use_fn_validation;
var output_schema4453_4492 = plumbing.fnk.schema.GraphIOSchemata;
var input_schema4454_4493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker4455_4494 = schema.core.checker.call(null,input_schema4454_4493);
var output_checker4456_4495 = schema.core.checker.call(null,output_schema4453_4492);
/**
 * Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
 *   Returns: GraphIOSchemata
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
 * return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
 */
plumbing.fnk.schema.sequence_schemata = (function plumbing$fnk$schema$sequence_schemata(G__4457,G__4458){
var validate__1756__auto__ = ufv___4491.get_cell();
if(cljs.core.truth_(validate__1756__auto__)){
var args__1757__auto___4496 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__4457,G__4458], null);
var temp__5735__auto___4497 = input_checker4455_4494.call(null,args__1757__auto___4496);
if(cljs.core.truth_(temp__5735__auto___4497)){
var error__1758__auto___4498 = temp__5735__auto___4497;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__1758__auto___4498)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema4454_4493,new cljs.core.Keyword(null,"value","value",305978217),args__1757__auto___4496,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4498], null));
} else {
}
} else {
}

var o__1759__auto__ = (function (){var G__4468 = G__4457;
var vec__4470 = G__4468;
var i1 = cljs.core.nth.call(null,vec__4470,(0),null);
var o1 = cljs.core.nth.call(null,vec__4470,(1),null);
var G__4469 = G__4458;
var vec__4473 = G__4469;
var k = cljs.core.nth.call(null,vec__4473,(0),null);
var vec__4476 = cljs.core.nth.call(null,vec__4473,(1),null);
var i2 = cljs.core.nth.call(null,vec__4476,(0),null);
var o2 = cljs.core.nth.call(null,vec__4476,(1),null);
var G__4468__$1 = G__4468;
var G__4469__$1 = G__4469;
while(true){
var vec__4479 = G__4468__$1;
var i1__$1 = cljs.core.nth.call(null,vec__4479,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__4479,(1),null);
var vec__4482 = G__4469__$1;
var k__$1 = cljs.core.nth.call(null,vec__4482,(0),null);
var vec__4485 = cljs.core.nth.call(null,vec__4482,(1),null);
var i2__$1 = cljs.core.nth.call(null,vec__4485,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__4485,(1),null);
if((!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}

if((!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}

if((!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}

var vec__4488 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));
var used = cljs.core.nth.call(null,vec__4488,(0),null);
var unused = cljs.core.nth.call(null,vec__4488,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();
if(cljs.core.truth_(validate__1756__auto__)){
var temp__5735__auto___4499 = output_checker4456_4495.call(null,o__1759__auto__);
if(cljs.core.truth_(temp__5735__auto___4499)){
var error__1758__auto___4500 = temp__5735__auto___4499;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__1758__auto___4500)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema4453_4492,new cljs.core.Keyword(null,"value","value",305978217),o__1759__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__1758__auto___4500], null));
} else {
}
} else {
}

return o__1759__auto__;
});

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema4453_4492,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema4454_4493], null)));

//# sourceMappingURL=schema.js.map?rel=1598625890237
