(ns de.phenomdevel.formalicious.util.log
  (:require
   [cljs.pprint :as pprint]
   [clojure.string :as str]))


;; =============================================================================
;; Logging Helper

(def ^:private verbose?
  true)

(def ^:private pprint?
  true)

(defn- log
  [level msgs]
  (let [msgs*
        (if pprint?
          (map #(with-out-str (pprint/pprint %)) msgs)
          (pr-str msgs))

        f
        (case level
          :DEBUG js/console.debug
          :INFO js/console.info
          :WARN js/console.warn
          :ERROR js/console.error
          js/console.debug)]

    (when js/console
      (f (str/join " " msgs*)))))


;; =============================================================================
;; Public API

(defn info
  "Logs on js/console with level `info`."
  [& msgs]
  (log :INFO msgs))

(defn warn
  "Logs on js/console with level `warn`."
  [& msgs]
  (log :WARN msgs))

(defn error
  "Logs on js/console with level `error`."
  [& msgs]
  (log :ERROR msgs))

(defn debug
  "Logs on js/console with level `debug`."
  [& msgs]
  (log :DEBUG msgs))

(defn debug+
  "Logs on js/console with level `debug`.
  Logs will be grouped under title for better reading and usability."
  [title & msgs]
  (js/console.groupCollapsed title)
  (log :DEBUG msgs)
  (js/console.groupEnd))

(defn render
  [id]
  (debug (str "formalicious__render__" (name id))))

(defn will-unmount
  [id]
  (debug (str "formalicious__will__unmount__" (name id))))

(defn did-mount
  [id]
  (debug (str "formalicious__did__mount__" (name id))))
