(ns de.phenomdevel.formalicious.form.text
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]
   [de.phenomdevel.formalicious.util :as u]))


;; =============================================================================
;; Private Helper

(defn- -render
  [field-spec value]
  (letk [[id
          {class nil}
          {data-path nil}
          {on-change nil}
          {value-transform identity}
          {validations nil}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (h/with-on-change on-change value-transform data-path))]

    (fn [field-spec value]
      (let [validation-messages
            (h/validate validations value)

            attrs
            (-> base-attrs
                (h/with-value value)
                (h/with-disabled (:disabled field-spec)))

            input
            (cond-> [:input.pd__input.pd__input--text attrs]
              (not-empty validation-messages)
              (assoc-in [1 :class] "has-error"))

            input-field
            (cond-> (-> {:class class}
                        (h/with-input-field-wrapper)
                        (h/with-contents input)
                        (h/with-label field-spec))
              (:hint field-spec)
              (h/with-hint (:hint field-spec)))]

        (cond-> input-field
          (not-empty validation-messages)
          (h/with-validation validation-messages))))))


;; =============================================================================
;; Public API

(defn render
  [field-spec value]
  (letk [[{render-fn -render}]
         field-spec]

    [render-fn field-spec value]))
