(ns de.phenomdevel.formalicious.form.range
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{class nil}
          {data-path nil}
          {on-change nil}
          {value-transform identity}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (assoc :type :range)
             (h/with-on-change on-change value-transform data-path))]

    (fn [field-spec value]
      (letk [[{disabled false}]
             field-spec

             attrs
             (-> base-attrs
                 (h/with-value value)
                 (h/with-disabled disabled))]

        (-> {:class class}
            (h/with-input-field-wrapper)
            (h/with-label field-spec)
            (h/with-contents [:input attrs]))))))
