(ns de.phenomdevel.formalicious.form.checkbox
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{class ""}
          {data-path nil}]
         field-spec

         base-attrs
         (assoc
          (shared/field-spec->attrs field-spec)
          :on-change
          (h/checked-on-change-handler data-path))]

    (fn [field-spec value]
      (letk [[{disabled false}]
             field-spec

             attrs
             (-> base-attrs
                 (h/with-value value)
                 (h/with-disabled disabled))]

        (-> {:class class}
            (h/with-input-field-wrapper)
            (h/with-contents [:input.pd__checkbox attrs])
            (h/with-label field-spec))))))
