(ns de.phenomdevel.formalicious.form
  "Provides a generic input-field render function which will
  render an input-field based on the given field-spec."
  (:require
   [cljs.pprint :as pprint]
   [plumbing.core :refer-macros [letk]]
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.util.log :as log]
   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.dynamic :as dyn]
   [de.phenomdevel.formalicious.form.shared :as shared]
   [de.phenomdevel.formalicious.util.dom.element :as element]

   [de.phenomdevel.formalicious.form.text :as text]
   [de.phenomdevel.formalicious.form.date :as date]
   [de.phenomdevel.formalicious.form.range :as range]
   [de.phenomdevel.formalicious.form.table :as table]
   [de.phenomdevel.formalicious.form.button :as button]
   [de.phenomdevel.formalicious.form.select :as select]
   [de.phenomdevel.formalicious.form.password :as password]
   [de.phenomdevel.formalicious.form.textarea :as textarea]
   [de.phenomdevel.formalicious.form.checkbox :as checkbox]
   [de.phenomdevel.formalicious.form.paragraph :as paragraph]
   [de.phenomdevel.formalicious.form.radiogroup :as radiogroup]
   [de.phenomdevel.formalicious.form.radiobutton :as radiobutton]
   [de.phenomdevel.formalicious.form.multiselect :as multiselect]))


;; =============================================================================
;; Public API

(defn render-field
  "Renders a `input-field` based on the given `field-spec` with the given value."
  [field-spec value]
  (let [render-fn
        (case (:type field-spec)
          :text text/render
          :date date/render
          :table table/render
          :range range/render
          :select select/render
          :button button/render
          :password password/render
          :textarea textarea/render
          :checkbox checkbox/render
          :paragraph paragraph/render
          :radiogroup radiogroup/render
          :multiselect multiselect/render
          :radiobutton radiobutton/render
          nil)]

    (fn [field-spec value]
      (shared/print-render-fn-infos field-spec value)

      (if (nil? render-fn)
        [:div "`field-spec` is not valid."
         [:pre (with-out-str (pprint/pprint field-spec))]]
        [render-fn field-spec value]))))
