(ns example.views.form-two
  (:require
   [clojure.string :as str]
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.core :as form]
   [de.phenomdevel.formalicious.validations :as validations]

   [example.views.state :as state]))


;; =============================================================================
;; Helper

(def form-spec
  {:data-root
   [:form/data :two]

   :fields
   [{:id :type
     :type :select
     :options [{:id :single :label "Single"}
               {:id :named :label "Named"}
               {:id :concurrent :label "Concurrent"}
               {:id :named-concurrent :label "Floating"}]
     :label "Typ"
     :class "mui-select mui-col-xs-3"}


    {:id  :order-nr
     :type :text
     :label "Auftrag"
     :validations
     [[validations/not-empty? "darf nicht leer sein"]]
     :class "mui-textfield mui-col-xs-3"
     :placeholder "Auftragsnummer"}

    {:id :quantity
     :type :text
     :label "Anzahl Benutzer"
     :validations
     {:multiple? false
      :checks
      [[validations/not-empty? "darf nicht leer sein"]
       [validations/is-number? "es muss eine Zahl angegeben werden"]]}
     :class "mui-textfield mui-col-xs-6"}

    {:id :quantity-concurrent
     :type :text
     :label "Anzahl gleichzeitiger Zugriffe"
     :validations
     {:multiple? true
      :checks
      [[validations/not-empty? "darf nicht leer sein"]
       [validations/is-number? "es muss eine Zahl angegeben werden"]]}
     :class "mui-textfield mui-col-xs-6"}

    {:id :output
     :type :paragraph
     :data-path [:form/data :two :order-nr]
     :label "Output"
     :render-fn
     (fn [{:keys [class]} value]
       [:p {:class class} "Custom `render-fn`: " value])
     :class "mui-textfield mui-col-xs-12"}]})


;; =============================================================================
;; Public API

(defn render
  []
  (let [!form-data
        (subscribe [:state/get-at (:data-root form-spec)])]

    [:div.form-two.mui-panel.mui-row
     [:h2 "Example Form Two"]
     [:div
      "Form-Data-Path " (pr-str (:data-root form-spec))
      [state/render @!form-data]]
     [form/render-form form-spec]]))
