(ns example.subscription
  (:require
   [re-frame.core :refer [reg-sub]]))


;; =============================================================================
;; Common Subscriptions

(reg-sub :form-data
  (fn [db [_ k]]
    (get-in db [:form-data])))

(reg-sub :form/data
  (fn [db [_ k]]
    (get-in db [:form-data])))

(reg-sub :route/current
  (fn [db _]
    (:route/current db)))

(reg-sub :form-data/input
  (fn [db _]
    (get-in db [:form-data :input])))

(reg-sub :table/state
  (fn [db _]
    (:table-state db)))

(reg-sub :example
  (fn [db [_ k]]
    (get-in db [:example k] {})))
