(ns de.phenomdevel.formalicious.util.dom.element
  "Provides utilities for dom elements.")


;; =============================================================================
;; Dom Element Helper

(defn value
  "Returns the `value` for `:value` attribute of given element."
  [e]
  (-> e
      (.-target)
      (.-value)))

(defn checked?
  "Returns true if `:checked` attribute of given element is set. False otherwise."
  [e]
  (-> e
      (.-target)
      (.-checked)))

(defn options
  "Returns selected options of given element."
  [e]
  (->> e
       (.-target)
       (.-options)
       (array-seq)
       (filter #(.-selected %))
       (mapv #(.-value %))))
