(ns de.phenomdevel.formalicious.util
  "Provides a lot of basic utilities.")


;; =============================================================================
;; Helper

(defn collify
  "Returns given element if it's a collection. Vector containing element otherwise."
  [v]
  (if (coll? v)
    v
    [v]))

(defn idify
  "Assocs `:id` on given `field-spec` if key is missing."
  [[k field-spec]]
  (if (:id field-spec)
    field-spec
    (assoc field-spec :id k)))

(defn to-data-path
  "Takes initial vector and items. Returns vector where items are conjed into the initial vector."
  [v & xs]
  (reduce
   into
   (collify v)
   (map collify xs)))
