(ns de.phenomdevel.formalicious.form.radiogroup
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]

   [de.phenomdevel.formalicious.form.select :as select]
   [de.phenomdevel.formalicious.form.radiobutton :as radiobutton]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{id ""}
          {class ""}
          {order-by :id}
          {data-path nil}
          {option-label :label}
          {value-transform identity}
          {option-value-key :id}]
         field-spec

         on-change
         (h/value-on-change-handler value-transform data-path)

         attrs
         (shared/field-spec->attrs field-spec)]

    (fn [field-spec value]
      (let [options
            (->> field-spec
                 (select/field-spec->options)
                 (map h/ensure-id)
                 (sort-by order-by))

            radiogroup-field
            [:div.radiogroup
             (for [option options]
               (letk [[{id ""}]
                      option

                      f-spec
                      (assoc option
                             :checked? (= (name id) value)
                             :type :radiobutton
                             :data-path data-path)]
                 ^{:key id}
                 [radiobutton/render f-spec nil]))]]

        (-> {:class class}
            (h/with-input-field-wrapper)
            (h/with-label field-spec)
            (h/with-contents radiogroup-field))))))
