(ns de.phenomdevel.formalicious.core
  (:require
   [com.stuartsierra.component :as c]

   [de.phenomdevel.formalicious.components.app :as app]
   [de.phenomdevel.formalicious.components.server :as server]
   [de.phenomdevel.formalicious.components.scheduler :as scheduler])

  (:import
   [clojure.lang ExceptionInfo])

  (:gen-class))


;; =============================================================================
;; System

(defn new-system
  [config]
  (c/system-map

    :app
    (c/using
     (app/new-app (:app config))
     [])

    :server
    (c/using
     (server/new-server (:server config))
     [:app])

    ;;:scheduler
    #_(c/using
     (scheduler/new-scheduler (:scheduler config))
     [])

    ,,,))


;; =============================================================================
;; Main

(defn shutdown-hook
  [sys]
  (Thread. (fn []
             (println "\nReceived term signal, shutting down...")
             (c/stop sys))))

;; TODO: Read config from file
(def config
  {:server
   {:port 1338}

   :scheduler
   {:interval 1000}

   ,,,})


(defn -main
  [& args]
  (try
    (let [system
          (c/start (new-system config))]

      (.addShutdownHook (Runtime/getRuntime) (shutdown-hook system)))

    (catch ExceptionInfo e
      (let [system
            (-> e
                (.getData)
                :system)

            err-comp
            (-> e
                (.getData)
                :component)]

        (-> e
            (.getCause)
            (.printStackTrace))
        (println "Error in component" err-comp "\nTerminating application")
        (c/stop system)
        (System/exit 1)))))
