(ns de.phenomdevel.formalicious.components.app.handler
  (:require
   [plumbing.core :refer [letk]]
   [compojure.route :as route]
   [compojure.core :as cp :refer [GET POST context]]

   [ring.middleware.params :as ring-mw-params]
   [ring.middleware.defaults :as ring-defaults]
   [ring.middleware.transit :as transit]

   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.view.app :as app]
   [de.phenomdevel.formalicious.view.error :as error]

   [de.phenomdevel.formalicious.service :as service]))


;; =============================================================================
;; Common Routes

(defn transit-response
  [body]
  {:status 200
   :body body
   :headers {"Content-Type" "application/transit+json;charset=utf-8"}})

(defn- new-routes
  []
  (cp/routes
    (route/resources "/")

    (GET "/app" req
      (app/view))

    (POST "/service" request
      (-> request
          :body
          (service/service)
          (transit-response)))

    (route/not-found (error/render))))


;; =============================================================================
;; Public API

(def ^:private ring-defaults
  (assoc-in ring-defaults/site-defaults [:security :anti-forgery] false))

(defn new-handler
  []
  (-> (new-routes)
      (ring-defaults/wrap-defaults ring-defaults)
      (transit/wrap-transit-body)
      (transit/wrap-transit-response)))
