(defproject de.phenomdevel/formalicious "0.2.0-SNAPSHOT"
  :description
  "Generic form rendering library made for re-frame."

  :url
  "https://github.com/PhenomDevel/formalicious"

  :license
  {:name
   "Eclipse Public License"

   :url
   "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies
  [[org.clojure/clojure "1.10.1"]
   [org.clojure/clojurescript "1.10.773"]

   [medley "1.3.0"]
   [com.stuartsierra/component "0.3.2"]

   [hiccup "1.0.5"]
   [cljs-http "0.1.44"]
   [com.taoensso/timbre "4.10.0"]
   [http-kit "2.2.0"]
   [ring "1.6.3"]
   [ring/ring-defaults "0.3.1"]
   [compojure "1.6.0"]
   [ring-transit "0.1.6"]
   [hiccup "1.0.5"]

   [re-frame "0.12.0"]
   [reagent "0.10.0"]

   ;; DB
   [org.clojure/java.jdbc "0.7.5"]]

  :source-paths
  ["src/clj" "src/cljs"]

  :plugins
  [[lein-cljsbuild "1.1.7"]
   [lein-figwheel "0.5.16"]
   [lein-sass "0.5.0"]]

  :sass
  {:src "src/sass"
   :command :sassc
   :output-dir "resources/public/css"}

  :profiles
  {:dev
   {:source-paths
    ["dev"]

    :dependencies
    [[figwheel-sidecar "0.5.17"
      :exclusions [org.clojure/tools.nrepl]]
     [cider/piggieback "0.4.1"]
     [org.clojure/tools.namespace "0.2.10"]]}

   :uberjar
   {:aot :all
    :hooks [leiningen.cljsbuild]}}

  :repl-options
  {:timeout 120000}

  :clean-targets
  ^{:protect false}
  ["resources/public/js/compiled" "target"]

  :cljsbuild
  {:builds
   [{:id "dev"
     :source-paths ["src/cljs"]


     :figwheel
     {:on-jsload
      "example.core/on-jsload"}

     :compiler
     {:main "example.core"
      :asset-path "js/compiled/out"
      :output-to "resources/public/js/compiled/formalicious.js"
      :output-dir "resources/public/js/compiled/out"
      :source-map-timestamp true
      :optimizations :none}}]})
