(defproject de.phenomdevel/formalicious "0.2.0-SNAPSHOT"
  :description
  "Generic form rendering library made for re-frame."

  :url
  "https://github.com/PhenomDevel/formalicious"

  :license
  {:name
   "Eclipse Public License"

   :url
   "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies
  [[org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.494"]

   [prismatic/plumbing "0.5.2"]
   [com.stuartsierra/component "0.3.1"]

   [hiccup "1.0.5"]

   [http-kit "2.1.18"]
   [ring "1.4.0"]
   [ring/ring-defaults "0.1.5"]
   [compojure "1.4.0"]
   [hiccup "1.0.5"]
   [re-frame "0.9.2" :exclusions [reagent]]
   [reagent "0.6.0"]]

  :source-paths
  ["src/clj" "src/cljs"]

  :plugins
  [[lein-cljsbuild "1.1.4"]
   [lein-figwheel "0.5.8"]]

  :profiles
  {:dev
   {:source-paths
    ["dev"]

    :dependencies
    [[org.clojure/tools.namespace "0.2.10"]
     [figwheel-sidecar "0.5.8"]
     [com.cemerick/piggieback "0.2.1"]]}

   :uberjar
   {:aot :all
    :hooks [leiningen.cljsbuild]}}

  :repl-options
  {:nrepl-middleware
   [cemerick.piggieback/wrap-cljs-repl]}

  :clean-targets
  ^{:protect false}
  ["resources/public/js/compiled" "target"]

  :cljsbuild
  {:builds
   {:production
    {:source-paths
     ["src/cljs/de"]

     :compiler
     {:output-to
      "resources/public/js/compiled/formalicious.js"

      :main
      "de.phenomdevel.formalicious.core"

      :optimizations
      :advanced}}}})
