(ns de.phenomdevel.formalicious.util.dom.element)


;; =============================================================================
;; Dom Element Helper

(defn value
  [e]
  (-> e
      (.-target)
      (.-value)))

(defn checked?
  [e]
  (-> e
      (.-target)
      (.-checked)))

(defn options
  [e]
  (->> e
       (.-target)
       (.-options)
       (array-seq)
       (remove #(not (.-selected %)))
       (mapv #(.-value %))))
