(ns de.phenomdevel.formalicious.schema.form
  (:require
   [schema.core :as s]

   [de.phenomdevel.formalicious.schema.shared :as shared]))


;; =============================================================================
;; Schema Helper

(defn with-type
  [s t]
  (assoc s :type (s/enum t)))


;; =============================================================================
;; Schemas

(def ReFrameEventPath
  (s/cond-pre s/Keyword [s/Keyword]))

(def Common
  {:label
   s/Str

   (s/optional-key :placeholder)
   (s/cond-pre s/Str s/Keyword)

   (s/optional-key :pos)
   s/Int

   (s/optional-key :class)
   s/Str

   (s/optional-key :data-path) ReFrameEventPath

   (s/optional-key :disabled) s/Any

   ,,,})

(def Select
  (-> Common
      (with-type :select)
      (merge {(s/optional-key :options) [s/Any]
              (s/optional-key :options-path) ReFrameEventPath
              (s/optional-key :options-label-key) s/Keyword
              (s/optional-key :options-transform) (s/cond-pre s/Keyword (s/pred fn?))
              (s/optional-key :order-by) (s/cond-pre (s/pred fn?) s/Keyword)})))

(def Text
  (-> Common
      (with-type :text)))

(def Password
  (-> Common
      (with-type :password)))

(def Textarea
  (-> Common
      (with-type :textarea)))

(def Button
  (-> Common
      (with-type :button)
      (merge {:on-click (s/pred fn?)})))

(def Checkbox
  (-> Common
      (with-type :checkbox)))

(def Multiselect
  (-> Common
      (with-type :text)
      (merge {:multiple s/Bool})))

(def Radiobutton
  (-> Common
      (with-type :radiobutton)))

(def Datepicker
  (-> Common
      (with-type :date)))

(def FormSpec
  {:data-root
   ReFrameEventPath

   :fields
   {s/Keyword
    (s/cond-pre
     Select
     Text
     Button
     Password
     Textarea
     Checkbox
     Datepicker
     Multiselect
     Radiobutton)}})

(def Opts
  {(s/optional-key :wrapper) shared/Hiccup})
