(ns example.views.text
  (:require
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.core :as formalicious]))

(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:normal-text-input
    {:type :text
     :label "Textinput"
     :placeholder "Placeholder"
     :class "blue-text col l6"}


    :text-input-disabled-by-checkbox
    {:type :text
     :label "Textinput - Disabled by `normal-checkbox`"
     :class "col l6"
     :disabled #(not @(subscribe [:state/get-at [:example :form-data :normal-checkbox]]))}}})


;; =============================================================================
;; View

(defn view
  [form-data]
  [:div.panel.panel-default
   [:div.panel-body
    [:style
     ".blue-text {color: blue;}"]
    [:h5 "Textinput Examples"]
    [formalicious/render form-spec form-data]]])
