(ns de.phenomdevel.components.discord-bot-connection
  (:require
   [clojure.core.async :as a]

   [taoensso.timbre :as log]
   [discljord.messaging :as dism]


   [discljord.connections :as disc]
   [com.stuartsierra.component :as c]))


;; =============================================================================
;; Component

(defrecord DiscordBotConnection [token intents sender-ch receiver-ch connection-ch]
  c/Lifecycle
  (start
   [this]
   (let [receiver-ch
         (a/chan 100)

         sender-ch
         (dism/start-connection! token)

         connection-ch
         (disc/connect-bot! token receiver-ch :intents (or intents #{}))]

     (log/info "[DiscordBotConnection] Started.")
     (assoc this
            :sender-ch sender-ch
            :receiver-ch receiver-ch
            :connection-ch connection-ch)))

  (stop
   [this]
   (when sender-ch
     (dism/stop-connection! sender-ch))
   (when connection-ch
     (disc/disconnect-bot! connection-ch))
   (when receiver-ch
     (a/close! receiver-ch))

   (log/info "[DiscordBotConnection] Stopped.")
   (assoc this
          :sender-ch nil
          :receiver-ch nil
          :connection-ch nil)))


;; =============================================================================
;; Public API

(defn new-discord-bot-connection
  [config]
  (map->DiscordBotConnection config))
