(ns de.phenomdevel.components.discord-bot.sender
  (:require
   [clojure.pprint :as pprint]

   [taoensso.timbre :as log]
   [discljord.messaging :as dism]
   [com.stuartsierra.component :as c]

   [de.phenomdevel.protocols.discord-bot.isender :as idiscord-bot-sender]
   [de.phenomdevel.protocols.idiscord-bot-guild-state :as idiscord-bot-guild-state]))


;; =============================================================================
;; Component

(defrecord DiscordBotSender
    [token
     default-channel-id

     discord-bot-connection
     discord-bot-guild-state]

  c/Lifecycle
  (start [this]
    )

  (stop [this]
    ))

(def DefaultDiscordBotSender
  (extend-type DiscordBotSender
    idiscord-bot-sender
    (create-message!
      [component channel-id message embed]
      (let [channel-id
            (or channel-id default-channel-id)]

        (log/info (format "[DiscordBotSender] Sending new message with embed to channel `%s`" channel-id))
        (log/trace (format "[DiscordBotSender] Message\n%s" (pprint-str {:channel-id channel-id :message message :embed embed})))
        (dism/create-message! (:sender-ch discord-bot-connection) channel-id :content (or message "") :embed embed)))))


;; =============================================================================
;; Public API

(defn new-discord-bot-sender
  [config]
  (map->DiscordBotSender config))
