/*
 * Decompiled with CFR 0.152.
 */
package de.paymill.net;

import de.paymill.PaymillException;
import de.paymill.model.IPaymillObject;
import de.paymill.net.IEncoder;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Map;

public class UrlEncoder
implements IEncoder {
    protected String charset = "UTF-8";
    private boolean decodeCamelCase;

    public UrlEncoder() {
        this.setDecodeCamelCase(true);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String encode(Object o) {
        if ("de.paymill.model".equals(o.getClass().getPackage().getName())) {
            return this.encodeBean(o);
        }
        if (o instanceof Map) {
            return this.encodeMap((Map)o);
        }
        throw new PaymillException("Unknown object type '%s'. Only objects in package 'com.chipmunk.model' and instances of 'java.util.Map' are supported.", o.getClass().getName());
    }

    protected String encodeBean(Object o) {
        try {
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            StringBuilder builder = new StringBuilder();
            for (PropertyDescriptor prop : props) {
                Method reader;
                Object value;
                String key = prop.getName();
                if ("class".equals(key) || (value = (reader = prop.getReadMethod()).invoke(o, new Object[0])) == null) continue;
                this.addKeyValuePair(builder, key, value);
            }
            return builder.toString();
        }
        catch (Exception e) {
            this.throwReflectEx(o, e);
            throw new PaymillException("Ooops!", new Object[0]);
        }
    }

    private void throwReflectEx(Object o, Exception ex) {
        throw new PaymillException("Error reading bean of type '%s'.", o.getClass().getName());
    }

    protected String encodeMap(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            this.addKeyValuePair(builder, key.toString(), value);
        }
        return builder.toString();
    }

    protected void addKeyValuePair(StringBuilder builder, String key, Object value) {
        try {
            if (builder.length() > 0) {
                builder.append('&');
            }
            if (this.decodeCamelCase) {
                key = key.replaceAll("([a-z])([A-Z])", "$1_$2");
                key = key.toLowerCase();
            }
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                value = e.toString().toLowerCase();
            }
            if (value instanceof IPaymillObject) {
                value = ((IPaymillObject)value).getId();
            }
            builder.append(String.format("%s=%s", URLEncoder.encode(key, this.charset), URLEncoder.encode(value.toString(), this.charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new PaymillException("Unsupported or invalid character set encoding '%s'.", this.charset);
        }
    }

    public boolean isDecodeCamelCase() {
        return this.decodeCamelCase;
    }

    public void setDecodeCamelCase(boolean decodeCamelCase) {
        this.decodeCamelCase = decodeCamelCase;
    }
}

