(defproject de.otto.tesla/kafka-reader "0.2.29-SNAPSHOT"
  :description "library to read from a kafka-topic."
  :url "https://github.com/otto-de/tesla-tracklog-reader"
  :license {:name "Apache License 2.0"
            :url  "http://www.apache.org/license/LICENSE-2.0.html"}
  :repositories [["central" {:url "http://artifactory.lhotse.ov.otto.de/artifactory/maven-central-remote"}]
                 ["clojars" {:url "http://artifactory.lhotse.ov.otto.de/artifactory/clojars-releases-remote"}]
                 ["nexus-releases" {:url "http://artifactory.lhotse.ov.otto.de/artifactory/nexus-releases-remote"}]
                 ["releases" {:url           "http://artifactory.lhotse.ov.otto.de/artifactory/maven-tesla-releases-local"
                              :username      :env/artifactory_user
                              :password      :env/artifactory_password
                              :sign-releases false}]
                 ["snapshots" {:url           "http://artifactory.lhotse.ov.otto.de/artifactory/maven-tesla-snapshots-local"
                               :username      :env/artifactory_user
                               :password      :env/artifactory_password
                               :sign-releases false}]]
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [metrics-clojure "2.6.1"]
                 [com.stuartsierra/component "0.2.3"]
                 [org.clojure/core.async "0.2.374"]
                 [org.clojure/tools.logging "0.3.1"]
                 [clj-kafka "0.3.2"]]
  :source-paths ["src"]
  :test-paths ["test" "test-resources"]
  :profiles {:dev {:plugins [[lein-release/lein-release "1.0.9"]]}})