# tracklog-reader

Library that reads from kafka topic and puts messages in given channel.

## Usage


1. Giving only the output channel. All read messages will be put into the channel. 
   The config comes from the `:kafka {:default {...}}` section. 

    ```
    (kafkareader/new-kafka-reader 
      (async/chan))
    ```

2. Giving output channel and section. All read messages will be put into the channel. 
   The config comes from the given section. 

    ```clojure
    (kafkareader/new-kafka-reader 
      (async/chan)
      :wa) ;; config has a :kafka {:wa {...}} section
    ```

3. Giving output channel, section and filter-fn. Read messages will be passed through
   `transform-fn` and its result is then put into the channel. 
   The config comes from the given section.  

    ```clojure
    (defn transform-fn [messages] 
      (filter #(starts-with? % "X") messages))
    
    (kafkareader/new-kafka-reader 
      (async/chan) 
      :wa
      transform-fn)
    ```

## Config

```edn
{ :kafka {:default {:group-id           "tesla-tracklog-historizer"
                    :topic              "tracking"
                    :zookeeper-connect  "localhost:2181/develop-ci"}
          :wa      {:group-id            "tesla-wa-historizer"
                    :topic               "wa"
                    :zookeeper-connect   "localhost:2181/develop-ci"}}}
```

## Reporting

The rate of message read from the kafka queue is reported via `metrics-clojure` library. 

## License

Copyright © 2015 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
