(defproject de.otto/tesla-microservice "0.11.25"
  :description "basic microservice."
  :url "https://github.com/otto-de/tesla-microservice"
  :license {:name "Apache License 2.0"
            :url  "http://www.apache.org/license/LICENSE-2.0.html"}
  :scm {:name "git"
        :url  "https://github.com/otto-de/tesla-microservice"}
  :dependencies [[org.clojure/data.json "0.2.6"]
                 [org.clojure/tools.logging "0.4.0"]
                 [de.otto/status "0.1.3"]
                 [de.otto/goo "1.2.9"]
                 [metrics-clojure "2.10.0"]
                 [beckon "0.1.1"]
                 [clj-time "0.14.2"]
                 [clojurewerkz/propertied "1.3.0"]
                 [com.stuartsierra/component "0.3.2"]
                 [compojure "1.6.0"]
                 [environ "1.1.0"]
                 [metrics-clojure "2.10.0"]
                 [metrics-clojure-graphite "2.10.0"]
                 [overtone/at-at "1.2.0"]
                 [ring/ring-core "1.6.3"]
                 [ring-basic-authentication "1.0.5"]]

  :exclusions [org.clojure/clojure
               org.slf4j/slf4j-nop
               org.slf4j/slf4j-log4j12
               log4j
               commons-logging/commons-logging]
  :lein-release {:deploy-via :clojars}

  :filespecs [{:type :path :path "test-utils"}]

  :test-selectors {:default     (constantly true)
                   :integration :integration
                   :unit        :unit
                   :all         (constantly true)}
  :profiles {:uberjar {:aot :all}
             :dev     {:dependencies [[org.clojure/clojure "1.9.0"]
                                      [org.slf4j/slf4j-api "1.7.25"]
                                      [ch.qos.logback/logback-core "1.2.3"]
                                      [ch.qos.logback/logback-classic "1.2.3"]
                                      [ring-mock "0.1.5"]]
                       :plugins      [[lein-release/lein-release "1.0.9"]]}}
  :test-paths ["test" "test-resources" "test-utils"])
