if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.provide can not be used within a goog.module.");
  }
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    if (!opt_loadFlags || typeof opt_loadFlags === "boolean") {
      opt_loadFlags = opt_loadFlags ? {"module":"goog"} : {};
    }
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.loadFlags[path] = opt_loadFlags;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.writeScripts_(path);
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
goog.define("goog.TRANSPILE", "detect");
goog.define("goog.TRANSPILER", "transpile.js");
if (goog.DEPENDENCIES_ENABLED) {
  goog.dependencies_ = {loadFlags:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);
  goog.importProcessedScript_ = function(src, isModule, needsTranspile) {
    var bootstrap = 'goog.retrieveAndExec_("' + src + '", ' + isModule + ", " + needsTranspile + ");";
    goog.importScript_("", bootstrap);
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    var loadFlags = path && goog.dependencies_.loadFlags[path] || {};
    if (path && (loadFlags["module"] == "goog" || goog.needsTranspile_(loadFlags["lang"]))) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModuleFromUrl = function(url) {
    goog.retrieveAndExec_(url, true, false);
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareLegacyNamespace:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function() {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = (doc.createElement("script"));
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      if (opt_sourceText === undefined) {
        if (!goog.IS_OLD_IE_) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.needsTranspile_ = function(lang) {
    if (goog.TRANSPILE == "always") {
      return true;
    } else {
      if (goog.TRANSPILE == "never") {
        return false;
      } else {
        if (!goog.transpiledLanguages_) {
          goog.transpiledLanguages_ = {"es5":true, "es6":true, "es6-impl":true};
          try {
            goog.transpiledLanguages_["es5"] = eval("[1,].length!\x3d1");
            var es6implTest = "let a\x3d{};const X\x3dclass{constructor(){}x(z){return new Map([" + "...arguments]).get(z[0])\x3d\x3d3}};return new X().x([a,3])";
            var es6fullTest = "class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}" + "let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof " + "String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function " + "f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()" + "\x3d\x3d3}";
            if (eval('(()\x3d\x3e{"use strict";' + es6implTest + "})()")) {
              goog.transpiledLanguages_["es6-impl"] = false;
            }
            if (eval('(()\x3d\x3e{"use strict";' + es6fullTest + "})()")) {
              goog.transpiledLanguages_["es6"] = false;
            }
          } catch (err) {
          }
        }
      }
    }
    return !!goog.transpiledLanguages_[lang];
  };
  goog.transpiledLanguages_ = null;
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function(pathToLoad) {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    visitNode(pathToLoad);
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        var loadFlags = deps.loadFlags[path] || {};
        var needsTranspile = goog.needsTranspile_(loadFlags["lang"]);
        if (loadFlags["module"] == "goog" || needsTranspile) {
          goog.importProcessedScript_(goog.basePath + path, loadFlags["module"] == "goog", needsTranspile);
        } else {
          goog.importScript_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      var xhr = new goog.global["XMLHttpRequest"];
      xhr.open("get", src, false);
      xhr.send();
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      return null;
    }
  }
};
goog.retrieveAndExec_ = function(src, isModule, needsTranspile) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText == null) {
      throw new Error('Load of "' + src + '" failed');
    }
    if (needsTranspile) {
      scriptText = goog.transpile_.call(goog.global, scriptText, src);
    }
    if (isModule) {
      scriptText = goog.wrapModule_(src, scriptText);
    } else {
      scriptText += "\n//# sourceURL\x3d" + src;
    }
    var isOldIE = goog.IS_OLD_IE_;
    if (isOldIE) {
      goog.dependencies_.deferred[originalPath] = scriptText;
      goog.queuedModules_.push(originalPath);
    } else {
      importScript(src, scriptText);
    }
  }
};
goog.transpile_ = function(code, path) {
  var jscomp = goog.global["$jscomp"];
  if (!jscomp) {
    goog.global["$jscomp"] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      eval(transpilerCode + "\n//# sourceURL\x3d" + transpilerPath);
      jscomp = goog.global["$jscomp"];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code, path);
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if (obj !== null && "removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _evalTest_ \x3d 1;");
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = (doc.createElement("SCRIPT"));
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.scope is not supported within a goog.module.");
  }
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    return ctr;
  }
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);
  var wrappedCtr = function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    if (this.constructor === wrappedCtr && superclassSealable && Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };
  return wrappedCtr;
};
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype && ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:" "};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "" && ch <= "�";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(tokenizerRegExp);
  var tokens2 = str2.toLowerCase().match(tokenizerRegExp);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "\x3c":"\x3c"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  var sb = ['"'];
  for (var i = 0;i < s.length;i++) {
    var ch = s.charAt(i);
    var cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.lastComponent = function(str, separators) {
  if (!separators) {
    return str;
  } else {
    if (typeof separators == "string") {
      separators = [separators];
    }
  }
  var lastSeparatorIndex = -1;
  for (var i = 0;i < separators.length;i++) {
    if (separators[i] == "") {
      continue;
    }
    var currentSeparatorIndex = str.lastIndexOf(separators[i]);
    if (currentSeparatorIndex > lastSeparatorIndex) {
      lastSeparatorIndex = currentSeparatorIndex;
    }
  }
  if (lastSeparatorIndex == -1) {
    return str;
  }
  return str.slice(lastSeparatorIndex + 1);
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = Number(a[i] != b[j]);
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.is = function(v, v2) {
  if (v === v2) {
    return v !== 0 || 1 / v === 1 / (v2);
  }
  return v !== v && v2 !== v2;
};
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call((opt_obj), obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call((opt_obj), obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call((opt_obj), obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return obj !== null && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call((opt_this), obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in (obj)) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (obj !== null && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in (obj) ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.math.Integer");
goog.math.Integer = function(bits, sign) {
  this.bits_ = [];
  this.sign_ = sign;
  var top = true;
  for (var i = bits.length - 1;i >= 0;i--) {
    var val = bits[i] | 0;
    if (!top || val != sign) {
      this.bits_[i] = val;
      top = false;
    }
  }
};
goog.math.Integer.IntCache_ = {};
goog.math.Integer.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    var cachedObj = goog.math.Integer.IntCache_[value];
    if (cachedObj) {
      return cachedObj;
    }
  }
  var obj = new goog.math.Integer([value | 0], value < 0 ? -1 : 0);
  if (-128 <= value && value < 128) {
    goog.math.Integer.IntCache_[value] = obj;
  }
  return obj;
};
goog.math.Integer.fromNumber = function(value) {
  if (isNaN(value) || !isFinite(value)) {
    return goog.math.Integer.ZERO;
  } else {
    if (value < 0) {
      return goog.math.Integer.fromNumber(-value).negate();
    } else {
      var bits = [];
      var pow = 1;
      for (var i = 0;value >= pow;i++) {
        bits[i] = value / pow | 0;
        pow *= goog.math.Integer.TWO_PWR_32_DBL_;
      }
      return new goog.math.Integer(bits, 0);
    }
  }
};
goog.math.Integer.fromBits = function(bits) {
  var high = bits[bits.length - 1];
  return new goog.math.Integer(bits, high & 1 << 31 ? -1 : 0);
};
goog.math.Integer.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Integer.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character');
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Integer.ZERO;
  for (var i = 0;i < str.length;i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Integer.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Integer.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Integer.fromNumber(value));
    }
  }
  return result;
};
goog.math.Integer.TWO_PWR_32_DBL_ = (1 << 16) * (1 << 16);
goog.math.Integer.ZERO = goog.math.Integer.fromInt(0);
goog.math.Integer.ONE = goog.math.Integer.fromInt(1);
goog.math.Integer.TWO_PWR_24_ = goog.math.Integer.fromInt(1 << 24);
goog.math.Integer.prototype.toInt = function() {
  return this.bits_.length > 0 ? this.bits_[0] : this.sign_;
};
goog.math.Integer.prototype.toNumber = function() {
  if (this.isNegative()) {
    return -this.negate().toNumber();
  } else {
    var val = 0;
    var pow = 1;
    for (var i = 0;i < this.bits_.length;i++) {
      val += this.getBitsUnsigned(i) * pow;
      pow *= goog.math.Integer.TWO_PWR_32_DBL_;
    }
    return val;
  }
};
goog.math.Integer.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  } else {
    if (this.isNegative()) {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.divide(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Integer.prototype.getBits = function(index) {
  if (index < 0) {
    return 0;
  } else {
    if (index < this.bits_.length) {
      return this.bits_[index];
    } else {
      return this.sign_;
    }
  }
};
goog.math.Integer.prototype.getBitsUnsigned = function(index) {
  var val = this.getBits(index);
  return val >= 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;
};
goog.math.Integer.prototype.getSign = function() {
  return this.sign_;
};
goog.math.Integer.prototype.isZero = function() {
  if (this.sign_ != 0) {
    return false;
  }
  for (var i = 0;i < this.bits_.length;i++) {
    if (this.bits_[i] != 0) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.isNegative = function() {
  return this.sign_ == -1;
};
goog.math.Integer.prototype.isOdd = function() {
  return this.bits_.length == 0 && this.sign_ == -1 || this.bits_.length > 0 && (this.bits_[0] & 1) != 0;
};
goog.math.Integer.prototype.equals = function(other) {
  if (this.sign_ != other.sign_) {
    return false;
  }
  var len = Math.max(this.bits_.length, other.bits_.length);
  for (var i = 0;i < len;i++) {
    if (this.getBits(i) != other.getBits(i)) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.notEquals = function(other) {
  return !this.equals(other);
};
goog.math.Integer.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Integer.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Integer.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Integer.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Integer.prototype.compare = function(other) {
  var diff = this.subtract(other);
  if (diff.isNegative()) {
    return -1;
  } else {
    if (diff.isZero()) {
      return 0;
    } else {
      return +1;
    }
  }
};
goog.math.Integer.prototype.shorten = function(numBits) {
  var arr_index = numBits - 1 >> 5;
  var bit_index = (numBits - 1) % 32;
  var bits = [];
  for (var i = 0;i < arr_index;i++) {
    bits[i] = this.getBits(i);
  }
  var sigBits = bit_index == 31 ? 4294967295 : (1 << bit_index + 1) - 1;
  var val = this.getBits(arr_index) & sigBits;
  if (val & 1 << bit_index) {
    val |= 4294967295 - sigBits;
    bits[arr_index] = val;
    return new goog.math.Integer(bits, -1);
  } else {
    bits[arr_index] = val;
    return new goog.math.Integer(bits, 0);
  }
};
goog.math.Integer.prototype.negate = function() {
  return this.not().add(goog.math.Integer.ONE);
};
goog.math.Integer.prototype.add = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  var carry = 0;
  for (var i = 0;i <= len;i++) {
    var a1 = this.getBits(i) >>> 16;
    var a0 = this.getBits(i) & 65535;
    var b1 = other.getBits(i) >>> 16;
    var b0 = other.getBits(i) & 65535;
    var c0 = carry + a0 + b0;
    var c1 = (c0 >>> 16) + a1 + b1;
    carry = c1 >>> 16;
    c0 &= 65535;
    c1 &= 65535;
    arr[i] = c1 << 16 | c0;
  }
  return goog.math.Integer.fromBits(arr);
};
goog.math.Integer.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Integer.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Integer.ZERO;
  } else {
    if (other.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) && other.lessThan(goog.math.Integer.TWO_PWR_24_)) {
    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());
  }
  var len = this.bits_.length + other.bits_.length;
  var arr = [];
  for (var i = 0;i < 2 * len;i++) {
    arr[i] = 0;
  }
  for (var i = 0;i < this.bits_.length;i++) {
    for (var j = 0;j < other.bits_.length;j++) {
      var a1 = this.getBits(i) >>> 16;
      var a0 = this.getBits(i) & 65535;
      var b1 = other.getBits(j) >>> 16;
      var b0 = other.getBits(j) & 65535;
      arr[2 * i + 2 * j] += a0 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);
      arr[2 * i + 2 * j + 1] += a1 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 1] += a0 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 2] += a1 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);
    }
  }
  for (var i = 0;i < len;i++) {
    arr[i] = arr[2 * i + 1] << 16 | arr[2 * i];
  }
  for (var i = len;i < 2 * len;i++) {
    arr[i] = 0;
  }
  return new goog.math.Integer(arr, 0);
};
goog.math.Integer.carry16_ = function(bits, index) {
  while ((bits[index] & 65535) != bits[index]) {
    bits[index + 1] += bits[index] >>> 16;
    bits[index] &= 65535;
  }
};
goog.math.Integer.prototype.slowDivide_ = function(other) {
  if (this.isNegative() || other.isNegative()) {
    throw Error("slowDivide_ only works with positive integers.");
  }
  var twoPower = goog.math.Integer.ONE;
  var multiple = other;
  while (multiple.lessThanOrEqual(this)) {
    twoPower = twoPower.shiftLeft(1);
    multiple = multiple.shiftLeft(1);
  }
  var res = twoPower.shiftRight(1);
  var total = multiple.shiftRight(1);
  var total2;
  multiple = multiple.shiftRight(2);
  twoPower = twoPower.shiftRight(2);
  while (!multiple.isZero()) {
    total2 = total.add(multiple);
    if (total2.lessThanOrEqual(this)) {
      res = res.add(twoPower);
      total = total2;
    }
    multiple = multiple.shiftRight(1);
    twoPower = twoPower.shiftRight(1);
  }
  return res;
};
goog.math.Integer.prototype.divide = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().divide(other.negate());
    } else {
      return this.negate().divide(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.divide(other.negate()).negate();
    }
  }
  if (this.bits_.length > 30) {
    return this.slowDivide_(other);
  }
  var res = goog.math.Integer.ZERO;
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Integer.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Integer.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Integer.ONE;
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Integer.prototype.modulo = function(other) {
  return this.subtract(this.divide(other).multiply(other));
};
goog.math.Integer.prototype.not = function() {
  var len = this.bits_.length;
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = ~this.bits_[i];
  }
  return new goog.math.Integer(arr, ~this.sign_);
};
goog.math.Integer.prototype.and = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) & other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ & other.sign_);
};
goog.math.Integer.prototype.or = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) | other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ | other.sign_);
};
goog.math.Integer.prototype.xor = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) ^ other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);
};
goog.math.Integer.prototype.shiftLeft = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length + arr_delta + (bit_delta > 0 ? 1 : 0);
  var arr = [];
  for (var i = 0;i < len;i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i - arr_delta) << bit_delta | this.getBits(i - arr_delta - 1) >>> 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i - arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.math.Integer.prototype.shiftRight = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length - arr_delta;
  var arr = [];
  for (var i = 0;i < len;i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i + arr_delta) >>> bit_delta | this.getBits(i + arr_delta + 1) << 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i + arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += String(a1);
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  Array.prototype.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call((opt_obj), val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call((opt_obj), arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.asserts.assert(f != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call((opt_obj), arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call((opt_obj), element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeLast = function(arr, obj) {
  var i = goog.array.lastIndexOf(arr, obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call((opt_obj), val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.join = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return Array.prototype.slice.call(arr, start);
  } else {
    return Array.prototype.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = (compareFn)(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  var compArr = new Array(arr.length);
  for (var i = 0;i < arr.length;i++) {
    compArr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(compArr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = compArr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call((opt_obj), value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call((opt_obj), element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      Array.prototype.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        Array.prototype.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = Array.prototype.splice.call(arr, fromIndex, 1);
  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  var minLen = arguments[0].length;
  for (var i = 1;i < arguments.length;i++) {
    if (arguments[i].length < minLen) {
      minLen = arguments[i].length;
    }
  }
  for (var i = 0;i < minLen;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.array.concatMap = function(arr, f, opt_obj) {
  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));
};
goog.provide("goog.reflect");
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.objectProperty = function(prop, object) {
  return prop;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[" "](x);
  return x;
};
goog.reflect.sinkValue[" "] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    goog.reflect.sinkValue(obj[prop]);
    return true;
  } catch (e) {
  }
  return false;
};
goog.reflect.cache = function(cacheObj, key, valueFn, opt_keyFn) {
  var storedKey = opt_keyFn ? opt_keyFn(key) : key;
  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {
    return cacheObj[storedKey];
  }
  return cacheObj[storedKey] = valueFn(key);
};
goog.provide("goog.math.Long");
goog.require("goog.reflect");
goog.math.Long = function(low, high) {
  this.low_ = low | 0;
  this.high_ = high | 0;
};
goog.math.Long.IntCache_ = {};
goog.math.Long.valueCache_ = {};
goog.math.Long.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    return goog.reflect.cache(goog.math.Long.IntCache_, value, function(val) {
      return new goog.math.Long(val | 0, val < 0 ? -1 : 0);
    });
  } else {
    return new goog.math.Long(value | 0, value < 0 ? -1 : 0);
  }
};
goog.math.Long.fromNumber = function(value) {
  if (isNaN(value)) {
    return goog.math.Long.getZero();
  } else {
    if (value <= -goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.getMinValue();
    } else {
      if (value + 1 >= goog.math.Long.TWO_PWR_63_DBL_) {
        return goog.math.Long.getMaxValue();
      } else {
        if (value < 0) {
          return goog.math.Long.fromNumber(-value).negate();
        } else {
          return new goog.math.Long(value % goog.math.Long.TWO_PWR_32_DBL_ | 0, value / goog.math.Long.TWO_PWR_32_DBL_ | 0);
        }
      }
    }
  }
};
goog.math.Long.fromBits = function(lowBits, highBits) {
  return new goog.math.Long(lowBits, highBits);
};
goog.math.Long.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Long.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character: ' + str);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Long.getZero();
  for (var i = 0;i < str.length;i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Long.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Long.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Long.fromNumber(value));
    }
  }
  return result;
};
goog.math.Long.TWO_PWR_16_DBL_ = 1 << 16;
goog.math.Long.TWO_PWR_32_DBL_ = goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
goog.math.Long.TWO_PWR_64_DBL_ = goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;
goog.math.Long.TWO_PWR_63_DBL_ = goog.math.Long.TWO_PWR_64_DBL_ / 2;
goog.math.Long.getZero = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ZERO, function() {
    return goog.math.Long.fromInt(0);
  });
};
goog.math.Long.getOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ONE, function() {
    return goog.math.Long.fromInt(1);
  });
};
goog.math.Long.getNegOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.NEG_ONE, function() {
    return goog.math.Long.fromInt(-1);
  });
};
goog.math.Long.getMaxValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MAX_VALUE, function() {
    return goog.math.Long.fromBits(4294967295 | 0, 2147483647 | 0);
  });
};
goog.math.Long.getMinValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MIN_VALUE, function() {
    return goog.math.Long.fromBits(0, 2147483648 | 0);
  });
};
goog.math.Long.getTwoPwr24 = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.TWO_PWR_24, function() {
    return goog.math.Long.fromInt(1 << 24);
  });
};
goog.math.Long.prototype.toInt = function() {
  return this.low_;
};
goog.math.Long.prototype.toNumber = function() {
  return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();
};
goog.math.Long.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  }
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      var radixLong = goog.math.Long.fromNumber(radix);
      var div = this.div(radixLong);
      var rem = div.multiply(radixLong).subtract(this);
      return div.toString(radix) + rem.toInt().toString(radix);
    } else {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.div(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Long.prototype.getHighBits = function() {
  return this.high_;
};
goog.math.Long.prototype.getLowBits = function() {
  return this.low_;
};
goog.math.Long.prototype.getLowBitsUnsigned = function() {
  return this.low_ >= 0 ? this.low_ : goog.math.Long.TWO_PWR_32_DBL_ + this.low_;
};
goog.math.Long.prototype.getNumBitsAbs = function() {
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      return 64;
    } else {
      return this.negate().getNumBitsAbs();
    }
  } else {
    var val = this.high_ != 0 ? this.high_ : this.low_;
    for (var bit = 31;bit > 0;bit--) {
      if ((val & 1 << bit) != 0) {
        break;
      }
    }
    return this.high_ != 0 ? bit + 33 : bit + 1;
  }
};
goog.math.Long.prototype.isZero = function() {
  return this.high_ == 0 && this.low_ == 0;
};
goog.math.Long.prototype.isNegative = function() {
  return this.high_ < 0;
};
goog.math.Long.prototype.isOdd = function() {
  return (this.low_ & 1) == 1;
};
goog.math.Long.prototype.equals = function(other) {
  return this.high_ == other.high_ && this.low_ == other.low_;
};
goog.math.Long.prototype.notEquals = function(other) {
  return this.high_ != other.high_ || this.low_ != other.low_;
};
goog.math.Long.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Long.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Long.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Long.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Long.prototype.compare = function(other) {
  if (this.equals(other)) {
    return 0;
  }
  var thisNeg = this.isNegative();
  var otherNeg = other.isNegative();
  if (thisNeg && !otherNeg) {
    return -1;
  }
  if (!thisNeg && otherNeg) {
    return 1;
  }
  if (this.subtract(other).isNegative()) {
    return -1;
  } else {
    return 1;
  }
};
goog.math.Long.prototype.negate = function() {
  if (this.equals(goog.math.Long.getMinValue())) {
    return goog.math.Long.getMinValue();
  } else {
    return this.not().add(goog.math.Long.getOne());
  }
};
goog.math.Long.prototype.add = function(other) {
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 + b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 + b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 + b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 + b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Long.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Long.getZero();
  } else {
    if (other.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    return other.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return this.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Long.getTwoPwr24()) && other.lessThan(goog.math.Long.getTwoPwr24())) {
    return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());
  }
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 * b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 * b00;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c16 += a00 * b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 * b00;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a16 * b16;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a00 * b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.div = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    if (other.equals(goog.math.Long.getOne()) || other.equals(goog.math.Long.getNegOne())) {
      return goog.math.Long.getMinValue();
    } else {
      if (other.equals(goog.math.Long.getMinValue())) {
        return goog.math.Long.getOne();
      } else {
        var halfThis = this.shiftRight(1);
        var approx = halfThis.div(other).shiftLeft(1);
        if (approx.equals(goog.math.Long.getZero())) {
          return other.isNegative() ? goog.math.Long.getOne() : goog.math.Long.getNegOne();
        } else {
          var rem = this.subtract(other.multiply(approx));
          var result = approx.add(rem.div(other));
          return result;
        }
      }
    }
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().div(other.negate());
    } else {
      return this.negate().div(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.div(other.negate()).negate();
    }
  }
  var res = goog.math.Long.getZero();
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Long.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Long.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Long.getOne();
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Long.prototype.modulo = function(other) {
  return this.subtract(this.div(other).multiply(other));
};
goog.math.Long.prototype.not = function() {
  return goog.math.Long.fromBits(~this.low_, ~this.high_);
};
goog.math.Long.prototype.and = function(other) {
  return goog.math.Long.fromBits(this.low_ & other.low_, this.high_ & other.high_);
};
goog.math.Long.prototype.or = function(other) {
  return goog.math.Long.fromBits(this.low_ | other.low_, this.high_ | other.high_);
};
goog.math.Long.prototype.xor = function(other) {
  return goog.math.Long.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);
};
goog.math.Long.prototype.shiftLeft = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var low = this.low_;
    if (numBits < 32) {
      var high = this.high_;
      return goog.math.Long.fromBits(low << numBits, high << numBits | low >>> 32 - numBits);
    } else {
      return goog.math.Long.fromBits(0, low << numBits - 32);
    }
  }
};
goog.math.Long.prototype.shiftRight = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >> numBits);
    } else {
      return goog.math.Long.fromBits(high >> numBits - 32, high >= 0 ? 0 : -1);
    }
  }
};
goog.math.Long.prototype.shiftRightUnsigned = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits);
    } else {
      if (numBits == 32) {
        return goog.math.Long.fromBits(high, 0);
      } else {
        return goog.math.Long.fromBits(high >>> numBits - 32, 0);
      }
    }
  }
};
goog.math.Long.ValueCacheId_ = {MAX_VALUE:1, MIN_VALUE:2, ZERO:3, ONE:4, NEG_ONE:5, TWO_PWR_24:6};
goog.provide("cljs.core");
goog.require("goog.math.Long");
goog.require("goog.math.Integer");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.229";
cljs.core._STAR_unchecked_if_STAR_ = false;
goog.define("cljs.core._STAR_target_STAR_", "default");
cljs.core._STAR_ns_STAR_ = null;
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
if (typeof cljs.core._STAR_print_err_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_err_fn_STAR_ = function cljs$core$_STAR_print_err_fn_STAR_(_) {
    throw new Error("No *print-err-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core.set_print_err_fn_BANG_ = function cljs$core$set_print_err_fn_BANG_(f) {
  return cljs.core._STAR_print_err_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  cljs.core._STAR_print_fn_STAR_ = function() {
    var G__8637__delegate = function(args) {
      return console.log.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__8637 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__8638__i = 0, G__8638__a = new Array(arguments.length - 0);
        while (G__8638__i < G__8638__a.length) {
          G__8638__a[G__8638__i] = arguments[G__8638__i + 0];
          ++G__8638__i;
        }
        args = new cljs.core.IndexedSeq(G__8638__a, 0);
      }
      return G__8637__delegate.call(this, args);
    };
    G__8637.cljs$lang$maxFixedArity = 0;
    G__8637.cljs$lang$applyTo = function(arglist__8639) {
      var args = cljs.core.seq(arglist__8639);
      return G__8637__delegate(args);
    };
    G__8637.cljs$core$IFn$_invoke$arity$variadic = G__8637__delegate;
    return G__8637;
  }();
  cljs.core._STAR_print_err_fn_STAR_ = function() {
    var G__8640__delegate = function(args) {
      return console.error.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__8640 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__8641__i = 0, G__8641__a = new Array(arguments.length - 0);
        while (G__8641__i < G__8641__a.length) {
          G__8641__a[G__8641__i] = arguments[G__8641__i + 0];
          ++G__8641__i;
        }
        args = new cljs.core.IndexedSeq(G__8641__a, 0);
      }
      return G__8640__delegate.call(this, args);
    };
    G__8640.cljs$lang$maxFixedArity = 0;
    G__8640.cljs$lang$applyTo = function(arglist__8642) {
      var args = cljs.core.seq(arglist__8642);
      return G__8640__delegate(args);
    };
    G__8640.cljs$core$IFn$_invoke$arity$variadic = G__8640__delegate;
    return G__8640;
  }();
  return null;
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (x == null) {
    return true;
  } else {
    if (x === false) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  return goog.isString(x);
};
cljs.core.char_QMARK_ = function cljs$core$char_QMARK_(x) {
  return goog.string.isUnicodeChar(x);
};
cljs.core.any_QMARK_ = function cljs$core$any_QMARK_(x) {
  return true;
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[goog.typeOf(x__$1)]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__6405__auto__ = ty;
    if (cljs.core.truth_(and__6405__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__6405__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4655__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4655__auto__)) {
    var s = temp__4655__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && goog.typeOf(Symbol) === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.CHAR_MAP = {"]":"_RBRACK_", "'":"_SINGLEQUOTE_", "\x3d":"_EQ_", '"':"_DOUBLEQUOTE_", "!":"_BANG_", "*":"_STAR_", "%":"_PERCENT_", "|":"_BAR_", "~":"_TILDE_", "/":"_SLASH_", "\\":"_BSLASH_", "-":"_", "?":"_QMARK_", "\x26":"_AMPERSAND_", ":":"_COLON_", "\x3c":"_LT_", "{":"_LBRACE_", "}":"_RBRACE_", "[":"_LBRACK_", "#":"_SHARP_", "^":"_CARET_", "+":"_PLUS_", "@":"_CIRCA_", "\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP = {"_RBRACE_":"}", "_COLON_":":", "_BANG_":"!", "_QMARK_":"?", "_BSLASH_":"\\\\", "_SLASH_":"/", "_PERCENT_":"%", "_PLUS_":"+", "_SHARP_":"#", "_LBRACE_":"{", "_BAR_":"|", "_LBRACK_":"[", "_EQ_":"\x3d", "_":"-", "_TILDE_":"~", "_RBRACK_":"]", "_GT_":"\x3e", "_SINGLEQUOTE_":"'", "_CIRCA_":"@", "_AMPERSAND_":"\x26", "_DOUBLEQUOTE_":'\\"', "_CARET_":"^", "_LT_":"\x3c", "_STAR_":"*"};
cljs.core.DEMUNGE_PATTERN = null;
cljs.core.system_time = function cljs$core$system_time() {
  if (typeof performance !== "undefined" && !(performance.now == null)) {
    return performance.now();
  } else {
    if (typeof process !== "undefined" && !(process.hrtime == null)) {
      var t = process.hrtime();
      return (t[0] * 1E9 + t[1]) / 1E6;
    } else {
      return (new Date).getTime();
    }
  }
};
cljs.core.make_array = function cljs$core$make_array(var_args) {
  var args8643 = [];
  var len__7492__auto___8649 = arguments.length;
  var i__7493__auto___8650 = 0;
  while (true) {
    if (i__7493__auto___8650 < len__7492__auto___8649) {
      args8643.push(arguments[i__7493__auto___8650]);
      var G__8651 = i__7493__auto___8650 + 1;
      i__7493__auto___8650 = G__8651;
      continue;
    } else {
    }
    break;
  }
  var G__8648 = args8643.length;
  switch(G__8648) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8643.slice(2), 0, null);
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = function(type, size, more_sizes) {
  var dims = more_sizes;
  var dimarray = new Array(size);
  var n__7332__auto___8653 = dimarray.length;
  var i_8654 = 0;
  while (true) {
    if (i_8654 < n__7332__auto___8653) {
      dimarray[i_8654] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array, null, dims) : cljs.core.apply.call(null, cljs.core.make_array, null, dims);
      var G__8655 = i_8654 + 1;
      i_8654 = G__8655;
      continue;
    } else {
    }
    break;
  }
  return dimarray;
};
cljs.core.make_array.cljs$lang$applyTo = function(seq8644) {
  var G__8645 = cljs.core.first(seq8644);
  var seq8644__$1 = cljs.core.next(seq8644);
  var G__8646 = cljs.core.first(seq8644__$1);
  var seq8644__$2 = cljs.core.next(seq8644__$1);
  return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__8645, G__8646, seq8644__$2);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__7332__auto___8656 = len;
  var i_8657 = 0;
  while (true) {
    if (i_8657 < n__7332__auto___8656) {
      new_arr[i_8657] = arr[i_8657];
      var G__8658 = i_8657 + 1;
      i_8657 = G__8658;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__8659 = i + 1;
      i = G__8659;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget(var_args) {
  var args8660 = [];
  var len__7492__auto___8669 = arguments.length;
  var i__7493__auto___8670 = 0;
  while (true) {
    if (i__7493__auto___8670 < len__7492__auto___8669) {
      args8660.push(arguments[i__7493__auto___8670]);
      var G__8671 = i__7493__auto___8670 + 1;
      i__7493__auto___8670 = G__8671;
      continue;
    } else {
    }
    break;
  }
  var G__8665 = args8660.length;
  switch(G__8665) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8660.slice(2), 0, null);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__8666 = cljs.core.aget;
  var G__8667 = array[i];
  var G__8668 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__8666, G__8667, G__8668) : cljs.core.apply.call(null, G__8666, G__8667, G__8668);
};
cljs.core.aget.cljs$lang$applyTo = function(seq8661) {
  var G__8662 = cljs.core.first(seq8661);
  var seq8661__$1 = cljs.core.next(seq8661);
  var G__8663 = cljs.core.first(seq8661__$1);
  var seq8661__$2 = cljs.core.next(seq8661__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__8662, G__8663, seq8661__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset(var_args) {
  var args8673 = [];
  var len__7492__auto___8684 = arguments.length;
  var i__7493__auto___8685 = 0;
  while (true) {
    if (i__7493__auto___8685 < len__7492__auto___8684) {
      args8673.push(arguments[i__7493__auto___8685]);
      var G__8686 = i__7493__auto___8685 + 1;
      i__7493__auto___8685 = G__8686;
      continue;
    } else {
    }
    break;
  }
  var G__8679 = args8673.length;
  switch(G__8679) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8673.slice(3), 0, null);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__8680 = cljs.core.aset;
  var G__8681 = array[idx];
  var G__8682 = idx2;
  var G__8683 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__8680, G__8681, G__8682, G__8683) : cljs.core.apply.call(null, G__8680, G__8681, G__8682, G__8683);
};
cljs.core.aset.cljs$lang$applyTo = function(seq8674) {
  var G__8675 = cljs.core.first(seq8674);
  var seq8674__$1 = cljs.core.next(seq8674);
  var G__8676 = cljs.core.first(seq8674__$1);
  var seq8674__$2 = cljs.core.next(seq8674__$1);
  var G__8677 = cljs.core.first(seq8674__$2);
  var seq8674__$3 = cljs.core.next(seq8674__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__8675, G__8676, G__8677, seq8674__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array(var_args) {
  var args8688 = [];
  var len__7492__auto___8694 = arguments.length;
  var i__7493__auto___8695 = 0;
  while (true) {
    if (i__7493__auto___8695 < len__7492__auto___8694) {
      args8688.push(arguments[i__7493__auto___8695]);
      var G__8696 = i__7493__auto___8695 + 1;
      i__7493__auto___8695 = G__8696;
      continue;
    } else {
    }
    break;
  }
  var G__8690 = args8688.length;
  switch(G__8690) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8688.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__8691 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__8692 = [];
  var G__8693 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__8691, G__8692, G__8693) : cljs.core.reduce.call(null, G__8691, G__8692, G__8693);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke(var_args) {
  var args__7499__auto__ = [];
  var len__7492__auto___8701 = arguments.length;
  var i__7493__auto___8702 = 0;
  while (true) {
    if (i__7493__auto___8702 < len__7492__auto___8701) {
      args__7499__auto__.push(arguments[i__7493__auto___8702]);
      var G__8703 = i__7493__auto___8702 + 1;
      i__7493__auto___8702 = G__8703;
      continue;
    } else {
    }
    break;
  }
  var argseq__7500__auto__ = 2 < args__7499__auto__.length ? new cljs.core.IndexedSeq(args__7499__auto__.slice(2), 0, null) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7500__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq8698) {
  var G__8699 = cljs.core.first(seq8698);
  var seq8698__$1 = cljs.core.next(seq8698);
  var G__8700 = cljs.core.first(seq8698__$1);
  var seq8698__$2 = cljs.core.next(seq8698__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__8699, G__8700, seq8698__$2);
};
cljs.core.Fn = function() {
};
cljs.core.IFn = function() {
};
cljs.core._invoke = function cljs$core$_invoke(var_args) {
  var args8704 = [];
  var len__7492__auto___8707 = arguments.length;
  var i__7493__auto___8708 = 0;
  while (true) {
    if (i__7493__auto___8708 < len__7492__auto___8707) {
      args8704.push(arguments[i__7493__auto___8708]);
      var G__8709 = i__7493__auto___8708 + 1;
      i__7493__auto___8708 = G__8709;
      continue;
    } else {
    }
    break;
  }
  var G__8706 = args8704.length;
  switch(G__8706) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8704.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$1 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7081__auto__.call(null, this$);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7081__auto____$1.call(null, this$);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$2 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(this$, a) : m__7081__auto__.call(null, this$, a);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, a) : m__7081__auto____$1.call(null, this$, a);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$3 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__7081__auto__.call(null, this$, a, b);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__7081__auto____$1.call(null, this$, a, b);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$4 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__7081__auto__.call(null, this$, a, b, c);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__7081__auto____$1.call(null, this$, a, b, c);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$5 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__7081__auto__.call(null, this$, a, b, c, d);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__7081__auto____$1.call(null, this$, a, b, c, d);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$6 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$6 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__7081__auto__.call(null, this$, a, b, c, d, e);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__7081__auto____$1.call(null, this$, a, b, c, d, e);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$7 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$7 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__7081__auto__.call(null, this$, a, b, c, d, e, f);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$8 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$8 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$9 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$9 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$10 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$10 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$11 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$11 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$12 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$12 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$13 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$13 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$14 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$14 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$15 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$15 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$16 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$16 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$17 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$17 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$18 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$18 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$19 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$19 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$20 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$20 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$21 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$21 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$22 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._invoke[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$22 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__7081__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    } else {
      var m__7081__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__7081__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
};
cljs.core._clone = function cljs$core$_clone(value) {
  if (!(value == null) && !(value.cljs$core$ICloneable$_clone$arity$1 == null)) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__7080__auto__ = value == null ? null : value;
    var m__7081__auto__ = cljs.core._clone[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__7081__auto__.call(null, value);
    } else {
      var m__7081__auto____$1 = cljs.core._clone["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__7081__auto____$1.call(null, value);
      } else {
        throw cljs.core.missing_protocol("ICloneable.-clone", value);
      }
    }
  }
};
cljs.core.ICounted = function() {
};
cljs.core._count = function cljs$core$_count(coll) {
  if (!(coll == null) && !(coll.cljs$core$ICounted$_count$arity$1 == null)) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._count[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._count["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ICounted.-count", coll);
      }
    }
  }
};
cljs.core.IEmptyableCollection = function() {
};
cljs.core._empty = function cljs$core$_empty(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._empty[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._empty["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
      }
    }
  }
};
cljs.core.ICollection = function() {
};
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (!(coll == null) && !(coll.cljs$core$ICollection$_conj$arity$2 == null)) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._conj[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, o) : m__7081__auto__.call(null, coll, o);
    } else {
      var m__7081__auto____$1 = cljs.core._conj["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, o) : m__7081__auto____$1.call(null, coll, o);
      } else {
        throw cljs.core.missing_protocol("ICollection.-conj", coll);
      }
    }
  }
};
cljs.core.IIndexed = function() {
};
cljs.core._nth = function cljs$core$_nth(var_args) {
  var args8711 = [];
  var len__7492__auto___8714 = arguments.length;
  var i__7493__auto___8715 = 0;
  while (true) {
    if (i__7493__auto___8715 < len__7492__auto___8714) {
      args8711.push(arguments[i__7493__auto___8715]);
      var G__8716 = i__7493__auto___8715 + 1;
      i__7493__auto___8715 = G__8716;
      continue;
    } else {
    }
    break;
  }
  var G__8713 = args8711.length;
  switch(G__8713) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8711.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$2 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._nth[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, n) : m__7081__auto__.call(null, coll, n);
    } else {
      var m__7081__auto____$1 = cljs.core._nth["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, n) : m__7081__auto____$1.call(null, coll, n);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$3 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._nth[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__7081__auto__.call(null, coll, n, not_found);
    } else {
      var m__7081__auto____$1 = cljs.core._nth["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__7081__auto____$1.call(null, coll, n, not_found);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
};
cljs.core.ISeq = function() {
};
cljs.core._first = function cljs$core$_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_first$arity$1 == null)) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._first[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._first["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-first", coll);
      }
    }
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_rest$arity$1 == null)) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._rest[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._rest["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-rest", coll);
      }
    }
  }
};
cljs.core.INext = function() {
};
cljs.core._next = function cljs$core$_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$INext$_next$arity$1 == null)) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._next[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._next["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("INext.-next", coll);
      }
    }
  }
};
cljs.core.ILookup = function() {
};
cljs.core._lookup = function cljs$core$_lookup(var_args) {
  var args8718 = [];
  var len__7492__auto___8721 = arguments.length;
  var i__7493__auto___8722 = 0;
  while (true) {
    if (i__7493__auto___8722 < len__7492__auto___8721) {
      args8718.push(arguments[i__7493__auto___8722]);
      var G__8723 = i__7493__auto___8722 + 1;
      i__7493__auto___8722 = G__8723;
      continue;
    } else {
    }
    break;
  }
  var G__8720 = args8718.length;
  switch(G__8720) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8718.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$2 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._lookup[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, k) : m__7081__auto__.call(null, o, k);
    } else {
      var m__7081__auto____$1 = cljs.core._lookup["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, k) : m__7081__auto____$1.call(null, o, k);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$3 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._lookup[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__7081__auto__.call(null, o, k, not_found);
    } else {
      var m__7081__auto____$1 = cljs.core._lookup["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__7081__auto____$1.call(null, o, k, not_found);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
};
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7081__auto__.call(null, coll, k);
    } else {
      var m__7081__auto____$1 = cljs.core._contains_key_QMARK_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7081__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
      }
    }
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_assoc$arity$3 == null)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._assoc[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__7081__auto__.call(null, coll, k, v);
    } else {
      var m__7081__auto____$1 = cljs.core._assoc["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__7081__auto____$1.call(null, coll, k, v);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
      }
    }
  }
};
cljs.core.IMap = function() {
};
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IMap$_dissoc$arity$2 == null)) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._dissoc[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7081__auto__.call(null, coll, k);
    } else {
      var m__7081__auto____$1 = cljs.core._dissoc["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7081__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IMap.-dissoc", coll);
      }
    }
  }
};
cljs.core.IMapEntry = function() {
};
cljs.core._key = function cljs$core$_key(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_key$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._key[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._key["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-key", coll);
      }
    }
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_val$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._val[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._val["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-val", coll);
      }
    }
  }
};
cljs.core.ISet = function() {
};
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (!(coll == null) && !(coll.cljs$core$ISet$_disjoin$arity$2 == null)) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._disjoin[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, v) : m__7081__auto__.call(null, coll, v);
    } else {
      var m__7081__auto____$1 = cljs.core._disjoin["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, v) : m__7081__auto____$1.call(null, coll, v);
      } else {
        throw cljs.core.missing_protocol("ISet.-disjoin", coll);
      }
    }
  }
};
cljs.core.IStack = function() {
};
cljs.core._peek = function cljs$core$_peek(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_peek$arity$1 == null)) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._peek[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._peek["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-peek", coll);
      }
    }
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_pop$arity$1 == null)) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._pop[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._pop["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-pop", coll);
      }
    }
  }
};
cljs.core.IVector = function() {
};
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (!(coll == null) && !(coll.cljs$core$IVector$_assoc_n$arity$3 == null)) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._assoc_n[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__7081__auto__.call(null, coll, n, val);
    } else {
      var m__7081__auto____$1 = cljs.core._assoc_n["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__7081__auto____$1.call(null, coll, n, val);
      } else {
        throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
      }
    }
  }
};
cljs.core.IDeref = function() {
};
cljs.core._deref = function cljs$core$_deref(o) {
  if (!(o == null) && !(o.cljs$core$IDeref$_deref$arity$1 == null)) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._deref[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto__.call(null, o);
    } else {
      var m__7081__auto____$1 = cljs.core._deref["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IDeref.-deref", o);
      }
    }
  }
};
cljs.core.IDerefWithTimeout = function() {
};
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (!(o == null) && !(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__7081__auto__.call(null, o, msec, timeout_val);
    } else {
      var m__7081__auto____$1 = cljs.core._deref_with_timeout["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__7081__auto____$1.call(null, o, msec, timeout_val);
      } else {
        throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
      }
    }
  }
};
cljs.core.IMeta = function() {
};
cljs.core._meta = function cljs$core$_meta(o) {
  if (!(o == null) && !(o.cljs$core$IMeta$_meta$arity$1 == null)) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._meta[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto__.call(null, o);
    } else {
      var m__7081__auto____$1 = cljs.core._meta["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IMeta.-meta", o);
      }
    }
  }
};
cljs.core.IWithMeta = function() {
};
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (!(o == null) && !(o.cljs$core$IWithMeta$_with_meta$arity$2 == null)) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._with_meta[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, meta) : m__7081__auto__.call(null, o, meta);
    } else {
      var m__7081__auto____$1 = cljs.core._with_meta["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, meta) : m__7081__auto____$1.call(null, o, meta);
      } else {
        throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
      }
    }
  }
};
cljs.core.IReduce = function() {
};
cljs.core._reduce = function cljs$core$_reduce(var_args) {
  var args8725 = [];
  var len__7492__auto___8728 = arguments.length;
  var i__7493__auto___8729 = 0;
  while (true) {
    if (i__7493__auto___8729 < len__7492__auto___8728) {
      args8725.push(arguments[i__7493__auto___8729]);
      var G__8730 = i__7493__auto___8729 + 1;
      i__7493__auto___8729 = G__8730;
      continue;
    } else {
    }
    break;
  }
  var G__8727 = args8725.length;
  switch(G__8727) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8725.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$2 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._reduce[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, f) : m__7081__auto__.call(null, coll, f);
    } else {
      var m__7081__auto____$1 = cljs.core._reduce["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, f) : m__7081__auto____$1.call(null, coll, f);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$3 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._reduce[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__7081__auto__.call(null, coll, f, start);
    } else {
      var m__7081__auto____$1 = cljs.core._reduce["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__7081__auto____$1.call(null, coll, f, start);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
};
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (!(coll == null) && !(coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._kv_reduce[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__7081__auto__.call(null, coll, f, init);
    } else {
      var m__7081__auto____$1 = cljs.core._kv_reduce["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__7081__auto____$1.call(null, coll, f, init);
      } else {
        throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
      }
    }
  }
};
cljs.core.IEquiv = function() {
};
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (!(o == null) && !(o.cljs$core$IEquiv$_equiv$arity$2 == null)) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._equiv[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, other) : m__7081__auto__.call(null, o, other);
    } else {
      var m__7081__auto____$1 = cljs.core._equiv["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, other) : m__7081__auto____$1.call(null, o, other);
      } else {
        throw cljs.core.missing_protocol("IEquiv.-equiv", o);
      }
    }
  }
};
cljs.core.IHash = function() {
};
cljs.core._hash = function cljs$core$_hash(o) {
  if (!(o == null) && !(o.cljs$core$IHash$_hash$arity$1 == null)) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._hash[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto__.call(null, o);
    } else {
      var m__7081__auto____$1 = cljs.core._hash["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IHash.-hash", o);
      }
    }
  }
};
cljs.core.ISeqable = function() {
};
cljs.core._seq = function cljs$core$_seq(o) {
  if (!(o == null) && !(o.cljs$core$ISeqable$_seq$arity$1 == null)) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._seq[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto__.call(null, o);
    } else {
      var m__7081__auto____$1 = cljs.core._seq["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7081__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("ISeqable.-seq", o);
      }
    }
  }
};
cljs.core.ISequential = function() {
};
cljs.core.IList = function() {
};
cljs.core.IRecord = function() {
};
cljs.core.IReversible = function() {
};
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (!(coll == null) && !(coll.cljs$core$IReversible$_rseq$arity$1 == null)) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._rseq[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._rseq["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IReversible.-rseq", coll);
      }
    }
  }
};
cljs.core.ISorted = function() {
};
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._sorted_seq[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__7081__auto__.call(null, coll, ascending_QMARK_);
    } else {
      var m__7081__auto____$1 = cljs.core._sorted_seq["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__7081__auto____$1.call(null, coll, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
      }
    }
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__7081__auto__.call(null, coll, k, ascending_QMARK_);
    } else {
      var m__7081__auto____$1 = cljs.core._sorted_seq_from["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__7081__auto____$1.call(null, coll, k, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
      }
    }
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_entry_key$arity$2 == null)) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._entry_key[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__7081__auto__.call(null, coll, entry);
    } else {
      var m__7081__auto____$1 = cljs.core._entry_key["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__7081__auto____$1.call(null, coll, entry);
      } else {
        throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
      }
    }
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_comparator$arity$1 == null)) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._comparator[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._comparator["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISorted.-comparator", coll);
      }
    }
  }
};
cljs.core.IWriter = function() {
};
cljs.core._write = function cljs$core$_write(writer, s) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_write$arity$2 == null)) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__7080__auto__ = writer == null ? null : writer;
    var m__7081__auto__ = cljs.core._write[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(writer, s) : m__7081__auto__.call(null, writer, s);
    } else {
      var m__7081__auto____$1 = cljs.core._write["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(writer, s) : m__7081__auto____$1.call(null, writer, s);
      } else {
        throw cljs.core.missing_protocol("IWriter.-write", writer);
      }
    }
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_flush$arity$1 == null)) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__7080__auto__ = writer == null ? null : writer;
    var m__7081__auto__ = cljs.core._flush[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__7081__auto__.call(null, writer);
    } else {
      var m__7081__auto____$1 = cljs.core._flush["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__7081__auto____$1.call(null, writer);
      } else {
        throw cljs.core.missing_protocol("IWriter.-flush", writer);
      }
    }
  }
};
cljs.core.IPrintWithWriter = function() {
};
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (!(o == null) && !(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._pr_writer[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__7081__auto__.call(null, o, writer, opts);
    } else {
      var m__7081__auto____$1 = cljs.core._pr_writer["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__7081__auto____$1.call(null, o, writer, opts);
      } else {
        throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
      }
    }
  }
};
cljs.core.IPending = function() {
};
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(x) {
  if (!(x == null) && !(x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)) {
    return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
  } else {
    var x__7080__auto__ = x == null ? null : x;
    var m__7081__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto__.call(null, x);
    } else {
      var m__7081__auto____$1 = cljs.core._realized_QMARK_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("IPending.-realized?", x);
      }
    }
  }
};
cljs.core.IWatchable = function() {
};
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._notify_watches[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__7081__auto__.call(null, this$, oldval, newval);
    } else {
      var m__7081__auto____$1 = cljs.core._notify_watches["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__7081__auto____$1.call(null, this$, oldval, newval);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
      }
    }
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_add_watch$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._add_watch[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__7081__auto__.call(null, this$, key, f);
    } else {
      var m__7081__auto____$1 = cljs.core._add_watch["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__7081__auto____$1.call(null, this$, key, f);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
      }
    }
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__7080__auto__ = this$ == null ? null : this$;
    var m__7081__auto__ = cljs.core._remove_watch[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(this$, key) : m__7081__auto__.call(null, this$, key);
    } else {
      var m__7081__auto____$1 = cljs.core._remove_watch["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, key) : m__7081__auto____$1.call(null, this$, key);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
      }
    }
  }
};
cljs.core.IEditableCollection = function() {
};
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._as_transient[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._as_transient["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
      }
    }
  }
};
cljs.core.ITransientCollection = function() {
};
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__7081__auto__.call(null, tcoll, val);
    } else {
      var m__7081__auto____$1 = cljs.core._conj_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__7081__auto____$1.call(null, tcoll, val);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
      }
    }
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7081__auto__.call(null, tcoll);
    } else {
      var m__7081__auto____$1 = cljs.core._persistent_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7081__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
      }
    }
  }
};
cljs.core.ITransientAssociative = function() {
};
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__7081__auto__.call(null, tcoll, key, val);
    } else {
      var m__7081__auto____$1 = cljs.core._assoc_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__7081__auto____$1.call(null, tcoll, key, val);
      } else {
        throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientMap = function() {
};
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__7081__auto__.call(null, tcoll, key);
    } else {
      var m__7081__auto____$1 = cljs.core._dissoc_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__7081__auto____$1.call(null, tcoll, key);
      } else {
        throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientVector = function() {
};
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__7081__auto__.call(null, tcoll, n, val);
    } else {
      var m__7081__auto____$1 = cljs.core._assoc_n_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__7081__auto____$1.call(null, tcoll, n, val);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
      }
    }
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7081__auto__.call(null, tcoll);
    } else {
      var m__7081__auto____$1 = cljs.core._pop_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7081__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
      }
    }
  }
};
cljs.core.ITransientSet = function() {
};
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__7080__auto__ = tcoll == null ? null : tcoll;
    var m__7081__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__7081__auto__.call(null, tcoll, v);
    } else {
      var m__7081__auto____$1 = cljs.core._disjoin_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__7081__auto____$1.call(null, tcoll, v);
      } else {
        throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
      }
    }
  }
};
cljs.core.IComparable = function() {
};
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (!(x == null) && !(x.cljs$core$IComparable$_compare$arity$2 == null)) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__7080__auto__ = x == null ? null : x;
    var m__7081__auto__ = cljs.core._compare[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(x, y) : m__7081__auto__.call(null, x, y);
    } else {
      var m__7081__auto____$1 = cljs.core._compare["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(x, y) : m__7081__auto____$1.call(null, x, y);
      } else {
        throw cljs.core.missing_protocol("IComparable.-compare", x);
      }
    }
  }
};
cljs.core.IChunk = function() {
};
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunk$_drop_first$arity$1 == null)) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._drop_first[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._drop_first["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
      }
    }
  }
};
cljs.core.IChunkedSeq = function() {
};
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._chunked_first[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._chunked_first["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
      }
    }
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._chunked_rest[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._chunked_rest["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
      }
    }
  }
};
cljs.core.IChunkedNext = function() {
};
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._chunked_next[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._chunked_next["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
      }
    }
  }
};
cljs.core.INamed = function() {
};
cljs.core._name = function cljs$core$_name(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_name$arity$1 == null)) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__7080__auto__ = x == null ? null : x;
    var m__7081__auto__ = cljs.core._name[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto__.call(null, x);
    } else {
      var m__7081__auto____$1 = cljs.core._name["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-name", x);
      }
    }
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_namespace$arity$1 == null)) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__7080__auto__ = x == null ? null : x;
    var m__7081__auto__ = cljs.core._namespace[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto__.call(null, x);
    } else {
      var m__7081__auto____$1 = cljs.core._namespace["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7081__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-namespace", x);
      }
    }
  }
};
cljs.core.IAtom = function() {
};
cljs.core.IReset = function() {
};
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IReset$_reset_BANG_$arity$2 == null)) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7081__auto__.call(null, o, new_value);
    } else {
      var m__7081__auto____$1 = cljs.core._reset_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7081__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IReset.-reset!", o);
      }
    }
  }
};
cljs.core.ISwap = function() {
};
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_(var_args) {
  var args8732 = [];
  var len__7492__auto___8735 = arguments.length;
  var i__7493__auto___8736 = 0;
  while (true) {
    if (i__7493__auto___8736 < len__7492__auto___8735) {
      args8732.push(arguments[i__7493__auto___8736]);
      var G__8737 = i__7493__auto___8736 + 1;
      i__7493__auto___8736 = G__8737;
      continue;
    } else {
    }
    break;
  }
  var G__8734 = args8732.length;
  switch(G__8734) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8732.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, f) : m__7081__auto__.call(null, o, f);
    } else {
      var m__7081__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, f) : m__7081__auto____$1.call(null, o, f);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__7081__auto__.call(null, o, f, a);
    } else {
      var m__7081__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__7081__auto____$1.call(null, o, f, a);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__7081__auto__.call(null, o, f, a, b);
    } else {
      var m__7081__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__7081__auto____$1.call(null, o, f, a, b);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__7081__auto__.call(null, o, f, a, b, xs);
    } else {
      var m__7081__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__7081__auto____$1.call(null, o, f, a, b, xs);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
};
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__7080__auto__ = o == null ? null : o;
    var m__7081__auto__ = cljs.core._vreset_BANG_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7081__auto__.call(null, o, new_value);
    } else {
      var m__7081__auto____$1 = cljs.core._vreset_BANG_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7081__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
      }
    }
  }
};
cljs.core.IIterable = function() {
};
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (!(coll == null) && !(coll.cljs$core$IIterable$_iterator$arity$1 == null)) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__7080__auto__ = coll == null ? null : coll;
    var m__7081__auto__ = cljs.core._iterator[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto__.call(null, coll);
    } else {
      var m__7081__auto____$1 = cljs.core._iterator["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7081__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IIterable.-iterator", coll);
      }
    }
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(Math.imul(4294967295, 5) === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    return Math.imul(a, b);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  return h1__$6 ^ h1__$6 >>> 16;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__8739 = i + 2;
        var G__8740 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__8739;
        h1 = G__8740;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__8743 = i + 1;
          var G__8744 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__8743;
          hash = G__8744;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  if (k == null) {
    return 0;
  } else {
    var h = cljs.core.string_hash_cache[k];
    if (typeof h === "number") {
      return h;
    } else {
      return cljs.core.add_to_string_hash_cache(k);
    }
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 4194304 || o.cljs$core$IHash$ ? true : false : false) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      if (cljs.core.truth_(isFinite(o))) {
        return Math.floor(o) % 2147483647;
      } else {
        var G__8752 = o;
        switch(G__8752) {
          case Infinity:
            return 2146435072;
            break;
          case -Infinity:
            return -1048576;
            break;
          default:
            return 2146959360;
        }
      }
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(c, x) {
  return x instanceof c;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__6405__auto__ = cljs.core.not(a.ns);
      if (and__6405__auto__) {
        return b.ns;
      } else {
        return and__6405__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__8760 = a.ns;
            var G__8761 = b.ns;
            return goog.array.defaultCompare(G__8760, G__8761);
          }();
          if (0 === nsc) {
            var G__8762 = a.name;
            var G__8763 = b.name;
            return goog.array.defaultCompare(G__8762, G__8763);
          } else {
            return nsc;
          }
        }
      } else {
        var G__8764 = a.name;
        var G__8765 = b.name;
        return goog.array.defaultCompare(G__8764, G__8765);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__8767 = null;
  var G__8767__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
  };
  var G__8767__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
  };
  G__8767 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8767__2.call(this, self__, coll);
      case 3:
        return G__8767__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8767.cljs$core$IFn$_invoke$arity$2 = G__8767__2;
  G__8767.cljs$core$IFn$_invoke$arity$3 = G__8767__3;
  return G__8767;
}();
cljs.core.Symbol.prototype.apply = function(self__, args8766) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args8766)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__6852__auto__ = self__._hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, 
  "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol(var_args) {
  var args8768 = [];
  var len__7492__auto___8771 = arguments.length;
  var i__7493__auto___8772 = 0;
  while (true) {
    if (i__7493__auto___8772 < len__7492__auto___8771) {
      args8768.push(arguments[i__7493__auto___8772]);
      var G__8773 = i__7493__auto___8772 + 1;
      i__7493__auto___8772 = G__8773;
      continue;
    } else {
    }
    break;
  }
  var G__8770 = args8768.length;
  switch(G__8770) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8768.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    var idx = name.indexOf("/");
    if (idx < 1) {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
    } else {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0, idx), name.substring(idx + 1, name.length));
    }
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 6717441;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.isMacro = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
};
cljs.core.Var.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str("#'"), cljs.core.str(self__.sym)].join("");
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Var(self__.val, self__.sym, new_meta);
};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  if (other instanceof cljs.core.Var) {
    var G__8776 = this$__$1.sym;
    var G__8777 = other.sym;
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__8776, G__8777) : cljs.core._EQ_.call(null, G__8776, G__8777);
  } else {
    return false;
  }
};
cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return cljs.core.hash_symbol(self__.sym);
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.call = function() {
  var G__8822 = null;
  var G__8822__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
  };
  var G__8822__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
  };
  var G__8822__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
  };
  var G__8822__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
  };
  var G__8822__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
  };
  var G__8822__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
  };
  var G__8822__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
  };
  var G__8822__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
  };
  var G__8822__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
  };
  var G__8822__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__8822__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__8822__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__8822__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__8822__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__8822__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__8822__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__8822__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__8822__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__8822__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__8822__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__8822__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__8822__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__8778 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    var G__8779 = a;
    var G__8780 = b;
    var G__8781 = c;
    var G__8782 = d;
    var G__8783 = e;
    var G__8784 = f;
    var G__8785 = g;
    var G__8786 = h;
    var G__8787 = i;
    var G__8788 = j;
    var G__8789 = k;
    var G__8790 = l;
    var G__8791 = m;
    var G__8792 = n;
    var G__8793 = o;
    var G__8794 = p;
    var G__8795 = q;
    var G__8796 = r;
    var G__8797 = s;
    var G__8798 = t;
    var G__8799 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8778, G__8779, G__8780, G__8781, G__8782, G__8783, G__8784, G__8785, G__8786, G__8787, G__8788, G__8789, G__8790, G__8791, G__8792, G__8793, G__8794, G__8795, G__8796, G__8797, G__8798, G__8799) : cljs.core.apply.call(null, G__8778, G__8779, G__8780, G__8781, G__8782, G__8783, G__8784, G__8785, G__8786, G__8787, G__8788, G__8789, G__8790, G__8791, G__8792, G__8793, G__8794, G__8795, G__8796, 
    G__8797, G__8798, G__8799);
  };
  G__8822 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__8822__1.call(this, self__);
      case 2:
        return G__8822__2.call(this, self__, a);
      case 3:
        return G__8822__3.call(this, self__, a, b);
      case 4:
        return G__8822__4.call(this, self__, a, b, c);
      case 5:
        return G__8822__5.call(this, self__, a, b, c, d);
      case 6:
        return G__8822__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__8822__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__8822__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__8822__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__8822__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__8822__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__8822__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__8822__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__8822__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__8822__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__8822__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__8822__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__8822__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__8822__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__8822__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__8822__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__8822__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8822.cljs$core$IFn$_invoke$arity$1 = G__8822__1;
  G__8822.cljs$core$IFn$_invoke$arity$2 = G__8822__2;
  G__8822.cljs$core$IFn$_invoke$arity$3 = G__8822__3;
  G__8822.cljs$core$IFn$_invoke$arity$4 = G__8822__4;
  G__8822.cljs$core$IFn$_invoke$arity$5 = G__8822__5;
  G__8822.cljs$core$IFn$_invoke$arity$6 = G__8822__6;
  G__8822.cljs$core$IFn$_invoke$arity$7 = G__8822__7;
  G__8822.cljs$core$IFn$_invoke$arity$8 = G__8822__8;
  G__8822.cljs$core$IFn$_invoke$arity$9 = G__8822__9;
  G__8822.cljs$core$IFn$_invoke$arity$10 = G__8822__10;
  G__8822.cljs$core$IFn$_invoke$arity$11 = G__8822__11;
  G__8822.cljs$core$IFn$_invoke$arity$12 = G__8822__12;
  G__8822.cljs$core$IFn$_invoke$arity$13 = G__8822__13;
  G__8822.cljs$core$IFn$_invoke$arity$14 = G__8822__14;
  G__8822.cljs$core$IFn$_invoke$arity$15 = G__8822__15;
  G__8822.cljs$core$IFn$_invoke$arity$16 = G__8822__16;
  G__8822.cljs$core$IFn$_invoke$arity$17 = G__8822__17;
  G__8822.cljs$core$IFn$_invoke$arity$18 = G__8822__18;
  G__8822.cljs$core$IFn$_invoke$arity$19 = G__8822__19;
  G__8822.cljs$core$IFn$_invoke$arity$20 = G__8822__20;
  G__8822.cljs$core$IFn$_invoke$arity$21 = G__8822__21;
  G__8822.cljs$core$IFn$_invoke$arity$22 = G__8822__22;
  return G__8822;
}();
cljs.core.Var.prototype.apply = function(self__, args8775) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args8775)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__8800 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  var G__8801 = a;
  var G__8802 = b;
  var G__8803 = c;
  var G__8804 = d;
  var G__8805 = e;
  var G__8806 = f;
  var G__8807 = g;
  var G__8808 = h;
  var G__8809 = i;
  var G__8810 = j;
  var G__8811 = k;
  var G__8812 = l;
  var G__8813 = m;
  var G__8814 = n;
  var G__8815 = o;
  var G__8816 = p;
  var G__8817 = q;
  var G__8818 = r;
  var G__8819 = s;
  var G__8820 = t;
  var G__8821 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8800, G__8801, G__8802, G__8803, G__8804, G__8805, G__8806, G__8807, G__8808, G__8809, G__8810, G__8811, G__8812, G__8813, G__8814, G__8815, G__8816, G__8817, G__8818, G__8819, G__8820, G__8821) : cljs.core.apply.call(null, G__8800, G__8801, G__8802, G__8803, G__8804, G__8805, G__8806, G__8807, G__8808, G__8809, G__8810, G__8811, G__8812, G__8813, G__8814, G__8815, G__8816, G__8817, G__8818, 
  G__8819, G__8820, G__8821);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  if (!(x == null)) {
    if (false || x.cljs$core$IIterable$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  if (!(value == null)) {
    if (value.cljs$lang$protocol_mask$partition1$ & 8192 || value.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!value.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || coll.cljs$core$ISeqable$ ? true : false : false) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0, null);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0, null);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 128 || coll.cljs$core$INext$ ? true : false : false) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_(var_args) {
  var args8835 = [];
  var len__7492__auto___8841 = arguments.length;
  var i__7493__auto___8842 = 0;
  while (true) {
    if (i__7493__auto___8842 < len__7492__auto___8841) {
      args8835.push(arguments[i__7493__auto___8842]);
      var G__8843 = i__7493__auto___8842 + 1;
      i__7493__auto___8842 = G__8843;
      continue;
    } else {
    }
    break;
  }
  var G__8840 = args8835.length;
  switch(G__8840) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8835.slice(2), 0, null);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__8845 = y;
        var G__8846 = cljs.core.first(more);
        var G__8847 = cljs.core.next(more);
        x = G__8845;
        y = G__8846;
        more = G__8847;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq8836) {
  var G__8837 = cljs.core.first(seq8836);
  var seq8836__$1 = cljs.core.next(seq8836);
  var G__8838 = cljs.core.first(seq8836__$1);
  var seq8836__$2 = cljs.core.next(seq8836__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8837, G__8838, seq8836__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null, self__.iter);
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__8848 = n + 1;
      var G__8849 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__8850 = cljs.core.next(coll__$1);
      n = G__8848;
      hash_code = G__8849;
      coll__$1 = G__8850;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__8851 = n + 1;
      var G__8852 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__8853 = cljs.core.next(coll__$1);
      n = G__8851;
      hash_code = G__8852;
      coll__$1 = G__8853;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__8854 = this$__$1.valueOf();
    var G__8855 = other.valueOf();
    return goog.array.defaultCompare(G__8854, G__8855);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.Inst = function() {
};
cljs.core.inst_ms_STAR_ = function cljs$core$inst_ms_STAR_(inst) {
  if (!(inst == null) && !(inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)) {
    return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
  } else {
    var x__7080__auto__ = inst == null ? null : inst;
    var m__7081__auto__ = cljs.core.inst_ms_STAR_[goog.typeOf(x__7080__auto__)];
    if (!(m__7081__auto__ == null)) {
      return m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__7081__auto__.call(null, inst);
    } else {
      var m__7081__auto____$1 = cljs.core.inst_ms_STAR_["_"];
      if (!(m__7081__auto____$1 == null)) {
        return m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__7081__auto____$1.call(null, inst);
      } else {
        throw cljs.core.missing_protocol("Inst.inst-ms*", inst);
      }
    }
  }
};
Date.prototype.cljs$core$Inst$ = true;
Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = function(inst) {
  var inst__$1 = this;
  return inst__$1.getTime();
};
cljs.core.inst_ms = function cljs$core$inst_ms(inst) {
  return cljs.core.inst_ms_STAR_(inst);
};
cljs.core.inst_QMARK_ = function cljs$core$inst_QMARK_(x) {
  if (!(x == null)) {
    if (false || x.cljs$core$Inst$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null, x);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce(var_args) {
  var args8858 = [];
  var len__7492__auto___8867 = arguments.length;
  var i__7493__auto___8868 = 0;
  while (true) {
    if (i__7493__auto___8868 < len__7492__auto___8867) {
      args8858.push(arguments[i__7493__auto___8868]);
      var G__8869 = i__7493__auto___8868 + 1;
      i__7493__auto___8868 = G__8869;
      continue;
    } else {
    }
    break;
  }
  var G__8860 = args8858.length;
  switch(G__8860) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8858.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__8861 = val;
          var G__8862 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8861, G__8862) : f.call(null, G__8861, G__8862);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__8871 = nval;
          var G__8872 = n + 1;
          val = G__8871;
          n = G__8872;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__8863 = val__$1;
        var G__8864 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8863, G__8864) : f.call(null, G__8863, G__8864);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__8873 = nval;
        var G__8874 = n + 1;
        val__$1 = G__8873;
        n = G__8874;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__8865 = val__$1;
        var G__8866 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8865, G__8866) : f.call(null, G__8865, G__8866);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__8875 = nval;
        var G__8876 = n + 1;
        val__$1 = G__8875;
        n = G__8876;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce(var_args) {
  var args8877 = [];
  var len__7492__auto___8886 = arguments.length;
  var i__7493__auto___8887 = 0;
  while (true) {
    if (i__7493__auto___8887 < len__7492__auto___8886) {
      args8877.push(arguments[i__7493__auto___8887]);
      var G__8888 = i__7493__auto___8887 + 1;
      i__7493__auto___8887 = G__8888;
      continue;
    } else {
    }
    break;
  }
  var G__8879 = args8877.length;
  switch(G__8879) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8877.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__8880 = val;
          var G__8881 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8880, G__8881) : f.call(null, G__8880, G__8881);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__8890 = nval;
          var G__8891 = n + 1;
          val = G__8890;
          n = G__8891;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__8882 = val__$1;
        var G__8883 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8882, G__8883) : f.call(null, G__8882, G__8883);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__8892 = nval;
        var G__8893 = n + 1;
        val__$1 = G__8892;
        n = G__8893;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__8884 = val__$1;
        var G__8885 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8884, G__8885) : f.call(null, G__8884, G__8885);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__8894 = nval;
        var G__8895 = n + 1;
        val__$1 = G__8894;
        n = G__8895;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2 || x.cljs$core$ICounted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16 || x.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
  }
};
cljs.core._indexOf = function cljs$core$_indexOf(var_args) {
  var args8900 = [];
  var len__7492__auto___8903 = arguments.length;
  var i__7493__auto___8904 = 0;
  while (true) {
    if (i__7493__auto___8904 < len__7492__auto___8903) {
      args8900.push(arguments[i__7493__auto___8904]);
      var G__8905 = i__7493__auto___8904 + 1;
      i__7493__auto___8904 = G__8905;
      continue;
    } else {
    }
    break;
  }
  var G__8902 = args8900.length;
  switch(G__8902) {
    case 2:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8900.length)].join(""));;
  }
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (start >= len) {
    return -1;
  } else {
    var idx = start > 0 ? start : start < 0 ? function() {
      var x__6748__auto__ = 0;
      var y__6749__auto__ = start + len;
      return x__6748__auto__ > y__6749__auto__ ? x__6748__auto__ : y__6749__auto__;
    }() : start;
    while (true) {
      if (idx < len) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__8907 = idx + 1;
          idx = G__8907;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._indexOf.cljs$lang$maxFixedArity = 3;
cljs.core._lastIndexOf = function cljs$core$_lastIndexOf(var_args) {
  var args8908 = [];
  var len__7492__auto___8911 = arguments.length;
  var i__7493__auto___8912 = 0;
  while (true) {
    if (i__7493__auto___8912 < len__7492__auto___8911) {
      args8908.push(arguments[i__7493__auto___8912]);
      var G__8913 = i__7493__auto___8912 + 1;
      i__7493__auto___8912 = G__8913;
      continue;
    } else {
    }
    break;
  }
  var G__8910 = args8908.length;
  switch(G__8910) {
    case 2:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8908.length)].join(""));;
  }
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (len === 0) {
    return -1;
  } else {
    var idx = start > 0 ? function() {
      var x__6755__auto__ = len - 1;
      var y__6756__auto__ = start;
      return x__6755__auto__ < y__6756__auto__ ? x__6755__auto__ : y__6756__auto__;
    }() : start < 0 ? len + start : start;
    while (true) {
      if (idx >= 0) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__8915 = idx - 1;
          idx = G__8915;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i, meta) {
  this.arr = arr;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 166592766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.indexOf = function() {
  var G__8916 = null;
  var G__8916__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__8916__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__8916 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__8916__1.call(this, x);
      case 2:
        return G__8916__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8916.cljs$core$IFn$_invoke$arity$1 = G__8916__1;
  G__8916.cljs$core$IFn$_invoke$arity$2 = G__8916__2;
  return G__8916;
}();
cljs.core.IndexedSeq.prototype.lastIndexOf = function() {
  var G__8917 = null;
  var G__8917__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__8917__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__8917 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__8917__1.call(this, x);
      case 2:
        return G__8917__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8917.cljs$core$IFn$_invoke$arity$1 = G__8917__1;
  G__8917.cljs$core$IFn$_invoke$arity$2 = G__8917__2;
  return G__8917;
}();
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, self__.meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__6748__auto__ = 0;
  var y__6749__auto__ = self__.arr.length - self__.i;
  return x__6748__auto__ > y__6749__auto__ ? x__6748__auto__ : y__6749__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, new_meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i, meta) {
  return new cljs.core.IndexedSeq(arr, i, meta);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq(var_args) {
  var args8918 = [];
  var len__7492__auto___8921 = arguments.length;
  var i__7493__auto___8922 = 0;
  while (true) {
    if (i__7493__auto___8922 < len__7492__auto___8921) {
      args8918.push(arguments[i__7493__auto___8922]);
      var G__8923 = i__7493__auto___8922 + 1;
      i__7493__auto___8922 = G__8923;
      continue;
    } else {
    }
    break;
  }
  var G__8920 = args8918.length;
  switch(G__8920) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8918.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i, null);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq(var_args) {
  var args8925 = [];
  var len__7492__auto___8928 = arguments.length;
  var i__7493__auto___8929 = 0;
  while (true) {
    if (i__7493__auto___8929 < len__7492__auto___8928) {
      args8925.push(arguments[i__7493__auto___8929]);
      var G__8930 = i__7493__auto___8929 + 1;
      i__7493__auto___8929 = G__8930;
      continue;
    } else {
    }
    break;
  }
  var G__8927 = args8925.length;
  switch(G__8927) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8925.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.indexOf = function() {
  var G__8934 = null;
  var G__8934__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__8934__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__8934 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__8934__1.call(this, x);
      case 2:
        return G__8934__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8934.cljs$core$IFn$_invoke$arity$1 = G__8934__1;
  G__8934.cljs$core$IFn$_invoke$arity$2 = G__8934__2;
  return G__8934;
}();
cljs.core.RSeq.prototype.lastIndexOf = function() {
  var G__8935 = null;
  var G__8935__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__8935__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__8935 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__8935__1.call(this, x);
      case 2:
        return G__8935__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__8935.cljs$core$IFn$_invoke$arity$1 = G__8935__1;
  G__8935.cljs$core$IFn$_invoke$arity$2 = G__8935__2;
  return G__8935;
}();
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__8932 = cljs.core.List.EMPTY;
  var G__8933 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__8932, G__8933) : cljs.core.with_meta.call(null, G__8932, G__8933);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, col__$1) : cljs.core.seq_reduce.call(null, f, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, col__$1) : cljs.core.seq_reduce.call(null, f, start, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__8936 = sn;
      s = G__8936;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj(var_args) {
  var args8937 = [];
  var len__7492__auto___8943 = arguments.length;
  var i__7493__auto___8944 = 0;
  while (true) {
    if (i__7493__auto___8944 < len__7492__auto___8943) {
      args8937.push(arguments[i__7493__auto___8944]);
      var G__8945 = i__7493__auto___8944 + 1;
      i__7493__auto___8944 = G__8945;
      continue;
    } else {
    }
    break;
  }
  var G__8942 = args8937.length;
  switch(G__8942) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8937.slice(2), 0, null);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    var x__7251__auto__ = x;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7251__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__8947 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__8948 = cljs.core.first(xs);
      var G__8949 = cljs.core.next(xs);
      coll = G__8947;
      x = G__8948;
      xs = G__8949;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq8938) {
  var G__8939 = cljs.core.first(seq8938);
  var seq8938__$1 = cljs.core.next(seq8938);
  var G__8940 = cljs.core.first(seq8938__$1);
  var seq8938__$2 = cljs.core.next(seq8938__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__8939, G__8940, seq8938__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__8950 = cljs.core.next(s);
      var G__8951 = acc + 1;
      s = G__8950;
      acc = G__8951;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 2 || coll.cljs$core$ICounted$ ? true : false : false) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || coll.cljs$core$ISeqable$ ? true : false : false) {
            return cljs.core.accumulating_seq_count(coll);
          } else {
            return cljs.core._count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth(var_args) {
  var args8956 = [];
  var len__7492__auto___8959 = arguments.length;
  var i__7493__auto___8960 = 0;
  while (true) {
    if (i__7493__auto___8960 < len__7492__auto___8959) {
      args8956.push(arguments[i__7493__auto___8960]);
      var G__8961 = i__7493__auto___8960 + 1;
      i__7493__auto___8960 = G__8961;
      continue;
    } else {
    }
    break;
  }
  var G__8958 = args8956.length;
  switch(G__8958) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8956.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__8963 = cljs.core.next(coll);
            var G__8964 = n - 1;
            coll = G__8963;
            n = G__8964;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__8965 = cljs.core.next(coll);
            var G__8966 = n - 1;
            var G__8967 = not_found;
            coll = G__8965;
            n = G__8966;
            not_found = G__8967;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth(var_args) {
  var args8968 = [];
  var len__7492__auto___8975 = arguments.length;
  var i__7493__auto___8976 = 0;
  while (true) {
    if (i__7493__auto___8976 < len__7492__auto___8975) {
      args8968.push(arguments[i__7493__auto___8976]);
      var G__8977 = i__7493__auto___8976 + 1;
      i__7493__auto___8976 = G__8977;
      continue;
    } else {
    }
    break;
  }
  var G__8970 = args8968.length;
  switch(G__8970) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8968.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll.charAt(n);
            } else {
              return null;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll.charAt(n);
            } else {
              return not_found;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__8979 = n__$1 - 1;
      var G__8980 = cljs.core.rest(xs);
      n__$1 = G__8979;
      xs = G__8980;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get(var_args) {
  var args8981 = [];
  var len__7492__auto___8986 = arguments.length;
  var i__7493__auto___8987 = 0;
  while (true) {
    if (i__7493__auto___8987 < len__7492__auto___8986) {
      args8981.push(arguments[i__7493__auto___8987]);
      var G__8988 = i__7493__auto___8987 + 1;
      i__7493__auto___8987 = G__8988;
      continue;
    } else {
    }
    break;
  }
  var G__8983 = args8981.length;
  switch(G__8983) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args8981.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc(var_args) {
  var args8990 = [];
  var len__7492__auto___8997 = arguments.length;
  var i__7493__auto___8998 = 0;
  while (true) {
    if (i__7493__auto___8998 < len__7492__auto___8997) {
      args8990.push(arguments[i__7493__auto___8998]);
      var G__8999 = i__7493__auto___8998 + 1;
      i__7493__auto___8998 = G__8999;
      continue;
    } else {
    }
    break;
  }
  var G__8996 = args8990.length;
  switch(G__8996) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args8990.slice(3), 0, null);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__9001 = ret;
      var G__9002 = cljs.core.first(kvs);
      var G__9003 = cljs.core.second(kvs);
      var G__9004 = cljs.core.nnext(kvs);
      coll = G__9001;
      k = G__9002;
      v = G__9003;
      kvs = G__9004;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq8991) {
  var G__8992 = cljs.core.first(seq8991);
  var seq8991__$1 = cljs.core.next(seq8991);
  var G__8993 = cljs.core.first(seq8991__$1);
  var seq8991__$2 = cljs.core.next(seq8991__$1);
  var G__8994 = cljs.core.first(seq8991__$2);
  var seq8991__$3 = cljs.core.next(seq8991__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__8992, G__8993, G__8994, seq8991__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc(var_args) {
  var args9005 = [];
  var len__7492__auto___9011 = arguments.length;
  var i__7493__auto___9012 = 0;
  while (true) {
    if (i__7493__auto___9012 < len__7492__auto___9011) {
      args9005.push(arguments[i__7493__auto___9012]);
      var G__9013 = i__7493__auto___9012 + 1;
      i__7493__auto___9012 = G__9013;
      continue;
    } else {
    }
    break;
  }
  var G__9010 = args9005.length;
  switch(G__9010) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9005.slice(2), 0, null);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9015 = ret;
        var G__9016 = cljs.core.first(ks);
        var G__9017 = cljs.core.next(ks);
        coll = G__9015;
        k = G__9016;
        ks = G__9017;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq9006) {
  var G__9007 = cljs.core.first(seq9006);
  var seq9006__$1 = cljs.core.next(seq9006);
  var G__9008 = cljs.core.first(seq9006__$1);
  var seq9006__$2 = cljs.core.next(seq9006__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__9007, G__9008, seq9006__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__6417__auto__ = goog.isFunction(f);
  if (or__6417__auto__) {
    return or__6417__auto__;
  } else {
    if (!(f == null)) {
      if (false || f.cljs$core$Fn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.call = function() {
  var G__9023 = null;
  var G__9023__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__9023__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
  };
  var G__9023__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
  };
  var G__9023__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
  };
  var G__9023__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
  };
  var G__9023__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
  };
  var G__9023__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
  };
  var G__9023__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
  };
  var G__9023__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
  };
  var G__9023__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__9023__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__9023__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__9023__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__9023__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__9023__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__9023__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__9023__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__9023__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__9023__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__9023__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__9023__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__9023__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  };
  G__9023 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__9023__1.call(this, self__);
      case 2:
        return G__9023__2.call(this, self__, a);
      case 3:
        return G__9023__3.call(this, self__, a, b);
      case 4:
        return G__9023__4.call(this, self__, a, b, c);
      case 5:
        return G__9023__5.call(this, self__, a, b, c, d);
      case 6:
        return G__9023__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__9023__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__9023__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__9023__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__9023__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__9023__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__9023__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__9023__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__9023__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__9023__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__9023__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__9023__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__9023__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__9023__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__9023__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__9023__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__9023__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9023.cljs$core$IFn$_invoke$arity$1 = G__9023__1;
  G__9023.cljs$core$IFn$_invoke$arity$2 = G__9023__2;
  G__9023.cljs$core$IFn$_invoke$arity$3 = G__9023__3;
  G__9023.cljs$core$IFn$_invoke$arity$4 = G__9023__4;
  G__9023.cljs$core$IFn$_invoke$arity$5 = G__9023__5;
  G__9023.cljs$core$IFn$_invoke$arity$6 = G__9023__6;
  G__9023.cljs$core$IFn$_invoke$arity$7 = G__9023__7;
  G__9023.cljs$core$IFn$_invoke$arity$8 = G__9023__8;
  G__9023.cljs$core$IFn$_invoke$arity$9 = G__9023__9;
  G__9023.cljs$core$IFn$_invoke$arity$10 = G__9023__10;
  G__9023.cljs$core$IFn$_invoke$arity$11 = G__9023__11;
  G__9023.cljs$core$IFn$_invoke$arity$12 = G__9023__12;
  G__9023.cljs$core$IFn$_invoke$arity$13 = G__9023__13;
  G__9023.cljs$core$IFn$_invoke$arity$14 = G__9023__14;
  G__9023.cljs$core$IFn$_invoke$arity$15 = G__9023__15;
  G__9023.cljs$core$IFn$_invoke$arity$16 = G__9023__16;
  G__9023.cljs$core$IFn$_invoke$arity$17 = G__9023__17;
  G__9023.cljs$core$IFn$_invoke$arity$18 = G__9023__18;
  G__9023.cljs$core$IFn$_invoke$arity$19 = G__9023__19;
  G__9023.cljs$core$IFn$_invoke$arity$20 = G__9023__20;
  G__9023.cljs$core$IFn$_invoke$arity$21 = G__9023__21;
  G__9023.cljs$core$IFn$_invoke$arity$22 = G__9023__22;
  return G__9023;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args9022) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9022)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (goog.isFunction(o)) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__6405__auto__ = !(o == null);
    if (and__6405__auto__) {
      if (!(o == null)) {
        if (o.cljs$lang$protocol_mask$partition0$ & 131072 || o.cljs$core$IMeta$) {
          return true;
        } else {
          if (!o.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
      }
    } else {
      return and__6405__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj(var_args) {
  var args9028 = [];
  var len__7492__auto___9034 = arguments.length;
  var i__7493__auto___9035 = 0;
  while (true) {
    if (i__7493__auto___9035 < len__7492__auto___9034) {
      args9028.push(arguments[i__7493__auto___9035]);
      var G__9036 = i__7493__auto___9035 + 1;
      i__7493__auto___9035 = G__9036;
      continue;
    } else {
    }
    break;
  }
  var G__9033 = args9028.length;
  switch(G__9033) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9028.slice(2), 0, null);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9038 = ret;
        var G__9039 = cljs.core.first(ks);
        var G__9040 = cljs.core.next(ks);
        coll = G__9038;
        k = G__9039;
        ks = G__9040;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq9029) {
  var G__9030 = cljs.core.first(seq9029);
  var seq9029__$1 = cljs.core.next(seq9029);
  var G__9031 = cljs.core.first(seq9029__$1);
  var seq9029__$2 = cljs.core.next(seq9029__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__9030, G__9031, seq9029__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 8 || x.cljs$core$ICollection$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 4096 || x.cljs$core$ISet$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 512 || x.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16777216 || x.cljs$core$ISequential$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 268435456 || x.cljs$core$ISorted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 524288 || x.cljs$core$IReduce$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 1024 || x.cljs$core$IMap$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 67108864 || x.cljs$core$IRecord$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16384 || x.cljs$core$IVector$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 512 || x.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj(var_args) {
  var args9061 = [];
  var len__7492__auto___9067 = arguments.length;
  var i__7493__auto___9068 = 0;
  while (true) {
    if (i__7493__auto___9068 < len__7492__auto___9067) {
      args9061.push(arguments[i__7493__auto___9068]);
      var G__9069 = i__7493__auto___9068 + 1;
      i__7493__auto___9068 = G__9069;
      continue;
    } else {
    }
    break;
  }
  var G__9064 = args9061.length;
  switch(G__9064) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9061.slice(0), 0, null);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__7511__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  return {};
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create, keyvals) : cljs.core.apply.call(null, goog.object.create, keyvals);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq9062) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9062));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__9073_9075 = obj;
  var G__9074_9076 = function(G__9073_9075, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__9073_9075, keys);
  goog.object.forEach(G__9073_9075, G__9074_9076);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9077 = i__$1 + 1;
      var G__9078 = j__$1 + 1;
      var G__9079 = len__$1 - 1;
      i__$1 = G__9077;
      j__$1 = G__9078;
      len__$1 = G__9079;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9080 = i__$1 - 1;
      var G__9081 = j__$1 - 1;
      var G__9082 = len__$1 - 1;
      i__$1 = G__9080;
      j__$1 = G__9081;
      len__$1 = G__9082;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.boolean_QMARK_ = function cljs$core$boolean_QMARK_(x) {
  return x === true || x === false;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    if (!(s == null)) {
      if (s.cljs$lang$protocol_mask$partition0$ & 64 || s.cljs$core$ISeq$) {
        return true;
      } else {
        if (!s.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  if (!(s == null)) {
    if (s.cljs$lang$protocol_mask$partition0$ & 8388608 || s.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!s.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (x == null) {
    return false;
  } else {
    if (x === false) {
      return false;
    } else {
      return true;
    }
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__6417__auto__ = cljs.core.fn_QMARK_(f);
  if (or__6417__auto__) {
    return or__6417__auto__;
  } else {
    if (!(f == null)) {
      if (f.cljs$lang$protocol_mask$partition0$ & 1 || f.cljs$core$IFn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && !isNaN(n) && !(n === Infinity) && parseFloat(n) === parseInt(n, 10);
};
cljs.core.int_QMARK_ = function cljs$core$int_QMARK_(x) {
  return cljs.core.integer_QMARK_(x) || x instanceof goog.math.Integer || x instanceof goog.math.Long;
};
cljs.core.pos_int_QMARK_ = function cljs$core$pos_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x > 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
    } else {
      if (x instanceof goog.math.Long) {
        return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
      } else {
        return false;
      }
    }
  }
};
cljs.core.neg_int_QMARK_ = function cljs$core$neg_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x < 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return x.isNegative();
    } else {
      if (x instanceof goog.math.Long) {
        return x.isNegative();
      } else {
        return false;
      }
    }
  }
};
cljs.core.nat_int_QMARK_ = function cljs$core$nat_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return !(x < 0) || x === 0;
  } else {
    if (x instanceof goog.math.Integer) {
      var or__6417__auto__ = cljs.core.not(x.isNegative());
      if (or__6417__auto__) {
        return or__6417__auto__;
      } else {
        return x.isZero();
      }
    } else {
      if (x instanceof goog.math.Long) {
        var or__6417__auto__ = cljs.core.not(x.isNegative());
        if (or__6417__auto__) {
          return or__6417__auto__;
        } else {
          return x.isZero();
        }
      } else {
        return false;
      }
    }
  }
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_(var_args) {
  var args9093 = [];
  var len__7492__auto___9099 = arguments.length;
  var i__7493__auto___9100 = 0;
  while (true) {
    if (i__7493__auto___9100 < len__7492__auto___9099) {
      args9093.push(arguments[i__7493__auto___9100]);
      var G__9101 = i__7493__auto___9100 + 1;
      i__7493__auto___9100 = G__9101;
      continue;
    } else {
    }
    break;
  }
  var G__9098 = args9093.length;
  switch(G__9098) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9093.slice(2), 0, null);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__9103 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__9104 = etc;
          s = G__9103;
          xs = G__9104;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq9094) {
  var G__9095 = cljs.core.first(seq9094);
  var seq9094__$1 = cljs.core.next(seq9094);
  var G__9096 = cljs.core.first(seq9094__$1);
  var seq9094__$2 = cljs.core.next(seq9094__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__9095, G__9096, seq9094__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            return goog.array.defaultCompare(x, y);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 2048 || x.cljs$core$IComparable$ ? true : !x.cljs$lang$protocol_mask$partition1$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x)) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              return goog.array.defaultCompare(x, y);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed(var_args) {
  var args9107 = [];
  var len__7492__auto___9110 = arguments.length;
  var i__7493__auto___9111 = 0;
  while (true) {
    if (i__7493__auto___9111 < len__7492__auto___9110) {
      args9107.push(arguments[i__7493__auto___9111]);
      var G__9112 = i__7493__auto___9111 + 1;
      i__7493__auto___9111 = G__9112;
      continue;
    } else {
    }
    break;
  }
  var G__9109 = args9107.length;
  switch(G__9109) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9107.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__9114 = xs;
      var G__9115 = ys;
      var G__9116 = len;
      var G__9117 = n + 1;
      xs = G__9114;
      ys = G__9115;
      len = G__9116;
      n = G__9117;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y, x) : f.call(null, y, x))) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort(var_args) {
  var args9118 = [];
  var len__7492__auto___9123 = arguments.length;
  var i__7493__auto___9124 = 0;
  while (true) {
    if (i__7493__auto___9124 < len__7492__auto___9123) {
      args9118.push(arguments[i__7493__auto___9124]);
      var G__9125 = i__7493__auto___9124 + 1;
      i__7493__auto___9124 = G__9125;
      continue;
    } else {
    }
    break;
  }
  var G__9120 = args9118.length;
  switch(G__9120) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9118.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
    var G__9121_9127 = a;
    var G__9122_9128 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__9121_9127, G__9122_9128);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by(var_args) {
  var args9129 = [];
  var len__7492__auto___9132 = arguments.length;
  var i__7493__auto___9133 = 0;
  while (true) {
    if (i__7493__auto___9133 < len__7492__auto___9132) {
      args9129.push(arguments[i__7493__auto___9133]);
      var G__9134 = i__7493__auto___9133 + 1;
      i__7493__auto___9133 = G__9134;
      continue;
    } else {
    }
    break;
  }
  var G__9131 = args9129.length;
  switch(G__9131) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9129.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x), keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y));
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce(var_args) {
  var args9136 = [];
  var len__7492__auto___9144 = arguments.length;
  var i__7493__auto___9145 = 0;
  while (true) {
    if (i__7493__auto___9145 < len__7492__auto___9144) {
      args9136.push(arguments[i__7493__auto___9145]);
      var G__9146 = i__7493__auto___9145 + 1;
      i__7493__auto___9145 = G__9146;
      continue;
    } else {
    }
    break;
  }
  var G__9138 = args9136.length;
  switch(G__9138) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9136.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4655__auto__ = cljs.core.seq(coll);
  if (temp__4655__auto__) {
    var s = temp__4655__auto__;
    var G__9139 = f;
    var G__9140 = cljs.core.first(s);
    var G__9141 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__9139, G__9140, G__9141) : cljs.core.reduce.call(null, G__9139, G__9140, G__9141);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__9142 = val__$1;
        var G__9143 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9142, G__9143) : f.call(null, G__9142, G__9143);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9148 = nval;
        var G__9149 = cljs.core.next(coll__$1);
        val__$1 = G__9148;
        coll__$1 = G__9149;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a);
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null, a);
};
cljs.core.reduce = function cljs$core$reduce(var_args) {
  var args9150 = [];
  var len__7492__auto___9155 = arguments.length;
  var i__7493__auto___9156 = 0;
  while (true) {
    if (i__7493__auto___9156 < len__7492__auto___9155) {
      args9150.push(arguments[i__7493__auto___9156]);
      var G__9157 = i__7493__auto___9156 + 1;
      i__7493__auto___9156 = G__9157;
      continue;
    } else {
    }
    break;
  }
  var G__9152 = args9150.length;
  switch(G__9152) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9150.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing(var_args) {
  var args9159 = [];
  var len__7492__auto___9162 = arguments.length;
  var i__7493__auto___9163 = 0;
  while (true) {
    if (i__7493__auto___9163 < len__7492__auto___9162) {
      args9159.push(arguments[i__7493__auto___9163]);
      var G__9164 = i__7493__auto___9163 + 1;
      i__7493__auto___9163 = G__9164;
      continue;
    } else {
    }
    break;
  }
  var G__9161 = args9159.length;
  switch(G__9161) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9159.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__9166 = null;
    var G__9166__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__9166__1 = function(x) {
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x);
    };
    var G__9166__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
    };
    G__9166 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__9166__0.call(this);
        case 1:
          return G__9166__1.call(this, x);
        case 2:
          return G__9166__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9166.cljs$core$IFn$_invoke$arity$0 = G__9166__0;
    G__9166.cljs$core$IFn$_invoke$arity$1 = G__9166__1;
    G__9166.cljs$core$IFn$_invoke$arity$2 = G__9166__2;
    return G__9166;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce(var_args) {
  var args9167 = [];
  var len__7492__auto___9170 = arguments.length;
  var i__7493__auto___9171 = 0;
  while (true) {
    if (i__7493__auto___9171 < len__7492__auto___9170) {
      args9167.push(arguments[i__7493__auto___9171]);
      var G__9172 = i__7493__auto___9171 + 1;
      i__7493__auto___9171 = G__9172;
      continue;
    } else {
    }
    break;
  }
  var G__9169 = args9167.length;
  switch(G__9169) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9167.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f);
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_(var_args) {
  var args9174 = [];
  var len__7492__auto___9180 = arguments.length;
  var i__7493__auto___9181 = 0;
  while (true) {
    if (i__7493__auto___9181 < len__7492__auto___9180) {
      args9174.push(arguments[i__7493__auto___9181]);
      var G__9182 = i__7493__auto___9181 + 1;
      i__7493__auto___9181 = G__9182;
      continue;
    } else {
    }
    break;
  }
  var G__9179 = args9174.length;
  switch(G__9179) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9174.slice(2), 0, null);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq9175) {
  var G__9176 = cljs.core.first(seq9175);
  var seq9175__$1 = cljs.core.next(seq9175);
  var G__9177 = cljs.core.first(seq9175__$1);
  var seq9175__$2 = cljs.core.next(seq9175__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__9176, G__9177, seq9175__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_(var_args) {
  var args9184 = [];
  var len__7492__auto___9190 = arguments.length;
  var i__7493__auto___9191 = 0;
  while (true) {
    if (i__7493__auto___9191 < len__7492__auto___9190) {
      args9184.push(arguments[i__7493__auto___9191]);
      var G__9192 = i__7493__auto___9191 + 1;
      i__7493__auto___9191 = G__9192;
      continue;
    } else {
    }
    break;
  }
  var G__9189 = args9184.length;
  switch(G__9189) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9184.slice(2), 0, null);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq9185) {
  var G__9186 = cljs.core.first(seq9185);
  var seq9185__$1 = cljs.core.next(seq9185);
  var G__9187 = cljs.core.first(seq9185__$1);
  var seq9185__$2 = cljs.core.next(seq9185__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__9186, G__9187, seq9185__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_(var_args) {
  var args9194 = [];
  var len__7492__auto___9200 = arguments.length;
  var i__7493__auto___9201 = 0;
  while (true) {
    if (i__7493__auto___9201 < len__7492__auto___9200) {
      args9194.push(arguments[i__7493__auto___9201]);
      var G__9202 = i__7493__auto___9201 + 1;
      i__7493__auto___9201 = G__9202;
      continue;
    } else {
    }
    break;
  }
  var G__9199 = args9194.length;
  switch(G__9199) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9194.slice(2), 0, null);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq9195) {
  var G__9196 = cljs.core.first(seq9195);
  var seq9195__$1 = cljs.core.next(seq9195);
  var G__9197 = cljs.core.first(seq9195__$1);
  var seq9195__$2 = cljs.core.next(seq9195__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__9196, G__9197, seq9195__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_(var_args) {
  var args9204 = [];
  var len__7492__auto___9210 = arguments.length;
  var i__7493__auto___9211 = 0;
  while (true) {
    if (i__7493__auto___9211 < len__7492__auto___9210) {
      args9204.push(arguments[i__7493__auto___9211]);
      var G__9212 = i__7493__auto___9211 + 1;
      i__7493__auto___9211 = G__9212;
      continue;
    } else {
    }
    break;
  }
  var G__9209 = args9204.length;
  switch(G__9209) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9204.slice(2), 0, null);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq9205) {
  var G__9206 = cljs.core.first(seq9205);
  var seq9205__$1 = cljs.core.next(seq9205);
  var G__9207 = cljs.core.first(seq9205__$1);
  var seq9205__$2 = cljs.core.next(seq9205__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__9206, G__9207, seq9205__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_(var_args) {
  var args9214 = [];
  var len__7492__auto___9220 = arguments.length;
  var i__7493__auto___9221 = 0;
  while (true) {
    if (i__7493__auto___9221 < len__7492__auto___9220) {
      args9214.push(arguments[i__7493__auto___9221]);
      var G__9222 = i__7493__auto___9221 + 1;
      i__7493__auto___9221 = G__9222;
      continue;
    } else {
    }
    break;
  }
  var G__9219 = args9214.length;
  switch(G__9219) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9214.slice(2), 0, null);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__9224 = y;
        var G__9225 = cljs.core.first(more);
        var G__9226 = cljs.core.next(more);
        x = G__9224;
        y = G__9225;
        more = G__9226;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq9215) {
  var G__9216 = cljs.core.first(seq9215);
  var seq9215__$1 = cljs.core.next(seq9215);
  var G__9217 = cljs.core.first(seq9215__$1);
  var seq9215__$2 = cljs.core.next(seq9215__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__9216, G__9217, seq9215__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_(var_args) {
  var args9227 = [];
  var len__7492__auto___9233 = arguments.length;
  var i__7493__auto___9234 = 0;
  while (true) {
    if (i__7493__auto___9234 < len__7492__auto___9233) {
      args9227.push(arguments[i__7493__auto___9234]);
      var G__9235 = i__7493__auto___9234 + 1;
      i__7493__auto___9234 = G__9235;
      continue;
    } else {
    }
    break;
  }
  var G__9232 = args9227.length;
  switch(G__9232) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9227.slice(2), 0, null);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__9237 = y;
        var G__9238 = cljs.core.first(more);
        var G__9239 = cljs.core.next(more);
        x = G__9237;
        y = G__9238;
        more = G__9239;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq9228) {
  var G__9229 = cljs.core.first(seq9228);
  var seq9228__$1 = cljs.core.next(seq9228);
  var G__9230 = cljs.core.first(seq9228__$1);
  var seq9228__$2 = cljs.core.next(seq9228__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9229, G__9230, seq9228__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_(var_args) {
  var args9240 = [];
  var len__7492__auto___9246 = arguments.length;
  var i__7493__auto___9247 = 0;
  while (true) {
    if (i__7493__auto___9247 < len__7492__auto___9246) {
      args9240.push(arguments[i__7493__auto___9247]);
      var G__9248 = i__7493__auto___9247 + 1;
      i__7493__auto___9247 = G__9248;
      continue;
    } else {
    }
    break;
  }
  var G__9245 = args9240.length;
  switch(G__9245) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9240.slice(2), 0, null);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__9250 = y;
        var G__9251 = cljs.core.first(more);
        var G__9252 = cljs.core.next(more);
        x = G__9250;
        y = G__9251;
        more = G__9252;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq9241) {
  var G__9242 = cljs.core.first(seq9241);
  var seq9241__$1 = cljs.core.next(seq9241);
  var G__9243 = cljs.core.first(seq9241__$1);
  var seq9241__$2 = cljs.core.next(seq9241__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__9242, G__9243, seq9241__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_(var_args) {
  var args9253 = [];
  var len__7492__auto___9259 = arguments.length;
  var i__7493__auto___9260 = 0;
  while (true) {
    if (i__7493__auto___9260 < len__7492__auto___9259) {
      args9253.push(arguments[i__7493__auto___9260]);
      var G__9261 = i__7493__auto___9260 + 1;
      i__7493__auto___9260 = G__9261;
      continue;
    } else {
    }
    break;
  }
  var G__9258 = args9253.length;
  switch(G__9258) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9253.slice(2), 0, null);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__9263 = y;
        var G__9264 = cljs.core.first(more);
        var G__9265 = cljs.core.next(more);
        x = G__9263;
        y = G__9264;
        more = G__9265;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq9254) {
  var G__9255 = cljs.core.first(seq9254);
  var seq9254__$1 = cljs.core.next(seq9254);
  var G__9256 = cljs.core.first(seq9254__$1);
  var seq9254__$2 = cljs.core.next(seq9254__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9255, G__9256, seq9254__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max(var_args) {
  var args9266 = [];
  var len__7492__auto___9272 = arguments.length;
  var i__7493__auto___9273 = 0;
  while (true) {
    if (i__7493__auto___9273 < len__7492__auto___9272) {
      args9266.push(arguments[i__7493__auto___9273]);
      var G__9274 = i__7493__auto___9273 + 1;
      i__7493__auto___9273 = G__9274;
      continue;
    } else {
    }
    break;
  }
  var G__9271 = args9266.length;
  switch(G__9271) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9266.slice(2), 0, null);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__6748__auto__ = x;
  var y__6749__auto__ = y;
  return x__6748__auto__ > y__6749__auto__ ? x__6748__auto__ : y__6749__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__6748__auto__ = x;
    var y__6749__auto__ = y;
    return x__6748__auto__ > y__6749__auto__ ? x__6748__auto__ : y__6749__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq9267) {
  var G__9268 = cljs.core.first(seq9267);
  var seq9267__$1 = cljs.core.next(seq9267);
  var G__9269 = cljs.core.first(seq9267__$1);
  var seq9267__$2 = cljs.core.next(seq9267__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__9268, G__9269, seq9267__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min(var_args) {
  var args9276 = [];
  var len__7492__auto___9282 = arguments.length;
  var i__7493__auto___9283 = 0;
  while (true) {
    if (i__7493__auto___9283 < len__7492__auto___9282) {
      args9276.push(arguments[i__7493__auto___9283]);
      var G__9284 = i__7493__auto___9283 + 1;
      i__7493__auto___9283 = G__9284;
      continue;
    } else {
    }
    break;
  }
  var G__9281 = args9276.length;
  switch(G__9281) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9276.slice(2), 0, null);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__6755__auto__ = x;
  var y__6756__auto__ = y;
  return x__6755__auto__ < y__6756__auto__ ? x__6755__auto__ : y__6756__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__6755__auto__ = x;
    var y__6756__auto__ = y;
    return x__6755__auto__ < y__6756__auto__ ? x__6755__auto__ : y__6756__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq9277) {
  var G__9278 = cljs.core.first(seq9277);
  var seq9277__$1 = cljs.core.next(seq9277);
  var G__9279 = cljs.core.first(seq9277__$1);
  var seq9277__$2 = cljs.core.next(seq9277__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__9278, G__9279, seq9277__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add(var_args) {
  var args9286 = [];
  var len__7492__auto___9292 = arguments.length;
  var i__7493__auto___9293 = 0;
  while (true) {
    if (i__7493__auto___9293 < len__7492__auto___9292) {
      args9286.push(arguments[i__7493__auto___9293]);
      var G__9294 = i__7493__auto___9293 + 1;
      i__7493__auto___9293 = G__9294;
      continue;
    } else {
    }
    break;
  }
  var G__9291 = args9286.length;
  switch(G__9291) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9286.slice(2), 0, null);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq9287) {
  var G__9288 = cljs.core.first(seq9287);
  var seq9287__$1 = cljs.core.next(seq9287);
  var G__9289 = cljs.core.first(seq9287__$1);
  var seq9287__$2 = cljs.core.next(seq9287__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__9288, G__9289, seq9287__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int(var_args) {
  var args9296 = [];
  var len__7492__auto___9302 = arguments.length;
  var i__7493__auto___9303 = 0;
  while (true) {
    if (i__7493__auto___9303 < len__7492__auto___9302) {
      args9296.push(arguments[i__7493__auto___9303]);
      var G__9304 = i__7493__auto___9303 + 1;
      i__7493__auto___9303 = G__9304;
      continue;
    } else {
    }
    break;
  }
  var G__9301 = args9296.length;
  switch(G__9301) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9296.slice(2), 0, null);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq9297) {
  var G__9298 = cljs.core.first(seq9297);
  var seq9297__$1 = cljs.core.next(seq9297);
  var G__9299 = cljs.core.first(seq9297__$1);
  var seq9297__$2 = cljs.core.next(seq9297__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__9298, G__9299, seq9297__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int(var_args) {
  var args9306 = [];
  var len__7492__auto___9312 = arguments.length;
  var i__7493__auto___9313 = 0;
  while (true) {
    if (i__7493__auto___9313 < len__7492__auto___9312) {
      args9306.push(arguments[i__7493__auto___9313]);
      var G__9314 = i__7493__auto___9313 + 1;
      i__7493__auto___9313 = G__9314;
      continue;
    } else {
    }
    break;
  }
  var G__9311 = args9306.length;
  switch(G__9311) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9306.slice(2), 0, null);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq9307) {
  var G__9308 = cljs.core.first(seq9307);
  var seq9307__$1 = cljs.core.next(seq9307);
  var G__9309 = cljs.core.first(seq9307__$1);
  var seq9307__$2 = cljs.core.next(seq9307__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__9308, G__9309, seq9307__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply(var_args) {
  var args9316 = [];
  var len__7492__auto___9322 = arguments.length;
  var i__7493__auto___9323 = 0;
  while (true) {
    if (i__7493__auto___9323 < len__7492__auto___9322) {
      args9316.push(arguments[i__7493__auto___9323]);
      var G__9324 = i__7493__auto___9323 + 1;
      i__7493__auto___9323 = G__9324;
      continue;
    } else {
    }
    break;
  }
  var G__9321 = args9316.length;
  switch(G__9321) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9316.slice(2), 0, null);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq9317) {
  var G__9318 = cljs.core.first(seq9317);
  var seq9317__$1 = cljs.core.next(seq9317);
  var G__9319 = cljs.core.first(seq9317__$1);
  var seq9317__$2 = cljs.core.next(seq9317__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__9318, G__9319, seq9317__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int(var_args) {
  var args9326 = [];
  var len__7492__auto___9332 = arguments.length;
  var i__7493__auto___9333 = 0;
  while (true) {
    if (i__7493__auto___9333 < len__7492__auto___9332) {
      args9326.push(arguments[i__7493__auto___9333]);
      var G__9334 = i__7493__auto___9333 + 1;
      i__7493__auto___9333 = G__9334;
      continue;
    } else {
    }
    break;
  }
  var G__9331 = args9326.length;
  switch(G__9331) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9326.slice(2), 0, null);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq9327) {
  var G__9328 = cljs.core.first(seq9327);
  var seq9327__$1 = cljs.core.next(seq9327);
  var G__9329 = cljs.core.first(seq9327__$1);
  var seq9327__$2 = cljs.core.next(seq9327__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__9328, G__9329, seq9327__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x, n) : cljs.core.mod.call(null, x, n);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract(var_args) {
  var args9336 = [];
  var len__7492__auto___9342 = arguments.length;
  var i__7493__auto___9343 = 0;
  while (true) {
    if (i__7493__auto___9343 < len__7492__auto___9342) {
      args9336.push(arguments[i__7493__auto___9343]);
      var G__9344 = i__7493__auto___9343 + 1;
      i__7493__auto___9343 = G__9344;
      continue;
    } else {
    }
    break;
  }
  var G__9341 = args9336.length;
  switch(G__9341) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9336.slice(2), 0, null);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq9337) {
  var G__9338 = cljs.core.first(seq9337);
  var seq9337__$1 = cljs.core.next(seq9337);
  var G__9339 = cljs.core.first(seq9337__$1);
  var seq9337__$2 = cljs.core.next(seq9337__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__9338, G__9339, seq9337__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int(var_args) {
  var args9346 = [];
  var len__7492__auto___9352 = arguments.length;
  var i__7493__auto___9353 = 0;
  while (true) {
    if (i__7493__auto___9353 < len__7492__auto___9352) {
      args9346.push(arguments[i__7493__auto___9353]);
      var G__9354 = i__7493__auto___9353 + 1;
      i__7493__auto___9353 = G__9354;
      continue;
    } else {
    }
    break;
  }
  var G__9351 = args9346.length;
  switch(G__9351) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9346.slice(2), 0, null);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq9347) {
  var G__9348 = cljs.core.first(seq9347);
  var seq9347__$1 = cljs.core.next(seq9347);
  var G__9349 = cljs.core.first(seq9347__$1);
  var seq9347__$2 = cljs.core.next(seq9347__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__9348, G__9349, seq9347__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    return Math.floor(q);
  } else {
    return Math.ceil(q);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor(var_args) {
  var args9356 = [];
  var len__7492__auto___9362 = arguments.length;
  var i__7493__auto___9363 = 0;
  while (true) {
    if (i__7493__auto___9363 < len__7492__auto___9362) {
      args9356.push(arguments[i__7493__auto___9363]);
      var G__9364 = i__7493__auto___9363 + 1;
      i__7493__auto___9363 = G__9364;
      continue;
    } else {
    }
    break;
  }
  var G__9361 = args9356.length;
  switch(G__9361) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9356.slice(2), 0, null);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq9357) {
  var G__9358 = cljs.core.first(seq9357);
  var seq9357__$1 = cljs.core.next(seq9357);
  var G__9359 = cljs.core.first(seq9357__$1);
  var seq9357__$2 = cljs.core.next(seq9357__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__9358, G__9359, seq9357__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and(var_args) {
  var args9366 = [];
  var len__7492__auto___9372 = arguments.length;
  var i__7493__auto___9373 = 0;
  while (true) {
    if (i__7493__auto___9373 < len__7492__auto___9372) {
      args9366.push(arguments[i__7493__auto___9373]);
      var G__9374 = i__7493__auto___9373 + 1;
      i__7493__auto___9373 = G__9374;
      continue;
    } else {
    }
    break;
  }
  var G__9371 = args9366.length;
  switch(G__9371) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9366.slice(2), 0, null);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq9367) {
  var G__9368 = cljs.core.first(seq9367);
  var seq9367__$1 = cljs.core.next(seq9367);
  var G__9369 = cljs.core.first(seq9367__$1);
  var seq9367__$2 = cljs.core.next(seq9367__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__9368, G__9369, seq9367__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or(var_args) {
  var args9376 = [];
  var len__7492__auto___9382 = arguments.length;
  var i__7493__auto___9383 = 0;
  while (true) {
    if (i__7493__auto___9383 < len__7492__auto___9382) {
      args9376.push(arguments[i__7493__auto___9383]);
      var G__9384 = i__7493__auto___9383 + 1;
      i__7493__auto___9383 = G__9384;
      continue;
    } else {
    }
    break;
  }
  var G__9381 = args9376.length;
  switch(G__9381) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9376.slice(2), 0, null);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq9377) {
  var G__9378 = cljs.core.first(seq9377);
  var seq9377__$1 = cljs.core.next(seq9377);
  var G__9379 = cljs.core.first(seq9377__$1);
  var seq9377__$2 = cljs.core.next(seq9377__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__9378, G__9379, seq9377__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not(var_args) {
  var args9386 = [];
  var len__7492__auto___9392 = arguments.length;
  var i__7493__auto___9393 = 0;
  while (true) {
    if (i__7493__auto___9393 < len__7492__auto___9392) {
      args9386.push(arguments[i__7493__auto___9393]);
      var G__9394 = i__7493__auto___9393 + 1;
      i__7493__auto___9393 = G__9394;
      continue;
    } else {
    }
    break;
  }
  var G__9391 = args9386.length;
  switch(G__9391) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9386.slice(2), 0, null);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq9387) {
  var G__9388 = cljs.core.first(seq9387);
  var seq9387__$1 = cljs.core.next(seq9387);
  var G__9389 = cljs.core.first(seq9387__$1);
  var seq9387__$2 = cljs.core.next(seq9387__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__9388, G__9389, seq9387__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_(var_args) {
  var args9396 = [];
  var len__7492__auto___9402 = arguments.length;
  var i__7493__auto___9403 = 0;
  while (true) {
    if (i__7493__auto___9403 < len__7492__auto___9402) {
      args9396.push(arguments[i__7493__auto___9403]);
      var G__9404 = i__7493__auto___9403 + 1;
      i__7493__auto___9403 = G__9404;
      continue;
    } else {
    }
    break;
  }
  var G__9401 = args9396.length;
  switch(G__9401) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9396.slice(2), 0, null);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__9406 = y;
        var G__9407 = cljs.core.first(more);
        var G__9408 = cljs.core.next(more);
        x = G__9406;
        y = G__9407;
        more = G__9408;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq9397) {
  var G__9398 = cljs.core.first(seq9397);
  var seq9397__$1 = cljs.core.next(seq9397);
  var G__9399 = cljs.core.first(seq9397__$1);
  var seq9397__$2 = cljs.core.next(seq9397__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9398, G__9399, seq9397__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(x) {
  return x > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(x) {
  return x === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__9409 = n__$1 - 1;
      var G__9410 = cljs.core.next(xs);
      n__$1 = G__9409;
      xs = G__9410;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str(var_args) {
  var args9411 = [];
  var len__7492__auto___9416 = arguments.length;
  var i__7493__auto___9417 = 0;
  while (true) {
    if (i__7493__auto___9417 < len__7492__auto___9416) {
      args9411.push(arguments[i__7493__auto___9417]);
      var G__9418 = i__7493__auto___9417 + 1;
      i__7493__auto___9417 = G__9418;
      continue;
    } else {
    }
    break;
  }
  var G__9415 = args9411.length;
  switch(G__9415) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9411.slice(1), 0, null);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7511__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    return [x].join("");
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__9420 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__9421 = cljs.core.next(more);
      sb = G__9420;
      more = G__9421;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq9412) {
  var G__9413 = cljs.core.first(seq9412);
  var seq9412__$1 = cljs.core.next(seq9412);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__9413, seq9412__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs(var_args) {
  var args9422 = [];
  var len__7492__auto___9425 = arguments.length;
  var i__7493__auto___9426 = 0;
  while (true) {
    if (i__7493__auto___9426 < len__7492__auto___9425) {
      args9422.push(arguments[i__7493__auto___9426]);
      var G__9427 = i__7493__auto___9426 + 1;
      i__7493__auto___9426 = G__9427;
      continue;
    } else {
    }
    break;
  }
  var G__9424 = args9422.length;
  switch(G__9424) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9422.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__9429 = cljs.core.next(xs);
            var G__9430 = cljs.core.next(ys);
            xs = G__9429;
            ys = G__9430;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__9431 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__9432 = cljs.core.next(s);
        res = G__9431;
        s = G__9432;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__9433 = (h + (cljs.core.hash(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)) ^ cljs.core.hash(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)))) % 4503599627370496;
      var G__9434 = cljs.core.next(s);
      h = G__9433;
      s = G__9434;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__9435 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__9436 = cljs.core.next(s__$1);
      h = G__9435;
      s__$1 = G__9436;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__9447_9457 = cljs.core.seq(fn_map);
  var chunk__9448_9458 = null;
  var count__9449_9459 = 0;
  var i__9450_9460 = 0;
  while (true) {
    if (i__9450_9460 < count__9449_9459) {
      var vec__9451_9461 = chunk__9448_9458.cljs$core$IIndexed$_nth$arity$2(null, i__9450_9460);
      var key_name_9462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9451_9461, 0, null);
      var f_9463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9451_9461, 1, null);
      var str_name_9464 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_9462) : cljs.core.name.call(null, key_name_9462);
      obj[str_name_9464] = f_9463;
      var G__9465 = seq__9447_9457;
      var G__9466 = chunk__9448_9458;
      var G__9467 = count__9449_9459;
      var G__9468 = i__9450_9460 + 1;
      seq__9447_9457 = G__9465;
      chunk__9448_9458 = G__9466;
      count__9449_9459 = G__9467;
      i__9450_9460 = G__9468;
      continue;
    } else {
      var temp__4657__auto___9469 = cljs.core.seq(seq__9447_9457);
      if (temp__4657__auto___9469) {
        var seq__9447_9470__$1 = temp__4657__auto___9469;
        if (cljs.core.chunked_seq_QMARK_(seq__9447_9470__$1)) {
          var c__7228__auto___9471 = cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__9447_9470__$1) : cljs.core.chunk_first.call(null, seq__9447_9470__$1);
          var G__9472 = cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__9447_9470__$1) : cljs.core.chunk_rest.call(null, seq__9447_9470__$1);
          var G__9473 = c__7228__auto___9471;
          var G__9474 = cljs.core.count(c__7228__auto___9471);
          var G__9475 = 0;
          seq__9447_9457 = G__9472;
          chunk__9448_9458 = G__9473;
          count__9449_9459 = G__9474;
          i__9450_9460 = G__9475;
          continue;
        } else {
          var vec__9454_9476 = cljs.core.first(seq__9447_9470__$1);
          var key_name_9477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9454_9476, 0, null);
          var f_9478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9454_9476, 1, null);
          var str_name_9479 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_9477) : cljs.core.name.call(null, key_name_9477);
          obj[str_name_9479] = f_9478;
          var G__9480 = cljs.core.next(seq__9447_9470__$1);
          var G__9481 = null;
          var G__9482 = 0;
          var G__9483 = 0;
          seq__9447_9457 = G__9480;
          chunk__9448_9458 = G__9481;
          count__9449_9459 = G__9482;
          i__9450_9460 = G__9483;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.indexOf = function() {
  var G__9484 = null;
  var G__9484__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9484__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9484 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9484__1.call(this, x);
      case 2:
        return G__9484__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9484.cljs$core$IFn$_invoke$arity$1 = G__9484__1;
  G__9484.cljs$core$IFn$_invoke$arity$2 = G__9484__2;
  return G__9484;
}();
cljs.core.List.prototype.lastIndexOf = function() {
  var G__9485 = null;
  var G__9485__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count);
  };
  var G__9485__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9485 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9485__1.call(this, x);
      case 2:
        return G__9485__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9485.cljs$core$IFn$_invoke$arity$1 = G__9485__1;
  G__9485.cljs$core$IFn$_invoke$arity$2 = G__9485__2;
  return G__9485;
}();
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 33554432 || x.cljs$core$IList$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
  }
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.indexOf = function() {
  var G__9488 = null;
  var G__9488__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9488__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9488 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9488__1.call(this, x);
      case 2:
        return G__9488__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9488.cljs$core$IFn$_invoke$arity$1 = G__9488__1;
  G__9488.cljs$core$IFn$_invoke$arity$2 = G__9488__2;
  return G__9488;
}();
cljs.core.EmptyList.prototype.lastIndexOf = function() {
  var G__9489 = null;
  var G__9489__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__9489__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9489 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9489__1.call(this, x);
      case 2:
        return G__9489__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9489.cljs$core$IFn$_invoke$arity$1 = G__9489__1;
  G__9489.cljs$core$IFn$_invoke$arity$2 = G__9489__2;
  return G__9489;
}();
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.list_QMARK_(other) || cljs.core.sequential_QMARK_(other)) {
    return cljs.core.seq(other) == null;
  } else {
    return false;
  }
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  if (!(coll == null)) {
    if (coll.cljs$lang$protocol_mask$partition0$ & 134217728 || coll.cljs$core$IReversible$) {
      return true;
    } else {
      if (!coll.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
  }
};
cljs.core.rseq = function cljs$core$rseq(rev) {
  return cljs.core._rseq(rev);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list(var_args) {
  var args__7499__auto__ = [];
  var len__7492__auto___9493 = arguments.length;
  var i__7493__auto___9494 = 0;
  while (true) {
    if (i__7493__auto___9494 < len__7492__auto___9493) {
      args__7499__auto__.push(arguments[i__7493__auto___9494]);
      var G__9495 = i__7493__auto___9494 + 1;
      i__7493__auto___9494 = G__9495;
      continue;
    } else {
    }
    break;
  }
  var argseq__7500__auto__ = 0 < args__7499__auto__.length ? new cljs.core.IndexedSeq(args__7499__auto__.slice(0), 0, null) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__9496 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__9496;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__9497 = i - 1;
      var G__9498 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__9497;
      r = G__9498;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq9492) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9492));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.indexOf = function() {
  var G__9499 = null;
  var G__9499__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9499__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9499 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9499__1.call(this, x);
      case 2:
        return G__9499__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9499.cljs$core$IFn$_invoke$arity$1 = G__9499__1;
  G__9499.cljs$core$IFn$_invoke$arity$2 = G__9499__2;
  return G__9499;
}();
cljs.core.Cons.prototype.lastIndexOf = function() {
  var G__9500 = null;
  var G__9500__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__9500__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9500 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9500__1.call(this, x);
      case 2:
        return G__9500__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9500.cljs$core$IFn$_invoke$arity$1 = G__9500__1;
  G__9500.cljs$core$IFn$_invoke$arity$2 = G__9500__2;
  return G__9500;
}();
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, null);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__6417__auto__ = coll == null;
    if (or__6417__auto__) {
      return or__6417__auto__;
    } else {
      if (!(coll == null)) {
        if (coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__6405__auto__ = cljs.core.not(a.ns);
      if (and__6405__auto__) {
        return b.ns;
      } else {
        return and__6405__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__9511 = a.ns;
            var G__9512 = b.ns;
            return goog.array.defaultCompare(G__9511, G__9512);
          }();
          if (0 === nsc) {
            var G__9513 = a.name;
            var G__9514 = b.name;
            return goog.array.defaultCompare(G__9513, G__9514);
          } else {
            return nsc;
          }
        }
      } else {
        var G__9515 = a.name;
        var G__9516 = b.name;
        return goog.array.defaultCompare(G__9515, G__9516);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__9518 = null;
  var G__9518__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__9518__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__9518 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9518__2.call(this, self__, coll);
      case 3:
        return G__9518__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9518.cljs$core$IFn$_invoke$arity$2 = G__9518__2;
  G__9518.cljs$core$IFn$_invoke$arity$3 = G__9518__3;
  return G__9518;
}();
cljs.core.Keyword.prototype.apply = function(self__, args9517) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9517)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__6852__auto__ = self__._hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.symbol_identical_QMARK_ = function cljs$core$symbol_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Symbol && y instanceof cljs.core.Symbol) {
      return x.str === y.str;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 4096 || x.cljs$core$INamed$ ? true : false : false) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.ident_QMARK_ = function cljs$core$ident_QMARK_(x) {
  return x instanceof cljs.core.Keyword || x instanceof cljs.core.Symbol;
};
cljs.core.simple_ident_QMARK_ = function cljs$core$simple_ident_QMARK_(x) {
  return cljs.core.ident_QMARK_(x) && cljs.core.namespace(x) == null;
};
cljs.core.qualified_ident_QMARK_ = function cljs$core$qualified_ident_QMARK_(x) {
  var and__6405__auto__ = cljs.core.ident_QMARK_(x);
  if (and__6405__auto__) {
    var and__6405__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__6405__auto____$1)) {
      return true;
    } else {
      return and__6405__auto____$1;
    }
  } else {
    return and__6405__auto__;
  }
};
cljs.core.simple_symbol_QMARK_ = function cljs$core$simple_symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol && cljs.core.namespace(x) == null;
};
cljs.core.qualified_symbol_QMARK_ = function cljs$core$qualified_symbol_QMARK_(x) {
  var and__6405__auto__ = x instanceof cljs.core.Symbol;
  if (and__6405__auto__) {
    var and__6405__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__6405__auto____$1)) {
      return true;
    } else {
      return and__6405__auto____$1;
    }
  } else {
    return and__6405__auto__;
  }
};
cljs.core.simple_keyword_QMARK_ = function cljs$core$simple_keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword && cljs.core.namespace(x) == null;
};
cljs.core.qualified_keyword_QMARK_ = function cljs$core$qualified_keyword_QMARK_(x) {
  var and__6405__auto__ = x instanceof cljs.core.Keyword;
  if (and__6405__auto__) {
    var and__6405__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__6405__auto____$1)) {
      return true;
    } else {
      return and__6405__auto____$1;
    }
  } else {
    return and__6405__auto__;
  }
};
cljs.core.keyword = function cljs$core$keyword(var_args) {
  var args9521 = [];
  var len__7492__auto___9524 = arguments.length;
  var i__7493__auto___9525 = 0;
  while (true) {
    if (i__7493__auto___9525 < len__7492__auto___9524) {
      args9521.push(arguments[i__7493__auto___9525]);
      var G__9526 = i__7493__auto___9525 + 1;
      i__7493__auto___9525 = G__9526;
      continue;
    } else {
    }
    break;
  }
  var G__9523 = args9521.length;
  switch(G__9523) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9521.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.indexOf = function() {
  var G__9528 = null;
  var G__9528__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9528__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9528 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9528__1.call(this, x);
      case 2:
        return G__9528__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9528.cljs$core$IFn$_invoke$arity$1 = G__9528__1;
  G__9528.cljs$core$IFn$_invoke$arity$2 = G__9528__2;
  return G__9528;
}();
cljs.core.LazySeq.prototype.lastIndexOf = function() {
  var G__9529 = null;
  var G__9529__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__9529__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9529 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9529__1.call(this, x);
      case 2:
        return G__9529__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9529.cljs$core$IFn$_invoke$arity$1 = G__9529__1;
  G__9529.cljs$core$IFn$_invoke$arity$2 = G__9529__2;
  return G__9529;
}();
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.not(self__.fn);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__9530 = ls.sval();
        ls = G__9530;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk(var_args) {
  var args9531 = [];
  var len__7492__auto___9534 = arguments.length;
  var i__7493__auto___9535 = 0;
  while (true) {
    if (i__7493__auto___9535 < len__7492__auto___9534) {
      args9531.push(arguments[i__7493__auto___9535]);
      var G__9536 = i__7493__auto___9535 + 1;
      i__7493__auto___9535 = G__9536;
      continue;
    } else {
    }
    break;
  }
  var G__9533 = args9531.length;
  switch(G__9533) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9531.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.indexOf = function() {
  var G__9538 = null;
  var G__9538__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9538__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9538 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9538__1.call(this, x);
      case 2:
        return G__9538__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9538.cljs$core$IFn$_invoke$arity$1 = G__9538__1;
  G__9538.cljs$core$IFn$_invoke$arity$2 = G__9538__2;
  return G__9538;
}();
cljs.core.ChunkedCons.prototype.lastIndexOf = function() {
  var G__9539 = null;
  var G__9539__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__9539__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9539 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9539__1.call(this, x);
      case 2:
        return G__9539__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9539.cljs$core$IFn$_invoke$arity$1 = G__9539__1;
  G__9539.cljs$core$IFn$_invoke$arity$2 = G__9539__2;
  return G__9539;
}();
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (!(s == null) ? s.cljs$lang$protocol_mask$partition1$ & 1024 || s.cljs$core$IChunkedNext$ ? true : false : false) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__9542 = cljs.core.next(s__$1);
      s__$1 = G__9542;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_9543 = 0;
  var xs_9544 = cljs.core.seq(coll);
  while (true) {
    if (xs_9544) {
      ret[i_9543] = cljs.core.to_array(cljs.core.first(xs_9544));
      var G__9545 = i_9543 + 1;
      var G__9546 = cljs.core.next(xs_9544);
      i_9543 = G__9545;
      xs_9544 = G__9546;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array(var_args) {
  var args9547 = [];
  var len__7492__auto___9550 = arguments.length;
  var i__7493__auto___9551 = 0;
  while (true) {
    if (i__7493__auto___9551 < len__7492__auto___9550) {
      args9547.push(arguments[i__7493__auto___9551]);
      var G__9552 = i__7493__auto___9551 + 1;
      i__7493__auto___9551 = G__9552;
      continue;
    } else {
    }
    break;
  }
  var G__9549 = args9547.length;
  switch(G__9549) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9547.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__9554 = i + 1;
        var G__9555 = cljs.core.next(s__$1);
        i = G__9554;
        s__$1 = G__9555;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7332__auto___9556 = size;
    var i_9557 = 0;
    while (true) {
      if (i_9557 < n__7332__auto___9556) {
        a[i_9557] = init_val_or_seq;
        var G__9558 = i_9557 + 1;
        i_9557 = G__9558;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array(var_args) {
  var args9559 = [];
  var len__7492__auto___9562 = arguments.length;
  var i__7493__auto___9563 = 0;
  while (true) {
    if (i__7493__auto___9563 < len__7492__auto___9562) {
      args9559.push(arguments[i__7493__auto___9563]);
      var G__9564 = i__7493__auto___9563 + 1;
      i__7493__auto___9563 = G__9564;
      continue;
    } else {
    }
    break;
  }
  var G__9561 = args9559.length;
  switch(G__9561) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9559.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__9566 = i + 1;
        var G__9567 = cljs.core.next(s__$1);
        i = G__9566;
        s__$1 = G__9567;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7332__auto___9568 = size;
    var i_9569 = 0;
    while (true) {
      if (i_9569 < n__7332__auto___9568) {
        a[i_9569] = init_val_or_seq;
        var G__9570 = i_9569 + 1;
        i_9569 = G__9570;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array(var_args) {
  var args9571 = [];
  var len__7492__auto___9574 = arguments.length;
  var i__7493__auto___9575 = 0;
  while (true) {
    if (i__7493__auto___9575 < len__7492__auto___9574) {
      args9571.push(arguments[i__7493__auto___9575]);
      var G__9576 = i__7493__auto___9575 + 1;
      i__7493__auto___9575 = G__9576;
      continue;
    } else {
    }
    break;
  }
  var G__9573 = args9571.length;
  switch(G__9573) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9571.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__9578 = i + 1;
        var G__9579 = cljs.core.next(s__$1);
        i = G__9578;
        s__$1 = G__9579;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7332__auto___9580 = size;
    var i_9581 = 0;
    while (true) {
      if (i_9581 < n__7332__auto___9580) {
        a[i_9581] = init_val_or_seq;
        var G__9582 = i_9581 + 1;
        i_9581 = G__9582;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array(var_args) {
  var args9583 = [];
  var len__7492__auto___9586 = arguments.length;
  var i__7493__auto___9587 = 0;
  while (true) {
    if (i__7493__auto___9587 < len__7492__auto___9586) {
      args9583.push(arguments[i__7493__auto___9587]);
      var G__9588 = i__7493__auto___9587 + 1;
      i__7493__auto___9587 = G__9588;
      continue;
    } else {
    }
    break;
  }
  var G__9585 = args9583.length;
  switch(G__9585) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9583.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__9590 = i + 1;
        var G__9591 = cljs.core.next(s__$1);
        i = G__9590;
        s__$1 = G__9591;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7332__auto___9592 = size;
    var i_9593 = 0;
    while (true) {
      if (i_9593 < n__7332__auto___9592) {
        a[i_9593] = init_val_or_seq;
        var G__9594 = i_9593 + 1;
        i_9593 = G__9594;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(n, coll) {
  if (cljs.core.counted_QMARK_(coll)) {
    return cljs.core.count(coll);
  } else {
    var i = 0;
    var s = cljs.core.seq(coll);
    while (true) {
      if (!(s == null) && i < n) {
        var G__9595 = i + 1;
        var G__9596 = cljs.core.next(s);
        i = G__9595;
        s = G__9596;
        continue;
      } else {
        return i;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat(var_args) {
  var args9598 = [];
  var len__7492__auto___9610 = arguments.length;
  var i__7493__auto___9611 = 0;
  while (true) {
    if (i__7493__auto___9611 < len__7492__auto___9610) {
      args9598.push(arguments[i__7493__auto___9611]);
      var G__9612 = i__7493__auto___9611 + 1;
      i__7493__auto___9611 = G__9612;
      continue;
    } else {
    }
    break;
  }
  var G__9603 = args9598.length;
  switch(G__9603) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9598.slice(2), 0, null);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq9599) {
  var G__9600 = cljs.core.first(seq9599);
  var seq9599__$1 = cljs.core.next(seq9599);
  var G__9601 = cljs.core.first(seq9599__$1);
  var seq9599__$2 = cljs.core.next(seq9599__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__9600, G__9601, seq9599__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_(var_args) {
  var args9614 = [];
  var len__7492__auto___9622 = arguments.length;
  var i__7493__auto___9623 = 0;
  while (true) {
    if (i__7493__auto___9623 < len__7492__auto___9622) {
      args9614.push(arguments[i__7493__auto___9623]);
      var G__9624 = i__7493__auto___9623 + 1;
      i__7493__auto___9623 = G__9624;
      continue;
    } else {
    }
    break;
  }
  var G__9621 = args9614.length;
  switch(G__9621) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9614.slice(4), 0, null);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7511__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq9615) {
  var G__9616 = cljs.core.first(seq9615);
  var seq9615__$1 = cljs.core.next(seq9615);
  var G__9617 = cljs.core.first(seq9615__$1);
  var seq9615__$2 = cljs.core.next(seq9615__$1);
  var G__9618 = cljs.core.first(seq9615__$2);
  var seq9615__$3 = cljs.core.next(seq9615__$2);
  var G__9619 = cljs.core.first(seq9615__$3);
  var seq9615__$4 = cljs.core.next(seq9615__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__9616, G__9617, G__9618, G__9619, seq9615__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_(var_args) {
  var args9626 = [];
  var len__7492__auto___9632 = arguments.length;
  var i__7493__auto___9633 = 0;
  while (true) {
    if (i__7493__auto___9633 < len__7492__auto___9632) {
      args9626.push(arguments[i__7493__auto___9633]);
      var G__9634 = i__7493__auto___9633 + 1;
      i__7493__auto___9633 = G__9634;
      continue;
    } else {
    }
    break;
  }
  var G__9631 = args9626.length;
  switch(G__9631) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9626.slice(2), 0, null);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(tcoll) {
  return tcoll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__9636 = ntcoll;
      var G__9637 = cljs.core.first(vals);
      var G__9638 = cljs.core.next(vals);
      tcoll = G__9636;
      val = G__9637;
      vals = G__9638;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq9627) {
  var G__9628 = cljs.core.first(seq9627);
  var seq9627__$1 = cljs.core.next(seq9627);
  var G__9629 = cljs.core.first(seq9627__$1);
  var seq9627__$2 = cljs.core.next(seq9627__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9628, G__9629, seq9627__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_(var_args) {
  var args9639 = [];
  var len__7492__auto___9646 = arguments.length;
  var i__7493__auto___9647 = 0;
  while (true) {
    if (i__7493__auto___9647 < len__7492__auto___9646) {
      args9639.push(arguments[i__7493__auto___9647]);
      var G__9648 = i__7493__auto___9647 + 1;
      i__7493__auto___9647 = G__9648;
      continue;
    } else {
    }
    break;
  }
  var G__9645 = args9639.length;
  switch(G__9645) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9639.slice(3), 0, null);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__9650 = ntcoll;
      var G__9651 = cljs.core.first(kvs);
      var G__9652 = cljs.core.second(kvs);
      var G__9653 = cljs.core.nnext(kvs);
      tcoll = G__9650;
      key = G__9651;
      val = G__9652;
      kvs = G__9653;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq9640) {
  var G__9641 = cljs.core.first(seq9640);
  var seq9640__$1 = cljs.core.next(seq9640);
  var G__9642 = cljs.core.first(seq9640__$1);
  var seq9640__$2 = cljs.core.next(seq9640__$1);
  var G__9643 = cljs.core.first(seq9640__$2);
  var seq9640__$3 = cljs.core.next(seq9640__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9641, G__9642, G__9643, seq9640__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_(var_args) {
  var args9654 = [];
  var len__7492__auto___9660 = arguments.length;
  var i__7493__auto___9661 = 0;
  while (true) {
    if (i__7493__auto___9661 < len__7492__auto___9660) {
      args9654.push(arguments[i__7493__auto___9661]);
      var G__9662 = i__7493__auto___9661 + 1;
      i__7493__auto___9661 = G__9662;
      continue;
    } else {
    }
    break;
  }
  var G__9659 = args9654.length;
  switch(G__9659) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9654.slice(2), 0, null);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__9664 = ntcoll;
      var G__9665 = cljs.core.first(ks);
      var G__9666 = cljs.core.next(ks);
      tcoll = G__9664;
      key = G__9665;
      ks = G__9666;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq9655) {
  var G__9656 = cljs.core.first(seq9655);
  var seq9655__$1 = cljs.core.next(seq9655);
  var G__9657 = cljs.core.first(seq9655__$1);
  var seq9655__$2 = cljs.core.next(seq9655__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9656, G__9657, seq9655__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_(var_args) {
  var args9667 = [];
  var len__7492__auto___9673 = arguments.length;
  var i__7493__auto___9674 = 0;
  while (true) {
    if (i__7493__auto___9674 < len__7492__auto___9673) {
      args9667.push(arguments[i__7493__auto___9674]);
      var G__9675 = i__7493__auto___9674 + 1;
      i__7493__auto___9674 = G__9675;
      continue;
    } else {
    }
    break;
  }
  var G__9672 = args9667.length;
  switch(G__9672) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9667.slice(2), 0, null);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__9677 = ntcoll;
      var G__9678 = cljs.core.first(vals);
      var G__9679 = cljs.core.next(vals);
      tcoll = G__9677;
      val = G__9678;
      vals = G__9679;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq9668) {
  var G__9669 = cljs.core.first(seq9668);
  var seq9668__$1 = cljs.core.next(seq9668);
  var G__9670 = cljs.core.first(seq9668__$1);
  var seq9668__$2 = cljs.core.next(seq9668__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9669, G__9670, seq9668__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a7376 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a7376);
      } else {
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a7376) : f.call(null, a7376);
      }
    } else {
      var b7377 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a7376, b7377);
        } else {
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a7376, b7377) : f.call(null, a7376, b7377);
        }
      } else {
        var c7378 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a7376, b7377, c7378);
          } else {
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a7376, b7377, c7378) : f.call(null, a7376, b7377, c7378);
          }
        } else {
          var d7379 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a7376, b7377, c7378, d7379);
            } else {
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a7376, b7377, c7378, d7379) : f.call(null, a7376, b7377, c7378, d7379);
            }
          } else {
            var e7380 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a7376, b7377, c7378, d7379, e7380);
              } else {
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a7376, b7377, c7378, d7379, e7380) : f.call(null, a7376, b7377, c7378, d7379, e7380);
              }
            } else {
              var f7381 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a7376, b7377, c7378, d7379, e7380, f7381);
                } else {
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a7376, b7377, c7378, d7379, e7380, f7381) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381);
                }
              } else {
                var g7382 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a7376, b7377, c7378, d7379, e7380, f7381, g7382);
                  } else {
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a7376, b7377, c7378, d7379, e7380, f7381, g7382) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382);
                  }
                } else {
                  var h7383 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383);
                    } else {
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383);
                    }
                  } else {
                    var i7384 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384);
                      } else {
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384);
                      }
                    } else {
                      var j7385 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385);
                        } else {
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385);
                        }
                      } else {
                        var k7386 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386);
                          } else {
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386);
                          }
                        } else {
                          var l7387 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387);
                            } else {
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387);
                            }
                          } else {
                            var m7388 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388);
                              } else {
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388);
                              }
                            } else {
                              var n7389 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389);
                                } else {
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389);
                                }
                              } else {
                                var o7390 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390);
                                  } else {
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390);
                                  }
                                } else {
                                  var p7391 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391);
                                    } else {
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391);
                                    }
                                  } else {
                                    var q7392 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392);
                                      } else {
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392);
                                      }
                                    } else {
                                      var r7393 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393);
                                        } else {
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393);
                                        }
                                      } else {
                                        var s7394 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394);
                                          } else {
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394);
                                          }
                                        } else {
                                          var t7395 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394, t7395);
                                            } else {
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394, t7395) : f.call(null, a7376, b7377, c7378, d7379, e7380, f7381, g7382, h7383, i7384, j7385, k7386, l7387, m7388, n7389, o7390, p7391, q7392, r7393, s7394, t7395);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply(var_args) {
  var args9680 = [];
  var len__7492__auto___9689 = arguments.length;
  var i__7493__auto___9690 = 0;
  while (true) {
    if (i__7493__auto___9690 < len__7492__auto___9689) {
      args9680.push(arguments[i__7493__auto___9690]);
      var G__9691 = i__7493__auto___9690 + 1;
      i__7493__auto___9690 = G__9691;
      continue;
    } else {
    }
    break;
  }
  var G__9688 = args9680.length;
  switch(G__9688) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9680.slice(5), 0, null);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__7511__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq9681) {
  var G__9682 = cljs.core.first(seq9681);
  var seq9681__$1 = cljs.core.next(seq9681);
  var G__9683 = cljs.core.first(seq9681__$1);
  var seq9681__$2 = cljs.core.next(seq9681__$1);
  var G__9684 = cljs.core.first(seq9681__$2);
  var seq9681__$3 = cljs.core.next(seq9681__$2);
  var G__9685 = cljs.core.first(seq9681__$3);
  var seq9681__$4 = cljs.core.next(seq9681__$3);
  var G__9686 = cljs.core.first(seq9681__$4);
  var seq9681__$5 = cljs.core.next(seq9681__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__9682, G__9683, G__9684, G__9685, G__9686, seq9681__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta(var_args) {
  var args9693 = [];
  var len__7492__auto___9718 = arguments.length;
  var i__7493__auto___9719 = 0;
  while (true) {
    if (i__7493__auto___9719 < len__7492__auto___9718) {
      args9693.push(arguments[i__7493__auto___9719]);
      var G__9720 = i__7493__auto___9719 + 1;
      i__7493__auto___9719 = G__9720;
      continue;
    } else {
    }
    break;
  }
  var G__9702 = args9693.length;
  switch(G__9702) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9693.slice(6), 0, null);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7511__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__9703 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9703) : f.call(null, G__9703);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__9704 = cljs.core.meta(obj);
    var G__9705 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9704, G__9705) : f.call(null, G__9704, G__9705);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__9706 = cljs.core.meta(obj);
    var G__9707 = a;
    var G__9708 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9706, G__9707, G__9708) : f.call(null, G__9706, G__9707, G__9708);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__9709 = cljs.core.meta(obj);
    var G__9710 = a;
    var G__9711 = b;
    var G__9712 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9709, G__9710, G__9711, G__9712) : f.call(null, G__9709, G__9710, G__9711, G__9712);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__9713 = cljs.core.meta(obj);
    var G__9714 = a;
    var G__9715 = b;
    var G__9716 = c;
    var G__9717 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9713, G__9714, G__9715, G__9716, G__9717) : f.call(null, G__9713, G__9714, G__9715, G__9716, G__9717);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq9694) {
  var G__9695 = cljs.core.first(seq9694);
  var seq9694__$1 = cljs.core.next(seq9694);
  var G__9696 = cljs.core.first(seq9694__$1);
  var seq9694__$2 = cljs.core.next(seq9694__$1);
  var G__9697 = cljs.core.first(seq9694__$2);
  var seq9694__$3 = cljs.core.next(seq9694__$2);
  var G__9698 = cljs.core.first(seq9694__$3);
  var seq9694__$4 = cljs.core.next(seq9694__$3);
  var G__9699 = cljs.core.first(seq9694__$4);
  var seq9694__$5 = cljs.core.next(seq9694__$4);
  var G__9700 = cljs.core.first(seq9694__$5);
  var seq9694__$6 = cljs.core.next(seq9694__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__9695, G__9696, G__9697, G__9698, G__9699, G__9700, seq9694__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_(var_args) {
  var args9722 = [];
  var len__7492__auto___9728 = arguments.length;
  var i__7493__auto___9729 = 0;
  while (true) {
    if (i__7493__auto___9729 < len__7492__auto___9728) {
      args9722.push(arguments[i__7493__auto___9729]);
      var G__9730 = i__7493__auto___9729 + 1;
      i__7493__auto___9729 = G__9730;
      continue;
    } else {
    }
    break;
  }
  var G__9727 = args9722.length;
  switch(G__9727) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9722.slice(2), 0, null);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq9723) {
  var G__9724 = cljs.core.first(seq9723);
  var seq9723__$1 = cljs.core.next(seq9723);
  var G__9725 = cljs.core.first(seq9723__$1);
  var seq9723__$2 = cljs.core.next(seq9723__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9724, G__9725, seq9723__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t_cljs$core9735 !== "undefined") {
  } else {
    cljs.core.t_cljs$core9735 = function(nil_iter, meta9736) {
      this.nil_iter = nil_iter;
      this.meta9736 = meta9736;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t_cljs$core9735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_9737, meta9736__$1) {
      var self__ = this;
      var _9737__$1 = this;
      return new cljs.core.t_cljs$core9735(self__.nil_iter, meta9736__$1);
    };
    cljs.core.t_cljs$core9735.prototype.cljs$core$IMeta$_meta$arity$1 = function(_9737) {
      var self__ = this;
      var _9737__$1 = this;
      return self__.meta9736;
    };
    cljs.core.t_cljs$core9735.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t_cljs$core9735.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t_cljs$core9735.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t_cljs$core9735.getBasis = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "nil-iter", "nil-iter", 1101030523, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "arglists", "arglists", 1661989754), cljs.core.list(new cljs.core.Symbol(null, "quote", "quote", 1377916282, null), cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)), new cljs.core.Symbol(null, "meta9736", "meta9736", -1370840278, null)], 
      null);
    };
    cljs.core.t_cljs$core9735.cljs$lang$type = true;
    cljs.core.t_cljs$core9735.cljs$lang$ctorStr = "cljs.core/t_cljs$core9735";
    cljs.core.t_cljs$core9735.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
      return cljs.core._write(writer__7024__auto__, "cljs.core/t_cljs$core9735");
    };
    cljs.core.__GT_t_cljs$core9735 = function cljs$core$nil_iter_$___GT_t_cljs$core9735(nil_iter__$1, meta9736) {
      return new cljs.core.t_cljs$core9735(nil_iter__$1, meta9736);
    };
  }
  return new cljs.core.t_cljs$core9735(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.iterable_QMARK_(coll)) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__6405__auto__ = !(lt.stepper == null);
      if (and__6405__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__6405__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__9738 = lt;
        var G__9739 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__9738, G__9739) : self__.xform.call(null, G__9738, G__9739);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__9740 = cljs.core.next(iters__$1);
        iters__$1 = G__9740;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__7332__auto___9741 = self__.iters.length;
  var i_9742 = 0;
  while (true) {
    if (i_9742 < n__7332__auto___9741) {
      self__.nexts[i_9742] = self__.iters[i_9742].next();
      var G__9743 = i_9742 + 1;
      i_9742 = G__9743;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__6405__auto__ = !(lt.stepper == null);
      if (and__6405__auto__) {
        return this$.hasNext();
      } else {
        return and__6405__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper(var_args) {
  var args9744 = [];
  var len__7492__auto___9747 = arguments.length;
  var i__7493__auto___9748 = 0;
  while (true) {
    if (i__7493__auto___9748 < len__7492__auto___9747) {
      args9744.push(arguments[i__7493__auto___9748]);
      var G__9749 = i__7493__auto___9748 + 1;
      i__7493__auto___9748 = G__9749;
      continue;
    } else {
    }
    break;
  }
  var G__9746 = args9744.length;
  switch(G__9746) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9744.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31850700;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.indexOf = function() {
  var G__9751 = null;
  var G__9751__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9751__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9751 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9751__1.call(this, x);
      case 2:
        return G__9751__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9751.cljs$core$IFn$_invoke$arity$1 = G__9751__1;
  G__9751.cljs$core$IFn$_invoke$arity$2 = G__9751__2;
  return G__9751;
}();
cljs.core.LazyTransformer.prototype.lastIndexOf = function() {
  var G__9752 = null;
  var G__9752__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__9752__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9752 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9752__1.call(this, x);
      case 2:
        return G__9752__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9752.cljs$core$IFn$_invoke$arity$1 = G__9752__1;
  G__9752.cljs$core$IFn$_invoke$arity$2 = G__9752__2;
  return G__9752;
}();
cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return self__.meta;
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  cljs.core.with_meta(new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__9753_9757 = cljs.core.seq(colls);
  var chunk__9754_9758 = null;
  var count__9755_9759 = 0;
  var i__9756_9760 = 0;
  while (true) {
    if (i__9756_9760 < count__9755_9759) {
      var coll_9761 = chunk__9754_9758.cljs$core$IIndexed$_nth$arity$2(null, i__9756_9760);
      iters.push(cljs.core.iter(coll_9761));
      var G__9762 = seq__9753_9757;
      var G__9763 = chunk__9754_9758;
      var G__9764 = count__9755_9759;
      var G__9765 = i__9756_9760 + 1;
      seq__9753_9757 = G__9762;
      chunk__9754_9758 = G__9763;
      count__9755_9759 = G__9764;
      i__9756_9760 = G__9765;
      continue;
    } else {
      var temp__4657__auto___9766 = cljs.core.seq(seq__9753_9757);
      if (temp__4657__auto___9766) {
        var seq__9753_9767__$1 = temp__4657__auto___9766;
        if (cljs.core.chunked_seq_QMARK_(seq__9753_9767__$1)) {
          var c__7228__auto___9768 = cljs.core.chunk_first(seq__9753_9767__$1);
          var G__9769 = cljs.core.chunk_rest(seq__9753_9767__$1);
          var G__9770 = c__7228__auto___9768;
          var G__9771 = cljs.core.count(c__7228__auto___9768);
          var G__9772 = 0;
          seq__9753_9757 = G__9769;
          chunk__9754_9758 = G__9770;
          count__9755_9759 = G__9771;
          i__9756_9760 = G__9772;
          continue;
        } else {
          var coll_9773 = cljs.core.first(seq__9753_9767__$1);
          iters.push(cljs.core.iter(coll_9773));
          var G__9774 = cljs.core.next(seq__9753_9767__$1);
          var G__9775 = null;
          var G__9776 = 0;
          var G__9777 = 0;
          seq__9753_9757 = G__9774;
          chunk__9754_9758 = G__9775;
          count__9755_9759 = G__9776;
          i__9756_9760 = G__9777;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence(var_args) {
  var args9778 = [];
  var len__7492__auto___9784 = arguments.length;
  var i__7493__auto___9785 = 0;
  while (true) {
    if (i__7493__auto___9785 < len__7492__auto___9784) {
      args9778.push(arguments[i__7493__auto___9785]);
      var G__9786 = i__7493__auto___9785 + 1;
      i__7493__auto___9785 = G__9786;
      continue;
    } else {
    }
    break;
  }
  var G__9783 = args9778.length;
  switch(G__9783) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9778.slice(2), 0, null);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__6417__auto__ = cljs.core.seq(coll);
    if (or__6417__auto__) {
      return or__6417__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq9779) {
  var G__9780 = cljs.core.first(seq9779);
  var seq9779__$1 = cljs.core.next(seq9779);
  var G__9781 = cljs.core.first(seq9779__$1);
  var seq9779__$2 = cljs.core.next(seq9779__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__9780, G__9781, seq9779__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__9789 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9789) : pred.call(null, G__9789);
      }())) {
        var G__9790 = pred;
        var G__9791 = cljs.core.next(coll);
        pred = G__9790;
        coll = G__9791;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__6417__auto__ = function() {
        var G__9795 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9795) : pred.call(null, G__9795);
      }();
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var G__9796 = pred;
        var G__9797 = cljs.core.next(coll);
        pred = G__9796;
        coll = G__9797;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__9798 = null;
    var G__9798__0 = function() {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
    };
    var G__9798__1 = function(x) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
    };
    var G__9798__2 = function(x, y) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y));
    };
    var G__9798__3 = function() {
      var G__9799__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__9799 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__9800__i = 0, G__9800__a = new Array(arguments.length - 2);
          while (G__9800__i < G__9800__a.length) {
            G__9800__a[G__9800__i] = arguments[G__9800__i + 2];
            ++G__9800__i;
          }
          zs = new cljs.core.IndexedSeq(G__9800__a, 0);
        }
        return G__9799__delegate.call(this, x, y, zs);
      };
      G__9799.cljs$lang$maxFixedArity = 2;
      G__9799.cljs$lang$applyTo = function(arglist__9801) {
        var x = cljs.core.first(arglist__9801);
        arglist__9801 = cljs.core.next(arglist__9801);
        var y = cljs.core.first(arglist__9801);
        var zs = cljs.core.rest(arglist__9801);
        return G__9799__delegate(x, y, zs);
      };
      G__9799.cljs$core$IFn$_invoke$arity$variadic = G__9799__delegate;
      return G__9799;
    }();
    G__9798 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__9798__0.call(this);
        case 1:
          return G__9798__1.call(this, x);
        case 2:
          return G__9798__2.call(this, x, y);
        default:
          var G__9802 = null;
          if (arguments.length > 2) {
            var G__9803__i = 0, G__9803__a = new Array(arguments.length - 2);
            while (G__9803__i < G__9803__a.length) {
              G__9803__a[G__9803__i] = arguments[G__9803__i + 2];
              ++G__9803__i;
            }
            G__9802 = new cljs.core.IndexedSeq(G__9803__a, 0);
          }
          return G__9798__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__9802);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9798.cljs$lang$maxFixedArity = 2;
    G__9798.cljs$lang$applyTo = G__9798__3.cljs$lang$applyTo;
    G__9798.cljs$core$IFn$_invoke$arity$0 = G__9798__0;
    G__9798.cljs$core$IFn$_invoke$arity$1 = G__9798__1;
    G__9798.cljs$core$IFn$_invoke$arity$2 = G__9798__2;
    G__9798.cljs$core$IFn$_invoke$arity$variadic = G__9798__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__9798;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__9804__delegate = function(args) {
      return x;
    };
    var G__9804 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__9805__i = 0, G__9805__a = new Array(arguments.length - 0);
        while (G__9805__i < G__9805__a.length) {
          G__9805__a[G__9805__i] = arguments[G__9805__i + 0];
          ++G__9805__i;
        }
        args = new cljs.core.IndexedSeq(G__9805__a, 0);
      }
      return G__9804__delegate.call(this, args);
    };
    G__9804.cljs$lang$maxFixedArity = 0;
    G__9804.cljs$lang$applyTo = function(arglist__9806) {
      var args = cljs.core.seq(arglist__9806);
      return G__9804__delegate(args);
    };
    G__9804.cljs$core$IFn$_invoke$arity$variadic = G__9804__delegate;
    return G__9804;
  }();
};
cljs.core.comp = function cljs$core$comp(var_args) {
  var args9807 = [];
  var len__7492__auto___9829 = arguments.length;
  var i__7493__auto___9830 = 0;
  while (true) {
    if (i__7493__auto___9830 < len__7492__auto___9829) {
      args9807.push(arguments[i__7493__auto___9830]);
      var G__9831 = i__7493__auto___9830 + 1;
      i__7493__auto___9830 = G__9831;
      continue;
    } else {
    }
    break;
  }
  var G__9813 = args9807.length;
  switch(G__9813) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9807.slice(3), 0, null);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__9833 = null;
    var G__9833__0 = function() {
      var G__9814 = g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9814) : f.call(null, G__9814);
    };
    var G__9833__1 = function(x) {
      var G__9815 = g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9815) : f.call(null, G__9815);
    };
    var G__9833__2 = function(x, y) {
      var G__9816 = g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x, y) : g.call(null, x, y);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9816) : f.call(null, G__9816);
    };
    var G__9833__3 = function(x, y, z) {
      var G__9817 = g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x, y, z) : g.call(null, x, y, z);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9817) : f.call(null, G__9817);
    };
    var G__9833__4 = function() {
      var G__9834__delegate = function(x, y, z, args) {
        var G__9818 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9818) : f.call(null, G__9818);
      };
      var G__9834 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9835__i = 0, G__9835__a = new Array(arguments.length - 3);
          while (G__9835__i < G__9835__a.length) {
            G__9835__a[G__9835__i] = arguments[G__9835__i + 3];
            ++G__9835__i;
          }
          args = new cljs.core.IndexedSeq(G__9835__a, 0);
        }
        return G__9834__delegate.call(this, x, y, z, args);
      };
      G__9834.cljs$lang$maxFixedArity = 3;
      G__9834.cljs$lang$applyTo = function(arglist__9836) {
        var x = cljs.core.first(arglist__9836);
        arglist__9836 = cljs.core.next(arglist__9836);
        var y = cljs.core.first(arglist__9836);
        arglist__9836 = cljs.core.next(arglist__9836);
        var z = cljs.core.first(arglist__9836);
        var args = cljs.core.rest(arglist__9836);
        return G__9834__delegate(x, y, z, args);
      };
      G__9834.cljs$core$IFn$_invoke$arity$variadic = G__9834__delegate;
      return G__9834;
    }();
    G__9833 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9833__0.call(this);
        case 1:
          return G__9833__1.call(this, x);
        case 2:
          return G__9833__2.call(this, x, y);
        case 3:
          return G__9833__3.call(this, x, y, z);
        default:
          var G__9837 = null;
          if (arguments.length > 3) {
            var G__9838__i = 0, G__9838__a = new Array(arguments.length - 3);
            while (G__9838__i < G__9838__a.length) {
              G__9838__a[G__9838__i] = arguments[G__9838__i + 3];
              ++G__9838__i;
            }
            G__9837 = new cljs.core.IndexedSeq(G__9838__a, 0);
          }
          return G__9833__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9837);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9833.cljs$lang$maxFixedArity = 3;
    G__9833.cljs$lang$applyTo = G__9833__4.cljs$lang$applyTo;
    G__9833.cljs$core$IFn$_invoke$arity$0 = G__9833__0;
    G__9833.cljs$core$IFn$_invoke$arity$1 = G__9833__1;
    G__9833.cljs$core$IFn$_invoke$arity$2 = G__9833__2;
    G__9833.cljs$core$IFn$_invoke$arity$3 = G__9833__3;
    G__9833.cljs$core$IFn$_invoke$arity$variadic = G__9833__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9833;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__9839 = null;
    var G__9839__0 = function() {
      var G__9819 = function() {
        var G__9820 = h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9820) : g.call(null, G__9820);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9819) : f.call(null, G__9819);
    };
    var G__9839__1 = function(x) {
      var G__9821 = function() {
        var G__9822 = h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9822) : g.call(null, G__9822);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9821) : f.call(null, G__9821);
    };
    var G__9839__2 = function(x, y) {
      var G__9823 = function() {
        var G__9824 = h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x, y) : h.call(null, x, y);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9824) : g.call(null, G__9824);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9823) : f.call(null, G__9823);
    };
    var G__9839__3 = function(x, y, z) {
      var G__9825 = function() {
        var G__9826 = h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x, y, z) : h.call(null, x, y, z);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9826) : g.call(null, G__9826);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9825) : f.call(null, G__9825);
    };
    var G__9839__4 = function() {
      var G__9840__delegate = function(x, y, z, args) {
        var G__9827 = function() {
          var G__9828 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9828) : g.call(null, G__9828);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9827) : f.call(null, G__9827);
      };
      var G__9840 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9841__i = 0, G__9841__a = new Array(arguments.length - 3);
          while (G__9841__i < G__9841__a.length) {
            G__9841__a[G__9841__i] = arguments[G__9841__i + 3];
            ++G__9841__i;
          }
          args = new cljs.core.IndexedSeq(G__9841__a, 0);
        }
        return G__9840__delegate.call(this, x, y, z, args);
      };
      G__9840.cljs$lang$maxFixedArity = 3;
      G__9840.cljs$lang$applyTo = function(arglist__9842) {
        var x = cljs.core.first(arglist__9842);
        arglist__9842 = cljs.core.next(arglist__9842);
        var y = cljs.core.first(arglist__9842);
        arglist__9842 = cljs.core.next(arglist__9842);
        var z = cljs.core.first(arglist__9842);
        var args = cljs.core.rest(arglist__9842);
        return G__9840__delegate(x, y, z, args);
      };
      G__9840.cljs$core$IFn$_invoke$arity$variadic = G__9840__delegate;
      return G__9840;
    }();
    G__9839 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9839__0.call(this);
        case 1:
          return G__9839__1.call(this, x);
        case 2:
          return G__9839__2.call(this, x, y);
        case 3:
          return G__9839__3.call(this, x, y, z);
        default:
          var G__9843 = null;
          if (arguments.length > 3) {
            var G__9844__i = 0, G__9844__a = new Array(arguments.length - 3);
            while (G__9844__i < G__9844__a.length) {
              G__9844__a[G__9844__i] = arguments[G__9844__i + 3];
              ++G__9844__i;
            }
            G__9843 = new cljs.core.IndexedSeq(G__9844__a, 0);
          }
          return G__9839__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9843);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9839.cljs$lang$maxFixedArity = 3;
    G__9839.cljs$lang$applyTo = G__9839__4.cljs$lang$applyTo;
    G__9839.cljs$core$IFn$_invoke$arity$0 = G__9839__0;
    G__9839.cljs$core$IFn$_invoke$arity$1 = G__9839__1;
    G__9839.cljs$core$IFn$_invoke$arity$2 = G__9839__2;
    G__9839.cljs$core$IFn$_invoke$arity$3 = G__9839__3;
    G__9839.cljs$core$IFn$_invoke$arity$variadic = G__9839__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9839;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__9845__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__9846 = cljs.core.first(fs__$2).call(null, ret);
            var G__9847 = cljs.core.next(fs__$2);
            ret = G__9846;
            fs__$2 = G__9847;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__9845 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__9848__i = 0, G__9848__a = new Array(arguments.length - 0);
          while (G__9848__i < G__9848__a.length) {
            G__9848__a[G__9848__i] = arguments[G__9848__i + 0];
            ++G__9848__i;
          }
          args = new cljs.core.IndexedSeq(G__9848__a, 0);
        }
        return G__9845__delegate.call(this, args);
      };
      G__9845.cljs$lang$maxFixedArity = 0;
      G__9845.cljs$lang$applyTo = function(arglist__9849) {
        var args = cljs.core.seq(arglist__9849);
        return G__9845__delegate(args);
      };
      G__9845.cljs$core$IFn$_invoke$arity$variadic = G__9845__delegate;
      return G__9845;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq9808) {
  var G__9809 = cljs.core.first(seq9808);
  var seq9808__$1 = cljs.core.next(seq9808);
  var G__9810 = cljs.core.first(seq9808__$1);
  var seq9808__$2 = cljs.core.next(seq9808__$1);
  var G__9811 = cljs.core.first(seq9808__$2);
  var seq9808__$3 = cljs.core.next(seq9808__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__9809, G__9810, G__9811, seq9808__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial(var_args) {
  var args9850 = [];
  var len__7492__auto___9858 = arguments.length;
  var i__7493__auto___9859 = 0;
  while (true) {
    if (i__7493__auto___9859 < len__7492__auto___9858) {
      args9850.push(arguments[i__7493__auto___9859]);
      var G__9860 = i__7493__auto___9859 + 1;
      i__7493__auto___9859 = G__9860;
      continue;
    } else {
    }
    break;
  }
  var G__9857 = args9850.length;
  switch(G__9857) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9850.slice(4), 0, null);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7511__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__9862 = null;
    var G__9862__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1);
    };
    var G__9862__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, x) : f.call(null, arg1, x);
    };
    var G__9862__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, x, y) : f.call(null, arg1, x, y);
    };
    var G__9862__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, x, y, z) : f.call(null, arg1, x, y, z);
    };
    var G__9862__4 = function() {
      var G__9863__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__9863 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9864__i = 0, G__9864__a = new Array(arguments.length - 3);
          while (G__9864__i < G__9864__a.length) {
            G__9864__a[G__9864__i] = arguments[G__9864__i + 3];
            ++G__9864__i;
          }
          args = new cljs.core.IndexedSeq(G__9864__a, 0);
        }
        return G__9863__delegate.call(this, x, y, z, args);
      };
      G__9863.cljs$lang$maxFixedArity = 3;
      G__9863.cljs$lang$applyTo = function(arglist__9865) {
        var x = cljs.core.first(arglist__9865);
        arglist__9865 = cljs.core.next(arglist__9865);
        var y = cljs.core.first(arglist__9865);
        arglist__9865 = cljs.core.next(arglist__9865);
        var z = cljs.core.first(arglist__9865);
        var args = cljs.core.rest(arglist__9865);
        return G__9863__delegate(x, y, z, args);
      };
      G__9863.cljs$core$IFn$_invoke$arity$variadic = G__9863__delegate;
      return G__9863;
    }();
    G__9862 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9862__0.call(this);
        case 1:
          return G__9862__1.call(this, x);
        case 2:
          return G__9862__2.call(this, x, y);
        case 3:
          return G__9862__3.call(this, x, y, z);
        default:
          var G__9866 = null;
          if (arguments.length > 3) {
            var G__9867__i = 0, G__9867__a = new Array(arguments.length - 3);
            while (G__9867__i < G__9867__a.length) {
              G__9867__a[G__9867__i] = arguments[G__9867__i + 3];
              ++G__9867__i;
            }
            G__9866 = new cljs.core.IndexedSeq(G__9867__a, 0);
          }
          return G__9862__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9866);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9862.cljs$lang$maxFixedArity = 3;
    G__9862.cljs$lang$applyTo = G__9862__4.cljs$lang$applyTo;
    G__9862.cljs$core$IFn$_invoke$arity$0 = G__9862__0;
    G__9862.cljs$core$IFn$_invoke$arity$1 = G__9862__1;
    G__9862.cljs$core$IFn$_invoke$arity$2 = G__9862__2;
    G__9862.cljs$core$IFn$_invoke$arity$3 = G__9862__3;
    G__9862.cljs$core$IFn$_invoke$arity$variadic = G__9862__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9862;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__9868 = null;
    var G__9868__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, arg2) : f.call(null, arg1, arg2);
    };
    var G__9868__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, x) : f.call(null, arg1, arg2, x);
    };
    var G__9868__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, x, y) : f.call(null, arg1, arg2, x, y);
    };
    var G__9868__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, x, y, z) : f.call(null, arg1, arg2, x, y, z);
    };
    var G__9868__4 = function() {
      var G__9869__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__9869 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9870__i = 0, G__9870__a = new Array(arguments.length - 3);
          while (G__9870__i < G__9870__a.length) {
            G__9870__a[G__9870__i] = arguments[G__9870__i + 3];
            ++G__9870__i;
          }
          args = new cljs.core.IndexedSeq(G__9870__a, 0);
        }
        return G__9869__delegate.call(this, x, y, z, args);
      };
      G__9869.cljs$lang$maxFixedArity = 3;
      G__9869.cljs$lang$applyTo = function(arglist__9871) {
        var x = cljs.core.first(arglist__9871);
        arglist__9871 = cljs.core.next(arglist__9871);
        var y = cljs.core.first(arglist__9871);
        arglist__9871 = cljs.core.next(arglist__9871);
        var z = cljs.core.first(arglist__9871);
        var args = cljs.core.rest(arglist__9871);
        return G__9869__delegate(x, y, z, args);
      };
      G__9869.cljs$core$IFn$_invoke$arity$variadic = G__9869__delegate;
      return G__9869;
    }();
    G__9868 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9868__0.call(this);
        case 1:
          return G__9868__1.call(this, x);
        case 2:
          return G__9868__2.call(this, x, y);
        case 3:
          return G__9868__3.call(this, x, y, z);
        default:
          var G__9872 = null;
          if (arguments.length > 3) {
            var G__9873__i = 0, G__9873__a = new Array(arguments.length - 3);
            while (G__9873__i < G__9873__a.length) {
              G__9873__a[G__9873__i] = arguments[G__9873__i + 3];
              ++G__9873__i;
            }
            G__9872 = new cljs.core.IndexedSeq(G__9873__a, 0);
          }
          return G__9868__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9872);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9868.cljs$lang$maxFixedArity = 3;
    G__9868.cljs$lang$applyTo = G__9868__4.cljs$lang$applyTo;
    G__9868.cljs$core$IFn$_invoke$arity$0 = G__9868__0;
    G__9868.cljs$core$IFn$_invoke$arity$1 = G__9868__1;
    G__9868.cljs$core$IFn$_invoke$arity$2 = G__9868__2;
    G__9868.cljs$core$IFn$_invoke$arity$3 = G__9868__3;
    G__9868.cljs$core$IFn$_invoke$arity$variadic = G__9868__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9868;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__9874 = null;
    var G__9874__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, arg3) : f.call(null, arg1, arg2, arg3);
    };
    var G__9874__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, arg3, x) : f.call(null, arg1, arg2, arg3, x);
    };
    var G__9874__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, arg3, x, y) : f.call(null, arg1, arg2, arg3, x, y);
    };
    var G__9874__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1, arg2, arg3, x, y, z) : f.call(null, arg1, arg2, arg3, x, y, z);
    };
    var G__9874__4 = function() {
      var G__9875__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__9875 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__9876__i = 0, G__9876__a = new Array(arguments.length - 3);
          while (G__9876__i < G__9876__a.length) {
            G__9876__a[G__9876__i] = arguments[G__9876__i + 3];
            ++G__9876__i;
          }
          args = new cljs.core.IndexedSeq(G__9876__a, 0);
        }
        return G__9875__delegate.call(this, x, y, z, args);
      };
      G__9875.cljs$lang$maxFixedArity = 3;
      G__9875.cljs$lang$applyTo = function(arglist__9877) {
        var x = cljs.core.first(arglist__9877);
        arglist__9877 = cljs.core.next(arglist__9877);
        var y = cljs.core.first(arglist__9877);
        arglist__9877 = cljs.core.next(arglist__9877);
        var z = cljs.core.first(arglist__9877);
        var args = cljs.core.rest(arglist__9877);
        return G__9875__delegate(x, y, z, args);
      };
      G__9875.cljs$core$IFn$_invoke$arity$variadic = G__9875__delegate;
      return G__9875;
    }();
    G__9874 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__9874__0.call(this);
        case 1:
          return G__9874__1.call(this, x);
        case 2:
          return G__9874__2.call(this, x, y);
        case 3:
          return G__9874__3.call(this, x, y, z);
        default:
          var G__9878 = null;
          if (arguments.length > 3) {
            var G__9879__i = 0, G__9879__a = new Array(arguments.length - 3);
            while (G__9879__i < G__9879__a.length) {
              G__9879__a[G__9879__i] = arguments[G__9879__i + 3];
              ++G__9879__i;
            }
            G__9878 = new cljs.core.IndexedSeq(G__9879__a, 0);
          }
          return G__9874__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__9878);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9874.cljs$lang$maxFixedArity = 3;
    G__9874.cljs$lang$applyTo = G__9874__4.cljs$lang$applyTo;
    G__9874.cljs$core$IFn$_invoke$arity$0 = G__9874__0;
    G__9874.cljs$core$IFn$_invoke$arity$1 = G__9874__1;
    G__9874.cljs$core$IFn$_invoke$arity$2 = G__9874__2;
    G__9874.cljs$core$IFn$_invoke$arity$3 = G__9874__3;
    G__9874.cljs$core$IFn$_invoke$arity$variadic = G__9874__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9874;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__9880__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__9880 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__9881__i = 0, G__9881__a = new Array(arguments.length - 0);
        while (G__9881__i < G__9881__a.length) {
          G__9881__a[G__9881__i] = arguments[G__9881__i + 0];
          ++G__9881__i;
        }
        args = new cljs.core.IndexedSeq(G__9881__a, 0);
      }
      return G__9880__delegate.call(this, args);
    };
    G__9880.cljs$lang$maxFixedArity = 0;
    G__9880.cljs$lang$applyTo = function(arglist__9882) {
      var args = cljs.core.seq(arglist__9882);
      return G__9880__delegate(args);
    };
    G__9880.cljs$core$IFn$_invoke$arity$variadic = G__9880__delegate;
    return G__9880;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq9851) {
  var G__9852 = cljs.core.first(seq9851);
  var seq9851__$1 = cljs.core.next(seq9851);
  var G__9853 = cljs.core.first(seq9851__$1);
  var seq9851__$2 = cljs.core.next(seq9851__$1);
  var G__9854 = cljs.core.first(seq9851__$2);
  var seq9851__$3 = cljs.core.next(seq9851__$2);
  var G__9855 = cljs.core.first(seq9851__$3);
  var seq9851__$4 = cljs.core.next(seq9851__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__9852, G__9853, G__9854, G__9855, seq9851__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil(var_args) {
  var args9883 = [];
  var len__7492__auto___9902 = arguments.length;
  var i__7493__auto___9903 = 0;
  while (true) {
    if (i__7493__auto___9903 < len__7492__auto___9902) {
      args9883.push(arguments[i__7493__auto___9903]);
      var G__9904 = i__7493__auto___9903 + 1;
      i__7493__auto___9903 = G__9904;
      continue;
    } else {
    }
    break;
  }
  var G__9885 = args9883.length;
  switch(G__9885) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9883.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__9906 = null;
    var G__9906__1 = function(a) {
      var G__9886 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9886) : f.call(null, G__9886);
    };
    var G__9906__2 = function(a, b) {
      var G__9887 = a == null ? x : a;
      var G__9888 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9887, G__9888) : f.call(null, G__9887, G__9888);
    };
    var G__9906__3 = function(a, b, c) {
      var G__9889 = a == null ? x : a;
      var G__9890 = b;
      var G__9891 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9889, G__9890, G__9891) : f.call(null, G__9889, G__9890, G__9891);
    };
    var G__9906__4 = function() {
      var G__9907__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__9907 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9908__i = 0, G__9908__a = new Array(arguments.length - 3);
          while (G__9908__i < G__9908__a.length) {
            G__9908__a[G__9908__i] = arguments[G__9908__i + 3];
            ++G__9908__i;
          }
          ds = new cljs.core.IndexedSeq(G__9908__a, 0);
        }
        return G__9907__delegate.call(this, a, b, c, ds);
      };
      G__9907.cljs$lang$maxFixedArity = 3;
      G__9907.cljs$lang$applyTo = function(arglist__9909) {
        var a = cljs.core.first(arglist__9909);
        arglist__9909 = cljs.core.next(arglist__9909);
        var b = cljs.core.first(arglist__9909);
        arglist__9909 = cljs.core.next(arglist__9909);
        var c = cljs.core.first(arglist__9909);
        var ds = cljs.core.rest(arglist__9909);
        return G__9907__delegate(a, b, c, ds);
      };
      G__9907.cljs$core$IFn$_invoke$arity$variadic = G__9907__delegate;
      return G__9907;
    }();
    G__9906 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__9906__1.call(this, a);
        case 2:
          return G__9906__2.call(this, a, b);
        case 3:
          return G__9906__3.call(this, a, b, c);
        default:
          var G__9910 = null;
          if (arguments.length > 3) {
            var G__9911__i = 0, G__9911__a = new Array(arguments.length - 3);
            while (G__9911__i < G__9911__a.length) {
              G__9911__a[G__9911__i] = arguments[G__9911__i + 3];
              ++G__9911__i;
            }
            G__9910 = new cljs.core.IndexedSeq(G__9911__a, 0);
          }
          return G__9906__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9910);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9906.cljs$lang$maxFixedArity = 3;
    G__9906.cljs$lang$applyTo = G__9906__4.cljs$lang$applyTo;
    G__9906.cljs$core$IFn$_invoke$arity$1 = G__9906__1;
    G__9906.cljs$core$IFn$_invoke$arity$2 = G__9906__2;
    G__9906.cljs$core$IFn$_invoke$arity$3 = G__9906__3;
    G__9906.cljs$core$IFn$_invoke$arity$variadic = G__9906__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9906;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__9912 = null;
    var G__9912__2 = function(a, b) {
      var G__9892 = a == null ? x : a;
      var G__9893 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9892, G__9893) : f.call(null, G__9892, G__9893);
    };
    var G__9912__3 = function(a, b, c) {
      var G__9894 = a == null ? x : a;
      var G__9895 = b == null ? y : b;
      var G__9896 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9894, G__9895, G__9896) : f.call(null, G__9894, G__9895, G__9896);
    };
    var G__9912__4 = function() {
      var G__9913__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__9913 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9914__i = 0, G__9914__a = new Array(arguments.length - 3);
          while (G__9914__i < G__9914__a.length) {
            G__9914__a[G__9914__i] = arguments[G__9914__i + 3];
            ++G__9914__i;
          }
          ds = new cljs.core.IndexedSeq(G__9914__a, 0);
        }
        return G__9913__delegate.call(this, a, b, c, ds);
      };
      G__9913.cljs$lang$maxFixedArity = 3;
      G__9913.cljs$lang$applyTo = function(arglist__9915) {
        var a = cljs.core.first(arglist__9915);
        arglist__9915 = cljs.core.next(arglist__9915);
        var b = cljs.core.first(arglist__9915);
        arglist__9915 = cljs.core.next(arglist__9915);
        var c = cljs.core.first(arglist__9915);
        var ds = cljs.core.rest(arglist__9915);
        return G__9913__delegate(a, b, c, ds);
      };
      G__9913.cljs$core$IFn$_invoke$arity$variadic = G__9913__delegate;
      return G__9913;
    }();
    G__9912 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__9912__2.call(this, a, b);
        case 3:
          return G__9912__3.call(this, a, b, c);
        default:
          var G__9916 = null;
          if (arguments.length > 3) {
            var G__9917__i = 0, G__9917__a = new Array(arguments.length - 3);
            while (G__9917__i < G__9917__a.length) {
              G__9917__a[G__9917__i] = arguments[G__9917__i + 3];
              ++G__9917__i;
            }
            G__9916 = new cljs.core.IndexedSeq(G__9917__a, 0);
          }
          return G__9912__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9916);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9912.cljs$lang$maxFixedArity = 3;
    G__9912.cljs$lang$applyTo = G__9912__4.cljs$lang$applyTo;
    G__9912.cljs$core$IFn$_invoke$arity$2 = G__9912__2;
    G__9912.cljs$core$IFn$_invoke$arity$3 = G__9912__3;
    G__9912.cljs$core$IFn$_invoke$arity$variadic = G__9912__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9912;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__9918 = null;
    var G__9918__2 = function(a, b) {
      var G__9897 = a == null ? x : a;
      var G__9898 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9897, G__9898) : f.call(null, G__9897, G__9898);
    };
    var G__9918__3 = function(a, b, c) {
      var G__9899 = a == null ? x : a;
      var G__9900 = b == null ? y : b;
      var G__9901 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9899, G__9900, G__9901) : f.call(null, G__9899, G__9900, G__9901);
    };
    var G__9918__4 = function() {
      var G__9919__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__9919 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__9920__i = 0, G__9920__a = new Array(arguments.length - 3);
          while (G__9920__i < G__9920__a.length) {
            G__9920__a[G__9920__i] = arguments[G__9920__i + 3];
            ++G__9920__i;
          }
          ds = new cljs.core.IndexedSeq(G__9920__a, 0);
        }
        return G__9919__delegate.call(this, a, b, c, ds);
      };
      G__9919.cljs$lang$maxFixedArity = 3;
      G__9919.cljs$lang$applyTo = function(arglist__9921) {
        var a = cljs.core.first(arglist__9921);
        arglist__9921 = cljs.core.next(arglist__9921);
        var b = cljs.core.first(arglist__9921);
        arglist__9921 = cljs.core.next(arglist__9921);
        var c = cljs.core.first(arglist__9921);
        var ds = cljs.core.rest(arglist__9921);
        return G__9919__delegate(a, b, c, ds);
      };
      G__9919.cljs$core$IFn$_invoke$arity$variadic = G__9919__delegate;
      return G__9919;
    }();
    G__9918 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__9918__2.call(this, a, b);
        case 3:
          return G__9918__3.call(this, a, b, c);
        default:
          var G__9922 = null;
          if (arguments.length > 3) {
            var G__9923__i = 0, G__9923__a = new Array(arguments.length - 3);
            while (G__9923__i < G__9923__a.length) {
              G__9923__a[G__9923__i] = arguments[G__9923__i + 3];
              ++G__9923__i;
            }
            G__9922 = new cljs.core.IndexedSeq(G__9923__a, 0);
          }
          return G__9918__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__9922);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9918.cljs$lang$maxFixedArity = 3;
    G__9918.cljs$lang$applyTo = G__9918__4.cljs$lang$applyTo;
    G__9918.cljs$core$IFn$_invoke$arity$2 = G__9918__2;
    G__9918.cljs$core$IFn$_invoke$arity$3 = G__9918__3;
    G__9918.cljs$core$IFn$_invoke$arity$variadic = G__9918__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__9918;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed(var_args) {
  var args9924 = [];
  var len__7492__auto___9955 = arguments.length;
  var i__7493__auto___9956 = 0;
  while (true) {
    if (i__7493__auto___9956 < len__7492__auto___9955) {
      args9924.push(arguments[i__7493__auto___9956]);
      var G__9957 = i__7493__auto___9956 + 1;
      i__7493__auto___9956 = G__9957;
      continue;
    } else {
    }
    break;
  }
  var G__9926 = args9924.length;
  switch(G__9926) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9924.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(-1) : cljs.core.volatile_BANG_.call(null, -1);
    return function(i) {
      return function() {
        var G__9959 = null;
        var G__9959__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__9959__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__9959__2 = function(result, input) {
          var G__9927 = result;
          var G__9928 = function() {
            var G__9929 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__9930 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9929, G__9930) : f.call(null, G__9929, G__9930);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9927, G__9928) : rf.call(null, G__9927, G__9928);
        };
        G__9959 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__9959__0.call(this);
            case 1:
              return G__9959__1.call(this, result);
            case 2:
              return G__9959__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__9959.cljs$core$IFn$_invoke$arity$0 = G__9959__0;
        G__9959.cljs$core$IFn$_invoke$arity$1 = G__9959__1;
        G__9959.cljs$core$IFn$_invoke$arity$2 = G__9959__2;
        return G__9959;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4657__auto__ = cljs.core.seq(coll__$1);
      if (temp__4657__auto__) {
        var s = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__7332__auto___9960 = size;
          var i_9961 = 0;
          while (true) {
            if (i_9961 < n__7332__auto___9960) {
              cljs.core.chunk_append(b, function() {
                var G__9951 = idx + i_9961;
                var G__9952 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9961);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9951, G__9952) : f.call(null, G__9951, G__9952);
              }());
              var G__9962 = i_9961 + 1;
              i_9961 = G__9962;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__9953 = idx;
            var G__9954 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9953, G__9954) : f.call(null, G__9953, G__9954);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep(var_args) {
  var args9963 = [];
  var len__7492__auto___9968 = arguments.length;
  var i__7493__auto___9969 = 0;
  while (true) {
    if (i__7493__auto___9969 < len__7492__auto___9968) {
      args9963.push(arguments[i__7493__auto___9969]);
      var G__9970 = i__7493__auto___9969 + 1;
      i__7493__auto___9969 = G__9970;
      continue;
    } else {
    }
    break;
  }
  var G__9965 = args9963.length;
  switch(G__9965) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9963.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__9972 = null;
      var G__9972__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__9972__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__9972__2 = function(result, input) {
        var v = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        if (v == null) {
          return result;
        } else {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
        }
      };
      G__9972 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__9972__0.call(this);
          case 1:
            return G__9972__1.call(this, result);
          case 2:
            return G__9972__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__9972.cljs$core$IFn$_invoke$arity$0 = G__9972__0;
      G__9972.cljs$core$IFn$_invoke$arity$1 = G__9972__1;
      G__9972.cljs$core$IFn$_invoke$arity$2 = G__9972__2;
      return G__9972;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7332__auto___9973 = size;
        var i_9974 = 0;
        while (true) {
          if (i_9974 < n__7332__auto___9973) {
            var x_9975 = function() {
              var G__9966 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_9974);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9966) : f.call(null, G__9966);
            }();
            if (x_9975 == null) {
            } else {
              cljs.core.chunk_append(b, x_9975);
            }
            var G__9976 = i_9974 + 1;
            i_9974 = G__9976;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__9967 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9967) : f.call(null, G__9967);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__9977 = cljs.core.seq(self__.watches);
  var chunk__9978 = null;
  var count__9979 = 0;
  var i__9980 = 0;
  while (true) {
    if (i__9980 < count__9979) {
      var vec__9981 = chunk__9978.cljs$core$IIndexed$_nth$arity$2(null, i__9980);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9981, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9981, 1, null);
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
      var G__9987 = seq__9977;
      var G__9988 = chunk__9978;
      var G__9989 = count__9979;
      var G__9990 = i__9980 + 1;
      seq__9977 = G__9987;
      chunk__9978 = G__9988;
      count__9979 = G__9989;
      i__9980 = G__9990;
      continue;
    } else {
      var temp__4657__auto__ = cljs.core.seq(seq__9977);
      if (temp__4657__auto__) {
        var seq__9977__$1 = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__9977__$1)) {
          var c__7228__auto__ = cljs.core.chunk_first(seq__9977__$1);
          var G__9991 = cljs.core.chunk_rest(seq__9977__$1);
          var G__9992 = c__7228__auto__;
          var G__9993 = cljs.core.count(c__7228__auto__);
          var G__9994 = 0;
          seq__9977 = G__9991;
          chunk__9978 = G__9992;
          count__9979 = G__9993;
          i__9980 = G__9994;
          continue;
        } else {
          var vec__9984 = cljs.core.first(seq__9977__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9984, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9984, 1, null);
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
          var G__9995 = cljs.core.next(seq__9977__$1);
          var G__9996 = null;
          var G__9997 = 0;
          var G__9998 = 0;
          seq__9977 = G__9995;
          chunk__9978 = G__9996;
          count__9979 = G__9997;
          i__9980 = G__9998;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return goog.getUid(this$__$1);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom(var_args) {
  var args9999 = [];
  var len__7492__auto___10007 = arguments.length;
  var i__7493__auto___10008 = 0;
  while (true) {
    if (i__7493__auto___10008 < len__7492__auto___10007) {
      args9999.push(arguments[i__7493__auto___10008]);
      var G__10009 = i__7493__auto___10008 + 1;
      i__7493__auto___10008 = G__10009;
      continue;
    } else {
    }
    break;
  }
  var G__10003 = args9999.length;
  switch(G__10003) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args9999.slice(1), 0, null);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7511__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__10004) {
  var map__10005 = p__10004;
  var map__10005__$1 = (!(map__10005 == null) ? map__10005.cljs$lang$protocol_mask$partition0$ & 64 || map__10005.cljs$core$ISeq$ ? true : false : false) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__10005) : map__10005;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10005__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10005__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq10000) {
  var G__10001 = cljs.core.first(seq10000);
  var seq10000__$1 = cljs.core.next(seq10000);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__10001, seq10000__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
      } else {
        throw new Error("Validator rejected reference state");
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_(var_args) {
  var args10011 = [];
  var len__7492__auto___10025 = arguments.length;
  var i__7493__auto___10026 = 0;
  while (true) {
    if (i__7493__auto___10026 < len__7492__auto___10025) {
      args10011.push(arguments[i__7493__auto___10026]);
      var G__10027 = i__7493__auto___10026 + 1;
      i__7493__auto___10026 = G__10027;
      continue;
    } else {
    }
    break;
  }
  var G__10018 = args10011.length;
  switch(G__10018) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10011.slice(4), 0, null);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7511__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10019 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10019) : f.call(null, G__10019);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10020 = a.state;
      var G__10021 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10020, G__10021) : f.call(null, G__10020, G__10021);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10022 = a.state;
      var G__10023 = x;
      var G__10024 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10022, G__10023, G__10024) : f.call(null, G__10022, G__10023, G__10024);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq10012) {
  var G__10013 = cljs.core.first(seq10012);
  var seq10012__$1 = cljs.core.next(seq10012);
  var G__10014 = cljs.core.first(seq10012__$1);
  var seq10012__$2 = cljs.core.next(seq10012__$1);
  var G__10015 = cljs.core.first(seq10012__$2);
  var seq10012__$3 = cljs.core.next(seq10012__$2);
  var G__10016 = cljs.core.first(seq10012__$3);
  var seq10012__$4 = cljs.core.next(seq10012__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10013, G__10014, G__10015, G__10016, seq10012__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed(var_args) {
  var args10029 = [];
  var len__7492__auto___10060 = arguments.length;
  var i__7493__auto___10061 = 0;
  while (true) {
    if (i__7493__auto___10061 < len__7492__auto___10060) {
      args10029.push(arguments[i__7493__auto___10061]);
      var G__10062 = i__7493__auto___10061 + 1;
      i__7493__auto___10061 = G__10062;
      continue;
    } else {
    }
    break;
  }
  var G__10031 = args10029.length;
  switch(G__10031) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10029.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__10064 = null;
        var G__10064__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10064__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10064__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i, input) : f.call(null, i, input);
          if (v == null) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
          }
        };
        G__10064 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10064__0.call(this);
            case 1:
              return G__10064__1.call(this, result);
            case 2:
              return G__10064__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10064.cljs$core$IFn$_invoke$arity$0 = G__10064__0;
        G__10064.cljs$core$IFn$_invoke$arity$1 = G__10064__1;
        G__10064.cljs$core$IFn$_invoke$arity$2 = G__10064__2;
        return G__10064;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4657__auto__ = cljs.core.seq(coll__$1);
      if (temp__4657__auto__) {
        var s = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__7332__auto___10065 = size;
          var i_10066 = 0;
          while (true) {
            if (i_10066 < n__7332__auto___10065) {
              var x_10067 = function() {
                var G__10056 = idx + i_10066;
                var G__10057 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10066);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10056, G__10057) : f.call(null, G__10056, G__10057);
              }();
              if (x_10067 == null) {
              } else {
                cljs.core.chunk_append(b, x_10067);
              }
              var G__10068 = i_10066 + 1;
              i_10066 = G__10068;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__10058 = idx;
            var G__10059 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10058, G__10059) : f.call(null, G__10058, G__10059);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred(var_args) {
  var args10075 = [];
  var len__7492__auto___10082 = arguments.length;
  var i__7493__auto___10083 = 0;
  while (true) {
    if (i__7493__auto___10083 < len__7492__auto___10082) {
      args10075.push(arguments[i__7493__auto___10083]);
      var G__10084 = i__7493__auto___10083 + 1;
      i__7493__auto___10083 = G__10084;
      continue;
    } else {
    }
    break;
  }
  var G__10081 = args10075.length;
  switch(G__10081) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10075.slice(3), 0, null);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__10086__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6405__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6405__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__6405__auto__;
          }
        }());
      };
      var G__10086 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10087__i = 0, G__10087__a = new Array(arguments.length - 3);
          while (G__10087__i < G__10087__a.length) {
            G__10087__a[G__10087__i] = arguments[G__10087__i + 3];
            ++G__10087__i;
          }
          args = new cljs.core.IndexedSeq(G__10087__a, 0);
        }
        return G__10086__delegate.call(this, x, y, z, args);
      };
      G__10086.cljs$lang$maxFixedArity = 3;
      G__10086.cljs$lang$applyTo = function(arglist__10088) {
        var x = cljs.core.first(arglist__10088);
        arglist__10088 = cljs.core.next(arglist__10088);
        var y = cljs.core.first(arglist__10088);
        arglist__10088 = cljs.core.next(arglist__10088);
        var z = cljs.core.first(arglist__10088);
        var args = cljs.core.rest(arglist__10088);
        return G__10086__delegate(x, y, z, args);
      };
      G__10086.cljs$core$IFn$_invoke$arity$variadic = G__10086__delegate;
      return G__10086;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__10089 = null;
          if (arguments.length > 3) {
            var G__10090__i = 0, G__10090__a = new Array(arguments.length - 3);
            while (G__10090__i < G__10090__a.length) {
              G__10090__a[G__10090__i] = arguments[G__10090__i + 3];
              ++G__10090__i;
            }
            G__10089 = new cljs.core.IndexedSeq(G__10090__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10089);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            var and__6405__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(and__6405__auto____$2)) {
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
            } else {
              return and__6405__auto____$2;
            }
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            var and__6405__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
            if (cljs.core.truth_(and__6405__auto____$2)) {
              var and__6405__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
              if (cljs.core.truth_(and__6405__auto____$3)) {
                var and__6405__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6405__auto____$4)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                } else {
                  return and__6405__auto____$4;
                }
              } else {
                return and__6405__auto____$3;
              }
            } else {
              return and__6405__auto____$2;
            }
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__10091__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6405__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6405__auto__)) {
            return cljs.core.every_QMARK_(function(and__6405__auto__) {
              return function(p1__10069_SHARP_) {
                var and__6405__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10069_SHARP_) : p1.call(null, p1__10069_SHARP_);
                if (cljs.core.truth_(and__6405__auto____$1)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10069_SHARP_) : p2.call(null, p1__10069_SHARP_);
                } else {
                  return and__6405__auto____$1;
                }
              };
            }(and__6405__auto__), args);
          } else {
            return and__6405__auto__;
          }
        }());
      };
      var G__10091 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10092__i = 0, G__10092__a = new Array(arguments.length - 3);
          while (G__10092__i < G__10092__a.length) {
            G__10092__a[G__10092__i] = arguments[G__10092__i + 3];
            ++G__10092__i;
          }
          args = new cljs.core.IndexedSeq(G__10092__a, 0);
        }
        return G__10091__delegate.call(this, x, y, z, args);
      };
      G__10091.cljs$lang$maxFixedArity = 3;
      G__10091.cljs$lang$applyTo = function(arglist__10093) {
        var x = cljs.core.first(arglist__10093);
        arglist__10093 = cljs.core.next(arglist__10093);
        var y = cljs.core.first(arglist__10093);
        arglist__10093 = cljs.core.next(arglist__10093);
        var z = cljs.core.first(arglist__10093);
        var args = cljs.core.rest(arglist__10093);
        return G__10091__delegate(x, y, z, args);
      };
      G__10091.cljs$core$IFn$_invoke$arity$variadic = G__10091__delegate;
      return G__10091;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__10094 = null;
          if (arguments.length > 3) {
            var G__10095__i = 0, G__10095__a = new Array(arguments.length - 3);
            while (G__10095__i < G__10095__a.length) {
              G__10095__a[G__10095__i] = arguments[G__10095__i + 3];
              ++G__10095__i;
            }
            G__10094 = new cljs.core.IndexedSeq(G__10095__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10094);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            var and__6405__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__6405__auto____$2)) {
              var and__6405__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__6405__auto____$3)) {
                var and__6405__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6405__auto____$4)) {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                } else {
                  return and__6405__auto____$4;
                }
              } else {
                return and__6405__auto____$3;
              }
            } else {
              return and__6405__auto____$2;
            }
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6405__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6405__auto__)) {
          var and__6405__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6405__auto____$1)) {
            var and__6405__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__6405__auto____$2)) {
              var and__6405__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__6405__auto____$3)) {
                var and__6405__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6405__auto____$4)) {
                  var and__6405__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                  if (cljs.core.truth_(and__6405__auto____$5)) {
                    var and__6405__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                    if (cljs.core.truth_(and__6405__auto____$6)) {
                      var and__6405__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                      if (cljs.core.truth_(and__6405__auto____$7)) {
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                      } else {
                        return and__6405__auto____$7;
                      }
                    } else {
                      return and__6405__auto____$6;
                    }
                  } else {
                    return and__6405__auto____$5;
                  }
                } else {
                  return and__6405__auto____$4;
                }
              } else {
                return and__6405__auto____$3;
              }
            } else {
              return and__6405__auto____$2;
            }
          } else {
            return and__6405__auto____$1;
          }
        } else {
          return and__6405__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__10096__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6405__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6405__auto__)) {
            return cljs.core.every_QMARK_(function(and__6405__auto__) {
              return function(p1__10070_SHARP_) {
                var and__6405__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10070_SHARP_) : p1.call(null, p1__10070_SHARP_);
                if (cljs.core.truth_(and__6405__auto____$1)) {
                  var and__6405__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10070_SHARP_) : p2.call(null, p1__10070_SHARP_);
                  if (cljs.core.truth_(and__6405__auto____$2)) {
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__10070_SHARP_) : p3.call(null, p1__10070_SHARP_);
                  } else {
                    return and__6405__auto____$2;
                  }
                } else {
                  return and__6405__auto____$1;
                }
              };
            }(and__6405__auto__), args);
          } else {
            return and__6405__auto__;
          }
        }());
      };
      var G__10096 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10097__i = 0, G__10097__a = new Array(arguments.length - 3);
          while (G__10097__i < G__10097__a.length) {
            G__10097__a[G__10097__i] = arguments[G__10097__i + 3];
            ++G__10097__i;
          }
          args = new cljs.core.IndexedSeq(G__10097__a, 0);
        }
        return G__10096__delegate.call(this, x, y, z, args);
      };
      G__10096.cljs$lang$maxFixedArity = 3;
      G__10096.cljs$lang$applyTo = function(arglist__10098) {
        var x = cljs.core.first(arglist__10098);
        arglist__10098 = cljs.core.next(arglist__10098);
        var y = cljs.core.first(arglist__10098);
        arglist__10098 = cljs.core.next(arglist__10098);
        var z = cljs.core.first(arglist__10098);
        var args = cljs.core.rest(arglist__10098);
        return G__10096__delegate(x, y, z, args);
      };
      G__10096.cljs$core$IFn$_invoke$arity$variadic = G__10096__delegate;
      return G__10096;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__10099 = null;
          if (arguments.length > 3) {
            var G__10100__i = 0, G__10100__a = new Array(arguments.length - 3);
            while (G__10100__i < G__10100__a.length) {
              G__10100__a[G__10100__i] = arguments[G__10100__i + 3];
              ++G__10100__i;
            }
            G__10099 = new cljs.core.IndexedSeq(G__10100__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10099);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10071_SHARP_) {
            return p1__10071_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10071_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10071_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10072_SHARP_) {
            var and__6405__auto__ = p1__10072_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10072_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10072_SHARP_.call(null, x);
            if (cljs.core.truth_(and__6405__auto__)) {
              return p1__10072_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10072_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10072_SHARP_.call(null, y);
            } else {
              return and__6405__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10073_SHARP_) {
            var and__6405__auto__ = p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10073_SHARP_.call(null, x);
            if (cljs.core.truth_(and__6405__auto__)) {
              var and__6405__auto____$1 = p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10073_SHARP_.call(null, y);
              if (cljs.core.truth_(and__6405__auto____$1)) {
                return p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10073_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__10073_SHARP_.call(null, z);
              } else {
                return and__6405__auto____$1;
              }
            } else {
              return and__6405__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__10101__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__6405__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__6405__auto__)) {
              return cljs.core.every_QMARK_(function(and__6405__auto__, ps__$1) {
                return function(p1__10074_SHARP_) {
                  return cljs.core.every_QMARK_(p1__10074_SHARP_, args);
                };
              }(and__6405__auto__, ps__$1), ps__$1);
            } else {
              return and__6405__auto__;
            }
          }());
        };
        var G__10101 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__10102__i = 0, G__10102__a = new Array(arguments.length - 3);
            while (G__10102__i < G__10102__a.length) {
              G__10102__a[G__10102__i] = arguments[G__10102__i + 3];
              ++G__10102__i;
            }
            args = new cljs.core.IndexedSeq(G__10102__a, 0);
          }
          return G__10101__delegate.call(this, x, y, z, args);
        };
        G__10101.cljs$lang$maxFixedArity = 3;
        G__10101.cljs$lang$applyTo = function(arglist__10103) {
          var x = cljs.core.first(arglist__10103);
          arglist__10103 = cljs.core.next(arglist__10103);
          var y = cljs.core.first(arglist__10103);
          arglist__10103 = cljs.core.next(arglist__10103);
          var z = cljs.core.first(arglist__10103);
          var args = cljs.core.rest(arglist__10103);
          return G__10101__delegate(x, y, z, args);
        };
        G__10101.cljs$core$IFn$_invoke$arity$variadic = G__10101__delegate;
        return G__10101;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__10104 = null;
            if (arguments.length > 3) {
              var G__10105__i = 0, G__10105__a = new Array(arguments.length - 3);
              while (G__10105__i < G__10105__a.length) {
                G__10105__a[G__10105__i] = arguments[G__10105__i + 3];
                ++G__10105__i;
              }
              G__10104 = new cljs.core.IndexedSeq(G__10105__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10104);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq10076) {
  var G__10077 = cljs.core.first(seq10076);
  var seq10076__$1 = cljs.core.next(seq10076);
  var G__10078 = cljs.core.first(seq10076__$1);
  var seq10076__$2 = cljs.core.next(seq10076__$1);
  var G__10079 = cljs.core.first(seq10076__$2);
  var seq10076__$3 = cljs.core.next(seq10076__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__10077, G__10078, G__10079, seq10076__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn(var_args) {
  var args10112 = [];
  var len__7492__auto___10119 = arguments.length;
  var i__7493__auto___10120 = 0;
  while (true) {
    if (i__7493__auto___10120 < len__7492__auto___10119) {
      args10112.push(arguments[i__7493__auto___10120]);
      var G__10121 = i__7493__auto___10120 + 1;
      i__7493__auto___10120 = G__10121;
      continue;
    } else {
    }
    break;
  }
  var G__10118 = args10112.length;
  switch(G__10118) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10112.slice(3), 0, null);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7511__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__6417__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__6417__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__10123__delegate = function(x, y, z, args) {
        var or__6417__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6417__auto__)) {
          return or__6417__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__10123 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10124__i = 0, G__10124__a = new Array(arguments.length - 3);
          while (G__10124__i < G__10124__a.length) {
            G__10124__a[G__10124__i] = arguments[G__10124__i + 3];
            ++G__10124__i;
          }
          args = new cljs.core.IndexedSeq(G__10124__a, 0);
        }
        return G__10123__delegate.call(this, x, y, z, args);
      };
      G__10123.cljs$lang$maxFixedArity = 3;
      G__10123.cljs$lang$applyTo = function(arglist__10125) {
        var x = cljs.core.first(arglist__10125);
        arglist__10125 = cljs.core.next(arglist__10125);
        var y = cljs.core.first(arglist__10125);
        arglist__10125 = cljs.core.next(arglist__10125);
        var z = cljs.core.first(arglist__10125);
        var args = cljs.core.rest(arglist__10125);
        return G__10123__delegate(x, y, z, args);
      };
      G__10123.cljs$core$IFn$_invoke$arity$variadic = G__10123__delegate;
      return G__10123;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__10126 = null;
          if (arguments.length > 3) {
            var G__10127__i = 0, G__10127__a = new Array(arguments.length - 3);
            while (G__10127__i < G__10127__a.length) {
              G__10127__a[G__10127__i] = arguments[G__10127__i + 3];
              ++G__10127__i;
            }
            G__10126 = new cljs.core.IndexedSeq(G__10127__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10126);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          var or__6417__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(or__6417__auto____$2)) {
            return or__6417__auto____$2;
          } else {
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          var or__6417__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
          if (cljs.core.truth_(or__6417__auto____$2)) {
            return or__6417__auto____$2;
          } else {
            var or__6417__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(or__6417__auto____$3)) {
              return or__6417__auto____$3;
            } else {
              var or__6417__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6417__auto____$4)) {
                return or__6417__auto____$4;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__10128__delegate = function(x, y, z, args) {
        var or__6417__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6417__auto__)) {
          return or__6417__auto__;
        } else {
          return cljs.core.some(function(or__6417__auto__) {
            return function(p1__10106_SHARP_) {
              var or__6417__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10106_SHARP_) : p1.call(null, p1__10106_SHARP_);
              if (cljs.core.truth_(or__6417__auto____$1)) {
                return or__6417__auto____$1;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10106_SHARP_) : p2.call(null, p1__10106_SHARP_);
              }
            };
          }(or__6417__auto__), args);
        }
      };
      var G__10128 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10129__i = 0, G__10129__a = new Array(arguments.length - 3);
          while (G__10129__i < G__10129__a.length) {
            G__10129__a[G__10129__i] = arguments[G__10129__i + 3];
            ++G__10129__i;
          }
          args = new cljs.core.IndexedSeq(G__10129__a, 0);
        }
        return G__10128__delegate.call(this, x, y, z, args);
      };
      G__10128.cljs$lang$maxFixedArity = 3;
      G__10128.cljs$lang$applyTo = function(arglist__10130) {
        var x = cljs.core.first(arglist__10130);
        arglist__10130 = cljs.core.next(arglist__10130);
        var y = cljs.core.first(arglist__10130);
        arglist__10130 = cljs.core.next(arglist__10130);
        var z = cljs.core.first(arglist__10130);
        var args = cljs.core.rest(arglist__10130);
        return G__10128__delegate(x, y, z, args);
      };
      G__10128.cljs$core$IFn$_invoke$arity$variadic = G__10128__delegate;
      return G__10128;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__10131 = null;
          if (arguments.length > 3) {
            var G__10132__i = 0, G__10132__a = new Array(arguments.length - 3);
            while (G__10132__i < G__10132__a.length) {
              G__10132__a[G__10132__i] = arguments[G__10132__i + 3];
              ++G__10132__i;
            }
            G__10131 = new cljs.core.IndexedSeq(G__10132__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10131);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          var or__6417__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__6417__auto____$2)) {
            return or__6417__auto____$2;
          } else {
            var or__6417__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__6417__auto____$3)) {
              return or__6417__auto____$3;
            } else {
              var or__6417__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6417__auto____$4)) {
                return or__6417__auto____$4;
              } else {
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__6417__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        var or__6417__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6417__auto____$1)) {
          return or__6417__auto____$1;
        } else {
          var or__6417__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__6417__auto____$2)) {
            return or__6417__auto____$2;
          } else {
            var or__6417__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__6417__auto____$3)) {
              return or__6417__auto____$3;
            } else {
              var or__6417__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6417__auto____$4)) {
                return or__6417__auto____$4;
              } else {
                var or__6417__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                if (cljs.core.truth_(or__6417__auto____$5)) {
                  return or__6417__auto____$5;
                } else {
                  var or__6417__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                  if (cljs.core.truth_(or__6417__auto____$6)) {
                    return or__6417__auto____$6;
                  } else {
                    var or__6417__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                    if (cljs.core.truth_(or__6417__auto____$7)) {
                      return or__6417__auto____$7;
                    } else {
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__10133__delegate = function(x, y, z, args) {
        var or__6417__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6417__auto__)) {
          return or__6417__auto__;
        } else {
          return cljs.core.some(function(or__6417__auto__) {
            return function(p1__10107_SHARP_) {
              var or__6417__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10107_SHARP_) : p1.call(null, p1__10107_SHARP_);
              if (cljs.core.truth_(or__6417__auto____$1)) {
                return or__6417__auto____$1;
              } else {
                var or__6417__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10107_SHARP_) : p2.call(null, p1__10107_SHARP_);
                if (cljs.core.truth_(or__6417__auto____$2)) {
                  return or__6417__auto____$2;
                } else {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__10107_SHARP_) : p3.call(null, p1__10107_SHARP_);
                }
              }
            };
          }(or__6417__auto__), args);
        }
      };
      var G__10133 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10134__i = 0, G__10134__a = new Array(arguments.length - 3);
          while (G__10134__i < G__10134__a.length) {
            G__10134__a[G__10134__i] = arguments[G__10134__i + 3];
            ++G__10134__i;
          }
          args = new cljs.core.IndexedSeq(G__10134__a, 0);
        }
        return G__10133__delegate.call(this, x, y, z, args);
      };
      G__10133.cljs$lang$maxFixedArity = 3;
      G__10133.cljs$lang$applyTo = function(arglist__10135) {
        var x = cljs.core.first(arglist__10135);
        arglist__10135 = cljs.core.next(arglist__10135);
        var y = cljs.core.first(arglist__10135);
        arglist__10135 = cljs.core.next(arglist__10135);
        var z = cljs.core.first(arglist__10135);
        var args = cljs.core.rest(arglist__10135);
        return G__10133__delegate(x, y, z, args);
      };
      G__10133.cljs$core$IFn$_invoke$arity$variadic = G__10133__delegate;
      return G__10133;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__10136 = null;
          if (arguments.length > 3) {
            var G__10137__i = 0, G__10137__a = new Array(arguments.length - 3);
            while (G__10137__i < G__10137__a.length) {
              G__10137__a[G__10137__i] = arguments[G__10137__i + 3];
              ++G__10137__i;
            }
            G__10136 = new cljs.core.IndexedSeq(G__10137__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10136);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10108_SHARP_) {
            return p1__10108_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10108_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10108_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10109_SHARP_) {
            var or__6417__auto__ = p1__10109_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10109_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10109_SHARP_.call(null, x);
            if (cljs.core.truth_(or__6417__auto__)) {
              return or__6417__auto__;
            } else {
              return p1__10109_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10109_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10109_SHARP_.call(null, y);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10110_SHARP_) {
            var or__6417__auto__ = p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10110_SHARP_.call(null, x);
            if (cljs.core.truth_(or__6417__auto__)) {
              return or__6417__auto__;
            } else {
              var or__6417__auto____$1 = p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10110_SHARP_.call(null, y);
              if (cljs.core.truth_(or__6417__auto____$1)) {
                return or__6417__auto____$1;
              } else {
                return p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10110_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__10110_SHARP_.call(null, z);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__10138__delegate = function(x, y, z, args) {
          var or__6417__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__6417__auto__)) {
            return or__6417__auto__;
          } else {
            return cljs.core.some(function(or__6417__auto__, ps__$1) {
              return function(p1__10111_SHARP_) {
                return cljs.core.some(p1__10111_SHARP_, args);
              };
            }(or__6417__auto__, ps__$1), ps__$1);
          }
        };
        var G__10138 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__10139__i = 0, G__10139__a = new Array(arguments.length - 3);
            while (G__10139__i < G__10139__a.length) {
              G__10139__a[G__10139__i] = arguments[G__10139__i + 3];
              ++G__10139__i;
            }
            args = new cljs.core.IndexedSeq(G__10139__a, 0);
          }
          return G__10138__delegate.call(this, x, y, z, args);
        };
        G__10138.cljs$lang$maxFixedArity = 3;
        G__10138.cljs$lang$applyTo = function(arglist__10140) {
          var x = cljs.core.first(arglist__10140);
          arglist__10140 = cljs.core.next(arglist__10140);
          var y = cljs.core.first(arglist__10140);
          arglist__10140 = cljs.core.next(arglist__10140);
          var z = cljs.core.first(arglist__10140);
          var args = cljs.core.rest(arglist__10140);
          return G__10138__delegate(x, y, z, args);
        };
        G__10138.cljs$core$IFn$_invoke$arity$variadic = G__10138__delegate;
        return G__10138;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__10141 = null;
            if (arguments.length > 3) {
              var G__10142__i = 0, G__10142__a = new Array(arguments.length - 3);
              while (G__10142__i < G__10142__a.length) {
                G__10142__a[G__10142__i] = arguments[G__10142__i + 3];
                ++G__10142__i;
              }
              G__10141 = new cljs.core.IndexedSeq(G__10142__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10141);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq10113) {
  var G__10114 = cljs.core.first(seq10113);
  var seq10113__$1 = cljs.core.next(seq10113);
  var G__10115 = cljs.core.first(seq10113__$1);
  var seq10113__$2 = cljs.core.next(seq10113__$1);
  var G__10116 = cljs.core.first(seq10113__$2);
  var seq10113__$3 = cljs.core.next(seq10113__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__10114, G__10115, G__10116, seq10113__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map(var_args) {
  var args10144 = [];
  var len__7492__auto___10164 = arguments.length;
  var i__7493__auto___10165 = 0;
  while (true) {
    if (i__7493__auto___10165 < len__7492__auto___10164) {
      args10144.push(arguments[i__7493__auto___10165]);
      var G__10166 = i__7493__auto___10165 + 1;
      i__7493__auto___10165 = G__10166;
      continue;
    } else {
    }
    break;
  }
  var G__10151 = args10144.length;
  switch(G__10151) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10144.slice(4), 0, null);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7511__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__10168 = null;
      var G__10168__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__10168__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__10168__2 = function(result, input) {
        var G__10152 = result;
        var G__10153 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10152, G__10153) : rf.call(null, G__10152, G__10153);
      };
      var G__10168__3 = function() {
        var G__10169__delegate = function(result, input, inputs) {
          var G__10154 = result;
          var G__10155 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10154, G__10155) : rf.call(null, G__10154, G__10155);
        };
        var G__10169 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__10170__i = 0, G__10170__a = new Array(arguments.length - 2);
            while (G__10170__i < G__10170__a.length) {
              G__10170__a[G__10170__i] = arguments[G__10170__i + 2];
              ++G__10170__i;
            }
            inputs = new cljs.core.IndexedSeq(G__10170__a, 0);
          }
          return G__10169__delegate.call(this, result, input, inputs);
        };
        G__10169.cljs$lang$maxFixedArity = 2;
        G__10169.cljs$lang$applyTo = function(arglist__10171) {
          var result = cljs.core.first(arglist__10171);
          arglist__10171 = cljs.core.next(arglist__10171);
          var input = cljs.core.first(arglist__10171);
          var inputs = cljs.core.rest(arglist__10171);
          return G__10169__delegate(result, input, inputs);
        };
        G__10169.cljs$core$IFn$_invoke$arity$variadic = G__10169__delegate;
        return G__10169;
      }();
      G__10168 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__10168__0.call(this);
          case 1:
            return G__10168__1.call(this, result);
          case 2:
            return G__10168__2.call(this, result, input);
          default:
            var G__10172 = null;
            if (arguments.length > 2) {
              var G__10173__i = 0, G__10173__a = new Array(arguments.length - 2);
              while (G__10173__i < G__10173__a.length) {
                G__10173__a[G__10173__i] = arguments[G__10173__i + 2];
                ++G__10173__i;
              }
              G__10172 = new cljs.core.IndexedSeq(G__10173__a, 0);
            }
            return G__10168__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__10172);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__10168.cljs$lang$maxFixedArity = 2;
      G__10168.cljs$lang$applyTo = G__10168__3.cljs$lang$applyTo;
      G__10168.cljs$core$IFn$_invoke$arity$0 = G__10168__0;
      G__10168.cljs$core$IFn$_invoke$arity$1 = G__10168__1;
      G__10168.cljs$core$IFn$_invoke$arity$2 = G__10168__2;
      G__10168.cljs$core$IFn$_invoke$arity$variadic = G__10168__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__10168;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7332__auto___10174 = size;
        var i_10175 = 0;
        while (true) {
          if (i_10175 < n__7332__auto___10174) {
            cljs.core.chunk_append(b, function() {
              var G__10156 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10175);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10156) : f.call(null, G__10156);
            }());
            var G__10176 = i_10175 + 1;
            i_10175 = G__10176;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__10157 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10157) : f.call(null, G__10157);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__10158 = cljs.core.first(s1);
        var G__10159 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10158, G__10159) : f.call(null, G__10158, G__10159);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__10160 = cljs.core.first(s1);
        var G__10161 = cljs.core.first(s2);
        var G__10162 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10160, G__10161, G__10162) : f.call(null, G__10160, G__10161, G__10162);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__10143_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__10143_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq10145) {
  var G__10146 = cljs.core.first(seq10145);
  var seq10145__$1 = cljs.core.next(seq10145);
  var G__10147 = cljs.core.first(seq10145__$1);
  var seq10145__$2 = cljs.core.next(seq10145__$1);
  var G__10148 = cljs.core.first(seq10145__$2);
  var seq10145__$3 = cljs.core.next(seq10145__$2);
  var G__10149 = cljs.core.first(seq10145__$3);
  var seq10145__$4 = cljs.core.next(seq10145__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__10146, G__10147, G__10148, G__10149, seq10145__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take(var_args) {
  var args10177 = [];
  var len__7492__auto___10180 = arguments.length;
  var i__7493__auto___10181 = 0;
  while (true) {
    if (i__7493__auto___10181 < len__7492__auto___10180) {
      args10177.push(arguments[i__7493__auto___10181]);
      var G__10182 = i__7493__auto___10181 + 1;
      i__7493__auto___10181 = G__10182;
      continue;
    } else {
    }
    break;
  }
  var G__10179 = args10177.length;
  switch(G__10179) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10177.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__10184 = null;
        var G__10184__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10184__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10184__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input) : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__10184 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10184__0.call(this);
            case 1:
              return G__10184__1.call(this, result);
            case 2:
              return G__10184__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10184.cljs$core$IFn$_invoke$arity$0 = G__10184__0;
        G__10184.cljs$core$IFn$_invoke$arity$1 = G__10184__1;
        G__10184.cljs$core$IFn$_invoke$arity$2 = G__10184__2;
        return G__10184;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4657__auto__ = cljs.core.seq(coll);
      if (temp__4657__auto__) {
        var s = temp__4657__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop(var_args) {
  var args10185 = [];
  var len__7492__auto___10188 = arguments.length;
  var i__7493__auto___10189 = 0;
  while (true) {
    if (i__7493__auto___10189 < len__7492__auto___10188) {
      args10185.push(arguments[i__7493__auto___10189]);
      var G__10190 = i__7493__auto___10189 + 1;
      i__7493__auto___10189 = G__10190;
      continue;
    } else {
    }
    break;
  }
  var G__10187 = args10185.length;
  switch(G__10187) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10185.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__10192 = null;
        var G__10192__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10192__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10192__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__10192 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10192__0.call(this);
            case 1:
              return G__10192__1.call(this, result);
            case 2:
              return G__10192__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10192.cljs$core$IFn$_invoke$arity$0 = G__10192__0;
        G__10192.cljs$core$IFn$_invoke$arity$1 = G__10192__1;
        G__10192.cljs$core$IFn$_invoke$arity$2 = G__10192__2;
        return G__10192;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__10193 = n__$1 - 1;
        var G__10194 = cljs.core.rest(s);
        n__$1 = G__10193;
        coll__$1 = G__10194;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last(var_args) {
  var args10195 = [];
  var len__7492__auto___10198 = arguments.length;
  var i__7493__auto___10199 = 0;
  while (true) {
    if (i__7493__auto___10199 < len__7492__auto___10198) {
      args10195.push(arguments[i__7493__auto___10199]);
      var G__10200 = i__7493__auto___10199 + 1;
      i__7493__auto___10199 = G__10200;
      continue;
    } else {
    }
    break;
  }
  var G__10197 = args10195.length;
  switch(G__10197) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10195.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__10202 = cljs.core.next(s);
      var G__10203 = cljs.core.next(lead);
      s = G__10202;
      lead = G__10203;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while(var_args) {
  var args10204 = [];
  var len__7492__auto___10209 = arguments.length;
  var i__7493__auto___10210 = 0;
  while (true) {
    if (i__7493__auto___10210 < len__7492__auto___10209) {
      args10204.push(arguments[i__7493__auto___10210]);
      var G__10211 = i__7493__auto___10210 + 1;
      i__7493__auto___10210 = G__10211;
      continue;
    } else {
    }
    break;
  }
  var G__10206 = args10204.length;
  switch(G__10206) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10204.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__10213 = null;
        var G__10213__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10213__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10213__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__6405__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__6405__auto__)) {
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input);
            } else {
              return and__6405__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__10213 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10213__0.call(this);
            case 1:
              return G__10213__1.call(this, result);
            case 2:
              return G__10213__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10213.cljs$core$IFn$_invoke$arity$0 = G__10213__0;
        G__10213.cljs$core$IFn$_invoke$arity$1 = G__10213__1;
        G__10213.cljs$core$IFn$_invoke$arity$2 = G__10213__2;
        return G__10213;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__6405__auto__ = s;
        if (and__6405__auto__) {
          var G__10208 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__10208) : pred__$1.call(null, G__10208);
        } else {
          return and__6405__auto__;
        }
      }())) {
        var G__10214 = pred__$1;
        var G__10215 = cljs.core.rest(s);
        pred__$1 = G__10214;
        coll__$1 = G__10215;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat(var_args) {
  var args10216 = [];
  var len__7492__auto___10219 = arguments.length;
  var i__7493__auto___10220 = 0;
  while (true) {
    if (i__7493__auto___10220 < len__7492__auto___10219) {
      args10216.push(arguments[i__7493__auto___10220]);
      var G__10221 = i__7493__auto___10220 + 1;
      i__7493__auto___10220 = G__10221;
      continue;
    } else {
    }
    break;
  }
  var G__10218 = args10216.length;
  switch(G__10218) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10216.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly(var_args) {
  var args10223 = [];
  var len__7492__auto___10226 = arguments.length;
  var i__7493__auto___10227 = 0;
  while (true) {
    if (i__7493__auto___10227 < len__7492__auto___10226) {
      args10223.push(arguments[i__7493__auto___10227]);
      var G__10228 = i__7493__auto___10227 + 1;
      i__7493__auto___10227 = G__10228;
      continue;
    } else {
    }
    break;
  }
  var G__10225 = args10223.length;
  switch(G__10225) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10223.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave(var_args) {
  var args10232 = [];
  var len__7492__auto___10238 = arguments.length;
  var i__7493__auto___10239 = 0;
  while (true) {
    if (i__7493__auto___10239 < len__7492__auto___10238) {
      args10232.push(arguments[i__7493__auto___10239]);
      var G__10240 = i__7493__auto___10239 + 1;
      i__7493__auto___10239 = G__10240;
      continue;
    } else {
    }
    break;
  }
  var G__10237 = args10232.length;
  switch(G__10237) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10232.slice(2), 0, null);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7511__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq10233) {
  var G__10234 = cljs.core.first(seq10233);
  var seq10233__$1 = cljs.core.next(seq10233);
  var G__10235 = cljs.core.first(seq10233__$1);
  var seq10233__$2 = cljs.core.next(seq10233__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__10234, G__10235, seq10233__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose(var_args) {
  var args10242 = [];
  var len__7492__auto___10245 = arguments.length;
  var i__7493__auto___10246 = 0;
  while (true) {
    if (i__7493__auto___10246 < len__7492__auto___10245) {
      args10242.push(arguments[i__7493__auto___10246]);
      var G__10247 = i__7493__auto___10246 + 1;
      i__7493__auto___10246 = G__10247;
      continue;
    } else {
    }
    break;
  }
  var G__10244 = args10242.length;
  switch(G__10244) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10242.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__10249 = null;
        var G__10249__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10249__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10249__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, sep) : rf.call(null, result, sep);
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr, input) : rf.call(null, sepr, input);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__10249 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10249__0.call(this);
            case 1:
              return G__10249__1.call(this, result);
            case 2:
              return G__10249__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10249.cljs$core$IFn$_invoke$arity$0 = G__10249__0;
        G__10249.cljs$core$IFn$_invoke$arity$1 = G__10249__1;
        G__10249.cljs$core$IFn$_invoke$arity$2 = G__10249__2;
        return G__10249;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4655__auto__ = cljs.core.seq(coll);
      if (temp__4655__auto__) {
        var coll__$1 = temp__4655__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat(var_args) {
  var args10258 = [];
  var len__7492__auto___10263 = arguments.length;
  var i__7493__auto___10264 = 0;
  while (true) {
    if (i__7493__auto___10264 < len__7492__auto___10263) {
      args10258.push(arguments[i__7493__auto___10264]);
      var G__10265 = i__7493__auto___10264 + 1;
      i__7493__auto___10264 = G__10265;
      continue;
    } else {
    }
    break;
  }
  var G__10262 = args10258.length;
  switch(G__10262) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10258.slice(1), 0, null);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7511__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq10259) {
  var G__10260 = cljs.core.first(seq10259);
  var seq10259__$1 = cljs.core.next(seq10259);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__10260, seq10259__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter(var_args) {
  var args10267 = [];
  var len__7492__auto___10271 = arguments.length;
  var i__7493__auto___10272 = 0;
  while (true) {
    if (i__7493__auto___10272 < len__7492__auto___10271) {
      args10267.push(arguments[i__7493__auto___10272]);
      var G__10273 = i__7493__auto___10272 + 1;
      i__7493__auto___10272 = G__10273;
      continue;
    } else {
    }
    break;
  }
  var G__10269 = args10267.length;
  switch(G__10269) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10267.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__10275 = null;
      var G__10275__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__10275__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__10275__2 = function(result, input) {
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input))) {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
        } else {
          return result;
        }
      };
      G__10275 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__10275__0.call(this);
          case 1:
            return G__10275__1.call(this, result);
          case 2:
            return G__10275__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__10275.cljs$core$IFn$_invoke$arity$0 = G__10275__0;
      G__10275.cljs$core$IFn$_invoke$arity$1 = G__10275__1;
      G__10275.cljs$core$IFn$_invoke$arity$2 = G__10275__2;
      return G__10275;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7332__auto___10276 = size;
        var i_10277 = 0;
        while (true) {
          if (i_10277 < n__7332__auto___10276) {
            if (cljs.core.truth_(function() {
              var G__10270 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10277);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10270) : pred.call(null, G__10270);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10277));
            } else {
            }
            var G__10278 = i_10277 + 1;
            i_10277 = G__10278;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f))) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove(var_args) {
  var args10279 = [];
  var len__7492__auto___10282 = arguments.length;
  var i__7493__auto___10283 = 0;
  while (true) {
    if (i__7493__auto___10283 < len__7492__auto___10282) {
      args10279.push(arguments[i__7493__auto___10283]);
      var G__10284 = i__7493__auto___10283 + 1;
      i__7493__auto___10283 = G__10284;
      continue;
    } else {
    }
    break;
  }
  var G__10281 = args10279.length;
  switch(G__10281) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10279.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node)], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__10286_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__10286_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into(var_args) {
  var args10287 = [];
  var len__7492__auto___10292 = arguments.length;
  var i__7493__auto___10293 = 0;
  while (true) {
    if (i__7493__auto___10293 < len__7492__auto___10292) {
      args10287.push(arguments[i__7493__auto___10293]);
      var G__10294 = i__7493__auto___10293 + 1;
      i__7493__auto___10293 = G__10294;
      continue;
    } else {
    }
    break;
  }
  var G__10289 = args10287.length;
  switch(G__10289) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10287.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || to.cljs$core$IEditableCollection$ ? true : false : false) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || to.cljs$core$IEditableCollection$ ? true : false : false) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv(var_args) {
  var args10296 = [];
  var len__7492__auto___10304 = arguments.length;
  var i__7493__auto___10305 = 0;
  while (true) {
    if (i__7493__auto___10305 < len__7492__auto___10304) {
      args10296.push(arguments[i__7493__auto___10305]);
      var G__10306 = i__7493__auto___10305 + 1;
      i__7493__auto___10305 = G__10306;
      continue;
    } else {
    }
    break;
  }
  var G__10303 = args10296.length;
  switch(G__10303) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10296.slice(4), 0, null);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7511__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o));
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq10297) {
  var G__10298 = cljs.core.first(seq10297);
  var seq10297__$1 = cljs.core.next(seq10297);
  var G__10299 = cljs.core.first(seq10297__$1);
  var seq10297__$2 = cljs.core.next(seq10297__$1);
  var G__10300 = cljs.core.first(seq10297__$2);
  var seq10297__$3 = cljs.core.next(seq10297__$2);
  var G__10301 = cljs.core.first(seq10297__$3);
  var seq10297__$4 = cljs.core.next(seq10297__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__10298, G__10299, G__10300, G__10301, seq10297__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o))) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition(var_args) {
  var args10308 = [];
  var len__7492__auto___10311 = arguments.length;
  var i__7493__auto___10312 = 0;
  while (true) {
    if (i__7493__auto___10312 < len__7492__auto___10311) {
      args10308.push(arguments[i__7493__auto___10312]);
      var G__10313 = i__7493__auto___10312 + 1;
      i__7493__auto___10312 = G__10313;
      continue;
    } else {
    }
    break;
  }
  var G__10310 = args10308.length;
  switch(G__10310) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10308.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4657__auto__ = cljs.core.seq(coll);
    if (temp__4657__auto__) {
      var s = temp__4657__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        var x__7251__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad));
        return cljs.core._conj(cljs.core.List.EMPTY, x__7251__auto__);
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in(var_args) {
  var args10315 = [];
  var len__7492__auto___10318 = arguments.length;
  var i__7493__auto___10319 = 0;
  while (true) {
    if (i__7493__auto___10319 < len__7492__auto___10318) {
      args10315.push(arguments[i__7493__auto___10319]);
      var G__10320 = i__7493__auto___10319 + 1;
      i__7493__auto___10319 = G__10320;
      continue;
    } else {
    }
    break;
  }
  var G__10317 = args10315.length;
  switch(G__10317) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10315.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get, m, ks);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (!(ks__$1 == null)) {
      var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
      if (sentinel === m__$2) {
        return not_found;
      } else {
        var G__10322 = sentinel;
        var G__10323 = m__$2;
        var G__10324 = cljs.core.next(ks__$1);
        sentinel = G__10322;
        m__$1 = G__10323;
        ks__$1 = G__10324;
        continue;
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__10325, v) {
  var vec__10332 = p__10325;
  var seq__10333 = cljs.core.seq(vec__10332);
  var first__10334 = cljs.core.first(seq__10333);
  var seq__10333__$1 = cljs.core.next(seq__10333);
  var k = first__10334;
  var ks = seq__10333__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in(var_args) {
  var args10335 = [];
  var len__7492__auto___10375 = arguments.length;
  var i__7493__auto___10376 = 0;
  while (true) {
    if (i__7493__auto___10376 < len__7492__auto___10375) {
      args10335.push(arguments[i__7493__auto___10376]);
      var G__10377 = i__7493__auto___10376 + 1;
      i__7493__auto___10376 = G__10377;
      continue;
    } else {
    }
    break;
  }
  var G__10344 = args10335.length;
  switch(G__10344) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10335.slice(6), 0, null);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7511__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__10345, f) {
  var vec__10346 = p__10345;
  var seq__10347 = cljs.core.seq(vec__10346);
  var first__10348 = cljs.core.first(seq__10347);
  var seq__10347__$1 = cljs.core.next(seq__10347);
  var k = first__10348;
  var ks = seq__10347__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__10349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10349) : f.call(null, G__10349);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__10350, f, a) {
  var vec__10351 = p__10350;
  var seq__10352 = cljs.core.seq(vec__10351);
  var first__10353 = cljs.core.first(seq__10352);
  var seq__10352__$1 = cljs.core.next(seq__10352);
  var k = first__10353;
  var ks = seq__10352__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__10354 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__10355 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10354, G__10355) : f.call(null, G__10354, G__10355);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__10356, f, a, b) {
  var vec__10357 = p__10356;
  var seq__10358 = cljs.core.seq(vec__10357);
  var first__10359 = cljs.core.first(seq__10358);
  var seq__10358__$1 = cljs.core.next(seq__10358);
  var k = first__10359;
  var ks = seq__10358__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__10360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__10361 = a;
      var G__10362 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10360, G__10361, G__10362) : f.call(null, G__10360, G__10361, G__10362);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__10363, f, a, b, c) {
  var vec__10364 = p__10363;
  var seq__10365 = cljs.core.seq(vec__10364);
  var first__10366 = cljs.core.first(seq__10365);
  var seq__10365__$1 = cljs.core.next(seq__10365);
  var k = first__10366;
  var ks = seq__10365__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__10367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__10368 = a;
      var G__10369 = b;
      var G__10370 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10367, G__10368, G__10369, G__10370) : f.call(null, G__10367, G__10368, G__10369, G__10370);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__10371, f, a, b, c, args) {
  var vec__10372 = p__10371;
  var seq__10373 = cljs.core.seq(vec__10372);
  var first__10374 = cljs.core.first(seq__10373);
  var seq__10373__$1 = cljs.core.next(seq__10373);
  var k = first__10374;
  var ks = seq__10373__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq10336) {
  var G__10337 = cljs.core.first(seq10336);
  var seq10336__$1 = cljs.core.next(seq10336);
  var G__10338 = cljs.core.first(seq10336__$1);
  var seq10336__$2 = cljs.core.next(seq10336__$1);
  var G__10339 = cljs.core.first(seq10336__$2);
  var seq10336__$3 = cljs.core.next(seq10336__$2);
  var G__10340 = cljs.core.first(seq10336__$3);
  var seq10336__$4 = cljs.core.next(seq10336__$3);
  var G__10341 = cljs.core.first(seq10336__$4);
  var seq10336__$5 = cljs.core.next(seq10336__$4);
  var G__10342 = cljs.core.first(seq10336__$5);
  var seq10336__$6 = cljs.core.next(seq10336__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__10337, G__10338, G__10339, G__10340, G__10341, G__10342, seq10336__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update(var_args) {
  var args10379 = [];
  var len__7492__auto___10399 = arguments.length;
  var i__7493__auto___10400 = 0;
  while (true) {
    if (i__7493__auto___10400 < len__7492__auto___10399) {
      args10379.push(arguments[i__7493__auto___10400]);
      var G__10401 = i__7493__auto___10400 + 1;
      i__7493__auto___10400 = G__10401;
      continue;
    } else {
    }
    break;
  }
  var G__10388 = args10379.length;
  switch(G__10388) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7511__auto__ = new cljs.core.IndexedSeq(args10379.slice(6), 0, null);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7511__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__10389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10389) : f.call(null, G__10389);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__10390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__10391 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10390, G__10391) : f.call(null, G__10390, G__10391);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__10392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__10393 = x;
    var G__10394 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10392, G__10393, G__10394) : f.call(null, G__10392, G__10393, G__10394);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__10395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__10396 = x;
    var G__10397 = y;
    var G__10398 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10395, G__10396, G__10397, G__10398) : f.call(null, G__10395, G__10396, G__10397, G__10398);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq10380) {
  var G__10381 = cljs.core.first(seq10380);
  var seq10380__$1 = cljs.core.next(seq10380);
  var G__10382 = cljs.core.first(seq10380__$1);
  var seq10380__$2 = cljs.core.next(seq10380__$1);
  var G__10383 = cljs.core.first(seq10380__$2);
  var seq10380__$3 = cljs.core.next(seq10380__$2);
  var G__10384 = cljs.core.first(seq10380__$3);
  var seq10380__$4 = cljs.core.next(seq10380__$3);
  var G__10385 = cljs.core.first(seq10380__$4);
  var seq10380__$5 = cljs.core.next(seq10380__$4);
  var G__10386 = cljs.core.first(seq10380__$5);
  var seq10380__$6 = cljs.core.next(seq10380__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__10381, G__10382, G__10383, G__10384, G__10385, G__10386, seq10380__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__10403 = ll - 5;
      var G__10404 = r;
      ll = G__10403;
      ret = G__10404;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__10409 = cljs.core.pv_aget(node, 0);
      var G__10410 = level - 5;
      node = G__10409;
      level = G__10410;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__10411 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__10412 = level - 5;
        node = G__10411;
        level = G__10412;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.indexOf = function() {
  var G__10431 = null;
  var G__10431__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10431__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10431 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10431__1.call(this, x);
      case 2:
        return G__10431__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10431.cljs$core$IFn$_invoke$arity$1 = G__10431__1;
  G__10431.cljs$core$IFn$_invoke$arity$2 = G__10431__2;
  return G__10431;
}();
cljs.core.PersistentVector.prototype.lastIndexOf = function() {
  var G__10432 = null;
  var G__10432__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10432__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10432 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10432__1.call(this, x);
      case 2:
        return G__10432__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10432.cljs$core$IFn$_invoke$arity$1 = G__10432__1;
  G__10432.cljs$core$IFn$_invoke$arity$2 = G__10432__2;
  return G__10432;
}();
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__10422 = init__$2;
              var G__10423 = j + i;
              var G__10424 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10422, G__10423, G__10424) : f.call(null, G__10422, G__10423, G__10424);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__10433 = j + 1;
              var G__10434 = init__$3;
              j = G__10433;
              init__$2 = G__10434;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10435 = i + len;
        var G__10436 = init__$2;
        i = G__10435;
        init__$1 = G__10436;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null, self__.root), cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null, self__.tail));
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__10425 = init__$2;
              var G__10426 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10425, G__10426) : f.call(null, G__10425, G__10426);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__10437 = j + 1;
              var G__10438 = init__$3;
              j = G__10437;
              init__$2 = G__10438;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10439 = i + len;
        var G__10440 = init__$2;
        i = G__10439;
        init__$1 = G__10440;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0, null);
    } else {
      var G__10427 = coll__$1;
      var G__10428 = cljs.core.first_array_for_longvec(coll__$1);
      var G__10429 = 0;
      var G__10430 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10427, G__10428, G__10429, G__10430) : cljs.core.chunked_seq.call(null, G__10427, G__10428, G__10429, G__10430);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__7332__auto___10441 = len;
    var i_10442 = 0;
    while (true) {
      if (i_10442 < n__7332__auto___10441) {
        new_tail[i_10442] = self__.tail[i_10442];
        var G__10443 = i_10442 + 1;
        i_10442 = G__10443;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__10444 = null;
  var G__10444__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__10444__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__10444 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10444__2.call(this, self__, k);
      case 3:
        return G__10444__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10444.cljs$core$IFn$_invoke$arity$2 = G__10444__2;
  G__10444.cljs$core$IFn$_invoke$arity$3 = G__10444__3;
  return G__10444;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args10421) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10421)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__10445 = i + 1;
        var G__10446 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__10445;
        out = G__10446;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector(var_args) {
  var args__7499__auto__ = [];
  var len__7492__auto___10448 = arguments.length;
  var i__7493__auto___10449 = 0;
  while (true) {
    if (i__7493__auto___10449 < len__7492__auto___10448) {
      args__7499__auto__.push(arguments[i__7493__auto___10449]);
      var G__10450 = i__7493__auto___10449 + 1;
      i__7493__auto___10449 = G__10450;
      continue;
    } else {
    }
    break;
  }
  var argseq__7500__auto__ = 0 < args__7499__auto__.length ? new cljs.core.IndexedSeq(args__7499__auto__.slice(0), 0, null) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq10447) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10447));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.indexOf = function() {
  var G__10473 = null;
  var G__10473__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10473__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10473 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10473__1.call(this, x);
      case 2:
        return G__10473__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10473.cljs$core$IFn$_invoke$arity$1 = G__10473__1;
  G__10473.cljs$core$IFn$_invoke$arity$2 = G__10473__2;
  return G__10473;
}();
cljs.core.ChunkedSeq.prototype.lastIndexOf = function() {
  var G__10474 = null;
  var G__10474__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10474__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10474 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10474__1.call(this, x);
      case 2:
        return G__10474__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10474.cljs$core$IFn$_invoke$arity$1 = G__10474__1;
  G__10474.cljs$core$IFn$_invoke$arity$2 = G__10474__2;
  return G__10474;
}();
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__10451 = self__.vec;
      var G__10452 = self__.node;
      var G__10453 = self__.i;
      var G__10454 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10451, G__10452, G__10453, G__10454) : cljs.core.chunked_seq.call(null, G__10451, G__10452, G__10453, G__10454);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__10455 = self__.vec;
    var G__10456 = self__.i + self__.off;
    var G__10457 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__10455, G__10456, G__10457) : cljs.core.subvec.call(null, G__10455, G__10456, G__10457);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__10458 = self__.vec;
    var G__10459 = self__.i + self__.off;
    var G__10460 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__10458, G__10459, G__10460) : cljs.core.subvec.call(null, G__10458, G__10459, G__10460);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__10461 = self__.vec;
      var G__10462 = self__.node;
      var G__10463 = self__.i;
      var G__10464 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10461, G__10462, G__10463, G__10464) : cljs.core.chunked_seq.call(null, G__10461, G__10462, G__10463, G__10464);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__10465 = self__.vec;
    var G__10466 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__10467 = end;
    var G__10468 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10465, G__10466, G__10467, G__10468) : cljs.core.chunked_seq.call(null, G__10465, G__10466, G__10467, G__10468);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec, self__.node, self__.i, self__.off, m) : cljs.core.chunked_seq.call(null, self__.vec, self__.node, self__.i, self__.off, m);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__10469 = self__.vec;
    var G__10470 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__10471 = end;
    var G__10472 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10469, G__10470, G__10471, G__10472) : cljs.core.chunked_seq.call(null, G__10469, G__10470, G__10471, G__10472);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq(var_args) {
  var args10475 = [];
  var len__7492__auto___10478 = arguments.length;
  var i__7493__auto___10479 = 0;
  while (true) {
    if (i__7493__auto___10479 < len__7492__auto___10478) {
      args10475.push(arguments[i__7493__auto___10479]);
      var G__10480 = i__7493__auto___10479 + 1;
      i__7493__auto___10479 = G__10480;
      continue;
    } else {
    }
    break;
  }
  var G__10477 = args10475.length;
  switch(G__10477) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10475.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.indexOf = function() {
  var G__10502 = null;
  var G__10502__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10502__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__10502 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__10502__1.call(this, x);
      case 2:
        return G__10502__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10502.cljs$core$IFn$_invoke$arity$1 = G__10502__1;
  G__10502.cljs$core$IFn$_invoke$arity$2 = G__10502__2;
  return G__10502;
}();
cljs.core.Subvec.prototype.lastIndexOf = function() {
  var G__10503 = null;
  var G__10503__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10503__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__10503 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__10503__1.call(this, x);
      case 2:
        return G__10503__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10503.cljs$core$IFn$_invoke$arity$1 = G__10503__1;
  G__10503.cljs$core$IFn$_invoke$arity$2 = G__10503__2;
  return G__10503;
}();
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__10483 = init__$1;
        var G__10484 = j;
        var G__10485 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10483, G__10484, G__10485) : f.call(null, G__10483, G__10484, G__10485);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10504 = i + 1;
        var G__10505 = j + 1;
        var G__10506 = init__$2;
        i = G__10504;
        j = G__10505;
        init__$1 = G__10506;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__10486 = self__.meta;
  var G__10487 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__10488 = self__.start;
  var G__10489 = function() {
    var x__6748__auto__ = self__.end;
    var y__6749__auto__ = v_pos + 1;
    return x__6748__auto__ > y__6749__auto__ ? x__6748__auto__ : y__6749__auto__;
  }();
  var G__10490 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10486, G__10487, G__10488, G__10489, G__10490) : cljs.core.build_subvec.call(null, G__10486, G__10487, G__10488, G__10489, G__10490);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__10491 = self__.meta;
    var G__10492 = self__.v;
    var G__10493 = self__.start;
    var G__10494 = self__.end - 1;
    var G__10495 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10491, G__10492, G__10493, G__10494, G__10495) : cljs.core.build_subvec.call(null, G__10491, G__10492, G__10493, G__10494, G__10495);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1, self__.v, self__.start, self__.end, self__.__hash) : cljs.core.build_subvec.call(null, meta__$1, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__10497 = self__.meta;
  var G__10498 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__10499 = self__.start;
  var G__10500 = self__.end + 1;
  var G__10501 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10497, G__10498, G__10499, G__10500, G__10501) : cljs.core.build_subvec.call(null, G__10497, G__10498, G__10499, G__10500, G__10501);
};
cljs.core.Subvec.prototype.call = function() {
  var G__10507 = null;
  var G__10507__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__10507__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__10507 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10507__2.call(this, self__, k);
      case 3:
        return G__10507__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10507.cljs$core$IFn$_invoke$arity$2 = G__10507__2;
  G__10507.cljs$core$IFn$_invoke$arity$3 = G__10507__3;
  return G__10507;
}();
cljs.core.Subvec.prototype.apply = function(self__, args10482) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10482)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__10508 = meta;
      var G__10509 = v.v;
      var G__10510 = v.start + start;
      var G__10511 = v.start + end;
      var G__10512 = __hash;
      meta = G__10508;
      v = G__10509;
      start = G__10510;
      end = G__10511;
      __hash = G__10512;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec(var_args) {
  var args10513 = [];
  var len__7492__auto___10516 = arguments.length;
  var i__7493__auto___10517 = 0;
  while (true) {
    if (i__7493__auto___10517 < len__7492__auto___10516) {
      args10513.push(arguments[i__7493__auto___10517]);
      var G__10518 = i__7493__auto___10517 + 1;
      i__7493__auto___10517 = G__10518;
      continue;
    } else {
    }
    break;
  }
  var G__10515 = args10513.length;
  switch(G__10515) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10513.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__10531 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__10532 = level - 5;
        node = G__10531;
        level = G__10532;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__10536 = null;
  var G__10536__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10536__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10536 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10536__2.call(this, self__, k);
      case 3:
        return G__10536__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10536.cljs$core$IFn$_invoke$arity$2 = G__10536__2;
  G__10536.cljs$core$IFn$_invoke$arity$3 = G__10536__3;
  return G__10536;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args10533) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10533)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueIter = function(fseq, riter) {
  this.fseq = fseq;
  this.riter = riter;
};
cljs.core.PersistentQueueIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__6417__auto__ = cljs.core.some_QMARK_(self__.fseq) && cljs.core.seq(self__.fseq);
  if (or__6417__auto__) {
    return or__6417__auto__;
  } else {
    var and__6405__auto__ = cljs.core.some_QMARK_(self__.riter);
    if (and__6405__auto__) {
      return self__.riter.hasNext();
    } else {
      return and__6405__auto__;
    }
  }
};
cljs.core.PersistentQueueIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (cljs.core.some_QMARK_(self__.fseq)) {
    var ret = cljs.core.first(self__.fseq);
    self__.fseq = cljs.core.next(self__.fseq);
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.riter) && self__.riter.hasNext()) {
      return self__.riter.next();
    } else {
      throw new Error("No such element");
    }
  }
};
cljs.core.PersistentQueueIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.PersistentQueueIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "fseq", "fseq", -1466412450, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "riter", "riter", -237834262, null)], null);
};
cljs.core.PersistentQueueIter.cljs$lang$type = true;
cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";
cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentQueueIter");
};
cljs.core.__GT_PersistentQueueIter = function cljs$core$__GT_PersistentQueueIter(fseq, riter) {
  return new cljs.core.PersistentQueueIter(fseq, riter);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.indexOf = function() {
  var G__10537 = null;
  var G__10537__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10537__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10537 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10537__1.call(this, x);
      case 2:
        return G__10537__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10537.cljs$core$IFn$_invoke$arity$1 = G__10537__1;
  G__10537.cljs$core$IFn$_invoke$arity$2 = G__10537__2;
  return G__10537;
}();
cljs.core.PersistentQueueSeq.prototype.lastIndexOf = function() {
  var G__10538 = null;
  var G__10538__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10538__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10538 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10538__1.call(this, x);
      case 2:
        return G__10538__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10538.cljs$core$IFn$_invoke$arity$1 = G__10538__1;
  G__10538.cljs$core$IFn$_invoke$arity$2 = G__10538__2;
  return G__10538;
}();
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4655__auto__ = cljs.core.next(self__.front);
  if (temp__4655__auto__) {
    var f1 = temp__4655__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.indexOf = function() {
  var G__10539 = null;
  var G__10539__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10539__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10539 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10539__1.call(this, x);
      case 2:
        return G__10539__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10539.cljs$core$IFn$_invoke$arity$1 = G__10539__1;
  G__10539.cljs$core$IFn$_invoke$arity$2 = G__10539__2;
  return G__10539;
}();
cljs.core.PersistentQueue.prototype.lastIndexOf = function() {
  var G__10540 = null;
  var G__10540__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null, coll));
  };
  var G__10540__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10540 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10540__1.call(this, x);
      case 2:
        return G__10540__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10540.cljs$core$IFn$_invoke$arity$1 = G__10540__1;
  G__10540.cljs$core$IFn$_invoke$arity$2 = G__10540__2;
  return G__10540;
}();
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueIter(self__.front, cljs.core._iterator(self__.rear));
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4655__auto__ = cljs.core.next(self__.front);
    if (temp__4655__auto__) {
      var f1 = temp__4655__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__6417__auto__ = self__.front;
    if (cljs.core.truth_(or__6417__auto__)) {
      return or__6417__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__6417__auto__ = self__.rear;
      if (cljs.core.truth_(or__6417__auto__)) {
        return or__6417__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__10541 = i + incr;
        i = G__10541;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__10542 = i + 1;
      var G__10543 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__10542;
      out = G__10543;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = {};
  var l = ks.length;
  var i_10548 = 0;
  while (true) {
    if (i_10548 < l) {
      var k_10549 = ks[i_10548];
      new_obj[k_10549] = obj[k_10549];
      var G__10550 = i_10548 + 1;
      i_10548 = G__10550;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__10553 = init__$1;
        var G__10554 = k;
        var G__10555 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10553, G__10554, G__10555) : f.call(null, G__10553, G__10554, G__10555);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10556 = cljs.core.rest(keys__$1);
        var G__10557 = init__$2;
        keys__$1 = G__10556;
        init__$1 = G__10557;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k)) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__10551_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10551_SHARP_, self__.strobj[p1__10551_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__10558 = null;
  var G__10558__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10558__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10558 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10558__2.call(this, self__, k);
      case 3:
        return G__10558__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10558.cljs$core$IFn$_invoke$arity$2 = G__10558__2;
  G__10558.cljs$core$IFn$_invoke$arity$3 = G__10558__3;
  return G__10558;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args10552) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10552)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.RecordIter = function(i, record, base_count, fields, ext_map_iter) {
  this.i = i;
  this.record = record;
  this.base_count = base_count;
  this.fields = fields;
  this.ext_map_iter = ext_map_iter;
};
cljs.core.RecordIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__6417__auto__ = self__.i < self__.base_count;
  if (or__6417__auto__) {
    return or__6417__auto__;
  } else {
    return self__.ext_map_iter.hasNext();
  }
};
cljs.core.RecordIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (self__.i < self__.base_count) {
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields, self__.i);
    self__.i = self__.i + 1;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record, k)], null);
  } else {
    return self__.ext_map_iter.next();
  }
};
cljs.core.RecordIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.RecordIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "record", "record", 861424668, null), new cljs.core.Symbol(null, "base-count", "base-count", -1180647182, null), new cljs.core.Symbol(null, "fields", "fields", -291534703, null), new cljs.core.Symbol(null, 
  "ext-map-iter", "ext-map-iter", -1215982757, null)], null);
};
cljs.core.RecordIter.cljs$lang$type = true;
cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";
cljs.core.RecordIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/RecordIter");
};
cljs.core.__GT_RecordIter = function cljs$core$__GT_RecordIter(i, record, base_count, fields, ext_map_iter) {
  return new cljs.core.RecordIter(i, record, base_count, fields, ext_map_iter);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__10561 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10561, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10561, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__10564 = i + 2;
        i = G__10564;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Keyword && kstr === arr[i].fqn) {
        return i;
      } else {
        var G__10565 = i + 2;
        i = G__10565;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Symbol && kstr === arr[i].str) {
        return i;
      } else {
        var G__10566 = i + 2;
        i = G__10566;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__10567 = i + 2;
        i = G__10567;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__10568 = i + 2;
        i = G__10568;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (goog.isString(k) || typeof k === "number") {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_10569 = 0;
  while (true) {
    if (i_10569 < l) {
      narr[i_10569] = arr[i_10569];
      var G__10570 = i_10569 + 1;
      i_10569 = G__10570;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.indexOf = function() {
  var G__10571 = null;
  var G__10571__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10571__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10571 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10571__1.call(this, x);
      case 2:
        return G__10571__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10571.cljs$core$IFn$_invoke$arity$1 = G__10571__1;
  G__10571.cljs$core$IFn$_invoke$arity$2 = G__10571__2;
  return G__10571;
}();
cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = function() {
  var G__10572 = null;
  var G__10572__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10572__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10572 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10572__1.call(this, x);
      case 2:
        return G__10572__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10572.cljs$core$IFn$_invoke$arity$1 = G__10572__1;
  G__10572.cljs$core$IFn$_invoke$arity$2 = G__10572__2;
  return G__10572;
}();
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10574 = cljs.core.seq(coll);
  var chunk__10575 = null;
  var count__10576 = 0;
  var i__10577 = 0;
  while (true) {
    if (i__10577 < count__10576) {
      var vec__10578 = chunk__10575.cljs$core$IIndexed$_nth$arity$2(null, i__10577);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10578, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10578, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__10591 = seq__10574;
      var G__10592 = chunk__10575;
      var G__10593 = count__10576;
      var G__10594 = i__10577 + 1;
      seq__10574 = G__10591;
      chunk__10575 = G__10592;
      count__10576 = G__10593;
      i__10577 = G__10594;
      continue;
    } else {
      var temp__4657__auto__ = cljs.core.seq(seq__10574);
      if (temp__4657__auto__) {
        var seq__10574__$1 = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10574__$1)) {
          var c__7228__auto__ = cljs.core.chunk_first(seq__10574__$1);
          var G__10595 = cljs.core.chunk_rest(seq__10574__$1);
          var G__10596 = c__7228__auto__;
          var G__10597 = cljs.core.count(c__7228__auto__);
          var G__10598 = 0;
          seq__10574 = G__10595;
          chunk__10575 = G__10596;
          count__10576 = G__10597;
          i__10577 = G__10598;
          continue;
        } else {
          var vec__10581 = cljs.core.first(seq__10574__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10581, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10581, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__10599 = cljs.core.next(seq__10574__$1);
          var G__10600 = null;
          var G__10601 = 0;
          var G__10602 = 0;
          seq__10574 = G__10599;
          chunk__10575 = G__10600;
          count__10576 = G__10601;
          i__10577 = G__10602;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__10584 = init__$1;
        var G__10585 = self__.arr[i];
        var G__10586 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10584, G__10585, G__10586) : f.call(null, G__10584, G__10585, G__10586);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10603 = i + 2;
        var G__10604 = init__$2;
        i = G__10603;
        init__$1 = G__10604;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (!(other == null) ? other.cljs$lang$protocol_mask$partition0$ & 1024 || other.cljs$core$IMap$ ? true : false : false) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__10605 = i + 2;
              i = G__10605;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap({}, self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__10606 = s + 2;
            var G__10607 = d;
            s = G__10606;
            d = G__10607;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__10608 = s + 2;
            var G__10609 = d + 2;
            s = G__10608;
            d = G__10609;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__10590 = cljs.core.aclone(self__.arr);
        G__10590[idx + 1] = v;
        return G__10590;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10610 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10611 = cljs.core.next(es);
          ret = G__10610;
          es = G__10611;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__10612 = null;
  var G__10612__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10612__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10612 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10612__2.call(this, self__, k);
      case 3:
        return G__10612__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10612.cljs$core$IFn$_invoke$arity$2 = G__10612__2;
  G__10612.cljs$core$IFn$_invoke$arity$3 = G__10612__3;
  return G__10612;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args10573) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10573)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_10613 = 0;
    while (true) {
      if (i_10613 < arr__$1.length) {
        var k_10614 = arr__$1[i_10613];
        var v_10615 = arr__$1[i_10613 + 1];
        var idx_10616 = cljs.core.array_index_of(ret, k_10614);
        if (idx_10616 === -1) {
          ret.push(k_10614);
          ret.push(v_10615);
        } else {
        }
        var G__10617 = i_10613 + 2;
        i_10613 = G__10617;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var cnt = arr__$2.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return cljs.core._assoc_BANG_(tcoll__$1, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4655__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4655__auto__)) {
          var e = temp__4655__auto__;
          var G__10620 = cljs.core.next(es);
          var G__10621 = cljs.core._assoc_BANG_(tcoll__$2, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__10620;
          tcoll__$2 = G__10621;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len, self__.arr) : cljs.core.array__GT_transient_hash_map.call(null, self__.len, self__.arr), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__10619_10622 = self__.arr;
      G__10619_10622.pop();
      G__10619_10622.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__10623 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__10624 = i + 2;
      out = G__10623;
      i = G__10624;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set(var_args) {
  var args10625 = [];
  var len__7492__auto___10630 = arguments.length;
  var i__7493__auto___10631 = 0;
  while (true) {
    if (i__7493__auto___10631 < len__7492__auto___10630) {
      args10625.push(arguments[i__7493__auto___10631]);
      var G__10632 = i__7493__auto___10631 + 1;
      i__7493__auto___10631 = G__10632;
      continue;
    } else {
    }
    break;
  }
  var G__10627 = args10625.length;
  switch(G__10627) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10625.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__10628 = cljs.core.aclone(arr);
  G__10628[i] = a;
  return G__10628;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__10629 = cljs.core.aclone(arr);
  G__10629[i] = a;
  G__10629[j] = b;
  return G__10629;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set(var_args) {
  var args10634 = [];
  var len__7492__auto___10637 = arguments.length;
  var i__7493__auto___10638 = 0;
  while (true) {
    if (i__7493__auto___10638 < len__7492__auto___10637) {
      args10634.push(arguments[i__7493__auto___10638]);
      var G__10639 = i__7493__auto___10638 + 1;
      i__7493__auto___10638 = G__10639;
      continue;
    } else {
    }
    break;
  }
  var G__10636 = args10634.length;
  switch(G__10636) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10634.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__10644 = init__$1;
          var G__10645 = k;
          var G__10646 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10644, G__10645, G__10646) : f.call(null, G__10644, G__10645, G__10646);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__10647 = i + 2;
        var G__10648 = init__$2;
        i = G__10647;
        init__$1 = G__10648;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.NodeIterator = function(arr, i, next_entry, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_entry = next_entry;
  this.next_iter = next_iter;
};
cljs.core.NodeIterator.prototype.advance = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (self__.i < len) {
      var key = self__.arr[self__.i];
      var node_or_val = self__.arr[self__.i + 1];
      var found = cljs.core.some_QMARK_(key) ? self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key, node_or_val], null) : cljs.core.some_QMARK_(node_or_val) ? function() {
        var new_iter = cljs.core._iterator(node_or_val);
        if (new_iter.hasNext()) {
          return self__.next_iter = new_iter;
        } else {
          return false;
        }
      }() : false;
      self__.i = self__.i + 2;
      if (found) {
        return true;
      } else {
        continue;
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core.NodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var or__6417__auto__ = cljs.core.some_QMARK_(self__.next_entry);
  if (or__6417__auto__) {
    return or__6417__auto__;
  } else {
    var or__6417__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
    if (or__6417__auto____$1) {
      return or__6417__auto____$1;
    } else {
      return this$.advance();
    }
  }
};
cljs.core.NodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.some_QMARK_(self__.next_entry)) {
    var ret = self__.next_entry;
    self__.next_entry = null;
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.next_iter)) {
      var ret = self__.next_iter.next();
      if (self__.next_iter.hasNext()) {
      } else {
        self__.next_iter = null;
      }
      return ret;
    } else {
      if (this$.advance()) {
        return this$.next();
      } else {
        throw new Error("No such element");
      }
    }
  }
};
cljs.core.NodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.NodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-entry", "next-entry", 1091342476, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.NodeIterator.cljs$lang$type = true;
cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";
cljs.core.NodeIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/NodeIterator");
};
cljs.core.__GT_NodeIterator = function cljs$core$__GT_NodeIterator(arr, i, next_entry, next_iter) {
  return new cljs.core.NodeIterator(arr, i, next_entry, next_iter);
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_10662 = 0;
        var j_10663 = 0;
        while (true) {
          if (i_10662 < 32) {
            if ((self__.bitmap >>> i_10662 & 1) === 0) {
              var G__10664 = i_10662 + 1;
              var G__10665 = j_10663;
              i_10662 = G__10664;
              j_10663 = G__10665;
              continue;
            } else {
              nodes[i_10662] = !(self__.arr[j_10663] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_10663]), self__.arr[j_10663], self__.arr[j_10663 + 1], added_leaf_QMARK_) : self__.arr[j_10663 + 1];
              var G__10666 = i_10662 + 1;
              var G__10667 = j_10663 + 2;
              i_10662 = G__10666;
              j_10663 = G__10667;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__10649 = edit__$1;
          var G__10650 = shift + 5;
          var G__10651 = key_or_nil;
          var G__10652 = val_or_node;
          var G__10653 = hash;
          var G__10654 = key;
          var G__10655 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__10649, G__10650, G__10651, G__10652, G__10653, G__10654, G__10655) : cljs.core.create_node.call(null, G__10649, G__10650, G__10651, G__10652, G__10653, G__10654, G__10655);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_10668 = 0;
      var j_10669 = 0;
      while (true) {
        if (i_10668 < 32) {
          if ((self__.bitmap >>> i_10668 & 1) === 0) {
            var G__10670 = i_10668 + 1;
            var G__10671 = j_10669;
            i_10668 = G__10670;
            j_10669 = G__10671;
            continue;
          } else {
            nodes[i_10668] = !(self__.arr[j_10669] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_10669]), self__.arr[j_10669], self__.arr[j_10669 + 1], added_leaf_QMARK_) : self__.arr[j_10669 + 1];
            var G__10672 = i_10668 + 1;
            var G__10673 = j_10669 + 2;
            i_10668 = G__10672;
            j_10669 = G__10673;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__10656 = shift + 5;
          var G__10657 = key_or_nil;
          var G__10658 = val_or_node;
          var G__10659 = hash;
          var G__10660 = key;
          var G__10661 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__10656, G__10657, G__10658, G__10659, G__10660, G__10661) : cljs.core.create_node.call(null, G__10656, G__10657, G__10658, G__10659, G__10660, G__10661);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = true;
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__10674 = i + 1;
        var G__10675 = j + 2;
        var G__10676 = bitmap | 1 << i;
        i = G__10674;
        j = G__10675;
        bitmap = G__10676;
        continue;
      } else {
        var G__10677 = i + 1;
        var G__10678 = j;
        var G__10679 = bitmap;
        i = G__10677;
        j = G__10678;
        bitmap = G__10679;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNodeIterator = function(arr, i, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_iter = next_iter;
};
cljs.core.ArrayNodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (!(cljs.core.some_QMARK_(self__.next_iter) && self__.next_iter.hasNext())) {
      if (self__.i < len) {
        var node = self__.arr[self__.i];
        self__.i = self__.i + 1;
        if (cljs.core.some_QMARK_(node)) {
          self__.next_iter = cljs.core._iterator(node);
        } else {
        }
        continue;
      } else {
        return false;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.ArrayNodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (this$.hasNext()) {
    return self__.next_iter.next();
  } else {
    throw new Error("No such element");
  }
};
cljs.core.ArrayNodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayNodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNodeIterator.cljs$lang$type = true;
cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";
cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ArrayNodeIterator");
};
cljs.core.__GT_ArrayNodeIterator = function cljs$core$__GT_ArrayNodeIterator(arr, i, next_iter) {
  return new cljs.core.ArrayNodeIterator(arr, i, next_iter);
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null, self__.arr);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
        } else {
          var G__10680 = i + 1;
          var G__10681 = init__$2;
          i = G__10680;
          init__$1 = G__10681;
          continue;
        }
      } else {
        var G__10682 = i + 1;
        var G__10683 = init__$1;
        i = G__10682;
        init__$1 = G__10683;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = true;
cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeIterator(self__.arr, 0, null);
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__10684 = i + 2;
        i = G__10684;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = true;
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node(var_args) {
  var args10685 = [];
  var len__7492__auto___10688 = arguments.length;
  var i__7493__auto___10689 = 0;
  while (true) {
    if (i__7493__auto___10689 < len__7492__auto___10688) {
      args10685.push(arguments[i__7493__auto___10689]);
      var G__10690 = i__7493__auto___10689 + 1;
      i__7493__auto___10689 = G__10690;
      continue;
    } else {
    }
    break;
  }
  var G__10687 = args10685.length;
  switch(G__10687) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10685.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.indexOf = function() {
  var G__10698 = null;
  var G__10698__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10698__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10698 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10698__1.call(this, x);
      case 2:
        return G__10698__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10698.cljs$core$IFn$_invoke$arity$1 = G__10698__1;
  G__10698.cljs$core$IFn$_invoke$arity$2 = G__10698__2;
  return G__10698;
}();
cljs.core.NodeSeq.prototype.lastIndexOf = function() {
  var G__10699 = null;
  var G__10699__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10699__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10699 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10699__1.call(this, x);
      case 2:
        return G__10699__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10699.cljs$core$IFn$_invoke$arity$1 = G__10699__1;
  G__10699.cljs$core$IFn$_invoke$arity$2 = G__10699__2;
  return G__10699;
}();
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = self__.s == null ? function() {
    var G__10692 = self__.nodes;
    var G__10693 = self__.i + 2;
    var G__10694 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10692, G__10693, G__10694) : cljs.core.create_inode_seq.call(null, G__10692, G__10693, G__10694);
  }() : function() {
    var G__10695 = self__.nodes;
    var G__10696 = self__.i;
    var G__10697 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10695, G__10696, G__10697) : cljs.core.create_inode_seq.call(null, G__10695, G__10696, G__10697);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq(var_args) {
  var args10700 = [];
  var len__7492__auto___10703 = arguments.length;
  var i__7493__auto___10704 = 0;
  while (true) {
    if (i__7493__auto___10704 < len__7492__auto___10703) {
      args10700.push(arguments[i__7493__auto___10704]);
      var G__10705 = i__7493__auto___10704 + 1;
      i__7493__auto___10704 = G__10705;
      continue;
    } else {
    }
    break;
  }
  var G__10702 = args10700.length;
  switch(G__10702) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10700.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4655__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4655__auto__)) {
            var node = temp__4655__auto__;
            var temp__4655__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4655__auto____$1)) {
              var node_seq = temp__4655__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__10707 = j + 2;
              j = G__10707;
              continue;
            }
          } else {
            var G__10708 = j + 2;
            j = G__10708;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.indexOf = function() {
  var G__10713 = null;
  var G__10713__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10713__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10713 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10713__1.call(this, x);
      case 2:
        return G__10713__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10713.cljs$core$IFn$_invoke$arity$1 = G__10713__1;
  G__10713.cljs$core$IFn$_invoke$arity$2 = G__10713__2;
  return G__10713;
}();
cljs.core.ArrayNodeSeq.prototype.lastIndexOf = function() {
  var G__10714 = null;
  var G__10714__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10714__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10714 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10714__1.call(this, x);
      case 2:
        return G__10714__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10714.cljs$core$IFn$_invoke$arity$1 = G__10714__1;
  G__10714.cljs$core$IFn$_invoke$arity$2 = G__10714__2;
  return G__10714;
}();
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = function() {
    var G__10709 = null;
    var G__10710 = self__.nodes;
    var G__10711 = self__.i;
    var G__10712 = cljs.core.next(self__.s);
    return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__10709, G__10710, G__10711, G__10712) : cljs.core.create_array_node_seq.call(null, G__10709, G__10710, G__10711, G__10712);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq(var_args) {
  var args10715 = [];
  var len__7492__auto___10718 = arguments.length;
  var i__7493__auto___10719 = 0;
  while (true) {
    if (i__7493__auto___10719 < len__7492__auto___10718) {
      args10715.push(arguments[i__7493__auto___10719]);
      var G__10720 = i__7493__auto___10719 + 1;
      i__7493__auto___10719 = G__10720;
      continue;
    } else {
    }
    break;
  }
  var G__10717 = args10715.length;
  switch(G__10717) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10715.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4655__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4655__auto__)) {
          var nj = temp__4655__auto__;
          var temp__4655__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4655__auto____$1)) {
            var ns = temp__4655__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__10722 = j + 1;
            j = G__10722;
            continue;
          }
        } else {
          var G__10723 = j + 1;
          j = G__10723;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.HashMapIter = function(nil_val, root_iter, seen) {
  this.nil_val = nil_val;
  this.root_iter = root_iter;
  this.seen = seen;
};
cljs.core.HashMapIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.seen && self__.root_iter.hasNext();
};
cljs.core.HashMapIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!self__.seen) {
    self__.seen = true;
    return self__.nil_val;
  } else {
    return self__.root_iter.next();
  }
};
cljs.core.HashMapIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.HashMapIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "root-iter", "root-iter", 1974672108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "seen", "seen", 1121531738, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashMapIter.cljs$lang$type = true;
cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";
cljs.core.HashMapIter.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/HashMapIter");
};
cljs.core.__GT_HashMapIter = function cljs$core$__GT_HashMapIter(nil_val, root_iter, seen) {
  return new cljs.core.HashMapIter(nil_val, root_iter, seen);
};
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10725 = cljs.core.seq(coll);
  var chunk__10726 = null;
  var count__10727 = 0;
  var i__10728 = 0;
  while (true) {
    if (i__10728 < count__10727) {
      var vec__10729 = chunk__10726.cljs$core$IIndexed$_nth$arity$2(null, i__10728);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10729, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10729, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__10737 = seq__10725;
      var G__10738 = chunk__10726;
      var G__10739 = count__10727;
      var G__10740 = i__10728 + 1;
      seq__10725 = G__10737;
      chunk__10726 = G__10738;
      count__10727 = G__10739;
      i__10728 = G__10740;
      continue;
    } else {
      var temp__4657__auto__ = cljs.core.seq(seq__10725);
      if (temp__4657__auto__) {
        var seq__10725__$1 = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10725__$1)) {
          var c__7228__auto__ = cljs.core.chunk_first(seq__10725__$1);
          var G__10741 = cljs.core.chunk_rest(seq__10725__$1);
          var G__10742 = c__7228__auto__;
          var G__10743 = cljs.core.count(c__7228__auto__);
          var G__10744 = 0;
          seq__10725 = G__10741;
          chunk__10726 = G__10742;
          count__10727 = G__10743;
          i__10728 = G__10744;
          continue;
        } else {
          var vec__10732 = cljs.core.first(seq__10725__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10732, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10732, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__10745 = cljs.core.next(seq__10725__$1);
          var G__10746 = null;
          var G__10747 = 0;
          var G__10748 = 0;
          seq__10725 = G__10745;
          chunk__10726 = G__10746;
          count__10727 = G__10747;
          i__10728 = G__10748;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init, null, self__.nil_val) : f.call(null, init, null, self__.nil_val) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var root_iter = self__.root ? cljs.core._iterator(self__.root) : cljs.core.nil_iter;
  if (self__.has_nil_QMARK_) {
    return new cljs.core.HashMapIter(self__.nil_val, root_iter, false);
  } else {
    return root_iter;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap({}, self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10749 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10750 = cljs.core.next(es);
          ret = G__10749;
          es = G__10750;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__10751 = null;
  var G__10751__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10751__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10751 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10751__2.call(this, self__, k);
      case 3:
        return G__10751__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10751.cljs$core$IFn$_invoke$arity$2 = G__10751__2;
  G__10751.cljs$core$IFn$_invoke$arity$3 = G__10751__3;
  return G__10751;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args10724) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10724)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", 
  "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__10752 = i + 2;
      var G__10753 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__10752;
      ret = G__10753;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__10754 = i + 1;
      var G__10755 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__10754;
      out = G__10755;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return tcoll.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4655__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4655__auto__)) {
          var e = temp__4655__auto__;
          var G__10757 = cljs.core.next(es);
          var G__10758 = tcoll__$1.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__10757;
          tcoll__$1 = G__10758;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, 
  "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__10759 = ascending_QMARK_ ? t.left : t.right;
      var G__10760 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__10759;
      stack__$1 = G__10760;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.indexOf = function() {
  var G__10761 = null;
  var G__10761__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10761__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10761 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10761__1.call(this, x);
      case 2:
        return G__10761__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10761.cljs$core$IFn$_invoke$arity$1 = G__10761__1;
  G__10761.cljs$core$IFn$_invoke$arity$2 = G__10761__2;
  return G__10761;
}();
cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = function() {
  var G__10762 = null;
  var G__10762__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10762__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10762 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10762__1.call(this, x);
      case 2:
        return G__10762__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10762.cljs$core$IFn$_invoke$arity$1 = G__10762__1;
  G__10762.cljs$core$IFn$_invoke$arity$2 = G__10762__2;
  return G__10762;
}();
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), cljs.core.with_meta(new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, 
  "cnt", "cnt", 1924510325, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    var init__$2 = function() {
      var G__10772 = init__$1;
      var G__10773 = node.key;
      var G__10774 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10772, G__10773, G__10774) : f.call(null, G__10772, G__10773, G__10774);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null, init__$3);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.lastIndexOf = function() {
  var G__10776 = null;
  var G__10776__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10776__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10776 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10776__1.call(this, x);
      case 2:
        return G__10776__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10776.cljs$core$IFn$_invoke$arity$1 = G__10776__1;
  G__10776.cljs$core$IFn$_invoke$arity$2 = G__10776__2;
  return G__10776;
}();
cljs.core.BlackNode.prototype.indexOf = function() {
  var G__10777 = null;
  var G__10777__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10777__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10777 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10777__1.call(this, x);
      case 2:
        return G__10777__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10777.cljs$core$IFn$_invoke$arity$1 = G__10777__1;
  G__10777.cljs$core$IFn$_invoke$arity$2 = G__10777__2;
  return G__10777;
}();
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  var x__7251__auto__ = self__.key;
  return cljs.core._conj(function() {
    var x__7251__auto____$1 = self__.val;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7251__auto____$1);
  }(), x__7251__auto__);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__10778 = null;
  var G__10778__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10778__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10778 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10778__2.call(this, self__, k);
      case 3:
        return G__10778__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10778.cljs$core$IFn$_invoke$arity$2 = G__10778__2;
  G__10778.cljs$core$IFn$_invoke$arity$3 = G__10778__3;
  return G__10778;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args10775) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10775)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.RedNode.prototype.lastIndexOf = function() {
  var G__10780 = null;
  var G__10780__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10780__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10780 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10780__1.call(this, x);
      case 2:
        return G__10780__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10780.cljs$core$IFn$_invoke$arity$1 = G__10780__1;
  G__10780.cljs$core$IFn$_invoke$arity$2 = G__10780__2;
  return G__10780;
}();
cljs.core.RedNode.prototype.indexOf = function() {
  var G__10781 = null;
  var G__10781__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10781__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10781 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10781__1.call(this, x);
      case 2:
        return G__10781__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10781.cljs$core$IFn$_invoke$arity$1 = G__10781__1;
  G__10781.cljs$core$IFn$_invoke$arity$2 = G__10781__2;
  return G__10781;
}();
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  var x__7251__auto__ = self__.key;
  return cljs.core._conj(function() {
    var x__7251__auto____$1 = self__.val;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7251__auto____$1);
  }(), x__7251__auto__);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__10782 = null;
  var G__10782__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10782__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10782 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10782__2.call(this, self__, k);
      case 3:
        return G__10782__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10782.cljs$core$IFn$_invoke$arity$2 = G__10782__2;
  G__10782.cljs$core$IFn$_invoke$arity$3 = G__10782__3;
  return G__10782;
}();
cljs.core.RedNode.prototype.apply = function(self__, args10779) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10779)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__7023__auto__, writer__7024__auto__, opt__7025__auto__) {
  return cljs.core._write(writer__7024__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7423__auto__ = this;
  return cljs.core.es6_iterator(this__7423__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__10795 = k;
      var G__10796 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10795, G__10796) : comp.call(null, G__10795, G__10796);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = cljs$core$tree_map_add(comp, tree.left, k, v, found);
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = cljs$core$tree_map_add(comp, tree.right, k, v, found);
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, cljs$core$tree_map_append(left.right, right), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, cljs$core$tree_map_append(left, right.left), right.right, null);
        } else {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__10815 = k;
      var G__10816 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10815, G__10816) : comp.call(null, G__10815, G__10816);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = cljs$core$tree_map_remove(comp, tree.left, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = cljs$core$tree_map_remove(comp, tree.right, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k, tk) : comp.call(null, k, tk);
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, cljs$core$tree_map_replace(comp, tree.left, k, v), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, cljs$core$tree_map_replace(comp, tree.right, k, v));
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__10826 = cljs.core.seq(coll);
  var chunk__10827 = null;
  var count__10828 = 0;
  var i__10829 = 0;
  while (true) {
    if (i__10829 < count__10828) {
      var vec__10830 = chunk__10827.cljs$core$IIndexed$_nth$arity$2(null, i__10829);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10830, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10830, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__10840 = seq__10826;
      var G__10841 = chunk__10827;
      var G__10842 = count__10828;
      var G__10843 = i__10829 + 1;
      seq__10826 = G__10840;
      chunk__10827 = G__10841;
      count__10828 = G__10842;
      i__10829 = G__10843;
      continue;
    } else {
      var temp__4657__auto__ = cljs.core.seq(seq__10826);
      if (temp__4657__auto__) {
        var seq__10826__$1 = temp__4657__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10826__$1)) {
          var c__7228__auto__ = cljs.core.chunk_first(seq__10826__$1);
          var G__10844 = cljs.core.chunk_rest(seq__10826__$1);
          var G__10845 = c__7228__auto__;
          var G__10846 = cljs.core.count(c__7228__auto__);
          var G__10847 = 0;
          seq__10826 = G__10844;
          chunk__10827 = G__10845;
          count__10828 = G__10846;
          i__10829 = G__10847;
          continue;
        } else {
          var vec__10833 = cljs.core.first(seq__10826__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10833, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10833, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__10848 = cljs.core.next(seq__10826__$1);
          var G__10849 = null;
          var G__10850 = 0;
          var G__10851 = 0;
          seq__10826 = G__10848;
          chunk__10827 = G__10849;
          count__10828 = G__10850;
          i__10829 = G__10851;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentTreeMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentTreeMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var self__ = this;
  var coll = this;
  var t = self__.tree;
  while (true) {
    if (!(t == null)) {
      var c = function() {
        var G__10836 = k;
        var G__10837 = t.key;
        return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10836, G__10837) : self__.comp.call(null, G__10836, G__10837);
      }();
      if (c === 0) {
        return t;
      } else {
        if (c < 0) {
          var G__10852 = t.left;
          t = G__10852;
          continue;
        } else {
          var G__10853 = t.right;
          t = G__10853;
          continue;
        }
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = coll__$1.entry_at(k);
  if (!(n == null)) {
    return n.val;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.tree == null)) {
    return cljs.core.tree_map_kv_reduce(self__.tree, f, init);
  } else {
    return init;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, self__.meta, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, false, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6852__auto__ = self__.__hash;
  if (!(h__6852__auto__ == null)) {
    return h__6852__auto__;
  } else {
    var h__6852__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6852__auto____$1;
    return h__6852__auto____$1;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, 0);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_remove(self__.comp, self__.tree, k, found);
  if (t == null) {
    if (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0) == null) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt - 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_add(self__.comp, self__.tree, k, v, found);
  if (t == null) {
    var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0);
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v, found_node.val)) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, cljs.core.tree_map_replace(self__.comp, self__.tree, k, v), self__.cnt, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt + 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(coll__$1.entry_at(k) == null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, true, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, meta__$1, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__10854 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__10855 = cljs.core.next(es);
          ret = G__10854;
          es = G__10855;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__10856 = null;
  var G__10856__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__10856__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__10856 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10856__2.call(this, self__, k);
      case 3:
        return G__10856__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10856.cljs$core$IFn$_invoke$arity$2 = G__10856__2;
  G__10856.cljs$core$IFn$_invoke$arity$3 = G__10856__3;
  return G__10856;
}();
cljs.core.PersistentTreeMap.prototype.apply = function(self__, args10825) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10825)));
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, ascending_QMARK_, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var stack = null;
    var t = self__.tree;
    while (true) {
      if (!(t == null)) {
        var c = function() {
          var G__10838 = k;
          var G__10839 = t.key;
          return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10838, G__10839) : self__.comp.call(null, G__10838, G__10839);
        }();
        if (c === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t), ascending_QMARK_, -1, null);
        } else {
          if (cljs.core.truth_(ascending_QMARK_)) {
            if (c < 0) {
              var G__10857 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__10858 = t.left;
              stack = G__10857;
              t = G__10858;
              continue;
            } else {
              var G__10859 = stack;
              var G__10860 = t.right;
              stack = G__10859;
              t = G__10860;
              continue;
            }
          } else {
            if (c > 0) {
              var G__10861 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__10862 = t.right;
              stack = G__10861;
              t = G__10862;
              continue;
            