if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareTestMethods = function() {
  if (!goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareTestMethods must be called from " + "within a goog.module");
  }
  goog.moduleLoaderState_.declareTestMethods = true;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_isModule) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.pathIsModule[path] = !!opt_isModule;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.included_ = {};
  goog.dependencies_ = {pathIsModule:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !goog.global.atob && goog.global.document && goog.global.document.all;
  goog.importModule_ = function(src) {
    var bootstrap = 'goog.retrieveAndExecModule_("' + src + '");';
    if (goog.importScript_("", bootstrap)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && goog.dependencies_.pathIsModule[path]) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareTestMethods:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
      if (goog.moduleLoaderState_.declareTestMethods) {
        for (var entry in exports) {
          if (entry.indexOf("test", 0) === 0 || entry == "tearDown" || entry == "setUp" || entry == "setUpPage" || entry == "tearDownPage") {
            goog.global[entry] = exports[entry];
          }
        }
      }
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function(source) {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = doc.createElement("script");
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      var isOldIE = goog.IS_OLD_IE_;
      if (opt_sourceText === undefined) {
        if (!isOldIE) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        if (!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path);
        }
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    for (var path in goog.included_) {
      if (!deps.written[path]) {
        visitNode(path);
      }
    }
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    var loadingModule = false;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        if (!deps.pathIsModule[path]) {
          goog.importScript_(goog.basePath + path);
        } else {
          loadingModule = true;
          goog.importModule_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    var xhr = new goog.global["XMLHttpRequest"];
    xhr.open("get", src, false);
    xhr.send();
    return xhr.responseText;
  }
};
goog.retrieveAndExecModule_ = function(src) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText != null) {
      var execModuleScript = goog.wrapModule_(src, scriptText);
      var isOldIE = goog.IS_OLD_IE_;
      if (isOldIE) {
        goog.dependencies_.deferred[originalPath] = execModuleScript;
        goog.queuedModules_.push(originalPath);
      } else {
        importScript(src, execModuleScript);
      }
    } else {
      throw new Error("load of " + src + "failed");
    }
  }
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ \x3d 1;");
        if (typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("SCRIPT");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) {
    if (superClass && superClass.prototype && superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if (s.quote) {
    return s.quote();
  } else {
    var sb = ['"'];
    for (var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
    }
    sb.push('"');
    return sb.join("");
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = a[i] != b[j];
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += a1;
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  for (var i = 0;true;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if (i >= arr.length) {
        return result;
      }
      value.push(arr[i]);
    }
    result.push(value);
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3308";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_target_STAR_ = "default";
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  return cljs.core._STAR_print_fn_STAR_ = function() {
    var G__8703__delegate = function(args) {
      return console.log.apply(console, function() {
        var G__8702 = args;
        return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__8702) : cljs.core.into_array.call(null, G__8702);
      }());
    };
    var G__8703 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__8704__i = 0, G__8704__a = new Array(arguments.length - 0);
        while (G__8704__i < G__8704__a.length) {
          G__8704__a[G__8704__i] = arguments[G__8704__i + 0];
          ++G__8704__i;
        }
        args = new cljs.core.IndexedSeq(G__8704__a, 0);
      }
      return G__8703__delegate.call(this, args);
    };
    G__8703.cljs$lang$maxFixedArity = 0;
    G__8703.cljs$lang$applyTo = function(arglist__8705) {
      var args = cljs.core.seq(arglist__8705);
      return G__8703__delegate(args);
    };
    G__8703.cljs$core$IFn$_invoke$arity$variadic = G__8703__delegate;
    return G__8703;
  }();
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(n) {
  return typeof n === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (cljs.core.truth_(x)) {
    return false;
  } else {
    return true;
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  var G__8707 = x;
  return goog.isString(G__8707);
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[function() {
    var G__8709 = x__$1;
    return goog.typeOf(G__8709);
  }()]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__4297__auto__ = ty;
    if (cljs.core.truth_(and__4297__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__4297__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : function() {
    var G__8711 = obj;
    return goog.typeOf(G__8711);
  }();
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4423__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4423__auto__)) {
    var s = temp__4423__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && function() {
  var G__8713 = Symbol;
  return goog.typeOf(G__8713);
}() === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = function cljs$core$make_array() {
  var G__8715 = arguments.length;
  switch(G__8715) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__5194__auto___8717 = len;
  var i_8718 = 0;
  while (true) {
    if (i_8718 < n__5194__auto___8717) {
      new_arr[i_8718] = arr[i_8718];
      var G__8719 = i_8718 + 1;
      i_8718 = G__8719;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__8720 = i + 1;
      i = G__8720;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget() {
  var G__8725 = arguments.length;
  switch(G__8725) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__8726 = cljs.core.aget;
  var G__8727 = array[i];
  var G__8728 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__8726, G__8727, G__8728) : cljs.core.apply.call(null, G__8726, G__8727, G__8728);
};
cljs.core.aget.cljs$lang$applyTo = function(seq8721) {
  var G__8722 = cljs.core.first(seq8721);
  var seq8721__$1 = cljs.core.next(seq8721);
  var G__8723 = cljs.core.first(seq8721__$1);
  var seq8721__$2 = cljs.core.next(seq8721__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__8722, G__8723, seq8721__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset() {
  var G__8735 = arguments.length;
  switch(G__8735) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__8736 = cljs.core.aset;
  var G__8737 = array[idx];
  var G__8738 = idx2;
  var G__8739 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__8736, G__8737, G__8738, G__8739) : cljs.core.apply.call(null, G__8736, G__8737, G__8738, G__8739);
};
cljs.core.aset.cljs$lang$applyTo = function(seq8730) {
  var G__8731 = cljs.core.first(seq8730);
  var seq8730__$1 = cljs.core.next(seq8730);
  var G__8732 = cljs.core.first(seq8730__$1);
  var seq8730__$2 = cljs.core.next(seq8730__$1);
  var G__8733 = cljs.core.first(seq8730__$2);
  var seq8730__$3 = cljs.core.next(seq8730__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__8731, G__8732, G__8733, seq8730__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array() {
  var G__8742 = arguments.length;
  switch(G__8742) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__8743 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__8744 = [];
  var G__8745 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__8743, G__8744, G__8745) : cljs.core.reduce.call(null, G__8743, G__8744, G__8745);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke() {
  var argseq__5349__auto__ = 2 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5349__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq8747) {
  var G__8748 = cljs.core.first(seq8747);
  var seq8747__$1 = cljs.core.next(seq8747);
  var G__8749 = cljs.core.first(seq8747__$1);
  var seq8747__$2 = cljs.core.next(seq8747__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__8748, G__8749, seq8747__$2);
};
cljs.core.Fn = function() {
  var obj8751 = {};
  return obj8751;
}();
cljs.core.IFn = function() {
  var obj8753 = {};
  return obj8753;
}();
cljs.core._invoke = function cljs$core$_invoke() {
  var G__8755 = arguments.length;
  switch(G__8755) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8757 = x__4945__auto__;
        return goog.typeOf(G__8757);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8759 = x__4945__auto__;
        return goog.typeOf(G__8759);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8761 = x__4945__auto__;
        return goog.typeOf(G__8761);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8763 = x__4945__auto__;
        return goog.typeOf(G__8763);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8765 = x__4945__auto__;
        return goog.typeOf(G__8765);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$6;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8767 = x__4945__auto__;
        return goog.typeOf(G__8767);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$7;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8769 = x__4945__auto__;
        return goog.typeOf(G__8769);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$8;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8771 = x__4945__auto__;
        return goog.typeOf(G__8771);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$9;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8773 = x__4945__auto__;
        return goog.typeOf(G__8773);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$10;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8775 = x__4945__auto__;
        return goog.typeOf(G__8775);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$11;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8777 = x__4945__auto__;
        return goog.typeOf(G__8777);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$12;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8779 = x__4945__auto__;
        return goog.typeOf(G__8779);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$13;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8781 = x__4945__auto__;
        return goog.typeOf(G__8781);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$14;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8783 = x__4945__auto__;
        return goog.typeOf(G__8783);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$15;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8785 = x__4945__auto__;
        return goog.typeOf(G__8785);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$16;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8787 = x__4945__auto__;
        return goog.typeOf(G__8787);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$17;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8789 = x__4945__auto__;
        return goog.typeOf(G__8789);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$18;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8791 = x__4945__auto__;
        return goog.typeOf(G__8791);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$19;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8793 = x__4945__auto__;
        return goog.typeOf(G__8793);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$20;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8795 = x__4945__auto__;
        return goog.typeOf(G__8795);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$21;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8797 = x__4945__auto__;
        return goog.typeOf(G__8797);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$22;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._invoke[function() {
        var G__8799 = x__4945__auto__;
        return goog.typeOf(G__8799);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._invoke["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
  var obj8802 = {};
  return obj8802;
}();
cljs.core._clone = function cljs$core$_clone(value) {
  if (function() {
    var and__4297__auto__ = value;
    if (and__4297__auto__) {
      return value.cljs$core$ICloneable$_clone$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__4945__auto__ = value == null ? null : value;
    return function() {
      var or__4309__auto__ = cljs.core._clone[function() {
        var G__8806 = x__4945__auto__;
        return goog.typeOf(G__8806);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._clone["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICloneable.-clone", value);
        }
      }
    }().call(null, value);
  }
};
cljs.core.ICounted = function() {
  var obj8808 = {};
  return obj8808;
}();
cljs.core._count = function cljs$core$_count(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICounted$_count$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._count[function() {
        var G__8812 = x__4945__auto__;
        return goog.typeOf(G__8812);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._count["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICounted.-count", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IEmptyableCollection = function() {
  var obj8814 = {};
  return obj8814;
}();
cljs.core._empty = function cljs$core$_empty(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._empty[function() {
        var G__8818 = x__4945__auto__;
        return goog.typeOf(G__8818);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._empty["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ICollection = function() {
  var obj8820 = {};
  return obj8820;
}();
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ICollection$_conj$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._conj[function() {
        var G__8824 = x__4945__auto__;
        return goog.typeOf(G__8824);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o);
  }
};
cljs.core.IIndexed = function() {
  var obj8826 = {};
  return obj8826;
}();
cljs.core._nth = function cljs$core$_nth() {
  var G__8828 = arguments.length;
  switch(G__8828) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__8830 = x__4945__auto__;
        return goog.typeOf(G__8830);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n);
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._nth[function() {
        var G__8832 = x__4945__auto__;
        return goog.typeOf(G__8832);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._nth["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n, not_found);
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
  var obj8835 = {};
  return obj8835;
}();
cljs.core.ISeq = function() {
  var obj8837 = {};
  return obj8837;
}();
cljs.core._first = function cljs$core$_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._first[function() {
        var G__8841 = x__4945__auto__;
        return goog.typeOf(G__8841);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISeq$_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rest[function() {
        var G__8845 = x__4945__auto__;
        return goog.typeOf(G__8845);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INext = function() {
  var obj8847 = {};
  return obj8847;
}();
cljs.core._next = function cljs$core$_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$INext$_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._next[function() {
        var G__8851 = x__4945__auto__;
        return goog.typeOf(G__8851);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INext.-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ILookup = function() {
  var obj8853 = {};
  return obj8853;
}();
cljs.core._lookup = function cljs$core$_lookup() {
  var G__8855 = arguments.length;
  switch(G__8855) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__8857 = x__4945__auto__;
        return goog.typeOf(G__8857);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k);
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._lookup[function() {
        var G__8859 = x__4945__auto__;
        return goog.typeOf(G__8859);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._lookup["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k, not_found);
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
  var obj8862 = {};
  return obj8862;
}();
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._contains_key_QMARK_[function() {
        var G__8866 = x__4945__auto__;
        return goog.typeOf(G__8866);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._contains_key_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IAssociative$_assoc$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc[function() {
        var G__8870 = x__4945__auto__;
        return goog.typeOf(G__8870);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v);
  }
};
cljs.core.IMap = function() {
  var obj8872 = {};
  return obj8872;
}();
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMap$_dissoc$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc[function() {
        var G__8876 = x__4945__auto__;
        return goog.typeOf(G__8876);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core.IMapEntry = function() {
  var obj8878 = {};
  return obj8878;
}();
cljs.core._key = function cljs$core$_key(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_key$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._key[function() {
        var G__8882 = x__4945__auto__;
        return goog.typeOf(G__8882);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-key", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IMapEntry$_val$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._val[function() {
        var G__8886 = x__4945__auto__;
        return goog.typeOf(G__8886);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._val["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-val", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISet = function() {
  var obj8888 = {};
  return obj8888;
}();
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISet$_disjoin$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin[function() {
        var G__8892 = x__4945__auto__;
        return goog.typeOf(G__8892);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v);
  }
};
cljs.core.IStack = function() {
  var obj8894 = {};
  return obj8894;
}();
cljs.core._peek = function cljs$core$_peek(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_peek$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._peek[function() {
        var G__8898 = x__4945__auto__;
        return goog.typeOf(G__8898);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._peek["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-peek", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IStack$_pop$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._pop[function() {
        var G__8902 = x__4945__auto__;
        return goog.typeOf(G__8902);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-pop", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IVector = function() {
  var obj8904 = {};
  return obj8904;
}();
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IVector$_assoc_n$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n[function() {
        var G__8908 = x__4945__auto__;
        return goog.typeOf(G__8908);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val);
  }
};
cljs.core.IDeref = function() {
  var obj8910 = {};
  return obj8910;
}();
cljs.core._deref = function cljs$core$_deref(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDeref$_deref$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref[function() {
        var G__8914 = x__4945__auto__;
        return goog.typeOf(G__8914);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDeref.-deref", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IDerefWithTimeout = function() {
  var obj8916 = {};
  return obj8916;
}();
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._deref_with_timeout[function() {
        var G__8920 = x__4945__auto__;
        return goog.typeOf(G__8920);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._deref_with_timeout["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val);
  }
};
cljs.core.IMeta = function() {
  var obj8922 = {};
  return obj8922;
}();
cljs.core._meta = function cljs$core$_meta(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IMeta$_meta$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._meta[function() {
        var G__8926 = x__4945__auto__;
        return goog.typeOf(G__8926);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMeta.-meta", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IWithMeta = function() {
  var obj8928 = {};
  return obj8928;
}();
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._with_meta[function() {
        var G__8932 = x__4945__auto__;
        return goog.typeOf(G__8932);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._with_meta["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta);
  }
};
cljs.core.IReduce = function() {
  var obj8934 = {};
  return obj8934;
}();
cljs.core._reduce = function cljs$core$_reduce() {
  var G__8936 = arguments.length;
  switch(G__8936) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__8938 = x__4945__auto__;
        return goog.typeOf(G__8938);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f);
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._reduce[function() {
        var G__8940 = x__4945__auto__;
        return goog.typeOf(G__8940);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f, start);
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
  var obj8943 = {};
  return obj8943;
}();
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._kv_reduce[function() {
        var G__8947 = x__4945__auto__;
        return goog.typeOf(G__8947);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._kv_reduce["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init);
  }
};
cljs.core.IEquiv = function() {
  var obj8949 = {};
  return obj8949;
}();
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IEquiv$_equiv$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._equiv[function() {
        var G__8953 = x__4945__auto__;
        return goog.typeOf(G__8953);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._equiv["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other);
  }
};
cljs.core.IHash = function() {
  var obj8955 = {};
  return obj8955;
}();
cljs.core._hash = function cljs$core$_hash(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IHash$_hash$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._hash[function() {
        var G__8959 = x__4945__auto__;
        return goog.typeOf(G__8959);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._hash["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IHash.-hash", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISeqable = function() {
  var obj8961 = {};
  return obj8961;
}();
cljs.core._seq = function cljs$core$_seq(o) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISeqable$_seq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._seq[function() {
        var G__8965 = x__4945__auto__;
        return goog.typeOf(G__8965);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeqable.-seq", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISequential = function() {
  var obj8967 = {};
  return obj8967;
}();
cljs.core.IList = function() {
  var obj8969 = {};
  return obj8969;
}();
cljs.core.IRecord = function() {
  var obj8971 = {};
  return obj8971;
}();
cljs.core.IReversible = function() {
  var obj8973 = {};
  return obj8973;
}();
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IReversible$_rseq$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._rseq[function() {
        var G__8977 = x__4945__auto__;
        return goog.typeOf(G__8977);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._rseq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReversible.-rseq", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISorted = function() {
  var obj8979 = {};
  return obj8979;
}();
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq[function() {
        var G__8983 = x__4945__auto__;
        return goog.typeOf(G__8983);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_);
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._sorted_seq_from[function() {
        var G__8987 = x__4945__auto__;
        return goog.typeOf(G__8987);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._sorted_seq_from["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_);
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_entry_key$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._entry_key[function() {
        var G__8991 = x__4945__auto__;
        return goog.typeOf(G__8991);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._entry_key["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry);
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$ISorted$_comparator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._comparator[function() {
        var G__8995 = x__4945__auto__;
        return goog.typeOf(G__8995);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._comparator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-comparator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IWriter = function() {
  var obj8997 = {};
  return obj8997;
}();
cljs.core._write = function cljs$core$_write(writer, s) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_write$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._write[function() {
        var G__9001 = x__4945__auto__;
        return goog.typeOf(G__9001);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._write["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-write", writer);
        }
      }
    }().call(null, writer, s);
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (function() {
    var and__4297__auto__ = writer;
    if (and__4297__auto__) {
      return writer.cljs$core$IWriter$_flush$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__4945__auto__ = writer == null ? null : writer;
    return function() {
      var or__4309__auto__ = cljs.core._flush[function() {
        var G__9005 = x__4945__auto__;
        return goog.typeOf(G__9005);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._flush["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-flush", writer);
        }
      }
    }().call(null, writer);
  }
};
cljs.core.IPrintWithWriter = function() {
  var obj9007 = {};
  return obj9007;
}();
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._pr_writer[function() {
        var G__9011 = x__4945__auto__;
        return goog.typeOf(G__9011);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pr_writer["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
        }
      }
    }().call(null, o, writer, opts);
  }
};
cljs.core.IPending = function() {
  var obj9013 = {};
  return obj9013;
}();
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(d) {
  if (function() {
    var and__4297__auto__ = d;
    if (and__4297__auto__) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
  } else {
    var x__4945__auto__ = d == null ? null : d;
    return function() {
      var or__4309__auto__ = cljs.core._realized_QMARK_[function() {
        var G__9017 = x__4945__auto__;
        return goog.typeOf(G__9017);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._realized_QMARK_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPending.-realized?", d);
        }
      }
    }().call(null, d);
  }
};
cljs.core.IWatchable = function() {
  var obj9019 = {};
  return obj9019;
}();
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._notify_watches[function() {
        var G__9023 = x__4945__auto__;
        return goog.typeOf(G__9023);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._notify_watches["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval);
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._add_watch[function() {
        var G__9027 = x__4945__auto__;
        return goog.typeOf(G__9027);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._add_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f);
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (function() {
    var and__4297__auto__ = this$;
    if (and__4297__auto__) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__4945__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4309__auto__ = cljs.core._remove_watch[function() {
        var G__9031 = x__4945__auto__;
        return goog.typeOf(G__9031);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._remove_watch["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key);
  }
};
cljs.core.IEditableCollection = function() {
  var obj9033 = {};
  return obj9033;
}();
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._as_transient[function() {
        var G__9037 = x__4945__auto__;
        return goog.typeOf(G__9037);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._as_transient["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ITransientCollection = function() {
  var obj9039 = {};
  return obj9039;
}();
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._conj_BANG_[function() {
        var G__9043 = x__4945__auto__;
        return goog.typeOf(G__9043);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._conj_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val);
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._persistent_BANG_[function() {
        var G__9047 = x__4945__auto__;
        return goog.typeOf(G__9047);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._persistent_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientAssociative = function() {
  var obj9049 = {};
  return obj9049;
}();
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_BANG_[function() {
        var G__9053 = x__4945__auto__;
        return goog.typeOf(G__9053);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val);
  }
};
cljs.core.ITransientMap = function() {
  var obj9055 = {};
  return obj9055;
}();
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._dissoc_BANG_[function() {
        var G__9059 = x__4945__auto__;
        return goog.typeOf(G__9059);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._dissoc_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key);
  }
};
cljs.core.ITransientVector = function() {
  var obj9061 = {};
  return obj9061;
}();
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._assoc_n_BANG_[function() {
        var G__9065 = x__4945__auto__;
        return goog.typeOf(G__9065);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._assoc_n_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val);
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._pop_BANG_[function() {
        var G__9069 = x__4945__auto__;
        return goog.typeOf(G__9069);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._pop_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientSet = function() {
  var obj9071 = {};
  return obj9071;
}();
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (function() {
    var and__4297__auto__ = tcoll;
    if (and__4297__auto__) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__4945__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4309__auto__ = cljs.core._disjoin_BANG_[function() {
        var G__9075 = x__4945__auto__;
        return goog.typeOf(G__9075);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._disjoin_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v);
  }
};
cljs.core.IComparable = function() {
  var obj9077 = {};
  return obj9077;
}();
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$IComparable$_compare$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._compare[function() {
        var G__9081 = x__4945__auto__;
        return goog.typeOf(G__9081);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._compare["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IComparable.-compare", x);
        }
      }
    }().call(null, x, y);
  }
};
cljs.core.IChunk = function() {
  var obj9083 = {};
  return obj9083;
}();
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunk$_drop_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._drop_first[function() {
        var G__9087 = x__4945__auto__;
        return goog.typeOf(G__9087);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._drop_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedSeq = function() {
  var obj9089 = {};
  return obj9089;
}();
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_first[function() {
        var G__9093 = x__4945__auto__;
        return goog.typeOf(G__9093);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_first["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_rest[function() {
        var G__9097 = x__4945__auto__;
        return goog.typeOf(G__9097);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_rest["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedNext = function() {
  var obj9099 = {};
  return obj9099;
}();
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._chunked_next[function() {
        var G__9103 = x__4945__auto__;
        return goog.typeOf(G__9103);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._chunked_next["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INamed = function() {
  var obj9105 = {};
  return obj9105;
}();
cljs.core._name = function cljs$core$_name(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_name$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._name[function() {
        var G__9109 = x__4945__auto__;
        return goog.typeOf(G__9109);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._name["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-name", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (function() {
    var and__4297__auto__ = x;
    if (and__4297__auto__) {
      return x.cljs$core$INamed$_namespace$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__4945__auto__ = x == null ? null : x;
    return function() {
      var or__4309__auto__ = cljs.core._namespace[function() {
        var G__9113 = x__4945__auto__;
        return goog.typeOf(G__9113);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._namespace["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-namespace", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core.IAtom = function() {
  var obj9115 = {};
  return obj9115;
}();
cljs.core.IReset = function() {
  var obj9117 = {};
  return obj9117;
}();
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IReset$_reset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._reset_BANG_[function() {
        var G__9121 = x__4945__auto__;
        return goog.typeOf(G__9121);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._reset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReset.-reset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.ISwap = function() {
  var obj9123 = {};
  return obj9123;
}();
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_() {
  var G__9125 = arguments.length;
  switch(G__9125) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__9127 = x__4945__auto__;
        return goog.typeOf(G__9127);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$3;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__9129 = x__4945__auto__;
        return goog.typeOf(G__9129);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$4;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__9131 = x__4945__auto__;
        return goog.typeOf(G__9131);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$5;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._swap_BANG_[function() {
        var G__9133 = x__4945__auto__;
        return goog.typeOf(G__9133);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b, xs);
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
  var obj9136 = {};
  return obj9136;
}();
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (function() {
    var and__4297__auto__ = o;
    if (and__4297__auto__) {
      return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__4945__auto__ = o == null ? null : o;
    return function() {
      var or__4309__auto__ = cljs.core._vreset_BANG_[function() {
        var G__9140 = x__4945__auto__;
        return goog.typeOf(G__9140);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._vreset_BANG_["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.IIterable = function() {
  var obj9142 = {};
  return obj9142;
}();
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (function() {
    var and__4297__auto__ = coll;
    if (and__4297__auto__) {
      return coll.cljs$core$IIterable$_iterator$arity$1;
    } else {
      return and__4297__auto__;
    }
  }()) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__4945__auto__ = coll == null ? null : coll;
    return function() {
      var or__4309__auto__ = cljs.core._iterator[function() {
        var G__9146 = x__4945__auto__;
        return goog.typeOf(G__9146);
      }()];
      if (or__4309__auto__) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = cljs.core._iterator["_"];
        if (or__4309__auto____$1) {
          return or__4309__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIterable.-iterator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(function() {
  var G__9149 = 4294967295;
  var G__9150 = 5;
  return Math.imul(G__9149, G__9150);
}() === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var G__9153 = a;
    var G__9154 = b;
    return Math.imul(G__9153, G__9154);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  var h1__$7 = h1__$6 ^ h1__$6 >>> 16;
  return h1__$7;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__9155 = i + 2;
        var G__9156 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__9155;
        h1 = G__9156;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = function() {
  var obj9158 = {};
  return obj9158;
}();
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__9159 = i + 1;
          var G__9160 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__9159;
          hash = G__9160;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = function() {
      var obj9164 = {};
      return obj9164;
    }();
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  var h = cljs.core.string_hash_cache[k];
  if (typeof h === "number") {
    return h;
  } else {
    return cljs.core.add_to_string_hash_cache(k);
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (function() {
    var G__9167 = o;
    if (G__9167) {
      var bit__4976__auto__ = G__9167.cljs$lang$protocol_mask$partition0$ & 4194304;
      if (bit__4976__auto__ || G__9167.cljs$core$IHash$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      return function() {
        var G__9168 = o;
        return Math.floor(G__9168);
      }() % 2147483647;
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(t, o) {
  return o instanceof t;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__9175 = a.ns;
            var G__9176 = b.ns;
            return goog.array.defaultCompare(G__9175, G__9176);
          }();
          if (0 === nsc) {
            var G__9177 = a.name;
            var G__9178 = b.name;
            return goog.array.defaultCompare(G__9177, G__9178);
          } else {
            return nsc;
          }
        }
      } else {
        var G__9179 = a.name;
        var G__9180 = b.name;
        return goog.array.defaultCompare(G__9179, G__9180);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__9182 = null;
  var G__9182__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
  };
  var G__9182__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
  };
  G__9182 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9182__2.call(this, self__, coll);
      case 3:
        return G__9182__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9182.cljs$core$IFn$_invoke$arity$2 = G__9182__2;
  G__9182.cljs$core$IFn$_invoke$arity$3 = G__9182__3;
  return G__9182;
}();
cljs.core.Symbol.prototype.apply = function(self__, args9181) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9181)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol() {
  var G__9184 = arguments.length;
  switch(G__9184) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 163841;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.call = function() {
  var G__9231 = null;
  var G__9231__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null);
  };
  var G__9231__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a);
  };
  var G__9231__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b);
  };
  var G__9231__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c);
  };
  var G__9231__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d);
  };
  var G__9231__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e);
  };
  var G__9231__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f);
  };
  var G__9231__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g);
  };
  var G__9231__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h);
  };
  var G__9231__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__9231__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__9231__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__9231__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__9231__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__9231__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__9231__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__9231__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__9231__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__9231__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__9231__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__9231__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__9231__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9187 = function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }();
    var G__9188 = a;
    var G__9189 = b;
    var G__9190 = c;
    var G__9191 = d;
    var G__9192 = e;
    var G__9193 = f;
    var G__9194 = g;
    var G__9195 = h;
    var G__9196 = i;
    var G__9197 = j;
    var G__9198 = k;
    var G__9199 = l;
    var G__9200 = m;
    var G__9201 = n;
    var G__9202 = o;
    var G__9203 = p;
    var G__9204 = q;
    var G__9205 = r;
    var G__9206 = s;
    var G__9207 = t;
    var G__9208 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9187, G__9188, G__9189, G__9190, G__9191, G__9192, G__9193, G__9194, G__9195, G__9196, G__9197, G__9198, G__9199, G__9200, G__9201, G__9202, G__9203, G__9204, G__9205, G__9206, G__9207, G__9208) : cljs.core.apply.call(null, G__9187, G__9188, G__9189, G__9190, G__9191, G__9192, G__9193, G__9194, G__9195, G__9196, G__9197, G__9198, G__9199, G__9200, G__9201, G__9202, G__9203, G__9204, G__9205, 
    G__9206, G__9207, G__9208);
  };
  G__9231 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__9231__1.call(this, self__);
      case 2:
        return G__9231__2.call(this, self__, a);
      case 3:
        return G__9231__3.call(this, self__, a, b);
      case 4:
        return G__9231__4.call(this, self__, a, b, c);
      case 5:
        return G__9231__5.call(this, self__, a, b, c, d);
      case 6:
        return G__9231__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__9231__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__9231__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__9231__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__9231__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__9231__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__9231__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__9231__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__9231__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__9231__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__9231__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__9231__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__9231__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__9231__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__9231__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__9231__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__9231__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9231.cljs$core$IFn$_invoke$arity$1 = G__9231__1;
  G__9231.cljs$core$IFn$_invoke$arity$2 = G__9231__2;
  G__9231.cljs$core$IFn$_invoke$arity$3 = G__9231__3;
  G__9231.cljs$core$IFn$_invoke$arity$4 = G__9231__4;
  G__9231.cljs$core$IFn$_invoke$arity$5 = G__9231__5;
  G__9231.cljs$core$IFn$_invoke$arity$6 = G__9231__6;
  G__9231.cljs$core$IFn$_invoke$arity$7 = G__9231__7;
  G__9231.cljs$core$IFn$_invoke$arity$8 = G__9231__8;
  G__9231.cljs$core$IFn$_invoke$arity$9 = G__9231__9;
  G__9231.cljs$core$IFn$_invoke$arity$10 = G__9231__10;
  G__9231.cljs$core$IFn$_invoke$arity$11 = G__9231__11;
  G__9231.cljs$core$IFn$_invoke$arity$12 = G__9231__12;
  G__9231.cljs$core$IFn$_invoke$arity$13 = G__9231__13;
  G__9231.cljs$core$IFn$_invoke$arity$14 = G__9231__14;
  G__9231.cljs$core$IFn$_invoke$arity$15 = G__9231__15;
  G__9231.cljs$core$IFn$_invoke$arity$16 = G__9231__16;
  G__9231.cljs$core$IFn$_invoke$arity$17 = G__9231__17;
  G__9231.cljs$core$IFn$_invoke$arity$18 = G__9231__18;
  G__9231.cljs$core$IFn$_invoke$arity$19 = G__9231__19;
  G__9231.cljs$core$IFn$_invoke$arity$20 = G__9231__20;
  G__9231.cljs$core$IFn$_invoke$arity$21 = G__9231__21;
  G__9231.cljs$core$IFn$_invoke$arity$22 = G__9231__22;
  return G__9231;
}();
cljs.core.Var.prototype.apply = function(self__, args9186) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9186)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__9209 = function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }();
  var G__9210 = a;
  var G__9211 = b;
  var G__9212 = c;
  var G__9213 = d;
  var G__9214 = e;
  var G__9215 = f;
  var G__9216 = g;
  var G__9217 = h;
  var G__9218 = i;
  var G__9219 = j;
  var G__9220 = k;
  var G__9221 = l;
  var G__9222 = m;
  var G__9223 = n;
  var G__9224 = o;
  var G__9225 = p;
  var G__9226 = q;
  var G__9227 = r;
  var G__9228 = s;
  var G__9229 = t;
  var G__9230 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9209, G__9210, G__9211, G__9212, G__9213, G__9214, G__9215, G__9216, G__9217, G__9218, G__9219, G__9220, G__9221, G__9222, G__9223, G__9224, G__9225, G__9226, G__9227, G__9228, G__9229, G__9230) : cljs.core.apply.call(null, G__9209, G__9210, G__9211, G__9212, G__9213, G__9214, G__9215, G__9216, G__9217, G__9218, G__9219, G__9220, G__9221, G__9222, G__9223, G__9224, G__9225, G__9226, G__9227, 
  G__9228, G__9229, G__9230);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  var G__9233 = x;
  if (G__9233) {
    var bit__4983__auto__ = null;
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = bit__4983__auto__;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return G__9233.cljs$core$IIterable$;
      }
    }())) {
      return true;
    } else {
      if (!G__9233.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__9233);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__9233);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  var G__9235 = value;
  if (G__9235) {
    var bit__4983__auto__ = G__9235.cljs$lang$protocol_mask$partition1$ & 8192;
    if (bit__4983__auto__ || G__9235.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!G__9235.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__9235);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__9235);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__9237 = coll;
      if (G__9237) {
        var bit__4976__auto__ = G__9237.cljs$lang$protocol_mask$partition0$ & 8388608;
        if (bit__4976__auto__ || G__9237.cljs$core$ISeqable$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__9239 = coll;
      if (G__9239) {
        var bit__4976__auto__ = G__9239.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__9239.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__9241 = coll;
      if (G__9241) {
        var bit__4976__auto__ = G__9241.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__9241.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__9243 = coll;
      if (G__9243) {
        var bit__4976__auto__ = G__9243.cljs$lang$protocol_mask$partition0$ & 128;
        if (bit__4976__auto__ || G__9243.cljs$core$INext$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_() {
  var G__9248 = arguments.length;
  switch(G__9248) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__9250 = y;
        var G__9251 = cljs.core.first(more);
        var G__9252 = cljs.core.next(more);
        x = G__9250;
        y = G__9251;
        more = G__9252;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq9244) {
  var G__9245 = cljs.core.first(seq9244);
  var seq9244__$1 = cljs.core.next(seq9244);
  var G__9246 = cljs.core.first(seq9244__$1);
  var seq9244__$2 = cljs.core.next(seq9244__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9245, G__9246, seq9244__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = function() {
      var G__9253 = self__.iter;
      return cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__9253) : cljs.core.es6_iterator_seq.call(null, G__9253);
    }();
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null)], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__9254 = n + 1;
      var G__9255 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__9256 = cljs.core.next(coll__$1);
      n = G__9254;
      hash_code = G__9255;
      coll__$1 = G__9256;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__9257 = n + 1;
      var G__9258 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__9259 = cljs.core.next(coll__$1);
      n = G__9257;
      hash_code = G__9258;
      coll__$1 = G__9259;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__9260 = this$__$1.valueOf();
    var G__9261 = other.valueOf();
    return goog.array.defaultCompare(G__9260, G__9261);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  var G__9262 = o;
  return goog.getUid(G__9262);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    var G__9264 = x;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9264) : cljs.core.deref.call(null, G__9264);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce() {
  var G__9266 = arguments.length;
  switch(G__9266) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__9267 = val;
          var G__9268 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9267, G__9268) : f.call(null, G__9267, G__9268);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__9274 = nval;
          var G__9275 = n + 1;
          val = G__9274;
          n = G__9275;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9269 = val__$1;
        var G__9270 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9269, G__9270) : f.call(null, G__9269, G__9270);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9276 = nval;
        var G__9277 = n + 1;
        val__$1 = G__9276;
        n = G__9277;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9271 = val__$1;
        var G__9272 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9271, G__9272) : f.call(null, G__9271, G__9272);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9278 = nval;
        var G__9279 = n + 1;
        val__$1 = G__9278;
        n = G__9279;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce() {
  var G__9281 = arguments.length;
  switch(G__9281) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__9282 = val;
          var G__9283 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9282, G__9283) : f.call(null, G__9282, G__9283);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__9289 = nval;
          var G__9290 = n + 1;
          val = G__9289;
          n = G__9290;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9284 = val__$1;
        var G__9285 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9284, G__9285) : f.call(null, G__9284, G__9285);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9291 = nval;
        var G__9292 = n + 1;
        val__$1 = G__9291;
        n = G__9292;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9286 = val__$1;
        var G__9287 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9286, G__9287) : f.call(null, G__9286, G__9287);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9293 = nval;
        var G__9294 = n + 1;
        val__$1 = G__9293;
        n = G__9294;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  var G__9296 = x;
  if (G__9296) {
    var bit__4983__auto__ = G__9296.cljs$lang$protocol_mask$partition0$ & 2;
    if (bit__4983__auto__ || G__9296.cljs$core$ICounted$) {
      return true;
    } else {
      if (!G__9296.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__9296);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__9296);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  var G__9298 = x;
  if (G__9298) {
    var bit__4983__auto__ = G__9298.cljs$lang$protocol_mask$partition0$ & 16;
    if (bit__4983__auto__ || G__9298.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!G__9298.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__9298);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__9298);
  }
};
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i) {
  this.arr = arr;
  this.i = i;
  this.cljs$lang$protocol_mask$partition0$ = 166199550;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__4621__auto__ = 0;
  var y__4622__auto__ = self__.arr.length - self__.i;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__9299 = coll__$1;
  var G__9300 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__9299, G__9300) : cljs.core.equiv_sequential.call(null, G__9299, G__9300);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__9301 = o;
  var G__9302 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__9301, G__9302) : cljs.core.cons.call(null, G__9301, G__9302);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i) {
  return new cljs.core.IndexedSeq(arr, i);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq() {
  var G__9304 = arguments.length;
  switch(G__9304) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq() {
  var G__9307 = arguments.length;
  switch(G__9307) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__9309 = coll__$1;
  var G__9310 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__9309, G__9310) : cljs.core.equiv_sequential.call(null, G__9309, G__9310);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__9311 = cljs.core.List.EMPTY;
  var G__9312 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__9311, G__9312) : cljs.core.with_meta.call(null, G__9311, G__9312);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  var G__9313 = f;
  var G__9314 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__9313, G__9314) : cljs.core.seq_reduce.call(null, G__9313, G__9314);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  var G__9315 = f;
  var G__9316 = start;
  var G__9317 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__9315, G__9316, G__9317) : cljs.core.seq_reduce.call(null, G__9315, G__9316, G__9317);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__9318 = o;
  var G__9319 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__9318, G__9319) : cljs.core.cons.call(null, G__9318, G__9319);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__9320 = sn;
      s = G__9320;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj() {
  var G__9325 = arguments.length;
  switch(G__9325) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return cljs.core._conj(cljs.core.List.EMPTY, x);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__9327 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__9328 = cljs.core.first(xs);
      var G__9329 = cljs.core.next(xs);
      coll = G__9327;
      x = G__9328;
      xs = G__9329;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq9321) {
  var G__9322 = cljs.core.first(seq9321);
  var seq9321__$1 = cljs.core.next(seq9321);
  var G__9323 = cljs.core.first(seq9321__$1);
  var seq9321__$2 = cljs.core.next(seq9321__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__9322, G__9323, seq9321__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__9330 = cljs.core.next(s);
      var G__9331 = acc + 1;
      s = G__9330;
      acc = G__9331;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__9333 = coll;
      if (G__9333) {
        var bit__4976__auto__ = G__9333.cljs$lang$protocol_mask$partition0$ & 2;
        if (bit__4976__auto__ || G__9333.cljs$core$ICounted$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, coll)) {
            return cljs.core._count(coll);
          } else {
            return cljs.core.accumulating_seq_count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth() {
  var G__9335 = arguments.length;
  switch(G__9335) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__9337 = cljs.core.next(coll);
            var G__9338 = n - 1;
            coll = G__9337;
            n = G__9338;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__9339 = cljs.core.next(coll);
            var G__9340 = n - 1;
            var G__9341 = not_found;
            coll = G__9339;
            n = G__9340;
            not_found = G__9341;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth() {
  var G__9343 = arguments.length;
  switch(G__9343) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (function() {
        var G__9344 = coll;
        if (G__9344) {
          var bit__4976__auto__ = G__9344.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__9344.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return null;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__9345 = coll;
                if (G__9345) {
                  var bit__4983__auto__ = G__9345.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__9345.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__9345.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9345);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9345);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (function() {
        var G__9346 = coll;
        if (G__9346) {
          var bit__4976__auto__ = G__9346.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4976__auto__ || G__9346.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return not_found;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__9347 = coll;
                if (G__9347) {
                  var bit__4983__auto__ = G__9347.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4983__auto__ || G__9347.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__9347.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9347);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9347);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__9349 = n__$1 - 1;
      var G__9350 = cljs.core.rest(xs);
      n__$1 = G__9349;
      xs = G__9350;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get() {
  var G__9352 = arguments.length;
  switch(G__9352) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (function() {
      var G__9353 = o;
      if (G__9353) {
        var bit__4976__auto__ = G__9353.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__9353.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (function() {
      var G__9354 = o;
      if (G__9354) {
        var bit__4976__auto__ = G__9354.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4976__auto__ || G__9354.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc() {
  var G__9361 = arguments.length;
  switch(G__9361) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__9363 = ret;
      var G__9364 = cljs.core.first(kvs);
      var G__9365 = cljs.core.second(kvs);
      var G__9366 = cljs.core.nnext(kvs);
      coll = G__9363;
      k = G__9364;
      v = G__9365;
      kvs = G__9366;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq9356) {
  var G__9357 = cljs.core.first(seq9356);
  var seq9356__$1 = cljs.core.next(seq9356);
  var G__9358 = cljs.core.first(seq9356__$1);
  var seq9356__$2 = cljs.core.next(seq9356__$1);
  var G__9359 = cljs.core.first(seq9356__$2);
  var seq9356__$3 = cljs.core.next(seq9356__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__9357, G__9358, G__9359, seq9356__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc() {
  var G__9371 = arguments.length;
  switch(G__9371) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9373 = ret;
        var G__9374 = cljs.core.first(ks);
        var G__9375 = cljs.core.next(ks);
        coll = G__9373;
        k = G__9374;
        ks = G__9375;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq9367) {
  var G__9368 = cljs.core.first(seq9367);
  var seq9367__$1 = cljs.core.next(seq9367);
  var G__9369 = cljs.core.first(seq9367__$1);
  var seq9367__$2 = cljs.core.next(seq9367__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__9368, G__9369, seq9367__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__4309__auto__ = function() {
    var G__9380 = f;
    return goog.isFunction(G__9380);
  }();
  if (cljs.core.truth_(or__4309__auto__)) {
    return or__4309__auto__;
  } else {
    var G__9381 = f;
    if (G__9381) {
      var bit__4983__auto__ = null;
      if (cljs.core.truth_(function() {
        var or__4309__auto____$1 = bit__4983__auto__;
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          return G__9381.cljs$core$Fn$;
        }
      }())) {
        return true;
      } else {
        if (!G__9381.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__9381);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__9381);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.call = function() {
  var G__9847 = null;
  var G__9847__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__9847__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9383 = a;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__9383) : self__.afn.call(null, G__9383);
  };
  var G__9847__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9384 = a;
    var G__9385 = b;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__9384, G__9385) : self__.afn.call(null, G__9384, G__9385);
  };
  var G__9847__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9386 = a;
    var G__9387 = b;
    var G__9388 = c;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__9386, G__9387, G__9388) : self__.afn.call(null, G__9386, G__9387, G__9388);
  };
  var G__9847__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9389 = a;
    var G__9390 = b;
    var G__9391 = c;
    var G__9392 = d;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__9389, G__9390, G__9391, G__9392) : self__.afn.call(null, G__9389, G__9390, G__9391, G__9392);
  };
  var G__9847__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9393 = a;
    var G__9394 = b;
    var G__9395 = c;
    var G__9396 = d;
    var G__9397 = e;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__9393, G__9394, G__9395, G__9396, G__9397) : self__.afn.call(null, G__9393, G__9394, G__9395, G__9396, G__9397);
  };
  var G__9847__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9398 = a;
    var G__9399 = b;
    var G__9400 = c;
    var G__9401 = d;
    var G__9402 = e;
    var G__9403 = f;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__9398, G__9399, G__9400, G__9401, G__9402, G__9403) : self__.afn.call(null, G__9398, G__9399, G__9400, G__9401, G__9402, G__9403);
  };
  var G__9847__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9404 = a;
    var G__9405 = b;
    var G__9406 = c;
    var G__9407 = d;
    var G__9408 = e;
    var G__9409 = f;
    var G__9410 = g;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__9404, G__9405, G__9406, G__9407, G__9408, G__9409, G__9410) : self__.afn.call(null, G__9404, G__9405, G__9406, G__9407, G__9408, G__9409, G__9410);
  };
  var G__9847__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9411 = a;
    var G__9412 = b;
    var G__9413 = c;
    var G__9414 = d;
    var G__9415 = e;
    var G__9416 = f;
    var G__9417 = g;
    var G__9418 = h;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__9411, G__9412, G__9413, G__9414, G__9415, G__9416, G__9417, G__9418) : self__.afn.call(null, G__9411, G__9412, G__9413, G__9414, G__9415, G__9416, G__9417, G__9418);
  };
  var G__9847__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9419 = a;
    var G__9420 = b;
    var G__9421 = c;
    var G__9422 = d;
    var G__9423 = e;
    var G__9424 = f;
    var G__9425 = g;
    var G__9426 = h;
    var G__9427 = i;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__9419, G__9420, G__9421, G__9422, G__9423, G__9424, G__9425, G__9426, G__9427) : self__.afn.call(null, G__9419, G__9420, G__9421, G__9422, G__9423, G__9424, G__9425, G__9426, G__9427);
  };
  var G__9847__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9428 = a;
    var G__9429 = b;
    var G__9430 = c;
    var G__9431 = d;
    var G__9432 = e;
    var G__9433 = f;
    var G__9434 = g;
    var G__9435 = h;
    var G__9436 = i;
    var G__9437 = j;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__9428, G__9429, G__9430, G__9431, G__9432, G__9433, G__9434, G__9435, G__9436, G__9437) : self__.afn.call(null, G__9428, G__9429, G__9430, G__9431, G__9432, G__9433, G__9434, G__9435, G__9436, G__9437);
  };
  var G__9847__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9438 = a;
    var G__9439 = b;
    var G__9440 = c;
    var G__9441 = d;
    var G__9442 = e;
    var G__9443 = f;
    var G__9444 = g;
    var G__9445 = h;
    var G__9446 = i;
    var G__9447 = j;
    var G__9448 = k;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__9438, G__9439, G__9440, G__9441, G__9442, G__9443, G__9444, G__9445, G__9446, G__9447, G__9448) : self__.afn.call(null, G__9438, G__9439, G__9440, G__9441, G__9442, G__9443, G__9444, G__9445, G__9446, G__9447, G__9448);
  };
  var G__9847__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9449 = a;
    var G__9450 = b;
    var G__9451 = c;
    var G__9452 = d;
    var G__9453 = e;
    var G__9454 = f;
    var G__9455 = g;
    var G__9456 = h;
    var G__9457 = i;
    var G__9458 = j;
    var G__9459 = k;
    var G__9460 = l;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__9449, G__9450, G__9451, G__9452, G__9453, G__9454, G__9455, G__9456, G__9457, G__9458, G__9459, G__9460) : self__.afn.call(null, G__9449, G__9450, G__9451, G__9452, G__9453, G__9454, G__9455, G__9456, G__9457, G__9458, G__9459, G__9460);
  };
  var G__9847__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9461 = a;
    var G__9462 = b;
    var G__9463 = c;
    var G__9464 = d;
    var G__9465 = e;
    var G__9466 = f;
    var G__9467 = g;
    var G__9468 = h;
    var G__9469 = i;
    var G__9470 = j;
    var G__9471 = k;
    var G__9472 = l;
    var G__9473 = m;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__9461, G__9462, G__9463, G__9464, G__9465, G__9466, G__9467, G__9468, G__9469, G__9470, G__9471, G__9472, G__9473) : self__.afn.call(null, G__9461, G__9462, G__9463, G__9464, G__9465, G__9466, G__9467, G__9468, G__9469, G__9470, G__9471, G__9472, G__9473);
  };
  var G__9847__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9474 = a;
    var G__9475 = b;
    var G__9476 = c;
    var G__9477 = d;
    var G__9478 = e;
    var G__9479 = f;
    var G__9480 = g;
    var G__9481 = h;
    var G__9482 = i;
    var G__9483 = j;
    var G__9484 = k;
    var G__9485 = l;
    var G__9486 = m;
    var G__9487 = n;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__9474, G__9475, G__9476, G__9477, G__9478, G__9479, G__9480, G__9481, G__9482, G__9483, G__9484, G__9485, G__9486, G__9487) : self__.afn.call(null, G__9474, G__9475, G__9476, G__9477, G__9478, G__9479, G__9480, G__9481, G__9482, G__9483, G__9484, G__9485, G__9486, G__9487);
  };
  var G__9847__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9488 = a;
    var G__9489 = b;
    var G__9490 = c;
    var G__9491 = d;
    var G__9492 = e;
    var G__9493 = f;
    var G__9494 = g;
    var G__9495 = h;
    var G__9496 = i;
    var G__9497 = j;
    var G__9498 = k;
    var G__9499 = l;
    var G__9500 = m;
    var G__9501 = n;
    var G__9502 = o;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__9488, G__9489, G__9490, G__9491, G__9492, G__9493, G__9494, G__9495, G__9496, G__9497, G__9498, G__9499, G__9500, G__9501, G__9502) : self__.afn.call(null, G__9488, G__9489, G__9490, G__9491, G__9492, G__9493, G__9494, G__9495, G__9496, G__9497, G__9498, G__9499, G__9500, G__9501, G__9502);
  };
  var G__9847__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9503 = a;
    var G__9504 = b;
    var G__9505 = c;
    var G__9506 = d;
    var G__9507 = e;
    var G__9508 = f;
    var G__9509 = g;
    var G__9510 = h;
    var G__9511 = i;
    var G__9512 = j;
    var G__9513 = k;
    var G__9514 = l;
    var G__9515 = m;
    var G__9516 = n;
    var G__9517 = o;
    var G__9518 = p;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__9503, G__9504, G__9505, G__9506, G__9507, G__9508, G__9509, G__9510, G__9511, G__9512, G__9513, G__9514, G__9515, G__9516, G__9517, G__9518) : self__.afn.call(null, G__9503, G__9504, G__9505, G__9506, G__9507, G__9508, G__9509, G__9510, G__9511, G__9512, G__9513, G__9514, G__9515, G__9516, G__9517, G__9518);
  };
  var G__9847__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9519 = a;
    var G__9520 = b;
    var G__9521 = c;
    var G__9522 = d;
    var G__9523 = e;
    var G__9524 = f;
    var G__9525 = g;
    var G__9526 = h;
    var G__9527 = i;
    var G__9528 = j;
    var G__9529 = k;
    var G__9530 = l;
    var G__9531 = m;
    var G__9532 = n;
    var G__9533 = o;
    var G__9534 = p;
    var G__9535 = q;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__9519, G__9520, G__9521, G__9522, G__9523, G__9524, G__9525, G__9526, G__9527, G__9528, G__9529, G__9530, G__9531, G__9532, G__9533, G__9534, G__9535) : self__.afn.call(null, G__9519, G__9520, G__9521, G__9522, G__9523, G__9524, G__9525, G__9526, G__9527, G__9528, G__9529, G__9530, G__9531, G__9532, G__9533, G__9534, G__9535);
  };
  var G__9847__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9536 = a;
    var G__9537 = b;
    var G__9538 = c;
    var G__9539 = d;
    var G__9540 = e;
    var G__9541 = f;
    var G__9542 = g;
    var G__9543 = h;
    var G__9544 = i;
    var G__9545 = j;
    var G__9546 = k;
    var G__9547 = l;
    var G__9548 = m;
    var G__9549 = n;
    var G__9550 = o;
    var G__9551 = p;
    var G__9552 = q;
    var G__9553 = r;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__9536, G__9537, G__9538, G__9539, G__9540, G__9541, G__9542, G__9543, G__9544, G__9545, G__9546, G__9547, G__9548, G__9549, G__9550, G__9551, G__9552, G__9553) : self__.afn.call(null, G__9536, G__9537, G__9538, G__9539, G__9540, G__9541, G__9542, G__9543, G__9544, G__9545, G__9546, G__9547, G__9548, G__9549, G__9550, G__9551, G__9552, G__9553);
  };
  var G__9847__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9554 = a;
    var G__9555 = b;
    var G__9556 = c;
    var G__9557 = d;
    var G__9558 = e;
    var G__9559 = f;
    var G__9560 = g;
    var G__9561 = h;
    var G__9562 = i;
    var G__9563 = j;
    var G__9564 = k;
    var G__9565 = l;
    var G__9566 = m;
    var G__9567 = n;
    var G__9568 = o;
    var G__9569 = p;
    var G__9570 = q;
    var G__9571 = r;
    var G__9572 = s;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__9554, G__9555, G__9556, G__9557, G__9558, G__9559, G__9560, G__9561, G__9562, G__9563, G__9564, G__9565, G__9566, G__9567, G__9568, G__9569, G__9570, G__9571, G__9572) : self__.afn.call(null, G__9554, G__9555, G__9556, G__9557, G__9558, G__9559, G__9560, G__9561, G__9562, G__9563, G__9564, G__9565, G__9566, G__9567, G__9568, G__9569, G__9570, G__9571, G__9572);
  };
  var G__9847__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9573 = a;
    var G__9574 = b;
    var G__9575 = c;
    var G__9576 = d;
    var G__9577 = e;
    var G__9578 = f;
    var G__9579 = g;
    var G__9580 = h;
    var G__9581 = i;
    var G__9582 = j;
    var G__9583 = k;
    var G__9584 = l;
    var G__9585 = m;
    var G__9586 = n;
    var G__9587 = o;
    var G__9588 = p;
    var G__9589 = q;
    var G__9590 = r;
    var G__9591 = s;
    var G__9592 = t;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__9573, G__9574, G__9575, G__9576, G__9577, G__9578, G__9579, G__9580, G__9581, G__9582, G__9583, G__9584, G__9585, G__9586, G__9587, G__9588, G__9589, G__9590, G__9591, G__9592) : self__.afn.call(null, G__9573, G__9574, G__9575, G__9576, G__9577, G__9578, G__9579, G__9580, G__9581, G__9582, G__9583, G__9584, G__9585, G__9586, G__9587, G__9588, G__9589, G__9590, G__9591, G__9592);
  };
  var G__9847__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9593 = self__.afn;
    var G__9594 = a;
    var G__9595 = b;
    var G__9596 = c;
    var G__9597 = d;
    var G__9598 = e;
    var G__9599 = f;
    var G__9600 = g;
    var G__9601 = h;
    var G__9602 = i;
    var G__9603 = j;
    var G__9604 = k;
    var G__9605 = l;
    var G__9606 = m;
    var G__9607 = n;
    var G__9608 = o;
    var G__9609 = p;
    var G__9610 = q;
    var G__9611 = r;
    var G__9612 = s;
    var G__9613 = t;
    var G__9614 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9593, G__9594, G__9595, G__9596, G__9597, G__9598, G__9599, G__9600, G__9601, G__9602, G__9603, G__9604, G__9605, G__9606, G__9607, G__9608, G__9609, G__9610, G__9611, G__9612, G__9613, G__9614) : cljs.core.apply.call(null, G__9593, G__9594, G__9595, G__9596, G__9597, G__9598, G__9599, G__9600, G__9601, G__9602, G__9603, G__9604, G__9605, G__9606, G__9607, G__9608, G__9609, G__9610, G__9611, 
    G__9612, G__9613, G__9614);
  };
  G__9847 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__9847__1.call(this, self__);
      case 2:
        return G__9847__2.call(this, self__, a);
      case 3:
        return G__9847__3.call(this, self__, a, b);
      case 4:
        return G__9847__4.call(this, self__, a, b, c);
      case 5:
        return G__9847__5.call(this, self__, a, b, c, d);
      case 6:
        return G__9847__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__9847__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__9847__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__9847__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__9847__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__9847__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__9847__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__9847__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__9847__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__9847__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__9847__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__9847__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__9847__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__9847__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__9847__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__9847__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__9847__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9847.cljs$core$IFn$_invoke$arity$1 = G__9847__1;
  G__9847.cljs$core$IFn$_invoke$arity$2 = G__9847__2;
  G__9847.cljs$core$IFn$_invoke$arity$3 = G__9847__3;
  G__9847.cljs$core$IFn$_invoke$arity$4 = G__9847__4;
  G__9847.cljs$core$IFn$_invoke$arity$5 = G__9847__5;
  G__9847.cljs$core$IFn$_invoke$arity$6 = G__9847__6;
  G__9847.cljs$core$IFn$_invoke$arity$7 = G__9847__7;
  G__9847.cljs$core$IFn$_invoke$arity$8 = G__9847__8;
  G__9847.cljs$core$IFn$_invoke$arity$9 = G__9847__9;
  G__9847.cljs$core$IFn$_invoke$arity$10 = G__9847__10;
  G__9847.cljs$core$IFn$_invoke$arity$11 = G__9847__11;
  G__9847.cljs$core$IFn$_invoke$arity$12 = G__9847__12;
  G__9847.cljs$core$IFn$_invoke$arity$13 = G__9847__13;
  G__9847.cljs$core$IFn$_invoke$arity$14 = G__9847__14;
  G__9847.cljs$core$IFn$_invoke$arity$15 = G__9847__15;
  G__9847.cljs$core$IFn$_invoke$arity$16 = G__9847__16;
  G__9847.cljs$core$IFn$_invoke$arity$17 = G__9847__17;
  G__9847.cljs$core$IFn$_invoke$arity$18 = G__9847__18;
  G__9847.cljs$core$IFn$_invoke$arity$19 = G__9847__19;
  G__9847.cljs$core$IFn$_invoke$arity$20 = G__9847__20;
  G__9847.cljs$core$IFn$_invoke$arity$21 = G__9847__21;
  G__9847.cljs$core$IFn$_invoke$arity$22 = G__9847__22;
  return G__9847;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args9382) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9382)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  var G__9615 = a;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__9615) : self__.afn.call(null, G__9615);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  var G__9616 = a;
  var G__9617 = b;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__9616, G__9617) : self__.afn.call(null, G__9616, G__9617);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  var G__9618 = a;
  var G__9619 = b;
  var G__9620 = c;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__9618, G__9619, G__9620) : self__.afn.call(null, G__9618, G__9619, G__9620);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  var G__9621 = a;
  var G__9622 = b;
  var G__9623 = c;
  var G__9624 = d;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__9621, G__9622, G__9623, G__9624) : self__.afn.call(null, G__9621, G__9622, G__9623, G__9624);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  var G__9625 = a;
  var G__9626 = b;
  var G__9627 = c;
  var G__9628 = d;
  var G__9629 = e;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__9625, G__9626, G__9627, G__9628, G__9629) : self__.afn.call(null, G__9625, G__9626, G__9627, G__9628, G__9629);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  var G__9630 = a;
  var G__9631 = b;
  var G__9632 = c;
  var G__9633 = d;
  var G__9634 = e;
  var G__9635 = f;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__9630, G__9631, G__9632, G__9633, G__9634, G__9635) : self__.afn.call(null, G__9630, G__9631, G__9632, G__9633, G__9634, G__9635);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  var G__9636 = a;
  var G__9637 = b;
  var G__9638 = c;
  var G__9639 = d;
  var G__9640 = e;
  var G__9641 = f;
  var G__9642 = g;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__9636, G__9637, G__9638, G__9639, G__9640, G__9641, G__9642) : self__.afn.call(null, G__9636, G__9637, G__9638, G__9639, G__9640, G__9641, G__9642);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  var G__9643 = a;
  var G__9644 = b;
  var G__9645 = c;
  var G__9646 = d;
  var G__9647 = e;
  var G__9648 = f;
  var G__9649 = g;
  var G__9650 = h;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__9643, G__9644, G__9645, G__9646, G__9647, G__9648, G__9649, G__9650) : self__.afn.call(null, G__9643, G__9644, G__9645, G__9646, G__9647, G__9648, G__9649, G__9650);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  var G__9651 = a;
  var G__9652 = b;
  var G__9653 = c;
  var G__9654 = d;
  var G__9655 = e;
  var G__9656 = f;
  var G__9657 = g;
  var G__9658 = h;
  var G__9659 = i;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__9651, G__9652, G__9653, G__9654, G__9655, G__9656, G__9657, G__9658, G__9659) : self__.afn.call(null, G__9651, G__9652, G__9653, G__9654, G__9655, G__9656, G__9657, G__9658, G__9659);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  var G__9660 = a;
  var G__9661 = b;
  var G__9662 = c;
  var G__9663 = d;
  var G__9664 = e;
  var G__9665 = f;
  var G__9666 = g;
  var G__9667 = h;
  var G__9668 = i;
  var G__9669 = j;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__9660, G__9661, G__9662, G__9663, G__9664, G__9665, G__9666, G__9667, G__9668, G__9669) : self__.afn.call(null, G__9660, G__9661, G__9662, G__9663, G__9664, G__9665, G__9666, G__9667, G__9668, G__9669);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  var G__9670 = a;
  var G__9671 = b;
  var G__9672 = c;
  var G__9673 = d;
  var G__9674 = e;
  var G__9675 = f;
  var G__9676 = g;
  var G__9677 = h;
  var G__9678 = i;
  var G__9679 = j;
  var G__9680 = k;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__9670, G__9671, G__9672, G__9673, G__9674, G__9675, G__9676, G__9677, G__9678, G__9679, G__9680) : self__.afn.call(null, G__9670, G__9671, G__9672, G__9673, G__9674, G__9675, G__9676, G__9677, G__9678, G__9679, G__9680);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  var G__9681 = a;
  var G__9682 = b;
  var G__9683 = c;
  var G__9684 = d;
  var G__9685 = e;
  var G__9686 = f;
  var G__9687 = g;
  var G__9688 = h;
  var G__9689 = i;
  var G__9690 = j;
  var G__9691 = k;
  var G__9692 = l;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__9681, G__9682, G__9683, G__9684, G__9685, G__9686, G__9687, G__9688, G__9689, G__9690, G__9691, G__9692) : self__.afn.call(null, G__9681, G__9682, G__9683, G__9684, G__9685, G__9686, G__9687, G__9688, G__9689, G__9690, G__9691, G__9692);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  var G__9693 = a;
  var G__9694 = b;
  var G__9695 = c;
  var G__9696 = d;
  var G__9697 = e;
  var G__9698 = f;
  var G__9699 = g;
  var G__9700 = h;
  var G__9701 = i;
  var G__9702 = j;
  var G__9703 = k;
  var G__9704 = l;
  var G__9705 = m;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__9693, G__9694, G__9695, G__9696, G__9697, G__9698, G__9699, G__9700, G__9701, G__9702, G__9703, G__9704, G__9705) : self__.afn.call(null, G__9693, G__9694, G__9695, G__9696, G__9697, G__9698, G__9699, G__9700, G__9701, G__9702, G__9703, G__9704, G__9705);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  var G__9706 = a;
  var G__9707 = b;
  var G__9708 = c;
  var G__9709 = d;
  var G__9710 = e;
  var G__9711 = f;
  var G__9712 = g;
  var G__9713 = h;
  var G__9714 = i;
  var G__9715 = j;
  var G__9716 = k;
  var G__9717 = l;
  var G__9718 = m;
  var G__9719 = n;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__9706, G__9707, G__9708, G__9709, G__9710, G__9711, G__9712, G__9713, G__9714, G__9715, G__9716, G__9717, G__9718, G__9719) : self__.afn.call(null, G__9706, G__9707, G__9708, G__9709, G__9710, G__9711, G__9712, G__9713, G__9714, G__9715, G__9716, G__9717, G__9718, G__9719);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  var G__9720 = a;
  var G__9721 = b;
  var G__9722 = c;
  var G__9723 = d;
  var G__9724 = e;
  var G__9725 = f;
  var G__9726 = g;
  var G__9727 = h;
  var G__9728 = i;
  var G__9729 = j;
  var G__9730 = k;
  var G__9731 = l;
  var G__9732 = m;
  var G__9733 = n;
  var G__9734 = o;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__9720, G__9721, G__9722, G__9723, G__9724, G__9725, G__9726, G__9727, G__9728, G__9729, G__9730, G__9731, G__9732, G__9733, G__9734) : self__.afn.call(null, G__9720, G__9721, G__9722, G__9723, G__9724, G__9725, G__9726, G__9727, G__9728, G__9729, G__9730, G__9731, G__9732, G__9733, G__9734);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  var G__9735 = a;
  var G__9736 = b;
  var G__9737 = c;
  var G__9738 = d;
  var G__9739 = e;
  var G__9740 = f;
  var G__9741 = g;
  var G__9742 = h;
  var G__9743 = i;
  var G__9744 = j;
  var G__9745 = k;
  var G__9746 = l;
  var G__9747 = m;
  var G__9748 = n;
  var G__9749 = o;
  var G__9750 = p;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__9735, G__9736, G__9737, G__9738, G__9739, G__9740, G__9741, G__9742, G__9743, G__9744, G__9745, G__9746, G__9747, G__9748, G__9749, G__9750) : self__.afn.call(null, G__9735, G__9736, G__9737, G__9738, G__9739, G__9740, G__9741, G__9742, G__9743, G__9744, G__9745, G__9746, G__9747, G__9748, G__9749, G__9750);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  var G__9751 = a;
  var G__9752 = b;
  var G__9753 = c;
  var G__9754 = d;
  var G__9755 = e;
  var G__9756 = f;
  var G__9757 = g;
  var G__9758 = h;
  var G__9759 = i;
  var G__9760 = j;
  var G__9761 = k;
  var G__9762 = l;
  var G__9763 = m;
  var G__9764 = n;
  var G__9765 = o;
  var G__9766 = p;
  var G__9767 = q;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__9751, G__9752, G__9753, G__9754, G__9755, G__9756, G__9757, G__9758, G__9759, G__9760, G__9761, G__9762, G__9763, G__9764, G__9765, G__9766, G__9767) : self__.afn.call(null, G__9751, G__9752, G__9753, G__9754, G__9755, G__9756, G__9757, G__9758, G__9759, G__9760, G__9761, G__9762, G__9763, G__9764, G__9765, G__9766, G__9767);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  var G__9768 = a;
  var G__9769 = b;
  var G__9770 = c;
  var G__9771 = d;
  var G__9772 = e;
  var G__9773 = f;
  var G__9774 = g;
  var G__9775 = h;
  var G__9776 = i;
  var G__9777 = j;
  var G__9778 = k;
  var G__9779 = l;
  var G__9780 = m;
  var G__9781 = n;
  var G__9782 = o;
  var G__9783 = p;
  var G__9784 = q;
  var G__9785 = r;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__9768, G__9769, G__9770, G__9771, G__9772, G__9773, G__9774, G__9775, G__9776, G__9777, G__9778, G__9779, G__9780, G__9781, G__9782, G__9783, G__9784, G__9785) : self__.afn.call(null, G__9768, G__9769, G__9770, G__9771, G__9772, G__9773, G__9774, G__9775, G__9776, G__9777, G__9778, G__9779, G__9780, G__9781, G__9782, G__9783, G__9784, G__9785);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  var G__9786 = a;
  var G__9787 = b;
  var G__9788 = c;
  var G__9789 = d;
  var G__9790 = e;
  var G__9791 = f;
  var G__9792 = g;
  var G__9793 = h;
  var G__9794 = i;
  var G__9795 = j;
  var G__9796 = k;
  var G__9797 = l;
  var G__9798 = m;
  var G__9799 = n;
  var G__9800 = o;
  var G__9801 = p;
  var G__9802 = q;
  var G__9803 = r;
  var G__9804 = s;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__9786, G__9787, G__9788, G__9789, G__9790, G__9791, G__9792, G__9793, G__9794, G__9795, G__9796, G__9797, G__9798, G__9799, G__9800, G__9801, G__9802, G__9803, G__9804) : self__.afn.call(null, G__9786, G__9787, G__9788, G__9789, G__9790, G__9791, G__9792, G__9793, G__9794, G__9795, G__9796, G__9797, G__9798, G__9799, G__9800, G__9801, G__9802, G__9803, G__9804);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  var G__9805 = a;
  var G__9806 = b;
  var G__9807 = c;
  var G__9808 = d;
  var G__9809 = e;
  var G__9810 = f;
  var G__9811 = g;
  var G__9812 = h;
  var G__9813 = i;
  var G__9814 = j;
  var G__9815 = k;
  var G__9816 = l;
  var G__9817 = m;
  var G__9818 = n;
  var G__9819 = o;
  var G__9820 = p;
  var G__9821 = q;
  var G__9822 = r;
  var G__9823 = s;
  var G__9824 = t;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__9805, G__9806, G__9807, G__9808, G__9809, G__9810, G__9811, G__9812, G__9813, G__9814, G__9815, G__9816, G__9817, G__9818, G__9819, G__9820, G__9821, G__9822, G__9823, G__9824) : self__.afn.call(null, G__9805, G__9806, G__9807, G__9808, G__9809, G__9810, G__9811, G__9812, G__9813, G__9814, G__9815, G__9816, G__9817, G__9818, G__9819, G__9820, G__9821, G__9822, G__9823, G__9824);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__9825 = self__.afn;
  var G__9826 = a;
  var G__9827 = b;
  var G__9828 = c;
  var G__9829 = d;
  var G__9830 = e;
  var G__9831 = f;
  var G__9832 = g;
  var G__9833 = h;
  var G__9834 = i;
  var G__9835 = j;
  var G__9836 = k;
  var G__9837 = l;
  var G__9838 = m;
  var G__9839 = n;
  var G__9840 = o;
  var G__9841 = p;
  var G__9842 = q;
  var G__9843 = r;
  var G__9844 = s;
  var G__9845 = t;
  var G__9846 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9825, G__9826, G__9827, G__9828, G__9829, G__9830, G__9831, G__9832, G__9833, G__9834, G__9835, G__9836, G__9837, G__9838, G__9839, G__9840, G__9841, G__9842, G__9843, G__9844, G__9845, G__9846) : cljs.core.apply.call(null, G__9825, G__9826, G__9827, G__9828, G__9829, G__9830, G__9831, G__9832, G__9833, G__9834, G__9835, G__9836, G__9837, G__9838, G__9839, G__9840, G__9841, G__9842, G__9843, 
  G__9844, G__9845, G__9846);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (cljs.core.fn_QMARK_(o) && !function() {
    var G__9851 = o;
    if (G__9851) {
      var bit__4983__auto__ = G__9851.cljs$lang$protocol_mask$partition0$ & 262144;
      if (bit__4983__auto__ || G__9851.cljs$core$IWithMeta$) {
        return true;
      } else {
        if (!G__9851.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__9851);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__9851);
    }
  }()) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__4297__auto__ = !(o == null);
    if (and__4297__auto__) {
      var G__9855 = o;
      if (G__9855) {
        var bit__4983__auto__ = G__9855.cljs$lang$protocol_mask$partition0$ & 131072;
        if (bit__4983__auto__ || G__9855.cljs$core$IMeta$) {
          return true;
        } else {
          if (!G__9855.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__9855);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__9855);
      }
    } else {
      return and__4297__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj() {
  var G__9860 = arguments.length;
  switch(G__9860) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9862 = ret;
        var G__9863 = cljs.core.first(ks);
        var G__9864 = cljs.core.next(ks);
        coll = G__9862;
        k = G__9863;
        ks = G__9864;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq9856) {
  var G__9857 = cljs.core.first(seq9856);
  var seq9856__$1 = cljs.core.next(seq9856);
  var G__9858 = cljs.core.first(seq9856__$1);
  var seq9856__$2 = cljs.core.next(seq9856__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__9857, G__9858, seq9856__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__9866 = x;
    if (G__9866) {
      var bit__4983__auto__ = G__9866.cljs$lang$protocol_mask$partition0$ & 8;
      if (bit__4983__auto__ || G__9866.cljs$core$ICollection$) {
        return true;
      } else {
        if (!G__9866.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__9866);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__9866);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__9868 = x;
    if (G__9868) {
      var bit__4983__auto__ = G__9868.cljs$lang$protocol_mask$partition0$ & 4096;
      if (bit__4983__auto__ || G__9868.cljs$core$ISet$) {
        return true;
      } else {
        if (!G__9868.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__9868);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__9868);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  var G__9870 = x;
  if (G__9870) {
    var bit__4983__auto__ = G__9870.cljs$lang$protocol_mask$partition0$ & 512;
    if (bit__4983__auto__ || G__9870.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!G__9870.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__9870);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__9870);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  var G__9872 = x;
  if (G__9872) {
    var bit__4983__auto__ = G__9872.cljs$lang$protocol_mask$partition0$ & 16777216;
    if (bit__4983__auto__ || G__9872.cljs$core$ISequential$) {
      return true;
    } else {
      if (!G__9872.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__9872);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__9872);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  var G__9874 = x;
  if (G__9874) {
    var bit__4983__auto__ = G__9874.cljs$lang$protocol_mask$partition0$ & 268435456;
    if (bit__4983__auto__ || G__9874.cljs$core$ISorted$) {
      return true;
    } else {
      if (!G__9874.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__9874);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__9874);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  var G__9876 = x;
  if (G__9876) {
    var bit__4983__auto__ = G__9876.cljs$lang$protocol_mask$partition0$ & 524288;
    if (bit__4983__auto__ || G__9876.cljs$core$IReduce$) {
      return true;
    } else {
      if (!G__9876.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__9876);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__9876);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__9878 = x;
    if (G__9878) {
      var bit__4983__auto__ = G__9878.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4983__auto__ || G__9878.cljs$core$IMap$) {
        return true;
      } else {
        if (!G__9878.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__9878);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__9878);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  var G__9880 = x;
  if (G__9880) {
    var bit__4983__auto__ = G__9880.cljs$lang$protocol_mask$partition0$ & 67108864;
    if (bit__4983__auto__ || G__9880.cljs$core$IRecord$) {
      return true;
    } else {
      if (!G__9880.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__9880);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, G__9880);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  var G__9882 = x;
  if (G__9882) {
    var bit__4983__auto__ = G__9882.cljs$lang$protocol_mask$partition0$ & 16384;
    if (bit__4983__auto__ || G__9882.cljs$core$IVector$) {
      return true;
    } else {
      if (!G__9882.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__9882);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__9882);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  var G__9884 = x;
  if (G__9884) {
    var bit__4976__auto__ = G__9884.cljs$lang$protocol_mask$partition1$ & 512;
    if (bit__4976__auto__ || G__9884.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj() {
  var G__9887 = arguments.length;
  switch(G__9887) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  var obj9889 = {};
  return obj9889;
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var G__9890 = goog.object.create;
  var G__9891 = keyvals;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__9890, G__9891) : cljs.core.apply.call(null, G__9890, G__9891);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq9885) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9885));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__9895_9897 = obj;
  var G__9896_9898 = function(G__9895_9897, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__9895_9897, keys);
  goog.object.forEach(G__9895_9897, G__9896_9898);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9899 = i__$1 + 1;
      var G__9900 = j__$1 + 1;
      var G__9901 = len__$1 - 1;
      i__$1 = G__9899;
      j__$1 = G__9900;
      len__$1 = G__9901;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9902 = i__$1 - 1;
      var G__9903 = j__$1 - 1;
      var G__9904 = len__$1 - 1;
      i__$1 = G__9902;
      j__$1 = G__9903;
      len__$1 = G__9904;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = function() {
  var obj9906 = {};
  return obj9906;
}();
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    var G__9908 = s;
    if (G__9908) {
      var bit__4983__auto__ = G__9908.cljs$lang$protocol_mask$partition0$ & 64;
      if (bit__4983__auto__ || G__9908.cljs$core$ISeq$) {
        return true;
      } else {
        if (!G__9908.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9908);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__9908);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var G__9910 = s;
  if (G__9910) {
    var bit__4983__auto__ = G__9910.cljs$lang$protocol_mask$partition0$ & 8388608;
    if (bit__4983__auto__ || G__9910.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!G__9910.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__9910);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__9910);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (cljs.core.truth_(x)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__4309__auto__ = cljs.core.fn_QMARK_(f);
  if (or__4309__auto__) {
    return or__4309__auto__;
  } else {
    var G__9914 = f;
    if (G__9914) {
      var bit__4983__auto__ = G__9914.cljs$lang$protocol_mask$partition0$ & 1;
      if (bit__4983__auto__ || G__9914.cljs$core$IFn$) {
        return true;
      } else {
        if (!G__9914.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__9914);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__9914);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && cljs.core.not(function() {
    var G__9927 = n;
    return isNaN(G__9927);
  }()) && !(n === Infinity) && function() {
    var G__9928 = n;
    return parseFloat(G__9928);
  }() === function() {
    var G__9929 = n;
    var G__9930 = 10;
    return parseInt(G__9929, G__9930);
  }();
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_() {
  var G__9935 = arguments.length;
  switch(G__9935) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__9937 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__9938 = etc;
          s = G__9937;
          xs = G__9938;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq9931) {
  var G__9932 = cljs.core.first(seq9931);
  var seq9931__$1 = cljs.core.next(seq9931);
  var G__9933 = cljs.core.first(seq9931__$1);
  var seq9931__$2 = cljs.core.next(seq9931__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__9932, G__9933, seq9931__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            var G__9944 = x;
            var G__9945 = y;
            return goog.array.defaultCompare(G__9944, G__9945);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (function() {
            var G__9946 = x;
            if (G__9946) {
              var bit__4983__auto__ = G__9946.cljs$lang$protocol_mask$partition1$ & 2048;
              if (bit__4983__auto__ || G__9946.cljs$core$IComparable$) {
                return true;
              } else {
                if (!G__9946.cljs$lang$protocol_mask$partition1$) {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__9946);
                } else {
                  return false;
                }
              }
            } else {
              return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, G__9946);
            }
          }()) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              var G__9947 = x;
              var G__9948 = y;
              return goog.array.defaultCompare(G__9947, G__9948);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed() {
  var G__9950 = arguments.length;
  switch(G__9950) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__9952 = xs;
      var G__9953 = ys;
      var G__9954 = len;
      var G__9955 = n + 1;
      xs = G__9952;
      ys = G__9953;
      len = G__9954;
      n = G__9955;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = function() {
        var G__9960 = x;
        var G__9961 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9960, G__9961) : f.call(null, G__9960, G__9961);
      }();
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(function() {
            var G__9962 = y;
            var G__9963 = x;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9962, G__9963) : f.call(null, G__9962, G__9963);
          }())) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort() {
  var G__9965 = arguments.length;
  switch(G__9965) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = function() {
      var G__9966 = coll;
      return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__9966) : cljs.core.to_array.call(null, G__9966);
    }();
    var G__9967_9970 = a;
    var G__9968_9971 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__9967_9970, G__9968_9971);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by() {
  var G__9973 = arguments.length;
  switch(G__9973) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, function() {
      var G__9974 = x;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__9974) : keyfn.call(null, G__9974);
    }(), function() {
      var G__9975 = y;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__9975) : keyfn.call(null, G__9975);
    }());
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce() {
  var G__9978 = arguments.length;
  switch(G__9978) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4423__auto__ = cljs.core.seq(coll);
  if (temp__4423__auto__) {
    var s = temp__4423__auto__;
    var G__9979 = f;
    var G__9980 = cljs.core.first(s);
    var G__9981 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__9979, G__9980, G__9981) : cljs.core.reduce.call(null, G__9979, G__9980, G__9981);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__9982 = val__$1;
        var G__9983 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9982, G__9983) : f.call(null, G__9982, G__9983);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9985 = nval;
        var G__9986 = cljs.core.next(coll__$1);
        val__$1 = G__9985;
        coll__$1 = G__9986;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = function() {
    var G__9990 = coll;
    return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__9990) : cljs.core.to_array.call(null, G__9990);
  }();
  var G__9991_9993 = a;
  goog.array.shuffle(G__9991_9993);
  var G__9992 = a;
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__9992) : cljs.core.vec.call(null, G__9992);
};
cljs.core.reduce = function cljs$core$reduce() {
  var G__9995 = arguments.length;
  switch(G__9995) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (function() {
    var G__9996 = coll;
    if (G__9996) {
      var bit__4976__auto__ = G__9996.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__9996.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (function() {
    var G__9997 = coll;
    if (G__9997) {
      var bit__4976__auto__ = G__9997.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4976__auto__ || G__9997.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing() {
  var G__10000 = arguments.length;
  switch(G__10000) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__10005 = null;
    var G__10005__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__10005__1 = function(x) {
      var G__10001 = x;
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__10001) : cf.call(null, G__10001);
    };
    var G__10005__2 = function(x, y) {
      var G__10002 = x;
      var G__10003 = y;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10002, G__10003) : f.call(null, G__10002, G__10003);
    };
    G__10005 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__10005__0.call(this);
        case 1:
          return G__10005__1.call(this, x);
        case 2:
          return G__10005__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10005.cljs$core$IFn$_invoke$arity$0 = G__10005__0;
    G__10005.cljs$core$IFn$_invoke$arity$1 = G__10005__1;
    G__10005.cljs$core$IFn$_invoke$arity$2 = G__10005__2;
    return G__10005;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce() {
  var G__10007 = arguments.length;
  switch(G__10007) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, function() {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }(), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = function() {
    var G__10008 = f;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__10008) : xform.call(null, G__10008);
  }();
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  var G__10009 = ret;
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__10009) : f__$1.call(null, G__10009);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_() {
  var G__10015 = arguments.length;
  switch(G__10015) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq10011) {
  var G__10012 = cljs.core.first(seq10011);
  var seq10011__$1 = cljs.core.next(seq10011);
  var G__10013 = cljs.core.first(seq10011__$1);
  var seq10011__$2 = cljs.core.next(seq10011__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__10012, G__10013, seq10011__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_() {
  var G__10021 = arguments.length;
  switch(G__10021) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq10017) {
  var G__10018 = cljs.core.first(seq10017);
  var seq10017__$1 = cljs.core.next(seq10017);
  var G__10019 = cljs.core.first(seq10017__$1);
  var seq10017__$2 = cljs.core.next(seq10017__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__10018, G__10019, seq10017__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_() {
  var G__10027 = arguments.length;
  switch(G__10027) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq10023) {
  var G__10024 = cljs.core.first(seq10023);
  var seq10023__$1 = cljs.core.next(seq10023);
  var G__10025 = cljs.core.first(seq10023__$1);
  var seq10023__$2 = cljs.core.next(seq10023__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10024, G__10025, seq10023__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_() {
  var G__10033 = arguments.length;
  switch(G__10033) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq10029) {
  var G__10030 = cljs.core.first(seq10029);
  var seq10029__$1 = cljs.core.next(seq10029);
  var G__10031 = cljs.core.first(seq10029__$1);
  var seq10029__$2 = cljs.core.next(seq10029__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__10030, G__10031, seq10029__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_() {
  var G__10039 = arguments.length;
  switch(G__10039) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__10041 = y;
        var G__10042 = cljs.core.first(more);
        var G__10043 = cljs.core.next(more);
        x = G__10041;
        y = G__10042;
        more = G__10043;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq10035) {
  var G__10036 = cljs.core.first(seq10035);
  var seq10035__$1 = cljs.core.next(seq10035);
  var G__10037 = cljs.core.first(seq10035__$1);
  var seq10035__$2 = cljs.core.next(seq10035__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__10036, G__10037, seq10035__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_() {
  var G__10048 = arguments.length;
  switch(G__10048) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__10050 = y;
        var G__10051 = cljs.core.first(more);
        var G__10052 = cljs.core.next(more);
        x = G__10050;
        y = G__10051;
        more = G__10052;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq10044) {
  var G__10045 = cljs.core.first(seq10044);
  var seq10044__$1 = cljs.core.next(seq10044);
  var G__10046 = cljs.core.first(seq10044__$1);
  var seq10044__$2 = cljs.core.next(seq10044__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10045, G__10046, seq10044__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_() {
  var G__10057 = arguments.length;
  switch(G__10057) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__10059 = y;
        var G__10060 = cljs.core.first(more);
        var G__10061 = cljs.core.next(more);
        x = G__10059;
        y = G__10060;
        more = G__10061;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq10053) {
  var G__10054 = cljs.core.first(seq10053);
  var seq10053__$1 = cljs.core.next(seq10053);
  var G__10055 = cljs.core.first(seq10053__$1);
  var seq10053__$2 = cljs.core.next(seq10053__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__10054, G__10055, seq10053__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_() {
  var G__10066 = arguments.length;
  switch(G__10066) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__10068 = y;
        var G__10069 = cljs.core.first(more);
        var G__10070 = cljs.core.next(more);
        x = G__10068;
        y = G__10069;
        more = G__10070;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq10062) {
  var G__10063 = cljs.core.first(seq10062);
  var seq10062__$1 = cljs.core.next(seq10062);
  var G__10064 = cljs.core.first(seq10062__$1);
  var seq10062__$2 = cljs.core.next(seq10062__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10063, G__10064, seq10062__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max() {
  var G__10075 = arguments.length;
  switch(G__10075) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4621__auto__ = x;
  var y__4622__auto__ = y;
  return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__4621__auto__ = x;
    var y__4622__auto__ = y;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq10071) {
  var G__10072 = cljs.core.first(seq10071);
  var seq10071__$1 = cljs.core.next(seq10071);
  var G__10073 = cljs.core.first(seq10071__$1);
  var seq10071__$2 = cljs.core.next(seq10071__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__10072, G__10073, seq10071__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min() {
  var G__10081 = arguments.length;
  switch(G__10081) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4628__auto__ = x;
  var y__4629__auto__ = y;
  return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__4628__auto__ = x;
    var y__4629__auto__ = y;
    return x__4628__auto__ < y__4629__auto__ ? x__4628__auto__ : y__4629__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq10077) {
  var G__10078 = cljs.core.first(seq10077);
  var seq10077__$1 = cljs.core.next(seq10077);
  var G__10079 = cljs.core.first(seq10077__$1);
  var seq10077__$2 = cljs.core.next(seq10077__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__10078, G__10079, seq10077__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add() {
  var G__10087 = arguments.length;
  switch(G__10087) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq10083) {
  var G__10084 = cljs.core.first(seq10083);
  var seq10083__$1 = cljs.core.next(seq10083);
  var G__10085 = cljs.core.first(seq10083__$1);
  var seq10083__$2 = cljs.core.next(seq10083__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__10084, G__10085, seq10083__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int() {
  var G__10093 = arguments.length;
  switch(G__10093) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq10089) {
  var G__10090 = cljs.core.first(seq10089);
  var seq10089__$1 = cljs.core.next(seq10089);
  var G__10091 = cljs.core.first(seq10089__$1);
  var seq10089__$2 = cljs.core.next(seq10089__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__10090, G__10091, seq10089__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int() {
  var G__10099 = arguments.length;
  switch(G__10099) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq10095) {
  var G__10096 = cljs.core.first(seq10095);
  var seq10095__$1 = cljs.core.next(seq10095);
  var G__10097 = cljs.core.first(seq10095__$1);
  var seq10095__$2 = cljs.core.next(seq10095__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__10096, G__10097, seq10095__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply() {
  var G__10105 = arguments.length;
  switch(G__10105) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq10101) {
  var G__10102 = cljs.core.first(seq10101);
  var seq10101__$1 = cljs.core.next(seq10101);
  var G__10103 = cljs.core.first(seq10101__$1);
  var seq10101__$2 = cljs.core.next(seq10101__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__10102, G__10103, seq10101__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int() {
  var G__10111 = arguments.length;
  switch(G__10111) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq10107) {
  var G__10108 = cljs.core.first(seq10107);
  var seq10107__$1 = cljs.core.next(seq10107);
  var G__10109 = cljs.core.first(seq10107__$1);
  var seq10107__$2 = cljs.core.next(seq10107__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__10108, G__10109, seq10107__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  var G__10115 = x;
  var G__10116 = n;
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__10115, G__10116) : cljs.core.mod.call(null, G__10115, G__10116);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract() {
  var G__10121 = arguments.length;
  switch(G__10121) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq10117) {
  var G__10118 = cljs.core.first(seq10117);
  var seq10117__$1 = cljs.core.next(seq10117);
  var G__10119 = cljs.core.first(seq10117__$1);
  var seq10117__$2 = cljs.core.next(seq10117__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__10118, G__10119, seq10117__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int() {
  var G__10127 = arguments.length;
  switch(G__10127) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq10123) {
  var G__10124 = cljs.core.first(seq10123);
  var seq10123__$1 = cljs.core.next(seq10123);
  var G__10125 = cljs.core.first(seq10123__$1);
  var seq10123__$2 = cljs.core.next(seq10123__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__10124, G__10125, seq10123__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    var G__10131 = q;
    return Math.floor(G__10131);
  } else {
    var G__10132 = q;
    return Math.ceil(G__10132);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor() {
  var G__10137 = arguments.length;
  switch(G__10137) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq10133) {
  var G__10134 = cljs.core.first(seq10133);
  var seq10133__$1 = cljs.core.next(seq10133);
  var G__10135 = cljs.core.first(seq10133__$1);
  var seq10133__$2 = cljs.core.next(seq10133__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__10134, G__10135, seq10133__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and() {
  var G__10143 = arguments.length;
  switch(G__10143) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq10139) {
  var G__10140 = cljs.core.first(seq10139);
  var seq10139__$1 = cljs.core.next(seq10139);
  var G__10141 = cljs.core.first(seq10139__$1);
  var seq10139__$2 = cljs.core.next(seq10139__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__10140, G__10141, seq10139__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or() {
  var G__10149 = arguments.length;
  switch(G__10149) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq10145) {
  var G__10146 = cljs.core.first(seq10145);
  var seq10145__$1 = cljs.core.next(seq10145);
  var G__10147 = cljs.core.first(seq10145__$1);
  var seq10145__$2 = cljs.core.next(seq10145__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__10146, G__10147, seq10145__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not() {
  var G__10155 = arguments.length;
  switch(G__10155) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq10151) {
  var G__10152 = cljs.core.first(seq10151);
  var seq10151__$1 = cljs.core.next(seq10151);
  var G__10153 = cljs.core.first(seq10151__$1);
  var seq10151__$2 = cljs.core.next(seq10151__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__10152, G__10153, seq10151__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_() {
  var G__10161 = arguments.length;
  switch(G__10161) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__10163 = y;
        var G__10164 = cljs.core.first(more);
        var G__10165 = cljs.core.next(more);
        x = G__10163;
        y = G__10164;
        more = G__10165;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq10157) {
  var G__10158 = cljs.core.first(seq10157);
  var seq10157__$1 = cljs.core.next(seq10157);
  var G__10159 = cljs.core.first(seq10157__$1);
  var seq10157__$2 = cljs.core.next(seq10157__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10158, G__10159, seq10157__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(n) {
  return n > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(n) {
  return n === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__10166 = n__$1 - 1;
      var G__10167 = cljs.core.next(xs);
      n__$1 = G__10166;
      xs = G__10167;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str() {
  var G__10171 = arguments.length;
  switch(G__10171) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    var G__10172 = x;
    return goog.string.buildString(G__10172);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__10174 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__10175 = cljs.core.next(more);
      sb = G__10174;
      more = G__10175;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq10168) {
  var G__10169 = cljs.core.first(seq10168);
  var seq10168__$1 = cljs.core.next(seq10168);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__10169, seq10168__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs() {
  var G__10177 = arguments.length;
  switch(G__10177) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__10179 = cljs.core.next(xs);
            var G__10180 = cljs.core.next(ys);
            xs = G__10179;
            ys = G__10180;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__10181 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__10182 = cljs.core.next(s);
        res = G__10181;
        s = G__10182;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__10187 = (h + (cljs.core.hash(function() {
        var G__10185 = e;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10185) : cljs.core.key.call(null, G__10185);
      }()) ^ cljs.core.hash(function() {
        var G__10186 = e;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10186) : cljs.core.val.call(null, G__10186);
      }()))) % 4503599627370496;
      var G__10188 = cljs.core.next(s);
      h = G__10187;
      s = G__10188;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__10189 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__10190 = cljs.core.next(s__$1);
      h = G__10189;
      s__$1 = G__10190;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__10201_10211 = cljs.core.seq(fn_map);
  var chunk__10202_10212 = null;
  var count__10203_10213 = 0;
  var i__10204_10214 = 0;
  while (true) {
    if (i__10204_10214 < count__10203_10213) {
      var vec__10205_10215 = chunk__10202_10212.cljs$core$IIndexed$_nth$arity$2(null, i__10204_10214);
      var key_name_10216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10205_10215, 0, null);
      var f_10217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10205_10215, 1, null);
      var str_name_10218 = function() {
        var G__10206 = key_name_10216;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__10206) : cljs.core.name.call(null, G__10206);
      }();
      obj[str_name_10218] = f_10217;
      var G__10219 = seq__10201_10211;
      var G__10220 = chunk__10202_10212;
      var G__10221 = count__10203_10213;
      var G__10222 = i__10204_10214 + 1;
      seq__10201_10211 = G__10219;
      chunk__10202_10212 = G__10220;
      count__10203_10213 = G__10221;
      i__10204_10214 = G__10222;
      continue;
    } else {
      var temp__4425__auto___10223 = cljs.core.seq(seq__10201_10211);
      if (temp__4425__auto___10223) {
        var seq__10201_10224__$1 = temp__4425__auto___10223;
        if (cljs.core.chunked_seq_QMARK_(seq__10201_10224__$1)) {
          var c__5094__auto___10225 = function() {
            var G__10207 = seq__10201_10224__$1;
            return cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__10207) : cljs.core.chunk_first.call(null, G__10207);
          }();
          var G__10226 = function() {
            var G__10208 = seq__10201_10224__$1;
            return cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__10208) : cljs.core.chunk_rest.call(null, G__10208);
          }();
          var G__10227 = c__5094__auto___10225;
          var G__10228 = cljs.core.count(c__5094__auto___10225);
          var G__10229 = 0;
          seq__10201_10211 = G__10226;
          chunk__10202_10212 = G__10227;
          count__10203_10213 = G__10228;
          i__10204_10214 = G__10229;
          continue;
        } else {
          var vec__10209_10230 = cljs.core.first(seq__10201_10224__$1);
          var key_name_10231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209_10230, 0, null);
          var f_10232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209_10230, 1, null);
          var str_name_10233 = function() {
            var G__10210 = key_name_10231;
            return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__10210) : cljs.core.name.call(null, G__10210);
          }();
          obj[str_name_10233] = f_10232;
          var G__10234 = cljs.core.next(seq__10201_10224__$1);
          var G__10235 = null;
          var G__10236 = 0;
          var G__10237 = 0;
          seq__10201_10211 = G__10234;
          chunk__10202_10212 = G__10235;
          count__10203_10213 = G__10236;
          i__10204_10214 = G__10237;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  var G__10239 = coll;
  if (G__10239) {
    var bit__4983__auto__ = G__10239.cljs$lang$protocol_mask$partition0$ & 134217728;
    if (bit__4983__auto__ || G__10239.cljs$core$IReversible$) {
      return true;
    } else {
      if (!G__10239.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__10239);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__10239);
  }
};
cljs.core.rseq = function cljs$core$rseq(coll) {
  return cljs.core._rseq(coll);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__10241 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__10241;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__10242 = i - 1;
      var G__10243 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__10242;
      r = G__10243;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq10240) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10240));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, self__.__hash);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__4309__auto__ = coll == null;
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      var G__10247 = coll;
      if (G__10247) {
        var bit__4976__auto__ = G__10247.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4976__auto__ || G__10247.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  var G__10249 = x;
  if (G__10249) {
    var bit__4983__auto__ = G__10249.cljs$lang$protocol_mask$partition0$ & 33554432;
    if (bit__4983__auto__ || G__10249.cljs$core$IList$) {
      return true;
    } else {
      if (!G__10249.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__10249);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__10249);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = cljs.core.not(a.ns);
      if (and__4297__auto__) {
        return b.ns;
      } else {
        return and__4297__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__10256 = a.ns;
            var G__10257 = b.ns;
            return goog.array.defaultCompare(G__10256, G__10257);
          }();
          if (0 === nsc) {
            var G__10258 = a.name;
            var G__10259 = b.name;
            return goog.array.defaultCompare(G__10258, G__10259);
          } else {
            return nsc;
          }
        }
      } else {
        var G__10260 = a.name;
        var G__10261 = b.name;
        return goog.array.defaultCompare(G__10260, G__10261);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__10263 = null;
  var G__10263__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__10263__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__10263 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10263__2.call(this, self__, coll);
      case 3:
        return G__10263__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10263.cljs$core$IFn$_invoke$arity$2 = G__10263__2;
  G__10263.cljs$core$IFn$_invoke$arity$3 = G__10263__3;
  return G__10263;
}();
cljs.core.Keyword.prototype.apply = function(self__, args10262) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10262)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__4725__auto__ = self__._hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null)], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (function() {
    var G__10265 = x;
    if (G__10265) {
      var bit__4976__auto__ = G__10265.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__10265.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.keyword = function cljs$core$keyword() {
  var G__10267 = arguments.length;
  switch(G__10267) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), function() {
        var G__10268 = name;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__10268) : cljs.core.name.call(null, G__10268);
      }(), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = function() {
      return self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    }();
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__10270 = ls.sval();
        ls = G__10270;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk() {
  var G__10272 = arguments.length;
  switch(G__10272) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (function() {
    var G__10275 = s;
    if (G__10275) {
      var bit__4976__auto__ = G__10275.cljs$lang$protocol_mask$partition1$ & 1024;
      if (bit__4976__auto__ || G__10275.cljs$core$IChunkedNext$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__10276 = cljs.core.next(s__$1);
      s__$1 = G__10276;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_10277 = 0;
  var xs_10278 = cljs.core.seq(coll);
  while (true) {
    if (xs_10278) {
      ret[i_10277] = cljs.core.to_array(cljs.core.first(xs_10278));
      var G__10279 = i_10277 + 1;
      var G__10280 = cljs.core.next(xs_10278);
      i_10277 = G__10279;
      xs_10278 = G__10280;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array() {
  var G__10282 = arguments.length;
  switch(G__10282) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10284 = i + 1;
        var G__10285 = cljs.core.next(s__$1);
        i = G__10284;
        s__$1 = G__10285;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___10286 = size;
    var i_10287 = 0;
    while (true) {
      if (i_10287 < n__5194__auto___10286) {
        a[i_10287] = init_val_or_seq;
        var G__10288 = i_10287 + 1;
        i_10287 = G__10288;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array() {
  var G__10290 = arguments.length;
  switch(G__10290) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10292 = i + 1;
        var G__10293 = cljs.core.next(s__$1);
        i = G__10292;
        s__$1 = G__10293;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___10294 = size;
    var i_10295 = 0;
    while (true) {
      if (i_10295 < n__5194__auto___10294) {
        a[i_10295] = init_val_or_seq;
        var G__10296 = i_10295 + 1;
        i_10295 = G__10296;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array() {
  var G__10298 = arguments.length;
  switch(G__10298) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10300 = i + 1;
        var G__10301 = cljs.core.next(s__$1);
        i = G__10300;
        s__$1 = G__10301;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___10302 = size;
    var i_10303 = 0;
    while (true) {
      if (i_10303 < n__5194__auto___10302) {
        a[i_10303] = init_val_or_seq;
        var G__10304 = i_10303 + 1;
        i_10303 = G__10304;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array() {
  var G__10306 = arguments.length;
  switch(G__10306) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10308 = i + 1;
        var G__10309 = cljs.core.next(s__$1);
        i = G__10308;
        s__$1 = G__10309;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5194__auto___10310 = size;
    var i_10311 = 0;
    while (true) {
      if (i_10311 < n__5194__auto___10310) {
        a[i_10311] = init_val_or_seq;
        var G__10312 = i_10311 + 1;
        i_10311 = G__10312;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(s, n) {
  if (cljs.core.counted_QMARK_(s)) {
    return cljs.core.count(s);
  } else {
    var s__$1 = s;
    var i = n;
    var sum = 0;
    while (true) {
      if (i > 0 && cljs.core.seq(s__$1)) {
        var G__10313 = cljs.core.next(s__$1);
        var G__10314 = i - 1;
        var G__10315 = sum + 1;
        s__$1 = G__10313;
        i = G__10314;
        sum = G__10315;
        continue;
      } else {
        return sum;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat() {
  var G__10321 = arguments.length;
  switch(G__10321) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq10317) {
  var G__10318 = cljs.core.first(seq10317);
  var seq10317__$1 = cljs.core.next(seq10317);
  var G__10319 = cljs.core.first(seq10317__$1);
  var seq10317__$2 = cljs.core.next(seq10317__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__10318, G__10319, seq10317__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_() {
  var G__10335 = arguments.length;
  switch(G__10335) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq10329) {
  var G__10330 = cljs.core.first(seq10329);
  var seq10329__$1 = cljs.core.next(seq10329);
  var G__10331 = cljs.core.first(seq10329__$1);
  var seq10329__$2 = cljs.core.next(seq10329__$1);
  var G__10332 = cljs.core.first(seq10329__$2);
  var seq10329__$3 = cljs.core.next(seq10329__$2);
  var G__10333 = cljs.core.first(seq10329__$3);
  var seq10329__$4 = cljs.core.next(seq10329__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10330, G__10331, G__10332, G__10333, seq10329__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_() {
  var G__10341 = arguments.length;
  switch(G__10341) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__10343 = ntcoll;
      var G__10344 = cljs.core.first(vals);
      var G__10345 = cljs.core.next(vals);
      tcoll = G__10343;
      val = G__10344;
      vals = G__10345;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq10337) {
  var G__10338 = cljs.core.first(seq10337);
  var seq10337__$1 = cljs.core.next(seq10337);
  var G__10339 = cljs.core.first(seq10337__$1);
  var seq10337__$2 = cljs.core.next(seq10337__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10338, G__10339, seq10337__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_() {
  var G__10351 = arguments.length;
  switch(G__10351) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__10353 = ntcoll;
      var G__10354 = cljs.core.first(kvs);
      var G__10355 = cljs.core.second(kvs);
      var G__10356 = cljs.core.nnext(kvs);
      tcoll = G__10353;
      key = G__10354;
      val = G__10355;
      kvs = G__10356;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq10346) {
  var G__10347 = cljs.core.first(seq10346);
  var seq10346__$1 = cljs.core.next(seq10346);
  var G__10348 = cljs.core.first(seq10346__$1);
  var seq10346__$2 = cljs.core.next(seq10346__$1);
  var G__10349 = cljs.core.first(seq10346__$2);
  var seq10346__$3 = cljs.core.next(seq10346__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10347, G__10348, G__10349, seq10346__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_() {
  var G__10361 = arguments.length;
  switch(G__10361) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__10363 = ntcoll;
      var G__10364 = cljs.core.first(ks);
      var G__10365 = cljs.core.next(ks);
      tcoll = G__10363;
      key = G__10364;
      ks = G__10365;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq10357) {
  var G__10358 = cljs.core.first(seq10357);
  var seq10357__$1 = cljs.core.next(seq10357);
  var G__10359 = cljs.core.first(seq10357__$1);
  var seq10357__$2 = cljs.core.next(seq10357__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10358, G__10359, seq10357__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_() {
  var G__10370 = arguments.length;
  switch(G__10370) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__10372 = ntcoll;
      var G__10373 = cljs.core.first(vals);
      var G__10374 = cljs.core.next(vals);
      tcoll = G__10372;
      val = G__10373;
      vals = G__10374;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq10366) {
  var G__10367 = cljs.core.first(seq10366);
  var seq10366__$1 = cljs.core.next(seq10366);
  var G__10368 = cljs.core.first(seq10366__$1);
  var seq10366__$2 = cljs.core.next(seq10366__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10367, G__10368, seq10366__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a5238 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a5238);
      } else {
        var G__10585 = a5238;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10585) : f.call(null, G__10585);
      }
    } else {
      var b5239 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a5238, b5239);
        } else {
          var G__10586 = a5238;
          var G__10587 = b5239;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10586, G__10587) : f.call(null, G__10586, G__10587);
        }
      } else {
        var c5240 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a5238, b5239, c5240);
          } else {
            var G__10588 = a5238;
            var G__10589 = b5239;
            var G__10590 = c5240;
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10588, G__10589, G__10590) : f.call(null, G__10588, G__10589, G__10590);
          }
        } else {
          var d5241 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a5238, b5239, c5240, d5241);
            } else {
              var G__10591 = a5238;
              var G__10592 = b5239;
              var G__10593 = c5240;
              var G__10594 = d5241;
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10591, G__10592, G__10593, G__10594) : f.call(null, G__10591, G__10592, G__10593, G__10594);
            }
          } else {
            var e5242 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a5238, b5239, c5240, d5241, e5242);
              } else {
                var G__10595 = a5238;
                var G__10596 = b5239;
                var G__10597 = c5240;
                var G__10598 = d5241;
                var G__10599 = e5242;
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__10595, G__10596, G__10597, G__10598, G__10599) : f.call(null, G__10595, G__10596, G__10597, G__10598, G__10599);
              }
            } else {
              var f5243 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a5238, b5239, c5240, d5241, e5242, f5243);
                } else {
                  var G__10600 = a5238;
                  var G__10601 = b5239;
                  var G__10602 = c5240;
                  var G__10603 = d5241;
                  var G__10604 = e5242;
                  var G__10605 = f5243;
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__10600, G__10601, G__10602, G__10603, G__10604, G__10605) : f.call(null, G__10600, G__10601, G__10602, G__10603, G__10604, G__10605);
                }
              } else {
                var g5244 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a5238, b5239, c5240, d5241, e5242, f5243, g5244);
                  } else {
                    var G__10606 = a5238;
                    var G__10607 = b5239;
                    var G__10608 = c5240;
                    var G__10609 = d5241;
                    var G__10610 = e5242;
                    var G__10611 = f5243;
                    var G__10612 = g5244;
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__10606, G__10607, G__10608, G__10609, G__10610, G__10611, G__10612) : f.call(null, G__10606, G__10607, G__10608, G__10609, G__10610, G__10611, G__10612);
                  }
                } else {
                  var h5245 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245);
                    } else {
                      var G__10613 = a5238;
                      var G__10614 = b5239;
                      var G__10615 = c5240;
                      var G__10616 = d5241;
                      var G__10617 = e5242;
                      var G__10618 = f5243;
                      var G__10619 = g5244;
                      var G__10620 = h5245;
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__10613, G__10614, G__10615, G__10616, G__10617, G__10618, G__10619, G__10620) : f.call(null, G__10613, G__10614, G__10615, G__10616, G__10617, G__10618, G__10619, G__10620);
                    }
                  } else {
                    var i5246 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246);
                      } else {
                        var G__10621 = a5238;
                        var G__10622 = b5239;
                        var G__10623 = c5240;
                        var G__10624 = d5241;
                        var G__10625 = e5242;
                        var G__10626 = f5243;
                        var G__10627 = g5244;
                        var G__10628 = h5245;
                        var G__10629 = i5246;
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__10621, G__10622, G__10623, G__10624, G__10625, G__10626, G__10627, G__10628, G__10629) : f.call(null, G__10621, G__10622, G__10623, G__10624, G__10625, G__10626, G__10627, G__10628, G__10629);
                      }
                    } else {
                      var j5247 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247);
                        } else {
                          var G__10630 = a5238;
                          var G__10631 = b5239;
                          var G__10632 = c5240;
                          var G__10633 = d5241;
                          var G__10634 = e5242;
                          var G__10635 = f5243;
                          var G__10636 = g5244;
                          var G__10637 = h5245;
                          var G__10638 = i5246;
                          var G__10639 = j5247;
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__10630, G__10631, G__10632, G__10633, G__10634, G__10635, G__10636, G__10637, G__10638, G__10639) : f.call(null, G__10630, G__10631, G__10632, G__10633, G__10634, G__10635, G__10636, G__10637, G__10638, G__10639);
                        }
                      } else {
                        var k5248 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248);
                          } else {
                            var G__10640 = a5238;
                            var G__10641 = b5239;
                            var G__10642 = c5240;
                            var G__10643 = d5241;
                            var G__10644 = e5242;
                            var G__10645 = f5243;
                            var G__10646 = g5244;
                            var G__10647 = h5245;
                            var G__10648 = i5246;
                            var G__10649 = j5247;
                            var G__10650 = k5248;
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__10640, G__10641, G__10642, G__10643, G__10644, G__10645, G__10646, G__10647, G__10648, G__10649, G__10650) : f.call(null, G__10640, G__10641, G__10642, G__10643, G__10644, G__10645, G__10646, G__10647, G__10648, G__10649, G__10650);
                          }
                        } else {
                          var l5249 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249);
                            } else {
                              var G__10651 = a5238;
                              var G__10652 = b5239;
                              var G__10653 = c5240;
                              var G__10654 = d5241;
                              var G__10655 = e5242;
                              var G__10656 = f5243;
                              var G__10657 = g5244;
                              var G__10658 = h5245;
                              var G__10659 = i5246;
                              var G__10660 = j5247;
                              var G__10661 = k5248;
                              var G__10662 = l5249;
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__10651, G__10652, G__10653, G__10654, G__10655, G__10656, G__10657, G__10658, G__10659, G__10660, G__10661, G__10662) : f.call(null, G__10651, G__10652, G__10653, G__10654, G__10655, G__10656, G__10657, G__10658, G__10659, G__10660, G__10661, G__10662);
                            }
                          } else {
                            var m5250 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250);
                              } else {
                                var G__10663 = a5238;
                                var G__10664 = b5239;
                                var G__10665 = c5240;
                                var G__10666 = d5241;
                                var G__10667 = e5242;
                                var G__10668 = f5243;
                                var G__10669 = g5244;
                                var G__10670 = h5245;
                                var G__10671 = i5246;
                                var G__10672 = j5247;
                                var G__10673 = k5248;
                                var G__10674 = l5249;
                                var G__10675 = m5250;
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__10663, G__10664, G__10665, G__10666, G__10667, G__10668, G__10669, G__10670, G__10671, G__10672, G__10673, G__10674, G__10675) : f.call(null, G__10663, G__10664, G__10665, G__10666, G__10667, G__10668, G__10669, G__10670, G__10671, G__10672, G__10673, G__10674, G__10675);
                              }
                            } else {
                              var n5251 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251);
                                } else {
                                  var G__10676 = a5238;
                                  var G__10677 = b5239;
                                  var G__10678 = c5240;
                                  var G__10679 = d5241;
                                  var G__10680 = e5242;
                                  var G__10681 = f5243;
                                  var G__10682 = g5244;
                                  var G__10683 = h5245;
                                  var G__10684 = i5246;
                                  var G__10685 = j5247;
                                  var G__10686 = k5248;
                                  var G__10687 = l5249;
                                  var G__10688 = m5250;
                                  var G__10689 = n5251;
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__10676, G__10677, G__10678, G__10679, G__10680, G__10681, G__10682, G__10683, G__10684, G__10685, G__10686, G__10687, G__10688, G__10689) : f.call(null, G__10676, G__10677, G__10678, G__10679, G__10680, G__10681, G__10682, G__10683, G__10684, G__10685, G__10686, G__10687, G__10688, G__10689);
                                }
                              } else {
                                var o5252 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252);
                                  } else {
                                    var G__10690 = a5238;
                                    var G__10691 = b5239;
                                    var G__10692 = c5240;
                                    var G__10693 = d5241;
                                    var G__10694 = e5242;
                                    var G__10695 = f5243;
                                    var G__10696 = g5244;
                                    var G__10697 = h5245;
                                    var G__10698 = i5246;
                                    var G__10699 = j5247;
                                    var G__10700 = k5248;
                                    var G__10701 = l5249;
                                    var G__10702 = m5250;
                                    var G__10703 = n5251;
                                    var G__10704 = o5252;
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__10690, G__10691, G__10692, G__10693, G__10694, G__10695, G__10696, G__10697, G__10698, G__10699, G__10700, G__10701, G__10702, G__10703, G__10704) : f.call(null, G__10690, G__10691, G__10692, G__10693, G__10694, G__10695, G__10696, G__10697, G__10698, G__10699, G__10700, G__10701, G__10702, G__10703, G__10704);
                                  }
                                } else {
                                  var p5253 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253);
                                    } else {
                                      var G__10705 = a5238;
                                      var G__10706 = b5239;
                                      var G__10707 = c5240;
                                      var G__10708 = d5241;
                                      var G__10709 = e5242;
                                      var G__10710 = f5243;
                                      var G__10711 = g5244;
                                      var G__10712 = h5245;
                                      var G__10713 = i5246;
                                      var G__10714 = j5247;
                                      var G__10715 = k5248;
                                      var G__10716 = l5249;
                                      var G__10717 = m5250;
                                      var G__10718 = n5251;
                                      var G__10719 = o5252;
                                      var G__10720 = p5253;
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__10705, G__10706, G__10707, G__10708, G__10709, G__10710, G__10711, G__10712, G__10713, G__10714, G__10715, G__10716, G__10717, G__10718, G__10719, G__10720) : f.call(null, G__10705, G__10706, G__10707, G__10708, G__10709, G__10710, G__10711, G__10712, G__10713, G__10714, G__10715, G__10716, G__10717, G__10718, G__10719, G__10720);
                                    }
                                  } else {
                                    var q5254 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254);
                                      } else {
                                        var G__10721 = a5238;
                                        var G__10722 = b5239;
                                        var G__10723 = c5240;
                                        var G__10724 = d5241;
                                        var G__10725 = e5242;
                                        var G__10726 = f5243;
                                        var G__10727 = g5244;
                                        var G__10728 = h5245;
                                        var G__10729 = i5246;
                                        var G__10730 = j5247;
                                        var G__10731 = k5248;
                                        var G__10732 = l5249;
                                        var G__10733 = m5250;
                                        var G__10734 = n5251;
                                        var G__10735 = o5252;
                                        var G__10736 = p5253;
                                        var G__10737 = q5254;
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__10721, G__10722, G__10723, G__10724, G__10725, G__10726, G__10727, G__10728, G__10729, G__10730, G__10731, G__10732, G__10733, G__10734, G__10735, G__10736, G__10737) : f.call(null, G__10721, G__10722, G__10723, G__10724, G__10725, G__10726, G__10727, G__10728, G__10729, G__10730, G__10731, G__10732, G__10733, G__10734, G__10735, G__10736, G__10737);
                                      }
                                    } else {
                                      var r5255 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255);
                                        } else {
                                          var G__10738 = a5238;
                                          var G__10739 = b5239;
                                          var G__10740 = c5240;
                                          var G__10741 = d5241;
                                          var G__10742 = e5242;
                                          var G__10743 = f5243;
                                          var G__10744 = g5244;
                                          var G__10745 = h5245;
                                          var G__10746 = i5246;
                                          var G__10747 = j5247;
                                          var G__10748 = k5248;
                                          var G__10749 = l5249;
                                          var G__10750 = m5250;
                                          var G__10751 = n5251;
                                          var G__10752 = o5252;
                                          var G__10753 = p5253;
                                          var G__10754 = q5254;
                                          var G__10755 = r5255;
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__10738, G__10739, G__10740, G__10741, G__10742, G__10743, G__10744, G__10745, G__10746, G__10747, G__10748, G__10749, G__10750, G__10751, G__10752, G__10753, G__10754, G__10755) : f.call(null, G__10738, G__10739, G__10740, G__10741, G__10742, G__10743, G__10744, G__10745, G__10746, G__10747, G__10748, G__10749, G__10750, G__10751, G__10752, G__10753, G__10754, G__10755);
                                        }
                                      } else {
                                        var s5256 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256);
                                          } else {
                                            var G__10756 = a5238;
                                            var G__10757 = b5239;
                                            var G__10758 = c5240;
                                            var G__10759 = d5241;
                                            var G__10760 = e5242;
                                            var G__10761 = f5243;
                                            var G__10762 = g5244;
                                            var G__10763 = h5245;
                                            var G__10764 = i5246;
                                            var G__10765 = j5247;
                                            var G__10766 = k5248;
                                            var G__10767 = l5249;
                                            var G__10768 = m5250;
                                            var G__10769 = n5251;
                                            var G__10770 = o5252;
                                            var G__10771 = p5253;
                                            var G__10772 = q5254;
                                            var G__10773 = r5255;
                                            var G__10774 = s5256;
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__10756, G__10757, G__10758, G__10759, G__10760, G__10761, G__10762, G__10763, G__10764, G__10765, G__10766, G__10767, G__10768, G__10769, G__10770, G__10771, G__10772, G__10773, G__10774) : f.call(null, G__10756, G__10757, G__10758, G__10759, G__10760, G__10761, G__10762, G__10763, G__10764, G__10765, G__10766, G__10767, G__10768, G__10769, G__10770, G__10771, G__10772, G__10773, 
                                            G__10774);
                                          }
                                        } else {
                                          var t5257 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a5238, b5239, c5240, d5241, e5242, f5243, g5244, h5245, i5246, j5247, k5248, l5249, m5250, n5251, o5252, p5253, q5254, r5255, s5256, t5257);
                                            } else {
                                              var G__10775 = a5238;
                                              var G__10776 = b5239;
                                              var G__10777 = c5240;
                                              var G__10778 = d5241;
                                              var G__10779 = e5242;
                                              var G__10780 = f5243;
                                              var G__10781 = g5244;
                                              var G__10782 = h5245;
                                              var G__10783 = i5246;
                                              var G__10784 = j5247;
                                              var G__10785 = k5248;
                                              var G__10786 = l5249;
                                              var G__10787 = m5250;
                                              var G__10788 = n5251;
                                              var G__10789 = o5252;
                                              var G__10790 = p5253;
                                              var G__10791 = q5254;
                                              var G__10792 = r5255;
                                              var G__10793 = s5256;
                                              var G__10794 = t5257;
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__10775, G__10776, G__10777, G__10778, G__10779, G__10780, G__10781, G__10782, G__10783, G__10784, G__10785, G__10786, G__10787, G__10788, G__10789, G__10790, G__10791, G__10792, G__10793, G__10794) : f.call(null, G__10775, G__10776, G__10777, G__10778, G__10779, G__10780, G__10781, G__10782, G__10783, G__10784, G__10785, G__10786, G__10787, G__10788, G__10789, G__10790, G__10791, 
                                              G__10792, G__10793, G__10794);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply() {
  var G__10802 = arguments.length;
  switch(G__10802) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 5), 0);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__5360__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(args, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq10795) {
  var G__10796 = cljs.core.first(seq10795);
  var seq10795__$1 = cljs.core.next(seq10795);
  var G__10797 = cljs.core.first(seq10795__$1);
  var seq10795__$2 = cljs.core.next(seq10795__$1);
  var G__10798 = cljs.core.first(seq10795__$2);
  var seq10795__$3 = cljs.core.next(seq10795__$2);
  var G__10799 = cljs.core.first(seq10795__$3);
  var seq10795__$4 = cljs.core.next(seq10795__$3);
  var G__10800 = cljs.core.first(seq10795__$4);
  var seq10795__$5 = cljs.core.next(seq10795__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__10796, G__10797, G__10798, G__10799, G__10800, seq10795__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta() {
  var G__10812 = arguments.length;
  switch(G__10812) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__10813 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10813) : f.call(null, G__10813);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__10814 = cljs.core.meta(obj);
    var G__10815 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10814, G__10815) : f.call(null, G__10814, G__10815);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__10816 = cljs.core.meta(obj);
    var G__10817 = a;
    var G__10818 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10816, G__10817, G__10818) : f.call(null, G__10816, G__10817, G__10818);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__10819 = cljs.core.meta(obj);
    var G__10820 = a;
    var G__10821 = b;
    var G__10822 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10819, G__10820, G__10821, G__10822) : f.call(null, G__10819, G__10820, G__10821, G__10822);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__10823 = cljs.core.meta(obj);
    var G__10824 = a;
    var G__10825 = b;
    var G__10826 = c;
    var G__10827 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__10823, G__10824, G__10825, G__10826, G__10827) : f.call(null, G__10823, G__10824, G__10825, G__10826, G__10827);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq10804) {
  var G__10805 = cljs.core.first(seq10804);
  var seq10804__$1 = cljs.core.next(seq10804);
  var G__10806 = cljs.core.first(seq10804__$1);
  var seq10804__$2 = cljs.core.next(seq10804__$1);
  var G__10807 = cljs.core.first(seq10804__$2);
  var seq10804__$3 = cljs.core.next(seq10804__$2);
  var G__10808 = cljs.core.first(seq10804__$3);
  var seq10804__$4 = cljs.core.next(seq10804__$3);
  var G__10809 = cljs.core.first(seq10804__$4);
  var seq10804__$5 = cljs.core.next(seq10804__$4);
  var G__10810 = cljs.core.first(seq10804__$5);
  var seq10804__$6 = cljs.core.next(seq10804__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__10805, G__10806, G__10807, G__10808, G__10809, G__10810, seq10804__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_() {
  var G__10833 = arguments.length;
  switch(G__10833) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq10829) {
  var G__10830 = cljs.core.first(seq10829);
  var seq10829__$1 = cljs.core.next(seq10829);
  var G__10831 = cljs.core.first(seq10829__$1);
  var seq10829__$2 = cljs.core.next(seq10829__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10830, G__10831, seq10829__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t10838 !== "undefined") {
  } else {
    cljs.core.t10838 = function(nil_iter, meta10839) {
      this.nil_iter = nil_iter;
      this.meta10839 = meta10839;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t10838.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_10840, meta10839__$1) {
      var self__ = this;
      var _10840__$1 = this;
      return new cljs.core.t10838(self__.nil_iter, meta10839__$1);
    };
    cljs.core.t10838.prototype.cljs$core$IMeta$_meta$arity$1 = function(_10840) {
      var self__ = this;
      var _10840__$1 = this;
      return self__.meta10839;
    };
    cljs.core.t10838.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t10838.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t10838.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t10838.getBasis = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-iter", "nil-iter", 1101030523, null), new cljs.core.Symbol(null, "meta10839", "meta10839", 1697181765, null)], null);
    };
    cljs.core.t10838.cljs$lang$type = true;
    cljs.core.t10838.cljs$lang$ctorStr = "cljs.core/t10838";
    cljs.core.t10838.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
      return cljs.core._write(writer__4889__auto__, "cljs.core/t10838");
    };
    cljs.core.__GT_t10838 = function cljs$core$nil_iter_$___GT_t10838(nil_iter__$1, meta10839) {
      return new cljs.core.t10838(nil_iter__$1, meta10839);
    };
  }
  return new cljs.core.t10838(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.Symbol(null, "_next", "_next", 101877036, null)], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.truth_(cljs.core.iterable_QMARK_(coll))) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__10841 = lt;
        var G__10842 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__10841, G__10842) : self__.xform.call(null, G__10841, G__10842);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__10843 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__10843) : self__.xform.call(null, G__10843);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(function() {
    var G__10845 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__10845) : xform.call(null, G__10845);
  }(), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__10847 = cljs.core.next(iters__$1);
        iters__$1 = G__10847;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__5194__auto___10848 = self__.iters.length;
  var i_10849 = 0;
  while (true) {
    if (i_10849 < n__5194__auto___10848) {
      self__.nexts[i_10849] = self__.iters[i_10849].next();
      var G__10850 = i_10849 + 1;
      i_10849 = G__10850;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4297__auto__ = !(lt.stepper == null);
      if (and__4297__auto__) {
        return this$.hasNext();
      } else {
        return and__4297__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__10846 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__10846) : self__.xform.call(null, G__10846);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper() {
  var G__10852 = arguments.length;
  switch(G__10852) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(function() {
    var G__10853 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__10853) : xform.call(null, G__10853);
  }(), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31719628;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__10855_10859 = cljs.core.seq(colls);
  var chunk__10856_10860 = null;
  var count__10857_10861 = 0;
  var i__10858_10862 = 0;
  while (true) {
    if (i__10858_10862 < count__10857_10861) {
      var coll_10863 = chunk__10856_10860.cljs$core$IIndexed$_nth$arity$2(null, i__10858_10862);
      iters.push(cljs.core.iter(coll_10863));
      var G__10864 = seq__10855_10859;
      var G__10865 = chunk__10856_10860;
      var G__10866 = count__10857_10861;
      var G__10867 = i__10858_10862 + 1;
      seq__10855_10859 = G__10864;
      chunk__10856_10860 = G__10865;
      count__10857_10861 = G__10866;
      i__10858_10862 = G__10867;
      continue;
    } else {
      var temp__4425__auto___10868 = cljs.core.seq(seq__10855_10859);
      if (temp__4425__auto___10868) {
        var seq__10855_10869__$1 = temp__4425__auto___10868;
        if (cljs.core.chunked_seq_QMARK_(seq__10855_10869__$1)) {
          var c__5094__auto___10870 = cljs.core.chunk_first(seq__10855_10869__$1);
          var G__10871 = cljs.core.chunk_rest(seq__10855_10869__$1);
          var G__10872 = c__5094__auto___10870;
          var G__10873 = cljs.core.count(c__5094__auto___10870);
          var G__10874 = 0;
          seq__10855_10859 = G__10871;
          chunk__10856_10860 = G__10872;
          count__10857_10861 = G__10873;
          i__10858_10862 = G__10874;
          continue;
        } else {
          var coll_10875 = cljs.core.first(seq__10855_10869__$1);
          iters.push(cljs.core.iter(coll_10875));
          var G__10876 = cljs.core.next(seq__10855_10869__$1);
          var G__10877 = null;
          var G__10878 = 0;
          var G__10879 = 0;
          seq__10855_10859 = G__10876;
          chunk__10856_10860 = G__10877;
          count__10857_10861 = G__10878;
          i__10858_10862 = G__10879;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence() {
  var G__10884 = arguments.length;
  switch(G__10884) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__4309__auto__ = cljs.core.seq(coll);
    if (or__4309__auto__) {
      return or__4309__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq10880) {
  var G__10881 = cljs.core.first(seq10880);
  var seq10880__$1 = cljs.core.next(seq10880);
  var G__10882 = cljs.core.first(seq10880__$1);
  var seq10880__$2 = cljs.core.next(seq10880__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__10881, G__10882, seq10880__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__10887 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10887) : pred.call(null, G__10887);
      }())) {
        var G__10888 = pred;
        var G__10889 = cljs.core.next(coll);
        pred = G__10888;
        coll = G__10889;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__4309__auto__ = function() {
        var G__10893 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10893) : pred.call(null, G__10893);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__10894 = pred;
        var G__10895 = cljs.core.next(coll);
        pred = G__10894;
        coll = G__10895;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__10902 = null;
    var G__10902__0 = function() {
      return cljs.core.not(function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }());
    };
    var G__10902__1 = function(x) {
      return cljs.core.not(function() {
        var G__10899 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10899) : f.call(null, G__10899);
      }());
    };
    var G__10902__2 = function(x, y) {
      return cljs.core.not(function() {
        var G__10900 = x;
        var G__10901 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10900, G__10901) : f.call(null, G__10900, G__10901);
      }());
    };
    var G__10902__3 = function() {
      var G__10903__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__10903 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__10904__i = 0, G__10904__a = new Array(arguments.length - 2);
          while (G__10904__i < G__10904__a.length) {
            G__10904__a[G__10904__i] = arguments[G__10904__i + 2];
            ++G__10904__i;
          }
          zs = new cljs.core.IndexedSeq(G__10904__a, 0);
        }
        return G__10903__delegate.call(this, x, y, zs);
      };
      G__10903.cljs$lang$maxFixedArity = 2;
      G__10903.cljs$lang$applyTo = function(arglist__10905) {
        var x = cljs.core.first(arglist__10905);
        arglist__10905 = cljs.core.next(arglist__10905);
        var y = cljs.core.first(arglist__10905);
        var zs = cljs.core.rest(arglist__10905);
        return G__10903__delegate(x, y, zs);
      };
      G__10903.cljs$core$IFn$_invoke$arity$variadic = G__10903__delegate;
      return G__10903;
    }();
    G__10902 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__10902__0.call(this);
        case 1:
          return G__10902__1.call(this, x);
        case 2:
          return G__10902__2.call(this, x, y);
        default:
          var G__10906 = null;
          if (arguments.length > 2) {
            var G__10907__i = 0, G__10907__a = new Array(arguments.length - 2);
            while (G__10907__i < G__10907__a.length) {
              G__10907__a[G__10907__i] = arguments[G__10907__i + 2];
              ++G__10907__i;
            }
            G__10906 = new cljs.core.IndexedSeq(G__10907__a, 0);
          }
          return G__10902__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__10906);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10902.cljs$lang$maxFixedArity = 2;
    G__10902.cljs$lang$applyTo = G__10902__3.cljs$lang$applyTo;
    G__10902.cljs$core$IFn$_invoke$arity$0 = G__10902__0;
    G__10902.cljs$core$IFn$_invoke$arity$1 = G__10902__1;
    G__10902.cljs$core$IFn$_invoke$arity$2 = G__10902__2;
    G__10902.cljs$core$IFn$_invoke$arity$variadic = G__10902__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__10902;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__10908__delegate = function(args) {
      return x;
    };
    var G__10908 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__10909__i = 0, G__10909__a = new Array(arguments.length - 0);
        while (G__10909__i < G__10909__a.length) {
          G__10909__a[G__10909__i] = arguments[G__10909__i + 0];
          ++G__10909__i;
        }
        args = new cljs.core.IndexedSeq(G__10909__a, 0);
      }
      return G__10908__delegate.call(this, args);
    };
    G__10908.cljs$lang$maxFixedArity = 0;
    G__10908.cljs$lang$applyTo = function(arglist__10910) {
      var args = cljs.core.seq(arglist__10910);
      return G__10908__delegate(args);
    };
    G__10908.cljs$core$IFn$_invoke$arity$variadic = G__10908__delegate;
    return G__10908;
  }();
};
cljs.core.comp = function cljs$core$comp() {
  var G__10916 = arguments.length;
  switch(G__10916) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__10945 = null;
    var G__10945__0 = function() {
      var G__10917 = function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10917) : f.call(null, G__10917);
    };
    var G__10945__1 = function(x) {
      var G__10918 = function() {
        var G__10919 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10919) : g.call(null, G__10919);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10918) : f.call(null, G__10918);
    };
    var G__10945__2 = function(x, y) {
      var G__10920 = function() {
        var G__10921 = x;
        var G__10922 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__10921, G__10922) : g.call(null, G__10921, G__10922);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10920) : f.call(null, G__10920);
    };
    var G__10945__3 = function(x, y, z) {
      var G__10923 = function() {
        var G__10924 = x;
        var G__10925 = y;
        var G__10926 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__10924, G__10925, G__10926) : g.call(null, G__10924, G__10925, G__10926);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10923) : f.call(null, G__10923);
    };
    var G__10945__4 = function() {
      var G__10946__delegate = function(x, y, z, args) {
        var G__10927 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10927) : f.call(null, G__10927);
      };
      var G__10946 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10947__i = 0, G__10947__a = new Array(arguments.length - 3);
          while (G__10947__i < G__10947__a.length) {
            G__10947__a[G__10947__i] = arguments[G__10947__i + 3];
            ++G__10947__i;
          }
          args = new cljs.core.IndexedSeq(G__10947__a, 0);
        }
        return G__10946__delegate.call(this, x, y, z, args);
      };
      G__10946.cljs$lang$maxFixedArity = 3;
      G__10946.cljs$lang$applyTo = function(arglist__10948) {
        var x = cljs.core.first(arglist__10948);
        arglist__10948 = cljs.core.next(arglist__10948);
        var y = cljs.core.first(arglist__10948);
        arglist__10948 = cljs.core.next(arglist__10948);
        var z = cljs.core.first(arglist__10948);
        var args = cljs.core.rest(arglist__10948);
        return G__10946__delegate(x, y, z, args);
      };
      G__10946.cljs$core$IFn$_invoke$arity$variadic = G__10946__delegate;
      return G__10946;
    }();
    G__10945 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10945__0.call(this);
        case 1:
          return G__10945__1.call(this, x);
        case 2:
          return G__10945__2.call(this, x, y);
        case 3:
          return G__10945__3.call(this, x, y, z);
        default:
          var G__10949 = null;
          if (arguments.length > 3) {
            var G__10950__i = 0, G__10950__a = new Array(arguments.length - 3);
            while (G__10950__i < G__10950__a.length) {
              G__10950__a[G__10950__i] = arguments[G__10950__i + 3];
              ++G__10950__i;
            }
            G__10949 = new cljs.core.IndexedSeq(G__10950__a, 0);
          }
          return G__10945__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10949);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10945.cljs$lang$maxFixedArity = 3;
    G__10945.cljs$lang$applyTo = G__10945__4.cljs$lang$applyTo;
    G__10945.cljs$core$IFn$_invoke$arity$0 = G__10945__0;
    G__10945.cljs$core$IFn$_invoke$arity$1 = G__10945__1;
    G__10945.cljs$core$IFn$_invoke$arity$2 = G__10945__2;
    G__10945.cljs$core$IFn$_invoke$arity$3 = G__10945__3;
    G__10945.cljs$core$IFn$_invoke$arity$variadic = G__10945__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10945;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__10951 = null;
    var G__10951__0 = function() {
      var G__10928 = function() {
        var G__10929 = function() {
          return h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10929) : g.call(null, G__10929);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10928) : f.call(null, G__10928);
    };
    var G__10951__1 = function(x) {
      var G__10930 = function() {
        var G__10931 = function() {
          var G__10932 = x;
          return h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__10932) : h.call(null, G__10932);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10931) : g.call(null, G__10931);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10930) : f.call(null, G__10930);
    };
    var G__10951__2 = function(x, y) {
      var G__10933 = function() {
        var G__10934 = function() {
          var G__10935 = x;
          var G__10936 = y;
          return h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__10935, G__10936) : h.call(null, G__10935, G__10936);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10934) : g.call(null, G__10934);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10933) : f.call(null, G__10933);
    };
    var G__10951__3 = function(x, y, z) {
      var G__10937 = function() {
        var G__10938 = function() {
          var G__10939 = x;
          var G__10940 = y;
          var G__10941 = z;
          return h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__10939, G__10940, G__10941) : h.call(null, G__10939, G__10940, G__10941);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10938) : g.call(null, G__10938);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10937) : f.call(null, G__10937);
    };
    var G__10951__4 = function() {
      var G__10952__delegate = function(x, y, z, args) {
        var G__10942 = function() {
          var G__10943 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10943) : g.call(null, G__10943);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10942) : f.call(null, G__10942);
      };
      var G__10952 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10953__i = 0, G__10953__a = new Array(arguments.length - 3);
          while (G__10953__i < G__10953__a.length) {
            G__10953__a[G__10953__i] = arguments[G__10953__i + 3];
            ++G__10953__i;
          }
          args = new cljs.core.IndexedSeq(G__10953__a, 0);
        }
        return G__10952__delegate.call(this, x, y, z, args);
      };
      G__10952.cljs$lang$maxFixedArity = 3;
      G__10952.cljs$lang$applyTo = function(arglist__10954) {
        var x = cljs.core.first(arglist__10954);
        arglist__10954 = cljs.core.next(arglist__10954);
        var y = cljs.core.first(arglist__10954);
        arglist__10954 = cljs.core.next(arglist__10954);
        var z = cljs.core.first(arglist__10954);
        var args = cljs.core.rest(arglist__10954);
        return G__10952__delegate(x, y, z, args);
      };
      G__10952.cljs$core$IFn$_invoke$arity$variadic = G__10952__delegate;
      return G__10952;
    }();
    G__10951 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10951__0.call(this);
        case 1:
          return G__10951__1.call(this, x);
        case 2:
          return G__10951__2.call(this, x, y);
        case 3:
          return G__10951__3.call(this, x, y, z);
        default:
          var G__10955 = null;
          if (arguments.length > 3) {
            var G__10956__i = 0, G__10956__a = new Array(arguments.length - 3);
            while (G__10956__i < G__10956__a.length) {
              G__10956__a[G__10956__i] = arguments[G__10956__i + 3];
              ++G__10956__i;
            }
            G__10955 = new cljs.core.IndexedSeq(G__10956__a, 0);
          }
          return G__10951__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10955);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10951.cljs$lang$maxFixedArity = 3;
    G__10951.cljs$lang$applyTo = G__10951__4.cljs$lang$applyTo;
    G__10951.cljs$core$IFn$_invoke$arity$0 = G__10951__0;
    G__10951.cljs$core$IFn$_invoke$arity$1 = G__10951__1;
    G__10951.cljs$core$IFn$_invoke$arity$2 = G__10951__2;
    G__10951.cljs$core$IFn$_invoke$arity$3 = G__10951__3;
    G__10951.cljs$core$IFn$_invoke$arity$variadic = G__10951__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10951;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__10957__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__10958 = cljs.core.first(fs__$2).call(null, ret);
            var G__10959 = cljs.core.next(fs__$2);
            ret = G__10958;
            fs__$2 = G__10959;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__10957 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__10960__i = 0, G__10960__a = new Array(arguments.length - 0);
          while (G__10960__i < G__10960__a.length) {
            G__10960__a[G__10960__i] = arguments[G__10960__i + 0];
            ++G__10960__i;
          }
          args = new cljs.core.IndexedSeq(G__10960__a, 0);
        }
        return G__10957__delegate.call(this, args);
      };
      G__10957.cljs$lang$maxFixedArity = 0;
      G__10957.cljs$lang$applyTo = function(arglist__10961) {
        var args = cljs.core.seq(arglist__10961);
        return G__10957__delegate(args);
      };
      G__10957.cljs$core$IFn$_invoke$arity$variadic = G__10957__delegate;
      return G__10957;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq10911) {
  var G__10912 = cljs.core.first(seq10911);
  var seq10911__$1 = cljs.core.next(seq10911);
  var G__10913 = cljs.core.first(seq10911__$1);
  var seq10911__$2 = cljs.core.next(seq10911__$1);
  var G__10914 = cljs.core.first(seq10911__$2);
  var seq10911__$3 = cljs.core.next(seq10911__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__10912, G__10913, G__10914, seq10911__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial() {
  var G__10968 = arguments.length;
  switch(G__10968) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__11012 = null;
    var G__11012__0 = function() {
      var G__10969 = arg1;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10969) : f.call(null, G__10969);
    };
    var G__11012__1 = function(x) {
      var G__10970 = arg1;
      var G__10971 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10970, G__10971) : f.call(null, G__10970, G__10971);
    };
    var G__11012__2 = function(x, y) {
      var G__10972 = arg1;
      var G__10973 = x;
      var G__10974 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10972, G__10973, G__10974) : f.call(null, G__10972, G__10973, G__10974);
    };
    var G__11012__3 = function(x, y, z) {
      var G__10975 = arg1;
      var G__10976 = x;
      var G__10977 = y;
      var G__10978 = z;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10975, G__10976, G__10977, G__10978) : f.call(null, G__10975, G__10976, G__10977, G__10978);
    };
    var G__11012__4 = function() {
      var G__11013__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__11013 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11014__i = 0, G__11014__a = new Array(arguments.length - 3);
          while (G__11014__i < G__11014__a.length) {
            G__11014__a[G__11014__i] = arguments[G__11014__i + 3];
            ++G__11014__i;
          }
          args = new cljs.core.IndexedSeq(G__11014__a, 0);
        }
        return G__11013__delegate.call(this, x, y, z, args);
      };
      G__11013.cljs$lang$maxFixedArity = 3;
      G__11013.cljs$lang$applyTo = function(arglist__11015) {
        var x = cljs.core.first(arglist__11015);
        arglist__11015 = cljs.core.next(arglist__11015);
        var y = cljs.core.first(arglist__11015);
        arglist__11015 = cljs.core.next(arglist__11015);
        var z = cljs.core.first(arglist__11015);
        var args = cljs.core.rest(arglist__11015);
        return G__11013__delegate(x, y, z, args);
      };
      G__11013.cljs$core$IFn$_invoke$arity$variadic = G__11013__delegate;
      return G__11013;
    }();
    G__11012 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__11012__0.call(this);
        case 1:
          return G__11012__1.call(this, x);
        case 2:
          return G__11012__2.call(this, x, y);
        case 3:
          return G__11012__3.call(this, x, y, z);
        default:
          var G__11016 = null;
          if (arguments.length > 3) {
            var G__11017__i = 0, G__11017__a = new Array(arguments.length - 3);
            while (G__11017__i < G__11017__a.length) {
              G__11017__a[G__11017__i] = arguments[G__11017__i + 3];
              ++G__11017__i;
            }
            G__11016 = new cljs.core.IndexedSeq(G__11017__a, 0);
          }
          return G__11012__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11016);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11012.cljs$lang$maxFixedArity = 3;
    G__11012.cljs$lang$applyTo = G__11012__4.cljs$lang$applyTo;
    G__11012.cljs$core$IFn$_invoke$arity$0 = G__11012__0;
    G__11012.cljs$core$IFn$_invoke$arity$1 = G__11012__1;
    G__11012.cljs$core$IFn$_invoke$arity$2 = G__11012__2;
    G__11012.cljs$core$IFn$_invoke$arity$3 = G__11012__3;
    G__11012.cljs$core$IFn$_invoke$arity$variadic = G__11012__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11012;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__11018 = null;
    var G__11018__0 = function() {
      var G__10979 = arg1;
      var G__10980 = arg2;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10979, G__10980) : f.call(null, G__10979, G__10980);
    };
    var G__11018__1 = function(x) {
      var G__10981 = arg1;
      var G__10982 = arg2;
      var G__10983 = x;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10981, G__10982, G__10983) : f.call(null, G__10981, G__10982, G__10983);
    };
    var G__11018__2 = function(x, y) {
      var G__10984 = arg1;
      var G__10985 = arg2;
      var G__10986 = x;
      var G__10987 = y;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10984, G__10985, G__10986, G__10987) : f.call(null, G__10984, G__10985, G__10986, G__10987);
    };
    var G__11018__3 = function(x, y, z) {
      var G__10988 = arg1;
      var G__10989 = arg2;
      var G__10990 = x;
      var G__10991 = y;
      var G__10992 = z;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__10988, G__10989, G__10990, G__10991, G__10992) : f.call(null, G__10988, G__10989, G__10990, G__10991, G__10992);
    };
    var G__11018__4 = function() {
      var G__11019__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__11019 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11020__i = 0, G__11020__a = new Array(arguments.length - 3);
          while (G__11020__i < G__11020__a.length) {
            G__11020__a[G__11020__i] = arguments[G__11020__i + 3];
            ++G__11020__i;
          }
          args = new cljs.core.IndexedSeq(G__11020__a, 0);
        }
        return G__11019__delegate.call(this, x, y, z, args);
      };
      G__11019.cljs$lang$maxFixedArity = 3;
      G__11019.cljs$lang$applyTo = function(arglist__11021) {
        var x = cljs.core.first(arglist__11021);
        arglist__11021 = cljs.core.next(arglist__11021);
        var y = cljs.core.first(arglist__11021);
        arglist__11021 = cljs.core.next(arglist__11021);
        var z = cljs.core.first(arglist__11021);
        var args = cljs.core.rest(arglist__11021);
        return G__11019__delegate(x, y, z, args);
      };
      G__11019.cljs$core$IFn$_invoke$arity$variadic = G__11019__delegate;
      return G__11019;
    }();
    G__11018 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__11018__0.call(this);
        case 1:
          return G__11018__1.call(this, x);
        case 2:
          return G__11018__2.call(this, x, y);
        case 3:
          return G__11018__3.call(this, x, y, z);
        default:
          var G__11022 = null;
          if (arguments.length > 3) {
            var G__11023__i = 0, G__11023__a = new Array(arguments.length - 3);
            while (G__11023__i < G__11023__a.length) {
              G__11023__a[G__11023__i] = arguments[G__11023__i + 3];
              ++G__11023__i;
            }
            G__11022 = new cljs.core.IndexedSeq(G__11023__a, 0);
          }
          return G__11018__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11022);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11018.cljs$lang$maxFixedArity = 3;
    G__11018.cljs$lang$applyTo = G__11018__4.cljs$lang$applyTo;
    G__11018.cljs$core$IFn$_invoke$arity$0 = G__11018__0;
    G__11018.cljs$core$IFn$_invoke$arity$1 = G__11018__1;
    G__11018.cljs$core$IFn$_invoke$arity$2 = G__11018__2;
    G__11018.cljs$core$IFn$_invoke$arity$3 = G__11018__3;
    G__11018.cljs$core$IFn$_invoke$arity$variadic = G__11018__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11018;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__11024 = null;
    var G__11024__0 = function() {
      var G__10993 = arg1;
      var G__10994 = arg2;
      var G__10995 = arg3;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10993, G__10994, G__10995) : f.call(null, G__10993, G__10994, G__10995);
    };
    var G__11024__1 = function(x) {
      var G__10996 = arg1;
      var G__10997 = arg2;
      var G__10998 = arg3;
      var G__10999 = x;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10996, G__10997, G__10998, G__10999) : f.call(null, G__10996, G__10997, G__10998, G__10999);
    };
    var G__11024__2 = function(x, y) {
      var G__11000 = arg1;
      var G__11001 = arg2;
      var G__11002 = arg3;
      var G__11003 = x;
      var G__11004 = y;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__11000, G__11001, G__11002, G__11003, G__11004) : f.call(null, G__11000, G__11001, G__11002, G__11003, G__11004);
    };
    var G__11024__3 = function(x, y, z) {
      var G__11005 = arg1;
      var G__11006 = arg2;
      var G__11007 = arg3;
      var G__11008 = x;
      var G__11009 = y;
      var G__11010 = z;
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__11005, G__11006, G__11007, G__11008, G__11009, G__11010) : f.call(null, G__11005, G__11006, G__11007, G__11008, G__11009, G__11010);
    };
    var G__11024__4 = function() {
      var G__11025__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__11025 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11026__i = 0, G__11026__a = new Array(arguments.length - 3);
          while (G__11026__i < G__11026__a.length) {
            G__11026__a[G__11026__i] = arguments[G__11026__i + 3];
            ++G__11026__i;
          }
          args = new cljs.core.IndexedSeq(G__11026__a, 0);
        }
        return G__11025__delegate.call(this, x, y, z, args);
      };
      G__11025.cljs$lang$maxFixedArity = 3;
      G__11025.cljs$lang$applyTo = function(arglist__11027) {
        var x = cljs.core.first(arglist__11027);
        arglist__11027 = cljs.core.next(arglist__11027);
        var y = cljs.core.first(arglist__11027);
        arglist__11027 = cljs.core.next(arglist__11027);
        var z = cljs.core.first(arglist__11027);
        var args = cljs.core.rest(arglist__11027);
        return G__11025__delegate(x, y, z, args);
      };
      G__11025.cljs$core$IFn$_invoke$arity$variadic = G__11025__delegate;
      return G__11025;
    }();
    G__11024 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__11024__0.call(this);
        case 1:
          return G__11024__1.call(this, x);
        case 2:
          return G__11024__2.call(this, x, y);
        case 3:
          return G__11024__3.call(this, x, y, z);
        default:
          var G__11028 = null;
          if (arguments.length > 3) {
            var G__11029__i = 0, G__11029__a = new Array(arguments.length - 3);
            while (G__11029__i < G__11029__a.length) {
              G__11029__a[G__11029__i] = arguments[G__11029__i + 3];
              ++G__11029__i;
            }
            G__11028 = new cljs.core.IndexedSeq(G__11029__a, 0);
          }
          return G__11024__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11028);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11024.cljs$lang$maxFixedArity = 3;
    G__11024.cljs$lang$applyTo = G__11024__4.cljs$lang$applyTo;
    G__11024.cljs$core$IFn$_invoke$arity$0 = G__11024__0;
    G__11024.cljs$core$IFn$_invoke$arity$1 = G__11024__1;
    G__11024.cljs$core$IFn$_invoke$arity$2 = G__11024__2;
    G__11024.cljs$core$IFn$_invoke$arity$3 = G__11024__3;
    G__11024.cljs$core$IFn$_invoke$arity$variadic = G__11024__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11024;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__11030__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__11030 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__11031__i = 0, G__11031__a = new Array(arguments.length - 0);
        while (G__11031__i < G__11031__a.length) {
          G__11031__a[G__11031__i] = arguments[G__11031__i + 0];
          ++G__11031__i;
        }
        args = new cljs.core.IndexedSeq(G__11031__a, 0);
      }
      return G__11030__delegate.call(this, args);
    };
    G__11030.cljs$lang$maxFixedArity = 0;
    G__11030.cljs$lang$applyTo = function(arglist__11032) {
      var args = cljs.core.seq(arglist__11032);
      return G__11030__delegate(args);
    };
    G__11030.cljs$core$IFn$_invoke$arity$variadic = G__11030__delegate;
    return G__11030;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq10962) {
  var G__10963 = cljs.core.first(seq10962);
  var seq10962__$1 = cljs.core.next(seq10962);
  var G__10964 = cljs.core.first(seq10962__$1);
  var seq10962__$2 = cljs.core.next(seq10962__$1);
  var G__10965 = cljs.core.first(seq10962__$2);
  var seq10962__$3 = cljs.core.next(seq10962__$2);
  var G__10966 = cljs.core.first(seq10962__$3);
  var seq10962__$4 = cljs.core.next(seq10962__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__10963, G__10964, G__10965, G__10966, seq10962__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil() {
  var G__11034 = arguments.length;
  switch(G__11034) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__11052 = null;
    var G__11052__1 = function(a) {
      var G__11035 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11035) : f.call(null, G__11035);
    };
    var G__11052__2 = function(a, b) {
      var G__11036 = a == null ? x : a;
      var G__11037 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11036, G__11037) : f.call(null, G__11036, G__11037);
    };
    var G__11052__3 = function(a, b, c) {
      var G__11038 = a == null ? x : a;
      var G__11039 = b;
      var G__11040 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11038, G__11039, G__11040) : f.call(null, G__11038, G__11039, G__11040);
    };
    var G__11052__4 = function() {
      var G__11053__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__11053 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__11054__i = 0, G__11054__a = new Array(arguments.length - 3);
          while (G__11054__i < G__11054__a.length) {
            G__11054__a[G__11054__i] = arguments[G__11054__i + 3];
            ++G__11054__i;
          }
          ds = new cljs.core.IndexedSeq(G__11054__a, 0);
        }
        return G__11053__delegate.call(this, a, b, c, ds);
      };
      G__11053.cljs$lang$maxFixedArity = 3;
      G__11053.cljs$lang$applyTo = function(arglist__11055) {
        var a = cljs.core.first(arglist__11055);
        arglist__11055 = cljs.core.next(arglist__11055);
        var b = cljs.core.first(arglist__11055);
        arglist__11055 = cljs.core.next(arglist__11055);
        var c = cljs.core.first(arglist__11055);
        var ds = cljs.core.rest(arglist__11055);
        return G__11053__delegate(a, b, c, ds);
      };
      G__11053.cljs$core$IFn$_invoke$arity$variadic = G__11053__delegate;
      return G__11053;
    }();
    G__11052 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__11052__1.call(this, a);
        case 2:
          return G__11052__2.call(this, a, b);
        case 3:
          return G__11052__3.call(this, a, b, c);
        default:
          var G__11056 = null;
          if (arguments.length > 3) {
            var G__11057__i = 0, G__11057__a = new Array(arguments.length - 3);
            while (G__11057__i < G__11057__a.length) {
              G__11057__a[G__11057__i] = arguments[G__11057__i + 3];
              ++G__11057__i;
            }
            G__11056 = new cljs.core.IndexedSeq(G__11057__a, 0);
          }
          return G__11052__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__11056);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11052.cljs$lang$maxFixedArity = 3;
    G__11052.cljs$lang$applyTo = G__11052__4.cljs$lang$applyTo;
    G__11052.cljs$core$IFn$_invoke$arity$1 = G__11052__1;
    G__11052.cljs$core$IFn$_invoke$arity$2 = G__11052__2;
    G__11052.cljs$core$IFn$_invoke$arity$3 = G__11052__3;
    G__11052.cljs$core$IFn$_invoke$arity$variadic = G__11052__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11052;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__11058 = null;
    var G__11058__2 = function(a, b) {
      var G__11041 = a == null ? x : a;
      var G__11042 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11041, G__11042) : f.call(null, G__11041, G__11042);
    };
    var G__11058__3 = function(a, b, c) {
      var G__11043 = a == null ? x : a;
      var G__11044 = b == null ? y : b;
      var G__11045 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11043, G__11044, G__11045) : f.call(null, G__11043, G__11044, G__11045);
    };
    var G__11058__4 = function() {
      var G__11059__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__11059 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__11060__i = 0, G__11060__a = new Array(arguments.length - 3);
          while (G__11060__i < G__11060__a.length) {
            G__11060__a[G__11060__i] = arguments[G__11060__i + 3];
            ++G__11060__i;
          }
          ds = new cljs.core.IndexedSeq(G__11060__a, 0);
        }
        return G__11059__delegate.call(this, a, b, c, ds);
      };
      G__11059.cljs$lang$maxFixedArity = 3;
      G__11059.cljs$lang$applyTo = function(arglist__11061) {
        var a = cljs.core.first(arglist__11061);
        arglist__11061 = cljs.core.next(arglist__11061);
        var b = cljs.core.first(arglist__11061);
        arglist__11061 = cljs.core.next(arglist__11061);
        var c = cljs.core.first(arglist__11061);
        var ds = cljs.core.rest(arglist__11061);
        return G__11059__delegate(a, b, c, ds);
      };
      G__11059.cljs$core$IFn$_invoke$arity$variadic = G__11059__delegate;
      return G__11059;
    }();
    G__11058 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__11058__2.call(this, a, b);
        case 3:
          return G__11058__3.call(this, a, b, c);
        default:
          var G__11062 = null;
          if (arguments.length > 3) {
            var G__11063__i = 0, G__11063__a = new Array(arguments.length - 3);
            while (G__11063__i < G__11063__a.length) {
              G__11063__a[G__11063__i] = arguments[G__11063__i + 3];
              ++G__11063__i;
            }
            G__11062 = new cljs.core.IndexedSeq(G__11063__a, 0);
          }
          return G__11058__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__11062);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11058.cljs$lang$maxFixedArity = 3;
    G__11058.cljs$lang$applyTo = G__11058__4.cljs$lang$applyTo;
    G__11058.cljs$core$IFn$_invoke$arity$2 = G__11058__2;
    G__11058.cljs$core$IFn$_invoke$arity$3 = G__11058__3;
    G__11058.cljs$core$IFn$_invoke$arity$variadic = G__11058__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11058;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__11064 = null;
    var G__11064__2 = function(a, b) {
      var G__11046 = a == null ? x : a;
      var G__11047 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11046, G__11047) : f.call(null, G__11046, G__11047);
    };
    var G__11064__3 = function(a, b, c) {
      var G__11048 = a == null ? x : a;
      var G__11049 = b == null ? y : b;
      var G__11050 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11048, G__11049, G__11050) : f.call(null, G__11048, G__11049, G__11050);
    };
    var G__11064__4 = function() {
      var G__11065__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__11065 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__11066__i = 0, G__11066__a = new Array(arguments.length - 3);
          while (G__11066__i < G__11066__a.length) {
            G__11066__a[G__11066__i] = arguments[G__11066__i + 3];
            ++G__11066__i;
          }
          ds = new cljs.core.IndexedSeq(G__11066__a, 0);
        }
        return G__11065__delegate.call(this, a, b, c, ds);
      };
      G__11065.cljs$lang$maxFixedArity = 3;
      G__11065.cljs$lang$applyTo = function(arglist__11067) {
        var a = cljs.core.first(arglist__11067);
        arglist__11067 = cljs.core.next(arglist__11067);
        var b = cljs.core.first(arglist__11067);
        arglist__11067 = cljs.core.next(arglist__11067);
        var c = cljs.core.first(arglist__11067);
        var ds = cljs.core.rest(arglist__11067);
        return G__11065__delegate(a, b, c, ds);
      };
      G__11065.cljs$core$IFn$_invoke$arity$variadic = G__11065__delegate;
      return G__11065;
    }();
    G__11064 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__11064__2.call(this, a, b);
        case 3:
          return G__11064__3.call(this, a, b, c);
        default:
          var G__11068 = null;
          if (arguments.length > 3) {
            var G__11069__i = 0, G__11069__a = new Array(arguments.length - 3);
            while (G__11069__i < G__11069__a.length) {
              G__11069__a[G__11069__i] = arguments[G__11069__i + 3];
              ++G__11069__i;
            }
            G__11068 = new cljs.core.IndexedSeq(G__11069__a, 0);
          }
          return G__11064__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__11068);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__11064.cljs$lang$maxFixedArity = 3;
    G__11064.cljs$lang$applyTo = G__11064__4.cljs$lang$applyTo;
    G__11064.cljs$core$IFn$_invoke$arity$2 = G__11064__2;
    G__11064.cljs$core$IFn$_invoke$arity$3 = G__11064__3;
    G__11064.cljs$core$IFn$_invoke$arity$variadic = G__11064__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__11064;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed() {
  var G__11071 = arguments.length;
  switch(G__11071) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = function() {
      var G__11072 = -1;
      return cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__11072) : cljs.core.volatile_BANG_.call(null, G__11072);
    }();
    return function(i) {
      return function() {
        var G__11103 = null;
        var G__11103__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11103__1 = function(result) {
          var G__11073 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11073) : rf.call(null, G__11073);
        };
        var G__11103__2 = function(result, input) {
          var G__11074 = result;
          var G__11075 = function() {
            var G__11076 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__11077 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11076, G__11077) : f.call(null, G__11076, G__11077);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11074, G__11075) : rf.call(null, G__11074, G__11075);
        };
        G__11103 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11103__0.call(this);
            case 1:
              return G__11103__1.call(this, result);
            case 2:
              return G__11103__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11103.cljs$core$IFn$_invoke$arity$0 = G__11103__0;
        G__11103.cljs$core$IFn$_invoke$arity$1 = G__11103__1;
        G__11103.cljs$core$IFn$_invoke$arity$2 = G__11103__2;
        return G__11103;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___11104 = size;
          var i_11105 = 0;
          while (true) {
            if (i_11105 < n__5194__auto___11104) {
              cljs.core.chunk_append(b, function() {
                var G__11098 = idx + i_11105;
                var G__11099 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11105);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11098, G__11099) : f.call(null, G__11098, G__11099);
              }());
              var G__11106 = i_11105 + 1;
              i_11105 = G__11106;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__11100 = idx;
            var G__11101 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11100, G__11101) : f.call(null, G__11100, G__11101);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep() {
  var G__11108 = arguments.length;
  switch(G__11108) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__11116 = null;
      var G__11116__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__11116__1 = function(result) {
        var G__11109 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11109) : rf.call(null, G__11109);
      };
      var G__11116__2 = function(result, input) {
        var v = function() {
          var G__11110 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11110) : f.call(null, G__11110);
        }();
        if (v == null) {
          return result;
        } else {
          var G__11111 = result;
          var G__11112 = v;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11111, G__11112) : rf.call(null, G__11111, G__11112);
        }
      };
      G__11116 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__11116__0.call(this);
          case 1:
            return G__11116__1.call(this, result);
          case 2:
            return G__11116__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__11116.cljs$core$IFn$_invoke$arity$0 = G__11116__0;
      G__11116.cljs$core$IFn$_invoke$arity$1 = G__11116__1;
      G__11116.cljs$core$IFn$_invoke$arity$2 = G__11116__2;
      return G__11116;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___11117 = size;
        var i_11118 = 0;
        while (true) {
          if (i_11118 < n__5194__auto___11117) {
            var x_11119 = function() {
              var G__11113 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11118);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11113) : f.call(null, G__11113);
            }();
            if (x_11119 == null) {
            } else {
              cljs.core.chunk_append(b, x_11119);
            }
            var G__11120 = i_11118 + 1;
            i_11118 = G__11120;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__11114 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11114) : f.call(null, G__11114);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__11121 = cljs.core.seq(self__.watches);
  var chunk__11122 = null;
  var count__11123 = 0;
  var i__11124 = 0;
  while (true) {
    if (i__11124 < count__11123) {
      var vec__11125 = chunk__11122.cljs$core$IIndexed$_nth$arity$2(null, i__11124);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11125, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11125, 1, null);
      var G__11126_11136 = key;
      var G__11127_11137 = this$__$1;
      var G__11128_11138 = oldval;
      var G__11129_11139 = newval;
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11126_11136, G__11127_11137, G__11128_11138, G__11129_11139) : f.call(null, G__11126_11136, G__11127_11137, G__11128_11138, G__11129_11139);
      var G__11140 = seq__11121;
      var G__11141 = chunk__11122;
      var G__11142 = count__11123;
      var G__11143 = i__11124 + 1;
      seq__11121 = G__11140;
      chunk__11122 = G__11141;
      count__11123 = G__11142;
      i__11124 = G__11143;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__11121);
      if (temp__4425__auto__) {
        var seq__11121__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__11121__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__11121__$1);
          var G__11144 = cljs.core.chunk_rest(seq__11121__$1);
          var G__11145 = c__5094__auto__;
          var G__11146 = cljs.core.count(c__5094__auto__);
          var G__11147 = 0;
          seq__11121 = G__11144;
          chunk__11122 = G__11145;
          count__11123 = G__11146;
          i__11124 = G__11147;
          continue;
        } else {
          var vec__11130 = cljs.core.first(seq__11121__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11130, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11130, 1, null);
          var G__11131_11148 = key;
          var G__11132_11149 = this$__$1;
          var G__11133_11150 = oldval;
          var G__11134_11151 = newval;
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11131_11148, G__11132_11149, G__11133_11150, G__11134_11151) : f.call(null, G__11131_11148, G__11132_11149, G__11133_11150, G__11134_11151);
          var G__11152 = cljs.core.next(seq__11121__$1);
          var G__11153 = null;
          var G__11154 = 0;
          var G__11155 = 0;
          seq__11121 = G__11152;
          chunk__11122 = G__11153;
          count__11123 = G__11154;
          i__11124 = G__11155;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var G__11135 = this$__$1;
  return goog.getUid(G__11135);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom() {
  var G__11159 = arguments.length;
  switch(G__11159) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__11160) {
  var map__11161 = p__11160;
  var map__11161__$1 = cljs.core.seq_QMARK_(map__11161) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__11161) : map__11161;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11161__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11161__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq11156) {
  var G__11157 = cljs.core.first(seq11156);
  var seq11156__$1 = cljs.core.next(seq11156);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__11157, seq11156__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(function() {
        var G__11165 = new_value;
        return validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__11165) : validate.call(null, G__11165);
      }())) {
      } else {
        throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(function() {
          var G__11166 = cljs.core.list(new cljs.core.Symbol(null, "validate", "validate", 1439230700, null), new cljs.core.Symbol(null, "new-value", "new-value", -1567397401, null));
          return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__11166) : cljs.core.pr_str.call(null, G__11166);
        }())].join(""));
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_() {
  var G__11173 = arguments.length;
  switch(G__11173) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__11174 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11174) : f.call(null, G__11174);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__11175 = a.state;
      var G__11176 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11175, G__11176) : f.call(null, G__11175, G__11176);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__11177 = a.state;
      var G__11178 = x;
      var G__11179 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11177, G__11178, G__11179) : f.call(null, G__11177, G__11178, G__11179);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq11167) {
  var G__11168 = cljs.core.first(seq11167);
  var seq11167__$1 = cljs.core.next(seq11167);
  var G__11169 = cljs.core.first(seq11167__$1);
  var seq11167__$2 = cljs.core.next(seq11167__$1);
  var G__11170 = cljs.core.first(seq11167__$2);
  var seq11167__$3 = cljs.core.next(seq11167__$2);
  var G__11171 = cljs.core.first(seq11167__$3);
  var seq11167__$4 = cljs.core.next(seq11167__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11168, G__11169, G__11170, G__11171, seq11167__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null)], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed() {
  var G__11182 = arguments.length;
  switch(G__11182) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__11217 = null;
        var G__11217__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11217__1 = function(result) {
          var G__11183 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11183) : rf.call(null, G__11183);
        };
        var G__11217__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = function() {
            var G__11184 = i;
            var G__11185 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11184, G__11185) : f.call(null, G__11184, G__11185);
          }();
          if (v == null) {
            return result;
          } else {
            var G__11186 = result;
            var G__11187 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11186, G__11187) : rf.call(null, G__11186, G__11187);
          }
        };
        G__11217 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11217__0.call(this);
            case 1:
              return G__11217__1.call(this, result);
            case 2:
              return G__11217__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11217.cljs$core$IFn$_invoke$arity$0 = G__11217__0;
        G__11217.cljs$core$IFn$_invoke$arity$1 = G__11217__1;
        G__11217.cljs$core$IFn$_invoke$arity$2 = G__11217__2;
        return G__11217;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5194__auto___11218 = size;
          var i_11219 = 0;
          while (true) {
            if (i_11219 < n__5194__auto___11218) {
              var x_11220 = function() {
                var G__11212 = idx + i_11219;
                var G__11213 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11219);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11212, G__11213) : f.call(null, G__11212, G__11213);
              }();
              if (x_11220 == null) {
              } else {
                cljs.core.chunk_append(b, x_11220);
              }
              var G__11221 = i_11219 + 1;
              i_11219 = G__11221;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__11214 = idx;
            var G__11215 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11214, G__11215) : f.call(null, G__11214, G__11215);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred() {
  var G__11233 = arguments.length;
  switch(G__11233) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(function() {
        var G__11249 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11249) : p.call(null, G__11249);
      }());
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11251 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11251) : p.call(null, G__11251);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__11252 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11252) : p.call(null, G__11252);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11254 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11254) : p.call(null, G__11254);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11256 = y;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11256) : p.call(null, G__11256);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__11257 = z;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11257) : p.call(null, G__11257);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__11419__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__11419 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11420__i = 0, G__11420__a = new Array(arguments.length - 3);
          while (G__11420__i < G__11420__a.length) {
            G__11420__a[G__11420__i] = arguments[G__11420__i + 3];
            ++G__11420__i;
          }
          args = new cljs.core.IndexedSeq(G__11420__a, 0);
        }
        return G__11419__delegate.call(this, x, y, z, args);
      };
      G__11419.cljs$lang$maxFixedArity = 3;
      G__11419.cljs$lang$applyTo = function(arglist__11421) {
        var x = cljs.core.first(arglist__11421);
        arglist__11421 = cljs.core.next(arglist__11421);
        var y = cljs.core.first(arglist__11421);
        arglist__11421 = cljs.core.next(arglist__11421);
        var z = cljs.core.first(arglist__11421);
        var args = cljs.core.rest(arglist__11421);
        return G__11419__delegate(x, y, z, args);
      };
      G__11419.cljs$core$IFn$_invoke$arity$variadic = G__11419__delegate;
      return G__11419;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__11422 = null;
          if (arguments.length > 3) {
            var G__11423__i = 0, G__11423__a = new Array(arguments.length - 3);
            while (G__11423__i < G__11423__a.length) {
              G__11423__a[G__11423__i] = arguments[G__11423__i + 3];
              ++G__11423__i;
            }
            G__11422 = new cljs.core.IndexedSeq(G__11423__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11422);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11289 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11289) : p1.call(null, G__11289);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var G__11290 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11290) : p2.call(null, G__11290);
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11292 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11292) : p1.call(null, G__11292);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11294 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11294) : p1.call(null, G__11294);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__11296 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11296) : p2.call(null, G__11296);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var G__11297 = y;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11297) : p2.call(null, G__11297);
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11299 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11299) : p1.call(null, G__11299);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11301 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11301) : p1.call(null, G__11301);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__11303 = z;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11303) : p1.call(null, G__11303);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__11305 = x;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11305) : p2.call(null, G__11305);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__11307 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11307) : p2.call(null, G__11307);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__11308 = z;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11308) : p2.call(null, G__11308);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__11424__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__11222_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__11310 = p1__11222_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11310) : p1.call(null, G__11310);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var G__11311 = p1__11222_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11311) : p2.call(null, G__11311);
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__11424 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11425__i = 0, G__11425__a = new Array(arguments.length - 3);
          while (G__11425__i < G__11425__a.length) {
            G__11425__a[G__11425__i] = arguments[G__11425__i + 3];
            ++G__11425__i;
          }
          args = new cljs.core.IndexedSeq(G__11425__a, 0);
        }
        return G__11424__delegate.call(this, x, y, z, args);
      };
      G__11424.cljs$lang$maxFixedArity = 3;
      G__11424.cljs$lang$applyTo = function(arglist__11426) {
        var x = cljs.core.first(arglist__11426);
        arglist__11426 = cljs.core.next(arglist__11426);
        var y = cljs.core.first(arglist__11426);
        arglist__11426 = cljs.core.next(arglist__11426);
        var z = cljs.core.first(arglist__11426);
        var args = cljs.core.rest(arglist__11426);
        return G__11424__delegate(x, y, z, args);
      };
      G__11424.cljs$core$IFn$_invoke$arity$variadic = G__11424__delegate;
      return G__11424;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__11427 = null;
          if (arguments.length > 3) {
            var G__11428__i = 0, G__11428__a = new Array(arguments.length - 3);
            while (G__11428__i < G__11428__a.length) {
              G__11428__a[G__11428__i] = arguments[G__11428__i + 3];
              ++G__11428__i;
            }
            G__11427 = new cljs.core.IndexedSeq(G__11428__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11427);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11357 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11357) : p1.call(null, G__11357);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11359 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11359) : p2.call(null, G__11359);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var G__11360 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11360) : p3.call(null, G__11360);
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11362 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11362) : p1.call(null, G__11362);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11364 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11364) : p2.call(null, G__11364);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__11366 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11366) : p3.call(null, G__11366);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__11368 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11368) : p1.call(null, G__11368);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__11370 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11370) : p2.call(null, G__11370);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var G__11371 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11371) : p3.call(null, G__11371);
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4297__auto__ = function() {
          var G__11373 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11373) : p1.call(null, G__11373);
        }();
        if (cljs.core.truth_(and__4297__auto__)) {
          var and__4297__auto____$1 = function() {
            var G__11375 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11375) : p2.call(null, G__11375);
          }();
          if (cljs.core.truth_(and__4297__auto____$1)) {
            var and__4297__auto____$2 = function() {
              var G__11377 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11377) : p3.call(null, G__11377);
            }();
            if (cljs.core.truth_(and__4297__auto____$2)) {
              var and__4297__auto____$3 = function() {
                var G__11379 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11379) : p1.call(null, G__11379);
              }();
              if (cljs.core.truth_(and__4297__auto____$3)) {
                var and__4297__auto____$4 = function() {
                  var G__11381 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11381) : p2.call(null, G__11381);
                }();
                if (cljs.core.truth_(and__4297__auto____$4)) {
                  var and__4297__auto____$5 = function() {
                    var G__11383 = y;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11383) : p3.call(null, G__11383);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$5)) {
                    var and__4297__auto____$6 = function() {
                      var G__11385 = z;
                      return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11385) : p1.call(null, G__11385);
                    }();
                    if (cljs.core.truth_(and__4297__auto____$6)) {
                      var and__4297__auto____$7 = function() {
                        var G__11387 = z;
                        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11387) : p2.call(null, G__11387);
                      }();
                      if (cljs.core.truth_(and__4297__auto____$7)) {
                        var G__11388 = z;
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11388) : p3.call(null, G__11388);
                      } else {
                        return and__4297__auto____$7;
                      }
                    } else {
                      return and__4297__auto____$6;
                    }
                  } else {
                    return and__4297__auto____$5;
                  }
                } else {
                  return and__4297__auto____$4;
                }
              } else {
                return and__4297__auto____$3;
              }
            } else {
              return and__4297__auto____$2;
            }
          } else {
            return and__4297__auto____$1;
          }
        } else {
          return and__4297__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__11429__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4297__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4297__auto__)) {
            return cljs.core.every_QMARK_(function(and__4297__auto__) {
              return function(p1__11223_SHARP_) {
                var and__4297__auto____$1 = function() {
                  var G__11390 = p1__11223_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11390) : p1.call(null, G__11390);
                }();
                if (cljs.core.truth_(and__4297__auto____$1)) {
                  var and__4297__auto____$2 = function() {
                    var G__11392 = p1__11223_SHARP_;
                    return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11392) : p2.call(null, G__11392);
                  }();
                  if (cljs.core.truth_(and__4297__auto____$2)) {
                    var G__11393 = p1__11223_SHARP_;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11393) : p3.call(null, G__11393);
                  } else {
                    return and__4297__auto____$2;
                  }
                } else {
                  return and__4297__auto____$1;
                }
              };
            }(and__4297__auto__), args);
          } else {
            return and__4297__auto__;
          }
        }());
      };
      var G__11429 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11430__i = 0, G__11430__a = new Array(arguments.length - 3);
          while (G__11430__i < G__11430__a.length) {
            G__11430__a[G__11430__i] = arguments[G__11430__i + 3];
            ++G__11430__i;
          }
          args = new cljs.core.IndexedSeq(G__11430__a, 0);
        }
        return G__11429__delegate.call(this, x, y, z, args);
      };
      G__11429.cljs$lang$maxFixedArity = 3;
      G__11429.cljs$lang$applyTo = function(arglist__11431) {
        var x = cljs.core.first(arglist__11431);
        arglist__11431 = cljs.core.next(arglist__11431);
        var y = cljs.core.first(arglist__11431);
        arglist__11431 = cljs.core.next(arglist__11431);
        var z = cljs.core.first(arglist__11431);
        var args = cljs.core.rest(arglist__11431);
        return G__11429__delegate(x, y, z, args);
      };
      G__11429.cljs$core$IFn$_invoke$arity$variadic = G__11429__delegate;
      return G__11429;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__11432 = null;
          if (arguments.length > 3) {
            var G__11433__i = 0, G__11433__a = new Array(arguments.length - 3);
            while (G__11433__i < G__11433__a.length) {
              G__11433__a[G__11433__i] = arguments[G__11433__i + 3];
              ++G__11433__i;
            }
            G__11432 = new cljs.core.IndexedSeq(G__11433__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11432);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__11224_SHARP_) {
            var G__11409 = x;
            return p1__11224_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11224_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11409) : p1__11224_SHARP_.call(null, G__11409);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__11225_SHARP_) {
            var and__4297__auto__ = function() {
              var G__11411 = x;
              return p1__11225_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11225_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11411) : p1__11225_SHARP_.call(null, G__11411);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__11412 = y;
              return p1__11225_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11225_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11412) : p1__11225_SHARP_.call(null, G__11412);
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__11226_SHARP_) {
            var and__4297__auto__ = function() {
              var G__11414 = x;
              return p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11414) : p1__11226_SHARP_.call(null, G__11414);
            }();
            if (cljs.core.truth_(and__4297__auto__)) {
              var and__4297__auto____$1 = function() {
                var G__11416 = y;
                return p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11416) : p1__11226_SHARP_.call(null, G__11416);
              }();
              if (cljs.core.truth_(and__4297__auto____$1)) {
                var G__11417 = z;
                return p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11226_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11417) : p1__11226_SHARP_.call(null, G__11417);
              } else {
                return and__4297__auto____$1;
              }
            } else {
              return and__4297__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__11434__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__4297__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__4297__auto__)) {
              return cljs.core.every_QMARK_(function(and__4297__auto__, ps__$1) {
                return function(p1__11227_SHARP_) {
                  return cljs.core.every_QMARK_(p1__11227_SHARP_, args);
                };
              }(and__4297__auto__, ps__$1), ps__$1);
            } else {
              return and__4297__auto__;
            }
          }());
        };
        var G__11434 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__11435__i = 0, G__11435__a = new Array(arguments.length - 3);
            while (G__11435__i < G__11435__a.length) {
              G__11435__a[G__11435__i] = arguments[G__11435__i + 3];
              ++G__11435__i;
            }
            args = new cljs.core.IndexedSeq(G__11435__a, 0);
          }
          return G__11434__delegate.call(this, x, y, z, args);
        };
        G__11434.cljs$lang$maxFixedArity = 3;
        G__11434.cljs$lang$applyTo = function(arglist__11436) {
          var x = cljs.core.first(arglist__11436);
          arglist__11436 = cljs.core.next(arglist__11436);
          var y = cljs.core.first(arglist__11436);
          arglist__11436 = cljs.core.next(arglist__11436);
          var z = cljs.core.first(arglist__11436);
          var args = cljs.core.rest(arglist__11436);
          return G__11434__delegate(x, y, z, args);
        };
        G__11434.cljs$core$IFn$_invoke$arity$variadic = G__11434__delegate;
        return G__11434;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__11437 = null;
            if (arguments.length > 3) {
              var G__11438__i = 0, G__11438__a = new Array(arguments.length - 3);
              while (G__11438__i < G__11438__a.length) {
                G__11438__a[G__11438__i] = arguments[G__11438__i + 3];
                ++G__11438__i;
              }
              G__11437 = new cljs.core.IndexedSeq(G__11438__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11437);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq11228) {
  var G__11229 = cljs.core.first(seq11228);
  var seq11228__$1 = cljs.core.next(seq11228);
  var G__11230 = cljs.core.first(seq11228__$1);
  var seq11228__$2 = cljs.core.next(seq11228__$1);
  var G__11231 = cljs.core.first(seq11228__$2);
  var seq11228__$3 = cljs.core.next(seq11228__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__11229, G__11230, G__11231, seq11228__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn() {
  var G__11450 = arguments.length;
  switch(G__11450) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      var G__11466 = x;
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11466) : p.call(null, G__11466);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__11468 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11468) : p.call(null, G__11468);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__11469 = y;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11469) : p.call(null, G__11469);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__11471 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11471) : p.call(null, G__11471);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11473 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11473) : p.call(null, G__11473);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__11474 = z;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__11474) : p.call(null, G__11474);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__11636__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__11636 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11637__i = 0, G__11637__a = new Array(arguments.length - 3);
          while (G__11637__i < G__11637__a.length) {
            G__11637__a[G__11637__i] = arguments[G__11637__i + 3];
            ++G__11637__i;
          }
          args = new cljs.core.IndexedSeq(G__11637__a, 0);
        }
        return G__11636__delegate.call(this, x, y, z, args);
      };
      G__11636.cljs$lang$maxFixedArity = 3;
      G__11636.cljs$lang$applyTo = function(arglist__11638) {
        var x = cljs.core.first(arglist__11638);
        arglist__11638 = cljs.core.next(arglist__11638);
        var y = cljs.core.first(arglist__11638);
        arglist__11638 = cljs.core.next(arglist__11638);
        var z = cljs.core.first(arglist__11638);
        var args = cljs.core.rest(arglist__11638);
        return G__11636__delegate(x, y, z, args);
      };
      G__11636.cljs$core$IFn$_invoke$arity$variadic = G__11636__delegate;
      return G__11636;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__11639 = null;
          if (arguments.length > 3) {
            var G__11640__i = 0, G__11640__a = new Array(arguments.length - 3);
            while (G__11640__i < G__11640__a.length) {
              G__11640__a[G__11640__i] = arguments[G__11640__i + 3];
              ++G__11640__i;
            }
            G__11639 = new cljs.core.IndexedSeq(G__11640__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11639);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__11506 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11506) : p1.call(null, G__11506);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var G__11507 = x;
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11507) : p2.call(null, G__11507);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__11509 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11509) : p1.call(null, G__11509);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11511 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11511) : p1.call(null, G__11511);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__11513 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11513) : p2.call(null, G__11513);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var G__11514 = y;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11514) : p2.call(null, G__11514);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__11516 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11516) : p1.call(null, G__11516);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11518 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11518) : p1.call(null, G__11518);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__11520 = z;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11520) : p1.call(null, G__11520);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__11522 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11522) : p2.call(null, G__11522);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__11524 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11524) : p2.call(null, G__11524);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__11525 = z;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11525) : p2.call(null, G__11525);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__11641__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__11439_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__11527 = p1__11439_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11527) : p1.call(null, G__11527);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__11528 = p1__11439_SHARP_;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11528) : p2.call(null, G__11528);
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__11641 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11642__i = 0, G__11642__a = new Array(arguments.length - 3);
          while (G__11642__i < G__11642__a.length) {
            G__11642__a[G__11642__i] = arguments[G__11642__i + 3];
            ++G__11642__i;
          }
          args = new cljs.core.IndexedSeq(G__11642__a, 0);
        }
        return G__11641__delegate.call(this, x, y, z, args);
      };
      G__11641.cljs$lang$maxFixedArity = 3;
      G__11641.cljs$lang$applyTo = function(arglist__11643) {
        var x = cljs.core.first(arglist__11643);
        arglist__11643 = cljs.core.next(arglist__11643);
        var y = cljs.core.first(arglist__11643);
        arglist__11643 = cljs.core.next(arglist__11643);
        var z = cljs.core.first(arglist__11643);
        var args = cljs.core.rest(arglist__11643);
        return G__11641__delegate(x, y, z, args);
      };
      G__11641.cljs$core$IFn$_invoke$arity$variadic = G__11641__delegate;
      return G__11641;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__11644 = null;
          if (arguments.length > 3) {
            var G__11645__i = 0, G__11645__a = new Array(arguments.length - 3);
            while (G__11645__i < G__11645__a.length) {
              G__11645__a[G__11645__i] = arguments[G__11645__i + 3];
              ++G__11645__i;
            }
            G__11644 = new cljs.core.IndexedSeq(G__11645__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11644);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__4309__auto__ = function() {
        var G__11574 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11574) : p1.call(null, G__11574);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11576 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11576) : p2.call(null, G__11576);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var G__11577 = x;
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11577) : p3.call(null, G__11577);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__4309__auto__ = function() {
        var G__11579 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11579) : p1.call(null, G__11579);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11581 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11581) : p2.call(null, G__11581);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__11583 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11583) : p3.call(null, G__11583);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__11585 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11585) : p1.call(null, G__11585);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__11587 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11587) : p2.call(null, G__11587);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var G__11588 = y;
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11588) : p3.call(null, G__11588);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__4309__auto__ = function() {
        var G__11590 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11590) : p1.call(null, G__11590);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        var or__4309__auto____$1 = function() {
          var G__11592 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11592) : p2.call(null, G__11592);
        }();
        if (cljs.core.truth_(or__4309__auto____$1)) {
          return or__4309__auto____$1;
        } else {
          var or__4309__auto____$2 = function() {
            var G__11594 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11594) : p3.call(null, G__11594);
          }();
          if (cljs.core.truth_(or__4309__auto____$2)) {
            return or__4309__auto____$2;
          } else {
            var or__4309__auto____$3 = function() {
              var G__11596 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11596) : p1.call(null, G__11596);
            }();
            if (cljs.core.truth_(or__4309__auto____$3)) {
              return or__4309__auto____$3;
            } else {
              var or__4309__auto____$4 = function() {
                var G__11598 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11598) : p2.call(null, G__11598);
              }();
              if (cljs.core.truth_(or__4309__auto____$4)) {
                return or__4309__auto____$4;
              } else {
                var or__4309__auto____$5 = function() {
                  var G__11600 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11600) : p3.call(null, G__11600);
                }();
                if (cljs.core.truth_(or__4309__auto____$5)) {
                  return or__4309__auto____$5;
                } else {
                  var or__4309__auto____$6 = function() {
                    var G__11602 = z;
                    return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11602) : p1.call(null, G__11602);
                  }();
                  if (cljs.core.truth_(or__4309__auto____$6)) {
                    return or__4309__auto____$6;
                  } else {
                    var or__4309__auto____$7 = function() {
                      var G__11604 = z;
                      return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11604) : p2.call(null, G__11604);
                    }();
                    if (cljs.core.truth_(or__4309__auto____$7)) {
                      return or__4309__auto____$7;
                    } else {
                      var G__11605 = z;
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11605) : p3.call(null, G__11605);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__11646__delegate = function(x, y, z, args) {
        var or__4309__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.some(function(or__4309__auto__) {
            return function(p1__11440_SHARP_) {
              var or__4309__auto____$1 = function() {
                var G__11607 = p1__11440_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__11607) : p1.call(null, G__11607);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var or__4309__auto____$2 = function() {
                  var G__11609 = p1__11440_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__11609) : p2.call(null, G__11609);
                }();
                if (cljs.core.truth_(or__4309__auto____$2)) {
                  return or__4309__auto____$2;
                } else {
                  var G__11610 = p1__11440_SHARP_;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__11610) : p3.call(null, G__11610);
                }
              }
            };
          }(or__4309__auto__), args);
        }
      };
      var G__11646 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__11647__i = 0, G__11647__a = new Array(arguments.length - 3);
          while (G__11647__i < G__11647__a.length) {
            G__11647__a[G__11647__i] = arguments[G__11647__i + 3];
            ++G__11647__i;
          }
          args = new cljs.core.IndexedSeq(G__11647__a, 0);
        }
        return G__11646__delegate.call(this, x, y, z, args);
      };
      G__11646.cljs$lang$maxFixedArity = 3;
      G__11646.cljs$lang$applyTo = function(arglist__11648) {
        var x = cljs.core.first(arglist__11648);
        arglist__11648 = cljs.core.next(arglist__11648);
        var y = cljs.core.first(arglist__11648);
        arglist__11648 = cljs.core.next(arglist__11648);
        var z = cljs.core.first(arglist__11648);
        var args = cljs.core.rest(arglist__11648);
        return G__11646__delegate(x, y, z, args);
      };
      G__11646.cljs$core$IFn$_invoke$arity$variadic = G__11646__delegate;
      return G__11646;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__11649 = null;
          if (arguments.length > 3) {
            var G__11650__i = 0, G__11650__a = new Array(arguments.length - 3);
            while (G__11650__i < G__11650__a.length) {
              G__11650__a[G__11650__i] = arguments[G__11650__i + 3];
              ++G__11650__i;
            }
            G__11649 = new cljs.core.IndexedSeq(G__11650__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11649);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__11441_SHARP_) {
            var G__11626 = x;
            return p1__11441_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11441_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11626) : p1__11441_SHARP_.call(null, G__11626);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__11442_SHARP_) {
            var or__4309__auto__ = function() {
              var G__11628 = x;
              return p1__11442_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11442_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11628) : p1__11442_SHARP_.call(null, G__11628);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var G__11629 = y;
              return p1__11442_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11442_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11629) : p1__11442_SHARP_.call(null, G__11629);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__11443_SHARP_) {
            var or__4309__auto__ = function() {
              var G__11631 = x;
              return p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11631) : p1__11443_SHARP_.call(null, G__11631);
            }();
            if (cljs.core.truth_(or__4309__auto__)) {
              return or__4309__auto__;
            } else {
              var or__4309__auto____$1 = function() {
                var G__11633 = y;
                return p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11633) : p1__11443_SHARP_.call(null, G__11633);
              }();
              if (cljs.core.truth_(or__4309__auto____$1)) {
                return or__4309__auto____$1;
              } else {
                var G__11634 = z;
                return p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11443_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11634) : p1__11443_SHARP_.call(null, G__11634);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__11651__delegate = function(x, y, z, args) {
          var or__4309__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.some(function(or__4309__auto__, ps__$1) {
              return function(p1__11444_SHARP_) {
                return cljs.core.some(p1__11444_SHARP_, args);
              };
            }(or__4309__auto__, ps__$1), ps__$1);
          }
        };
        var G__11651 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__11652__i = 0, G__11652__a = new Array(arguments.length - 3);
            while (G__11652__i < G__11652__a.length) {
              G__11652__a[G__11652__i] = arguments[G__11652__i + 3];
              ++G__11652__i;
            }
            args = new cljs.core.IndexedSeq(G__11652__a, 0);
          }
          return G__11651__delegate.call(this, x, y, z, args);
        };
        G__11651.cljs$lang$maxFixedArity = 3;
        G__11651.cljs$lang$applyTo = function(arglist__11653) {
          var x = cljs.core.first(arglist__11653);
          arglist__11653 = cljs.core.next(arglist__11653);
          var y = cljs.core.first(arglist__11653);
          arglist__11653 = cljs.core.next(arglist__11653);
          var z = cljs.core.first(arglist__11653);
          var args = cljs.core.rest(arglist__11653);
          return G__11651__delegate(x, y, z, args);
        };
        G__11651.cljs$core$IFn$_invoke$arity$variadic = G__11651__delegate;
        return G__11651;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__11654 = null;
            if (arguments.length > 3) {
              var G__11655__i = 0, G__11655__a = new Array(arguments.length - 3);
              while (G__11655__i < G__11655__a.length) {
                G__11655__a[G__11655__i] = arguments[G__11655__i + 3];
                ++G__11655__i;
              }
              G__11654 = new cljs.core.IndexedSeq(G__11655__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__11654);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq11445) {
  var G__11446 = cljs.core.first(seq11445);
  var seq11445__$1 = cljs.core.next(seq11445);
  var G__11447 = cljs.core.first(seq11445__$1);
  var seq11445__$2 = cljs.core.next(seq11445__$1);
  var G__11448 = cljs.core.first(seq11445__$2);
  var seq11445__$3 = cljs.core.next(seq11445__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__11446, G__11447, G__11448, seq11445__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map() {
  var G__11663 = arguments.length;
  switch(G__11663) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__11679 = null;
      var G__11679__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__11679__1 = function(result) {
        var G__11664 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11664) : rf.call(null, G__11664);
      };
      var G__11679__2 = function(result, input) {
        var G__11665 = result;
        var G__11666 = function() {
          var G__11667 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11667) : f.call(null, G__11667);
        }();
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11665, G__11666) : rf.call(null, G__11665, G__11666);
      };
      var G__11679__3 = function() {
        var G__11680__delegate = function(result, input, inputs) {
          var G__11668 = result;
          var G__11669 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11668, G__11669) : rf.call(null, G__11668, G__11669);
        };
        var G__11680 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__11681__i = 0, G__11681__a = new Array(arguments.length - 2);
            while (G__11681__i < G__11681__a.length) {
              G__11681__a[G__11681__i] = arguments[G__11681__i + 2];
              ++G__11681__i;
            }
            inputs = new cljs.core.IndexedSeq(G__11681__a, 0);
          }
          return G__11680__delegate.call(this, result, input, inputs);
        };
        G__11680.cljs$lang$maxFixedArity = 2;
        G__11680.cljs$lang$applyTo = function(arglist__11682) {
          var result = cljs.core.first(arglist__11682);
          arglist__11682 = cljs.core.next(arglist__11682);
          var input = cljs.core.first(arglist__11682);
          var inputs = cljs.core.rest(arglist__11682);
          return G__11680__delegate(result, input, inputs);
        };
        G__11680.cljs$core$IFn$_invoke$arity$variadic = G__11680__delegate;
        return G__11680;
      }();
      G__11679 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__11679__0.call(this);
          case 1:
            return G__11679__1.call(this, result);
          case 2:
            return G__11679__2.call(this, result, input);
          default:
            var G__11683 = null;
            if (arguments.length > 2) {
              var G__11684__i = 0, G__11684__a = new Array(arguments.length - 2);
              while (G__11684__i < G__11684__a.length) {
                G__11684__a[G__11684__i] = arguments[G__11684__i + 2];
                ++G__11684__i;
              }
              G__11683 = new cljs.core.IndexedSeq(G__11684__a, 0);
            }
            return G__11679__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__11683);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__11679.cljs$lang$maxFixedArity = 2;
      G__11679.cljs$lang$applyTo = G__11679__3.cljs$lang$applyTo;
      G__11679.cljs$core$IFn$_invoke$arity$0 = G__11679__0;
      G__11679.cljs$core$IFn$_invoke$arity$1 = G__11679__1;
      G__11679.cljs$core$IFn$_invoke$arity$2 = G__11679__2;
      G__11679.cljs$core$IFn$_invoke$arity$variadic = G__11679__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__11679;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___11685 = size;
        var i_11686 = 0;
        while (true) {
          if (i_11686 < n__5194__auto___11685) {
            cljs.core.chunk_append(b, function() {
              var G__11670 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11686);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11670) : f.call(null, G__11670);
            }());
            var G__11687 = i_11686 + 1;
            i_11686 = G__11687;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__11671 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11671) : f.call(null, G__11671);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__11672 = cljs.core.first(s1);
        var G__11673 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11672, G__11673) : f.call(null, G__11672, G__11673);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__11674 = cljs.core.first(s1);
        var G__11675 = cljs.core.first(s2);
        var G__11676 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11674, G__11675, G__11676) : f.call(null, G__11674, G__11675, G__11676);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__11656_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__11656_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq11657) {
  var G__11658 = cljs.core.first(seq11657);
  var seq11657__$1 = cljs.core.next(seq11657);
  var G__11659 = cljs.core.first(seq11657__$1);
  var seq11657__$2 = cljs.core.next(seq11657__$1);
  var G__11660 = cljs.core.first(seq11657__$2);
  var seq11657__$3 = cljs.core.next(seq11657__$2);
  var G__11661 = cljs.core.first(seq11657__$3);
  var seq11657__$4 = cljs.core.next(seq11657__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__11658, G__11659, G__11660, G__11661, seq11657__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take() {
  var G__11689 = arguments.length;
  switch(G__11689) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__11694 = null;
        var G__11694__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11694__1 = function(result) {
          var G__11690 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11690) : rf.call(null, G__11690);
        };
        var G__11694__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? function() {
            var G__11691 = result;
            var G__11692 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11691, G__11692) : rf.call(null, G__11691, G__11692);
          }() : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__11694 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11694__0.call(this);
            case 1:
              return G__11694__1.call(this, result);
            case 2:
              return G__11694__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11694.cljs$core$IFn$_invoke$arity$0 = G__11694__0;
        G__11694.cljs$core$IFn$_invoke$arity$1 = G__11694__1;
        G__11694.cljs$core$IFn$_invoke$arity$2 = G__11694__2;
        return G__11694;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4425__auto__ = cljs.core.seq(coll);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop() {
  var G__11696 = arguments.length;
  switch(G__11696) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__11701 = null;
        var G__11701__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11701__1 = function(result) {
          var G__11697 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11697) : rf.call(null, G__11697);
        };
        var G__11701__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            var G__11698 = result;
            var G__11699 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11698, G__11699) : rf.call(null, G__11698, G__11699);
          }
        };
        G__11701 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11701__0.call(this);
            case 1:
              return G__11701__1.call(this, result);
            case 2:
              return G__11701__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11701.cljs$core$IFn$_invoke$arity$0 = G__11701__0;
        G__11701.cljs$core$IFn$_invoke$arity$1 = G__11701__1;
        G__11701.cljs$core$IFn$_invoke$arity$2 = G__11701__2;
        return G__11701;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__11702 = n__$1 - 1;
        var G__11703 = cljs.core.rest(s);
        n__$1 = G__11702;
        coll__$1 = G__11703;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last() {
  var G__11705 = arguments.length;
  switch(G__11705) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__11707 = cljs.core.next(s);
      var G__11708 = cljs.core.next(lead);
      s = G__11707;
      lead = G__11708;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while() {
  var G__11710 = arguments.length;
  switch(G__11710) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__11718 = null;
        var G__11718__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11718__1 = function(result) {
          var G__11711 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11711) : rf.call(null, G__11711);
        };
        var G__11718__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__4297__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__4297__auto__)) {
              var G__11712 = input;
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11712) : pred.call(null, G__11712);
            } else {
              return and__4297__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            var G__11713 = result;
            var G__11714 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11713, G__11714) : rf.call(null, G__11713, G__11714);
          }
        };
        G__11718 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11718__0.call(this);
            case 1:
              return G__11718__1.call(this, result);
            case 2:
              return G__11718__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11718.cljs$core$IFn$_invoke$arity$0 = G__11718__0;
        G__11718.cljs$core$IFn$_invoke$arity$1 = G__11718__1;
        G__11718.cljs$core$IFn$_invoke$arity$2 = G__11718__2;
        return G__11718;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__4297__auto__ = s;
        if (and__4297__auto__) {
          var G__11716 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__11716) : pred__$1.call(null, G__11716);
        } else {
          return and__4297__auto__;
        }
      }())) {
        var G__11719 = pred__$1;
        var G__11720 = cljs.core.rest(s);
        pred__$1 = G__11719;
        coll__$1 = G__11720;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat() {
  var G__11723 = arguments.length;
  switch(G__11723) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly() {
  var G__11726 = arguments.length;
  switch(G__11726) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    }(), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, function() {
      var G__11731 = x;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11731) : f.call(null, G__11731);
    }());
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave() {
  var G__11736 = arguments.length;
  switch(G__11736) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5360__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq11732) {
  var G__11733 = cljs.core.first(seq11732);
  var seq11732__$1 = cljs.core.next(seq11732);
  var G__11734 = cljs.core.first(seq11732__$1);
  var seq11732__$2 = cljs.core.next(seq11732__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__11733, G__11734, seq11732__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose() {
  var G__11739 = arguments.length;
  switch(G__11739) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__11748 = null;
        var G__11748__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11748__1 = function(result) {
          var G__11740 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11740) : rf.call(null, G__11740);
        };
        var G__11748__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = function() {
              var G__11741 = result;
              var G__11742 = sep;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11741, G__11742) : rf.call(null, G__11741, G__11742);
            }();
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              var G__11743 = sepr;
              var G__11744 = input;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11743, G__11744) : rf.call(null, G__11743, G__11744);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            var G__11745 = result;
            var G__11746 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11745, G__11746) : rf.call(null, G__11745, G__11746);
          }
        };
        G__11748 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11748__0.call(this);
            case 1:
              return G__11748__1.call(this, result);
            case 2:
              return G__11748__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11748.cljs$core$IFn$_invoke$arity$0 = G__11748__0;
        G__11748.cljs$core$IFn$_invoke$arity$1 = G__11748__1;
        G__11748.cljs$core$IFn$_invoke$arity$2 = G__11748__2;
        return G__11748;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4423__auto__ = cljs.core.seq(coll);
      if (temp__4423__auto__) {
        var coll__$1 = temp__4423__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat() {
  var G__11760 = arguments.length;
  switch(G__11760) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5360__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq11757) {
  var G__11758 = cljs.core.first(seq11757);
  var seq11757__$1 = cljs.core.next(seq11757);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__11758, seq11757__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter() {
  var G__11763 = arguments.length;
  switch(G__11763) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__11771 = null;
      var G__11771__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__11771__1 = function(result) {
        var G__11764 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11764) : rf.call(null, G__11764);
      };
      var G__11771__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__11765 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11765) : pred.call(null, G__11765);
        }())) {
          var G__11766 = result;
          var G__11767 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11766, G__11767) : rf.call(null, G__11766, G__11767);
        } else {
          return result;
        }
      };
      G__11771 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__11771__0.call(this);
          case 1:
            return G__11771__1.call(this, result);
          case 2:
            return G__11771__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__11771.cljs$core$IFn$_invoke$arity$0 = G__11771__0;
      G__11771.cljs$core$IFn$_invoke$arity$1 = G__11771__1;
      G__11771.cljs$core$IFn$_invoke$arity$2 = G__11771__2;
      return G__11771;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5194__auto___11772 = size;
        var i_11773 = 0;
        while (true) {
          if (i_11773 < n__5194__auto___11772) {
            if (cljs.core.truth_(function() {
              var G__11768 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11773);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11768) : pred.call(null, G__11768);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11773));
            } else {
            }
            var G__11774 = i_11773 + 1;
            i_11773 = G__11774;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(function() {
          var G__11769 = f;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11769) : pred.call(null, G__11769);
        }())) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove() {
  var G__11776 = arguments.length;
  switch(G__11776) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(function() {
        var G__11784 = node;
        return branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__11784) : branch_QMARK_.call(null, G__11784);
      }()) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([function() {
        var G__11785 = node;
        return children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__11785) : children.call(null, G__11785);
      }()], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__11786_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__11786_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into() {
  var G__11788 = arguments.length;
  switch(G__11788) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (function() {
      var G__11789 = to;
      if (G__11789) {
        var bit__4976__auto__ = G__11789.cljs$lang$protocol_mask$partition1$ & 4;
        if (bit__4976__auto__ || G__11789.cljs$core$IEditableCollection$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (function() {
    var G__11790 = to;
    if (G__11790) {
      var bit__4976__auto__ = G__11790.cljs$lang$protocol_mask$partition1$ & 4;
      if (bit__4976__auto__ || G__11790.cljs$core$IEditableCollection$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv() {
  var G__11798 = arguments.length;
  switch(G__11798) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5360__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, function() {
      var G__11799 = o;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11799) : f.call(null, G__11799);
    }());
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq11792) {
  var G__11793 = cljs.core.first(seq11792);
  var seq11792__$1 = cljs.core.next(seq11792);
  var G__11794 = cljs.core.first(seq11792__$1);
  var seq11792__$2 = cljs.core.next(seq11792__$1);
  var G__11795 = cljs.core.first(seq11792__$2);
  var seq11792__$3 = cljs.core.next(seq11792__$2);
  var G__11796 = cljs.core.first(seq11792__$3);
  var seq11792__$4 = cljs.core.next(seq11792__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__11793, G__11794, G__11795, G__11796, seq11792__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(function() {
      var G__11802 = o;
      return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11802) : pred.call(null, G__11802);
    }())) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition() {
  var G__11804 = arguments.length;
  switch(G__11804) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return cljs.core._conj(cljs.core.List.EMPTY, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in() {
  var G__11807 = arguments.length;
  switch(G__11807) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m, ks, null);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (ks__$1) {
      if (!function() {
        var G__11808 = m__$1;
        if (G__11808) {
          var bit__4983__auto__ = G__11808.cljs$lang$protocol_mask$partition0$ & 256;
          if (bit__4983__auto__ || G__11808.cljs$core$ILookup$) {
            return true;
          } else {
            if (!G__11808.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__11808);
            } else {
              return false;
            }
          }
        } else {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__11808);
        }
      }()) {
        return not_found;
      } else {
        var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
        if (sentinel === m__$2) {
          return not_found;
        } else {
          var G__11810 = sentinel;
          var G__11811 = m__$2;
          var G__11812 = cljs.core.next(ks__$1);
          sentinel = G__11810;
          m__$1 = G__11811;
          ks__$1 = G__11812;
          continue;
        }
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__11813, v) {
  var vec__11818 = p__11813;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11818, 0, null);
  var ks = cljs.core.nthnext(vec__11818, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in() {
  var G__11827 = arguments.length;
  switch(G__11827) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__11828, f) {
  var vec__11829 = p__11828;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11829, 0, null);
  var ks = cljs.core.nthnext(vec__11829, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11830) : f.call(null, G__11830);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__11831, f, a) {
  var vec__11832 = p__11831;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11832, 0, null);
  var ks = cljs.core.nthnext(vec__11832, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11834 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11833, G__11834) : f.call(null, G__11833, G__11834);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__11835, f, a, b) {
  var vec__11836 = p__11835;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11836, 0, null);
  var ks = cljs.core.nthnext(vec__11836, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11838 = a;
      var G__11839 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11837, G__11838, G__11839) : f.call(null, G__11837, G__11838, G__11839);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__11840, f, a, b, c) {
  var vec__11841 = p__11840;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11841, 0, null);
  var ks = cljs.core.nthnext(vec__11841, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11843 = a;
      var G__11844 = b;
      var G__11845 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11842, G__11843, G__11844, G__11845) : f.call(null, G__11842, G__11843, G__11844, G__11845);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__11846, f, a, b, c, args) {
  var vec__11847 = p__11846;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11847, 0, null);
  var ks = cljs.core.nthnext(vec__11847, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq11819) {
  var G__11820 = cljs.core.first(seq11819);
  var seq11819__$1 = cljs.core.next(seq11819);
  var G__11821 = cljs.core.first(seq11819__$1);
  var seq11819__$2 = cljs.core.next(seq11819__$1);
  var G__11822 = cljs.core.first(seq11819__$2);
  var seq11819__$3 = cljs.core.next(seq11819__$2);
  var G__11823 = cljs.core.first(seq11819__$3);
  var seq11819__$4 = cljs.core.next(seq11819__$3);
  var G__11824 = cljs.core.first(seq11819__$4);
  var seq11819__$5 = cljs.core.next(seq11819__$4);
  var G__11825 = cljs.core.first(seq11819__$5);
  var seq11819__$6 = cljs.core.next(seq11819__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__11820, G__11821, G__11822, G__11823, G__11824, G__11825, seq11819__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update() {
  var G__11857 = arguments.length;
  switch(G__11857) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5360__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11858) : f.call(null, G__11858);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11859 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11860 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11859, G__11860) : f.call(null, G__11859, G__11860);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11861 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11862 = x;
    var G__11863 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11861, G__11862, G__11863) : f.call(null, G__11861, G__11862, G__11863);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11864 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11865 = x;
    var G__11866 = y;
    var G__11867 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11864, G__11865, G__11866, G__11867) : f.call(null, G__11864, G__11865, G__11866, G__11867);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq11849) {
  var G__11850 = cljs.core.first(seq11849);
  var seq11849__$1 = cljs.core.next(seq11849);
  var G__11851 = cljs.core.first(seq11849__$1);
  var seq11849__$2 = cljs.core.next(seq11849__$1);
  var G__11852 = cljs.core.first(seq11849__$2);
  var seq11849__$3 = cljs.core.next(seq11849__$2);
  var G__11853 = cljs.core.first(seq11849__$3);
  var seq11849__$4 = cljs.core.next(seq11849__$3);
  var G__11854 = cljs.core.first(seq11849__$4);
  var seq11849__$5 = cljs.core.next(seq11849__$4);
  var G__11855 = cljs.core.first(seq11849__$5);
  var seq11849__$6 = cljs.core.next(seq11849__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__11850, G__11851, G__11852, G__11853, G__11854, G__11855, seq11849__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__11869 = ll - 5;
      var G__11870 = r;
      ll = G__11869;
      ret = G__11870;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__11875 = cljs.core.pv_aget(node, 0);
      var G__11876 = level - 5;
      node = G__11875;
      level = G__11876;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__11877 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__11878 = level - 5;
        node = G__11877;
        level = G__11878;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__11888 = init__$2;
              var G__11889 = j + i;
              var G__11890 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11888, G__11889, G__11890) : f.call(null, G__11888, G__11889, G__11890);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__11901 = j + 1;
              var G__11902 = init__$3;
              j = G__11901;
              init__$2 = G__11902;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__11891 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11891) : cljs.core.deref.call(null, G__11891);
      } else {
        var G__11903 = i + len;
        var G__11904 = init__$2;
        i = G__11903;
        init__$1 = G__11904;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, function() {
    var G__11892 = self__.root;
    return cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__11892) : cljs.core.tv_editable_root.call(null, G__11892);
  }(), function() {
    var G__11893 = self__.tail;
    return cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__11893) : cljs.core.tv_editable_tail.call(null, G__11893);
  }());
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__11894 = init__$2;
              var G__11895 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11894, G__11895) : f.call(null, G__11894, G__11895);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__11905 = j + 1;
              var G__11906 = init__$3;
              j = G__11905;
              init__$2 = G__11906;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__11896 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11896) : cljs.core.deref.call(null, G__11896);
      } else {
        var G__11907 = i + len;
        var G__11908 = init__$2;
        i = G__11907;
        init__$1 = G__11908;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0);
    } else {
      var G__11897 = coll__$1;
      var G__11898 = cljs.core.first_array_for_longvec(coll__$1);
      var G__11899 = 0;
      var G__11900 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11897, G__11898, G__11899, G__11900) : cljs.core.chunked_seq.call(null, G__11897, G__11898, G__11899, G__11900);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__5194__auto___11909 = len;
    var i_11910 = 0;
    while (true) {
      if (i_11910 < n__5194__auto___11909) {
        new_tail[i_11910] = self__.tail[i_11910];
        var G__11911 = i_11910 + 1;
        i_11910 = G__11911;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__11912 = null;
  var G__11912__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__11912__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__11912 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11912__2.call(this, self__, k);
      case 3:
        return G__11912__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11912.cljs$core$IFn$_invoke$arity$2 = G__11912__2;
  G__11912.cljs$core$IFn$_invoke$arity$3 = G__11912__3;
  return G__11912;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args11887) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11887)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__11913 = i + 1;
        var G__11914 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__11913;
        out = G__11914;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq11915) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq11915));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__11916 = self__.vec;
      var G__11917 = self__.node;
      var G__11918 = self__.i;
      var G__11919 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11916, G__11917, G__11918, G__11919) : cljs.core.chunked_seq.call(null, G__11916, G__11917, G__11918, G__11919);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__11920 = self__.vec;
    var G__11921 = self__.i + self__.off;
    var G__11922 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11920, G__11921, G__11922) : cljs.core.subvec.call(null, G__11920, G__11921, G__11922);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__11923 = self__.vec;
    var G__11924 = self__.i + self__.off;
    var G__11925 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11923, G__11924, G__11925) : cljs.core.subvec.call(null, G__11923, G__11924, G__11925);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__11926 = self__.vec;
      var G__11927 = self__.node;
      var G__11928 = self__.i;
      var G__11929 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11926, G__11927, G__11928, G__11929) : cljs.core.chunked_seq.call(null, G__11926, G__11927, G__11928, G__11929);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__11930 = self__.vec;
    var G__11931 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__11932 = end;
    var G__11933 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11930, G__11931, G__11932, G__11933) : cljs.core.chunked_seq.call(null, G__11930, G__11931, G__11932, G__11933);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  var G__11934 = self__.vec;
  var G__11935 = self__.node;
  var G__11936 = self__.i;
  var G__11937 = self__.off;
  var G__11938 = m;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__11934, G__11935, G__11936, G__11937, G__11938) : cljs.core.chunked_seq.call(null, G__11934, G__11935, G__11936, G__11937, G__11938);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__11939 = self__.vec;
    var G__11940 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__11941 = end;
    var G__11942 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11939, G__11940, G__11941, G__11942) : cljs.core.chunked_seq.call(null, G__11939, G__11940, G__11941, G__11942);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq() {
  var G__11944 = arguments.length;
  switch(G__11944) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__11947 = init__$1;
        var G__11948 = j;
        var G__11949 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11947, G__11948, G__11949) : f.call(null, G__11947, G__11948, G__11949);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__11950 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11950) : cljs.core.deref.call(null, G__11950);
      } else {
        var G__11972 = i + 1;
        var G__11973 = j + 1;
        var G__11974 = init__$2;
        i = G__11972;
        j = G__11973;
        init__$1 = G__11974;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__11951 = self__.meta;
  var G__11952 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__11953 = self__.start;
  var G__11954 = function() {
    var x__4621__auto__ = self__.end;
    var y__4622__auto__ = v_pos + 1;
    return x__4621__auto__ > y__4622__auto__ ? x__4621__auto__ : y__4622__auto__;
  }();
  var G__11955 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11951, G__11952, G__11953, G__11954, G__11955) : cljs.core.build_subvec.call(null, G__11951, G__11952, G__11953, G__11954, G__11955);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__11956 = self__.meta;
    var G__11957 = self__.v;
    var G__11958 = self__.start;
    var G__11959 = self__.end - 1;
    var G__11960 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11956, G__11957, G__11958, G__11959, G__11960) : cljs.core.build_subvec.call(null, G__11956, G__11957, G__11958, G__11959, G__11960);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  var G__11962 = meta__$1;
  var G__11963 = self__.v;
  var G__11964 = self__.start;
  var G__11965 = self__.end;
  var G__11966 = self__.__hash;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11962, G__11963, G__11964, G__11965, G__11966) : cljs.core.build_subvec.call(null, G__11962, G__11963, G__11964, G__11965, G__11966);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__11967 = self__.meta;
  var G__11968 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__11969 = self__.start;
  var G__11970 = self__.end + 1;
  var G__11971 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11967, G__11968, G__11969, G__11970, G__11971) : cljs.core.build_subvec.call(null, G__11967, G__11968, G__11969, G__11970, G__11971);
};
cljs.core.Subvec.prototype.call = function() {
  var G__11975 = null;
  var G__11975__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__11975__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__11975 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11975__2.call(this, self__, k);
      case 3:
        return G__11975__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11975.cljs$core$IFn$_invoke$arity$2 = G__11975__2;
  G__11975.cljs$core$IFn$_invoke$arity$3 = G__11975__3;
  return G__11975;
}();
cljs.core.Subvec.prototype.apply = function(self__, args11946) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11946)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__11976 = meta;
      var G__11977 = v.v;
      var G__11978 = v.start + start;
      var G__11979 = v.start + end;
      var G__11980 = __hash;
      meta = G__11976;
      v = G__11977;
      start = G__11978;
      end = G__11979;
      __hash = G__11980;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec() {
  var G__11982 = arguments.length;
  switch(G__11982) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode(function() {
    var obj11987 = {};
    return obj11987;
  }(), cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__11995 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__11996 = level - 5;
        node = G__11995;
        level = G__11996;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__12000 = null;
  var G__12000__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12000__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12000 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12000__2.call(this, self__, k);
      case 3:
        return G__12000__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12000.cljs$core$IFn$_invoke$arity$2 = G__12000__2;
  G__12000.cljs$core$IFn$_invoke$arity$3 = G__12000__3;
  return G__12000;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args11997) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11997)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null)], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4423__auto__ = cljs.core.next(self__.front);
  if (temp__4423__auto__) {
    var f1 = temp__4423__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4423__auto__ = cljs.core.next(self__.front);
    if (temp__4423__auto__) {
      var f1 = temp__4423__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__4309__auto__ = self__.front;
    if (cljs.core.truth_(or__4309__auto__)) {
      return or__4309__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__4309__auto__ = self__.rear;
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(cljs.core.identity, cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x)) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__12001 = i + incr;
        i = G__12001;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__12002 = i + 1;
      var G__12003 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__12002;
      out = G__12003;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = function() {
    var obj12007 = {};
    return obj12007;
  }();
  var l = ks.length;
  var i_12008 = 0;
  while (true) {
    if (i_12008 < l) {
      var k_12009 = ks[i_12008];
      new_obj[k_12009] = obj[k_12009];
      var G__12010 = i_12008 + 1;
      i_12008 = G__12010;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__12014 = k;
      return goog.isString(G__12014);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__12015 = init__$1;
        var G__12016 = k;
        var G__12017 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12015, G__12016, G__12017) : f.call(null, G__12015, G__12016, G__12017);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__12018 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12018) : cljs.core.deref.call(null, G__12018);
      } else {
        var G__12024 = cljs.core.rest(keys__$1);
        var G__12025 = init__$2;
        keys__$1 = G__12024;
        init__$1 = G__12025;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__12020 = k;
      return goog.isString(G__12020);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var G__12021 = k;
    return goog.isString(G__12021);
  }())) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4297__auto__ = function() {
      var G__12023 = k;
      return goog.isString(G__12023);
    }();
    if (cljs.core.truth_(and__4297__auto__)) {
      return !(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4297__auto__;
    }
  }())) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__12011_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12011_SHARP_, self__.strobj[p1__12011_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__12026 = null;
  var G__12026__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12026__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12026 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12026__2.call(this, self__, k);
      case 3:
        return G__12026__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12026.cljs$core$IFn$_invoke$arity$2 = G__12026__2;
  G__12026.cljs$core$IFn$_invoke$arity$3 = G__12026__3;
  return G__12026;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args12012) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12012)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], function() {
  var obj12028 = {};
  return obj12028;
}(), 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__12029 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12029, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12029, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null)], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__12030 = i + 2;
        i = G__12030;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Keyword && kstr === k_SINGLEQUOTE_.fqn;
      }()) {
        return i;
      } else {
        var G__12031 = i + 2;
        i = G__12031;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Symbol && kstr === k_SINGLEQUOTE_.str;
      }()) {
        return i;
      } else {
        var G__12032 = i + 2;
        i = G__12032;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__12033 = i + 2;
        i = G__12033;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__12034 = i + 2;
        i = G__12034;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (cljs.core.truth_(function() {
      var or__4309__auto__ = function() {
        var G__12038 = k;
        return goog.isString(G__12038);
      }();
      if (cljs.core.truth_(or__4309__auto__)) {
        return or__4309__auto__;
      } else {
        return typeof k === "number";
      }
    }())) {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_12039 = 0;
  while (true) {
    if (i_12039 < l) {
      narr[i_12039] = arr[i_12039];
      var G__12040 = i_12039 + 1;
      i_12039 = G__12040;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12042 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__12042) : cljs.core.keys.call(null, G__12042);
  }());
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12043 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__12043) : cljs.core.vals.call(null, G__12043);
  }());
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__12044 = cljs.core.seq(coll);
  var chunk__12045 = null;
  var count__12046 = 0;
  var i__12047 = 0;
  while (true) {
    if (i__12047 < count__12046) {
      var vec__12048 = chunk__12045.cljs$core$IIndexed$_nth$arity$2(null, i__12047);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12048, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12048, 1, null);
      var G__12049_12062 = v;
      var G__12050_12063 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12049_12062, G__12050_12063) : f.call(null, G__12049_12062, G__12050_12063);
      var G__12064 = seq__12044;
      var G__12065 = chunk__12045;
      var G__12066 = count__12046;
      var G__12067 = i__12047 + 1;
      seq__12044 = G__12064;
      chunk__12045 = G__12065;
      count__12046 = G__12066;
      i__12047 = G__12067;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__12044);
      if (temp__4425__auto__) {
        var seq__12044__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__12044__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__12044__$1);
          var G__12068 = cljs.core.chunk_rest(seq__12044__$1);
          var G__12069 = c__5094__auto__;
          var G__12070 = cljs.core.count(c__5094__auto__);
          var G__12071 = 0;
          seq__12044 = G__12068;
          chunk__12045 = G__12069;
          count__12046 = G__12070;
          i__12047 = G__12071;
          continue;
        } else {
          var vec__12051 = cljs.core.first(seq__12044__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12051, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12051, 1, null);
          var G__12052_12072 = v;
          var G__12053_12073 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12052_12072, G__12053_12073) : f.call(null, G__12052_12072, G__12053_12073);
          var G__12074 = cljs.core.next(seq__12044__$1);
          var G__12075 = null;
          var G__12076 = 0;
          var G__12077 = 0;
          seq__12044 = G__12074;
          chunk__12045 = G__12075;
          count__12046 = G__12076;
          i__12047 = G__12077;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__12054 = init__$1;
        var G__12055 = self__.arr[i];
        var G__12056 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12054, G__12055, G__12056) : f.call(null, G__12054, G__12055, G__12056);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__12057 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12057) : cljs.core.deref.call(null, G__12057);
      } else {
        var G__12078 = i + 2;
        var G__12079 = init__$2;
        i = G__12078;
        init__$1 = G__12079;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (function() {
    var G__12058 = other;
    if (G__12058) {
      var bit__4976__auto__ = G__12058.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4976__auto__ || G__12058.cljs$core$IMap$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__12080 = i + 2;
              i = G__12080;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap(function() {
    var obj12060 = {};
    return obj12060;
  }(), self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__12081 = s + 2;
            var G__12082 = d;
            s = G__12081;
            d = G__12082;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__12083 = s + 2;
            var G__12084 = d + 2;
            s = G__12083;
            d = G__12084;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__12061 = cljs.core.aclone(self__.arr);
        G__12061[idx + 1] = v;
        return G__12061;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__12085 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__12086 = cljs.core.next(es);
          ret = G__12085;
          es = G__12086;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__12087 = null;
  var G__12087__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12087__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12087 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12087__2.call(this, self__, k);
      case 3:
        return G__12087__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12087.cljs$core$IFn$_invoke$arity$2 = G__12087__2;
  G__12087.cljs$core$IFn$_invoke$arity$3 = G__12087__3;
  return G__12087;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args12041) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12041)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_12088 = 0;
    while (true) {
      if (i_12088 < arr__$1.length) {
        var k_12089 = arr__$1[i_12088];
        var v_12090 = arr__$1[i_12088 + 1];
        var idx_12091 = cljs.core.array_index_of(ret, k_12089);
        if (idx_12091 === -1) {
          ret.push(k_12089);
          ret.push(v_12090);
        } else {
        }
        var G__12092 = i_12088 + 2;
        i_12088 = G__12092;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var arr__$3 = function() {
    var cnt = arr__$2.length / 2;
    return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
  }();
  return arr__$3;
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (function() {
      var G__12093 = o;
      if (G__12093) {
        var bit__4983__auto__ = G__12093.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__12093.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__12093.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__12093);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__12093);
      }
    }()) {
      return cljs.core._assoc_BANG_(tcoll__$1, function() {
        var G__12094 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__12094) : cljs.core.key.call(null, G__12094);
      }(), function() {
        var G__12095 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__12095) : cljs.core.val.call(null, G__12095);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__12101 = cljs.core.next(es);
          var G__12102 = cljs.core._assoc_BANG_(tcoll__$2, function() {
            var G__12096 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__12096) : cljs.core.key.call(null, G__12096);
          }(), function() {
            var G__12097 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__12097) : cljs.core.val.call(null, G__12097);
          }());
          es = G__12101;
          tcoll__$2 = G__12102;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(function() {
          var G__12098 = self__.len;
          var G__12099 = self__.arr;
          return cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__12098, G__12099) : cljs.core.array__GT_transient_hash_map.call(null, G__12098, G__12099);
        }(), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__12100_12103 = self__.arr;
      G__12100_12103.pop();
      G__12100_12103.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__12104 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__12105 = i + 2;
      out = G__12104;
      i = G__12105;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set() {
  var G__12107 = arguments.length;
  switch(G__12107) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__12108 = cljs.core.aclone(arr);
  G__12108[i] = a;
  return G__12108;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__12109 = cljs.core.aclone(arr);
  G__12109[i] = a;
  G__12109[j] = b;
  return G__12109;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set() {
  var G__12112 = arguments.length;
  switch(G__12112) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__12118 = init__$1;
          var G__12119 = k;
          var G__12120 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12118, G__12119, G__12120) : f.call(null, G__12118, G__12119, G__12120);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__12121 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12121) : cljs.core.deref.call(null, G__12121);
      } else {
        var G__12122 = i + 2;
        var G__12123 = init__$2;
        i = G__12122;
        init__$1 = G__12123;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__12124 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__12124) : cljs.core.create_inode_seq.call(null, G__12124);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_12138 = 0;
        var j_12139 = 0;
        while (true) {
          if (i_12138 < 32) {
            if ((self__.bitmap >>> i_12138 & 1) === 0) {
              var G__12140 = i_12138 + 1;
              var G__12141 = j_12139;
              i_12138 = G__12140;
              j_12139 = G__12141;
              continue;
            } else {
              nodes[i_12138] = !(self__.arr[j_12139] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_12139]), self__.arr[j_12139], self__.arr[j_12139 + 1], added_leaf_QMARK_) : self__.arr[j_12139 + 1];
              var G__12142 = i_12138 + 1;
              var G__12143 = j_12139 + 2;
              i_12138 = G__12142;
              j_12139 = G__12143;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__12125 = edit__$1;
          var G__12126 = shift + 5;
          var G__12127 = key_or_nil;
          var G__12128 = val_or_node;
          var G__12129 = hash;
          var G__12130 = key;
          var G__12131 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__12125, G__12126, G__12127, G__12128, G__12129, G__12130, G__12131) : cljs.core.create_node.call(null, G__12125, G__12126, G__12127, G__12128, G__12129, G__12130, G__12131);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_12144 = 0;
      var j_12145 = 0;
      while (true) {
        if (i_12144 < 32) {
          if ((self__.bitmap >>> i_12144 & 1) === 0) {
            var G__12146 = i_12144 + 1;
            var G__12147 = j_12145;
            i_12144 = G__12146;
            j_12145 = G__12147;
            continue;
          } else {
            nodes[i_12144] = !(self__.arr[j_12145] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_12145]), self__.arr[j_12145], self__.arr[j_12145 + 1], added_leaf_QMARK_) : self__.arr[j_12145 + 1];
            var G__12148 = i_12144 + 1;
            var G__12149 = j_12145 + 2;
            i_12144 = G__12148;
            j_12145 = G__12149;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__12132 = shift + 5;
          var G__12133 = key_or_nil;
          var G__12134 = val_or_node;
          var G__12135 = hash;
          var G__12136 = key;
          var G__12137 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__12132, G__12133, G__12134, G__12135, G__12136, G__12137) : cljs.core.create_node.call(null, G__12132, G__12133, G__12134, G__12135, G__12136, G__12137);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__12150 = i + 1;
        var G__12151 = j + 2;
        var G__12152 = bitmap | 1 << i;
        i = G__12150;
        j = G__12151;
        bitmap = G__12152;
        continue;
      } else {
        var G__12153 = i + 1;
        var G__12154 = j;
        var G__12155 = bitmap;
        i = G__12153;
        j = G__12154;
        bitmap = G__12155;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__12156 = self__.arr;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__12156) : cljs.core.create_array_node_seq.call(null, G__12156);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          var G__12157 = init__$2;
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12157) : cljs.core.deref.call(null, G__12157);
        } else {
          var G__12158 = i + 1;
          var G__12159 = init__$2;
          i = G__12158;
          init__$1 = G__12159;
          continue;
        }
      } else {
        var G__12160 = i + 1;
        var G__12161 = init__$1;
        i = G__12160;
        init__$1 = G__12161;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__12162 = i + 2;
        i = G__12162;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__12163 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__12163) : cljs.core.create_inode_seq.call(null, G__12163);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node() {
  var G__12165 = arguments.length;
  switch(G__12165) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    var G__12167 = self__.nodes;
    var G__12168 = self__.i + 2;
    var G__12169 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__12167, G__12168, G__12169) : cljs.core.create_inode_seq.call(null, G__12167, G__12168, G__12169);
  } else {
    var G__12170 = self__.nodes;
    var G__12171 = self__.i;
    var G__12172 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__12170, G__12171, G__12172) : cljs.core.create_inode_seq.call(null, G__12170, G__12171, G__12172);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq() {
  var G__12174 = arguments.length;
  switch(G__12174) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4423__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4423__auto__)) {
            var node = temp__4423__auto__;
            var temp__4423__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4423__auto____$1)) {
              var node_seq = temp__4423__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__12176 = j + 2;
              j = G__12176;
              continue;
            }
          } else {
            var G__12177 = j + 2;
            j = G__12177;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__12178 = null;
  var G__12179 = self__.nodes;
  var G__12180 = self__.i;
  var G__12181 = cljs.core.next(self__.s);
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__12178, G__12179, G__12180, G__12181) : cljs.core.create_array_node_seq.call(null, G__12178, G__12179, G__12180, G__12181);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq() {
  var G__12183 = arguments.length;
  switch(G__12183) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4423__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4423__auto__)) {
          var nj = temp__4423__auto__;
          var temp__4423__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4423__auto____$1)) {
            var ns = temp__4423__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__12185 = j + 1;
            j = G__12185;
            continue;
          }
        } else {
          var G__12186 = j + 1;
          j = G__12186;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12188 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__12188) : cljs.core.keys.call(null, G__12188);
  }());
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12189 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__12189) : cljs.core.vals.call(null, G__12189);
  }());
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__12190 = cljs.core.seq(coll);
  var chunk__12191 = null;
  var count__12192 = 0;
  var i__12193 = 0;
  while (true) {
    if (i__12193 < count__12192) {
      var vec__12194 = chunk__12191.cljs$core$IIndexed$_nth$arity$2(null, i__12193);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12194, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12194, 1, null);
      var G__12195_12206 = v;
      var G__12196_12207 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12195_12206, G__12196_12207) : f.call(null, G__12195_12206, G__12196_12207);
      var G__12208 = seq__12190;
      var G__12209 = chunk__12191;
      var G__12210 = count__12192;
      var G__12211 = i__12193 + 1;
      seq__12190 = G__12208;
      chunk__12191 = G__12209;
      count__12192 = G__12210;
      i__12193 = G__12211;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__12190);
      if (temp__4425__auto__) {
        var seq__12190__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__12190__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__12190__$1);
          var G__12212 = cljs.core.chunk_rest(seq__12190__$1);
          var G__12213 = c__5094__auto__;
          var G__12214 = cljs.core.count(c__5094__auto__);
          var G__12215 = 0;
          seq__12190 = G__12212;
          chunk__12191 = G__12213;
          count__12192 = G__12214;
          i__12193 = G__12215;
          continue;
        } else {
          var vec__12197 = cljs.core.first(seq__12190__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12197, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12197, 1, null);
          var G__12198_12216 = v;
          var G__12199_12217 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12198_12216, G__12199_12217) : f.call(null, G__12198_12216, G__12199_12217);
          var G__12218 = cljs.core.next(seq__12190__$1);
          var G__12219 = null;
          var G__12220 = 0;
          var G__12221 = 0;
          seq__12190 = G__12218;
          chunk__12191 = G__12219;
          count__12192 = G__12220;
          i__12193 = G__12221;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? function() {
    var G__12200 = init;
    var G__12201 = null;
    var G__12202 = self__.nil_val;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12200, G__12201, G__12202) : f.call(null, G__12200, G__12201, G__12202);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__12203 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12203) : cljs.core.deref.call(null, G__12203);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap(function() {
    var obj12205 = {};
    return obj12205;
  }(), self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__12222 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__12223 = cljs.core.next(es);
          ret = G__12222;
          es = G__12223;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__12224 = null;
  var G__12224__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12224__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12224 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12224__2.call(this, self__, k);
      case 3:
        return G__12224__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12224.cljs$core$IFn$_invoke$arity$2 = G__12224__2;
  G__12224.cljs$core$IFn$_invoke$arity$3 = G__12224__3;
  return G__12224;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args12187) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12187)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__12225 = i + 2;
      var G__12226 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__12225;
      ret = G__12226;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__12227 = i + 1;
      var G__12228 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__12227;
      out = G__12228;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (function() {
      var G__12229 = o;
      if (G__12229) {
        var bit__4983__auto__ = G__12229.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4983__auto__ || G__12229.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__12229.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__12229);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__12229);
      }
    }()) {
      return tcoll.assoc_BANG_(function() {
        var G__12230 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__12230) : cljs.core.key.call(null, G__12230);
      }(), function() {
        var G__12231 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__12231) : cljs.core.val.call(null, G__12231);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__12234 = cljs.core.next(es);
          var G__12235 = tcoll__$1.assoc_BANG_(function() {
            var G__12232 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__12232) : cljs.core.key.call(null, G__12232);
          }(), function() {
            var G__12233 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__12233) : cljs.core.val.call(null, G__12233);
          }());
          es = G__12234;
          tcoll__$1 = G__12235;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null)], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__12236 = ascending_QMARK_ ? t.left : t.right;
      var G__12237 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__12236;
      stack__$1 = G__12237;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__12250 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12250) : cljs.core.deref.call(null, G__12250);
  } else {
    var init__$2 = function() {
      var G__12251 = init__$1;
      var G__12252 = node.key;
      var G__12253 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12251, G__12252, G__12253) : f.call(null, G__12251, G__12252, G__12253);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      var G__12254 = init__$2;
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12254) : cljs.core.deref.call(null, G__12254);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        var G__12255 = init__$3;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12255) : cljs.core.deref.call(null, G__12255);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__12257 = null;
  var G__12257__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12257__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12257 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12257__2.call(this, self__, k);
      case 3:
        return G__12257__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12257.cljs$core$IFn$_invoke$arity$2 = G__12257__2;
  G__12257.cljs$core$IFn$_invoke$arity$3 = G__12257__3;
  return G__12257;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args12256) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12256)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__12259 = null;
  var G__12259__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12259__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12259 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12259__2.call(this, self__, k);
      case 3:
        return G__12259__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12259.cljs$core$IFn$_invoke$arity$2 = G__12259__2;
  G__12259.cljs$core$IFn$_invoke$arity$3 = G__12259__3;
  return G__12259;
}();
cljs.core.RedNode.prototype.apply = function(self__, args12258) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12258)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__12272 = k;
      var G__12273 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12272, G__12273) : comp.call(null, G__12272, G__12273);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = cljs$core$tree_map_add(comp, tree.left, k, v, found);
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = cljs$core$tree_map_add(comp, tree.right, k, v, found);
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, cljs$core$tree_map_append(left.right, right), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, cljs$core$tree_map_append(left, right.left), right.right, null);
        } else {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__12292 = k;
      var G__12293 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12292, G__12293) : comp.call(null, G__12292, G__12293);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = cljs$core$tree_map_remove(comp, tree.left, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = cljs$core$tree_map_remove(comp, tree.right, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = function() {
    var G__12304 = k;
    var G__12305 = tk;
    return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12304, G__12305) : comp.call(null, G__12304, G__12305);
  }();
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, cljs$core$tree_map_replace(comp, tree.left, k, v), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, cljs$core$tree_map_replace(comp, tree.right, k, v));
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__12307 = cljs.core.seq(coll);
  var chunk__12308 = null;
  var count__12309 = 0;
  var i__12310 = 0;
  while (true) {
    if (i__12310 < count__12309) {
      var vec__12311 = chunk__12308.cljs$core$IIndexed$_nth$arity$2(null, i__12310);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12311, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12311, 1, null);
      var G__12312_12324 = v;
      var G__12313_12325 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12312_12324, G__12313_12325) : f.call(null, G__12312_12324, G__12313_12325);
      var G__12326 = seq__12307;
      var G__12327 = chunk__12308;
      var G__12328 = count__12309;
      var G__12329 = i__12310 + 1;
      seq__12307 = G__12326;
      chunk__12308 = G__12327;
      count__12309 = G__12328;
      i__12310 = G__12329;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__12307);
      if (temp__4425__auto__) {
        var seq__12307__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__12307__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__12307__$1);
          var G__12330 = cljs.core.chunk_rest(seq__12307__$1);
          var G__12331 = c__5094__auto__;
          var G__12332 = cljs.core.count(c__5094__auto__);
          var G__12333 = 0;
          seq__12307 = G__12330;
          chunk__12308 = G__12331;
          count__12309 = G__12332;
          i__12310 = G__12333;
          continue;
        } else {
          var vec__12314 = cljs.core.first(seq__12307__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12314, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12314, 1, null);
          var G__12315_12334 = v;
          var G__12316_12335 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12315_12334, G__12316_12335) : f.call(null, G__12315_12334, G__12316_12335);
          var G__12336 = cljs.core.next(seq__12307__$1);
          var G__12337 = null;
          var G__12338 = 0;
          var G__12339 = 0;
          seq__12307 = G__12336;
          chunk__12308 = G__12337;
          count__12309 = G__12338;
          i__12310 = G__12339;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12317 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__12317) : cljs.core.keys.call(null, G__12317);
  }());
};
cljs.core.PersistentTreeMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__12318 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__12318) : cljs.core.vals.call(null, G__12318);
  }());
};
cljs.core.PersistentTreeMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var self__ = this;
  var coll = this;
  var t = self__.tree;
  while (true) {
    if (!(t == null)) {
      var c = function() {
        var G__12319 = k;
        var G__12320 = t.key;
        return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__12319, G__12320) : self__.comp.call(null, G__12319, G__12320);
      }();
      if (c === 0) {
        return t;
      } else {
        if (c < 0) {
          var G__12340 = t.left;
          t = G__12340;
          continue;
        } else {
          var G__12341 = t.right;
          t = G__12341;
          continue;
        }
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = coll__$1.entry_at(k);
  if (!(n == null)) {
    return n.val;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.tree == null)) {
    return cljs.core.tree_map_kv_reduce(self__.tree, f, init);
  } else {
    return init;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, self__.meta, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, false, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, 0);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_remove(self__.comp, self__.tree, k, found);
  if (t == null) {
    if (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0) == null) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt - 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_add(self__.comp, self__.tree, k, v, found);
  if (t == null) {
    var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0);
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v, found_node.val)) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, cljs.core.tree_map_replace(self__.comp, self__.tree, k, v), self__.cnt, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt + 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(coll__$1.entry_at(k) == null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, true, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, meta__$1, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__12342 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__12343 = cljs.core.next(es);
          ret = G__12342;
          es = G__12343;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__12344 = null;
  var G__12344__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12344__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12344 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12344__2.call(this, self__, k);
      case 3:
        return G__12344__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12344.cljs$core$IFn$_invoke$arity$2 = G__12344__2;
  G__12344.cljs$core$IFn$_invoke$arity$3 = G__12344__3;
  return G__12344;
}();
cljs.core.PersistentTreeMap.prototype.apply = function(self__, args12306) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12306)));
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, ascending_QMARK_, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var stack = null;
    var t = self__.tree;
    while (true) {
      if (!(t == null)) {
        var c = function() {
          var G__12321 = k;
          var G__12322 = t.key;
          return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__12321, G__12322) : self__.comp.call(null, G__12321, G__12322);
        }();
        if (c === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t), ascending_QMARK_, -1, null);
        } else {
          if (cljs.core.truth_(ascending_QMARK_)) {
            if (c < 0) {
              var G__12345 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__12346 = t.left;
              stack = G__12345;
              t = G__12346;
              continue;
            } else {
              var G__12347 = stack;
              var G__12348 = t.right;
              stack = G__12347;
              t = G__12348;
              continue;
            }
          } else {
            if (c > 0) {
              var G__12349 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__12350 = t.right;
              stack = G__12349;
              t = G__12350;
              continue;
            } else {
              var G__12351 = stack;
              var G__12352 = t.left;
              stack = G__12351;
              t = G__12352;
              continue;
            }
          }
        }
      } else {
        if (stack == null) {
          return null;
        } else {
          return new cljs.core.PersistentTreeMapSeq(null, stack, ascending_QMARK_, -1, null);
        }
      }
      break;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  var G__12323 = entry;
  return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__12323) : cljs.core.key.call(null, G__12323);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.comp;
};
cljs.core.PersistentTreeMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "comp", "comp", -1462482139, null), new cljs.core.Symbol(null, "tree", "tree", 1444219499, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";
cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeMap");
};
cljs.core.__GT_PersistentTreeMap = function cljs$core$__GT_PersistentTreeMap(comp, tree, cnt, meta, __hash) {
  return new cljs.core.PersistentTreeMap(comp, tree, cnt, meta, __hash);
};
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.hash_map = function cljs$core$hash_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (in$) {
      var G__12354 = cljs.core.nnext(in$);
      var G__12355 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__12354;
      out = G__12355;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.hash_map.cljs$lang$maxFixedArity = 0;
cljs.core.hash_map.cljs$lang$applyTo = function(seq12353) {
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12353));
};
cljs.core.array_map = function cljs$core$array_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var arr = keyvals instanceof cljs.core.IndexedSeq && keyvals.i === 0 ? keyvals.arr : cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals);
  return cljs.core.PersistentArrayMap.fromArray(arr, true, false);
};
cljs.core.array_map.cljs$lang$maxFixedArity = 0;
cljs.core.array_map.cljs$lang$applyTo = function(seq12356) {
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12356));
};
cljs.core.obj_map = function cljs$core$obj_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var ks = [];
  var obj = function() {
    var obj12359 = {};
    return obj12359;
  }();
  var kvs = cljs.core.seq(keyvals);
  while (true) {
    if (kvs) {
      ks.push(cljs.core.first(kvs));
      obj[cljs.core.first(kvs)] = cljs.core.second(kvs);
      var G__12360 = cljs.core.nnext(kvs);
      kvs = G__12360;
      continue;
    } else {
      return cljs.core.ObjMap.fromObject(ks, obj);
    }
    break;
  }
};
cljs.core.obj_map.cljs$lang$maxFixedArity = 0;
cljs.core.obj_map.cljs$lang$applyTo = function(seq12357) {
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12357));
};
cljs.core.sorted_map = function cljs$core$sorted_map() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.PersistentTreeMap.EMPTY;
  while (true) {
    if (in$) {
      var G__12362 = cljs.core.nnext(in$);
      var G__12363 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__12362;
      out = G__12363;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_map.cljs$lang$applyTo = function(seq12361) {
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12361));
};
cljs.core.sorted_map_by = function cljs$core$sorted_map_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator), null, 0, null, 0);
  while (true) {
    if (in$) {
      var G__12366 = cljs.core.nnext(in$);
      var G__12367 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__12366;
      out = G__12367;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_map_by.cljs$lang$applyTo = function(seq12364) {
  var G__12365 = cljs.core.first(seq12364);
  var seq12364__$1 = cljs.core.next(seq12364);
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__12365, seq12364__$1);
};
cljs.core.KeySeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.KeySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.KeySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__12368 = self__.mseq;
    if (G__12368) {
      var bit__4983__auto__ = G__12368.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__12368.cljs$core$INext$) {
        return true;
      } else {
        if (!G__12368.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12368);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12368);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.KeySeq(nseq, self__._meta);
  }
};
cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_key$arity$1(null);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__12369 = self__.mseq;
    if (G__12369) {
      var bit__4983__auto__ = G__12369.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__12369.cljs$core$INext$) {
        return true;
      } else {
        if (!G__12369.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12369);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12369);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.KeySeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.KeySeq(self__.mseq, new_meta);
};
cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.KeySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.KeySeq.cljs$lang$type = true;
cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";
cljs.core.KeySeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/KeySeq");
};
cljs.core.__GT_KeySeq = function cljs$core$__GT_KeySeq(mseq, _meta) {
  return new cljs.core.KeySeq(mseq, _meta);
};
cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.keys = function cljs$core$keys(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.KeySeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.key = function cljs$core$key(map_entry) {
  return cljs.core._key(map_entry);
};
cljs.core.ValSeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ValSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ValSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__12370 = self__.mseq;
    if (G__12370) {
      var bit__4983__auto__ = G__12370.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__12370.cljs$core$INext$) {
        return true;
      } else {
        if (!G__12370.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12370);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12370);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.ValSeq(nseq, self__._meta);
  }
};
cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_val$arity$1(null);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__12371 = self__.mseq;
    if (G__12371) {
      var bit__4983__auto__ = G__12371.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4983__auto__ || G__12371.cljs$core$INext$) {
        return true;
      } else {
        if (!G__12371.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12371);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__12371);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.ValSeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ValSeq(self__.mseq, new_meta);
};
cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ValSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "mseq", "mseq", 1602647196, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.ValSeq.cljs$lang$type = true;
cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";
cljs.core.ValSeq.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ValSeq");
};
cljs.core.__GT_ValSeq = function cljs$core$__GT_ValSeq(mseq, _meta) {
  return new cljs.core.ValSeq(mseq, _meta);
};
cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.vals = function cljs$core$vals(hash_map) {
  var temp__4425__auto__ = cljs.core.seq(hash_map);
  if (temp__4425__auto__) {
    var mseq = temp__4425__auto__;
    return new cljs.core.ValSeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.val = function cljs$core$val(map_entry) {
  return cljs.core._val(map_entry);
};
cljs.core.merge = function cljs$core$merge() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = function(maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(function(p1__12372_SHARP_, p2__12373_SHARP_) {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
        var or__4309__auto__ = p1__12372_SHARP_;
        if (cljs.core.truth_(or__4309__auto__)) {
          return or__4309__auto__;
        } else {
          return cljs.core.PersistentArrayMap.EMPTY;
        }
      }(), p2__12373_SHARP_);
    }, maps);
  } else {
    return null;
  }
};
cljs.core.merge.cljs$lang$maxFixedArity = 0;
cljs.core.merge.cljs$lang$applyTo = function(seq12374) {
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12374));
};
cljs.core.merge_with = function cljs$core$merge_with() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = function(f, maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    var merge_entry = function(m, e) {
      var k = cljs.core.first(e);
      var v = cljs.core.second(e);
      if (cljs.core.contains_QMARK_(m, k)) {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
          var G__12377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
          var G__12378 = v;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12377, G__12378) : f.call(null, G__12377, G__12378);
        }());
      } else {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
      }
    };
    var merge2 = function(merge_entry) {
      return function(m1, m2) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry, function() {
          var or__4309__auto__ = m1;
          if (cljs.core.truth_(or__4309__auto__)) {
            return or__4309__auto__;
          } else {
            return cljs.core.PersistentArrayMap.EMPTY;
          }
        }(), cljs.core.seq(m2));
      };
    }(merge_entry);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2, maps);
  } else {
    return null;
  }
};
cljs.core.merge_with.cljs$lang$maxFixedArity = 1;
cljs.core.merge_with.cljs$lang$applyTo = function(seq12375) {
  var G__12376 = cljs.core.first(seq12375);
  var seq12375__$1 = cljs.core.next(seq12375);
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__12376, seq12375__$1);
};
cljs.core.select_keys = function cljs$core$select_keys(map, keyseq) {
  var ret = cljs.core.PersistentArrayMap.EMPTY;
  var keys = cljs.core.seq(keyseq);
  while (true) {
    if (keys) {
      var key = cljs.core.first(keys);
      var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map, key, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185));
      var G__12379 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185)) ? cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret, key, entry) : ret;
      var G__12380 = cljs.core.next(keys);
      ret = G__12379;
      keys = G__12380;
      continue;
    } else {
      return cljs.core.with_meta(ret, cljs.core.meta(map));
    }
    break;
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 15077647;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__12383 = cljs.core.seq(coll);
  var chunk__12384 = null;
  var count__12385 = 0;
  var i__12386 = 0;
  while (true) {
    if (i__12386 < count__12385) {
      var vec__12387 = chunk__12384.cljs$core$IIndexed$_nth$arity$2(null, i__12386);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12387, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12387, 1, null);
      var G__12388_12393 = v;
      var G__12389_12394 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12388_12393, G__12389_12394) : f.call(null, G__12388_12393, G__12389_12394);
      var G__12395 = seq__12383;
      var G__12396 = chunk__12384;
      var G__12397 = count__12385;
      var G__12398 = i__12386 + 1;
      seq__12383 = G__12395;
      chunk__12384 = G__12396;
      count__12385 = G__12397;
      i__12386 = G__12398;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__12383);
      if (temp__4425__auto__) {
        var seq__12383__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__12383__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__12383__$1);
          var G__12399 = cljs.core.chunk_rest(seq__12383__$1);
          var G__12400 = c__5094__auto__;
          var G__12401 = cljs.core.count(c__5094__auto__);
          var G__12402 = 0;
          seq__12383 = G__12399;
          chunk__12384 = G__12400;
          count__12385 = G__12401;
          i__12386 = G__12402;
          continue;
        } else {
          var vec__12390 = cljs.core.first(seq__12383__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12390, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12390, 1, null);
          var G__12391_12403 = v;
          var G__12392_12404 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12391_12403, G__12392_12404) : f.call(null, G__12391_12403, G__12392_12404);
          var G__12405 = cljs.core.next(seq__12383__$1);
          var G__12406 = null;
          var G__12407 = 0;
          var G__12408 = 0;
          seq__12383 = G__12405;
          chunk__12384 = G__12406;
          count__12385 = G__12407;
          i__12386 = G__12408;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._contains_key_QMARK_(self__.hash_map, v)) {
    return v;
  } else {
    return not_found;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._count(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__12381_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__12381_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY, self__.meta);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core._dissoc(self__.hash_map, v), null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(meta__$1, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map, o, null), null);
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__12409 = null;
  var G__12409__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12409__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12409 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12409__2.call(this, self__, k);
      case 3:
        return G__12409__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12409.cljs$core$IFn$_invoke$arity$2 = G__12409__2;
  G__12409.cljs$core$IFn$_invoke$arity$3 = G__12409__3;
  return G__12409;
}();
cljs.core.PersistentHashSet.prototype.apply = function(self__, args12382) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12382)));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "hash-map", "hash-map", -439030950, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";
cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentHashSet");
};
cljs.core.__GT_PersistentHashSet = function cljs$core$__GT_PersistentHashSet(meta, hash_map, __hash) {
  return new cljs.core.PersistentHashSet(meta, hash_map, __hash);
};
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.PersistentArrayMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashSet.fromArray = function(items, no_clone) {
  var len = items.length;
  if (len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
    var arr = no_clone ? items : cljs.core.aclone(items);
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
    while (true) {
      if (i < len) {
        var G__12410 = i + 1;
        var G__12411 = cljs.core._assoc_BANG_(out, items[i], null);
        i = G__12410;
        out = G__12411;
        continue;
      } else {
        return new cljs.core.PersistentHashSet(null, cljs.core._persistent_BANG_(out), null);
      }
      break;
    }
  } else {
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < len) {
        var G__12412 = i + 1;
        var G__12413 = cljs.core._conj_BANG_(out, items[i]);
        i = G__12412;
        out = G__12413;
        continue;
      } else {
        return cljs.core._persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition1$ = 136;
  this.cljs$lang$protocol_mask$partition0$ = 259;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map, o, null);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_(self__.transient_map), null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map, v);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core.count(self__.transient_map);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, v, null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return v;
  }
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__12415 = null;
  var G__12415__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null;
    } else {
      return k;
    }
  };
  var G__12415__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found;
    } else {
      return k;
    }
  };
  G__12415 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12415__2.call(this, self__, k);
      case 3:
        return G__12415__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12415.cljs$core$IFn$_invoke$arity$2 = G__12415__2;
  G__12415.cljs$core$IFn$_invoke$arity$3 = G__12415__3;
  return G__12415;
}();
cljs.core.TransientHashSet.prototype.apply = function(self__, args12414) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12414)));
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return null;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "transient-map", "transient-map", 351764893, null)], null);
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";
cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/TransientHashSet");
};
cljs.core.__GT_TransientHashSet = function cljs$core$__GT_TransientHashSet(transient_map) {
  return new cljs.core.TransientHashSet(transient_map);
};
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 417730831;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__12418 = cljs.core.seq(coll);
  var chunk__12419 = null;
  var count__12420 = 0;
  var i__12421 = 0;
  while (true) {
    if (i__12421 < count__12420) {
      var vec__12422 = chunk__12419.cljs$core$IIndexed$_nth$arity$2(null, i__12421);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12422, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12422, 1, null);
      var G__12423_12428 = v;
      var G__12424_12429 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12423_12428, G__12424_12429) : f.call(null, G__12423_12428, G__12424_12429);
      var G__12430 = seq__12418;
      var G__12431 = chunk__12419;
      var G__12432 = count__12420;
      var G__12433 = i__12421 + 1;
      seq__12418 = G__12430;
      chunk__12419 = G__12431;
      count__12420 = G__12432;
      i__12421 = G__12433;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__12418);
      if (temp__4425__auto__) {
        var seq__12418__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__12418__$1)) {
          var c__5094__auto__ = cljs.core.chunk_first(seq__12418__$1);
          var G__12434 = cljs.core.chunk_rest(seq__12418__$1);
          var G__12435 = c__5094__auto__;
          var G__12436 = cljs.core.count(c__5094__auto__);
          var G__12437 = 0;
          seq__12418 = G__12434;
          chunk__12419 = G__12435;
          count__12420 = G__12436;
          i__12421 = G__12437;
          continue;
        } else {
          var vec__12425 = cljs.core.first(seq__12418__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12425, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12425, 1, null);
          var G__12426_12438 = v;
          var G__12427_12439 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12426_12438, G__12427_12439) : f.call(null, G__12426_12438, G__12427_12439);
          var G__12440 = cljs.core.next(seq__12418__$1);
          var G__12441 = null;
          var G__12442 = 0;
          var G__12443 = 0;
          seq__12418 = G__12440;
          chunk__12419 = G__12441;
          count__12420 = G__12442;
          i__12421 = G__12443;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = self__.tree_map.entry_at(v);
  if (!(n == null)) {
    return n.key;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.count(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.count(self__.tree_map) > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core.rseq(self__.tree_map));
  } else {
    return null;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__12416_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__12416_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core._empty(self__.tree_map), 0);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map, v), null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(meta__$1, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map, o, null), null);
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__12444 = null;
  var G__12444__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__12444__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__12444 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__12444__2.call(this, self__, k);
      case 3:
        return G__12444__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__12444.cljs$core$IFn$_invoke$arity$2 = G__12444__2;
  G__12444.cljs$core$IFn$_invoke$arity$3 = G__12444__3;
  return G__12444;
}();
cljs.core.PersistentTreeSet.prototype.apply = function(self__, args12417) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args12417)));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq(self__.tree_map, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq_from(self__.tree_map, k, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  return entry;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._comparator(self__.tree_map);
};
cljs.core.PersistentTreeSet.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "tree-map", "tree-map", 1373073049, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";
cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/PersistentTreeSet");
};
cljs.core.__GT_PersistentTreeSet = function cljs$core$__GT_PersistentTreeSet(meta, tree_map, __hash) {
  return new cljs.core.PersistentTreeSet(meta, tree_map, __hash);
};
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.PersistentTreeMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5285__auto__ = this;
  return cljs.core.es6_iterator(this__5285__auto__);
};
cljs.core.set_from_indexed_seq = function cljs$core$set_from_indexed_seq(iseq) {
  var arr = iseq.arr;
  var ret = function() {
    var a__5188__auto__ = arr;
    var i = 0;
    var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < a__5188__auto__.length) {
        var G__12445 = i + 1;
        var G__12446 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, arr[i]);
        i = G__12445;
        res = G__12446;
        continue;
      } else {
        return res;
      }
      break;
    }
  }();
  return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
};
cljs.core.set = function cljs$core$set(coll) {
  var in$ = cljs.core.seq(coll);
  if (in$ == null) {
    return cljs.core.PersistentHashSet.EMPTY;
  } else {
    if (in$ instanceof cljs.core.IndexedSeq && in$.i === 0) {
      return cljs.core.set_from_indexed_seq(in$);
    } else {
      var in$__$1 = in$;
      var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
      while (true) {
        if (!(in$__$1 == null)) {
          var G__12447 = cljs.core.next(in$__$1);
          var G__12448 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, in$__$1.cljs$core$ISeq$_first$arity$1(null));
          in$__$1 = G__12447;
          out = G__12448;
          continue;
        } else {
          return cljs.core.persistent_BANG_(out);
        }
        break;
      }
    }
  }
};
cljs.core.hash_set = function cljs$core$hash_set() {
  var G__12451 = arguments.length;
  switch(G__12451) {
    case 0:
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5360__auto__);
  }
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentHashSet.EMPTY;
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.set(keys);
};
cljs.core.hash_set.cljs$lang$applyTo = function(seq12449) {
  return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12449));
};
cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set = function cljs$core$sorted_set() {
  var argseq__5349__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5349__auto__);
};
cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys);
};
cljs.core.sorted_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set.cljs$lang$applyTo = function(seq12453) {
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12453));
};
cljs.core.sorted_set_by = function cljs$core$sorted_set_by() {
  var argseq__5349__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5349__auto__);
};
cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by(comparator), 0), keys);
};
cljs.core.sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_set_by.cljs$lang$applyTo = function(seq12454) {
  var G__12455 = cljs.core.first(seq12454);
  var seq12454__$1 = cljs.core.next(seq12454);
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__12455, seq12454__$1);
};
cljs.core.replace = function cljs$core$replace() {
  var G__12459 = arguments.length;
  switch(G__12459) {
    case 1:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = function(smap) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$1(function(p1__12456_SHARP_) {
    var temp__4423__auto__ = cljs.core.find(smap, p1__12456_SHARP_);
    if (cljs.core.truth_(temp__4423__auto__)) {
      var e = temp__4423__auto__;
      return cljs.core.val(e);
    } else {
      return p1__12456_SHARP_;
    }
  });
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = function(smap, coll) {
  if (cljs.core.vector_QMARK_(coll)) {
    var n = cljs.core.count(coll);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(n) {
      return function(v, i) {
        var temp__4423__auto__ = cljs.core.find(smap, cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v, i));
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v, i, cljs.core.second(e));
        } else {
          return v;
        }
      };
    }(n), coll, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.iterate(cljs.core.inc, 0)));
  } else {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(p1__12457_SHARP_) {
      var temp__4423__auto__ = cljs.core.find(smap, p1__12457_SHARP_);
      if (cljs.core.truth_(temp__4423__auto__)) {
        var e = temp__4423__auto__;
        return cljs.core.second(e);
      } else {
        return p1__12457_SHARP_;
      }
    }, coll);
  }
};
cljs.core.replace.cljs$lang$maxFixedArity = 2;
cljs.core.distinct = function cljs$core$distinct() {
  var G__12462 = arguments.length;
  switch(G__12462) {
    case 0:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = function() {
  return function(rf) {
    var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
    return function(seen) {
      return function() {
        var G__12474 = null;
        var G__12474__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__12474__1 = function(result) {
          var G__12463 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12463) : rf.call(null, G__12463);
        };
        var G__12474__2 = function(result, input) {
          if (cljs.core.contains_QMARK_(function() {
            var G__12464 = seen;
            return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12464) : cljs.core.deref.call(null, G__12464);
          }(), input)) {
            return result;
          } else {
            cljs.core._vreset_BANG_(seen, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen), input));
            var G__12465 = result;
            var G__12466 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12465, G__12466) : rf.call(null, G__12465, G__12466);
          }
        };
        G__12474 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__12474__0.call(this);
            case 1:
              return G__12474__1.call(this, result);
            case 2:
              return G__12474__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__12474.cljs$core$IFn$_invoke$arity$0 = G__12474__0;
        G__12474.cljs$core$IFn$_invoke$arity$1 = G__12474__1;
        G__12474.cljs$core$IFn$_invoke$arity$2 = G__12474__2;
        return G__12474;
      }();
    }(seen);
  };
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var step = function cljs$core$step(xs, seen) {
    return new cljs.core.LazySeq(null, function() {
      return function(p__12471, seen__$1) {
        while (true) {
          var vec__12472 = p__12471;
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12472, 0, null);
          var xs__$1 = vec__12472;
          var temp__4425__auto__ = cljs.core.seq(xs__$1);
          if (temp__4425__auto__) {
            var s = temp__4425__auto__;
            if (cljs.core.contains_QMARK_(seen__$1, f)) {
              var G__12475 = cljs.core.rest(s);
              var G__12476 = seen__$1;
              p__12471 = G__12475;
              seen__$1 = G__12476;
              continue;
            } else {
              return cljs.core.cons(f, cljs$core$step(cljs.core.rest(s), cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1, f)));
            }
          } else {
            return null;
          }
          break;
        }
      }.call(null, xs, seen);
    }, null, null);
  };
  return step(coll, cljs.core.PersistentHashSet.EMPTY);
};
cljs.core.distinct.cljs$lang$maxFixedArity = 1;
cljs.core.butlast = function cljs$core$butlast(s) {
  var ret = cljs.core.PersistentVector.EMPTY;
  var s__$1 = s;
  while (true) {
    if (cljs.core.next(s__$1)) {
      var G__12477 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret, cljs.core.first(s__$1));
      var G__12478 = cljs.core.next(s__$1);
      ret = G__12477;
      s__$1 = G__12478;
      continue;
    } else {
      return cljs.core.seq(ret);
    }
    break;
  }
};
cljs.core.name = function cljs$core$name(x) {
  if (function() {
    var G__12480 = x;
    if (G__12480) {
      var bit__4976__auto__ = G__12480.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4976__auto__ || G__12480.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(null);
  } else {
    if (typeof x === "string") {
      return x;
    } else {
      throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
    }
  }
};
cljs.core.zipmap = function cljs$core$zipmap(keys, vals) {
  var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
  var ks = cljs.core.seq(keys);
  var vs = cljs.core.seq(vals);
  while (true) {
    if (ks && vs) {
      var G__12481 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map, cljs.core.first(ks), cljs.core.first(vs));
      var G__12482 = cljs.core.next(ks);
      var G__12483 = cljs.core.next(vs);
      map = G__12481;
      ks = G__12482;
      vs = G__12483;
      continue;
    } else {
      return cljs.core.persistent_BANG_(map);
    }
    break;
  }
};
cljs.core.max_key = function cljs$core$max_key() {
  var G__12491 = arguments.length;
  switch(G__12491) {
    case 2:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__12492 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__12492) : k.call(null, G__12492);
  }() > function() {
    var G__12493 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__12493) : k.call(null, G__12493);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__12484_SHARP_, p2__12485_SHARP_) {
    return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, p1__12484_SHARP_, p2__12485_SHARP_);
  }, cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.max_key.cljs$lang$applyTo = function(seq12486) {
  var G__12487 = cljs.core.first(seq12486);
  var seq12486__$1 = cljs.core.next(seq12486);
  var G__12488 = cljs.core.first(seq12486__$1);
  var seq12486__$2 = cljs.core.next(seq12486__$1);
  var G__12489 = cljs.core.first(seq12486__$2);
  var seq12486__$3 = cljs.core.next(seq12486__$2);
  return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__12487, G__12488, G__12489, seq12486__$3);
};
cljs.core.max_key.cljs$lang$maxFixedArity = 3;
cljs.core.min_key = function cljs$core$min_key() {
  var G__12502 = arguments.length;
  switch(G__12502) {
    case 2:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5360__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5360__auto__);
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__12503 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__12503) : k.call(null, G__12503);
  }() < function() {
    var G__12504 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__12504) : k.call(null, G__12504);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__12495_SHARP_, p2__12496_SHARP_) {
    return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, p1__12495_SHARP_, p2__12496_SHARP_);
  }, cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.min_key.cljs$lang$applyTo = function(seq12497) {
  var G__12498 = cljs.core.first(seq12497);
  var seq12497__$1 = cljs.core.next(seq12497);
  var G__12499 = cljs.core.first(seq12497__$1);
  var seq12497__$2 = cljs.core.next(seq12497__$1);
  var G__12500 = cljs.core.first(seq12497__$2);
  var seq12497__$3 = cljs.core.next(seq12497__$2);
  return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__12498, G__12499, G__12500, seq12497__$3);
};
cljs.core.min_key.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayList = function(arr) {
  this.arr = arr;
};
cljs.core.ArrayList.prototype.add = function(x) {
  var self__ = this;
  var _ = this;
  return self__.arr.push(x);
};
cljs.core.ArrayList.prototype.size = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length;
};
cljs.core.ArrayList.prototype.clear = function() {
  var self__ = this;
  var _ = this;
  return self__.arr = [];
};
cljs.core.ArrayList.prototype.isEmpty = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length === 0;
};
cljs.core.ArrayList.prototype.toArray = function() {
  var self__ = this;
  var _ = this;
  return self__.arr;
};
cljs.core.ArrayList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.ArrayList.cljs$lang$type = true;
cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";
cljs.core.ArrayList.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/ArrayList");
};
cljs.core.__GT_ArrayList = function cljs$core$__GT_ArrayList(arr) {
  return new cljs.core.ArrayList(arr);
};
cljs.core.array_list = function cljs$core$array_list() {
  return new cljs.core.ArrayList([]);
};
cljs.core.partition_all = function cljs$core$partition_all() {
  var G__12507 = arguments.length;
  switch(G__12507) {
    case 1:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var a = cljs.core.array_list();
    return function(a) {
      return function() {
        var G__12514 = null;
        var G__12514__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__12514__1 = function(result) {
          var result__$1 = cljs.core.truth_(a.isEmpty()) ? result : function() {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            return cljs.core.unreduced(function() {
              var G__12508 = result;
              var G__12509 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12508, G__12509) : rf.call(null, G__12508, G__12509);
            }());
          }();
          var G__12510 = result__$1;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12510) : rf.call(null, G__12510);
        };
        var G__12514__2 = function(result, input) {
          a.add(input);
          if (n === a.size()) {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            var G__12511 = result;
            var G__12512 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12511, G__12512) : rf.call(null, G__12511, G__12512);
          } else {
            return result;
          }
        };
        G__12514 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__12514__0.call(this);
            case 1:
              return G__12514__1.call(this, result);
            case 2:
              return G__12514__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__12514.cljs$core$IFn$_invoke$arity$0 = G__12514__0;
        G__12514.cljs$core$IFn$_invoke$arity$1 = G__12514__1;
        G__12514.cljs$core$IFn$_invoke$arity$2 = G__12514__2;
        return G__12514;
      }();
    }(a);
  };
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s), cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
cljs.core.take_while = function cljs$core$take_while() {
  var G__12516 = arguments.length;
  switch(G__12516) {
    case 1:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__12523 = null;
      var G__12523__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__12523__1 = function(result) {
        var G__12517 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12517) : rf.call(null, G__12517);
      };
      var G__12523__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__12518 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__12518) : pred.call(null, G__12518);
        }())) {
          var G__12519 = result;
          var G__12520 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12519, G__12520) : rf.call(null, G__12519, G__12520);
        } else {
          return cljs.core.reduced(result);
        }
      };
      G__12523 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__12523__0.call(this);
          case 1:
            return G__12523__1.call(this, result);
          case 2:
            return G__12523__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__12523.cljs$core$IFn$_invoke$arity$0 = G__12523__0;
      G__12523.cljs$core$IFn$_invoke$arity$1 = G__12523__1;
      G__12523.cljs$core$IFn$_invoke$arity$2 = G__12523__2;
      return G__12523;
    }();
  };
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.truth_(function() {
        var G__12521 = cljs.core.first(s);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__12521) : pred.call(null, G__12521);
      }())) {
        return cljs.core.cons(cljs.core.first(s), cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = function cljs$core$mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp = cljs.core._comparator(sc);
    var G__12528 = function() {
      var G__12530 = cljs.core._entry_key(sc, e);
      var G__12531 = key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12530, G__12531) : comp.call(null, G__12530, G__12531);
    }();
    var G__12529 = 0;
    return test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__12528, G__12529) : test.call(null, G__12528, G__12529);
  };
};
cljs.core.subseq = function cljs$core$subseq() {
  var G__12533 = arguments.length;
  switch(G__12533) {
    case 3:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, true);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__12534 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12534, 0, null);
      var s = vec__12534;
      if (cljs.core.truth_(function() {
        var G__12535 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12535) : include.call(null, G__12535);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, true));
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, start_key, true);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__12536 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12536, 0, null);
    var s = vec__12536;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, start_test, start_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.subseq.cljs$lang$maxFixedArity = 5;
cljs.core.rsubseq = function cljs$core$rsubseq() {
  var G__12539 = arguments.length;
  switch(G__12539) {
    case 3:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_], true).call(null, test))) {
    var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, key, false);
    if (cljs.core.truth_(temp__4425__auto__)) {
      var vec__12540 = temp__4425__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12540, 0, null);
      var s = vec__12540;
      if (cljs.core.truth_(function() {
        var G__12541 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12541) : include.call(null, G__12541);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, false));
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4425__auto__ = cljs.core._sorted_seq_from(sc, end_key, false);
  if (cljs.core.truth_(temp__4425__auto__)) {
    var vec__12542 = temp__4425__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12542, 0, null);
    var s = vec__12542;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, end_test, end_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;
cljs.core.RangeIterator = function(i, end, step) {
  this.i = i;
  this.end = end;
  this.step = step;
};
cljs.core.RangeIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__.step > 0) {
    return self__.i < self__.end;
  } else {
    return self__.i > self__.end;
  }
};
cljs.core.RangeIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.i;
  self__.i = self__.i + self__.step;
  return ret;
};
cljs.core.RangeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "step", "step", -1365547645, null)], null);
};
cljs.core.RangeIterator.cljs$lang$type = true;
cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";
cljs.core.RangeIterator.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/RangeIterator");
};
cljs.core.__GT_RangeIterator = function cljs$core$__GT_RangeIterator(i, end, step) {
  return new cljs.core.RangeIterator(i, end, step);
};
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375006;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Range.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Range.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      return not_found;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIterable$ = true;
cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RangeIterator(self__.start, self__.end, self__.step);
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return self__.meta;
};
cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Range(self__.meta, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start + self__.step < self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  } else {
    if (self__.start + self__.step > self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core.not(cljs.core._seq(rng__$1))) {
    return 0;
  } else {
    var G__12544 = (self__.end - self__.start) / self__.step;
    return Math.ceil(G__12544);
  }
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  var h__4725__auto__ = self__.__hash;
  if (!(h__4725__auto__ == null)) {
    return h__4725__auto__;
  } else {
    var h__4725__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
    self__.__hash = h__4725__auto____$1;
    return h__4725__auto____$1;
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.equiv_sequential(rng__$1, other);
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1, f);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, init) {
  var self__ = this;
  var rng__$1 = this;
  var i = self__.start;
  var ret = init;
  while (true) {
    if (self__.step > 0 ? i < self__.end : i > self__.end) {
      var ret__$1 = function() {
        var G__12545 = ret;
        var G__12546 = i;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12545, G__12546) : f.call(null, G__12545, G__12546);
      }();
      if (cljs.core.reduced_QMARK_(ret__$1)) {
        var G__12547 = ret__$1;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12547) : cljs.core.deref.call(null, G__12547);
      } else {
        var G__12548 = i + self__.step;
        var G__12549 = ret__$1;
        i = G__12548;
        ret = G__12549;
        continue;
      }
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core._seq(rng__$1) == null) {
    return null;
  } else {
    return self__.start;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (!(cljs.core._seq(rng__$1) == null)) {
    return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start < self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  } else {
    if (self__.start > self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta__$1) {
  var self__ = this;
  var rng__$1 = this;
  return new cljs.core.Range(meta__$1, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.cons(o, rng__$1);
};
cljs.core.Range.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.Symbol(null, "step", "step", -1365547645, null), new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null)], null);
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";
cljs.core.Range.cljs$lang$ctorPrWriter = function(this__4888__auto__, writer__4889__auto__, opt__4890__auto__) {
  return cljs.core._write(writer__4889__auto__, "cljs.core/Range"