(ns de.levering-it.electric.three.dom
  (:require [hyperfiddle.electric3 :as e]
            [hyperfiddle.electric-dom3 :as dom]
            [hyperfiddle.electric.impl.runtime3 :as r]
            [hyperfiddle.electric-dom3-events :as events]
            [missionary.core :as m]
            [contrib.missionary-contrib :as mx]
            [de.levering-it.electric.three.bindings :as tbp]
            [de.levering-it.electric.three.utils :as tu]
            #?(:cljs ["three" :as three]))
  #?(:cljs (:require-macros [de.levering-it.electric.three.dom])))

#?(:cljs (defn with-listener
           ([n e f] (with-listener n e f nil))
           ([^js n e f o]
            (swap! (.-listeners n) update e #(if (nil? %) #{f} (conj % f)))
            #(swap! (.-listeners n)   update e (fn [x] (disj x f))))))

#?(:cljs
   (defn listen "Takes the same arguments as `addEventListener` and returns an uninitialized
  missionary flow that handles the listener's lifecycle producing `(f e)`.
  Relieves backpressure. `opts` can be a clojure map."
     ([node event-type] (listen node event-type identity))
     ([node event-type f] (listen node event-type f {}))
     ([node event-type f opts]
      (->> (m/observe (fn [!] (with-listener node event-type #(! (f %)) (clj->js opts))))
        (m/relieve {})))))

(e/defn On*
  #_([event-type f v]      (On* node event-type f v {}))
  #_([event-type f v opts] (On* node event-type f v opts))
  ([node event-type f v opts]
   (e/client
     (e/input (let [!v (m/mbx)]
                (r/do!
                  (!v v)     ; not just init-v, can be controlled v e.g. from db
                  (mx/mix (mx/poll-task !v) ; don't rebuild flow when v updates
                    (listen node event-type ((e/capture-fn) f) opts))))))))

(defmacro On
  ([event-type f v]      `(On tbp/node ~event-type ~f ~v {}))
  ([event-type f v opts] `(On tbp/node ~event-type ~f ~v ~opts))
  ([node event-type f v opts]
   `(let [v# ~v, opts# ~opts, e# ~event-type
          f# (e/client ~f)] ; auto-site f, a common gotcha when calling dom/On from site-neutral code
      ; f is unserializable, and called on client, so this is safe unless expr f is complex,
      ; e.g. a server sited factory building a client sited callback
      (e/client ; remove call latency when server sited
        (On* ~node e# f# v# opts#)))))

#?(:cljs
   (defn -not-ignore [i]
     (when-let [object (.-object i)]
       (not (true? (.-dom-transparent ^js object))))))

(defn -intersected [x y scene camera]
  #?(:cljs
     (let [pointer (three/Vector2.)
           caster (three/Raycaster.)]
       (set! (.-x pointer) x)
       (set! (.-y pointer) y)
       (.setFromCamera caster pointer camera)
       (when-let [i (first (filter -not-ignore (seq (.intersectObjects caster (.-children scene) true))))]
         (js->clj i)))))

#?(:cljs
   (do
     (defn -size [rect] [(.-width rect) (.-height rect)])
     (defn -pointer [e]
       (if (nil? (.-pointerLockElement js/document))
         (let [rect (.-target e)
               [width height] (-size rect)
               dx (.-offsetX e)
               dy (.-offsetY e)
               px (dec (* 2 (.-devicePixelRatio js/window) (/ dx width)))
               py (- (dec (* 2 (.-devicePixelRatio js/window) (/ dy height))))]
           [px py])
         [0 0]))

     (defn -call-event-stack [{^js obj :obj e :e data :data} typ]
       (let [listeners (deref (.. obj -listeners))]
         (dorun (map #(% {:obj obj :e e :data data}) (listeners typ)))
         (when-let [parent (.-parent obj)]
           (-call-event-stack {:obj parent :e e :data data} typ))))

     (defn -on-event [e scene camera typ]
       (let [[px py] (-pointer e)
             obj (-intersected px py scene camera)]
         (when obj
           (-call-event-stack {:obj (obj "object") :e e :data obj} typ))))

     (defn intersected [v x y scene camera]
       #?(:cljs
          (let [intersection  (-intersected x y scene camera)
                i-obj (get intersection "object")
                last-intersection @v
                l-obj (get last-intersection "object")]
            (do
              (vreset! v intersection)
              (if intersection
                (if (== i-obj l-obj)
                 [["pointermove" intersection]]
                  (if last-intersection
                    [[ "pointermove" intersection] ["pointerout" last-intersection] ["pointerenter" intersection]]
                    [["pointermove" intersection] ["pointerenter" intersection]]))
                (if last-intersection
                  [["pointerout" last-intersection]]
                  nil))))))

     (defn -on-event2 [v]
       (fn [e scene camera]
         (let [[px py] (-pointer e)
               obj (intersected v px py scene camera)]
           (dorun  (map (fn [[k v]]
                          (-call-event-stack {:obj (v "object") :e e :data v} k)) obj)))))))

(e/defn InitCallbacksystem [camera]
  (e/client
    (dom/On "click" (fn [e]
                      (-on-event e tbp/scene camera "click")) "")
    (let [v (volatile! nil)
          f (-on-event2 v)]
      (dom/On "pointerout" (fn [e]
                             (let [last-intersection @v]
                               (when last-intersection
                                 (vreset! v nil)
                                 (-call-event-stack {:obj (last-intersection "object") :e e :data v} "pointerout")))) "")
      (dom/On "pointermove" (fn [e]
                              (f e  tbp/scene camera )) ""))
    (e/amb)))

(e/defn Hovered? "Returns whether this DOM `node` is hovered over."
  []
  (e/client
    (e/input
      (->> (mx/mix
             (m/observe (fn [!] (with-listener tbp/node "pointerenter" (fn [e]
                                                                         (! true)))))
             (m/observe (fn [!] (with-listener tbp/node "pointerout" (fn [e]
                                                                       (! false))))))
        (m/reductions {} false)
        (m/relieve {})))))