(ns de.levering-it.electric.three.controls.orbit
  (:require [hyperfiddle.electric3 :as e]
            [missionary.core :as m]
            #?(:cljs ["three" :as three])
            [contrib.missionary-contrib :as mx]
            [hyperfiddle.electric-dom3 :as dom]
            [de.levering-it.electric.three.utils :as tu]
            [de.levering-it.electric.three.bindings :as tb]))


(defn clip
  "Round a number to n decimal places"
  ([x] (clip x 3))
  ([x n]
   (let [factor (Math/pow 10 n)]
     (/ (Math/round (* x factor)) factor))))

(comment
(clip 1.123454 )  )

#?(:cljs (defn -orbit-controls [^js camera target dx dy opts]
           (let [{rotateSpeed :rotateSpeed
                  :or {rotateSpeed 1}} opts
                 nx (* 2 Math/PI rotateSpeed dx  0.001)
                 ny (* 2 Math/PI rotateSpeed dy  0.001)
                 q (doto (three/Quaternion.)
                     (.setFromUnitVectors (.-up camera) (three/Vector3. 0 1 0)))

                 iq (doto (.clone q)
                      (.invert))

                 target (three/Vector3. (:x target) (:y target) (:z target))
                 v (doto (three/Vector3.)
                     (.copy (.-position camera))
                     (.sub target)
                     (.applyQuaternion q))
                 s (doto (three/Spherical.)
                     (.setFromVector3 v))
                 theta (.-theta s)
                 phi (.-phi s)]
             (set! (.-theta s) (- theta nx))
             (set! (.-phi s) (- phi ny))
             (.makeSafe s)

             (doto v
               (.setFromSpherical s)
               (.applyQuaternion iq)
               (.add target))
             (set! (.-x (.-position camera)) (.-x v))
             (set! (.-y (.-position camera)) (.-y v))
             (set! (.-z (.-position camera)) (.-z v))
             (.lookAt camera target)
             {:x (clip (.-x v)) :y (clip (.-y v))  :z (clip (.-z v)) :yaw (- theta nx) :pitch (- phi ny tu/deg90)})))

(e/defn OrbitControls
  "controls the camera. Makes camera always look at target. And pointer movement
  while pointer is down rotates the camera around the target."
  [camera target opts]
  (e/client
    (let [down? (tu/PointerDown?)
          [dx dy] (if down? (tu/RelMove) [0 0])]
      (-orbit-controls camera target dx dy opts))))
